/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.crl;

import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.CertificateStatus;
import esecurity.validator.x509status.RevocationBean;
import esecurity.validator.x509status.X509StatusValidator;
import esecurity.validator.x509status.crl.CRLCacheManager;
import esecurity.validator.x509status.crl.CRLUtils;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.vol.utils.I;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public class CRLX509StatusValidator
implements X509StatusValidator {
    private static final HashMap<String, ReentrantLock> a = new HashMap();
    private ValidatorConfig b;
    private Logger c;
    private CRLCacheManager d;
    private UrlClient e;
    private CertDB f;

    public CRLX509StatusValidator(ValidatorConfig validatorConfig, CRLCacheManager cRLCacheManager, Logger logger) throws CapiException {
        this.b = validatorConfig;
        this.c = logger;
        this.d = cRLCacheManager;
        this.f = validatorConfig.getCertDB();
        this.e = new UrlClient(validatorConfig.getNetConfiguration(), logger);
    }

    @Override
    public CertificateStatus checkStatus(Certificate object, ValidationDate validationDate) {
        this.c.debug(I.d() + "validateCertificate con CRL");
        CertificateStatus certificateStatus = new CertificateStatus();
        try {
            if (((Certificate)object).getSubjectDN().equalsIgnoreCase(((Certificate)object).getIssuerDN())) {
                this.c.debug(I.d() + "e' selfsigned: non fa la verifica CRL");
                certificateStatus.setCertValid(true);
                certificateStatus.setCrlStatus("NO_CHECK");
                object = certificateStatus;
                return object;
            }
            if (((Certificate)object).isRsVerified()) {
                this.c.debug(I.d() + "e' RsVerified");
                certificateStatus.setVerificationType("CRL");
                certificateStatus.setCertValid(true);
                certificateStatus.setCrlStatus("VERIFIED SIGNATURE");
                object = certificateStatus;
                return object;
            }
            certificateStatus.setVerificationType("CRL");
            object = this.a((Certificate)object, validationDate);
            if (object == null) {
                certificateStatus.setCertValid(false);
                certificateStatus.setInvalidityReason("Crl not found");
                certificateStatus.setCrlStatus("NOT FOUND");
                certificateStatus.setCertRevoked(false);
                certificateStatus.setCheckAnotherHelper(true);
                object = certificateStatus;
                return object;
            }
            if (((RevocationBean)object).getCertRevoked() && ((RevocationBean)object).getRevocationDate().before(validationDate.getDate())) {
                certificateStatus.setCertRevoked(true);
                certificateStatus.setCertValid(false);
                certificateStatus.setInvalidityReason(((RevocationBean)object).getInvalidityReason());
                certificateStatus.setRevocationDate(((RevocationBean)object).getRevocationDate());
                certificateStatus.setRevocationReason(((RevocationBean)object).getRevocationReason());
            }
            certificateStatus.setCrlBean(((RevocationBean)object).getCrlBean());
            certificateStatus.setCrlStatus(((RevocationBean)object).getCrlStatus());
        }
        catch (Exception exception) {
            certificateStatus.setCertValid(false);
            certificateStatus.setInvalidityReason(certificateStatus.getInvalidityReason() + exception.getMessage());
            certificateStatus.setCrlStatus("NOT FOUND");
            certificateStatus.setCheckAnotherHelper(true);
            this.c.error(I.d() + exception.getMessage());
        }
        finally {
            if (this.c.isDebugEnabled()) {
                this.c.debug("CRLX509StatusValidator result:");
                this.c.debug(certificateStatus.toString());
            }
        }
        return certificateStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevocationBean a(Certificate object, ValidationDate validationDate) throws CapiException {
        String string = CRLUtils.generateCrlId((Certificate)object);
        if (this.d.isCrlInCache(string)) {
            return this.d.checkRevocation((Certificate)object, validationDate);
        }
        ReentrantLock reentrantLock = null;
        try {
            Object object2;
            reentrantLock = a.get(string);
            if (reentrantLock == null) {
                object2 = a;
                synchronized (object2) {
                    reentrantLock = a.get(string);
                    if (reentrantLock == null) {
                        reentrantLock = new ReentrantLock();
                        a.put(string, reentrantLock);
                    }
                }
            }
            reentrantLock.lock();
            if (this.d.isCrlInCache(string)) {
                object2 = this.d.checkRevocation((Certificate)object, validationDate);
                return object2;
            }
            object2 = CRLUtils.getCrlForCertificate(this.e, this.b, (Certificate)object, validationDate.getDate(), this.f);
            if (object2 == null) {
                if (this.c.isDebugEnabled()) {
                    this.c.debug("CRL NULLA");
                }
                return null;
            }
            this.d.addCrlToCache(string, (CRL)object2);
            object = CRLUtils.a((CRL)object2, ((Certificate)object).getInternalCert().getSerialNumber(), validationDate);
        }
        finally {
            reentrantLock.unlock();
        }
        return object;
    }
}

