/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.dom;

import esecurity.desktop.DOMEvent;
import esecurity.desktop.JsUtils;
import esecurity.desktop.Listener;
import esecurity.desktop.View;
import esecurity.desktop.dom.Button;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.HTMLBlock;
import esecurity.desktop.dom.Table;
import esecurity.desktop.dom.TableBody;
import esecurity.desktop.dom.TableBodyCell;
import esecurity.desktop.dom.TableRow;
import esecurity.desktop.dom.TextInput;
import java.util.regex.Pattern;

public class Spinner
extends DOMElement {
    private Table spinner;
    private Button upButton;
    private Button downButton;
    private TextInput textInput;
    private String textPattern;
    private String text;
    private boolean mouseUp = false;

    public Spinner(String id, String parentId, View view, String textPattern) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createSpinner(id, parentId, view, textPattern);
    }

    public Spinner(String id, DOMElement parent, View view, String textPattern) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createSpinner(id, parent.getId(), view, textPattern);
    }

    private void createSpinner(String id, String parentId, View view, String textPattern) {
        this.textPattern = textPattern;
        this.spinner = new Table(id, parentId, view);
        this.spinner.addClass("spinner");
        TableBody spinnerBody = new TableBody("spinnerBody", id, view);
        TableRow<TableBodyCell<HTMLBlock>> spinnerRow = new TableRow<TableBodyCell<HTMLBlock>>("spinnerRow", spinnerBody, view);
        TableBodyCell<HTMLBlock> spinnerTextArea = new TableBodyCell<HTMLBlock>("spinnerTextArea", spinnerRow, view, () -> "");
        spinnerTextArea.addClass("spinnerTextArea");
        this.textInput = new TextInput("spinnerTextInput", spinnerTextArea, view);
        this.textInput.addClass("spinnerTextInput");
        this.textInput.onChange(evt -> {
            String t = this.textInput.getText();
            if (Pattern.matches(textPattern, t)) {
                this.text = t;
            } else {
                this.textInput.setText(this.text);
            }
        });
        TableBodyCell<HTMLBlock> spinnerButtonsArea = new TableBodyCell<HTMLBlock>("spinnerButtonsArea", spinnerRow, view, () -> "");
        spinnerButtonsArea.addClass("spinnerButtonsArea");
        this.upButton = new Button("spinnerUpButton", spinnerButtonsArea, view, () -> "&#x25B2;");
        this.downButton = new Button("spinnerDownButton", spinnerButtonsArea, view, () -> "&#x25BC;");
        spinnerRow.addCell(spinnerTextArea);
        spinnerRow.addCell(spinnerButtonsArea);
        spinnerBody.addRow(spinnerRow);
        this.spinner.setBody(spinnerBody);
        this.upButton.onMouseUp(evt -> {
            this.mouseUp = true;
        });
        this.downButton.onMouseUp(evt -> {
            this.mouseUp = true;
        });
    }

    public void onUpEvent(Listener listener) {
        this.upButton.addJavaEventListener(DOMEvent.MOUSEDOWN, evt -> new Thread(() -> {
            this.mouseUp = false;
            int loop = 0;
            int wait = 500;
            while (!this.mouseUp) {
                listener.notify(evt);
                try {
                    if (wait <= 0) continue;
                    wait = 500 - loop * 100;
                    ++loop;
                    Thread.sleep(wait);
                }
                catch (InterruptedException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }).start(), false);
    }

    public void onDownEvent(Listener listener) {
        this.downButton.addJavaEventListener(DOMEvent.MOUSEDOWN, evt -> new Thread(() -> {
            this.mouseUp = false;
            int loop = 0;
            int wait = 500;
            while (!this.mouseUp) {
                listener.notify(evt);
                try {
                    if (wait <= 0) continue;
                    wait = 500 - loop * 100;
                    ++loop;
                    Thread.sleep(wait);
                }
                catch (InterruptedException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }).start(), false);
    }

    public String getText() {
        this.text = this.textInput.getText();
        return this.text;
    }

    public void setText(String text) {
        if (this.textPattern != null && !this.textPattern.isEmpty()) {
            if (Pattern.matches(this.textPattern, text)) {
                this.textInput.setText(text);
                this.text = text;
            }
        } else {
            this.textInput.setText(text);
            this.text = text;
        }
    }
}

