/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.ldap;

public class LdapFilter {
    public static final int OP_EQUAL = 0;
    public static final int OP_NOT_EQUAL = 1;
    public static final int OP_CONTAIN = 2;
    public static final int OP_NOT_CONTAIN = 3;
    public static final int OP_END_WITH = 4;
    public static final int OP_START_WITH = 5;
    public static final int OP_LIKE = 6;
    public static final int OP_GTE = 7;
    public static final int OP_LTE = 8;
    public static final int AND = 0;
    public static final int OR = 1;
    private String filter = null;
    private String[] op1 = new String[]{"(", "(!(", "(", "(!(", "(", "(", "(", "(", "("};
    private String[] op2 = new String[]{"=", "=", "=*", "=*", "=*", "=", "~=", ">=", "<="};
    private String[] op3 = new String[]{")", "))", "*)", "*))", ")", "*)", ")", ")", ")"};

    public LdapFilter(int type) {
        this.filter = type == 0 ? "(& " : "(| ";
    }

    public void resetFilter(int type) {
        this.filter = type == 0 ? "(& " : "(| ";
    }

    public boolean addCondition(String attrName, int op, String attrValue) {
        try {
            this.filter = this.filter + this.op1[op] + attrName + this.op2[op] + attrValue + this.op3[op];
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getFilter() {
        String f = this.filter + ")";
        return f;
    }
}

