/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.arubasign.addsignature;

import esecurity.crypto.gui.functionality.SignatureFacade;
import esecurity.crypto.gui.model.DocumentsToValidate;
import esecurity.crypto.gui.model.FileToSign;
import esecurity.crypto.gui.signature.SignatureFormController;
import esecurity.crypto.gui.signature.models.FilesToSignHandler;
import esecurity.crypto.gui.utils.treeview.TreeItem;
import esecurity.crypto.gui.validation.addsignature.SignatureInterface;
import esecurity.crypto.gui.validation.panels.DocumentTreeElement;
import esecurity.desktop.dom.Tree;
import esecurity.desktop.dom.TreeNode;
import esecurity.desktop.observable.ObservableObject;
import esecurity.validator.bean.ValidatedDocument;
import esecurity.validator.bean.ValidatedSigner;
import esecurity.validator.constants.ContainerFormat;
import it.actalis.ellips.capi.datahandlers.inputs.FileHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.arubapec.arubasign.tabview.TabSection;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class SignatureAdditionAS
implements SignatureInterface {
    private static final EllipsLogger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private String selSignaturePath = "";
    private TabSection tabSection;
    private SignatureFormController sigController;
    private File inputFile;
    private final Runnable onCloseCallback = () -> {
        File outputFile = (File)FilesToSignHandler.getInstance().getList().get(0);
        this.tabSection.show("Verifica");
        if (this.inputFile != null && outputFile != null) {
            DocumentsToValidate.getInstance().replace((Object)this.inputFile, (Object)outputFile);
        }
        FilesToSignHandler.getInstance().clear();
        this.sigController.setOnCloseCallback(null);
        this.sigController.unlockDragAndDrop();
    };

    public SignatureAdditionAS(TabSection tabSection, SignatureFormController sigController) {
        this.tabSection = tabSection;
        this.sigController = sigController;
    }

    @Override
    public int addSignature(ObservableObject<DocumentTreeElement> selectedDocument, ObservableObject<TreeNode> selectedSignature, Tree ver_signaturesTree) {
        logger.info("Start add signature operation");
        ValidatedDocument doc = null;
        if (selectedDocument != null && selectedDocument.getValue() != null) {
            doc = ((DocumentTreeElement)selectedDocument.getValue()).getDocument();
        }
        if (doc == null) {
            logger.error("no document to sign selected");
            return -100;
        }
        logger.info("Selected document {}", (Object)doc.getShortName());
        int exitCode = 0;
        InputHandler hDoc = doc.getHandler();
        this.inputFile = null;
        if (hDoc instanceof FileHandler) {
            this.inputFile = ((FileHandler)hDoc).getFile();
        }
        return this.doSignatureOperation(doc, false, exitCode);
    }

    @Override
    public int addCounterSignature(ObservableObject<DocumentTreeElement> selectedDocument, ObservableObject<TreeNode> selectedSignature, Tree ver_signaturesTree) {
        logger.info("Start counter signature operation");
        ValidatedDocument doc = null;
        if (selectedDocument != null && selectedDocument.getValue() != null) {
            doc = ((DocumentTreeElement)selectedDocument.getValue()).getDocument();
        }
        if (doc == null) {
            logger.error("No document to sign selected");
            return -100;
        }
        logger.info("Selected document {}", (Object)doc.getShortName());
        int exitCode = 0;
        InputHandler hDoc = doc.getHandler();
        this.inputFile = null;
        if (hDoc instanceof FileHandler) {
            this.inputFile = ((FileHandler)hDoc).getFile();
        }
        if (selectedSignature.getValue() == null) {
            logger.error("no signature has been selected (for countersignature)");
            return -600;
        }
        ValidatedSigner signature = (ValidatedSigner)((TreeItem)((TreeNode)selectedSignature.getValue()).data).getData();
        logger.info("Selected signer {}", (Object)signature.getSignerName());
        AtomicInteger index = new AtomicInteger(0);
        ver_signaturesTree.getChildren().forEach(t -> {
            this.getSignatureTreePath(signature, (ValidatedSigner)((TreeItem)((TreeNode)ver_signaturesTree.getChildren().get((int)index.get())).data).getData(), "" + index);
            index.incrementAndGet();
        });
        return this.doSignatureOperation(doc, true, exitCode);
    }

    private boolean getSignatureTreePath(ValidatedSigner targetSignature, ValidatedSigner currentSignature, String curPath) {
        if (currentSignature == targetSignature) {
            this.selSignaturePath = curPath;
            return true;
        }
        for (int iSig = 0; iSig < currentSignature.getCounterSigners().size(); ++iSig) {
            String next = curPath + ":" + String.format("%d", iSig);
            if (!this.getSignatureTreePath(targetSignature, (ValidatedSigner)currentSignature.getCounterSigners().get(iSig), next)) continue;
            return true;
        }
        return false;
    }

    private int doSignatureOperation(ValidatedDocument doc, boolean isCounterSignature, int exitCode) {
        try {
            if (this.inputFile == null || !this.inputFile.exists()) {
                logger.error("File to sign not available");
                return -200;
            }
            if (!doc.isSigned()) {
                logger.error("Cannot add a signature to a not signed document");
                return -700;
            }
            SignatureFacade.SignatureType signFormat = SignatureFacade.SignatureType.CADES;
            if (null != ((ValidatedSigner)doc.getSigners().get(0)).getFormat()) {
                switch (((ValidatedSigner)doc.getSigners().get(0)).getFormat()) {
                    case CADES: {
                        signFormat = SignatureFacade.SignatureType.CADES;
                        break;
                    }
                    case PADES: {
                        signFormat = SignatureFacade.SignatureType.PADES;
                        break;
                    }
                    case XADES: {
                        signFormat = SignatureFacade.SignatureType.XADES;
                    }
                }
            }
            if (((ValidatedSigner)doc.getSigners().get(0)).getContainerFormat() == ContainerFormat.ASIC) {
                signFormat = SignatureFacade.SignatureType.ASICS;
            }
            logger.info("Selected signature format " + signFormat.getName());
            this.sigController.changeStatus(true);
            if (isCounterSignature) {
                this.sigController.setIsCounterSignature(true);
                logger.info("Counter signature path " + this.selSignaturePath);
                this.sigController.setRequestPath(this.selSignaturePath);
            } else {
                this.sigController.setIsAddSignature(true);
            }
            this.sigController.setPreselectedSignType(signFormat);
            this.sigController.setOnCloseCallback(this.onCloseCallback);
            this.sigController.lockDragAndDrop();
            this.tabSection.show("Firma");
            ArrayList<FileToSign> files = new ArrayList<FileToSign>();
            FileToSign file = new FileToSign(this.inputFile);
            file.setDestinationFileName(file.getName().substring(0, file.getName().lastIndexOf(".")));
            file.setDestinationFileExtension(file.getFileExtension());
            files.add(file);
            FilesToSignHandler.getInstance().reset(files);
        }
        catch (Exception ex) {
            logger.error("error adding signature to document: " + ex.getMessage());
            exitCode = -300;
        }
        return exitCode;
    }

    @Override
    public void undo() {
        this.sigController.recoverPanelFromExternalOperation();
        FilesToSignHandler.getInstance().clear();
        this.sigController.setOnCloseCallback(null);
        this.sigController.unlockDragAndDrop();
    }
}

