/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils.provider.apache;

import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

public class CapiSSLConnectionSocketFactory
extends SSLConnectionSocketFactory {
    private NetworkConfig config = null;

    public CapiSSLConnectionSocketFactory(SSLContext context, HostnameVerifier verifier, NetworkConfig config) {
        super(context, verifier);
        this.config = config;
    }

    public CapiSSLConnectionSocketFactory(SSLContext context, HostnameVerifier verifier) {
        super(context, verifier);
    }

    public CapiSSLConnectionSocketFactory(SSLContext sslContext) {
        super(sslContext);
    }

    public Socket createSocket(HttpContext context) throws IOException {
        Proxy proxy = null;
        if (this.config != null && (this.config.getProxy() != null && !this.config.getProxy().isEmpty() || this.config.getProxyPort() != null && !this.config.getProxyPort().isEmpty())) {
            InetSocketAddress addr = new InetSocketAddress(this.config.getProxy(), Integer.parseInt(this.config.getProxyPort()));
            proxy = new Proxy(this.getType(this.config.getProxyType()), addr);
        } else {
            proxy = Proxy.NO_PROXY;
        }
        return new Socket(proxy);
    }

    private Proxy.Type getType(String type) {
        if (type.startsWith("http")) {
            return Proxy.Type.HTTP;
        }
        if (type.startsWith("socks")) {
            return Proxy.Type.SOCKS;
        }
        return Proxy.Type.DIRECT;
    }
}

