/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.DateSource;
import esecurity.validator.ValidationDate;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class StepX509ValidationTime
extends MultipleValidationSubStepImpl {
    public StepX509ValidationTime() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> cloneable, ValidationContextParameters validationContextParameters) {
        cloneable = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        ((DateFormat)cloneable).setTimeZone(validationContextParameters.getTimeZone());
        cloneable = new LinkedList();
        if (validationContextParameters != null) {
            if (validationContextParameters.getSignerCertificate() != null) {
                if (validationContextParameters.getCalculatedValidationDate() == null) {
                    if (validationContextParameters.getValidationDate() == null) {
                        ValidationDate validationDate = new ValidationDate(new Date(), DateSource.SYSTEM);
                        validationContextParameters.setCalculatedValidationDate(validationDate);
                        ((LinkedList)cloneable).add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0011_CERT_VALIDATION_SYSTEM_DATE, validationContextParameters.getCalculatedValidationDate().getDate()));
                    } else {
                        ValidationDate validationDate = new ValidationDate(validationContextParameters.getValidationDate().getDate(), DateSource.CUSTOM);
                        validationContextParameters.setCalculatedValidationDate(validationDate);
                        ((LinkedList)cloneable).add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0012_CERT_VALIDATION_CUSTOM_DATE, validationContextParameters.getCalculatedValidationDate().getDate()));
                    }
                } else {
                    if (validationContextParameters.getCalculatedValidationDate().getDateSource() == DateSource.SYSTEM) {
                        ((LinkedList)cloneable).add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0011_CERT_VALIDATION_SYSTEM_DATE, validationContextParameters.getCalculatedValidationDate().getDate()));
                        ((LinkedList)cloneable).add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0016_CERT_VALIDATION, validationContextParameters.getSignature().getSignatureDate()));
                    }
                    if (validationContextParameters.getCalculatedValidationDate().getDateSource() == DateSource.CUSTOM) {
                        ((LinkedList)cloneable).add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0012_CERT_VALIDATION_CUSTOM_DATE, validationContextParameters.getCalculatedValidationDate().getDate()));
                    }
                    if (validationContextParameters.getCalculatedValidationDate().getDateSource() == DateSource.TIMESTAMP) {
                        ((LinkedList)cloneable).add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0013_CERT_VALIDATION_TIMESTAMP_DATE, validationContextParameters.getCalculatedValidationDate().getDate()));
                    }
                }
            } else {
                ((LinkedList)cloneable).add((ValidatorMessage)new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0008_NOSIGNERCERTIFICATE, new Object[0]));
            }
        } else {
            ((LinkedList)cloneable).add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
        }
        return cloneable;
    }
}

