/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.client;

import esecurity.dsd.core.ConfigurationMap;
import esecurity.dsd.core.LocalConfigurationProvider;
import esecurity.dsd.core.PropertyContainer;
import java.security.InvalidParameterException;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public class DomainConfigProvider
implements LocalConfigurationProvider {
    private String domain;
    private ConfigurationMap collection;
    private Set<String> defaultKeys;

    public static Builder setup(String domain) {
        return new Builder(domain);
    }

    protected DomainConfigProvider(Builder builder) {
        Builder b = Optional.ofNullable(builder).orElse(new Builder(""));
        if (b.domain == null) {
            throw new InvalidParameterException("Domain must be not null");
        }
        this.domain = new String(b.domain);
        this.collection = new ConfigurationMap(b.collection);
        this.defaultKeys = new LinkedHashSet<String>(b.defaultKeys);
    }

    public PropertyContainer getProvidedConfiguration() {
        return this.collection;
    }

    public Set<String> getDefaultProvidedKeys() {
        return this.defaultKeys;
    }

    public String getDomain() {
        return this.domain;
    }

    public Builder newBuilder() {
        Builder b = new Builder(this.domain);
        b.collection = (PropertyContainer)new ConfigurationMap((PropertyContainer)this.collection);
        b.defaultKeys = new LinkedHashSet<String>(this.defaultKeys);
        return b;
    }

    public static class Builder {
        private PropertyContainer collection;
        private Set<String> defaultKeys;
        private String domain;

        public Builder(String domain) {
            this.domain = domain;
            this.collection = new ConfigurationMap();
            this.defaultKeys = new LinkedHashSet<String>();
        }

        public Builder setValue(String key, Object value, boolean isLocalDefault) {
            this.collection.setValue(key, value);
            if (isLocalDefault) {
                this.defaultKeys.add(key);
            }
            return this;
        }

        public DomainConfigProvider build() {
            return new DomainConfigProvider(this);
        }
    }
}

