/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf;

import esecurity.dts.DTSClient;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.HttpsClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pades.CompareByteRangeSignature;
import it.actalis.ellips.capi.pades.PadesDssInfo;
import it.actalis.ellips.capi.pades.PadesUtils;
import it.actalis.ellips.capi.pdf.AdditionalDictionaryInfo;
import it.actalis.ellips.capi.pdf.AutenticaBinding;
import it.actalis.ellips.capi.pdf.CapiPDFApparence;
import it.actalis.ellips.capi.pdf.FeaInfo;
import it.actalis.ellips.capi.pdf.GraphometricInfo;
import it.actalis.ellips.capi.pdf.PadesSignatureInformation;
import it.actalis.ellips.capi.pdf.RevisionInformation;
import it.actalis.ellips.capi.pkcs7.StreamSignedEnvelope;
import it.actalis.ellips.util.File;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;

public class SignedPDF
implements SignatureInterface {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    protected PDDocument document = null;
    protected long documentSize = -1L;
    protected ArrayList<RevisionInformation> revisions = new ArrayList();
    protected Vector<String> names = new Vector();
    protected List<PadesSignatureInformation> signatures = new LinkedList<PadesSignatureInformation>();
    protected Vector<java.io.File> revisionsFileVector = new Vector();
    protected Vector<InputStream> revisionsIsVector = new Vector();
    private List<PadesSignatureInformation> b = new LinkedList<PadesSignatureInformation>();
    private boolean c = false;
    public static boolean bDebug = false;
    private String d = null;
    private static String e = "IT";
    private static String f = null;
    private static String g = null;
    private String h = null;
    private Calendar i = null;
    protected Vector<X509Certificate> certsVector = new Vector();
    private String j = null;
    private String k = null;
    private String l = null;
    private boolean m = true;
    private HttpsClient n = null;
    private String o = null;
    private String p = null;
    private DTSClient q = null;
    private java.io.File r = null;
    private int s = 0;
    private URL t = null;
    private byte[] u = null;
    private String v = null;
    private InputStream w;
    private boolean x = false;
    private boolean y = false;
    private int z = 2;
    private String A = null;
    private TokenSpi B = null;
    private boolean C = false;
    private boolean D = false;
    private ScratchFile E = null;
    private RandomAccessRead F;
    private boolean G = false;
    private PadesSignatureInformation H = null;
    private PadesDssInfo I = null;
    public static final String SHA1 = CMSSignedDataGenerator.DIGEST_SHA1;
    public static final String SHA256 = CMSSignedDataGenerator.DIGEST_SHA256;
    public static final int CERTIFIED_NO_CHANGES_ALLOWED = 1;
    public static final int CERTIFIED_SIGN_FORM_FILLING = 2;
    public static final int CERTIFIED_SIGN_FORM_FILLING_AND_ANNOTATIONS = 3;
    public static final int NOT_CERTIFIED = 0;
    public static final int CERTIFICATION_UNKNOWN = -1;
    public static final int PADES_BASIC = 1;
    public static final int PADES_BES = 2;

    public SignedPDF(String string) throws CapiException {
        this(string, null);
    }

    public SignedPDF(String string, boolean bl) throws CapiException {
        this(string, null, bl);
    }

    public SignedPDF(InputStream inputStream, boolean bl) throws CapiException {
        this(inputStream, null, bl);
    }

    public SignedPDF(String string, byte[] byArray) throws CapiException {
        this.v = string;
        this.a(byArray);
    }

    public SignedPDF(String string, byte[] byArray, boolean bl) throws CapiException {
        this.v = string;
        this.C = bl;
        this.a(byArray);
    }

    public SignedPDF(byte[] byArray) throws CapiException {
        this(byArray, null);
    }

    public SignedPDF(byte[] byArray, byte[] byArray2) throws CapiException {
        this.u = byArray;
        this.a(byArray2);
    }

    public SignedPDF(URL uRL) throws CapiException {
        this(uRL, null);
    }

    public SignedPDF(URL uRL, byte[] byArray) throws CapiException {
        this.t = uRL;
        this.a(byArray);
    }

    public SignedPDF(InputStream inputStream, byte[] byArray) throws CapiException {
        this.w = inputStream;
        this.a(byArray);
    }

    public SignedPDF(URL uRL, byte[] byArray, boolean bl) throws CapiException {
        this.t = uRL;
        this.C = bl;
        this.a(byArray);
    }

    public SignedPDF(InputStream inputStream, byte[] byArray, boolean bl) throws CapiException {
        if (inputStream instanceof ByteArrayInputStream) {
            try {
                inputStream.reset();
                this.u = Util.getBytesFromInputStream((InputStream)inputStream);
            }
            catch (IOException iOException) {
                try {
                    inputStream.reset();
                    this.w = inputStream;
                }
                catch (IOException iOException2) {
                    throw new CapiException("Internal Errore", 1003);
                }
            }
        } else {
            this.w = inputStream;
        }
        this.C = bl;
        this.a(byArray);
    }

    public SignedPDF(InputStream inputStream) throws CapiException {
        this(inputStream, null);
    }

    public static void setLanguage(String string) {
        if (string != null && string.equalsIgnoreCase("IT") || string.equalsIgnoreCase("EN") || string.equalsIgnoreCase("DE")) {
            e = string;
        }
    }

    public static void setLastCustomStamp(String string) {
        if (string != null) {
            f = string;
        }
    }

    public static String getLastCustomStamp() {
        return f;
    }

    public static void setDefaultStamp(String string) {
        if (string != null) {
            g = string;
        }
    }

    public void setPadesProfile(int n) {
        if (n == 1 || n == 2) {
            this.z = n;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void a(byte[] object4) throws CapiException {
        try {
            this.E = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
        }
        catch (IOException iOException) {
            a.error("Errore SCRATCH_FILE_TEMP", (Throwable)iOException);
        }
        Object object = this;
        try {
            MessageDigest.getInstance(Constants.SHA1, ProvUtils.bcProvider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("SHA1 Digest Algorithm not available", 50050);
        }
        try {
            MessageDigest.getInstance(Constants.SHA256, ProvUtils.bcProvider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("SHA256 Digest Algorithm not available", 50050);
        }
        object = null;
        if (object4 == null) {
            a.debug("[initialize] decrypting password is null...");
        } else {
            a.debug("[initialize] decrypting password is not null...");
            object = new String((byte[])object4);
        }
        this.document = null;
        try {
            long l;
            block45: {
                block47: {
                    InputStream inputStream;
                    block46: {
                        FileInputStream fileInputStream;
                        block44: {
                            l = System.currentTimeMillis();
                            a.debug("[initialize] loading document...");
                            if (this.u == null) break block44;
                            this.a(new ByteArrayInputStream(this.u), (String)object);
                            this.documentSize = this.u.length;
                            break block45;
                        }
                        if (this.v == null) break block46;
                        Closeable iOException = null;
                        try {
                            fileInputStream = new FileInputStream(this.v);
                            this.documentSize = fileInputStream.available();
                            this.a(fileInputStream, (String)object);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(iOException);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Closeable)fileInputStream);
                        break block45;
                    }
                    if (this.t == null) break block47;
                    Closeable i = null;
                    try {
                        inputStream = this.t.openStream();
                        this.documentSize = inputStream.available();
                        this.a(inputStream, (String)object);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(i);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)inputStream);
                    break block45;
                }
                if (this.w != null) {
                    this.r = TmpFileUtils.createTempFile((String)"PDFenv", null);
                    a.debug("[initialize]saving inputstream to ..." + this.r.getAbsolutePath());
                    SignedPDF.a(this.w, this.r, -1);
                    SignedPDF signedPDF = this;
                    LinkedList<PadesSignatureInformation> linkedList = object;
                    java.io.File file = signedPDF.r;
                    object = signedPDF;
                    signedPDF.F = new RandomAccessBufferedFileInputStream(file);
                    if (SignedPDF.a(((SignedPDF)object).F)) {
                        if (linkedList != null) {
                            PDFParser pDFParser = new PDFParser(((SignedPDF)object).F, (String)((Object)linkedList), null, null, ((SignedPDF)object).E);
                        } else {
                            PDFParser pDFParser = new PDFParser(((SignedPDF)object).F, ((SignedPDF)object).E);
                        }
                        try {
                            void var1_11;
                            ((SignedPDF)object).document = var1_11.parse();
                        }
                        catch (IOException iOException) {
                            IOUtils.closeQuietly((Closeable)((SignedPDF)object).F);
                            throw new a((SignedPDF)object, (String)((Object)linkedList), iOException);
                        }
                    } else {
                        throw new IOException("Input is not a PDF");
                    }
                    this.documentSize = this.r.length();
                }
            }
            a.debug("[initialize] document loaded in " + (System.currentTimeMillis() - l) + " ms");
            a.debug("canExtractForAccessibility() is " + this.document.getCurrentAccessPermission().canExtractForAccessibility());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.close();
            throw new CapiException("File not found", 4002);
        }
        catch (a a2) {
            this.close();
            throw new CapiException("Error load file (" + (a2.a.length() > 0 ? "with" : "without") + " password)", 4000);
        }
        catch (Exception exception) {
            this.close();
            throw new CapiException("Input is not a PDF", 50023);
        }
        try {
            void var1_25;
            Object object2;
            if (this.C) {
                List list = this.document.getDocumentCatalog().getOutputIntents();
                for (PDOutputIntent pDOutputIntent : list) {
                    if (pDOutputIntent.getInfo().contains("sRGB") || pDOutputIntent.getInfo().contains("Dot Gain")) continue;
                    throw new CapiException("PDFA OutputIntent not supported.", 50023);
                }
                for (PDOutputIntent pDOutputIntent : list) {
                    if (!pDOutputIntent.getInfo().contains("Dot Gain")) continue;
                    a.debug("OutputIntent{}", (Object)pDOutputIntent.getInfo());
                    this.D = true;
                    break;
                }
            }
            if ((object2 = this.document.getDocument().getTrailer()) == null) {
                a.error("[initialize] trailer is null.");
                return;
            }
            Object object3 = (COSDictionary)object2.getDictionaryObject(COSName.ROOT);
            if (object3 == null) {
                a.error("[initialize] root is null");
                return;
            }
            COSDictionary cOSDictionary = (COSDictionary)object3.getDictionaryObject(COSName.ACRO_FORM);
            if (cOSDictionary == null) {
                a.debug("[initialize] acroform is null");
                return;
            }
            this.I = PadesUtils.retrieveDssInfo(this.document);
            a.debug("[initialize] findSignature");
            object = PadesUtils.retrieveSignatures(this.document);
            object = ((AbstractSequentialList)object).iterator();
            while (object.hasNext()) {
                PadesSignatureInformation padesSignatureInformation = (PadesSignatureInformation)object.next();
                if (padesSignatureInformation.isEmpty()) {
                    this.b.add(padesSignatureInformation);
                    continue;
                }
                this.signatures.add(padesSignatureInformation);
            }
            a.debug("[initialize] findRevision ");
            this.c();
            this.checkRevisions();
            for (PadesSignatureInformation padesSignatureInformation : this.signatures) {
                object2 = this.a();
                object3 = DataHandlerBuilder.get().setInputStream((InputStream)object2).buildInput();
                try {
                    padesSignatureInformation.verify((InputHandler)object3);
                }
                catch (Error error) {
                    a.error("Impossibile parsare la firma: " + padesSignatureInformation.getName());
                }
                finally {
                    Util.closeQuietly((Closeable)object2);
                    Util.closeQuietly((Closeable)object3);
                }
            }
            object = new CompareByteRangeSignature();
            Collections.sort(this.signatures, object);
            boolean bl = false;
            while (var1_25 < this.signatures.size()) {
                object2 = this.signatures.get((int)var1_25);
                while (this.signatures.indexOf(object2) != this.signatures.lastIndexOf(object2)) {
                    this.signatures.remove(this.signatures.lastIndexOf(object2));
                }
                ++var1_25;
            }
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            this.close();
            throw new CapiException("Exception parsing PDF: " + exception.getMessage(), 50023);
        }
        if (this.signatures.isEmpty()) {
            a.debug("[initialize] pdf is not signed");
            return;
        }
        if (!this.signatures.isEmpty()) {
            this.H = this.signatures.get(this.signatures.size() - 1);
        }
        if (this.H == null) {
            a.error("[initialize] pdf is not signed");
            this.x = false;
            return;
        }
        this.x = true;
        this.y = true;
    }

    public boolean isInitialized() {
        return this.y;
    }

    @Deprecated
    public boolean getOriginalPDFbyEOF(java.io.File file) {
        return this.saveOriginalPDF(file);
    }

    public boolean saveOriginalPDF(java.io.File file) {
        return this.saveRevisionToFile(file, this.revisions.get(0));
    }

    public boolean saveRevisionToFile(java.io.File file, RevisionInformation revisionInformation) {
        if (!this.isInitialized() || file == null || revisionInformation == null) {
            return false;
        }
        if (this.signatures == null || this.signatures.isEmpty()) {
            return false;
        }
        if (file.exists()) {
            file.delete();
        }
        try {
            if (this.v != null) {
                SignedPDF signedPDF = this;
                signedPDF.a(signedPDF.v, file, revisionInformation.getByteRange()[1]);
            } else if (this.w != null && this.r.exists() && this.r.isFile()) {
                SignedPDF signedPDF = this;
                signedPDF.a(signedPDF.r, file, revisionInformation.getByteRange()[1]);
            } else if (this.t != null) {
                SignedPDF.a(this.t.openStream(), file, revisionInformation.getByteRange()[1]);
            } else if (this.u != null) {
                SignedPDF.a(new ByteArrayInputStream(this.u), file, revisionInformation.getByteRange()[1]);
            } else {
                throw new CapiException("Cannot get PDF Input File or URL", 1003);
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (CapiException capiException) {
            return false;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    private BufferedInputStream a() {
        try {
            BufferedInputStream bufferedInputStream;
            if (this.v != null) {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(new java.io.File(this.v)));
            } else if (this.w != null && this.r.exists()) {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(this.r));
            } else if (this.t != null) {
                bufferedInputStream = new BufferedInputStream(this.t.openStream());
            } else if (this.u != null) {
                bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(this.u));
            } else {
                throw new CapiException("Cannot get PDF Input File or URL", 1003);
            }
            return bufferedInputStream;
        }
        catch (Exception exception) {
            a.debug("Exception getting signed content: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    private static void a(InputStream inputStream, java.io.File object, int n) throws CapiException {
        FileOutputStream fileOutputStream = null;
        try {
            int n2;
            fileOutputStream = new FileOutputStream((java.io.File)object);
            if (n == -1) {
                Streams.pipeAll((InputStream)inputStream, (OutputStream)fileOutputStream);
                return;
            }
            object = new byte[4096];
            int n3 = 0;
            while ((n2 = inputStream.read((byte[])object, 0, 4096)) != -1) {
                if (n > (n3 += n2)) {
                    fileOutputStream.write((byte[])object, 0, n2);
                    continue;
                }
                if (n == n3) {
                    fileOutputStream.write((byte[])object, 0, n2);
                    break;
                }
                fileOutputStream.write((byte[])object, 0, n2 - (n3 - n));
                break;
            }
            return;
        }
        catch (IOException iOException) {
            a.debug(iOException.getMessage(), (Throwable)iOException);
            throw new CapiException("File write error", 4001);
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
            IOUtils.closeQuietly((Closeable)fileOutputStream);
        }
    }

    private void a(String string, java.io.File file, int n) throws CapiException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            SignedPDF.a(fileInputStream, file, n);
        }
        catch (IOException iOException) {
            try {
                a.debug(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("File write error", 4001);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fileInputStream);
        return;
    }

    private void a(java.io.File file, java.io.File file2, int n) throws CapiException {
        this.a(file.getAbsolutePath(), file2, n);
    }

    public InputStream getGraphometricRevisionInputStream(GraphometricInfo object) throws CapiException {
        try {
            object = ((GraphometricInfo)object).getByte_range();
            a.debug("[getRevisionInputStream] revByteRangeArray:");
            for (int i = 0; i < ((Object)object).length; ++i) {
                a.debug(" " + (long)object[i]);
            }
            File file = TmpFileUtils.createTempFile((String)"pdf_revision", (String)".tmp");
            a.debug("[getRevisionInputStream] saving revision to temporary file: " + file.getAbsolutePath());
            this.revisionsFileVector.add((java.io.File)file);
            if (this.v != null) {
                SignedPDF signedPDF = this;
                signedPDF.a(signedPDF.v, (java.io.File)file, (int)object[1]);
            } else if (this.w != null && this.r.exists() && this.r.isFile()) {
                SignedPDF signedPDF = this;
                signedPDF.a(signedPDF.r, (java.io.File)file, (int)object[1]);
            } else if (this.t != null) {
                SignedPDF.a(this.t.openStream(), (java.io.File)file, (int)object[1]);
            } else if (this.u != null) {
                SignedPDF.a(new ByteArrayInputStream(this.u), (java.io.File)file, (int)object[1]);
            } else {
                throw new CapiException("Cannot get PDF Input File or URL", 1003);
            }
            object = new FileInputStream((java.io.File)file);
            this.revisionsIsVector.add((InputStream)object);
            return object;
        }
        catch (Exception exception) {
            if (bDebug) {
                a.debug("[getRevisionInputStream] Exception getting revision input stream: " + exception.getMessage());
            }
            exception.printStackTrace();
            throw new CapiException("Exception getting revision input stream: " + exception.getMessage(), 50050);
        }
    }

    @Deprecated
    private InputStream a(RevisionInformation object) throws CapiException {
        try {
            File file = TmpFileUtils.createTempFile((String)"pdf_revision", (String)".tmp");
            a.debug("[getRevisionInputStream] saving revision to temporary file: " + file.getAbsolutePath());
            this.revisionsFileVector.add((java.io.File)file);
            if (!this.saveRevisionToFile((java.io.File)file, (RevisionInformation)object)) {
                throw new CapiException("File write error", 4001);
            }
            object = new FileInputStream((java.io.File)file);
            this.revisionsIsVector.add((InputStream)object);
            return object;
        }
        catch (CapiException capiException) {
            if (bDebug) {
                a.debug("[getRevisionInputStream] Exception getting revision input stream: " + capiException.getMessage());
                capiException.printStackTrace();
            }
            throw new CapiException("Exception getting revision input stream: " + capiException.getMessage(), 50050);
        }
        catch (IOException iOException) {
            if (bDebug) {
                a.debug("[getRevisionInputStream] Exception getting revision input stream: " + iOException.getMessage());
                iOException.printStackTrace();
            }
            throw new CapiException("Exception getting revision input stream: " + iOException.getMessage(), 50050);
        }
    }

    @Deprecated
    public boolean hasPreviousSignatureRevisions() throws CapiException {
        if (this.H == null) {
            return false;
        }
        RevisionInformation revisionInformation = this.H.getRevision();
        while (revisionInformation.getPreviusRevision() != null) {
            if (revisionInformation.getSignatures().size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public int getCertificationLevel() throws CapiException {
        if (this.signatures.size() == 0) {
            return -1;
        }
        return this.signatures.get(this.signatures.size() - 1).getCertificationLevel();
    }

    public int getCertificationLevel(int n) throws CapiException {
        if (n < 0 || n >= this.signatures.size()) {
            return -1;
        }
        return this.signatures.get(n).getCertificationLevel();
    }

    @Deprecated
    public InputStream[] getPreviousSignatureRevisions() throws CapiException {
        Object object;
        this.b();
        if (!this.hasPreviousSignatureRevisions()) {
            return null;
        }
        Vector<InputStream[]> vector = new Vector<InputStream[]>();
        if (this.H != null && this.H.getRevision().getPreviusRevision() != null) {
            SignedPDF signedPDF = this;
            object = signedPDF.a(signedPDF.H.getRevision().getPreviusRevision());
            vector.add((InputStream[])object);
        }
        object = new InputStream[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            object[i] = (InputStream)vector.elementAt(i);
        }
        return object;
    }

    @Deprecated
    public InputStream getPreviousSignatureRevision(String object) throws CapiException {
        this.b();
        if (!this.hasPreviousSignatureRevisions() || this.H.getName().equals(object)) {
            return null;
        }
        for (int i = this.signatures.size() - 2; i >= 0; --i) {
            String string = this.signatures.get(i).getName();
            if (!string.equals(object) || this.signatures.get(i).getRevision() == null) continue;
            SignedPDF signedPDF = this;
            object = signedPDF.a(signedPDF.signatures.get(i).getRevision());
            return object;
        }
        return null;
    }

    public String[] getBlankSignatureNames() throws CapiException {
        this.b();
        String[] stringArray = new String[this.b.size()];
        for (int i = 0; i < this.b.size(); ++i) {
            PDSignatureField pDSignatureField = this.b.get(i).a();
            pDSignatureField = (COSString)pDSignatureField.getCOSObject().getDictionaryObject(COSName.T);
            String string = "";
            if (pDSignatureField != null && pDSignatureField.getString() != null) {
                string = pDSignatureField.getString();
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    @Deprecated
    public String[] getPreviousSignatureRevisionNames() throws CapiException {
        this.b();
        if (!this.hasPreviousSignatureRevisions()) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = this.signatures.size() - 2; i >= 0; --i) {
            String string = this.signatures.get(i).getName();
            if (string == null || string == this.H.getName()) continue;
            vector.add(string);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public void setDigestAlg(String string) throws CapiException {
        if (bDebug) {
            a.debug("[setDigestAlg] Setting digest algorithm ...");
        }
        if (string == null) {
            throw new CapiException("Null data", 1001);
        }
        if (string.compareToIgnoreCase(SHA1) == 0) {
            if (bDebug) {
                a.debug("[setDigestAlg] set SHA1 digest");
            }
            return;
        }
        if (string.compareToIgnoreCase(SHA256) == 0) {
            if (bDebug) {
                a.debug("[setDigestAlg] set SHA256 digest ");
            }
            return;
        }
        throw new CapiException("Invalid digest algorithm", 1002);
    }

    public void setSignatureTimeStampParams(String string, String string2, String string3, boolean bl, HttpsClient httpsClient) throws CapiException {
        if (string == null || string2 == null || httpsClient == null) {
            throw new CapiException("Null data", 1001);
        }
        if (string2.compareToIgnoreCase("SHA-1") != 0 && string2.compareToIgnoreCase("SHA-256") != 0 && string2.compareToIgnoreCase("MD5") != 0) {
            throw new CapiException("Invalid hash Algorithm", 1002);
        }
        this.j = string;
        this.k = string2;
        this.l = string3;
        this.m = bl;
        this.n = httpsClient;
        if (bDebug) {
            a.debug("[setSignatureTimeStampParams] done.");
        }
    }

    public void setSignatureTimeStampParams(String string, String string2, String string3, boolean bl, String string4, String string5) throws CapiException {
        if (string == null || string2 == null) {
            throw new CapiException("Null data", 1001);
        }
        if (string2.compareToIgnoreCase("SHA-1") != 0 && string2.compareToIgnoreCase("SHA-256") != 0 && string2.compareToIgnoreCase("MD5") != 0) {
            throw new CapiException("Invalid hash Algorithm", 1002);
        }
        this.j = string;
        this.k = string2;
        this.l = string3;
        this.m = bl;
        this.o = string4;
        this.p = string5;
        if (bDebug) {
            a.debug("[setSignatureTimeStampParams] done.");
        }
    }

    public void setSignatureTimeStampParams(String string, String string2, boolean bl, DTSClient dTSClient) throws CapiException {
        if (dTSClient == null) {
            throw new CapiException("Null DTSClient", 1001);
        }
        this.k = string;
        this.l = string2;
        this.m = bl;
        this.q = dTSClient;
        this.j = "TSCLIENT";
        if (bDebug) {
            a.debug("[setSignatureTimeStampParams DTSClient] done.");
        }
    }

    public void addVisualRenderedCertificationSignature(String string, String string2, int n, OutputStream outputStream, int n2) throws CapiException {
        this.a(n2);
        this.addVisualRenderedSignatureRevision(string, string2, n, outputStream);
    }

    public void addVisualRenderedSignatureRevision(String string, String string2, int n, OutputStream outputStream) throws CapiException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        block37: {
            block36: {
                object5 = null;
                object4 = null;
                try {
                    if (this.v != null) {
                        object5 = this.v;
                        break block36;
                    }
                    if (this.r != null && this.r.exists()) {
                        object5 = this.r.getAbsolutePath();
                        break block36;
                    }
                    if (this.t != null) {
                        object4 = this.t;
                        break block36;
                    }
                    if (this.u != null) {
                        this.r = object3 = TmpFileUtils.createTempFile((String)"PDFenv", null);
                        object2 = new FileOutputStream((java.io.File)object3);
                        ((FileOutputStream)object2).write(this.u, 0, this.u.length);
                        if (bDebug) {
                            a.debug("bytearray saved in: " + ((java.io.File)object3).getAbsolutePath());
                        }
                        object5 = this.r.getAbsolutePath();
                        break block36;
                    }
                    throw new CapiException("Cannot get PDF Input File or URL", 1003);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                    throw new CapiException("Exception " + exception2.getMessage(), 1003);
                }
            }
            try {
                object3 = SignedPDF.class.getClassLoader();
                object2 = ((ClassLoader)object3).loadClass("arubasign.pdf.PDFViewer");
                object = ((Class)object2).newInstance();
                ((ClassLoader)object3).loadClass("arubasign.pdf.PDFSignApparence");
                if (bDebug) {
                    a.debug("arubasign.pdf.PDFSignApparence loaded");
                }
                if (object5 != null) {
                    if (bDebug) {
                        a.debug("call setLan...");
                    }
                    object3 = ((Class)object2).getMethod("setLan", String.class);
                    ((Method)object3).invoke(object, e);
                    if (g != null) {
                        if (bDebug) {
                            a.debug("call defaultStamp...");
                        }
                        object3 = ((Class)object2).getMethod("setDefaultStamp", String.class);
                        ((Method)object3).invoke(object, g);
                    }
                    if (f != null) {
                        if (bDebug) {
                            a.debug("call lastCustomStamp...");
                        }
                        object3 = ((Class)object2).getMethod("setLastCustomStamp", String.class);
                        ((Method)object3).invoke(object, f);
                    }
                    if (bDebug) {
                        a.debug("call checkApparence...");
                    }
                    object3 = ((Class)object2).getMethod("checkApparence", String.class, String.class, String.class);
                    object5 = ((Method)object3).invoke(object, object5, this.d, this.h);
                    break block37;
                }
                if (object4 != null) {
                    object3 = ((Class)object2).getMethod("checkApparence", URL.class, String.class, String.class);
                    object5 = ((Method)object3).invoke(object, object4, this.d, this.h);
                    break block37;
                }
                throw new CapiException("No PDF Input File or URL", 1003);
            }
            catch (ClassNotFoundException classNotFoundException) {
                object3 = classNotFoundException;
                classNotFoundException.printStackTrace();
                throw new CapiException("ClassNotFoundException: arubasign.pdf.PDFViewer", 1003);
            }
            catch (Exception exception) {
                object3 = exception;
                exception.printStackTrace();
                throw new CapiException("Exception: " + ((Throwable)object3).getMessage(), 1003);
            }
        }
        if (object5 != null) {
            try {
                if (bDebug) {
                    a.debug("objAppearance is not null");
                }
                object3 = object5.getClass().getMethod("getPage", new Class[0]);
                object2 = (Integer)((Method)object3).invoke(object5, new Object[0]);
                if (bDebug) {
                    a.debug("page= " + (Integer)object2);
                }
                object = object5.getClass().getMethod("getReason", new Class[0]);
                object4 = (String)((Method)object).invoke(object5, new Object[0]);
                if (bDebug) {
                    a.debug("reason= " + (String)object4);
                }
                object3 = object5.getClass().getMethod("getLocation", new Class[0]);
                object3 = (String)((Method)object3).invoke(object5, new Object[0]);
                if (bDebug) {
                    a.debug("location= " + (String)object3);
                }
                this.setSignatureReason((String)object4);
                this.setSignatureLocation((String)object3);
                object4 = object5.getClass().getMethod("getImage", new Class[0]);
                object4 = (BufferedImage)((Method)object4).invoke(object5, new Object[0]);
                object3 = object5.getClass().getMethod("getCustomImagePath", new Class[0]);
                object3 = (String)((Method)object3).invoke(object5, new Object[0]);
                if (bDebug) {
                    a.debug("customImagePath= " + (String)object3);
                }
                if (object3 != null) {
                    f = object3;
                }
                object3 = object5.getClass().getMethod("getLeftx", new Class[0]);
                object3 = (Integer)((Method)object3).invoke(object5, new Object[0]);
                if (bDebug) {
                    a.debug("leftx= " + (Integer)object3);
                }
                object = object5.getClass().getMethod("getLefty", new Class[0]);
                object = (Integer)((Method)object).invoke(object5, new Object[0]);
                if (bDebug) {
                    a.debug("lefty= " + (Integer)object);
                }
                Object object6 = object5.getClass().getMethod("getRightx", new Class[0]);
                object6 = (Integer)((Method)object6).invoke(object5, new Object[0]);
                if (bDebug) {
                    a.debug("rightx= " + (Integer)object6);
                }
                Object object7 = object5.getClass().getMethod("getRighty", new Class[0]);
                object5 = (Integer)((Method)object7).invoke(object5, new Object[0]);
                if (bDebug) {
                    a.debug("righty= " + (Integer)object5);
                }
                object7 = "Signature_" + new Long(System.currentTimeMillis()).intValue();
                this.addSignatureRevision(string, outputStream, (String)object7, (Integer)object2, ((Integer)object3).intValue(), ((Integer)object5).intValue(), (Integer)object6 - (Integer)object3, (Integer)object5 - (Integer)object, (BufferedImage)object4, string2, n);
                if (bDebug) {
                    a.debug("visible signature added.");
                }
                return;
            }
            catch (CapiException capiException) {
                object3 = capiException;
                capiException.printStackTrace();
                throw object3;
            }
            catch (Exception exception) {
                object3 = exception;
                exception.printStackTrace();
                throw new CapiException("Exception: " + ((Throwable)object3).getMessage(), 1003);
            }
        }
        if (bDebug) {
            a.debug("objAppearance is null");
        }
        this.addSignatureRevision(string, outputStream, null);
        if (bDebug) {
            a.debug("invisible signature added.");
        }
    }

    public void addSignatureRevision(String string, OutputStream outputStream) throws CapiException {
        this.addSignatureRevision(string, outputStream, null);
    }

    public void addSignatureRevision(String string, OutputStream outputStream, String string2) throws CapiException {
        this.addSignatureRevision(false, string, outputStream, string2, 0, 0.0f, 0.0f, 0.0f, 0.0f, null, null, 0);
    }

    public void addSignatureRevision(String string, OutputStream outputStream, String string2, int n, float f, float f2, float f3, float f4) throws CapiException {
        this.addSignatureRevision(true, string, outputStream, string2, n, f, f2, f3, f4, null, null, 0);
    }

    public void addSignatureRevision(String string, OutputStream outputStream, String string2, int n, float f, float f2, float f3, float f4, BufferedImage bufferedImage, String string3, int n2) throws CapiException {
        this.addSignatureRevision(true, string, outputStream, string2, n, f, f2, f3, f4, bufferedImage, string3, n2);
    }

    public void addSignatureRevision(TokenSpi tokenSpi, boolean bl, String string, OutputStream outputStream, String string2, int n, float f, float f2, float f3, float f4, BufferedImage bufferedImage, String string3, int n2) throws CapiException {
        CapiPDFApparence capiPDFApparence = null;
        if (bl) {
            capiPDFApparence = new CapiPDFApparence();
            capiPDFApparence.setPage(n);
            capiPDFApparence.setImage(bufferedImage);
            capiPDFApparence.setPosX(f);
            capiPDFApparence.setPosY(f2);
            capiPDFApparence.setWidth(f3);
            capiPDFApparence.setHeight(f4);
            capiPDFApparence.setFontSize(n2);
            capiPDFApparence.setVisibleLabel(string3);
        }
        this.addSignatureRevision(tokenSpi, string, outputStream, string2, capiPDFApparence, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addSignatureRevision(TokenSpi object, String object2, OutputStream outputStream, String string, CapiPDFApparence capiPDFApparence, AdditionalDictionaryInfo additionalDictionaryInfo) throws CapiException {
        Object object3;
        IOException iOException;
        COSDictionary cOSDictionary2222222;
        Object object4;
        Object object5;
        File file;
        this.G = true;
        if ((this.signatures != null && this.signatures.size() == 0 || capiPDFApparence != null) && this.document.getDocumentCatalog().getAcroForm() != null && this.document.getDocumentCatalog().getAcroForm().getNeedAppearances()) {
            this.document.getDocumentCatalog().getAcroForm().getCOSObject().removeItem(COSName.NEED_APPEARANCES);
        }
        String string2 = null;
        String string3 = null;
        try {
            file = object;
            object5 = this;
            this.B = file;
            if (bDebug) {
                a.debug("[addSigner] getting credential from token...");
            }
            object4 = new Certificate(object.getCert((String)object2).getBytes());
            this.addSignatureCertificate(Util.getBytes((String)object.getCert((String)object2)));
            if (bDebug) {
                a.debug("...cert ok");
            }
            object.getPrivateKey((String)object2);
            if (bDebug) {
                a.debug("[addSigner] getting credential from token ok");
            }
            if ((object = object4.getName()) != null) {
                object = ((String)object).toUpperCase();
            }
            if ((object5 = object4.getSubjectDNAttribute("organization")) != null && ((String[])object5).length > 0) {
                string2 = object5[0].toUpperCase();
            }
            if ((file = object4.getSubjectDNAttribute("title")) != null && ((String[])file).length > 0) {
                string3 = file[0];
            }
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
        file = object2;
        object5 = this;
        this.A = file;
        a.debug("Adding signer...");
        object5 = null;
        file = null;
        try {
            file = TmpFileUtils.createTempFile((String)"pdf_signed", (String)".tmp");
            object5 = new BufferedOutputStream(new FileOutputStream((java.io.File)file));
        }
        catch (IOException iOException2) {
            a.debug(iOException2.getMessage(), (Throwable)iOException2);
        }
        object2 = new PDSignature();
        object2.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        object2.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        object2.setName(object4.getName());
        if (this.d != null) {
            object2.setReason(this.d);
        }
        if (this.h != null) {
            object2.setLocation(this.h);
        }
        if (this.z == 2) {
            object2.setSubFilter(PDSignature.SUBFILTER_ETSI_CADES_DETACHED);
        }
        if (this.i != null) {
            object2.setSignDate(this.i);
        } else {
            object2.setSignDate(Calendar.getInstance());
        }
        if (additionalDictionaryInfo != null) {
            if (additionalDictionaryInfo instanceof GraphometricInfo) {
                object4 = new long[]{0L, this.documentSize};
                cOSDictionary2222222 = additionalDictionaryInfo.getDictionary((long[])object4);
                object2.getCOSObject().setItem("biometric_data", (COSBase)cOSDictionary2222222);
            } else if (additionalDictionaryInfo instanceof AutenticaBinding) {
                object2.getCOSObject().setItem("binding_dictionary", (COSBase)additionalDictionaryInfo.getDictionary());
            } else if (additionalDictionaryInfo instanceof FeaInfo) {
                object4 = new long[]{0L, this.documentSize};
                cOSDictionary2222222 = additionalDictionaryInfo.getDictionary((long[])object4);
                object2.getCOSObject().setItem("fea_dictionary", (COSBase)cOSDictionary2222222);
            } else {
                for (COSDictionary cOSDictionary2222222 : additionalDictionaryInfo.getDictionary().keySet()) {
                    iOException = additionalDictionaryInfo.getDictionary().getItem((COSName)cOSDictionary2222222);
                    object2.getCOSObject().setItem((COSName)cOSDictionary2222222, (COSBase)iOException);
                }
            }
        }
        if (this.s != 0) {
            object4 = new COSDictionary();
            object4.setItem(COSName.getPDFName((String)"Type"), (COSBase)COSName.getPDFName((String)"SigRef"));
            object4.setItem(COSName.getPDFName((String)"TransformMethod"), (COSBase)COSName.getPDFName((String)"DocMDP"));
            cOSDictionary2222222 = new COSDictionary();
            cOSDictionary2222222.setItem(COSName.getPDFName((String)"Type"), (COSBase)COSName.getPDFName((String)"TransformParams"));
            cOSDictionary2222222.setItem(COSName.getPDFName((String)"V"), (COSBase)COSName.getPDFName((String)"1.2"));
            cOSDictionary2222222.setInt("P", this.s);
            cOSDictionary2222222.setDirect(true);
            object4.setItem(COSName.getPDFName((String)"TransformParams"), (COSBase)cOSDictionary2222222);
            object4.setDirect(true);
            iOException = new COSArray();
            iOException.add((COSBase)object4);
            iOException.setDirect(true);
            object2.getCOSObject().setItem(COSName.getPDFName((String)"Reference"), (COSBase)iOException);
        }
        if (capiPDFApparence != null) {
            capiPDFApparence.setName((String)object);
            capiPDFApparence.setOrganization(string2);
            capiPDFApparence.setTitle(string3);
            capiPDFApparence.setFieldName(string);
            capiPDFApparence.setPDFASignature(this.C);
            capiPDFApparence.setGray(this.D);
            capiPDFApparence.setSigningTimeCal(this.i);
            capiPDFApparence.setLocation(this.h);
            capiPDFApparence.setReason(this.d);
            capiPDFApparence.setPdDocument(this.document);
        } else if (string != null) {
            for (int i = 0; i < this.b.size(); ++i) {
                object4 = this.b.get(i).a();
                iOException = (COSString)object4.getCOSObject().getDictionaryObject(COSName.T);
                object3 = "";
                if (iOException != null && iOException.getString() != null) {
                    object3 = iOException.getString();
                }
                if (!string.equalsIgnoreCase((String)object3)) continue;
                if (bDebug) {
                    a.debug("[addSigner] found emptySignatureFields to fill ");
                }
                try {
                    object4.getCOSObject().setNeedToBeUpdated(true);
                    if (object4.getWidgets().size() > 0) {
                        if (((PDAnnotationWidget)object4.getWidgets().get(0)).getRectangle() != null) {
                            if (((PDAnnotationWidget)object4.getWidgets().get(0)).getRectangle().getWidth() != 0.0f || ((PDAnnotationWidget)object4.getWidgets().get(0)).getRectangle().getHeight() != 0.0f) {
                                object4.getCOSObject().setItem(COSName.V, (COSObjectable)object2);
                                capiPDFApparence = new CapiPDFApparence();
                                capiPDFApparence.setPosX(((PDAnnotationWidget)object4.getWidgets().get(0)).getRectangle().getLowerLeftX());
                                capiPDFApparence.setPosY(((PDAnnotationWidget)object4.getWidgets().get(0)).getRectangle().getUpperRightY());
                                capiPDFApparence.setWidth(((PDAnnotationWidget)object4.getWidgets().get(0)).getRectangle().getWidth());
                                capiPDFApparence.setHeight(((PDAnnotationWidget)object4.getWidgets().get(0)).getRectangle().getHeight());
                                capiPDFApparence.setPage(this.document.getPages().indexOf(((PDAnnotationWidget)object4.getWidgets().get(0)).getPage()) + 1);
                                capiPDFApparence.setVisibleLabel(String.format("Signed by %s", object));
                                capiPDFApparence.setScaleFont(true);
                                capiPDFApparence.setPDFASignature(this.C);
                                capiPDFApparence.setGray(this.D);
                                capiPDFApparence.setSigningTimeCal(this.i);
                                capiPDFApparence.setLocation(this.h);
                                capiPDFApparence.setReason(this.d);
                                capiPDFApparence.setPdDocument(this.document);
                                break;
                            }
                            object4.setValue((PDSignature)object2);
                            break;
                        }
                        object4.setValue((PDSignature)object2);
                        break;
                    }
                    object4.setValue((PDSignature)object2);
                }
                catch (IOException iOException3) {
                    a.debug(iOException3.getMessage(), (Throwable)iOException3);
                }
                break;
            }
        }
        object4 = PadesUtils.getPDVisibleSigProperties(capiPDFApparence);
        SignatureOptions signatureOptions = null;
        try {
            if (object4 != null && object4.isVisualSignEnabled()) {
                a.debug("Adding visible Signature ....");
                signatureOptions = new SignatureOptions();
                signatureOptions.setVisualSignature((PDVisibleSigProperties)object4);
                signatureOptions.setPage(capiPDFApparence.getPage() - 1);
                this.document.addSignature((PDSignature)object2, (SignatureInterface)this, signatureOptions);
            } else {
                a.debug("Adding invisible Signature ....");
                this.document.addSignature((PDSignature)object2, (SignatureInterface)this);
            }
            long l = System.currentTimeMillis();
            a.debug("[saveIncremental] saving document...");
            object = (COSArray)this.document.getDocumentCatalog().getAcroForm().getCOSObject().getDictionaryObject(COSName.FIELDS);
            object.setNeedToBeUpdated(true);
            this.document.saveIncremental((OutputStream)object5);
            a.debug("[saveIncremental] document saved in " + (System.currentTimeMillis() - l) + " ms");
            if (this.G) {
                IOUtils.closeQuietly((Closeable)object5);
                object5 = null;
                if (file.exists()) {
                    file.delete();
                }
                throw new CapiException("Firma PDF non Eseguita", 50001);
            }
        }
        catch (IOException iOException4) {
            iOException = iOException4;
            if (iOException4.getCause() != null && iOException.getCause() instanceof CapiException) {
                if (file != null && file.exists()) {
                    file.delete();
                }
                throw (CapiException)iOException.getCause();
            }
            a.error(iOException.getMessage(), (Throwable)iOException);
            throw new CapiException("Internal error", 50050);
        }
        catch (Throwable throwable) {
            a.error(throwable.getMessage(), throwable);
            throw new CapiException("Internal error", 50050);
        }
        finally {
            IOUtils.closeQuietly((Closeable)object5);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream((java.io.File)file);
            Streams.pipeAll((InputStream)fileInputStream, (OutputStream)outputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                a.debug(fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
                throw new CapiException("Internal error", 50050);
                catch (Exception exception) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("Internal error", 50050);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                try {
                    if (file != null && file.exists()) {
                        file.delete();
                    }
                }
                catch (Exception exception) {
                    object2 = exception;
                    exception.printStackTrace();
                }
                try {
                    this.close();
                }
                catch (Exception exception) {
                    object2 = exception;
                    exception.printStackTrace();
                }
                Util.closeQuietly((Closeable)signatureOptions);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fileInputStream);
        try {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            object3 = exception;
            exception.printStackTrace();
        }
        try {
            this.close();
        }
        catch (Exception exception) {
            object3 = exception;
            exception.printStackTrace();
        }
        Util.closeQuietly((Closeable)signatureOptions);
        a.debug("PDF Signature done");
    }

    public void addSignatureRevision(boolean bl, String string, OutputStream outputStream, String string2, int n, float f, float f2, float f3, float f4, BufferedImage bufferedImage, String string3, int n2) throws CapiException {
        if (bl && string2 == null) {
            throw new CapiException("Null fieldName", 1001);
        }
        this.b();
        if (this.H != null && this.H.getCertificationLevel() == 1) {
            if (bDebug) {
                a.debug("Document certified and no changes allowed");
            }
            throw new CapiException("Document is certified and no changes are allowed.", 50026);
        }
        TokenSpi tokenSpi = ProvUtils.retrieveTokenByAlias((String)string);
        this.addSignatureRevision(tokenSpi, bl, string, outputStream, string2, n, f, f2, f3, f4, bufferedImage, string3, n2);
    }

    @Deprecated
    public GraphometricInfo getGraphometricInfo() {
        if (this.H != null) {
            return this.H.getGraphometricInfo();
        }
        return null;
    }

    public GraphometricInfo getGraphometricInfo(int n) {
        return this.signatures.get(n).getGraphometricInfo();
    }

    public byte[] sign(InputStream object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            Date date;
            StreamSignedEnvelope streamSignedEnvelope = new StreamSignedEnvelope(2);
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (this.j != null) {
                if (this.j.toLowerCase().startsWith("http")) {
                    if (this.n != null) {
                        streamSignedEnvelope.setSignatureTimeStampParams(this.j, this.k, this.l, this.m, this.n);
                    } else {
                        streamSignedEnvelope.setSignatureTimeStampParams(this.j, this.k, this.l, this.m, this.o, this.p);
                    }
                } else if (this.q != null) {
                    streamSignedEnvelope.setSignatureTimeStampParams(this.k, this.l, this.m, this.q);
                }
            }
            Date date2 = date = this.i != null ? this.i.getTime() : null;
            if (this.z == 2) {
                streamSignedEnvelope.includeSigningTime(false);
            }
            SignedPDF signedPDF = this;
            streamSignedEnvelope.addSigner(this.B, signedPDF.A, date, (InputStream)object);
            streamSignedEnvelope.getEncoded(null, (OutputStream)byteArrayOutputStream);
            this.G = false;
            object = byteArrayOutputStream.toByteArray();
        }
        catch (CapiException capiException) {
            try {
                a.debug("Unable save envelope! Got an exception", (Throwable)capiException);
                throw new IOException("Unable save envelope! Got an exception: " + capiException.getMessage(), capiException);
            }
            catch (Throwable throwable) {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                throw throwable;
            }
        }
        byteArrayOutputStream.close();
        return object;
    }

    public void addCertificationSignature(String string, OutputStream outputStream, String string2, int n, float f, float f2, float f3, float f4, int n2) throws CapiException {
        this.a(n2);
        this.addSignatureRevision(true, string, outputStream, string2, n, f, f2, f3, f4, null, null, 0);
    }

    public void addCertificationSignature(String string, OutputStream outputStream, String string2, int n, float f, float f2, float f3, float f4, int n2, BufferedImage bufferedImage, String string3, int n3) throws CapiException {
        this.a(n2);
        this.addSignatureRevision(true, string, outputStream, string2, n, f, f2, f3, f4, bufferedImage, string3, n3);
    }

    public void addCertificationSignature(String string, OutputStream outputStream, String string2, int n) throws CapiException {
        this.a(n);
        this.addSignatureRevision(string, outputStream, string2);
    }

    private void a(int n) throws CapiException {
        this.b();
        if (!this.signatures.isEmpty()) {
            throw new CapiException("PDF is already signed. Certification Signature cannot be added.", 50050);
        }
        if (this.getCertificationLevel() != 0) {
            if (bDebug) {
                a.debug("Document already certified");
            }
            throw new CapiException("Document already certified. Certification signature cannot be added.", 50026);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.s = n;
                return;
            }
        }
        if (bDebug) {
            a.debug("Certification level value is not valid.");
        }
        throw new CapiException("Certification level value not valid.", 1002);
    }

    public boolean isSigned() throws CapiException {
        return this.x;
    }

    public void addEmptySignatureField(OutputStream outputStream, String string, int n, float f, float f2, float f3, float f4) throws CapiException {
        if (string == null) {
            throw new CapiException("Null fieldName", 1001);
        }
        this.b();
    }

    public void close() {
        int n;
        SignedPDF signedPDF = this;
        if (signedPDF.revisionsIsVector != null && !signedPDF.revisionsIsVector.isEmpty()) {
            for (n = 0; n < signedPDF.revisionsIsVector.size(); ++n) {
                IOUtils.closeQuietly((Closeable)signedPDF.revisionsIsVector.get(n));
            }
        }
        if (signedPDF.revisionsFileVector != null && !signedPDF.revisionsFileVector.isEmpty()) {
            for (n = 0; n < signedPDF.revisionsFileVector.size(); ++n) {
                try {
                    signedPDF.revisionsFileVector.get(n).delete();
                    continue;
                }
                catch (Exception exception) {}
            }
        }
        this.c = true;
        IOUtils.closeQuietly((Closeable)this.document);
        IOUtils.closeQuietly((Closeable)this.F);
        IOUtils.closeQuietly((Closeable)this.E);
        try {
            if (this.r.exists()) {
                this.r.delete();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void addSignatureCertificate(byte[] object) throws CapiException {
        this.b();
        object = new Certificate(object).getInternalCert();
        if (!this.certsVector.contains(object)) {
            this.certsVector.addElement((X509Certificate)object);
        }
    }

    private void b() throws CapiException {
        if (this.c) {
            throw new CapiException("PDF has been closed, reread it from the outputstream used to add the signature revision", 50003);
        }
    }

    public void addSignatureCertificates(Certificate[] certificateArray) throws CapiException {
        this.b();
        for (int i = 0; i < certificateArray.length; ++i) {
            if (this.certsVector.contains(certificateArray[i].getInternalCert())) continue;
            this.certsVector.addElement(certificateArray[i].getInternalCert());
        }
    }

    public void addSignatureCertificates(String[] stringArray) throws CapiException {
        this.b();
        for (int i = 0; i < stringArray.length; ++i) {
            Certificate certificate = new Certificate(Util.getBytes((String)stringArray[i]));
            if (this.certsVector.contains(certificate.getInternalCert())) continue;
            this.certsVector.addElement(certificate.getInternalCert());
        }
    }

    @Deprecated
    public List<Certificate> listCertificates() throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        return this.H.getCertificatesArray();
    }

    public List<Certificate> listCertificates(int n) throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        return this.signatures.get(n).getCertificatesArray();
    }

    @Deprecated
    public Certificate getSignerCertificate() throws CapiException {
        return this.H.getSignerCertificate();
    }

    public Certificate getSignerCertificate(int n) throws CapiException {
        return this.signatures.get(n).getSignerCertificate();
    }

    @Deprecated
    public String getReason() {
        return this.H.getReason();
    }

    public String getReason(int n) {
        return this.signatures.get(n).getReason();
    }

    public void setSignatureReason(String string) {
        this.d = string;
    }

    @Deprecated
    public String getSubFilter() {
        return this.H.getSubFilter();
    }

    @Deprecated
    public String getSubFilter(int n) {
        return this.signatures.get(n).getSubFilter();
    }

    @Deprecated
    public String getCertificateInSigDictionary() {
        return this.H.getCertificateInSigDictionary();
    }

    public String getCertificateInSigDictionary(int n) {
        return this.signatures.get(n).getCertificateInSigDictionary();
    }

    @Deprecated
    public byte[] getP7Detached() {
        return this.H.getP7Detached();
    }

    public byte[] getP7Detached(int n) {
        return this.signatures.get(n).getP7Detached();
    }

    @Deprecated
    public String getLocation() {
        return this.H.getLocation();
    }

    public String getLocation(int n) {
        return this.signatures.get(n).getLocation();
    }

    @Deprecated
    public void setSignatureLocation(String string) {
        this.h = string;
    }

    @Deprecated
    public Calendar getSignDate() {
        return this.H.getSignDate();
    }

    public Calendar getSignDate(int n) {
        return this.signatures.get(n).getSignDate();
    }

    @Deprecated
    public String getName() {
        return this.H.getName();
    }

    public String getName(int n) {
        return this.signatures.get(n).getName();
    }

    public void setSignatureSignDate(Calendar calendar) {
        this.i = calendar;
    }

    @Deprecated
    public String verify() throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        if (!this.H.isValidSignature()) {
            throw new CapiException("Invalid signature", 3010);
        }
        return this.getSignerCertificate().getEncoded();
    }

    public String verify(int n) throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        if (!this.signatures.get(n).isValidSignature()) {
            throw new CapiException("Invalid signature", 3010);
        }
        return this.getSignerCertificate(n).getEncoded();
    }

    @Deprecated
    public byte[] getSignature() throws CapiException {
        return this.H.getSignature();
    }

    @Deprecated
    public String getSignerEncryptionAlg(int n) throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        return this.signatures.get(n).getSignerEncryptionAlg();
    }

    @Deprecated
    public String getSignerDigestAlg() throws CapiException {
        return this.H.getSignerDigestAlg();
    }

    @Deprecated
    public String getSignerDigestAlgOid() throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        return this.H.getSignerDigestAlg();
    }

    @Deprecated
    public byte[] getMessageDigest() throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        return this.H.getMessageDigest();
    }

    @Deprecated
    public boolean hasSigningCertificateV2() throws CapiException {
        return this.H.hasSigningCertificateV2();
    }

    @Deprecated
    public String getSigningCertificateV2HashAlg() throws CapiException {
        return this.H.getSigningCertificateV2HashAlg();
    }

    @Deprecated
    public boolean hasSigningCertificate() throws CapiException {
        return this.H.hasSigningCertificate();
    }

    @Deprecated
    public byte[] getSignatureTimeStampToken() throws CapiException {
        if (!this.isSigned()) {
            throw new CapiException("Pdf is not signed", 50001);
        }
        return this.H.getSignatureTimeStampToken();
    }

    public static void setDebug(boolean bl) {
        bDebug = bl;
    }

    @Deprecated
    public AutenticaBinding getAutentica_info() {
        return this.H.getAutentica_info();
    }

    public FeaInfo getFeaInfo(int n) {
        return this.signatures.get(n).getFeaInfo();
    }

    public AutenticaBinding getAutentica_info(int n) {
        return this.signatures.get(n).getAutentica_info();
    }

    private void a(InputStream inputStream, String string) throws a {
        try {
            this.F = this.E.createBuffer(inputStream);
            if (!SignedPDF.a(this.F)) {
                throw new IOException("Input is not a PDF");
            }
            inputStream = string != null ? new PDFParser(this.F, string, null, null, this.E) : new PDFParser(this.F, this.E);
            this.document = inputStream.parse();
        }
        catch (IOException iOException) {
            throw new a(this, string, iOException);
        }
    }

    private void c() throws IOException {
        Object object;
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        int n = 0;
        int n2 = 0;
        RevisionInformation revisionInformation = null;
        this.F.seek(0L);
        boolean bl = false;
        while (!this.F.isEOF()) {
            int n3 = this.F.read();
            if ((char)n3 == '%') {
                this.F.seek((long)n2);
                object = this.F.readFully(5);
                String string = new String((byte[])object, 0, 5, "US-ASCII");
                if (string.trim().equals("%%EOF")) {
                    int n4 = this.F.read();
                    if ((char)n4 == '\n') {
                        ++n2;
                        a.debug("EOF 6 carattere \\n codifica unix");
                    }
                    if ((char)n4 == '\r') {
                        ++n2;
                        n4 = this.F.read();
                        if ((char)n4 == '\n') {
                            a.debug("EOF 6 carattere \\r settimo \\n codifica windows");
                            ++n2;
                        }
                    }
                    RevisionInformation revisionInformation2 = new RevisionInformation();
                    nArray2[1] = n2 += 5;
                    revisionInformation2.setRevisionId(n);
                    revisionInformation2.setByteRange(nArray2);
                    for (PadesSignatureInformation padesSignatureInformation : this.signatures) {
                        int n5;
                        int[] nArray3 = padesSignatureInformation.getByteRangeArray();
                        if (nArray3 == null || nArray3[1] <= revisionInformation2.getByteRange()[0] || nArray3[2] >= revisionInformation2.getByteRange()[1]) continue;
                        revisionInformation2.getSignatures().add(padesSignatureInformation);
                        padesSignatureInformation.setRevision(revisionInformation2);
                        revisionInformation2.setSignedRevision(true);
                        COSString cOSString = (COSString)padesSignatureInformation.getSignatureDictionary().getDictionaryObject(COSName.CONTENTS);
                        int n6 = cOSString.toHexString().length();
                        int n7 = nArray3[2] - 1 - (nArray3[1] + 1);
                        int n8 = revisionInformation2.getByteRange()[1];
                        padesSignatureInformation.setSignature_cover_all_revision(false);
                        if (nArray3[0] != 0 || n7 != n6 || (n6 = Math.abs(nArray3[2] + nArray3[3] - n6 - (n8 - n6))) < 0 || n6 > 2 || (n5 = Math.abs(nArray3[2] + nArray3[3] - n8)) < 0 || n5 > 2) continue;
                        padesSignatureInformation.setSignature_cover_all_revision(true);
                    }
                    this.F.seek((long)n2);
                    if (bl) {
                        revisionInformation2.setPreviousRevision(revisionInformation);
                        revisionInformation.setNextRevision(revisionInformation2);
                        this.revisions.add(revisionInformation2);
                        revisionInformation = revisionInformation2;
                        a.debug("Aggiunta revisione " + n + " Range " + nArray2[0] + " " + nArray2[1]);
                        ++n;
                    } else if (revisionInformation2.getSignatures().size() != 0) {
                        if (revisionInformation != null) {
                            revisionInformation.getByteRange()[0] = 0;
                            revisionInformation.setRevisionId(0);
                            this.revisions.add(revisionInformation);
                            revisionInformation2.setPreviousRevision(revisionInformation);
                            revisionInformation.setNextRevision(revisionInformation2);
                            n = 1;
                        } else {
                            n = 0;
                        }
                        bl = true;
                        revisionInformation2.setRevisionId(n);
                        this.revisions.add(revisionInformation2);
                        revisionInformation = revisionInformation2;
                        a.debug("Aggiunta revisione " + n + " Range " + nArray2[0] + " " + nArray2[1]);
                        ++n;
                    } else if (this.b(revisionInformation2)) {
                        revisionInformation = revisionInformation2;
                    }
                    int[] nArray4 = new int[2];
                    nArray2 = nArray4;
                    nArray4[0] = n2 + 1;
                    continue;
                }
                this.F.seek((long)(n2 + 1));
                ++n2;
                continue;
            }
            ++n2;
        }
        if (!bl) {
            revisionInformation.getByteRange()[0] = 0;
            revisionInformation.setRevisionId(0);
            this.revisions.add(revisionInformation);
        } else {
            revisionInformation.getByteRange()[1] = (int)this.F.length();
        }
        for (PadesSignatureInformation padesSignatureInformation : this.signatures) {
            object = padesSignatureInformation;
            if (padesSignatureInformation.getRevision() != null) continue;
            this.revisions.get(this.revisions.size() - 1).getSignatures().add((PadesSignatureInformation)object);
            ((PadesSignatureInformation)object).setRevision(this.revisions.get(this.revisions.size() - 1));
            ((PadesSignatureInformation)object).setSignature_cover_all_revision(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean b(RevisionInformation revisionInformation) {
        block4: {
            ScratchFile scratchFile = null;
            RandomAccess randomAccess = null;
            PDDocument pDDocument = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                if (revisionInformation.getByteRange()[1] >= 1000000) break block4;
                bufferedInputStream = this.a();
                scratchFile = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
                randomAccess = scratchFile.createBuffer((InputStream)bufferedInputStream);
                pDDocument = revisionInformation.getDocument(randomAccess, scratchFile);
            }
            catch (IOException iOException) {
                try {
                    a.debug("Ipossibile parsare la revisioner");
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(pDDocument);
                    Util.closeQuietly(bufferedInputStream);
                    Util.closeQuietly(randomAccess);
                    Util.closeQuietly(scratchFile);
                    throw throwable;
                }
                Util.closeQuietly(pDDocument);
                Util.closeQuietly((Closeable)bufferedInputStream);
                Util.closeQuietly(randomAccess);
                Util.closeQuietly(scratchFile);
                return false;
            }
            Util.closeQuietly((Closeable)pDDocument);
            Util.closeQuietly((Closeable)bufferedInputStream);
            Util.closeQuietly((Closeable)randomAccess);
            Util.closeQuietly((Closeable)scratchFile);
            return true;
        }
        Util.closeQuietly(null);
        Util.closeQuietly(null);
        Util.closeQuietly(null);
        Util.closeQuietly(null);
        return true;
    }

    public void checkRevisions() throws FileNotFoundException, IOException, InterruptedException {
        Object object;
        for (int i = 0; i < this.document.getPages().getCount(); ++i) {
            Object object2 = this.document.getPages().get(i).getContentStreams();
            while (object2.hasNext()) {
                object = (PDStream)object2.next();
                RevisionInformation revisionInformation = this.a(object.getCOSObject().getOffsetPosition());
                if (revisionInformation == null || revisionInformation.getPreviusRevision() == null) continue;
                revisionInformation.setUpdatePreviousObject(true);
            }
            object = this.document.getPages().get(i).getAnnotations();
            for (int j = 0; j < object.size(); ++j) {
                object2 = (PDAnnotation)object.get(j);
                if (object2.getCOSObject().getItem(COSName.FT) != null || (object2 = this.a(object2.getCOSObject().getOffsetPosition())) == null || ((RevisionInformation)object2).getPreviusRevision() == null) continue;
                ((RevisionInformation)object2).setUpdatePreviousAnnotation(true);
            }
        }
        List list = this.document.getDocumentCatalog().getAcroForm().getFields();
        for (int i = 0; i < list.size(); ++i) {
            RevisionInformation revisionInformation;
            object = (PDField)list.get(i);
            if (object.getFieldType() != null && object.getFieldType().equals("Sig") || (revisionInformation = this.a(object.getCOSObject().getOffsetPosition())) == null || revisionInformation.getPreviusRevision() == null) continue;
            revisionInformation.setUpdatePreviousField(true);
        }
    }

    private RevisionInformation a(long l) {
        RevisionInformation revisionInformation = null;
        for (int i = 0; i < this.revisions.size(); ++i) {
            RevisionInformation revisionInformation2 = this.revisions.get(i);
            long l2 = revisionInformation2.getPreviusRevision() != null ? (long)revisionInformation2.getPreviusRevision().getByteRange()[1] : (long)revisionInformation2.getByteRange()[0];
            long l3 = revisionInformation2.getByteRange()[1];
            if (l >= l3 || l < l2) continue;
            revisionInformation = revisionInformation2;
            break;
        }
        return revisionInformation;
    }

    public ArrayList<RevisionInformation> getRevisions() {
        return this.revisions;
    }

    protected void finalize() throws IOException {
        if (!this.c) {
            a.debug("Documento PDF non chiuso");
            this.close();
        }
    }

    public LinkedList<X509Certificate> getCerts() {
        if (this.I != null) {
            return this.I.getCerts();
        }
        return new LinkedList<X509Certificate>();
    }

    public LinkedList<BasicOCSPResp> getOcsps() {
        if (this.I != null) {
            return this.I.getOcsps();
        }
        return new LinkedList<BasicOCSPResp>();
    }

    public LinkedList<CRL> getCrls() {
        if (this.I != null) {
            return this.I.getCrls();
        }
        return new LinkedList<CRL>();
    }

    private static boolean a(RandomAccessRead randomAccessRead) throws IOException {
        boolean bl = false;
        byte[] byArray = new byte[5];
        if (randomAccessRead.read(byArray, 0, 5) != -1) {
            String string = new String(byArray);
            bl = string.startsWith("%FDF-") || string.startsWith("%PDF-");
        }
        randomAccessRead.seek(0L);
        return bl;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public List<PadesSignatureInformation> getSignatures() {
        return this.signatures;
    }

    public PadesSignatureInformation getSignature(int n) {
        if (n < 0 || n >= this.signatures.size()) {
            return null;
        }
        return this.signatures.get(n);
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }

    private final class a
    extends IOException {
        String a = "";

        public a(SignedPDF signedPDF, String string, Throwable throwable) {
            super(throwable);
            this.a = string;
        }
    }
}

