/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider.pkcs11;

import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.pkcs11.ASToken;
import it.actalis.ellips.capi.provider.pkcs11.AS_PrivateKey;
import it.actalis.vol.utils.Constants;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi;
import org.slf4j.Logger;

public class AS_RSACipher
extends CipherSpi {
    private static Logger b = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private int c;
    private short d = 0;
    private ASToken e = null;
    static boolean a;

    public AS_RSACipher() {
        super((AsymmetricBlockCipher)new RSAEngine());
        b.debug("constructor OK");
        this.d = 0;
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        switch (this.d) {
            case 1: {
                b.debug("engineSetMode device: " + string);
                return;
            }
            case 0: {
                b.debug("engineSetMode: " + string);
            }
            case 2: {
                b.debug("engineSetMode BouncyCastle  :" + string);
                super.engineSetMode(string);
            }
        }
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        switch (this.d) {
            case 1: {
                b.debug("engineSetPadding device: " + string);
                return;
            }
            case 0: {
                b.debug("engineSetPadding: " + string);
            }
            case 2: {
                b.debug("engineSetPadding BouncyCastle: " + string);
                super.engineSetPadding(string);
            }
        }
    }

    public void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        b.debug("engineInit AlgParSpec");
        this.engineInit(n, key, secureRandom);
    }

    public void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException {
        b.debug("engineInit AlgParamet");
        this.engineInit(n, key, secureRandom);
    }

    public void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        b.debug("engineInit check?");
        this.c = n;
        try {
            if (key instanceof AS_PrivateKey) {
                b.debug("engineInit is as_privatekey");
                this.d = 1;
                AS_PrivateKey aS_PrivateKey = (AS_PrivateKey)key;
                this.e = aS_PrivateKey.getCryptoDev();
            } else {
                b.debug("engineInit is NOT as_privatekey");
                this.d = (short)2;
                this.e = null;
            }
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new InvalidKeyException("Unable to init RSA key: " + exception.toString());
        }
        switch (this.d) {
            case 0: {
                throw new InvalidKeyException("Invalid use device.");
            }
            case 1: {
                return;
            }
            case 2: {
                b.debug("call BouncyCastle engineInit");
                try {
                    super.engineInit(n, key, null, secureRandom);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    b.debug(invalidAlgorithmParameterException.getMessage(), (Throwable)invalidAlgorithmParameterException);
                    throw new InvalidKeyException("InvalidAlgorithmParameterException: " + invalidAlgorithmParameterException.toString());
                }
                b.debug("BouncyCastle engineInit checked");
            }
        }
    }

    public byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (this.d != 1) {
            b.debug("engineUpdate call BouncyCastle");
            return super.engineUpdate(byArray, n, n2);
        }
        throw new RuntimeException("Method not supported.");
    }

    public int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.d != 1) {
            b.debug("engineUpdate call BouncyCastle");
            return super.engineUpdate(byArray, n, n2, byArray2, n3);
        }
        throw new RuntimeException("Method not supported.");
    }

    public int engineGetBlockSize() {
        if (this.d != 1) {
            b.debug("engineGetBlockSize call BouncyCastle");
            return super.engineGetBlockSize();
        }
        throw new RuntimeException("Method not supported.");
    }

    public byte[] engineGetIV() {
        if (this.d != 1) {
            b.debug("engineGetIV call BouncyCastle");
            return super.engineGetIV();
        }
        throw new RuntimeException("Method not supported.");
    }

    public int engineGetOutputSize(int n) {
        if (this.d != 1) {
            b.debug("engineGetOutputSize: BouncyCastle ");
            return super.engineGetOutputSize(n);
        }
        return 0;
    }

    public byte[] engineDoFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
        if (this.d == 2) {
            b.debug("engineDoFinal: BouncyCastle inpLen=" + n2);
            try {
                return super.engineDoFinal(byArray, n, n2);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                b.debug(illegalBlockSizeException.getMessage(), (Throwable)illegalBlockSizeException);
                throw new IllegalBlockSizeException("Buffer to short to hold result.");
            }
        }
        if (this.d != 1) {
            throw new RuntimeException("Use not allowed.");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        b.debug("engineDoFinal: device: MODE: " + this.c);
        if (this.c == 1) {
            return this.a(byArray2);
        }
        return this.b(byArray2);
    }

    public int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        if (this.d == 2) {
            b.debug("engineDoFinal-2: BouncyCastle");
            return super.engineDoFinal(byArray, n, n2, byArray2, n3);
        }
        if (this.d != 1) {
            throw new RuntimeException("Use not allowed.");
        }
        b.debug("engineDoFinal-2");
        byArray = this.engineDoFinal(byArray, n, n2);
        try {
            System.arraycopy(byArray, 0, byArray2, n3, byArray.length);
        }
        catch (Exception exception) {
            b.debug(exception.getMessage(), (Throwable)exception);
            throw new IllegalBlockSizeException("Buffer to short to hold result.");
        }
        return byArray.length;
    }

    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    public AlgorithmParameters getParameters() {
        throw new RuntimeException("Method not supported.");
    }

    private byte[] a(byte[] byArray) {
        b.debug("[encrypt] hash.length " + byArray.length);
        try {
            byArray = this.e.doSign(byArray);
            b.debug("[encrypt] doSign ok");
        }
        catch (CapiException capiException) {
            b.debug(capiException.getMessage(), (Throwable)capiException);
            throw new CapiError(capiException);
        }
        if (byArray == null) {
            throw new CapiError("Invalid signature", 3003);
        }
        return byArray;
    }

    private byte[] b(byte[] byArray) {
        b.debug("[decrypt] signature.length " + byArray.length);
        try {
            byArray = this.e.doDecrypt(byArray);
            b.debug("[decrypt] doDecrypt ok");
        }
        catch (CapiException capiException) {
            b.debug(capiException.getMessage(), (Throwable)capiException);
            throw new CapiError(capiException);
        }
        if (byArray == null) {
            throw new CapiError("Invalid decryption", 3103);
        }
        b.debug("[decrypt] hash.length " + byArray.length);
        return byArray;
    }
}

