/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.security.cert.CertificateEncodingException;
import java.util.LinkedList;

public class StepX509AIACheck
extends SingleValidationSubStepImpl {
    public StepX509AIACheck() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> object, ValidationContextParameters validationContextParameters) {
        block11: {
            if (validationContextParameters != null && validationContextParameters.getSignerCertificate() != null && (validationContextParameters.getSignature() == null || validationContextParameters.getSignature().getFormat() != null && !validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST)) && validationContextParameters.getSignerCertificate().getIssuer() != null) {
                try {
                    object = validationContextParameters.getCertDB().contains(validationContextParameters.getSignerCertificate().getIssuer().getCert().getInternalCert().getEncoded());
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    object = null;
                }
                catch (CapiException capiException) {
                    object = null;
                }
                try {
                    Object object2 = validationContextParameters.getSignerCertificate().getCert().getAuthorityInfoAccess();
                    if (object2 == null || ((String[])object2).length == 0) {
                        return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0007_AIA_NOT_PRESENT, new Object[0]);
                    }
                    if (object != null && ((CertDBItem)object).getCertificate() != null && ((CertDBItem)object).getCertificate().getSubjectDN().equals(((CertDBItem)object).getCertificate().getIssuerDN())) break block11;
                    boolean bl = false;
                    try {
                        object2 = validationContextParameters.getSignerCertificate().getCert().getCaIssuer();
                        if (object2 != null && !((String)object2).isEmpty()) {
                            bl = true;
                        }
                    }
                    catch (CapiException capiException) {
                        bl = false;
                    }
                    if (!bl) {
                        return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0015_CAISSUER_NOT_PRESENT, new Object[0]);
                    }
                }
                catch (CapiException capiException) {}
            }
        }
        return null;
    }
}

