/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.ValidationDate;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class StepX509TimeValidity
extends MultipleValidationSubStepImpl {
    public StepX509TimeValidity() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> cloneable, ValidationContextParameters validationContextParameters) {
        cloneable = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        ((DateFormat)cloneable).setTimeZone(validationContextParameters.getTimeZone());
        cloneable = new LinkedList();
        if (validationContextParameters != null) {
            if (validationContextParameters.getSignerCertificate() != null) {
                Object object = validationContextParameters.getCalculatedValidationDate();
                try {
                    validationContextParameters.getSignerCertificate().setCertTimeValid(true);
                    object = ((ValidationDate)object).getDate();
                    if (((Date)object).before(validationContextParameters.getSignerCertificate().getCert().getInternalCert().getNotBefore()) || ((Date)object).after(validationContextParameters.getSignerCertificate().getCert().getInternalCert().getNotAfter())) {
                        validationContextParameters.getSignerCertificate().setCertTimeValid(false);
                        ((LinkedList)cloneable).add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0005_CERT_NOT_TIME_VALID, new Object[0]));
                        ((LinkedList)cloneable).add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0014_CERT_VALIDATION_TO_DATE, new Object[0]));
                    }
                }
                catch (Exception exception) {
                    ((LinkedList)cloneable).add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
                }
            } else {
                ((LinkedList)cloneable).add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
            }
        } else {
            ((LinkedList)cloneable).add((ValidatorMessage)new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
        }
        return cloneable;
    }
}

