/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.inputs;

import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.inputs.filter.InputFilter;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public abstract class InputHandler
extends DataHandler
implements Closeable {
    protected List<InputStream> trackedStreams = new ArrayList<InputStream>();
    protected List<InputFilter> filters = new ArrayList<InputFilter>();
    protected boolean closed = false;
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public InputStream getInputAsNewStream() throws IOException {
        return this.getInputAsNewStream(true);
    }

    public InputStream getInputAsNewStream(boolean bl) throws IOException {
        if (!this.closed) {
            InputStream inputStream = this.customGetInputAsNewStream();
            if (inputStream == null) {
                a.error("customGetInputAsNewStream returns null!");
            }
            if (this.filters != null) {
                for (InputFilter inputFilter : this.filters) {
                    inputStream = inputFilter.applayFilter(inputStream);
                }
            }
            if (bl) {
                this.trackedStreams.add(inputStream);
            }
            if (inputStream == null) {
                a.error("getInputAsNewStream returns null!");
            }
            return inputStream;
        }
        throw new IOException("Handler is closed");
    }

    protected abstract InputStream customGetInputAsNewStream();

    @Override
    public void close() {
        for (InputStream inputStream : this.trackedStreams) {
            Util.closeQuietly(inputStream);
        }
        this.closed = true;
    }

    public void addFilter(InputFilter inputFilter) {
        this.filters.add(inputFilter);
    }

    public void resetFilter() {
        this.filters.clear();
    }
}

