/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.Actalis_RSACipher;
import it.actalis.ellips.capi.provider.Token;
import it.actalis.ellips.capi.provider.c;
import it.actalis.vol.utils.Constants;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.slf4j.Logger;

public class Crypto_ISO9796d2PSSSigner {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String HASH_ALG_SHA1 = "SHA-1";
    public static final String HASH_ALG_SHA256 = "SHA-256";
    public static final String HASH_ALG_RIPEMD160 = "RIPEMD160";
    private String b = "SHA-1";
    private boolean c = false;
    private byte[] d = null;

    public Crypto_ISO9796d2PSSSigner(String string) throws CapiException {
        if (!(string.equalsIgnoreCase(HASH_ALG_SHA1) || string.equalsIgnoreCase(HASH_ALG_SHA256) || string.equalsIgnoreCase(HASH_ALG_RIPEMD160))) {
            throw new CapiException("Digest Algorithm: " + string + " not supported", 3011);
        }
        this.b = string;
        a.debug("constructor OK");
    }

    public void setImplicit(boolean bl) {
    }

    public void verify(InputStream inputStream, byte[] byArray, byte[] object, int n) throws CapiException {
        boolean bl;
        a.debug("verify");
        Certificate certificate = new Certificate((byte[])object);
        object = certificate;
        object = certificate.getPublicKey();
        try {
            int n2;
            SHA1Digest sHA1Digest;
            BigInteger bigInteger = ((RSAPublicKey)object).getPublicExponent();
            Object object2 = ((RSAPublicKey)object).getModulus();
            Actalis_RSACipher actalis_RSACipher = new Actalis_RSACipher();
            actalis_RSACipher.engineSetPadding("NOPADDING");
            if (this.b.equalsIgnoreCase(HASH_ALG_SHA1)) {
                sHA1Digest = new SHA1Digest();
            } else if (this.b.equalsIgnoreCase(HASH_ALG_SHA256)) {
                sHA1Digest = new SHA256Digest();
            } else if (this.b.equalsIgnoreCase(HASH_ALG_RIPEMD160)) {
                sHA1Digest = new RIPEMD160Digest();
            } else {
                throw new CapiException("Digest Algorithm: " + this.b + " not supported", 3011);
            }
            bigInteger = new RSAKeyParameters(false, (BigInteger)object2, bigInteger);
            this.d = null;
            this.c = false;
            SHA1Digest sHA1Digest2 = sHA1Digest;
            object2 = new c(actalis_RSACipher, (Digest)sHA1Digest2, sHA1Digest2.getDigestSize());
            ((c)object2).a(false, (CipherParameters)bigInteger, (Key)object);
            object = new byte[n];
            while ((n2 = inputStream.read((byte[])object)) != -1) {
                if (n2 == 0) continue;
                if (n2 == n) {
                    ((c)object2).update((byte[])object, 0, n);
                    continue;
                }
                a.debug("Crypto: hash last block read;len =" + n2);
                ((c)object2).update((byte[])object, 0, n2);
            }
            inputStream.close();
            bl = ((c)object2).verifySignature(byArray);
            if (bl) {
                a.debug("signature successfully verified");
            } else {
                a.debug("signature verify failed");
            }
            a.debug("hasFullMessage: " + ((c)object2).hasFullMessage());
            this.c = ((c)object2).hasFullMessage();
            this.d = ((c)object2).getRecoveredMessage();
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("Internal error. " + noSuchAlgorithmException.getMessage(), 1003);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            a.debug(noSuchPaddingException.getMessage(), (Throwable)noSuchPaddingException);
            throw new CapiException("Internal error. " + noSuchPaddingException.getMessage(), 1003);
        }
        catch (BadPaddingException badPaddingException) {
            a.debug(badPaddingException.getMessage(), (Throwable)badPaddingException);
            throw new CapiException("Invalid signature. " + badPaddingException.getMessage(), 3010);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            a.debug(illegalBlockSizeException.getMessage(), (Throwable)illegalBlockSizeException);
            throw new CapiException("Invalid signature. " + illegalBlockSizeException.getMessage(), 3010);
        }
        catch (InvalidKeyException invalidKeyException) {
            a.debug(invalidKeyException.getMessage(), (Throwable)invalidKeyException);
            throw new CapiException("Invalid key format. " + invalidKeyException.getMessage(), 3000);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Invalid signature. " + exception.getMessage(), 3010);
        }
        if (!bl) {
            throw new CapiException("Invalid signature", 3010);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(String object, InputStream inputStream, int n) throws CapiException {
        try {
            int n2;
            SHA1Digest sHA1Digest;
            PrivateKey privateKey;
            Object object2 = Token.getTokenSpi((String)object);
            if (object2 == null) {
                throw new CapiException("Token not initialized", 10003);
            }
            Object object3 = object2;
            synchronized (object3) {
                privateKey = ((TokenSpi)object2).getPrivateKey((String)object);
                a.debug("getPrivateKey done.");
                object = ((TokenSpi)object2).getPublicKey((String)object);
                a.debug("getPublicKey done.");
            }
            object3 = ((RSAPrivateKey)privateKey).getPrivateExponent();
            ((RSAPublicKey)object).getPublicExponent();
            object = ((RSAPublicKey)object).getModulus();
            object2 = new Actalis_RSACipher();
            ((Actalis_RSACipher)((Object)object2)).engineSetPadding("NOPADDING");
            if (this.b.equalsIgnoreCase(HASH_ALG_SHA1)) {
                sHA1Digest = new SHA1Digest();
            } else if (this.b.equalsIgnoreCase(HASH_ALG_SHA256)) {
                sHA1Digest = new SHA256Digest();
            } else if (this.b.equalsIgnoreCase(HASH_ALG_RIPEMD160)) {
                sHA1Digest = new RIPEMD160Digest();
            } else {
                throw new CapiException("Digest Algorithm: " + this.b + " not supported", 3011);
            }
            object = new RSAKeyParameters(true, (BigInteger)object, (BigInteger)object3);
            this.d = null;
            this.c = false;
            SHA1Digest sHA1Digest2 = sHA1Digest;
            object2 = new c((Actalis_RSACipher)((Object)object2), (Digest)sHA1Digest2, sHA1Digest2.getDigestSize());
            ((c)object2).a(true, (CipherParameters)object, privateKey);
            object = new byte[n];
            while ((n2 = inputStream.read((byte[])object)) != -1) {
                if (n2 == 0) continue;
                if (n2 == n) {
                    ((c)object2).update((byte[])object, 0, n);
                    continue;
                }
                ((c)object2).update((byte[])object, 0, n2);
            }
            inputStream.close();
            byte[] byArray = ((c)object2).generateSignature();
            object = byArray;
            return byArray;
        }
        catch (CapiException capiException) {
            CapiException capiException2 = capiException;
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            a.debug("CapiException in sign ... " + exception.getMessage());
            throw new CapiException(exception.getMessage(), 50040);
        }
    }

    public boolean hasFullMessage() {
        return this.c;
    }

    public byte[] getRecoveredMessage() {
        return this.d;
    }
}

