/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.ldap;

import it.actalis.ellips.capi.ldap.LdapException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;

public class LdapEntry {
    static final String ca_objcl = "ca";
    static final String ca_objcl2 = "certificationAuthority";
    static final String user_objcl = "person";
    public static final int CA_TYPE = 1;
    public static final int USER_TYPE = 0;
    private Attributes attrs = null;
    private String DN = null;

    protected LdapEntry(Attributes attrs, String DN) {
        this.attrs = attrs;
        this.DN = DN;
    }

    public String getDistinguishedName() {
        return this.DN;
    }

    public int getType() throws LdapException {
        int i = 0;
        String obj = this.getAttribute(i, "objectclass");
        while (obj != null) {
            if (obj.equalsIgnoreCase(user_objcl)) {
                return 0;
            }
            if (obj.equalsIgnoreCase(ca_objcl) || obj.equalsIgnoreCase(ca_objcl2)) {
                return 1;
            }
            obj = this.getAttribute(++i, "objectclass");
        }
        return -1;
    }

    public byte[] getX509Certificate(int index) throws LdapException {
        return this.getBinAttribute(index, "userCertificate");
    }

    public byte[] getX509CACertificate(int index) throws LdapException {
        return this.getBinAttribute(index, "caCertificate");
    }

    public byte[] getX509CRL(int index) throws LdapException {
        return this.getBinAttribute(index, "certificateRevocationList");
    }

    public String getEmailAddress() throws LdapException {
        try {
            return this.getAttribute("mail");
        }
        catch (LdapException ldapException) {
            try {
                return this.getAttribute("rfc822mailbox");
            }
            catch (LdapException ldapException2) {
                throw new LdapException("Cannot find Email attribute", 90006);
            }
        }
    }

    public byte[] getBinAttribute(String attr) throws LdapException {
        return this.getBinAttribute(0, attr);
    }

    public String getAttribute(String attr) throws LdapException {
        return this.getAttribute(0, attr);
    }

    public void resetX509Certificates(Object[] attrValues) throws LdapException {
        BasicAttributes attributes = new BasicAttributes();
        for (int i = 0; i < attrValues.length; ++i) {
            attributes.put("userCertificate", (byte[])attrValues[i]);
        }
        this.attrs = attributes;
    }

    public byte[] getBinAttribute(int index, String attr) throws LdapException {
        try {
            Attribute anAttr = this.attrs.get(attr);
            if (anAttr == null) {
                if (!attr.endsWith(";binary")) {
                    attr = attr + ";binary";
                    anAttr = this.attrs.get(attr);
                }
                if (anAttr == null) {
                    throw new LdapException("NoSuchAttribute", 90006);
                }
            }
            if (anAttr.get(index) != null) {
                return (byte[])anAttr.get(index);
            }
        }
        catch (Exception e) {
            throw new LdapException(e.getMessage(), 90006, e);
        }
        return null;
    }

    public String getAttribute(int index, String attr) throws LdapException {
        try {
            if (this.attrs.get(attr) == null) {
                return null;
            }
            if (this.attrs.get(attr).get(index) != null) {
                return (String)this.attrs.get(attr).get(index);
            }
        }
        catch (Exception e) {
            throw new LdapException(e.getMessage(), 90006, e);
        }
        return null;
    }

    public String toString() {
        return "[LdapEntry]:" + this.attrs.toString();
    }
}

