/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsa;

import esecurity.dts.DTSClient;
import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.tsa.TSAMessageEnum;
import it.actalis.ellips.capi.tsa.TSAUtil;
import it.actalis.ellips.capi.tsa.a;
import it.actalis.ellips.capi.tsa.b;
import it.actalis.ellips.capi.tsa.c;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.UserData;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampResponse;
import org.slf4j.Logger;

public class InfoCertDTSClient
extends DTSClient {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public InfoCertDTSClient(TSAData tSAData) throws IllegalParamException {
        this(tSAData, null);
    }

    public InfoCertDTSClient(UserData userData, NetworkConfig networkConfig) throws IllegalParamException {
        this(new TSAData(userData.getTsaUrl(), userData.getTsaAlternativeUrl(), null, userData.getTsaUsername(), userData.getTsaPassword(), userData.getTsaAlternativeUsername(), userData.getTsaAlternativePassword()), null);
    }

    public InfoCertDTSClient(TSAData tSAData, NetworkConfig networkConfig) throws IllegalParamException {
        this(tSAData, networkConfig, null);
    }

    public InfoCertDTSClient(TSAData tSAData, NetworkConfig networkConfig, String string) throws IllegalParamException {
        super(tSAData, networkConfig, string);
    }

    @Override
    public void initializeClient(TSAData tSAData, NetworkConfig networkConfig, String string) throws IllegalParamException {
        this.tsaData = tSAData;
        this.netConf = networkConfig == null ? new NetworkConfig() : networkConfig;
        this.requestedUrl = string;
        if (string == null) {
            this.requestedUrl = tSAData.getTSAUrl();
        }
    }

    @Override
    public void setServer(String string, HTTP hTTP) throws IllegalParamException {
        this.tsaData.setTSAUrl(string);
        this.netConf = hTTP.getConfig();
    }

    @Override
    public void setServer(String string, int n) throws IllegalParamException {
        throw new UnsupportedOperationException("Funzionalit\u00e0 non supportata");
    }

    @Override
    public void setTimeout(long l) throws IllegalParamException {
        this.netConf.setConnectionTimeOut("" + l);
    }

    @Override
    public TimeStampToken timeStamp(String string, String string2, byte[] byArray) throws TSAException, IOException, IllegalParamException {
        return this.timeStamp(string, string2, byArray, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String string, String string2, InputStream inputStream) throws IOException, TSAException, IllegalParamException {
        return this.timeStamp(string, string2, inputStream, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String object, String string, byte[] byArray, BigInteger bigInteger, boolean bl) throws TSAException {
        try {
            object = TSAUtil.generateMarkRequest(string, bigInteger, byArray, (String)object, bl);
            object = TSAUtil.getMarkFromRequest((TimeStampRequest)object, this.requestedUrl, this.tsaData, this.netConf, new a(this));
            return new TimeStampToken(object.getEncoded());
        }
        catch (TSAException tSAException) {
            object = tSAException;
            throw tSAException;
        }
        catch (CapiException | IOException exception) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR, exception);
        }
    }

    @Override
    public TimeStampToken timeStamp(String object, String string, InputStream inputStream, BigInteger bigInteger, boolean bl) throws TSAException {
        try {
            return new TimeStampToken(this.getMark(inputStream, bl).getEncoded());
        }
        catch (TSAException tSAException) {
            object = tSAException;
            throw tSAException;
        }
        catch (CapiException | IOException exception) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR, exception);
        }
    }

    @Override
    public TimeStampToken timeStampHash(String string, String string2, byte[] byArray) throws ApiGeneralException, IOException, TSAException {
        return this.timeStampHash(string, string2, byArray, null, true);
    }

    @Override
    public TimeStampToken timeStampHash(String object, String string, byte[] byArray, BigInteger bigInteger, boolean bl) throws ApiGeneralException, IOException, TSAException {
        try {
            object = TSAUtil.generateMarkRequest(string, bigInteger, byArray, (String)object, bl);
            object = TSAUtil.getMarkFromRequest((TimeStampRequest)object, this.requestedUrl, this.tsaData, this.netConf, new b(this));
            return new TimeStampToken(object.getEncoded());
        }
        catch (TSAException tSAException) {
            object = tSAException;
            throw tSAException;
        }
        catch (CapiException | IOException exception) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }

    @Override
    public TimeStampResponse getMark(InputStream object, boolean bl) throws ApiGeneralException, IOException, TSAException {
        try {
            object = TSAUtil.getMark((InputStream)object, bl, this.tsaData, this.netConf, new c(this));
            return object;
        }
        catch (TSAException tSAException) {
            object = tSAException;
            throw tSAException;
        }
        catch (CapiException | IOException | TSPException throwable) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR, (Exception)throwable);
        }
    }

    @Override
    public byte[] stamp(InputStream inputStream, TimeStampOptions timeStampOptions) {
        BigInteger bigInteger = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(timeStampOptions.getTSAPolicy(), timeStampOptions.getTSADigestAlgorithm().toString(), inputStream, bigInteger, timeStampOptions.isTSACertReq()).toByteArray(false, true);
        }
        catch (CapiException | IOException exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    public byte[] stampEx(InputStream object, TimeStampOptions timeStampOptions) throws TSAException {
        BigInteger bigInteger = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(timeStampOptions.getTSAPolicy(), timeStampOptions.getTSADigestAlgorithm().toString(), (InputStream)object, bigInteger, timeStampOptions.isTSACertReq()).toByteArray(false, true);
        }
        catch (TSAException tSAException) {
            object = tSAException;
            throw tSAException;
        }
        catch (CapiException | IOException exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }

    private static TSAMessageEnum b(UrlReturn object) {
        TSAMessageEnum tSAMessageEnum;
        block31: {
            tSAMessageEnum = null;
            if (object == null || object.getStatus() == null || !object.getStatus().equals("OK") || object.getData() == null) {
                tSAMessageEnum = TSAMessageEnum.INTERNAL_ERROR;
                if (object != null && object.getStatus() != null && !object.getStatus().equals("OK") && object.getStatus_code() == -1 && object.getStatus().equals("KO")) {
                    tSAMessageEnum = TSAMessageEnum.NETWORK_ERROR;
                }
            } else if (object.getStatus().equals("OK")) {
                try {
                    object = new String(object.getData());
                    String string = null;
                    if (((String)object).contains("MSGNO")) {
                        string = "MSGNO";
                    } else if (((String)object).contains("ERRNO")) {
                        string = "ERRNO";
                    }
                    if (string == null) break block31;
                    Object object2 = object;
                    string = ((String)object2).substring(((String)object2).indexOf(string) + 6, ((String)object).indexOf("DESCR")).trim();
                    Object object3 = object;
                    object = ((String)object3).substring(((String)object3).indexOf("DESCR") + 6).trim();
                    a.error("TSA error " + string + ": " + (String)object);
                    switch (string) {
                        case "1000": {
                            tSAMessageEnum = TSAMessageEnum.BAD_REQUEST;
                            break;
                        }
                        case "1100": {
                            tSAMessageEnum = TSAMessageEnum.RESOURCE_NOT_FOUND;
                            break;
                        }
                        case "1200": {
                            tSAMessageEnum = TSAMessageEnum.BAD_REQUEST;
                            break;
                        }
                        case "1300": {
                            tSAMessageEnum = TSAMessageEnum.ACCOUNT_BAD_CREDENTIALS;
                            break;
                        }
                        case "1400": {
                            tSAMessageEnum = TSAMessageEnum.INTERNAL_ERROR;
                            break;
                        }
                        case "1500": {
                            tSAMessageEnum = TSAMessageEnum.INTERNAL_ERROR;
                            break;
                        }
                        case "1600": {
                            tSAMessageEnum = TSAMessageEnum.INTERNAL_ERROR;
                            break;
                        }
                        case "1700": {
                            tSAMessageEnum = TSAMessageEnum.INTERNAL_ERROR;
                            break;
                        }
                        case "1900": {
                            tSAMessageEnum = TSAMessageEnum.NO_MORE_TIMESTAMPS;
                            break;
                        }
                        default: {
                            tSAMessageEnum = TSAMessageEnum.INTERNAL_ERROR;
                        }
                    }
                }
                catch (Exception exception) {
                    a.error(exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return tSAMessageEnum;
    }

    static /* synthetic */ TSAMessageEnum a(UrlReturn urlReturn) {
        return InfoCertDTSClient.b(urlReturn);
    }
}

