/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import it.actalis.ellips.capi.signature.DigestAlgorithm;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLCommonUtils {
    public static String getXMLEncDigestType(DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm == null) {
            return null;
        }
        switch (digestAlgorithm) {
            case SHA1: {
                return "sha1";
            }
            case SHA256: {
                return "sha256";
            }
        }
        return null;
    }

    public static void completeXMLDigestMethod(XMLStreamWriter xMLStreamWriter, DigestAlgorithm digestAlgorithm) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("DigestMethod");
        xMLStreamWriter.writeNamespace("", "http://www.w3.org/2000/09/xmldsig#");
        xMLStreamWriter.writeAttribute("Algorithm", "http://www.w3.org/2001/04/xmlenc#" + XMLCommonUtils.getXMLEncDigestType(digestAlgorithm));
        xMLStreamWriter.writeEndElement();
    }

    public static void completeXMLDigestValue(XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("DigestValue");
        xMLStreamWriter.writeNamespace("", "http://www.w3.org/2000/09/xmldsig#");
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
    }

    public static void completeXMLDigestCouple(XMLStreamWriter xMLStreamWriter, DigestAlgorithm digestAlgorithm, String string) throws XMLStreamException {
        XMLCommonUtils.completeXMLDigestMethod(xMLStreamWriter, digestAlgorithm);
        XMLCommonUtils.completeXMLDigestValue(xMLStreamWriter, string);
    }
}

