/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml.parser;

import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.RefOcsp;
import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.parser.utils.CRLUtils;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.ParserUtils;
import esecurity.validator.parser.utils.TSTUtils;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.StreamInputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.xml.parser.SignedXMLEnvelope;
import it.actalis.ellips.capi.xml.parser.a;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractSequentialList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.crypto.dsig.Reference;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class XadesParserHelper {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    private static SignatureInformation a(TransientDocument object, byte[] byArray) {
        for (SignatureInformation signatureInformation : ((TransientDocument)object).getSignerInfo()) {
            if (!Arrays.areEqual((byte[])signatureInformation.getSignatureInfo(), (byte[])byArray)) continue;
            return signatureInformation;
        }
        return null;
    }

    public static void parseXadesEnvelope(TransientDocument transientDocument, SignedXMLEnvelope signedXMLEnvelope, DateFormat dateFormat, boolean bl, boolean bl2, EventHandlerSelector eventHandlerSelector, NetworkConfig networkConfig) throws Exception {
        String[] stringArray = signedXMLEnvelope.listSigners();
        if (stringArray != null && stringArray.length > 0) {
            transientDocument.setSigned(true);
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                Object object2;
                SignatureInformation signatureInformation = null;
                if (!signedXMLEnvelope.isSignatureParsed(i)) {
                    signatureInformation = new SignatureInformation();
                    signatureInformation.setSignatureInfo(signedXMLEnvelope.getRawSignature(i));
                    signatureInformation.setFormat(SignatureFormat.XADES);
                    signatureInformation.setContainerFormat(ContainerFormat.SELF);
                    signatureInformation.setCorrupted(true);
                    Object object3 = signedXMLEnvelope.getCertificates(i);
                    if (object3 != null) {
                        object2 = ((AbstractSequentialList)object3).iterator();
                        while (object2.hasNext()) {
                            object = (X509Certificate)object2.next();
                            String string = Utils.calculateDigest(new ByteArrayInputStream(((Certificate)object).getEncoded()), Constants.SHA256);
                            object3 = new RefCertificate();
                            ((RefCertificate)object3).setId(string);
                            ((RefCertificate)object3).setContent(((Certificate)object).getEncoded());
                            ((RefCertificate)object3).setCapiCertificate(new it.actalis.ellips.capi.core.Certificate((X509Certificate)object));
                            transientDocument.addCert((RefCertificate)object3);
                        }
                        object2 = new it.actalis.ellips.capi.core.Certificate(Base64.decode((String)signedXMLEnvelope.getSignerCertificate(i)));
                        signatureInformation.setSignerName(((it.actalis.ellips.capi.core.Certificate)object2).getName());
                        object = Utils.calculateDigest(new ByteArrayInputStream(Base64.decode((String)signedXMLEnvelope.getSignerCertificate(i))), Constants.SHA256);
                        signatureInformation.setRefsCertId((String)object);
                    } else {
                        signatureInformation.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
                    }
                    transientDocument.addSignerInfo(signatureInformation);
                    continue;
                }
                if (bl) {
                    signatureInformation = XadesParserHelper.a(transientDocument, signedXMLEnvelope.getRawSignature(i));
                }
                if (signatureInformation == null) {
                    Object object3;
                    signatureInformation = new SignatureInformation();
                    Object object6 = signedXMLEnvelope.getCertificates(i);
                    object2 = new LinkedList();
                    if (object6 != null) {
                        object = ((AbstractSequentialList)object6).iterator();
                        while (object.hasNext()) {
                            X509Certificate x509Certificate = (X509Certificate)object.next();
                            object6 = Utils.calculateDigest(new ByteArrayInputStream(x509Certificate.getEncoded()), Constants.SHA256);
                            RefCertificate refCertificate = new RefCertificate();
                            refCertificate.setId((String)object6);
                            refCertificate.setContent(x509Certificate.getEncoded());
                            object3 = new it.actalis.ellips.capi.core.Certificate(x509Certificate);
                            refCertificate.setCapiCertificate((it.actalis.ellips.capi.core.Certificate)object3);
                            ((LinkedList)object2).add(object3);
                            transientDocument.addCert(refCertificate);
                        }
                        object = new it.actalis.ellips.capi.core.Certificate(Base64.decode((String)signedXMLEnvelope.getSignerCertificate(i)));
                        signatureInformation.setSignerName(((it.actalis.ellips.capi.core.Certificate)object).getName());
                        String string = Utils.calculateDigest(new ByteArrayInputStream(Base64.decode((String)signedXMLEnvelope.getSignerCertificate(i))), Constants.SHA256);
                        signatureInformation.setRefsCertId(string);
                    } else {
                        signatureInformation.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
                    }
                    signatureInformation.setSignatureInfo(signedXMLEnvelope.getRawSignature(i));
                    signatureInformation.setFormat(SignatureFormat.XADES);
                    signatureInformation.setContainerFormat(ContainerFormat.SELF);
                    signatureInformation.setContainsGraphometricInfo(false);
                    for (int j = 0; j < signedXMLEnvelope.getNumReference(i); ++j) {
                        Reference reference = signedXMLEnvelope.getReferenceInfo(i, j);
                        if (reference.getDigestInputStream() == null) continue;
                        object6 = new StreamInputHandler(reference.getDigestInputStream(), reference.getURI());
                        TransientDocument transientDocument2 = ParserUtils.parseDoc((InputHandler)object6, eventHandlerSelector, networkConfig);
                        transientDocument.addRefDoc(transientDocument2);
                        signatureInformation.addRefDoc(new ReferenceDoc(transientDocument2.getId(), bl2));
                    }
                    if (signedXMLEnvelope.getSigningTime(i) != null) {
                        try {
                            Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(signedXMLEnvelope.getSigningTime(i));
                            signatureInformation.setSignatureDate(dateFormat.format(date));
                        }
                        catch (ParseException parseException) {
                            a.error(parseException.getMessage(), (Throwable)parseException);
                        }
                    }
                    try {
                        signedXMLEnvelope.verify(i);
                        signatureInformation.setCorrupted(false);
                    }
                    catch (Exception exception) {
                        signatureInformation.setCorrupted(true);
                    }
                    transientDocument.addSignerInfo(signatureInformation);
                    try {
                        object = signedXMLEnvelope.getCounterSignature(i);
                        ((SignedXMLEnvelope)object).listSigners();
                    }
                    catch (CapiException capiException) {
                        object = null;
                    }
                    if (object != null && ((SignedXMLEnvelope)object).listSigners() != null && ((SignedXMLEnvelope)object).listSigners().length > 0) {
                        XadesParserHelper.a(transientDocument, (a)object, signatureInformation, dateFormat);
                    }
                    int n = signedXMLEnvelope.getNumSignatureTimeStamp(i);
                    for (int j = 0; j < n; ++j) {
                        try {
                            byte[] byArray = signedXMLEnvelope.getTimeStamp(i, j);
                            object3 = signedXMLEnvelope.getSignature(i);
                            if (byArray == null) continue;
                            object = DataHandlerBuilder.get().setBytes((byte[])object3).buildInput();
                            signatureInformation.addTimeStampToken(TSTUtils.tstToVol(transientDocument, byArray, (InputHandler)object, "", dateFormat));
                            continue;
                        }
                        catch (CapiException capiException) {}
                    }
                    for (RefCertificate refCertificate : transientDocument.getCerts()) {
                        if (((LinkedList)object2).contains(refCertificate.getCapiCertificate())) continue;
                        ((LinkedList)object2).add(refCertificate.getCapiCertificate());
                    }
                    if (signedXMLEnvelope.getCRLS(i) != null) {
                        for (CRL cRL : signedXMLEnvelope.getCRLS(i)) {
                            CRLUtils.addRefCrl(transientDocument.getCrls(), cRL, (LinkedList<it.actalis.ellips.capi.core.Certificate>)object2);
                        }
                    }
                    if (signedXMLEnvelope.getBasicOCSPResponses(i) == null) continue;
                    for (BasicOCSPResp basicOCSPResp : signedXMLEnvelope.getBasicOCSPResponses(i)) {
                        object3 = Utils.calculateDigest(new ByteArrayInputStream(basicOCSPResp.getEncoded()), Constants.SHA256);
                        object = new RefOcsp();
                        ((RefOcsp)object).setId((String)object3);
                        ((RefOcsp)object).setContent(basicOCSPResp.getEncoded());
                        transientDocument.addOcspresp((RefOcsp)object);
                    }
                    continue;
                }
                for (int j = 0; j < signedXMLEnvelope.getNumReference(i); ++j) {
                    object2 = signedXMLEnvelope.getReferenceInfo(i, j);
                    object = new StreamInputHandler(object2.getDigestInputStream(), object2.getURI());
                    TransientDocument transientDocument2 = ParserUtils.parseDoc((InputHandler)object, eventHandlerSelector, networkConfig);
                    transientDocument.addRefDoc(transientDocument2);
                    signatureInformation.addRefDoc(new ReferenceDoc(transientDocument2.getId(), bl2));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void a(TransientDocument transientDocument, a a2, SignatureInformation signatureInformation, DateFormat dateFormat) throws CapiException, CMSException, IOException, NoSuchAlgorithmException, FileNotFoundException, MalformedURLException, KeyStoreException, UnrecoverableKeyException, KeyManagementException, URISyntaxException, Exception {
        String[] stringArray = a2.listSigners();
        if (stringArray != null && stringArray.length > 0) {
            SignatureInformation signatureInformation2 = new SignatureInformation();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                void var9_16;
                Object object3 = a2.getCertificates(i);
                LinkedList<it.actalis.ellips.capi.core.Certificate> linkedList = new LinkedList<it.actalis.ellips.capi.core.Certificate>();
                if (object3 != null) {
                    object3 = ((AbstractSequentialList)object3).iterator();
                    while (object3.hasNext()) {
                        X509Certificate x509Certificate = (X509Certificate)object3.next();
                        String string = Utils.calculateDigest(new ByteArrayInputStream(x509Certificate.getEncoded()), Constants.SHA256);
                        Iterator iterator = new RefCertificate();
                        ((RefCertificate)((Object)iterator)).setId(string);
                        ((RefCertificate)((Object)iterator)).setContent(x509Certificate.getEncoded());
                        it.actalis.ellips.capi.core.Certificate certificate = new it.actalis.ellips.capi.core.Certificate(x509Certificate);
                        ((RefCertificate)((Object)iterator)).setCapiCertificate(certificate);
                        linkedList.add(certificate);
                        transientDocument.addCert((RefCertificate)((Object)iterator));
                    }
                    object3 = new it.actalis.ellips.capi.core.Certificate(Base64.decode((String)a2.getSignerCertificate(i)));
                    signatureInformation2.setSignerName(((it.actalis.ellips.capi.core.Certificate)object3).getName());
                } else {
                    signatureInformation2.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
                }
                signatureInformation2.setSignatureInfo(a2.getRawSignature(i));
                signatureInformation2.setCounterSignature(true);
                signatureInformation2.setFormat(SignatureFormat.XADES);
                signatureInformation2.setContainerFormat(ContainerFormat.SELF);
                signatureInformation2.setContainsGraphometricInfo(false);
                if (a2.getSigningTime(i) != null) {
                    try {
                        object3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(a2.getSigningTime(i));
                        signatureInformation2.setSignatureDate(dateFormat.format((Date)object3));
                    }
                    catch (Exception exception) {
                        a.error(exception.getMessage(), (Throwable)exception);
                    }
                }
                object3 = Utils.calculateDigest(new ByteArrayInputStream(Base64.decode((String)a2.getSignerCertificate(i))), Constants.SHA256);
                signatureInformation2.setRefsCertId((String)object3);
                try {
                    a2.verify(i);
                    signatureInformation2.setCorrupted(false);
                }
                catch (Exception exception) {
                    signatureInformation2.setCorrupted(true);
                }
                signatureInformation.addCounterSignaturesInformation(signatureInformation2);
                try {
                    a a3 = a2.getCounterSignature(i);
                    a3.listSigners();
                }
                catch (CapiException capiException) {
                    Object var9_15 = null;
                }
                if (var9_16 != null && var9_16.listSigners().length > 0) {
                    XadesParserHelper.a(transientDocument, (a)var9_16, signatureInformation2, dateFormat);
                }
                int n = a2.getNumSignatureTimeStamp(i);
                for (int j = 0; j < n; ++j) {
                    byte[] byArray = a2.getTimeStamp(i, j);
                    if (byArray == null) continue;
                    object3 = a2.getSignature(i);
                    object = DataHandlerBuilder.get().setBytes((byte[])object3).buildInput();
                    signatureInformation2.addTimeStampToken(TSTUtils.tstToVol(transientDocument, byArray, (InputHandler)object, "", dateFormat));
                }
                for (RefCertificate refCertificate : transientDocument.getCerts()) {
                    if (linkedList.contains(refCertificate.getCapiCertificate())) continue;
                    linkedList.add(refCertificate.getCapiCertificate());
                }
                if (a2.getCRLS(i) != null) {
                    for (CRL cRL : a2.getCRLS(i)) {
                        CRLUtils.addRefCrl(transientDocument.getCrls(), cRL, linkedList);
                    }
                }
                if (a2.getBasicOCSPResponses(i) == null) continue;
                for (BasicOCSPResp basicOCSPResp : a2.getBasicOCSPResponses(i)) {
                    object3 = Utils.calculateDigest(new ByteArrayInputStream(basicOCSPResp.getEncoded()), Constants.SHA256);
                    object = new RefOcsp();
                    ((RefOcsp)object).setId((String)object3);
                    ((RefOcsp)object).setContent(basicOCSPResp.getEncoded());
                    transientDocument.addOcspresp((RefOcsp)object);
                }
            }
        }
    }
}

