/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.vol.network;

import esecurity.validator.ValidatorConfig;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.ldap.LdapClient;
import it.actalis.ellips.capi.ldap.LdapException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.exception.NetworkException;
import it.actalis.vol.network.Helper;
import it.actalis.vol.utils.ConfigFile;
import it.actalis.vol.utils.Constants;
import org.slf4j.Logger;

public class LDAPhelper
implements Helper {
    private Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private int b = 0;
    private String c = null;
    private boolean d = false;
    private NetworkConfig e = null;
    private String f = null;

    public LDAPhelper(ConfigFile configFile) {
        this.d = Boolean.valueOf(configFile.getElement("ldap.proxy", "false"));
        if (this.d) {
            this.a.info("Use ldap proxy");
            this.c = configFile.getElement("ldap.proxy.host");
            configFile.getElement("ldap.proxy.port");
            configFile.getElement("ldap.proxy.user");
            configFile.getElement("ldap.proxy.pass");
            configFile.getElement("ldap.proxy.type");
            this.b = configFile.getIntElement("crl.ldap.timeout", 5000);
            if (this.c == null) {
                this.a.info("ldap.proxy.host == null use crl.ldap.proxy.host");
                this.c = configFile.getElement("crl.ldap.proxy.host");
                configFile.getElement("crl.ldap.proxy.port");
                configFile.getElement("crl.ldap.proxy.user");
                configFile.getElement("crl.ldap.proxy.pass");
                this.b = configFile.getIntElement("crl.ldap.timeout", 5000);
            }
        }
    }

    public LDAPhelper(ValidatorConfig validatorConfig) {
        this.d = Boolean.valueOf(validatorConfig.getElement("ldap.proxy", "false"));
        if (this.d) {
            this.a.info("Use ldap proxy");
            this.c = validatorConfig.getElement("ldap.proxy.host");
            validatorConfig.getElement("ldap.proxy.port");
            validatorConfig.getElement("ldap.proxy.user");
            validatorConfig.getElement("ldap.proxy.pass");
            validatorConfig.getElement("ldap.proxy.type");
            this.b = validatorConfig.getIntElement("crl.ldap.timeout", 5000);
            if (this.c == null) {
                this.a.info("ldap.proxy.host == null use crl.ldap.proxy.host");
                this.c = validatorConfig.getElement("crl.ldap.proxy.host");
                validatorConfig.getElement("crl.ldap.proxy.port");
                validatorConfig.getElement("crl.ldap.proxy.user");
                validatorConfig.getElement("crl.ldap.proxy.pass");
                this.b = validatorConfig.getIntElement("crl.ldap.timeout", 5000);
            }
            this.e = validatorConfig.getNetConfiguration();
        }
    }

    @Override
    public byte[] retrieveData() throws NetworkException {
        LDAPhelper lDAPhelper = this;
        return lDAPhelper.retrieveData(lDAPhelper.f);
    }

    @Override
    public byte[] retrieveData(String objectArray) throws NetworkException {
        try {
            objectArray = LdapClient.parseUrl((String)objectArray);
            LdapClient ldapClient = this.d ? new LdapClient(objectArray[0], 389, "", this.b, this.e) : new LdapClient(objectArray[0], 389, "", this.b);
            ldapClient = ldapClient.getEntry(objectArray[2]);
            byte[] byArray = ldapClient.getBinAttribute(0, objectArray[3]);
            objectArray = byArray;
            return byArray;
        }
        catch (LdapException ldapException) {
            throw new NetworkException(ldapException);
        }
    }

    @Override
    public void setUrl(String string) {
        this.f = string;
    }

    @Override
    public String getUrl() {
        return this.f;
    }
}

