/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import esecurity.dsd.core.PropertyContainer;
import esecurity.dsd.core.Utils;
import java.nio.CharBuffer;
import java.util.Set;
import java.util.TreeSet;

public class Domain
implements PropertyContainer {
    private JsonObject keyValues;
    private String id;

    public static Domain empty(String id) {
        return new Domain(id, new JsonObject());
    }

    public Domain(String id, PropertyContainer other) {
        this(id, new JsonObject());
        if (other != null) {
            other.keySet().forEach(k -> this.setValue((String)k, other.getValue((String)k)));
        }
    }

    public Domain(String id, JsonObject json) {
        this.id = id;
        this.keyValues = json;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Set<String> keySet() {
        TreeSet<String> keys = new TreeSet<String>();
        this.keyValues.entrySet().forEach(e -> keys.add((String)e.getKey()));
        return keys;
    }

    @Override
    public Object getValue(String key) {
        JsonElement element = this.keyValues.get(key);
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isBoolean()) {
                return element.getAsBoolean();
            }
            if (primitive.isNumber()) {
                return element.getAsNumber();
            }
            return element.getAsString();
        }
        if (element.isJsonArray()) {
            if (Utils.isBLOB(element.getAsJsonArray())) {
                JsonElement blob = element.getAsJsonArray().get(1);
                return blob.getAsString().toCharArray();
            }
            return element.getAsJsonArray();
        }
        return element.getAsJsonObject();
    }

    @Override
    public boolean setValue(String key, Object value) {
        if (this.keyValues.has(key)) {
            this.keyValues.remove(key);
        }
        if (value instanceof char[]) {
            JsonArray a = new JsonArray();
            a.add("BLOB");
            StringBuilder builder = new StringBuilder(CharBuffer.wrap((char[])value));
            a.add(builder.toString());
            this.keyValues.add(key, (JsonElement)a);
        } else if (value instanceof Boolean) {
            this.keyValues.addProperty(key, (Boolean)value);
        } else if (value instanceof Number) {
            this.keyValues.addProperty(key, (Number)value);
        } else if (value instanceof String) {
            this.keyValues.addProperty(key, (String)value);
        } else if (value instanceof JsonElement) {
            this.keyValues.add(key, (JsonElement)value);
        } else {
            return false;
        }
        return true;
    }
}

