/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf;

import esecurity.dts.TimeStampToken;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pades.PadesDssInfo;
import it.actalis.ellips.capi.pades.PadesUtils;
import it.actalis.ellips.capi.pdf.AutenticaBinding;
import it.actalis.ellips.capi.pdf.FeaInfo;
import it.actalis.ellips.capi.pdf.GraphometricInfo;
import it.actalis.ellips.capi.pdf.RevisionInformation;
import it.actalis.ellips.capi.pdf.SignedPDF;
import it.actalis.ellips.capi.pkcs7.SignedEnvelope;
import it.actalis.ellips.capi.pkcs7.StreamSignedEnvelope;
import it.actalis.ellips.capi.pkcs7.VerifyInfo;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.crypto.Cipher;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.COSFilterInputStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class PadesSignatureInformation {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private COSDictionary b;
    private COSDictionary c;
    private PDSignature d = null;
    private String e = null;
    private String f;
    private String g;
    private String h;
    private Calendar i;
    private boolean j = false;
    private String k = null;
    private List<Certificate> l;
    private SignedEnvelope m = null;
    private StreamSignedEnvelope n = null;
    private TimeStampToken o = null;
    private GraphometricInfo p = null;
    private AutenticaBinding q = null;
    private byte[] r = null;
    private Certificate s = null;
    private int t = 0;
    private RevisionInformation u = null;
    private boolean v;
    private boolean w = true;
    private PadesDssInfo x = null;
    private byte[] y;
    private PDSignatureField z;
    private boolean A = true;
    private FeaInfo B = null;

    public PadesSignatureInformation(PDSignatureField object, PadesDssInfo object2) {
        if (object.getValue() != null) {
            COSArray cOSArray;
            ASN1StreamParser aSN1StreamParser;
            String string;
            Object object3;
            this.w = false;
            this.z = object;
            this.b = object.getCOSObject();
            this.e = null;
            this.f = null;
            this.g = null;
            this.i = null;
            this.j = false;
            this.r = null;
            this.h = null;
            this.k = null;
            this.t = 0;
            this.x = object2;
            this.A = true;
            this.n = null;
            this.l = null;
            this.s = null;
            this.m = null;
            object = (COSString)this.b.getDictionaryObject(COSName.T);
            a.debug("[initialize][PadesSignatureInformation] Signatue Field Name: " + object.getString());
            this.h = object.getString();
            this.c = (COSDictionary)this.b.getDictionaryObject(COSName.V);
            object = this.c.getItem("biometric_data");
            if (object != null) {
                try {
                    object = (COSDictionary)((COSObject)object).getObject();
                    if (object.getString("version").equals("2.0.0")) {
                        object2 = (COSArray)object.getItem("g_blob");
                        object3 = new StringBuilder("");
                        for (int i = 0; i < object2.size(); ++i) {
                            ((StringBuilder)object3).append(object2.getString(i));
                        }
                        string = ((StringBuilder)object3).toString();
                        object2 = (COSArray)object.getItem("personal_data");
                        aSN1StreamParser = new String[object2.size()];
                        for (int i = 0; i < object2.size(); ++i) {
                            aSN1StreamParser[i] = object2.getString(i);
                        }
                        this.p = new GraphometricInfo(Base64.decode((String)string), Base64.decode((String)object.getString("Impronta_1")), Base64.decode((String)object.getString("Impronta_2")), Base64.decode((String)object.getString("Impr_signed")), object.getString("user_notice"), (String[])aSN1StreamParser);
                        cOSArray = (COSArray)object.getItem("byte_range");
                        long[] lArray = new long[2];
                        object = lArray;
                        lArray[0] = ((COSInteger)cOSArray.get(0)).longValue();
                        object[1] = (PDSignatureField)((COSInteger)cOSArray.get(1)).longValue();
                        this.p.a((long[])object);
                    }
                }
                catch (CapiException capiException) {
                    a.error("biometric_data non parsabile");
                }
            }
            if ((object = this.c.getItem("binding_dictionary")) != null) {
                try {
                    object2 = (COSDictionary)((COSObject)object).getObject();
                    if (object2.getString("version").equals("1.0.0")) {
                        object3 = object2.getString("SP_signed");
                        string = object2.getString("Imprt_SP");
                        aSN1StreamParser = (COSArray)object2.getItem("byte_range");
                        long[] lArray = new long[2];
                        object2 = lArray;
                        lArray[0] = ((COSInteger)aSN1StreamParser.get(0)).longValue();
                        object2[1] = ((COSInteger)aSN1StreamParser.get(1)).longValue();
                        this.q = new AutenticaBinding((String)object3, Base64.decode((String)string), "1.0.0", (long[])object2);
                        this.q.a((long[])object2);
                    }
                }
                catch (Throwable throwable) {
                    a.error("autentica_d non parsabile");
                }
            }
            if ((object2 = this.c.getItem("fea_dictionary")) != null) {
                try {
                    object3 = (COSDictionary)((COSObject)object2).getObject();
                    if (object3.getString("version").equals("2.0.0")) {
                        string = (COSArray)object3.getItem("fea_blob");
                        aSN1StreamParser = new StringBuilder("");
                        for (int i = 0; i < string.size(); ++i) {
                            aSN1StreamParser.append(string.getString(i));
                        }
                        object2 = aSN1StreamParser.toString();
                        cOSArray = (COSArray)object3.getItem("byte_range");
                        long[] lArray = new long[2];
                        object = lArray;
                        lArray[0] = ((COSInteger)cOSArray.get(0)).longValue();
                        object[1] = (PDSignatureField)((COSInteger)cOSArray.get(1)).longValue();
                        this.B = new FeaInfo(Base64.decode((String)object2));
                        object2 = object;
                        object = this.B;
                        this.B.a = (long[])object2;
                    }
                }
                catch (Throwable throwable) {
                    a.error("autentica_d non parsabile");
                }
            }
            object3 = (COSString)this.c.getDictionaryObject(COSName.CONTENTS);
            string = this.c.getDictionaryObject(COSName.getPDFName((String)"Cert"));
            if (string != null) {
                if (string instanceof COSString) {
                    this.k = ((COSString)string).getString();
                }
                if (string instanceof COSName) {
                    this.k = ((COSName)string).getName();
                }
            }
            this.r = object3.getBytes();
            try {
                aSN1StreamParser = new ASN1StreamParser(this.r);
                aSN1StreamParser.readObject().toASN1Primitive().getEncoded();
                this.y = Util.digestStreams((String)Constants.SHA1, (InputStream[])new InputStream[]{new ByteArrayInputStream(this.r)});
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
            }
            this.d = new PDSignature(this.c);
            this.f = this.d.getReason();
            this.g = this.d.getLocation();
            this.i = this.d.getSignDate();
            this.e = this.d.getSubFilter();
            a.debug("[initialize][PadesSignatureInformation] Location: {}", (Object)this.g);
            a.debug("[initialize][PadesSignatureInformation] Reason: {}", (Object)this.f);
            a.debug("[initialize][PadesSignatureInformation] SubFilter: {}", (Object)this.e);
            aSN1StreamParser = this.d.getCOSObject().getItem(COSName.getPDFName((String)"Reference"));
            this.t = PadesSignatureInformation.a((COSBase)aSN1StreamParser);
            if (a.isDebugEnabled()) {
                a.debug("[initialize][PadesSignatureInformation] byteRangeArray: ");
                if (this.getByteRangeArray() != null) {
                    for (int i = 0; i < this.getByteRangeArray().length; ++i) {
                        a.debug(" " + this.getByteRangeArray()[i]);
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean verify(InputHandler var1_1) {
        if (!this.w) {
            try {
                block69: {
                    var2_9 = null;
                    try {
                        var2_9 = new COSFilterInputStream(var1_1 /* !! */ .getInputAsNewStream(), this.getByteRangeArray());
                        var3_15 = this.getByteRangeArray();
                        var4_24 = var3_15[0] + var3_15[1] + 1;
                        var3_16 = var3_15[2] - var4_24;
                        PadesSignatureInformation.a(new COSFilterInputStream(var1_1 /* !! */ .getInputAsNewStream(), new int[]{var4_24, var3_16}));
                    }
                    catch (Exception var3_17) {
                        PadesSignatureInformation.a.debug("Exception getting signed content: " + var3_17.getMessage());
                        var3_17.printStackTrace();
                    }
                    if (var2_9 != null) {
                        if (this.d.getSubFilter().compareTo("adbe.x509.rsa_sha1") == 0) {
                            var3_18 = null;
                            try {
                                PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] subfilter adbe.x509.rsa_sha1, getting certificate...");
                                var1_1 /* !! */  = (COSString)this.c.getDictionaryObject(COSName.getPDFName((String)"Cert"));
                                var4_25 = var1_1 /* !! */ .getBytes();
                                var5_30 = CertificateFactory.getInstance("X.509");
                                var1_1 /* !! */  = new ByteArrayInputStream(var4_25);
                                var3_18 = var5_30.generateCertificates((InputStream)var1_1 /* !! */ );
                            }
                            catch (Exception var1_2) {
                                this.j = false;
                                PadesSignatureInformation.a.debug("no certificate found: " + var1_2.getMessage());
                            }
                            if (var3_18 == null || var3_18.isEmpty()) {
                                PadesSignatureInformation.a.debug("No certificate found");
                            } else {
                                PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] subfilter adbe.x509.rsa_sha1, digesting signed data ...");
                                try {
                                    var1_1 /* !! */  = MessageDigest.getInstance(Constants.SHA1, ProvUtils.bcProvider);
                                    var4_26 = new byte[4096];
                                    while ((var5_31 = var2_9.read((byte[])var4_26, 0, 4096)) != -1) {
                                        var1_1 /* !! */ .update((byte[])var4_26, 0, var5_31);
                                    }
                                    var1_1 /* !! */  = (InputHandler)var1_1 /* !! */ .digest();
                                    PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] digest done");
                                    var1_1 /* !! */  = new String(Hex.encode((byte[])var1_1 /* !! */ ), "US-ASCII").toUpperCase(Locale.ENGLISH);
                                    PadesSignatureInformation.a.debug("hash calcolato: " + (String)var1_1 /* !! */ );
                                    var3_18 = var3_18.iterator();
                                    var5_32 = null;
                                    if (var3_18.hasNext()) {
                                        v0 = (X509Certificate)var3_18.next();
                                        var4_26 = v0;
                                        var5_32 = v0.getPublicKey();
                                        var4_26 = new Certificate(var4_26.getEncoded());
                                        this.s = var4_26;
                                        PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] signerCertificate: " + var4_26.getName());
                                    } else {
                                        PadesSignatureInformation.a.debug("No certificate found");
                                    }
                                    this.l = new LinkedList<Certificate>();
                                    while (var3_18.hasNext()) {
                                        var4_26 = (X509Certificate)var3_18.next();
                                        this.l.add(new Certificate((X509Certificate)var4_26));
                                    }
                                    var4_26 = new ASN1StreamParser(this.r);
                                    var3_18 = ASN1OctetString.getInstance((Object)var4_26.readObject());
                                    var3_18 = var3_18.getOctets();
                                    PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] decrypting signature and getting hash ... ");
                                    var4_26 = Cipher.getInstance("RSA/ECB/NoPadding");
                                    var4_26.init(1, var5_32);
                                    var3_18 = var4_26.doFinal((byte[])var3_18);
                                    var3_18 = new String(Hex.encode((byte[])var3_18), "US-ASCII").toUpperCase(Locale.ENGLISH);
                                    PadesSignatureInformation.a.debug("hash from decryption: " + (String)var3_18);
                                    PadesSignatureInformation.a.debug("hash of pdf: " + (String)var1_1 /* !! */ );
                                    if (var3_18.endsWith((String)var1_1 /* !! */ )) {
                                        PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] adbe.x509.rsa_sha1 successfully verified");
                                        this.j = true;
                                    }
                                    PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] adbe.x509.rsa_sha1 not verified");
                                    this.j = false;
                                }
                                finally {
                                    IOUtils.closeQuietly((Closeable)var2_9);
                                }
                            }
                        } else if (this.d.getSubFilter().compareTo("adbe.pkcs7.sha1") == 0) {
                            PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] subfilter adbe.pkcs7.sha1, digesting signed data ...");
                            try {
                                var3_19 = MessageDigest.getInstance(Constants.SHA1, ProvUtils.bcProvider);
                                var1_1 /* !! */  = (InputHandler)new byte[4096];
                                while ((var4_24 = var2_9.read((byte[])var1_1 /* !! */ , 0, 4096)) != -1) {
                                    var3_19.update((byte[])var1_1 /* !! */ , 0, var4_24);
                                }
                                var4_27 = var3_19.digest();
                                PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] digest done");
                                this.m = new SignedEnvelope(this.r, true);
                                var3_19 = this.m.getData();
                                this.l = this.m.listCertificates();
                                this.s = this.m.getSignerCertificate(0);
                                var5_33 = this.m.getSigningTime(0, "yyyyMMddHHmmss");
                                PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] signing time: " + var5_33);
                                var1_1 /* !! */  = new SimpleDateFormat("yyyyMMddHHmmss");
                                if (var5_33 != null) {
                                    var1_1 /* !! */  = var1_1 /* !! */ .parse(var5_33);
                                    this.i = Calendar.getInstance();
                                    this.i.setTime((Date)var1_1 /* !! */ );
                                }
                                try {
                                    this.m.verify(0);
                                    this.j = true;
                                    PadesSignatureInformation.a.debug("[PadesSignatureInformation] valid signature");
                                }
                                catch (CapiException v1) {
                                    var1_1 /* !! */  = v1;
                                    if (v1.getErrorCode() == 3010) {
                                        PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation]  invalid signature");
                                        this.j = false;
                                    }
                                    throw var1_1 /* !! */ ;
                                }
                                if (var4_27 != null) {
                                    PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] comparing digest ...");
                                    if (Arrays.equals(var4_27, (byte[])var3_19)) ** GOTO lbl185
                                    PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] digest do not match");
                                    this.j = false;
                                }
                                PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] digest is null");
                                this.j = false;
                            }
                            finally {
                                IOUtils.closeQuietly((Closeable)var2_9);
                            }
                        } else if (this.d.getSubFilter().compareTo("ETSI.RFC3161") == 0) {
                            try {
                                this.o = new TimeStampToken(this.r);
                                this.l = this.o.listCertificates();
                                this.s = this.o.getTSACert();
                                if (this.o.getDate() != null) {
                                    this.i = Calendar.getInstance();
                                    this.i.setTime(this.o.getDate());
                                }
                                try {
                                    var3_20 = this.o.verifySignature();
                                    var1_5 = this.o.compare((InputStream)var2_9);
                                    if (!var3_20 || !var1_5) ** GOTO lbl185
                                    this.j = true;
                                    PadesSignatureInformation.a.debug("[PadesSignatureInformation] valid signature");
                                }
                                catch (CapiException v2) {
                                    var3_21 = v2;
                                    if (v2.getErrorCode() == 3010) {
                                        PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation]  invalid signature");
                                        this.j = false;
                                    }
                                    throw var3_21;
                                }
                            }
                            finally {
                                IOUtils.closeQuietly((Closeable)var2_9);
                            }
                        } else {
                            try {
                                this.n = new StreamSignedEnvelope((InputStream)new ByteArrayInputStream(this.r), (InputStream)var2_9);
                                this.l = this.n.listCertificates();
                                this.s = this.n.getSignerCertificate(0);
                                var3_22 = this.n.getSigningTime(0, "yyyyMMddHHmmss");
                                var1_1 /* !! */  = new SimpleDateFormat("yyyyMMddHHmmss");
                                if (var3_22 != null) {
                                    var4_28 = var1_1 /* !! */ .parse(var3_22);
                                    this.i = Calendar.getInstance();
                                    this.i.setTime(var4_28);
                                }
                                try {
                                    this.n.verify(0);
                                    this.j = true;
                                    PadesSignatureInformation.a.debug("[PadesSignatureInformation] valid signature");
                                }
                                catch (CapiException v3) {
                                    var4_29 = v3;
                                    if (v3.getErrorCode() == 3010) {
                                        PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation]  invalid signature");
                                        this.j = false;
                                        if (var4_29.getDetailReason() == VerifyInfo.FailureReason.MISSING_SIGNER_CERT.value()) {
                                            PadesSignatureInformation.a.debug("reason: MISSING_SIGNER_CERT");
                                        } else if (var4_29.getDetailReason() == VerifyInfo.FailureReason.WRONG_SIGNATURE.value()) {
                                            PadesSignatureInformation.a.debug("reason: WRONG_SIGNATURE");
                                        } else if (var4_29.getDetailReason() == VerifyInfo.FailureReason.INVALID_SIGNING_CERTIFICATE_AUTH_ATTRIBUTE.value()) {
                                            PadesSignatureInformation.a.debug("reason: INVALID_SIGNING_CERTIFICATE_AUTH_ATTRIBUTE");
                                        }
                                        break block69;
                                    }
                                    throw var4_29;
                                }
                            }
                            finally {
                                IOUtils.closeQuietly((Closeable)var2_9);
                            }
                        }
                    }
                }
                if (!this.j) {
                    PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] signature is invalid. Skip byterange check.");
                } else if (this.getByteRangeArray() != null) {
                    var3_23 = this.getByteRangeArray()[2] - this.getByteRangeArray()[1] - 2;
                    if (SignedPDF.bDebug) {
                        PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] calculatedSignatureSize: " + var3_23);
                    }
                    var1_8 = this.r.length << 1;
                    if (SignedPDF.bDebug) {
                        PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] realSignatureSize: " + var1_8);
                    }
                    var4_24 = this.getByteRangeArray()[2] + this.getByteRangeArray()[3];
                    if (SignedPDF.bDebug) {
                        PadesSignatureInformation.a.debug("[PadesSignatureInformation] calculatedRevisionSize: " + var4_24);
                    }
                    if (SignedPDF.bDebug) {
                        PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] First ByteRange Offset: " + this.getByteRangeArray()[0]);
                    }
                    if (this.getByteRangeArray()[0] != 0) {
                        PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] invalid byteRange: first byte is not 0");
                        this.j = false;
                    } else if (var3_23 != var1_8) {
                        PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] invalid byteRange: SignatureSize does not match");
                        this.j = false;
                    } else {
                        PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] valid byteRange");
                    }
                } else {
                    PadesSignatureInformation.a.debug("[initialize][PadesSignatureInformation] invalid byteRange");
                    this.j = false;
                }
            }
            catch (ParseException var2_10) {
                PadesSignatureInformation.a.error("Exception parsing signature: ", (Throwable)var2_10);
            }
            catch (GeneralSecurityException var2_11) {
                PadesSignatureInformation.a.error("Exception parsing signature: ", (Throwable)var2_11);
            }
            catch (UnsupportedEncodingException var2_12) {
                PadesSignatureInformation.a.error("Exception parsing signature: ", (Throwable)var2_12);
            }
            catch (IOException var2_13) {
                PadesSignatureInformation.a.error("Exception parsing signature: ", (Throwable)var2_13);
            }
            catch (CapiException var2_14) {
                PadesSignatureInformation.a.error("Exception parsing signature: ", (Throwable)var2_14);
            }
        }
        if (this.j && !this.isSignature_cover_all_revision()) {
            this.j = false;
        }
        return this.j;
    }

    private static byte[] a(COSFilterInputStream cOSFilterInputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        byte[] byArray = new byte[4096];
        while ((n = cOSFilterInputStream.read(byArray)) != -1) {
            if (byArray[0] == 60 || byArray[0] == 40) {
                byteArrayOutputStream.write(byArray, 1, n);
                continue;
            }
            if (byArray[n - 1] == 62 || byArray[n - 1] == 41) {
                byteArrayOutputStream.write(byArray, 0, n - 1);
                continue;
            }
            byteArrayOutputStream.write(byArray, 0, n);
        }
        cOSFilterInputStream.close();
        return COSString.parseHex((String)byteArrayOutputStream.toString("ISO-8859-1")).getBytes();
    }

    public COSDictionary getSignatureDictionary() {
        return this.c;
    }

    public String getName() {
        return this.h;
    }

    private static int a(COSBase cOSBase) {
        if (cOSBase != null && cOSBase instanceof COSArray) {
            if (SignedPDF.bDebug) {
                a.debug("[getCertificatioLevel] Found Reference");
            }
            for (int i = 0; i < ((COSArray)cOSBase).size(); ++i) {
                COSBase cOSBase2;
                COSBase cOSBase3 = ((COSArray)cOSBase).get(i);
                if (cOSBase3 == null || !(cOSBase3 instanceof COSDictionary)) continue;
                if (SignedPDF.bDebug) {
                    a.debug("[getCertificatioLevel] Found item");
                }
                if ((cOSBase2 = ((COSDictionary)cOSBase3).getItem(COSName.getPDFName((String)"Type"))) == null || !(cOSBase2 instanceof COSName)) continue;
                if (SignedPDF.bDebug) {
                    a.debug("[getCertificatioLevel] Type " + ((COSName)cOSBase2).getName());
                }
                if (((COSName)cOSBase2).getName().compareToIgnoreCase("SigRef") != 0 || (cOSBase2 = ((COSDictionary)cOSBase3).getItem(COSName.getPDFName((String)"TransformMethod"))) == null || !(cOSBase2 instanceof COSName)) continue;
                if (SignedPDF.bDebug) {
                    a.debug("[getCertificatioLevel] TransformMethod " + ((COSName)cOSBase2).getName());
                }
                if (((COSName)cOSBase2).getName().compareToIgnoreCase("DocMDP") != 0 && ((COSName)cOSBase2).getName().compareToIgnoreCase("FieldMDP") != 0 || (cOSBase3 = ((COSDictionary)cOSBase3).getDictionaryObject(COSName.getPDFName((String)"TransformParams"))) == null || !(cOSBase3 instanceof COSDictionary) || (cOSBase2 = ((COSDictionary)cOSBase3).getItem(COSName.getPDFName((String)"Type"))) == null || !(cOSBase2 instanceof COSName)) continue;
                if (SignedPDF.bDebug) {
                    a.debug("[getCertificatioLevel] Type " + ((COSName)cOSBase2).getName());
                }
                if (((COSName)cOSBase2).getName().compareToIgnoreCase("TransformParams") != 0 || (cOSBase3 = ((COSDictionary)cOSBase3).getItem(COSName.getPDFName((String)"P"))) == null || !(cOSBase3 instanceof COSInteger)) continue;
                if (SignedPDF.bDebug) {
                    a.debug("[getCertificatioLevel] P " + ((COSInteger)cOSBase3).intValue());
                }
                return ((COSInteger)cOSBase3).intValue();
            }
        }
        return 0;
    }

    public int getCertificationLevel() {
        return this.t;
    }

    public List<Certificate> getCertificatesArray() {
        return this.l;
    }

    public String getReason() {
        return this.f;
    }

    public String getLocation() {
        return this.g;
    }

    public String getSignName() {
        return this.h;
    }

    public Calendar getSignDate() {
        return this.i;
    }

    public String getSubFilter() {
        return this.e;
    }

    public static Logger getLogger() {
        return a;
    }

    public COSDictionary getFieldDictionary() {
        return this.b;
    }

    public boolean isValidSignature() {
        return this.j;
    }

    public String getCertificateInSigDictionary() {
        return this.k;
    }

    public int[] getByteRangeArray() {
        COSArray cOSArray = (COSArray)this.c.getDictionaryObject(COSName.BYTERANGE);
        if (cOSArray != null) {
            int[] nArray = new int[cOSArray.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = cOSArray.getInt(i);
            }
            return nArray;
        }
        return null;
    }

    public GraphometricInfo getGraphometricInfo() {
        return this.p;
    }

    public AutenticaBinding getAutentica_info() {
        return this.q;
    }

    public FeaInfo getFeaInfo() {
        return this.B;
    }

    public byte[] getP7Detached() {
        return Util.copyOf((byte[])this.r, (int)this.r.length);
    }

    public RevisionInformation getRevision() {
        return this.u;
    }

    public void setRevision(RevisionInformation revisionInformation) {
        this.u = revisionInformation;
    }

    public boolean isSignature_cover_all_revision() {
        return this.v;
    }

    public void setSignature_cover_all_revision(boolean bl) {
        this.v = bl;
    }

    public byte[] getSignatureTimeStampToken() throws CapiException {
        if (this.n != null) {
            return this.n.getSignatureTimeStampToken(0);
        }
        if (this.m != null) {
            return this.m.getSignatureTimeStampToken(0);
        }
        return null;
    }

    public boolean hasSigningCertificateV2() throws CapiException {
        if (this.n != null) {
            return this.n.hasSigningCertificateV2(0);
        }
        if (this.m != null) {
            return this.m.hasSigningCertificateV2(0);
        }
        if (this.o != null) {
            return this.o.hasSigningCertificateV2();
        }
        return false;
    }

    public String getSigningCertificateV2HashAlg() throws CapiException {
        if (this.n != null) {
            return this.n.getSigningCertificateV2HashAlg(0);
        }
        if (this.m != null) {
            return this.m.getSigningCertificateV2HashAlg(0);
        }
        if (this.o != null) {
            return this.o.getSigningCertificateV2HashAlg();
        }
        return null;
    }

    public boolean hasSigningCertificate() throws CapiException {
        if (this.n != null) {
            return this.n.hasSigningCertificate(0);
        }
        if (this.m != null) {
            return this.m.hasSigningCertificate(0);
        }
        if (this.o != null) {
            return this.o.hasSigningCertificate();
        }
        return false;
    }

    public String getSignerDigestAlg() throws CapiException {
        if (this.n != null) {
            return this.n.getSignerDigestAlg(0);
        }
        if (this.m != null) {
            return this.m.getSignerDigestAlg(0);
        }
        if (this.o != null) {
            return this.o.getSignerDigestAlg();
        }
        return Constants.SHA1;
    }

    public Certificate getSignerCertificate() throws CapiException {
        return this.s;
    }

    public byte[] getSignature() throws CapiException {
        if (this.n != null) {
            return this.n.getSignature(0);
        }
        if (this.m != null) {
            return this.m.getSignature(0);
        }
        return this.r;
    }

    public String getSignerEncryptionAlg() throws CapiException {
        if (this.n != null) {
            return this.n.getSignerEncryptionAlg(0);
        }
        if (this.m != null) {
            return this.m.getSignerEncryptionAlg(0);
        }
        if (this.o != null) {
            this.o.getSignerEncryptionAlg();
        }
        return "RSA";
    }

    public boolean nextRevisionsUpdateObject() {
        if (this.getRevision() != null && this.getRevision().getNextRevision() != null) {
            for (RevisionInformation revisionInformation = this.getRevision().getNextRevision(); revisionInformation != null; revisionInformation = revisionInformation.getNextRevision()) {
                if (!revisionInformation.isUpdatePreviousObject()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean nextRevisionsSigned() {
        if (this.getRevision() != null && this.getRevision().getNextRevision() != null) {
            for (RevisionInformation revisionInformation = this.getRevision().getNextRevision(); revisionInformation != null; revisionInformation = revisionInformation.getNextRevision()) {
                if (!revisionInformation.isSignedRevision()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean nextRevisionUpdateField() {
        if (this.getRevision() != null && this.getRevision().getNextRevision() != null) {
            for (RevisionInformation revisionInformation = this.getRevision().getNextRevision(); revisionInformation != null; revisionInformation = revisionInformation.getNextRevision()) {
                if (!revisionInformation.isUpdatePreviousField()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean nextRevisionUpdateAnnotation() {
        if (this.getRevision() != null && this.getRevision().getNextRevision() != null) {
            for (RevisionInformation revisionInformation = this.getRevision().getNextRevision(); revisionInformation != null; revisionInformation = revisionInformation.getNextRevision()) {
                if (!revisionInformation.isUpdatePreviousAnnotation()) continue;
                return true;
            }
        }
        return false;
    }

    public byte[] getMessageDigest() throws CapiException {
        if (this.n != null) {
            return this.n.getMessageDigest(0);
        }
        if (this.m != null) {
            return this.m.getMessageDigest(0);
        }
        if (this.o != null) {
            return this.o.getHashedMessage();
        }
        return null;
    }

    public byte[] getRawSignature() throws CapiException {
        if (this.n != null) {
            return this.n.getSignedDataProxy().getRawSignature(0);
        }
        if (this.m != null) {
            return this.m.getSignedDataProxy().getRawSignature(0);
        }
        if (this.o != null) {
            try {
                return this.o.toByteArray(false, true);
            }
            catch (IOException iOException) {
                throw new CapiException(iOException.getMessage(), 50040);
            }
        }
        return null;
    }

    public LinkedList<X509Certificate> getCerts() {
        COSDictionary cOSDictionary;
        LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
        if (this.x != null && (cOSDictionary = (COSDictionary)this.x.getDicDSS().getDictionaryObject("VRI")) != null) {
            try {
                String string = new String(Hex.encode((byte[])this.y)).toUpperCase();
                a.debug("VRI id:{}", (Object)string);
                cOSDictionary = (COSDictionary)cOSDictionary.getDictionaryObject(string);
                if (cOSDictionary != null && (cOSDictionary = PadesUtils.parseArray(cOSDictionary, "Cert")) != null) {
                    for (int i = 0; i < cOSDictionary.size(); ++i) {
                        Object object = (COSStream)cOSDictionary.getObject(i);
                        object = Util.getBytesFromInputStream((InputStream)object.createRawInputStream());
                        object = new Certificate((byte[])object);
                        linkedList.add(object.getInternalCert());
                    }
                }
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return linkedList;
    }

    public LinkedList<BasicOCSPResp> getOcsps() {
        COSDictionary cOSDictionary;
        LinkedList<BasicOCSPResp> linkedList = new LinkedList<BasicOCSPResp>();
        if (this.x != null && (cOSDictionary = (COSDictionary)this.x.getDicDSS().getDictionaryObject("VRI")) != null) {
            try {
                String string = new String(Hex.encode((byte[])this.y)).toUpperCase();
                a.debug("VRI id:{}", (Object)string);
                cOSDictionary = (COSDictionary)cOSDictionary.getDictionaryObject(string);
                if (cOSDictionary != null && (cOSDictionary = PadesUtils.parseArray(cOSDictionary, "OCSP")) != null) {
                    for (int i = 0; i < cOSDictionary.size(); ++i) {
                        Object object = (COSStream)cOSDictionary.getObject(i);
                        object = Util.getBytesFromInputStream((InputStream)object.createRawInputStream());
                        object = (BasicOCSPResp)new OCSPResp((byte[])object).getResponseObject();
                        linkedList.add((BasicOCSPResp)object);
                    }
                }
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return linkedList;
    }

    public LinkedList<CRL> getCrls() {
        COSDictionary cOSDictionary;
        LinkedList<CRL> linkedList = new LinkedList<CRL>();
        if (this.x != null && (cOSDictionary = (COSDictionary)this.x.getDicDSS().getDictionaryObject("VRI")) != null) {
            try {
                String string = new String(Hex.encode((byte[])this.y)).toUpperCase();
                a.debug("VRI id:{}", (Object)string);
                cOSDictionary = (COSDictionary)cOSDictionary.getDictionaryObject(string);
                if (cOSDictionary != null && (cOSDictionary = PadesUtils.parseArray(cOSDictionary, "CRL")) != null) {
                    for (int i = 0; i < cOSDictionary.size(); ++i) {
                        COSStream cOSStream = (COSStream)cOSDictionary.getObject(i);
                        cOSStream = new CRL(cOSStream.createRawInputStream());
                        linkedList.add((CRL)cOSStream);
                    }
                }
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return linkedList;
    }

    public boolean isEmpty() {
        return this.w;
    }

    public void setEmpty(boolean bl) {
        this.w = bl;
    }

    final PDSignatureField a() {
        return this.z;
    }

    public PadesDssInfo getPadesDssInfo() {
        return this.x;
    }

    public String getVri() {
        String string = new String(Hex.encode((byte[])this.y)).toUpperCase();
        return string;
    }

    public boolean hasMultipleSigners() {
        boolean bl = false;
        if (this.n != null) {
            boolean bl2 = bl = this.n.getSignedDataProxy().getNumberOfSigners() > 1;
        }
        if (this.m != null) {
            bl = this.m.getSignedDataProxy().getNumberOfSigners() > 1;
        }
        return bl;
    }

    public boolean hasRFC5652_SignedAttrDER() {
        return this.A;
    }

    public void setRFC5652_SignedAttrDER(boolean bl) {
        this.A = bl;
    }
}

