/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.tsl.CertChain;
import esecurity.tsl.ChainEntry;
import esecurity.tsl.ServiceDbItem;
import esecurity.tsl.TSLServiceTypeIdentifiers;
import esecurity.validator.bean.ValidatedBean;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.utils.ValidatedDocumentUtils;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;
import java.util.List;

public class StepX509ValidateCertificateChain
extends MultipleValidationSubStepImpl {
    public StepX509ValidateCertificateChain() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        boolean bl;
        ValidatedCertificate validatedCertificate;
        Object object;
        linkedList = new LinkedList();
        if (validationContextParameters.getSignerCertificate() == null) {
            linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
            return linkedList;
        }
        ValidatedCertificate validatedCertificate2 = validationContextParameters.getSignerCertificate();
        CertChain certChain = validatedCertificate2.getCert().getValidatedChain();
        if (certChain == null || certChain.getStartEntry() == null) {
            linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0028_NO_CHAIN_FOUND, this.getClass().getName()));
            return linkedList;
        }
        boolean bl2 = certChain.getStartEntry().getParent() == null;
        if (!bl2) {
            ChainEntry chainEntry = certChain.getStartEntry().getParent();
            Certificate certificate = chainEntry.getCert();
            certificate.setValidatedChain(new CertChain(chainEntry));
            validatedCertificate2.setIssuer(validationContextParameters.getValidator().validate(certificate, validationContextParameters.getProfile(), validationContextParameters.getValidationDate()));
        }
        boolean bl3 = validationContextParameters.getSignature() != null && validationContextParameters.getSignature().getFormat() != null && validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST);
        boolean bl4 = false;
        boolean bl5 = true;
        List<ServiceDbItem> list = certChain.getStartEntry().getCertDbItem();
        if (!list.isEmpty()) {
            object = list.get(0).getServiceType();
            boolean bl6 = object.equals((Object)TSLServiceTypeIdentifiers.CaIssuer) ? list.get(0).isValidSignature() : (bl4 = !(bl5 = object.equals((Object)TSLServiceTypeIdentifiers.SignerCertificate)));
        }
        if (!bl4 && bl2) {
            if (bl3) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0014_INVALID_CERT_TSA_AUTHORITY, this.getClass().getName()));
            } else {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0002_INVALID_CERT_AUTHORITY, this.getClass().getName()));
            }
        } else if (!bl4 && validatedCertificate2.getIssuer() != null) {
            object = validatedCertificate2.getIssuer();
            if (ValidatedDocumentUtils.hasMessage((ValidatedBean)object, ValidatorMessageEnum.EC0014_INVALID_CERT_TSA_AUTHORITY)) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0014_INVALID_CERT_TSA_AUTHORITY, this.getClass().getName()));
            } else if (ValidatedDocumentUtils.hasMessage((ValidatedBean)object, ValidatorMessageEnum.EC0002_INVALID_CERT_AUTHORITY)) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0002_INVALID_CERT_AUTHORITY, this.getClass().getName()));
            }
        }
        boolean bl7 = certChain.isMatchProfile(validationContextParameters.getProfile(), validationContextParameters.getCalculatedValidationDate());
        if (!bl7) {
            linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0023_CERT_AUTHORITY_NOT_VALID_FOR_PROFILE, this.getClass().getName()));
        }
        if (bl5) {
            validatedCertificate = validatedCertificate2;
            bl = bl7;
        } else {
            validatedCertificate = validatedCertificate2;
            bl = bl4 && bl7;
        }
        validatedCertificate.setCertTrusted(bl);
        return linkedList;
    }
}

