/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.cades;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.pkcs.SignedData;

public class CadesStepSignatureETSICMSSignedDataCheck
extends SingleValidationSubStepImpl {
    public CadesStepSignatureETSICMSSignedDataCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> cloneable, ValidationContextParameters validationContextParameters) {
        if (validationContextParameters == null) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        cloneable = validationContextParameters.getCalculatedValidationDate().getDate();
        if (validationContextParameters.getProfile() != null && validationContextParameters.getProfile() == ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE || validationContextParameters.getProfile() == ValidationProfile.GRAPHOMETRIC_SIGNATURE_PROFILE) {
            if (((Date)cloneable).before(Constants.DPCM_CNIPA_45_2009)) {
                return null;
            }
            if (validationContextParameters.getSignature() == null) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
            }
            if (validationContextParameters.getSignature().getSignerInfoData() == null) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
            }
            if (validationContextParameters.getSignature().getSignerInfoData().getSignerInfo().getAuthenticatedAttributes() != null) {
                ASN1Set aSN1Set = validationContextParameters.getSignature().getSignerInfoData().getSignerInfo().getAuthenticatedAttributes();
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                for (int i = 0; i < aSN1Set.size(); ++i) {
                    String string = aSN1Set.getObjectAt(i) instanceof DERSequence ? ((DERSequence)aSN1Set.getObjectAt(i)).getObjectAt(0).toString() : ((DLSequence)aSN1Set.getObjectAt(i)).getObjectAt(0).toString();
                    string.equals(CMSAttributes.messageDigest.getId());
                    if (string.equals(CMSAttributes.contentType.getId())) {
                        bl = true;
                    }
                    if (string.equals(SignedData.id_aa_signingCertificate.getId())) {
                        bl2 = true;
                    }
                    if (string.equals(SignedData.id_aa_signingCertificateV2.getId())) {
                        bl3 = true;
                    }
                    if (!string.equals(CMSAttributes.signingTime.getId())) continue;
                    bl4 = true;
                }
                if (!bl4) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0007_NOSIGNTIME, new Object[0]);
                }
                if (!bl2 && !bl3) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0005_CADES_NOSIGNCERT, new Object[0]);
                }
                if (!bl3 && ((Date)cloneable).before(Constants.DPCM_AGID_121_2019)) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0006_CADES_NOSIGNCERTV2, new Object[0]);
                }
                if (validationContextParameters.getSignature().isCounterSignature() && bl) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0020_COUNTER_SIGNATURE_WITH_CONTENT_TYPE, new Object[0]);
                }
            } else {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0004_CADES_NOSIGNEDATTRS, new Object[0]);
            }
        }
        return null;
    }
}

