/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import esecurity.dts.Client;
import esecurity.dts.DTSClient;
import esecurity.dts.TimeStampToken;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.cms.CadesSignedDataProxy;
import it.actalis.ellips.capi.core.Base64OutputStream;
import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.HttpsClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.net.HTTP_URLConnection;
import it.actalis.ellips.capi.pkcs7.CapiSignerInformation;
import it.actalis.ellips.capi.pkcs7.CounterSignedEnvelope;
import it.actalis.ellips.capi.pkcs7.RFC5652.VerificationResult;
import it.actalis.ellips.capi.pkcs7.SignedEnvelope;
import it.actalis.ellips.capi.pkcs7.VerRsContentSignerBuilder;
import it.actalis.ellips.capi.pkcs7.VerRsSignerInfoGenerator;
import it.actalis.ellips.capi.pkcs7.VerifyInfo;
import it.actalis.ellips.capi.provider.Token;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSProcessableFile;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;

public class StreamSignedEnvelope {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    public static final String SHA1 = SignedEnvelope.SHA1;
    public static final String SHA256 = SignedEnvelope.SHA256;
    private CMSSignedDataParser b = null;
    private MessageDigest c = null;
    private MessageDigest d = null;
    private String e = SHA256;
    private List<String> f = new LinkedList<String>();
    private List<Certificate> g = new LinkedList<Certificate>();
    private List<VerifyInfo> h = new LinkedList<VerifyInfo>();
    protected List<X509Certificate> certsVector = new LinkedList<X509Certificate>();
    private File i = null;
    private int j = -1;
    private String k = null;
    private String l = null;
    private String m = null;
    private boolean n = true;
    private HttpsClient o = null;
    private String p = null;
    private String q = null;
    private DTSClient r = null;
    private int s = 1;
    private boolean t = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StreamSignedEnvelope(InputStream inputStream, OutputStream outputStream) throws CapiException {
        try {
            if (inputStream == null) {
                throw new CapiException("Null data", 1001);
            }
            this.s = 1;
            StreamSignedEnvelope.a("mode", this.s, 1, 1);
            this.b();
            OutputStream outputStream2 = outputStream;
            InputStream inputStream2 = inputStream;
            StreamSignedEnvelope streamSignedEnvelope = this;
            try {
                DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
                streamSignedEnvelope.b = new CMSSignedDataParser(digestCalculatorProvider, inputStream2);
                a.debug("parsed implicit signed data ok");
                streamSignedEnvelope = streamSignedEnvelope.b.getSignedContent();
                if (streamSignedEnvelope == null) {
                    a.debug("no content found into envelope... is detached...");
                    throw new CapiException("Envelope is detached", 50000);
                }
                inputStream2 = streamSignedEnvelope.getContentStream();
                if (inputStream2 == null) {
                    a.debug("no content found into envelope... is detached...");
                    throw new CapiException("Envelope is detached", 50000);
                }
                if (outputStream2 != null) {
                    a.debug("parsed implicit: copying data...");
                    StreamSignedEnvelope.a(inputStream2, outputStream2, 8192);
                } else {
                    streamSignedEnvelope.drain();
                    a.debug("parsed implicit: skipping data...");
                }
                a.debug("parsed implicit: data ok");
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
                throw capiException;
            }
            catch (CMSException cMSException) {
                a.error("Formato busta non valido {}", (Object)cMSException.getMessage());
                throw new CapiException("Envelope format unknown or not implemented", 50023);
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("Error writing envelope content", 50025);
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Internal error", 50050);
            }
            this.a();
            a.debug("getting signers DN OK");
            this.j = 3;
        }
        catch (CapiException capiException) {
            try {
                CapiException capiException2 = capiException;
                throw capiException;
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    if (outputStream == null) throw throwable;
                    outputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        try {
            if (outputStream == null) return;
            outputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StreamSignedEnvelope(InputStream inputStream, InputStream inputStream2) throws CapiException {
        try {
            if (inputStream == null) {
                throw new CapiException("Null data", 1001);
            }
            if (inputStream2 == null) {
                throw new CapiException("Null data", 1001);
            }
            this.s = 2;
            StreamSignedEnvelope.a("mode", this.s, 2, 2);
            this.b();
            InputStream inputStream3 = inputStream2;
            InputStream inputStream4 = inputStream;
            StreamSignedEnvelope streamSignedEnvelope = this;
            try {
                DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
                streamSignedEnvelope.b = new CMSSignedDataParser(digestCalculatorProvider, new CMSTypedStream(inputStream3), inputStream4);
                streamSignedEnvelope.b.getSignedContent().drain();
                a.debug("parsed explicit signed data ok");
            }
            catch (CMSException cMSException) {
                a.error(cMSException.getMessage(), (Throwable)cMSException);
                throw new CapiException("Envelope format unknown or not implemented", 50023, (Throwable)cMSException);
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Internal error", 50050, (Throwable)exception);
            }
            this.a();
            a.debug("decode > Getting signers DN OK");
            this.j = 3;
        }
        catch (Exception exception) {
            try {
                a.error(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Exception " + exception.getMessage(), 50050);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Exception exception2) {}
                try {
                    inputStream2.close();
                    throw throwable;
                }
                catch (Exception exception3) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        try {
            inputStream2.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean isDERSignedData(InputStream inputStream) {
        a.debug("[isSignedData] Checking if content is a DER Signed Data ...");
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(inputStream);
        aSN1StreamParser = (ASN1SequenceParser)aSN1StreamParser.readObject();
        aSN1StreamParser = aSN1StreamParser.readObject();
        if (aSN1StreamParser == null || !(aSN1StreamParser instanceof ASN1ObjectIdentifier)) {
            throw new CapiException("Invalid ContentInfo", 50040);
        }
        if ((aSN1StreamParser = (ASN1ObjectIdentifier)aSN1StreamParser).getId().compareToIgnoreCase(CMSObjectIdentifiers.signedData.getId()) != 0) {
            throw new CapiException(aSN1StreamParser.getId() + "  is not SignedData OID", 50040);
        }
        a.debug("[isSignedData] Found SignedData OID Content Type.");
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
            try {
                inputStream.close();
            }
            catch (IOException iOException2) {}
            return false;
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            {
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return false;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean isPEMSignedData(InputStream inputStream) {
        Object object;
        BufferedReader bufferedReader;
        ByteArrayInputStream byteArrayInputStream;
        block44: {
            byteArrayInputStream = null;
            bufferedReader = null;
            object = new byte[256];
            inputStream.read((byte[])object, 0, 256);
            String string = new String((byte[])object);
            byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            if (string.startsWith("-----BEGIN PKCS7-----")) {
                bufferedReader.readLine();
            }
            String string2 = bufferedReader.readLine();
            object = string2;
            if (string2 != null && object.length() > 40) break block44;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            return false;
        }
        object = Base64.decode((String)object.substring(0, 39));
        boolean bl = StreamSignedEnvelope.isDERSignedData(new ByteArrayInputStream((byte[])object));
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        try {
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return bl;
        catch (FileNotFoundException fileNotFoundException) {
            a.error(fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            try {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            return false;
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
            {
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {}
                    try {
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                    }
                    catch (IOException iOException3) {}
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException4) {}
                    throw throwable;
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException5) {}
            try {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
            catch (IOException iOException6) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException7) {}
            return false;
        }
    }

    private void a() throws CapiException {
        SignerInformationStore signerInformationStore;
        Store store;
        a.debug("getting certificates...");
        try {
            store = this.b.getCertificates();
        }
        catch (CMSException cMSException) {
            a.error(cMSException.getMessage(), (Throwable)cMSException);
            throw new CapiException("CMSException", 50050);
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Exception " + exception.getMessage(), 50050);
        }
        try {
            if (store == null) {
                a.debug("no certificates found!");
            }
            signerInformationStore = Certificate.getX509CertificatesFromStore((Store)store);
            this.certsVector = new Vector<X509Certificate>(Arrays.asList(signerInformationStore));
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("StoreException", 50050);
        }
        a.debug(this.certsVector.size() + " certificates found");
        a.debug("getting signers DN...");
        try {
            Vector<SignerInformation> vector;
            CMSAbsentContent cMSAbsentContent;
            signerInformationStore = this.b.getSignerInfos();
            ArrayList<CapiSignerInformation> arrayList = new ArrayList<CapiSignerInformation>();
            if (this.s == 2) {
                cMSAbsentContent = new CMSAbsentContent();
            } else {
                vector = null;
                try {
                    vector = (Vector<SignerInformation>)IOUtils.toByteArray((InputStream)this.b.getSignedContent().getContentStream());
                }
                catch (IOException iOException) {
                    a.error(iOException.getMessage(), (Throwable)iOException);
                }
                cMSAbsentContent = new CMSProcessableByteArray((byte[])vector);
            }
            for (SignerInformation signerInformation : signerInformationStore.getSigners()) {
                arrayList.add(new CapiSignerInformation(signerInformation, (CMSTypedData)cMSAbsentContent));
            }
            vector = new Vector<SignerInformation>(arrayList);
            a.debug("signerInformVector size = " + vector.size());
            this.f = new Vector<String>();
            this.g = new Vector<Certificate>();
            this.h = new Vector<VerifyInfo>();
            SignedEnvelope.verifySigners(store, vector, this.f, this.g, this.h, this.getSignedDataProxy());
            return;
        }
        catch (CMSException cMSException) {
            a.error(cMSException.getMessage(), (Throwable)cMSException);
            throw new CapiException(cMSException.getMessage(), 50050);
        }
    }

    public boolean hasRFC5652_SignedAttrDER(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        VerifyInfo verifyInfo = this.h.get(n);
        return verifyInfo.e();
    }

    public String[] listSigners() {
        String[] stringArray = new String[this.f.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.f.get(i);
        }
        return stringArray;
    }

    public List<Certificate> listCertificates() throws CapiException {
        try {
            LinkedList<Certificate> linkedList = new LinkedList<Certificate>();
            for (int i = 0; i < this.certsVector.size(); ++i) {
                X509Certificate x509Certificate = this.certsVector.get(i);
                x509Certificate = new Certificate(x509Certificate);
                linkedList.add((Certificate)x509Certificate);
            }
            return linkedList;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
    }

    public Certificate verify(int n) throws CapiException {
        Boolean bl;
        if (this.b == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (n < 0 || n >= this.f.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.j == 1) {
            this.c();
        }
        if ((bl = this.h.get(n).a()).booleanValue()) {
            return this.g.get(n);
        }
        VerifyInfo verifyInfo = this.h.get(n);
        throw new CapiException("Invalid signature", 3010, verifyInfo.a.value());
    }

    public Certificate getSignerCertificate(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (n < 0 || n >= this.f.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.g.get(n);
    }

    public byte[] getSignature(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Object object = this.b.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= ((Vector)object).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)((Vector)object).elementAt(n);
            return signerInformation.getSignature();
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Cannot get signature value", 50023);
        }
    }

    public boolean hasSigningCertificateV2(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (n < 0 || n >= this.f.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        VerifyInfo verifyInfo = this.h.get(n);
        return verifyInfo.c();
    }

    public boolean hasSigningCertificate(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (n < 0 || n >= this.f.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        VerifyInfo verifyInfo = this.h.get(n);
        return verifyInfo.b();
    }

    public boolean hasNoSignerAttribute(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (n < 0 || n >= this.f.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            Object object = this.b.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= ((Vector)object).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)((Vector)object).elementAt(n);
            boolean bl = SignedEnvelope.hasNoSignedAttribute(signerInformation);
            return bl;
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            return false;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public int getSignatureInvalidityReason(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (n < 0 || n >= this.f.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        VerifyInfo verifyInfo = this.h.get(n);
        return verifyInfo.a.value();
    }

    public VerificationResult getSignatureVerificationResult(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (n < 0 || n >= this.f.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.h.get(n).getVerificationResult();
    }

    public String getSigningCertificateV2HashAlg(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.hasSigningCertificateV2(n)) {
            return null;
        }
        if (n < 0 || n >= this.f.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        Object object = this.g.get(n);
        try {
            Object object2 = this.b.getSignerInfos();
            object2 = object2.getSigners();
            object2 = new Vector(object2);
            if (n < 0 || n >= ((Vector)object2).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            Object object3 = (SignerInformation)((Vector)object2).elementAt(n);
            object = object.getInternalCert();
            object3 = SignedEnvelope.getSigningCertificateV2HashAlg(object3, (X509Certificate)object);
            return object3;
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            return null;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public String getSignerDigestAlg(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Object object = this.b.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= ((Vector)object).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)((Vector)object).elementAt(n);
            a.debug("[getSignerDigestAlg] " + signerInformation.getDigestAlgOID());
            if (signerInformation.getDigestAlgOID().equalsIgnoreCase(SHA256)) {
                return Constants.SHA256;
            }
            if (signerInformation.getDigestAlgOID().equalsIgnoreCase(SHA1)) {
                return Constants.SHA1;
            }
            return signerInformation.getDigestAlgOID();
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Cannot get signer digest algorithm oid " + exception.getMessage(), 50023);
        }
    }

    public String getSignerDigestAlgOid(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Object object = this.b.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= ((Vector)object).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)((Vector)object).elementAt(n);
            a.debug("[getSignerDigestAlg] " + signerInformation.getDigestAlgOID());
            return signerInformation.getDigestAlgOID();
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Cannot get signer digest algorithm oid " + exception.getMessage(), 50023);
        }
    }

    public String getSignerEncryptionAlg(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Object object = this.b.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= ((Vector)object).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)((Vector)object).elementAt(n);
            if (signerInformation.getEncryptionAlgOID().equalsIgnoreCase(CMSSignedDataGenerator.ENCRYPTION_RSA)) {
                a.debug("[getEncryptionAlgOID] is ENCRYPTION_RSA");
                return "RSA";
            }
            a.debug("[getEncryptionAlgOID] " + signerInformation.getEncryptionAlgOID());
            return signerInformation.getEncryptionAlgOID();
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Cannot get signer encryption algorithm oid " + exception.getMessage(), 50023);
        }
    }

    public String getSigningTime(int n, String string) throws CapiException {
        return this.getSigningTime(n, string, TimeZone.getDefault().getID());
    }

    public String getSigningTime(int n, String string, String string2) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Object object = this.b.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= ((Vector)object).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            Object object2 = (SignerInformation)((Vector)object).elementAt(n);
            if ((object2 = StreamSignedEnvelope.a(object2)) == null) {
                return null;
            }
            return Util.formatDate((Date)object2, (String)string, (String)string2);
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Wrong signingTime format", 50023);
        }
    }

    public byte[] getMessageDigest(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Object object = this.b.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= object.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)object.elementAt(n);
            SignerInformation signerInformation2 = signerInformation;
            signerInformation2 = signerInformation;
            signerInformation2 = signerInformation.getSignedAttributes();
            object = null;
            if (signerInformation2 != null && (signerInformation2 = signerInformation2.get(CMSAttributes.messageDigest)) != null) {
                signerInformation2 = (ASN1OctetString)signerInformation2.getAttrValues().getObjectAt(0).toASN1Primitive();
                object = signerInformation2.getOctets();
            }
            return object;
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Wrong signingTime format", 50023);
        }
    }

    private static Date a(SignerInformation signerInformation) {
        signerInformation = signerInformation.getSignedAttributes();
        Date date = null;
        if (signerInformation != null && (signerInformation = signerInformation.get(CMSAttributes.signingTime)) != null) {
            signerInformation = Time.getInstance((Object)signerInformation.getAttrValues().getObjectAt(0).toASN1Primitive());
            date = signerInformation.getDate();
        }
        return date;
    }

    public StreamSignedEnvelope(int n) throws CapiException {
        StreamSignedEnvelope.a("mode", n, 1, 2);
        this.s = n;
        this.j = 0;
        this.b = null;
        this.b();
    }

    private void b() throws CapiException {
        try {
            this.c = MessageDigest.getInstance(Constants.SHA1, ProvUtils.bcProvider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.error(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("SHA1 Digest Algorithm not available", 50050);
        }
        try {
            this.d = MessageDigest.getInstance(Constants.SHA256, ProvUtils.bcProvider);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.error(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("SHA256 Digest Algorithm not available", 50050);
        }
    }

    public void addCertificate(byte[] object) throws CapiException {
        if (this.j != 0 && this.j != 1 && this.j != 2 && this.j != 3) {
            throw new CapiException("Certificate cannot be set", 50040);
        }
        if (!this.certsVector.contains(object = (Object)new Certificate(object).getInternalCert())) {
            this.certsVector.add((X509Certificate)object);
        }
    }

    public void setSignatureTimeStampParams(String string, String string2, String string3, boolean bl, HttpsClient httpsClient) throws CapiException {
        if (string2 != null && string2.compareToIgnoreCase("SHA-1") != 0 && string2.compareToIgnoreCase("SHA-256") != 0 && string2.compareToIgnoreCase("MD5") != 0) {
            throw new CapiException("Invalid hash Algorithm", 1002);
        }
        this.k = string;
        this.l = string2;
        this.m = string3;
        this.n = bl;
        this.o = httpsClient;
        a.debug("[setSignatureTimeStampParams] done.");
    }

    public void setSignatureTimeStampParams(String string, String string2, String string3, boolean bl, String string4, String string5) throws CapiException {
        if (string == null || string2 == null) {
            throw new CapiException("Null data", 1001);
        }
        if (string2.compareToIgnoreCase("SHA-1") != 0 && string2.compareToIgnoreCase("SHA-256") != 0 && string2.compareToIgnoreCase("MD5") != 0) {
            throw new CapiException("Invalid hash Algorithm", 1002);
        }
        this.k = string;
        this.l = string2;
        this.m = string3;
        this.n = bl;
        this.p = string4;
        this.q = string5;
        this.o = null;
        a.debug("[setSignatureTimeStampParams] done.");
    }

    public void setSignatureTimeStampParams(String string, String string2, boolean bl, DTSClient dTSClient) throws CapiException {
        if (dTSClient == null) {
            throw new CapiException("Null DTSClient", 1001);
        }
        this.l = string;
        this.m = string2;
        this.n = bl;
        this.r = dTSClient;
        this.k = "TSCLIENT";
        a.debug("[setSignatureTimeStampParams DTSClient] done.");
    }

    public void addSigner(String string, boolean bl, InputStream inputStream, OutputStream outputStream) throws CapiException {
        this.addSigner(string, null, inputStream, outputStream);
    }

    private byte[] a(byte[] object) throws CapiException {
        Object object2 = new BigInteger(64, Util.secureRandom);
        try {
            if (this.r != null) {
                return this.r.timeStamp(this.m, this.l, object, (BigInteger)object2, this.n).toByteArray(false, true);
            }
            Client client = new Client();
            object2 = client.getRequest(this.m, this.l, object, false, (BigInteger)object2, this.n);
            a.debug("[getTimeStamp] generated TSReq");
            object = new ByteArrayInputStream(Util.base64DecodeStr((String)object2));
        }
        catch (IllegalParamException illegalParamException) {
            a.debug("[getTimeStamp] Error generating TSReq: " + illegalParamException.getMessage(), (Throwable)illegalParamException);
            throw new CapiException("Error generating TSReq", 50040);
        }
        catch (CapiException capiException) {
            a.error("[getTimeStamp] Error generating TSReq: " + capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (IOException iOException) {
            a.debug("[getTimeStamp] Error sending TSReq: " + iOException.getMessage(), (Throwable)iOException);
            if (iOException.getMessage() != null) {
                throw new CapiException("Error sending TSReq: " + iOException.getMessage(), 50040);
            }
            throw new CapiException("Error sending TSReq", 50040);
        }
        a.debug("[getTimeStamp] trying send TSA Request ...");
        try {
            if (this.o != null) {
                object = this.o.doPost(this.k, "application/timestamp-query", (InputStream)object, null);
            } else {
                HTTP_URLConnection hTTP_URLConnection = new HTTP_URLConnection();
                object = hTTP_URLConnection;
                object = hTTP_URLConnection.doPost(this.k, "application/timestamp-query", Util.base64DecodeStr((String)object2), this.p, this.q);
            }
        }
        catch (CapiException capiException) {
            a.error("[getTimeStamp] Error sending TSReq: " + capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.error("[getTimeStamp] Exception posting TSReq using HTTP_URLConnection: " + exception.getMessage(), (Throwable)exception);
            throw new CapiException("Exception posting TSReq using HTTP_URLConnection: " + exception.getMessage(), 91007);
        }
        if (object == null || ((byte[])object).length == 0) {
            throw new CapiException("Null response from TSA", 50040);
        }
        a.debug("[getTimeStamp] received Time Stamp Token form TSA.");
        return object;
    }

    public void addSigner(String string, Date date, InputStream inputStream, OutputStream outputStream) throws CapiException {
        try {
            if (string == null) {
                throw new CapiException("Null data", 1001);
            }
            if (inputStream == null) {
                throw new CapiException("Null data", 1001);
            }
            if (this.j != 0 && this.j != 1 && this.j != 2 && this.j != 3) {
                throw new CapiException("Signer cannot be added", 50040);
            }
            TokenSpi tokenSpi = ProvUtils.retrieveTokenByAlias((String)string);
            this.addSigner(tokenSpi, string, date, inputStream, outputStream);
        }
        catch (Throwable throwable) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            outputStream.close();
        }
        catch (Exception exception) {}
        try {
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void addSigner(TokenSpi object, String string, Date date, InputStream inputStream, OutputStream outputStream) throws CapiException {
        FileInputStream fileInputStream = null;
        try {
            Object object2;
            try {
                a.debug("[addSigner] getting credential from token...");
                String string2 = object.getCert(string);
                object2 = string2.getBytes("ISO8859_1");
                object2 = new ByteArrayInputStream((byte[])object2);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                try {
                    object2 = (X509Certificate)certificateFactory.generateCertificate((InputStream)object2);
                }
                catch (CertificateException certificateException) {
                    String string3 = StreamSignedEnvelope.a("CERTIFICATE") + string2 + StreamSignedEnvelope.b("CERTIFICATE");
                    object2 = string3;
                    object2 = string3.getBytes("ISO8859_1");
                    object2 = new ByteArrayInputStream((byte[])object2);
                    certificateFactory = CertificateFactory.getInstance("X.509");
                    object2 = (X509Certificate)certificateFactory.generateCertificate((InputStream)object2);
                    a.debug("alias cert Subject: " + ((X509Certificate)object2).getSubjectDN().getName());
                }
                a.debug("...cert ok");
                object = object.getPrivateKey(string);
                a.debug("[addSigner] getting credential from token ok");
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
                throw capiException;
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Internal error", 50050);
            }
            try {
                this.a((X509Certificate)object2, (PrivateKey)object, date, inputStream);
                this.j = 2;
                fileInputStream = new FileInputStream(this.i);
                this.getEncoded(fileInputStream, outputStream, false, true);
                a.debug("Signer added.");
            }
            catch (CapiError capiError) {
                a.error(capiError.getMessage(), (Throwable)capiError);
                throw capiError.getCapiException();
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
                throw capiException;
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Internal error", 50050);
            }
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            fileInputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(X509Certificate object, PrivateKey privateKey, Date object2, InputStream inputStream) throws CapiException {
        CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
        FileInputStream fileInputStream = null;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        this.a((CMSSignedGenerator)cMSSignedDataGenerator, aSN1EncodableVector, (X509Certificate)object, (Date)object2, inputStream);
        try {
            Object object3;
            a.debug("Pkcs7addSigner ...");
            object2 = "SHA256WithRSAEncryption";
            if (this.e.compareToIgnoreCase(SHA256) != 0) {
                object2 = "SHA1WithRSAEncryption";
            }
            privateKey = (object3 = new Certificate((X509Certificate)object)).isRsVerified() ? new VerRsContentSignerBuilder((String)object2).setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)privateKey)).build(privateKey) : new JcaContentSignerBuilder((String)object2).setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)privateKey)).build(privateKey);
            object2 = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            object2 = new JcaSignerInfoGeneratorBuilder((DigestCalculatorProvider)object2);
            object2 = object2.setSignedAttributeGenerator((CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(new AttributeTable(aSN1EncodableVector)));
            object = object2.build((ContentSigner)privateKey, (X509Certificate)object);
            if (object3.isRsVerified()) {
                cMSSignedDataGenerator.addSignerInfoGenerator((SignerInfoGenerator)new VerRsSignerInfoGenerator((SignerInfoGenerator)object));
            } else {
                cMSSignedDataGenerator.addSignerInfoGenerator((SignerInfoGenerator)object);
            }
            a.debug("Pkcs7 generating ...");
            privateKey = cMSSignedDataGenerator.generate((CMSTypedData)new CMSAbsentContent(), false);
            object = (SignerInformation)privateKey.getSignerInfos().getSigners().iterator().next();
            object = object.getSignature();
            if (this.k != null) {
                a.debug("Signature TimeStampToken adding..");
                object2 = privateKey.getSignerInfos();
                object2 = object2.getSigners();
                object2 = new Vector(object2);
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    aSN1EncodableVector = (SignerInformation)((Vector)object2).elementAt(i);
                    byte[] byArray = aSN1EncodableVector.getSignature();
                    object3 = byArray;
                    if (byArray == null || !Arrays.equals((byte[])object, (byte[])object3)) continue;
                    a.debug("Found same signature, Signature TimeStampToken adding..");
                    object = this.a(aSN1EncodableVector.getSignature());
                    object = new TimeStampToken((byte[])object);
                    byte[] byArray2 = object.toByteArray(false, true);
                    object = byArray2;
                    object = StreamSignedEnvelope.b(byArray2);
                    aSN1EncodableVector = StreamSignedEnvelope.a((Attribute)object, (SignerInformation)aSN1EncodableVector);
                    ((Vector)object2).set(i, aSN1EncodableVector);
                    break;
                }
                privateKey = CMSSignedData.replaceSigners((CMSSignedData)privateKey, (SignerInformationStore)new SignerInformationStore((Collection)object2));
            }
            a.debug("new Pkcs7 parsing ...");
            fileInputStream = new FileInputStream(this.i);
            object2 = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            this.b = new CMSSignedDataParser((DigestCalculatorProvider)object2, new CMSTypedStream((InputStream)new BufferedInputStream(fileInputStream)), privateKey.getEncoded());
            this.b.getSignedContent().drain();
            this.a();
            a.debug("Signer added.");
        }
        catch (CapiException capiException) {
            try {
                a.debug(capiException.getMessage(), (Throwable)capiException);
                throw capiException;
                catch (CMSException cMSException) {
                    a.debug(cMSException.getMessage(), (Throwable)cMSException);
                    throw new CapiException(cMSException.getMessage(), 50040, (Throwable)cMSException);
                }
                catch (IOException iOException) {
                    a.debug(iOException.getMessage(), (Throwable)iOException);
                    throw new CapiException(iOException.getMessage(), 50040, (Throwable)iOException);
                }
                catch (OperatorCreationException operatorCreationException) {
                    a.debug(operatorCreationException.getMessage(), (Throwable)operatorCreationException);
                    throw new CapiException(operatorCreationException.getMessage(), 50040, (Throwable)operatorCreationException);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    a.debug(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
                    throw new CapiException(certificateEncodingException.getMessage(), 50040, (Throwable)certificateEncodingException);
                }
                catch (Error error) {
                    a.debug(error.getMessage(), (Throwable)error);
                    throw new CapiException(error.getMessage(), 50040, (Throwable)error);
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        try {
            fileInputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(CMSSignedGenerator object, ASN1EncodableVector aSN1EncodableVector, X509Certificate x509Certificate, Date date, InputStream inputStream) throws CapiException {
        FileOutputStream fileOutputStream = null;
        try {
            JcaCertStore jcaCertStore;
            if (x509Certificate == null) {
                a.debug("x509Cert is null");
                throw new CapiException("x509Cert is null", 50040);
            }
            a.debug("Adding signer ...");
            MessageDigest messageDigest = this.c;
            Object object2 = new IssuerSerial(new GeneralNames(new GeneralName(JcaX500NameUtil.getIssuer((X509Certificate)x509Certificate))), new ASN1Integer(x509Certificate.getSerialNumber()));
            if (this.e.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA1) == 0) {
                a.debug("using SHA1 digest ...");
                this.c.reset();
                object2 = new ESSCertID(this.c.digest(x509Certificate.getEncoded()), object2);
                object2 = new Attribute(SignedData.id_aa_signingCertificate, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificate((ESSCertID)object2)));
                aSN1EncodableVector.add((ASN1Encodable)object2);
            } else {
                if (this.e.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA256) != 0) throw new CapiException("Invalid digest algorithm", 1002);
                a.debug("using SHA256 digest ...");
                messageDigest = this.d;
                this.d.reset();
                object2 = new ESSCertIDv2(new AlgorithmIdentifier(new ASN1ObjectIdentifier(CMSSignedDataGenerator.DIGEST_SHA256)), this.d.digest(x509Certificate.getEncoded()), object2);
                JcaCertStore jcaCertStore2 = new ESSCertIDv2[1];
                jcaCertStore = jcaCertStore2;
                jcaCertStore2[0] = object2;
                object2 = new Attribute(SignedData.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificateV2((ESSCertIDv2[])jcaCertStore)));
                aSN1EncodableVector.add((ASN1Encodable)object2);
            }
            if (this.b != null && this.b.getSignerInfos().size() > 0) {
                ((CMSSignedDataGenerator)object).addSigners(this.b.getSignerInfos());
                if (!this.certsVector.contains(x509Certificate)) {
                    this.certsVector.add(x509Certificate);
                }
                object2 = new JcaCertStore(this.certsVector);
                ((CMSSignedDataGenerator)object).addCertificates((Store)object2);
            } else {
                object2 = new Vector<X509Certificate>();
                object2.addElement(x509Certificate);
                jcaCertStore = new JcaCertStore((Collection)object2);
                ((CMSSignedDataGenerator)object).addCertificates((Store)jcaCertStore);
            }
            object2 = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.1")));
            aSN1EncodableVector.add((ASN1Encodable)object2);
            if (this.t) {
                a.debug("time is always true, including SigningTime!!");
                if (date != null) {
                    object2 = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(date)));
                    aSN1EncodableVector.add((ASN1Encodable)object2);
                } else {
                    object2 = new Date();
                    object2 = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time((Date)object2)));
                    aSN1EncodableVector.add((ASN1Encodable)object2);
                }
            }
            object2 = new byte[4096];
            a.debug("backing up content and digesting...");
            try {
                if (this.i.exists()) {
                    this.i.delete();
                }
            }
            catch (Exception exception) {}
            this.i = TmpFileUtils.createTempFile((String)"dataToSign", null);
            fileOutputStream = new FileOutputStream(this.i);
            int n = inputStream.read((byte[])object2);
            while (n > 0) {
                fileOutputStream.write((byte[])object2, 0, n);
                messageDigest.update((byte[])object2, 0, n);
                n = inputStream.read((byte[])object2);
            }
            fileOutputStream.close();
            fileOutputStream = null;
            a.debug("end of back up ...");
            object = messageDigest.digest();
            a.debug("end of digest ...");
            object2 = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString((byte[])object)));
            aSN1EncodableVector.add((ASN1Encodable)object2);
        }
        catch (CapiException capiException) {
            try {
                a.error(capiException.getMessage(), (Throwable)capiException);
                throw capiException;
                catch (Exception exception) {
                    a.error(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("Internal error. Previous signers lost", 50040);
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                if (fileOutputStream == null) throw throwable;
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    a.error(iOException.getMessage(), (Throwable)iOException);
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static String a(String string) throws IOException {
        return "-----BEGIN " + string + "-----" + System.getProperty("line.separator");
    }

    private static String b(String string) throws IOException {
        return System.getProperty("line.separator") + "-----END " + string + "-----";
    }

    public String[] addSigner(TokenSpi object, String string, Date date, InputStream inputStream) throws CapiException {
        Object object2;
        try {
            a.debug("[addSigner] getting credential from token...");
            String string2 = object.getCert(string);
            byte[] byArray = string2.getBytes("ISO8859_1");
            object2 = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            try {
                object2 = (X509Certificate)certificateFactory.generateCertificate((InputStream)object2);
                if (object2 == null) {
                    a.debug("Probably this is an IMB JRE, cert is null, retry as base64");
                    throw new CertificateException("IBM problem");
                }
            }
            catch (CertificateException certificateException) {
                object2 = Util.base64Decode((byte[])byArray);
                try {
                    object2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream((byte[])object2));
                    a.debug("certificate factory is " + certificateFactory.getClass().getName());
                    if (object2 == null) {
                        a.debug("cert is null");
                        throw new CertificateException("Null certificate");
                    }
                }
                catch (CertificateException certificateException2) {
                    object2 = StreamSignedEnvelope.a("CERTIFICATE") + string2 + StreamSignedEnvelope.b("CERTIFICATE");
                    byArray = ((String)object2).getBytes("ISO8859_1");
                    object2 = new ByteArrayInputStream(byArray);
                    certificateFactory = CertificateFactory.getInstance("X.509");
                    object2 = (X509Certificate)certificateFactory.generateCertificate((InputStream)object2);
                    if (object2 == null) {
                        a.debug("Cannot instantiate Certificate");
                        throw new CapiException("Certificate format unknown or not implemented", 30002);
                    }
                    a.debug("alias cert Subject: " + ((X509Certificate)object2).getSubjectDN().getName());
                }
            }
            a.debug("...cert ok");
            object = object.getPrivateKey(string);
            a.debug("[addSigner] getting credential from token ok");
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
            throw new CapiException("Internal error", 50050);
        }
        catch (CertificateException certificateException) {
            a.error(certificateException.getMessage(), (Throwable)certificateException);
            throw new CapiException("Internal error", 50050);
        }
        try {
            this.a((X509Certificate)object2, (PrivateKey)object, date, inputStream);
            a.debug("Signer added.");
            this.j = 2;
        }
        catch (CapiError capiError) {
            a.error(capiError.getMessage(), (Throwable)capiError);
            throw capiError.getCapiException();
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
        return this.listSigners();
    }

    public String[] addSigner(String string, Date date, InputStream inputStream) throws CapiException {
        try {
            if (string == null) {
                throw new CapiException("Null data", 1001);
            }
            if (inputStream == null) {
                throw new CapiException("Null data", 1001);
            }
            if (this.j != 0 && this.j != 1 && this.j != 2 && this.j != 3) {
                throw new CapiException("Signer cannot be added", 50040);
            }
            TokenSpi tokenSpi = ProvUtils.retrieveTokenByAlias((String)string);
            this.addSigner(tokenSpi, string, date, inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        return this.listSigners();
    }

    public void setDigestAlg(String string) throws CapiException {
        a.debug("Setting digest algorithm ...");
        if (string == null) {
            throw new CapiException("Null data", 1001);
        }
        if (string.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA1) == 0) {
            a.debug("set SHA1 digest");
            this.e = CMSSignedDataGenerator.DIGEST_SHA1;
            return;
        }
        if (string.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA256) == 0) {
            a.debug("set SHA256 digest ");
            this.e = CMSSignedDataGenerator.DIGEST_SHA256;
            return;
        }
        throw new CapiException("Invalid digest algorithm", 1002);
    }

    public void includeSigningTime(boolean bl) {
        a.debug("includeSigningTime called ... omit is " + bl);
        this.t = bl;
    }

    public String toString() {
        try {
            switch (this.j) {
                case 0: {
                    return "Envelope not signed yet";
                }
                case 1: {
                    if (this.b == null) {
                        return "Envelope not signed yet";
                    }
                    this.c();
                    break;
                }
                case 2: 
                case 3: {
                    return this.b.toString();
                }
            }
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
        }
        return this.getClass().getName();
    }

    private void c() throws CapiException {
        a.debug("setting certificates ...");
        if (this.certsVector.size() <= 0) {
            return;
        }
        try {
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            if (this.b != null) {
                if (this.b.getSignerInfos().size() > 0) {
                    cMSSignedDataGenerator.addSigners(this.b.getSignerInfos());
                }
            } else {
                throw new CapiException("Error parsing envelope: no signers", 50022);
            }
            JcaCertStore jcaCertStore = new JcaCertStore(this.certsVector);
            cMSSignedDataGenerator.addCertificates((Store)jcaCertStore);
            jcaCertStore = cMSSignedDataGenerator.generate((CMSTypedData)new CMSAbsentContent(), false);
            cMSSignedDataGenerator = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            this.b = new CMSSignedDataParser((DigestCalculatorProvider)cMSSignedDataGenerator, jcaCertStore.getEncoded());
            this.a();
            return;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            a.error(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            throw new CapiException("Error setting certificates", 50040);
        }
        catch (CMSException cMSException) {
            a.error(cMSException.getMessage(), (Throwable)cMSException);
            throw new CapiException("Error setting certificates", 50040);
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
            throw new CapiException("Error setting certificates", 50040);
        }
        catch (OperatorCreationException operatorCreationException) {
            a.error(operatorCreationException.getMessage(), (Throwable)operatorCreationException);
            throw new CapiException("Error setting certificates", 50040);
        }
    }

    public static void getPKCS7Content(InputStream inputStream, OutputStream outputStream) throws CapiException {
        if (inputStream == null || outputStream == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            inputStream = new CMSSignedDataParser(digestCalculatorProvider, inputStream);
            inputStream = inputStream.getSignedContent();
            if (inputStream == null) {
                throw new CapiException("Envelope is detached", 50000);
            }
            if ((inputStream = inputStream.getContentStream()) == null) {
                throw new CapiException("Envelope is detached", 50000);
            }
            Streams.pipeAll((InputStream)inputStream, (OutputStream)outputStream);
            return;
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (CMSException cMSException) {
            a.error(cMSException.getMessage(), (Throwable)cMSException);
            throw new CapiException("Envelope format unknown or not implemented", 50023);
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
            throw new CapiException("Error writing envelope content", 50025);
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
    }

    private static boolean a(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        if (inputStream == null || outputStream == null) {
            return false;
        }
        byte[] byArray = new byte[8192];
        while ((n2 = inputStream.read(byArray, 0, 8192)) >= 0) {
            outputStream.write(byArray, 0, n2);
        }
        return true;
    }

    private static void a(String string, int n, int n2, int n3) throws CapiException {
        if (n < n2 || n > n3) {
            throw new CapiException("Parameter " + string + " value ( " + n + " ) is out of the range allowed [" + n2 + " : " + n3 + "]", 1002);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StreamSignedEnvelope(InputStream inputStream, InputStream inputStream2, OutputStream outputStream, OutputStream outputStream2) throws CapiException {
        this(1);
        if (inputStream == null || inputStream2 == null || outputStream == null || outputStream2 == null) {
            throw new CapiException("Null data", 1001);
        }
        FileInputStream fileInputStream = null;
        StreamSignedEnvelope streamSignedEnvelope = null;
        StreamSignedEnvelope streamSignedEnvelope2 = null;
        try {
            int n;
            Store store;
            Object object = TmpFileUtils.createTempFile((String)"doc", (String)".tmp");
            streamSignedEnvelope = new StreamSignedEnvelope(inputStream2, new FileOutputStream((File)object));
            streamSignedEnvelope2 = new StreamSignedEnvelope(inputStream, outputStream2);
            CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
            if (streamSignedEnvelope.b.getSignerInfos().size() > 0) {
                cMSSignedDataStreamGenerator.addSigners(streamSignedEnvelope.b.getSignerInfos());
                store = streamSignedEnvelope.b.getCertificates();
                cMSSignedDataStreamGenerator.addCertificates(store);
            }
            if (streamSignedEnvelope2.b.getSignerInfos().size() > 0) {
                cMSSignedDataStreamGenerator.addSigners(streamSignedEnvelope2.b.getSignerInfos());
                store = streamSignedEnvelope2.b.getCertificates();
                cMSSignedDataStreamGenerator.addCertificates(store);
            }
            for (n = 0; n < streamSignedEnvelope.certsVector.size(); ++n) {
                if (this.certsVector.contains(streamSignedEnvelope.certsVector.get(n))) continue;
                this.certsVector.add(streamSignedEnvelope.certsVector.get(n));
            }
            for (n = 0; n < streamSignedEnvelope.f.size(); ++n) {
                if (this.f.contains(streamSignedEnvelope.f.get(n))) continue;
                this.f.add(streamSignedEnvelope.f.get(n));
            }
            for (n = 0; n < streamSignedEnvelope2.certsVector.size(); ++n) {
                if (this.certsVector.contains(streamSignedEnvelope2.certsVector.get(n))) continue;
                this.certsVector.add(streamSignedEnvelope2.certsVector.get(n));
            }
            for (n = 0; n < streamSignedEnvelope2.f.size(); ++n) {
                if (this.f.contains(streamSignedEnvelope2.f.get(n))) continue;
                this.f.add(streamSignedEnvelope2.f.get(n));
            }
            fileInputStream = new FileInputStream((File)object);
            OutputStream outputStream3 = this.s == 2 ? cMSSignedDataStreamGenerator.open(outputStream, false) : cMSSignedDataStreamGenerator.open(outputStream, true);
            object = new byte[4096];
            int n2 = fileInputStream.read((byte[])object);
            while (n2 > 0) {
                outputStream3.write((byte[])object, 0, n2);
                n2 = fileInputStream.read((byte[])object);
            }
            outputStream3.close();
            a.debug("Signer added and envelope saved.");
        }
        catch (IOException iOException) {
            try {
                a.error(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("Error encoding signed envelope", 50022);
                catch (CMSException cMSException) {
                    a.error(cMSException.getMessage(), (Throwable)cMSException);
                    throw new CapiException("Error encoding signed envelope", 50022);
                }
            }
            catch (Throwable throwable) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
                try {
                    outputStream2.close();
                }
                catch (Exception exception) {}
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    inputStream2.close();
                }
                catch (Exception exception) {}
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
                if (streamSignedEnvelope != null) {
                    streamSignedEnvelope.close();
                }
                if (streamSignedEnvelope2 != null) {
                    streamSignedEnvelope2.close();
                }
                throw throwable;
            }
        }
        try {
            outputStream.close();
        }
        catch (Exception exception) {}
        try {
            outputStream2.close();
        }
        catch (Exception exception) {}
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        try {
            inputStream2.close();
        }
        catch (Exception exception) {}
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        streamSignedEnvelope.close();
        streamSignedEnvelope2.close();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StreamSignedEnvelope(InputStream inputStream, InputStream inputStream2, OutputStream outputStream, InputStream inputStream3) throws CapiException {
        this(2);
        if (inputStream == null || inputStream2 == null || outputStream == null || inputStream3 == null) {
            throw new CapiException("Null data", 1001);
        }
        StreamSignedEnvelope streamSignedEnvelope = null;
        StreamSignedEnvelope streamSignedEnvelope2 = null;
        try {
            int n;
            Store store;
            streamSignedEnvelope = new StreamSignedEnvelope(inputStream2, inputStream3);
            streamSignedEnvelope2 = new StreamSignedEnvelope(inputStream, null);
            Object object = new CMSSignedDataGenerator();
            if (streamSignedEnvelope.b.getSignerInfos().size() > 0) {
                object.addSigners(streamSignedEnvelope.b.getSignerInfos());
                store = streamSignedEnvelope.b.getCertificates();
                object.addCertificates(store);
            }
            if (streamSignedEnvelope2.b.getSignerInfos().size() > 0) {
                object.addSigners(streamSignedEnvelope2.b.getSignerInfos());
                store = streamSignedEnvelope2.b.getCertificates();
                object.addCertificates(store);
            }
            for (n = 0; n < streamSignedEnvelope.certsVector.size(); ++n) {
                if (this.certsVector.contains(streamSignedEnvelope.certsVector.get(n))) continue;
                this.certsVector.add(streamSignedEnvelope.certsVector.get(n));
            }
            for (n = 0; n < streamSignedEnvelope.f.size(); ++n) {
                if (this.f.contains(streamSignedEnvelope.f.get(n))) continue;
                this.f.add(streamSignedEnvelope.f.get(n));
            }
            for (n = 0; n < streamSignedEnvelope2.certsVector.size(); ++n) {
                if (this.certsVector.contains(streamSignedEnvelope2.certsVector.get(n))) continue;
                this.certsVector.add(streamSignedEnvelope2.certsVector.get(n));
            }
            for (n = 0; n < streamSignedEnvelope2.f.size(); ++n) {
                if (this.f.contains(streamSignedEnvelope2.f.get(n))) continue;
                this.f.add(streamSignedEnvelope2.f.get(n));
            }
            CMSSignedData cMSSignedData = object.generate((CMSTypedData)new CMSProcessableFile(new File("prova")), false);
            object = cMSSignedData.getEncoded();
            outputStream.write((byte[])object);
            a.debug("Signer added and envelope saved.");
        }
        catch (IOException iOException) {
            try {
                a.error(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("Error encoding signed envelope", 50022);
                catch (CMSException cMSException) {
                    a.error(cMSException.getMessage(), (Throwable)cMSException);
                    throw new CapiException("Error encoding signed envelope", 50022);
                }
            }
            catch (Throwable throwable) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException2) {}
                try {
                    inputStream3.close();
                }
                catch (IOException iOException3) {}
                try {
                    inputStream.close();
                }
                catch (IOException iOException4) {}
                try {
                    inputStream2.close();
                }
                catch (IOException iOException5) {}
                if (streamSignedEnvelope != null) {
                    streamSignedEnvelope.close();
                }
                if (streamSignedEnvelope2 != null) {
                    streamSignedEnvelope2.close();
                }
                throw throwable;
            }
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {}
        try {
            inputStream3.close();
        }
        catch (IOException iOException) {}
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        try {
            inputStream2.close();
        }
        catch (IOException iOException) {}
        streamSignedEnvelope.close();
        streamSignedEnvelope2.close();
    }

    public CounterSignedEnvelope getCounterSignature(int n) throws CapiException {
        Object object;
        if (this.b == null) {
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (n < 0 || n >= this.f.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            object = this.b.getSignerInfos();
        }
        catch (CMSException cMSException) {
            a.error(cMSException.getMessage(), (Throwable)cMSException);
            throw new CapiException("Internal error", 50050);
        }
        object = object.getSigners();
        object = new Vector(object);
        if (n < 0 || n >= ((Vector)object).size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            object = (SignerInformation)((Vector)object).elementAt(n);
            SignerInformationStore signerInformationStore = object.getCounterSignatures();
            CounterSignedEnvelope counterSignedEnvelope = new CounterSignedEnvelope();
            new CounterSignedEnvelope().certsVector = this.certsVector;
            counterSignedEnvelope.setData(object.getSignature());
            counterSignedEnvelope.a(signerInformationStore, n);
            return counterSignedEnvelope;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] setCounterSignature(int n, CounterSignedEnvelope counterSignedEnvelope, InputStream inputStream) throws CapiException {
        String[] stringArray;
        Object object;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        if (this.b == null) {
            try {
                inputStream.close();
                throw new CapiException("Data must be signed or parsed before", 50001);
            }
            catch (IOException iOException) {}
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (n < 0 || n >= this.f.size()) {
            try {
                inputStream.close();
                throw new CapiException("Wrong signer index", 50010);
            }
            catch (IOException iOException) {}
            throw new CapiException("Wrong signer index", 50010);
        }
        if (counterSignedEnvelope == null) {
            try {
                inputStream.close();
                throw new CapiException("CounterSignedEnvelope must be valid and signed", 1001);
            }
            catch (IOException iOException) {}
            throw new CapiException("CounterSignedEnvelope must be valid and signed", 1001);
        }
        try {
            object = this.b.getSignerInfos();
            object = object.getSigners();
        }
        catch (CMSException cMSException) {
            try {
                inputStream.close();
                throw new CapiException("Data must be signed or parsed before", 50001);
            }
            catch (IOException iOException) {}
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (n < 0 || n >= object.size()) {
            try {
                inputStream.close();
                throw new CapiException("Wrong signer index", 50010);
            }
            catch (IOException iOException) {}
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            Object object2 = this.b.getCertificates().getMatches(null);
            Object object3 = counterSignedEnvelope.pkcs7SignedData.getCertificates().getMatches(null);
            object3 = new Vector(object3);
            for (int i = 0; i < object3.size(); ++i) {
                if (object2.contains(object3.elementAt(i))) continue;
                object2.add(object3.elementAt(i));
            }
            JcaCertStore jcaCertStore = new JcaCertStore((Collection)object2);
            cMSSignedDataGenerator.addCertificates((Store)jcaCertStore);
            counterSignedEnvelope = counterSignedEnvelope.getSignersInfos();
            a.debug("adding " + counterSignedEnvelope.size() + " countersignatures to signer " + n);
            object = new Vector(object);
            object2 = (SignerInformation)((Vector)object).get(n);
            object3 = object2.getUnsignedAttributes();
            if (object3 != null) {
                a.debug("replacing CS attribute ... ");
                object3 = object3.toHashtable();
                object3.remove(CMSAttributes.counterSignature);
                object3 = new AttributeTable((Hashtable)object3);
                object2 = SignerInformation.replaceUnsignedAttributes((SignerInformation)object2, (AttributeTable)object3);
            }
            object3 = SignerInformation.addCounterSigners((SignerInformation)object2, (SignerInformationStore)counterSignedEnvelope);
            ((Vector)object).set(n, object3);
            cMSSignedDataGenerator.addSigners(new SignerInformationStore((Collection)object));
            object3 = cMSSignedDataGenerator.generate((CMSTypedData)new CMSAbsentContent(), false);
            a.debug("backing up content...");
            try {
                if (this.i.exists()) {
                    this.i.delete();
                }
            }
            catch (Exception exception) {}
            this.i = TmpFileUtils.createTempFile((String)"dataToSign", null);
            fileOutputStream = new FileOutputStream(this.i);
            object2 = new byte[4096];
            n = inputStream.read((byte[])object2);
            while (n > 0) {
                fileOutputStream.write((byte[])object2, 0, n);
                n = inputStream.read((byte[])object2);
            }
            fileOutputStream.close();
            fileOutputStream = null;
            a.debug("end of back up ...");
            fileInputStream = new FileInputStream(this.i);
            stringArray = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            this.b = new CMSSignedDataParser((DigestCalculatorProvider)stringArray, new CMSTypedStream((InputStream)new BufferedInputStream(fileInputStream)), object3.getEncoded());
            this.b.getSignedContent().drain();
            this.a();
            stringArray = this.listSigners();
        }
        catch (IOException iOException) {
            try {
                a.error(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("CounterSignature internal error", 50050);
                catch (CMSException cMSException) {
                    a.error(cMSException.getMessage(), (Throwable)cMSException);
                    throw new CapiException("CounterSignature internal error", 50050);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    a.error(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
                    throw new CapiException("CounterSignature internal error", 50050);
                }
                catch (OperatorCreationException operatorCreationException) {
                    a.error(operatorCreationException.getMessage(), (Throwable)operatorCreationException);
                    throw new CapiException("CounterSignature internal error", 50050);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException2) {}
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {}
                try {
                    if (fileOutputStream == null) throw throwable;
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException4) {}
                throw throwable;
            }
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            inputStream.close();
            return stringArray;
        }
        catch (IOException iOException) {}
        return stringArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCounterSignature(int n, CounterSignedEnvelope counterSignedEnvelope, InputStream inputStream, OutputStream outputStream) throws CapiException {
        Object object;
        if (this.b == null) {
            try {
                inputStream.close();
                throw new CapiException("Data must be signed or parsed before", 50001);
            }
            catch (IOException iOException) {}
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (n < 0 || n >= this.f.size()) {
            try {
                inputStream.close();
                throw new CapiException("Wrong signer index", 50010);
            }
            catch (IOException iOException) {}
            throw new CapiException("Wrong signer index", 50010);
        }
        if (counterSignedEnvelope == null) {
            try {
                inputStream.close();
                throw new CapiException("CounterSignedEnvelope must be valid and signed", 1001);
            }
            catch (IOException iOException) {}
            throw new CapiException("CounterSignedEnvelope must be valid and signed", 1001);
        }
        try {
            object = this.b.getSignerInfos();
            object = object.getSigners();
        }
        catch (CMSException cMSException) {
            try {
                inputStream.close();
                throw new CapiException("Data must be signed or parsed before", 50001);
            }
            catch (IOException iOException) {}
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (n < 0 || n >= object.size()) {
            try {
                inputStream.close();
                throw new CapiException("Wrong signer index", 50010);
            }
            catch (IOException iOException) {}
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
            Object object2 = this.b.getCertificates().getMatches(null);
            Object object3 = counterSignedEnvelope.certsVector;
            for (int i = 0; i < object3.size(); ++i) {
                if (object2.contains(object3.get(i))) continue;
                object2.add(object3.get(i));
            }
            JcaCertStore jcaCertStore = new JcaCertStore((Collection)object2);
            cMSSignedDataStreamGenerator.addCertificates((Store)jcaCertStore);
            counterSignedEnvelope = counterSignedEnvelope.getSignersInfos();
            a.debug("adding " + counterSignedEnvelope.size() + " countersignatures to signer " + n);
            object = new Vector(object);
            object2 = (SignerInformation)((Vector)object).get(n);
            object3 = object2.getUnsignedAttributes();
            if (object3 != null) {
                a.debug("replacing CS attribute ... ");
                object3 = object3.toHashtable();
                ((Hashtable)object3).remove(CMSAttributes.counterSignature);
                object3 = new AttributeTable((Hashtable)object3);
                object2 = SignerInformation.replaceUnsignedAttributes((SignerInformation)object2, (AttributeTable)object3);
            }
            object3 = SignerInformation.addCounterSigners((SignerInformation)object2, (SignerInformationStore)counterSignedEnvelope);
            ((Vector)object).set(n, object3);
            cMSSignedDataStreamGenerator.addSigners(new SignerInformationStore((Collection)object));
            a.debug("saving Pkcs7 envelope ...");
            object2 = new byte[4096];
            object3 = this.s == 1 ? cMSSignedDataStreamGenerator.open(outputStream, true) : cMSSignedDataStreamGenerator.open(outputStream, false);
            if (this.s == 1) {
                n = inputStream.read((byte[])object2);
                while (n > 0) {
                    ((OutputStream)object3).write((byte[])object2, 0, n);
                    n = inputStream.read((byte[])object2);
                }
            }
            ((OutputStream)object3).close();
            a.debug("Envelope saved.");
        }
        catch (IOException iOException) {
            try {
                a.error(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("Error encoding CounterSigned envelope", 50040);
                catch (CMSException cMSException) {
                    a.error(cMSException.getMessage(), (Throwable)cMSException);
                    throw new CapiException("Error encoding CounterSigned envelope", 50040);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    a.error(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
                    throw new CapiException("Error encoding CounterSigned envelope", 50040);
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
                try {
                    this.j = 0;
                    if (!this.i.exists()) throw throwable;
                    this.i.delete();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        try {
            outputStream.close();
        }
        catch (Exception exception) {}
        try {
            this.j = 0;
            if (!this.i.exists()) return;
            this.i.delete();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean hasCounterSignature(int n) throws CapiException {
        Vector vector;
        if (this.b == null) {
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (n < 0 || n >= this.f.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            vector = this.b.getSignerInfos().getSigners();
        }
        catch (CMSException cMSException) {
            a.error(cMSException.getMessage(), (Throwable)cMSException);
            throw new CapiException("CMSException getting signers", 50050);
        }
        vector = new Vector(vector);
        SignerInformation signerInformation = (SignerInformation)vector.elementAt(n);
        signerInformation = signerInformation.getCounterSignatures();
        return signerInformation != null && signerInformation.size() > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getEncoded(InputStream inputStream, OutputStream outputStream, boolean bl, boolean bl2) throws CapiException {
        Object object;
        if (this.j < 2) {
            throw new CapiException("Data must be signed before", 50001);
        }
        a.debug("saving envelope ...");
        OutputStream outputStream2 = null;
        try {
            object = new CMSSignedDataStreamGenerator();
            if (this.b == null) throw new CapiException("Error parsing envelope: no signers", 50022);
            if (this.b.getSignerInfos().size() <= 0) throw new CapiException("Error parsing envelope: no signers", 50022);
            object.addSigners(this.b.getSignerInfos());
            object.addCertificates(this.b.getCertificates());
        }
        catch (CMSException cMSException) {
            a.error(cMSException.getMessage(), (Throwable)cMSException);
            throw new CapiException("Error parsing signed envelope", 50040);
        }
        try {
            if (bl) {
                outputStream2 = new Base64OutputStream(outputStream, true);
            }
            OutputStream outputStream3 = this.s == 1 ? object.open(bl ? outputStream2 : outputStream, true) : object.open(bl ? outputStream2 : outputStream, false);
            object = new byte[4096];
            if (this.s == 1) {
                int n = inputStream.read((byte[])object);
                while (n > 0) {
                    outputStream3.write((byte[])object, 0, n);
                    n = inputStream.read((byte[])object);
                }
            }
            outputStream3.close();
            a.debug("Envelope saved.");
        }
        catch (Exception exception) {
            try {
                a.error(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Error encoding signed envelope", 50040);
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream2 != null) {
                        outputStream2.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    outputStream.close();
                }
                catch (Exception exception2) {}
                try {
                    inputStream.close();
                }
                catch (Exception exception3) {}
                try {
                    if (!bl2) throw throwable;
                    this.j = 0;
                    if (!this.i.exists()) throw throwable;
                    this.i.delete();
                    throw throwable;
                }
                catch (Exception exception4) {}
                throw throwable;
            }
        }
        try {
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
        catch (IOException iOException) {}
        try {
            outputStream.close();
        }
        catch (Exception exception) {}
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        try {
            if (!bl2) return;
            this.j = 0;
            if (!this.i.exists()) return;
            this.i.delete();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void getEncoded(InputStream inputStream, OutputStream outputStream) throws CapiException {
        this.getEncoded(inputStream, outputStream, false, true);
    }

    private static Attribute b(byte[] object) throws CapiException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])object));
            object = aSN1InputStream;
            object = ContentInfo.getInstance((Object)aSN1InputStream.readObject());
            Attribute attribute = new Attribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Set)new DERSet((ASN1Encodable)object));
            object = attribute;
            return attribute;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error adding signature Time Stamp Token", 50040);
        }
    }

    public String[] setSignatureTimeStampToken(int n, TimeStampToken object, InputStream inputStream) throws CapiException, IOException {
        if (object == null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw new CapiException("Time Stamp Token is null", 1001);
        }
        object = object.toByteArray(false, true);
        return this.setSignatureTimeStampToken(n, (byte[])object, inputStream);
    }

    private static SignerInformation a(Attribute attribute, SignerInformation signerInformation) {
        Object object = signerInformation.getUnsignedAttributes();
        if (object != null) {
            a.debug("removing existing TimeStampToken unsignedAttributes ... ");
            object = object.toHashtable();
            object.remove(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            a.debug("adding TS attribute to existing unsignedAttributes ... ");
            object = new AttributeTable((Hashtable)object).toASN1EncodableVector();
        } else {
            object = new ASN1EncodableVector();
        }
        object.add((ASN1Encodable)attribute);
        object = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)new AttributeTable((ASN1EncodableVector)object));
        return object;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] setSignatureTimeStampToken(int n, byte[] object, InputStream inputStream) throws CapiException {
        String[] stringArray;
        Object object2;
        FileOutputStream fileOutputStream = null;
        if (object == null) {
            try {
                inputStream.close();
                throw new CapiException("Time Stamp Token is null", 1001);
            }
            catch (IOException iOException) {}
            throw new CapiException("Time Stamp Token is null", 1001);
        }
        object = StreamSignedEnvelope.b(object);
        FileInputStream fileInputStream = null;
        if (this.b == null) {
            try {
                inputStream.close();
                throw new CapiException("Data must be signed or parsed before", 50001);
            }
            catch (IOException iOException) {}
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (n < 0 || n >= this.f.size()) {
            try {
                inputStream.close();
                throw new CapiException("Wrong signer index", 50010);
            }
            catch (IOException iOException) {}
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            object2 = this.b.getSignerInfos();
            object2 = object2.getSigners();
        }
        catch (CMSException cMSException) {
            a.error(cMSException.getMessage(), (Throwable)cMSException);
            try {
                inputStream.close();
                throw new CapiException("Data must be signed or parsed before", 50001);
            }
            catch (IOException iOException) {}
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (n < 0 || n >= object2.size()) {
            try {
                inputStream.close();
                throw new CapiException("Wrong signer index", 50010);
            }
            catch (IOException iOException) {}
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            Store store = this.b.getCertificates();
            cMSSignedDataGenerator.addCertificates(store);
            object2 = new Vector(object2);
            store = (SignerInformation)((Vector)object2).get(n);
            store = StreamSignedEnvelope.a((Attribute)object, (SignerInformation)store);
            ((Vector)object2).set(n, store);
            cMSSignedDataGenerator.addSigners(new SignerInformationStore((Collection)object2));
            stringArray = cMSSignedDataGenerator.generate((CMSTypedData)new CMSAbsentContent(), false);
            a.debug("backing up content...");
            try {
                if (this.i.exists()) {
                    this.i.delete();
                }
            }
            catch (Exception exception) {}
            this.i = TmpFileUtils.createTempFile((String)"dataToSign", null);
            fileOutputStream = new FileOutputStream(this.i);
            object = new byte[4096];
            int n2 = inputStream.read((byte[])object);
            while (n2 > 0) {
                fileOutputStream.write((byte[])object, 0, n2);
                n2 = inputStream.read((byte[])object);
            }
            fileOutputStream.close();
            fileOutputStream = null;
            a.debug("end of back up ...");
            fileInputStream = new FileInputStream(this.i);
            object = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            this.b = new CMSSignedDataParser((DigestCalculatorProvider)object, new CMSTypedStream((InputStream)new BufferedInputStream(fileInputStream)), stringArray.getEncoded());
            this.b.getSignedContent().drain();
            this.a();
            stringArray = this.listSigners();
        }
        catch (IOException iOException) {
            try {
                a.error(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("Error encoding CounterSigned envelope", 50040);
                catch (CMSException cMSException) {
                    a.error(cMSException.getMessage(), (Throwable)cMSException);
                    throw new CapiException("Error encoding CounterSigned envelope", 50040);
                }
                catch (OperatorCreationException operatorCreationException) {
                    a.error(operatorCreationException.getMessage(), (Throwable)operatorCreationException);
                    throw new CapiException("Error encoding CounterSigned envelope", 50040);
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
                try {
                    this.j = 0;
                    if (this.i.exists()) {
                        this.i.delete();
                    }
                }
                catch (Exception exception) {}
                if (fileOutputStream == null) throw throwable;
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {}
        try {
            this.j = 0;
            if (!this.i.exists()) return stringArray;
            this.i.delete();
            return stringArray;
        }
        catch (Exception exception) {}
        return stringArray;
    }

    public byte[] getSignatureTimeStampToken(int n) throws CapiException {
        if (this.b == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Object object = this.b.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= object.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)object.elementAt(n);
            signerInformation = signerInformation.getUnsignedAttributes();
            object = null;
            if (signerInformation != null && (signerInformation = signerInformation.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) != null) {
                signerInformation = ContentInfo.getInstance((Object)signerInformation.getAttrValues().getObjectAt(0).toASN1Primitive());
                object = signerInformation.getEncoded("DER");
            }
            return object;
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Wrong timeStampToken format", 50023);
        }
    }

    public void close() {
        if (this.i != null && this.i.exists()) {
            this.i.delete();
        }
    }

    public CadesSignedDataProxy getSignedDataProxy() {
        return new CadesSignedDataProxy(this.b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] addSignerByApplet(String object, Date date, InputStream inputStream) throws CapiException {
        try {
            TokenSpi tokenSpi;
            if (object == null) {
                throw new CapiException("Null data", 1001);
            }
            if (inputStream == null) {
                throw new CapiException("Null data", 1001);
            }
            if (this.j != 0 && this.j != 1 && this.j != 2 && this.j != 3) {
                throw new CapiException("Signer cannot be added", 50040);
            }
            TokenSpi tokenSpi2 = tokenSpi = Token.getTokenSpi((String)object);
            synchronized (tokenSpi) {
                Object object2;
                try {
                    a.info("[addSigner] getting credential from token...");
                    String string = tokenSpi.getCert((String)object);
                    byte[] byArray = string.getBytes("ISO8859_1");
                    object2 = new ByteArrayInputStream(byArray);
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    try {
                        object2 = (X509Certificate)certificateFactory.generateCertificate((InputStream)object2);
                        if (object2 == null) {
                            a.info("Probably this is an IMB JRE, cert is null, retry as base64");
                            throw new CertificateException("IBM problem");
                        }
                    }
                    catch (CertificateException certificateException) {
                        object2 = Util.base64Decode((byte[])byArray);
                        try {
                            object2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream((byte[])object2));
                            a.info("certificate factory is " + certificateFactory.getClass().getName());
                            if (object2 == null) {
                                a.info("cert is null");
                                throw new CertificateException("Null certificate");
                            }
                        }
                        catch (CertificateException certificateException2) {
                            object2 = StreamSignedEnvelope.a("CERTIFICATE") + string + StreamSignedEnvelope.b("CERTIFICATE");
                            byArray = ((String)object2).getBytes("ISO8859_1");
                            object2 = new ByteArrayInputStream(byArray);
                            certificateFactory = CertificateFactory.getInstance("X.509");
                            object2 = (X509Certificate)certificateFactory.generateCertificate((InputStream)object2);
                            if (object2 == null) {
                                a.info("Cannot instantiate Certificate");
                                throw new CapiException("Certificate format unknown or not implemented", 30002);
                            }
                            a.info("alias cert Subject: " + ((X509Certificate)object2).getSubjectDN().getName());
                        }
                    }
                    a.info("...cert ok");
                    object = tokenSpi.getPrivateKey((String)object);
                    a.info("[addSigner] getting credential from token ok");
                }
                catch (CapiException capiException) {
                    a.error(capiException.getMessage());
                    throw capiException;
                }
                catch (Exception exception) {
                    a.error(exception.getMessage());
                    throw new CapiException("Internal error", 50050);
                }
                try {
                    this.b((X509Certificate)object2, (PrivateKey)object, date, inputStream);
                    a.info("Signer added.");
                    this.j = 2;
                }
                catch (CapiError capiError) {
                    a.error(capiError.getMessage());
                    throw capiError.getCapiException();
                }
                catch (Exception exception) {
                    a.error(exception.getMessage());
                    throw new CapiException("Internal error " + exception.getMessage(), 50050);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            return this.listSigners();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void b(X509Certificate object, PrivateKey privateKey, Date object2, InputStream inputStream) throws CapiException {
        Object object3 = new CMSSignedDataGenerator();
        FileInputStream fileInputStream = null;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        object2 = this.b((CMSSignedGenerator)object3, aSN1EncodableVector, (X509Certificate)object, (Date)object2, inputStream);
        try {
            String string = "SHA256WithRSAEncryption";
            if (this.e.compareToIgnoreCase(SHA256) != 0) {
                string = "SHA1WithRSAEncryption";
            }
            try {
                privateKey = new JcaContentSignerBuilder(string).setProvider(ProvUtils.actalisProvider).build(privateKey);
                string = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
                string = new JcaSignerInfoGeneratorBuilder((DigestCalculatorProvider)string);
            }
            catch (Exception exception) {
                throw new CapiException("1 " + exception.getMessage(), 1003);
            }
            try {
                aSN1EncodableVector = string.setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(new AttributeTable(aSN1EncodableVector)));
            }
            catch (Exception exception) {
                throw new CapiException("2 " + exception.getMessage(), 1003);
            }
            try {
                object = aSN1EncodableVector.build((ContentSigner)privateKey, (X509Certificate)object);
            }
            catch (Exception exception) {
                throw new CapiException("3 " + exception.getMessage(), 1003);
            }
            try {
                object3.addSignerInfoGenerator((SignerInfoGenerator)object);
            }
            catch (Exception exception) {
                throw new CapiException("4 " + exception.getMessage(), 1003);
            }
            try {
                privateKey = object3.generate((CMSTypedData)new CMSAbsentContent(), false);
            }
            catch (Exception exception) {
                throw new CapiException("5 " + exception.getMessage(), 1003);
            }
            try {
                if (this.k != null) {
                    object = privateKey.getSignerInfos();
                    object = object.getSigners();
                    object3 = new Vector(object);
                    for (int i = 0; i < ((Vector)object3).size(); ++i) {
                        string = (SignerInformation)((Vector)object3).elementAt(i);
                        object = StreamSignedEnvelope.a((SignerInformation)string);
                        if (object == null || ((Date)object).toString().compareToIgnoreCase((String)object2) != 0) continue;
                        object = this.a(string.getSignature());
                        object = new TimeStampToken((byte[])object);
                        byte[] byArray = object.toByteArray(false, true);
                        object = byArray;
                        object = StreamSignedEnvelope.b(byArray);
                        string = StreamSignedEnvelope.a((Attribute)object, (SignerInformation)string);
                        ((Vector)object3).set(i, string);
                        break;
                    }
                    privateKey = CMSSignedData.replaceSigners((CMSSignedData)privateKey, (SignerInformationStore)new SignerInformationStore((Collection)object3));
                }
            }
            catch (Exception exception) {
                throw new CapiException("6 " + exception.getMessage(), 1003);
            }
            try {
                fileInputStream = new FileInputStream(this.i);
                string = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            }
            catch (Exception exception) {
                throw new CapiException("7 " + exception.getMessage(), 1003);
            }
            try {
                this.b = new CMSSignedDataParser((DigestCalculatorProvider)string, new CMSTypedStream((InputStream)new BufferedInputStream(fileInputStream, 4096)), privateKey.getEncoded());
                this.b.getSignedContent().drain();
                this.a();
            }
            catch (Exception exception) {
                throw new CapiException("8 " + exception.getMessage(), 1003);
            }
        }
        catch (CapiException capiException) {
            try {
                CapiException capiException2 = capiException;
                throw capiException;
                catch (Exception exception) {
                    throw new CapiException(exception.getMessage(), 50040);
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        try {
            fileInputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String b(CMSSignedGenerator object, ASN1EncodableVector aSN1EncodableVector, X509Certificate x509Certificate, Date date, InputStream inputStream) throws CapiException {
        try {
            Object object2;
            Object object3;
            if (x509Certificate == null) {
                throw new CapiException("x509Cert is null", 50040);
            }
            MessageDigest messageDigest = this.c;
            try {
                object3 = new IssuerSerial(new GeneralNames(new GeneralName(JcaX500NameUtil.getIssuer((X509Certificate)x509Certificate))), new ASN1Integer(x509Certificate.getSerialNumber()));
            }
            catch (Exception exception) {
                throw new CapiException("Exception creating IssuerSerial", 50040);
            }
            if (this.e.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA1) == 0) {
                try {
                    this.c.reset();
                    object2 = new ESSCertID(this.c.digest(x509Certificate.getEncoded()), (IssuerSerial)object3);
                    object3 = new Attribute(SignedData.id_aa_signingCertificate, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificate(object2)));
                    aSN1EncodableVector.add((ASN1Encodable)object3);
                }
                catch (Exception exception) {
                    throw new CapiException("Exception creating id_aa_signingCertificate.", 50040);
                }
            }
            if (this.e.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA256) != 0) throw new CapiException("Invalid digest algorithm", 1002);
            messageDigest = this.d;
            try {
                this.d.reset();
                object2 = new ESSCertIDv2(new AlgorithmIdentifier(new ASN1ObjectIdentifier(CMSSignedDataGenerator.DIGEST_SHA256)), this.d.digest(x509Certificate.getEncoded()), (IssuerSerial)object3);
                JcaCertStore jcaCertStore = new ESSCertIDv2[1];
                object3 = jcaCertStore;
                jcaCertStore[0] = object2;
                object3 = new Attribute(SignedData.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificateV2((ESSCertIDv2[])object3)));
                aSN1EncodableVector.add((ASN1Encodable)object3);
            }
            catch (Exception exception) {
                throw new CapiException("Exception creating id_aa_signingCertificate.", 50040);
            }
            if (this.b != null && this.b.getSignerInfos().size() > 0) {
                try {
                    ((CMSSignedDataGenerator)object).addSigners(this.b.getSignerInfos());
                    if (!this.certsVector.contains(x509Certificate)) {
                        this.certsVector.add(x509Certificate);
                    }
                    object2 = new JcaCertStore(this.certsVector);
                    ((CMSSignedDataGenerator)object).addCertificates((Store)object2);
                }
                catch (Exception exception) {
                    throw new CapiException("busta gi\u00e0 firmata da aggiornare: " + exception.getMessage(), 1003);
                }
            }
            try {
                object2 = new Vector<X509Certificate>();
                object2.addElement(x509Certificate);
                object3 = new JcaCertStore((Collection)object2);
                ((CMSSignedDataGenerator)object).addCertificates((Store)object3);
            }
            catch (Exception exception) {
                throw new CapiException("busta nuova: " + exception.getMessage(), 1003);
            }
            try {
                object3 = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)new DERObjectIdentifier("1.2.840.113549.1.7.1")));
                aSN1EncodableVector.add((ASN1Encodable)object3);
            }
            catch (Exception exception) {
                throw new CapiException("aggiunta attributi contentType: " + exception.getMessage(), 1003);
            }
            try {
                if (date != null) {
                    object2 = date.toString();
                    object3 = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(date)));
                    aSN1EncodableVector.add((ASN1Encodable)object3);
                } else {
                    object3 = new Date();
                    object2 = object3.toString();
                    object3 = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time((Date)object3)));
                    aSN1EncodableVector.add((ASN1Encodable)object3);
                }
            }
            catch (Exception exception) {
                throw new CapiException("aggiunta attributi signingTime: " + exception.getMessage(), 1003);
            }
            object3 = new byte[4096];
            try {
                if (this.i.exists()) {
                    this.i.delete();
                }
            }
            catch (Exception exception) {}
            this.i = TmpFileUtils.createTempFile((String)"dataToSign", null);
            object = new FileOutputStream(this.i);
            int n = inputStream.read((byte[])object3);
            while (n > 0) {
                object.write((byte[])object3, 0, n);
                messageDigest.update((byte[])object3, 0, n);
                n = inputStream.read((byte[])object3);
            }
            object.close();
            object = messageDigest.digest();
            try {
                object3 = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString((byte[])object)));
                aSN1EncodableVector.add((ASN1Encodable)object3);
            }
            catch (Exception exception) {
                throw new CapiException("aggiunta attributi messageDigest: " + exception.getMessage(), 1003);
            }
            object = object2;
        }
        catch (CapiException capiException) {
            try {
                CapiException capiException2 = capiException;
                throw capiException;
                catch (Exception exception) {
                    throw new CapiException(exception.getMessage(), 50040);
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return object;
        }
        catch (Exception exception) {}
        return object;
    }
}

