/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils.provider.apache;

import com.sun.jna.Platform;
import it.actalis.ellips.capi.http.arubautils.HttpAdditionalInfoUtils;
import it.actalis.ellips.capi.http.arubautils.HttpStatusException;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.NullTrustManager;
import it.actalis.ellips.capi.http.arubautils.Parameters;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.http.arubautils.provider.DownloadProgressNotifier;
import it.actalis.ellips.capi.http.arubautils.provider.HTTPProvider;
import it.actalis.ellips.capi.http.arubautils.provider.MultipartWrapper;
import it.actalis.ellips.capi.http.arubautils.provider.apache.ApacheHttpClientMultipartWrapper;
import it.actalis.ellips.capi.http.arubautils.provider.apache.CapiConnectionSocketFactory;
import it.actalis.ellips.capi.http.arubautils.provider.apache.CapiSSLConnectionSocketFactory;
import it.actalis.ellips.capi.http.arubautils.provider.apache.CloseClientInputStream;
import it.actalis.ellips.capi.http.bc.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.impl.client.WinHttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;

public class ApacheHttpClientProvider
extends HTTPProvider {
    int connectionTimeOut = 3000;
    int readTimeOut = 5000;
    boolean usingProxy = false;
    private HashMap<KeyStore, SSLConnectionSocketFactory> sslSocketFactoryMap = new HashMap();

    public ApacheHttpClientProvider(NetworkConfig conf, Logger logger) {
        super(conf, logger);
    }

    private CloseableHttpResponse retrieveResponse(CloseableHttpClient httpclient, URL url, String method, RequestData rdate, URLCredentials credentials) throws URISyntaxException, IOException {
        HashMap reqHeaders;
        HttpGet req = null;
        CloseableHttpResponse response = null;
        if (method == null) {
            method = rdate != null && rdate.getPostdata() != null || rdate != null && rdate.getPostStream() != null ? "POST" : "GET";
        }
        URIBuilder builder = new URIBuilder(url.toURI());
        if (rdate != null) {
            for (Parameters p : rdate.getParam()) {
                builder.addParameter(p.getName(), p.getValue());
            }
        }
        if (method.equals("GET")) {
            req = new HttpGet(builder.build());
        } else if (method.equals("DELETE")) {
            req = new HttpDelete(builder.build());
        } else if (method.equals("POST") || method.equals("PUT")) {
            BufferedHttpEntity entity;
            HttpPost preq = null;
            if (method.equals("POST")) {
                preq = new HttpPost(builder.build());
            } else if (method.equals("PUT")) {
                preq = new HttpPut(builder.build());
            }
            if (rdate != null && rdate.getPostdata() != null) {
                entity = new BufferedHttpEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(rdate.getPostdata())));
                preq.setEntity((HttpEntity)entity);
            } else if (rdate != null && rdate.getPostStream() != null) {
                entity = new BufferedHttpEntity((HttpEntity)new InputStreamEntity(rdate.getPostStream()));
                preq.setEntity((HttpEntity)entity);
            }
            req = preq;
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.connectionTimeOut).setConnectionRequestTimeout(this.connectionTimeOut).setSocketTimeout(this.readTimeOut).setRedirectsEnabled(this.conf.isFollowRedirect()).build();
        req.setConfig(config);
        if (logger.isDebugEnabled()) {
            logger.debug("Executing request " + req.getRequestLine() + " to " + req);
        }
        if (credentials != null) {
            if (credentials.getUser() != null && credentials.getPassword() != null) {
                req.addHeader("Authorization", "Basic " + new String(Base64.encode((byte[])(credentials.getUser() + ":" + credentials.getPassword()).getBytes())));
            } else if (credentials.getToken() != null && !credentials.getToken().isEmpty()) {
                req.addHeader("Authorization", "Bearer " + credentials.getToken());
            }
        }
        if (rdate != null && rdate.getType() != null) {
            if (rdate.getType().equals("TSA")) {
                req.addHeader("Content-Type", "application/timestamp-query");
            } else if (rdate.getType().equals("SOAP")) {
                req.addHeader("Content-Type", "text/xml;charset=UTF-8");
            } else if (rdate.getType().equals("JSON")) {
                req.addHeader("Content-Type", "application/json");
            } else if (rdate.getType().equals("OCSP")) {
                req.addHeader("Content-Type", "application/ocsp-request");
            }
            if (rdate.getSoapAction() != null && !rdate.getSoapAction().equals("")) {
                if (rdate.getSoapAction().equals("empty")) {
                    req.addHeader("SOAPAction", "");
                } else {
                    req.addHeader("SOAPAction", rdate.getSoapAction());
                }
            }
        }
        if (rdate != null && rdate.getAcceptHeader() != null) {
            req.setHeader("Accept", rdate.getAcceptHeader());
        }
        if (rdate != null && rdate.getContentType() != null) {
            req.setHeader("Content-Type", rdate.getContentType());
        }
        if ((reqHeaders = HttpAdditionalInfoUtils.listAdditionalHeaders()) != null) {
            for (String key : reqHeaders.keySet()) {
                req.setHeader(key, (String)reqHeaders.get(key));
            }
        }
        try {
            response = httpclient.execute((HttpUriRequest)req);
            logger.debug("----------------------------------------");
            logger.debug(response.getStatusLine().toString());
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            ex.printStackTrace();
            throw new IOException("Errore http");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UrlReturn urlRequest(URL url, String method, RequestData rdate, URLCredentials credentials, OutputStream os, DownloadProgressNotifier notifier) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        UrlReturn ret;
        block10: {
            CloseableHttpClient httpclient = null;
            CloseableHttpResponse response = null;
            ret = new UrlReturn();
            ret.setStatus("KO");
            try {
                InputStream objIn;
                httpclient = this.initProvider(this.connectionTimeOut, this.readTimeOut, url, credentials);
                response = this.retrieveResponse(httpclient, url, method, rdate, credentials);
                long size = response.getEntity().getContentLength();
                long currentSize = 0L;
                if (notifier != null) {
                    notifier.notify(size, currentSize);
                }
                if ((objIn = response.getEntity().getContent()) == null) break block10;
                if (response.getStatusLine().getStatusCode() == 200) {
                    byte[] buffer = new byte[64000];
                    int letti = objIn.read(buffer);
                    while (letti != -1) {
                        if (notifier != null) {
                            notifier.notify(size, currentSize += (long)letti);
                        }
                        os.write(buffer, 0, letti);
                        letti = objIn.read(buffer);
                    }
                    objIn.close();
                    ArrayList<String> cookieList = new ArrayList<String>();
                    Header[] headers = response.getAllHeaders();
                    for (int i = 0; i < headers.length; ++i) {
                        Header header = headers[i];
                        if (!"Set-Cookie".equalsIgnoreCase(header.getName())) continue;
                        logger.debug("Cookie found: " + header.getValue());
                        cookieList.add(header.getValue());
                    }
                    ret.setCookieList(cookieList);
                    String urlpath = url.getHost() + url.getPort() + url.getDefaultPort() + url.getProtocol();
                    this.conf.getAuth().getOldCredential().remove(urlpath);
                    ret.setStatus("OK");
                    ret.setStatusMessage("OK");
                    break block10;
                }
                byte[] buffer = new byte[64000];
                int letti = objIn.read(buffer);
                ByteArrayOutputStream objOut = new ByteArrayOutputStream();
                while (letti != -1) {
                    objOut.write(buffer, 0, letti);
                    letti = objIn.read(buffer);
                }
                objOut.close();
                throw new HttpStatusException(response.getStatusLine().getStatusCode(), objOut.toByteArray(), (Throwable)new Exception(""));
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        return ret;
    }

    private Object getNewHttpClient(URL url, Proxy p, int connectTimeout, boolean useCache) throws IOException {
        throw new IOException("UNSUPPORTED PROXY FECH JDK 9");
    }

    public Date getLastModifiedDate(URL url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        CloseableHttpClient httpclient = this.initProvider(this.connectionTimeOut, this.readTimeOut, url, credentials);
        HttpHead request = new HttpHead(url.toString());
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);
        String lastModified = response.getFirstHeader("Last-Modified").getValue();
        return new Date(lastModified);
    }

    private CloseableHttpClient initProvider(int connectionTimeOut, int readTimeOut, URL url, URLCredentials credentials) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, IOException, URISyntaxException {
        return this.initProvider(connectionTimeOut, readTimeOut, url, credentials, null);
    }

    private CloseableHttpClient initProvider(int connectionTimeOut, int readTimeOut, URL url, URLCredentials credentials, HttpResponseInterceptor interceptor) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, IOException, URISyntaxException {
        logger.debug("Init Apache Provider [START]");
        CloseableHttpClient httpclient = null;
        SSLContext sslContext = null;
        CapiSSLConnectionSocketFactory sslSocketFactory = null;
        HttpClientBuilder cb = null;
        SystemDefaultCredentialsProvider credsProvider = new SystemDefaultCredentialsProvider();
        boolean isWindows = false;
        if (Platform.isWindows()) {
            if (!WinHttpClients.isWinAuthAvailable()) {
                logger.debug("Integrated Win auth is not supported!!!");
            }
            cb = WinHttpClients.custom();
            isWindows = true;
        } else {
            cb = HttpClients.custom();
        }
        if (this.conf.getConnectionTimeOut() != null && this.conf.getReadTimeOut() != null) {
            int val2;
            if (this.conf.getConnectionTimeOut().equals("0")) {
                this.connectionTimeOut = 0;
            }
            if (this.conf.getReadTimeOut().equals("0")) {
                this.readTimeOut = 0;
            }
            try {
                val2 = Integer.parseInt(this.conf.getConnectionTimeOut());
                if (val2 >= 3000) {
                    this.connectionTimeOut = val2;
                }
            }
            catch (Exception val2) {
                // empty catch block
            }
            try {
                val2 = Integer.parseInt(this.conf.getReadTimeOut());
                if (val2 >= 2000) {
                    this.readTimeOut = val2;
                }
            }
            catch (Exception val3) {}
        } else {
            this.connectionTimeOut = connectionTimeOut;
            this.readTimeOut = readTimeOut;
        }
        logger.debug("Configurato Time out");
        HostnameVerifier hostNameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        if (this.sslHallHostVerified) {
            hostNameVerifier = new NoopHostnameVerifier();
        }
        if (url.getProtocol().equals("https")) {
            if (credentials == null || credentials.getKeystore() == null) {
                sslSocketFactory = new CapiSSLConnectionSocketFactory(this.getDefaultSSLContext(), hostNameVerifier, this.conf);
            }
            if (sslSocketFactory == null) {
                KeyManager[] km = null;
                if (credentials != null && credentials.getKeystore() != null && !credentials.getKeystore().equals("")) {
                    KeyManagerFactory kmf = null;
                    try {
                        kmf = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
                        kmf.init(credentials.getKeystore(), credentials.getKeystorepwd().toCharArray());
                        km = kmf.getKeyManagers();
                    }
                    catch (Exception ex) {
                        logger.debug("Impossibile istanziare il provider ORACLE provo a instaziare il provider IBM");
                        kmf = KeyManagerFactory.getInstance("IbmX509");
                        kmf.init(credentials.getKeystore(), credentials.getKeystorepwd().toCharArray());
                        km = kmf.getKeyManagers();
                        logger.debug("provider IbmX509 impostato");
                    }
                }
                sslContext = System.getProperty("java.vm.vendor").contains("IBM") ? SSLContext.getInstance("TLSv1") : SSLContext.getInstance("SSL");
                if (this.sslTrustAllRoot) {
                    this.tm = new TrustManager[1];
                    this.tm[0] = new NullTrustManager();
                    sslContext.init(km, this.tm, null);
                } else {
                    sslContext.init(km, this.tm, null);
                }
                sslSocketFactory = new CapiSSLConnectionSocketFactory(sslContext, hostNameVerifier, this.conf);
            }
        }
        if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1") && this.conf.isProxyHost(url.toString())) {
            this.setupProxy(this.conf, url, logger);
            if (this.conf.getProxyType().startsWith("http") && isWindows) {
                cb.setProxy(new HttpHost(this.conf.getProxy(), Integer.parseInt(this.conf.getProxyPort()), "http"));
            } else {
                Registry registry = RegistryBuilder.create().register("http", (Object)new CapiConnectionSocketFactory(this.conf)).register("https", (Object)(sslSocketFactory != null ? sslSocketFactory : new CapiSSLConnectionSocketFactory(SSLContext.getDefault(), hostNameVerifier, this.conf))).build();
                cb.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(registry));
            }
        }
        if (!this.conf.getProxyType().equalsIgnoreCase("direct") || !this.conf.getLdapProxyType().equalsIgnoreCase("direct")) {
            this.conf.getAuth().setProxyConfig(this.conf.getProxy(), this.conf);
            this.usingProxy = true;
        }
        if (credentials != null && credentials.getUser() != null && !credentials.getUser().equals("")) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(credentials.getUser(), credentials.getPassword());
            AuthScope authScope = new AuthScope(url.getHost(), url.getPort());
            credsProvider.setCredentials(authScope, (Credentials)creds);
            cb.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectionTimeOut).setConnectionRequestTimeout(this.connectionTimeOut).setSocketTimeout(this.readTimeOut).build();
        cb.setDefaultRequestConfig(requestConfig);
        logger.debug("Configurato Proxy");
        if (interceptor != null) {
            cb.addInterceptorLast(interceptor);
        }
        httpclient = cb.build();
        logger.debug("Init Apache Provider [END]");
        return httpclient;
    }

    private void setupProxy(NetworkConfig conf, URL url, Logger logger) throws URISyntaxException {
        if (conf.isAutomaticProxyDiscovery()) {
            logger.debug("Tentativo selezione proxy automatica");
            ProxySelector sel = conf.getDefaultproxyselector();
            Proxy proxSel = null;
            if (sel != null) {
                URI uri = url.toURI();
                Iterator<Proxy> it = sel.select(uri).iterator();
                while (it.hasNext()) {
                    proxSel = it.next();
                    try {
                        if (proxSel == Proxy.NO_PROXY) continue;
                        proxSel = new Proxy(proxSel.type(), proxSel.address());
                        logger.debug("Utilizzo il proxy : " + (Object)((Object)proxSel.type()) + " - " + proxSel.address());
                    }
                    catch (Exception ex) {
                        logger.error("Errore connessione proxy:" + proxSel.address(), (Throwable)ex);
                        if (proxSel == Proxy.NO_PROXY) continue;
                        sel.connectFailed(uri, proxSel.address(), new IOException(ex));
                        if (it.hasNext()) continue;
                    }
                    break;
                }
            }
            if (proxSel != null) {
                InetSocketAddress sa = (InetSocketAddress)proxSel.address();
                if (url.getProtocol().startsWith("http")) {
                    this.setProxyConfiguration("http", sa.getAddress() != null ? sa.getAddress().getHostAddress() : sa.getHostName(), String.valueOf(sa.getPort()), proxSel.type().name());
                } else if (url.getProtocol().startsWith("ldap")) {
                    this.setProxyConfiguration("ldap", sa.getAddress() != null ? sa.getAddress().getHostAddress() : sa.getHostName(), String.valueOf(sa.getPort()), proxSel.type().name());
                }
            } else if (url.getProtocol().startsWith("http")) {
                this.setProxyConfiguration("http", "", "", "direct");
            } else if (url.getProtocol().startsWith("ldap")) {
                this.setProxyConfiguration("ldap", "", "", "direct");
            }
        } else if (conf.getProxy() != null && !conf.getProxy().equals("")) {
            if (conf.getProxyPort() != null && !conf.getProxyPort().equals("")) {
                if (url.getProtocol().startsWith("http")) {
                    this.setProxyConfiguration("http", conf.getProxy(), conf.getProxyPort(), conf.getProxyType());
                } else if (url.getProtocol().startsWith("ldap")) {
                    this.setProxyConfiguration("ldap", conf.getProxy(), conf.getProxyPort(), conf.getProxyType());
                }
            } else if (url.getProtocol().startsWith("http")) {
                this.setProxyConfiguration("http", conf.getProxy(), conf.getProxyType().equals("socks") ? "1080" : "8080", conf.getProxyType());
            } else if (url.getProtocol().startsWith("ldap")) {
                this.setProxyConfiguration("ldap", conf.getProxy(), conf.getProxyType().equals("socks") ? "1080" : "8080", conf.getProxyType());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Richiesta proxy non automatica:" + conf.getProxyType() + "://" + conf.getProxy() + ":" + conf.getProxyPort());
            }
        } else if (url.getProtocol().startsWith("http")) {
            this.setProxyConfiguration("http", "", "", "direct");
        } else if (url.getProtocol().startsWith("ldap")) {
            this.setProxyConfiguration("ldap", "", "", "direct");
        }
    }

    public Long getContentLengthLong(URL url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        CloseableHttpClient httpclient = this.initProvider(this.connectionTimeOut, this.readTimeOut, url, credentials);
        HttpHead request = new HttpHead(url.toURI());
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);
        String content = response.getFirstHeader("Content-Length").getValue();
        return new Long(content);
    }

    public Proxy fech_proxy(URL url) {
        int connectionTimeOut = 3000;
        int readTimeOut = 5000;
        Proxy proxy = null;
        logger.debug("Tenattivo selezione proxy automatica");
        ProxySelector sel = this.conf.getDefaultproxyselector();
        if (sel != null) {
            try {
                URI uri = url.toURI();
                Iterator<Proxy> it = sel.select(uri).iterator();
                while (it.hasNext()) {
                    proxy = it.next();
                    try {
                        if (proxy != Proxy.NO_PROXY) {
                            proxy = null;
                            continue;
                        }
                        proxy = new Proxy(proxy.type(), proxy.address());
                        logger.debug("Utilizzo il proxy : " + (Object)((Object)proxy.type()) + " - " + proxy.address().toString());
                        break;
                    }
                    catch (Exception ex) {
                        logger.error("Errore connessione proxy:" + proxy.address(), (Throwable)ex);
                        if (proxy != Proxy.NO_PROXY) {
                            sel.connectFailed(uri, proxy.address(), new IOException(ex));
                            if (it.hasNext()) continue;
                            proxy = null;
                            break;
                        }
                        proxy = null;
                    }
                }
            }
            catch (URISyntaxException ex) {
                logger.error("Errore Sintassi URI : " + url.toString(), (Throwable)ex);
            }
        }
        return proxy;
    }

    public Date getLastModifiedDate(String url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        return this.getLastModifiedDate(new URL(url), credentials);
    }

    public InputStream getInputStream(URL url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        CloseClientInputStream objRet = null;
        CloseableHttpClient httpclient = null;
        CloseableHttpResponse response = null;
        httpclient = this.initProvider(this.connectionTimeOut, this.readTimeOut, url, credentials);
        response = this.retrieveResponse(httpclient, url, null, null, credentials);
        objRet = new CloseClientInputStream((Closeable)response, response.getEntity().getContent());
        return objRet;
    }

    public MultipartWrapper getMultipartWrapper(URL url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        CloseableHttpClient client = this.initProvider(this.connectionTimeOut, this.readTimeOut, url, credentials);
        return new ApacheHttpClientMultipartWrapper((HttpClient)client, url);
    }

    public Long getContentLengthLong(String url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        return this.getContentLengthLong(new URL(url), credentials);
    }

    public HttpURLConnection getHttpURLConnection(URL url, URLCredentials credentials) throws IOException, KeyManagementException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, URISyntaxException {
        return new HttpsURLConnection(url, credentials);
    }

    private class HttpsURLConnection
    extends javax.net.ssl.HttpsURLConnection {
        private URLCredentials credentials;
        private Map<String, String> requestProperties;
        private Certificate[] certificates;
        private Certificate[] localCertificates;
        private String cipherSuit;
        private CloseableHttpResponse response;
        private CloseableHttpClient client;
        private OutputStream out;
        private boolean changed;

        @Override
        public String getCipherSuite() {
            return this.cipherSuit;
        }

        @Override
        public Certificate[] getLocalCertificates() {
            return this.localCertificates;
        }

        @Override
        public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
            return this.certificates;
        }

        public HttpsURLConnection(URL url, URLCredentials credentials) throws IOException, KeyManagementException, KeyStoreException, NoSuchAlgorithmException, URISyntaxException, UnrecoverableKeyException {
            super(url);
            this.requestProperties = new HashMap<String, String>();
            this.certificates = null;
            this.localCertificates = null;
            this.response = null;
            this.client = null;
            this.out = new ConnectionOutputStream();
            this.changed = false;
            this.credentials = credentials;
            this.client = ApacheHttpClientProvider.this.initProvider(ApacheHttpClientProvider.this.connectionTimeOut, ApacheHttpClientProvider.this.readTimeOut, url, credentials, new HttpResponseInterceptor(){

                public void process(HttpResponse hr, HttpContext hc) throws HttpException, IOException {
                    SSLSession sslSession;
                    ManagedHttpClientConnection routedConnection = (ManagedHttpClientConnection)hc.getAttribute("http.connection");
                    if (routedConnection.isOpen() && (sslSession = routedConnection.getSSLSession()) != null) {
                        HttpsURLConnection.access$102(HttpsURLConnection.this, sslSession.getPeerCertificates());
                        HttpsURLConnection.this.cipherSuit = sslSession.getCipherSuite();
                        HttpsURLConnection.access$302(HttpsURLConnection.this, sslSession.getLocalCertificates());
                    }
                }
            });
        }

        @Override
        public void disconnect() {
            try {
                this.client.close();
                this.requestProperties = null;
                HttpAdditionalInfoUtils.clearHeaders();
                this.response = null;
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.connected = false;
            }
        }

        @Override
        public boolean usingProxy() {
            return ApacheHttpClientProvider.this.usingProxy;
        }

        @Override
        public void connect() throws IOException {
            try {
                this.exec();
                this.connected = true;
            }
            catch (IOException ex) {
                throw new IOException(ex);
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }

        private void exec() throws IOException, URISyntaxException {
            RequestData data = new RequestData();
            data.setContentType(this.getContentType());
            if ((this.getRequestMethod().equalsIgnoreCase("POST") || this.getRequestMethod().equalsIgnoreCase("PUT")) && ((ByteArrayOutputStream)this.out).size() > 0) {
                data.setPostdata(((ByteArrayOutputStream)this.out).toByteArray());
            }
            HttpAdditionalInfoUtils.getAdditionalHeaders().putAll(this.requestProperties);
            this.response = ApacheHttpClientProvider.this.retrieveResponse(this.client, this.url, this.getRequestMethod(), data, this.credentials);
            this.setResponseCode(this.response.getStatusLine().getStatusCode());
            this.setResponseMessage(this.response.getStatusLine().getReasonPhrase());
            this.changed = false;
            this.out.close();
            this.out = new ByteArrayOutputStream();
        }

        public void setResponseCode(int responseCode) {
            this.responseCode = responseCode;
        }

        public void setResponseMessage(String responseMessage) {
            this.responseMessage = responseMessage;
        }

        @Override
        public int getConnectTimeout() {
            return ApacheHttpClientProvider.this.connectionTimeOut;
        }

        @Override
        public int getResponseCode() throws IOException {
            try {
                if (this.changed) {
                    this.exec();
                }
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
            return this.responseCode;
        }

        @Override
        public String getResponseMessage() throws IOException {
            try {
                if (this.changed) {
                    this.exec();
                }
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
            return this.responseMessage;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                if (this.changed) {
                    this.exec();
                }
                return this.response.getEntity().getContent();
            }
            catch (NullPointerException ex) {
                throw new IOException(ex);
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.doOutput) {
                return this.out;
            }
            throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
        }

        @Override
        public void setRequestProperty(String key, String value) {
            this.requestProperties.put(key, value);
        }

        static /* synthetic */ Certificate[] access$102(HttpsURLConnection x0, Certificate[] x1) {
            x0.certificates = x1;
            return x1;
        }

        static /* synthetic */ Certificate[] access$302(HttpsURLConnection x0, Certificate[] x1) {
            x0.localCertificates = x1;
            return x1;
        }

        private class ConnectionOutputStream
        extends ByteArrayOutputStream {
            private ConnectionOutputStream() {
            }

            @Override
            public void write(byte[] b) throws IOException {
                super.write(b);
                HttpsURLConnection.this.changed = true;
            }

            @Override
            public synchronized void write(int b) {
                super.write(b);
                HttpsURLConnection.this.changed = true;
            }

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                super.write(b, off, len);
                HttpsURLConnection.this.changed = true;
            }

            @Override
            public void flush() throws IOException {
                super.flush();
                HttpsURLConnection.this.changed = true;
            }
        }
    }
}

