/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.inputs;

import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.util.CacheOutputStream;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.ClonerInputStream;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;

public abstract class CloudInputHandler
extends InputHandler {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    protected DataHandler.CLOUD_TYPE cloudType = null;
    protected CloudReadProxyInputStream originalStream = null;
    protected CacheOutputStream clonedStream = null;
    protected ClonerInputStream clonerStream = null;

    public DataHandler.CLOUD_TYPE getCloudType() {
        return this.cloudType;
    }

    protected CloudInputHandler() {
    }

    protected final void initCloudInputHandler(DataHandler.CLOUD_TYPE cLOUD_TYPE, String string) throws IOException {
        if (cLOUD_TYPE == null) {
            throw new IllegalArgumentException("Please specify a cloud type!");
        }
        this.initDataHandler(DataHandler.DATA_TYPE.CLOUD, string, null);
        this.originalStream = this.getCloudReadProxyInputStream();
        this.clonedStream = new CacheOutputStream();
        this.clonerStream = new ClonerInputStream(this.originalStream, (OutputStream)this.clonedStream);
        this.cloudType = cLOUD_TYPE;
    }

    @Override
    protected InputStream customGetInputAsNewStream() {
        InputStream inputStream = null;
        try {
            inputStream = this.clonerStream.getSlaveInputStream(this.clonedStream.getCache());
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        return inputStream;
    }

    protected abstract CloudReadProxyInputStream getCloudReadProxyInputStream();

    protected abstract class CloudReadProxyInputStream
    extends InputStream {
        protected CloudReadProxyInputStream(CloudInputHandler cloudInputHandler) {
        }
    }
}

