/* libhandy-1.vapi generated by vapigen.EXE, do not modify. */

[CCode (cprefix = "Hdy", gir_namespace = "Handy", gir_version = "1", lower_case_cprefix = "hdy_")]
namespace Hdy {
	[CCode (cheader_filename = "handy.h", type_id = "hdy_action_row_get_type ()")]
	[Version (since = "1.0")]
	public class ActionRow : Hdy.PreferencesRow, Atk.Implementor, Gtk.Actionable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ActionRow ();
		public virtual void activate ();
		public void add_prefix (Gtk.Widget widget);
		public unowned Gtk.Widget? get_activatable_widget ();
		public unowned string get_icon_name ();
		public unowned string? get_subtitle ();
		[Version (since = "1.2")]
		public int get_subtitle_lines ();
		[Version (since = "1.2")]
		public int get_title_lines ();
		public bool get_use_underline ();
		public void set_activatable_widget (Gtk.Widget? widget);
		public void set_icon_name (string icon_name);
		public void set_subtitle (string? subtitle);
		[Version (since = "1.2")]
		public void set_subtitle_lines (int subtitle_lines);
		[Version (since = "1.2")]
		public void set_title_lines (int title_lines);
		public void set_use_underline (bool use_underline);
		public Gtk.Widget activatable_widget { get; set; }
		public string icon_name { get; set; }
		public string subtitle { get; set; }
		[Version (since = "1.2")]
		public int subtitle_lines { get; set; }
		[Version (since = "1.2")]
		public int title_lines { get; set; }
		public bool use_underline { get; set; }
		public signal void activated ();
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_application_window_get_type ()")]
	[Version (since = "1.0")]
	public class ApplicationWindow : Gtk.ApplicationWindow, Atk.Implementor, GLib.ActionGroup, GLib.ActionMap, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ApplicationWindow ();
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_avatar_get_type ()")]
	[Version (since = "1.0")]
	public class Avatar : Gtk.DrawingArea, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Avatar (int size, string? text, bool show_initials);
		[Version (since = "1.2")]
		public Gdk.Pixbuf draw_to_pixbuf (int size, int scale_factor);
		[Version (since = "1.2")]
		public async Gdk.Pixbuf draw_to_pixbuf_async (int size, int scale_factor, GLib.Cancellable? cancellable);
		public unowned string? get_icon_name ();
		[Version (since = "1.2")]
		public unowned GLib.LoadableIcon? get_loadable_icon ();
		public bool get_show_initials ();
		public int get_size ();
		public unowned string? get_text ();
		public void set_icon_name (string? icon_name);
		[Version (deprecated = true, deprecated_since = "1.2", since = "1.0")]
		public void set_image_load_func (owned Hdy.AvatarImageLoadFunc? load_image);
		[Version (since = "1.2")]
		public void set_loadable_icon (GLib.LoadableIcon? icon);
		public void set_show_initials (bool show_initials);
		public void set_size (int size);
		public void set_text (string? text);
		public string icon_name { get; set; }
		[Version (since = "1.2")]
		public GLib.LoadableIcon loadable_icon { get; set; }
		public bool show_initials { get; set; }
		public int size { get; set; }
		public string text { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_carousel_get_type ()")]
	[Version (since = "1.0")]
	public class Carousel : Gtk.EventBox, Atk.Implementor, Gtk.Buildable, Gtk.Orientable, Hdy.Swipeable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Carousel ();
		[Version (since = "1.2")]
		public bool get_allow_long_swipes ();
		public bool get_allow_mouse_drag ();
		[Version (since = "1.4")]
		public bool get_allow_scroll_wheel ();
		public uint get_animation_duration ();
		public bool get_interactive ();
		public uint get_n_pages ();
		public double get_position ();
		public uint get_reveal_duration ();
		public uint get_spacing ();
		public void insert (Gtk.Widget child, int position);
		public void prepend (Gtk.Widget child);
		public void reorder (Gtk.Widget child, int position);
		public void scroll_to (Gtk.Widget widget);
		public void scroll_to_full (Gtk.Widget widget, int64 duration);
		[Version (since = "1.2")]
		public void set_allow_long_swipes (bool allow_long_swipes);
		public void set_allow_mouse_drag (bool allow_mouse_drag);
		[Version (since = "1.4")]
		public void set_allow_scroll_wheel (bool allow_scroll_wheel);
		public void set_animation_duration (uint duration);
		public void set_interactive (bool interactive);
		public void set_reveal_duration (uint reveal_duration);
		public void set_spacing (uint spacing);
		[Version (since = "1.2")]
		public bool allow_long_swipes { get; set; }
		public bool allow_mouse_drag { get; set; }
		[Version (since = "1.4")]
		public bool allow_scroll_wheel { get; set; }
		public uint animation_duration { get; set; }
		public bool interactive { get; set; }
		public uint n_pages { get; }
		public double position { get; }
		public uint reveal_duration { get; set; }
		public uint spacing { get; set; }
		public signal void page_changed (uint index);
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_carousel_indicator_dots_get_type ()")]
	[Version (since = "1.0")]
	public class CarouselIndicatorDots : Gtk.DrawingArea, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public CarouselIndicatorDots ();
		public unowned Hdy.Carousel? get_carousel ();
		public void set_carousel (Hdy.Carousel? carousel);
		public Hdy.Carousel carousel { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_carousel_indicator_lines_get_type ()")]
	[Version (since = "1.0")]
	public class CarouselIndicatorLines : Gtk.DrawingArea, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public CarouselIndicatorLines ();
		public unowned Hdy.Carousel? get_carousel ();
		public void set_carousel (Hdy.Carousel? carousel);
		public Hdy.Carousel carousel { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_clamp_get_type ()")]
	[Version (since = "1.0")]
	public class Clamp : Gtk.Bin, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Clamp ();
		public int get_maximum_size ();
		public int get_tightening_threshold ();
		public void set_maximum_size (int maximum_size);
		public void set_tightening_threshold (int tightening_threshold);
		public int maximum_size { get; set; }
		public int tightening_threshold { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_combo_row_get_type ()")]
	[Version (since = "1.0")]
	public class ComboRow : Hdy.ActionRow, Atk.Implementor, Gtk.Actionable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ComboRow ();
		public void bind_model (GLib.ListModel? model, Gtk.ListBoxCreateWidgetFunc? create_list_widget_func, owned Gtk.ListBoxCreateWidgetFunc? create_current_widget_func);
		public void bind_name_model (GLib.ListModel? model, owned Hdy.ComboRowGetNameFunc? get_name_func);
		public unowned GLib.ListModel? get_model ();
		public int get_selected_index ();
		public bool get_use_subtitle ();
		public void set_for_enum (GLib.Type enum_type, owned Hdy.ComboRowGetEnumValueNameFunc? get_name_func);
		public void set_get_name_func (owned Hdy.ComboRowGetNameFunc? get_name_func);
		public void set_selected_index (int selected_index);
		public void set_use_subtitle (bool use_subtitle);
		public int selected_index { get; set; }
		public bool use_subtitle { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_deck_get_type ()")]
	[Version (since = "1.0")]
	public class Deck : Gtk.Container, Atk.Implementor, Gtk.Buildable, Gtk.Orientable, Hdy.Swipeable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Deck ();
		public unowned Gtk.Widget? get_adjacent_child (Hdy.NavigationDirection direction);
		public bool get_can_swipe_back ();
		public bool get_can_swipe_forward ();
		public unowned Gtk.Widget? get_child_by_name (string name);
		public bool get_homogeneous (Gtk.Orientation orientation);
		public bool get_interpolate_size ();
		public uint get_transition_duration ();
		public bool get_transition_running ();
		public Hdy.DeckTransitionType get_transition_type ();
		public unowned Gtk.Widget get_visible_child ();
		public unowned string get_visible_child_name ();
		[Version (since = "1.2")]
		public void insert_child_after (Gtk.Widget child, Gtk.Widget? sibling);
		public bool navigate (Hdy.NavigationDirection direction);
		[Version (since = "1.2")]
		public void prepend (Gtk.Widget child);
		[Version (since = "1.2")]
		public void reorder_child_after (Gtk.Widget child, Gtk.Widget? sibling);
		public void set_can_swipe_back (bool can_swipe_back);
		public void set_can_swipe_forward (bool can_swipe_forward);
		public void set_homogeneous (Gtk.Orientation orientation, bool homogeneous);
		public void set_interpolate_size (bool interpolate_size);
		public void set_transition_duration (uint duration);
		public void set_transition_type (Hdy.DeckTransitionType transition);
		public void set_visible_child (Gtk.Widget visible_child);
		public void set_visible_child_name (string name);
		public bool can_swipe_back { get; set; }
		public bool can_swipe_forward { get; set; }
		[NoAccessorMethod]
		public bool hhomogeneous { get; set; }
		public bool interpolate_size { get; set; }
		public uint transition_duration { get; set; }
		public bool transition_running { get; }
		public Hdy.DeckTransitionType transition_type { get; set; }
		[NoAccessorMethod]
		public bool vhomogeneous { get; set; }
		public Gtk.Widget visible_child { get; set; }
		public string visible_child_name { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_enum_value_object_get_type ()")]
	[Version (since = "1.0")]
	public class EnumValueObject : GLib.Object {
		[CCode (has_construct_function = false)]
		public EnumValueObject (GLib.EnumValue enum_value);
		public unowned string get_name ();
		public unowned string get_nick ();
		public int get_value ();
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_expander_row_get_type ()")]
	[Version (since = "1.0")]
	public class ExpanderRow : Hdy.PreferencesRow, Atk.Implementor, Gtk.Actionable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ExpanderRow ();
		public void add_action (Gtk.Widget widget);
		public void add_prefix (Gtk.Widget widget);
		public bool get_enable_expansion ();
		public bool get_expanded ();
		public unowned string get_icon_name ();
		public bool get_show_enable_switch ();
		public unowned string? get_subtitle ();
		public bool get_use_underline ();
		public void set_enable_expansion (bool enable_expansion);
		public void set_expanded (bool expanded);
		public void set_icon_name (string icon_name);
		public void set_show_enable_switch (bool show_enable_switch);
		public void set_subtitle (string? subtitle);
		public void set_use_underline (bool use_underline);
		public bool enable_expansion { get; set; }
		public bool expanded { get; set; }
		public string icon_name { get; set; }
		public bool show_enable_switch { get; set; }
		public string subtitle { get; set; }
		public bool use_underline { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_flap_get_type ()")]
	[Version (since = "1.2")]
	public class Flap : Gtk.Container, Atk.Implementor, Gtk.Buildable, Gtk.Orientable, Hdy.Swipeable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Flap ();
		public unowned Gtk.Widget? get_content ();
		public unowned Gtk.Widget? get_flap ();
		public Gtk.PackType get_flap_position ();
		public uint get_fold_duration ();
		public Hdy.FlapFoldPolicy get_fold_policy ();
		public bool get_folded ();
		public bool get_locked ();
		public bool get_modal ();
		public uint get_reveal_duration ();
		public bool get_reveal_flap ();
		public double get_reveal_progress ();
		public unowned Gtk.Widget? get_separator ();
		public bool get_swipe_to_close ();
		public bool get_swipe_to_open ();
		public Hdy.FlapTransitionType get_transition_type ();
		public void set_content (Gtk.Widget? content);
		public void set_flap (Gtk.Widget? flap);
		public void set_flap_position (Gtk.PackType position);
		public void set_fold_duration (uint duration);
		public void set_fold_policy (Hdy.FlapFoldPolicy policy);
		public void set_locked (bool locked);
		public void set_modal (bool modal);
		public void set_reveal_duration (uint duration);
		public void set_reveal_flap (bool reveal_flap);
		public void set_separator (Gtk.Widget? separator);
		public void set_swipe_to_close (bool swipe_to_close);
		public void set_swipe_to_open (bool swipe_to_open);
		public void set_transition_type (Hdy.FlapTransitionType transition_type);
		public Gtk.Widget content { get; set; }
		public Gtk.Widget flap { get; set; }
		public Gtk.PackType flap_position { get; set; }
		public uint fold_duration { get; set; }
		public Hdy.FlapFoldPolicy fold_policy { get; set; }
		public bool folded { get; }
		public bool locked { get; set; }
		public bool modal { get; set; }
		public uint reveal_duration { get; set; }
		public bool reveal_flap { get; set; }
		public double reveal_progress { get; }
		public Gtk.Widget separator { get; set; }
		public bool swipe_to_close { get; set; }
		public bool swipe_to_open { get; set; }
		public Hdy.FlapTransitionType transition_type { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_header_bar_get_type ()")]
	[Version (since = "1.0")]
	public class HeaderBar : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public HeaderBar ();
		public Hdy.CenteringPolicy get_centering_policy ();
		public unowned Gtk.Widget? get_custom_title ();
		public unowned string get_decoration_layout ();
		public bool get_has_subtitle ();
		public bool get_interpolate_size ();
		public bool get_show_close_button ();
		public unowned string? get_subtitle ();
		public unowned string? get_title ();
		public uint get_transition_duration ();
		public bool get_transition_running ();
		public void pack_end (Gtk.Widget child);
		public void pack_start (Gtk.Widget child);
		public void set_centering_policy (Hdy.CenteringPolicy centering_policy);
		public void set_custom_title (Gtk.Widget? title_widget);
		public void set_decoration_layout (string? layout);
		public void set_has_subtitle (bool setting);
		public void set_interpolate_size (bool interpolate_size);
		public void set_show_close_button (bool setting);
		public void set_subtitle (string? subtitle);
		public void set_title (string? title);
		public void set_transition_duration (uint duration);
		public Hdy.CenteringPolicy centering_policy { get; set; }
		public Gtk.Widget custom_title { get; set; }
		public string decoration_layout { get; set; }
		[NoAccessorMethod]
		public bool decoration_layout_set { get; set; }
		public bool has_subtitle { get; set; }
		public bool interpolate_size { get; set; }
		public bool show_close_button { get; set; }
		[NoAccessorMethod]
		public int spacing { get; set; }
		public string subtitle { get; set; }
		public string title { get; set; }
		public uint transition_duration { get; set; }
		public bool transition_running { get; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_header_group_get_type ()")]
	[Version (since = "1.0")]
	public class HeaderGroup : GLib.Object, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public HeaderGroup ();
		public void add_gtk_header_bar (Gtk.HeaderBar header_bar);
		public void add_header_bar (Hdy.HeaderBar header_bar);
		public void add_header_group (Hdy.HeaderGroup header_group);
		public unowned GLib.SList<Hdy.HeaderGroupChild> get_children ();
		public bool get_decorate_all ();
		public void remove_child (Hdy.HeaderGroupChild child);
		public void remove_gtk_header_bar (Gtk.HeaderBar header_bar);
		public void remove_header_bar (Hdy.HeaderBar header_bar);
		public void remove_header_group (Hdy.HeaderGroup header_group);
		public void set_decorate_all (bool decorate_all);
		public bool decorate_all { get; set; }
		public signal void update_decoration_layouts ();
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_header_group_child_get_type ()")]
	[Version (since = "1.0")]
	public class HeaderGroupChild : GLib.Object {
		[CCode (has_construct_function = false)]
		protected HeaderGroupChild ();
		public Hdy.HeaderGroupChildType get_child_type ();
		public unowned Gtk.HeaderBar get_gtk_header_bar ();
		public unowned Hdy.HeaderBar get_header_bar ();
		public unowned Hdy.HeaderGroup get_header_group ();
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_keypad_get_type ()")]
	[Version (since = "1.0")]
	public class Keypad : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Keypad (bool symbols_visible, bool letters_visible);
		public uint get_column_spacing ();
		public unowned Gtk.Widget? get_end_action ();
		public unowned Gtk.Entry get_entry ();
		public bool get_letters_visible ();
		public uint get_row_spacing ();
		public unowned Gtk.Widget? get_start_action ();
		public bool get_symbols_visible ();
		public void set_column_spacing (uint spacing);
		public void set_end_action (Gtk.Widget? end_action);
		public void set_entry (Gtk.Entry? entry);
		public void set_letters_visible (bool letters_visible);
		public void set_row_spacing (uint spacing);
		public void set_start_action (Gtk.Widget? start_action);
		public void set_symbols_visible (bool symbols_visible);
		public uint column_spacing { get; set; }
		public Gtk.Widget end_action { get; set; }
		public Gtk.Entry entry { get; set; }
		public bool letters_visible { get; set; }
		public uint row_spacing { get; set; }
		public Gtk.Widget start_action { get; set; }
		public bool symbols_visible { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_leaflet_get_type ()")]
	[Version (since = "1.0")]
	public class Leaflet : Gtk.Container, Atk.Implementor, Gtk.Buildable, Gtk.Orientable, Hdy.Swipeable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Leaflet ();
		public unowned Gtk.Widget? get_adjacent_child (Hdy.NavigationDirection direction);
		public bool get_can_swipe_back ();
		public bool get_can_swipe_forward ();
		public unowned Gtk.Widget? get_child_by_name (string name);
		public uint get_child_transition_duration ();
		public bool get_child_transition_running ();
		public bool get_folded ();
		public bool get_homogeneous (bool folded, Gtk.Orientation orientation);
		public bool get_interpolate_size ();
		public uint get_mode_transition_duration ();
		public Hdy.LeafletTransitionType get_transition_type ();
		public unowned Gtk.Widget get_visible_child ();
		public unowned string get_visible_child_name ();
		[Version (since = "1.2")]
		public void insert_child_after (Gtk.Widget child, Gtk.Widget? sibling);
		public bool navigate (Hdy.NavigationDirection direction);
		[Version (since = "1.2")]
		public void prepend (Gtk.Widget child);
		[Version (since = "1.2")]
		public void reorder_child_after (Gtk.Widget child, Gtk.Widget? sibling);
		public void set_can_swipe_back (bool can_swipe_back);
		public void set_can_swipe_forward (bool can_swipe_forward);
		public void set_child_transition_duration (uint duration);
		public void set_homogeneous (bool folded, Gtk.Orientation orientation, bool homogeneous);
		public void set_interpolate_size (bool interpolate_size);
		public void set_mode_transition_duration (uint duration);
		public void set_transition_type (Hdy.LeafletTransitionType transition);
		public void set_visible_child (Gtk.Widget visible_child);
		public void set_visible_child_name (string name);
		public bool can_swipe_back { get; set; }
		public bool can_swipe_forward { get; set; }
		public uint child_transition_duration { get; set; }
		public bool child_transition_running { get; }
		public bool folded { get; }
		[NoAccessorMethod]
		public bool hhomogeneous_folded { get; set; }
		[NoAccessorMethod]
		public bool hhomogeneous_unfolded { get; set; }
		public bool interpolate_size { get; set; }
		public uint mode_transition_duration { get; set; }
		public Hdy.LeafletTransitionType transition_type { get; set; }
		[NoAccessorMethod]
		public bool vhomogeneous_folded { get; set; }
		[NoAccessorMethod]
		public bool vhomogeneous_unfolded { get; set; }
		public Gtk.Widget visible_child { get; set; }
		public string visible_child_name { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_preferences_group_get_type ()")]
	[Version (since = "1.0")]
	public class PreferencesGroup : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public PreferencesGroup ();
		public unowned string get_description ();
		public unowned string get_title ();
		[Version (since = "1.4")]
		public bool get_use_markup ();
		public void set_description (string description);
		public void set_title (string title);
		[Version (since = "1.4")]
		public void set_use_markup (bool use_markup);
		public string description { get; set; }
		public string title { get; set; }
		[Version (since = "1.4")]
		public bool use_markup { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_preferences_page_get_type ()")]
	[Version (since = "1.0")]
	public class PreferencesPage : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public PreferencesPage ();
		public unowned string? get_icon_name ();
		public unowned string? get_title ();
		public void set_icon_name (string? icon_name);
		public void set_title (string? title);
		public string icon_name { get; set; }
		public string title { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_preferences_row_get_type ()")]
	[Version (since = "1.0")]
	public class PreferencesRow : Gtk.ListBoxRow, Atk.Implementor, Gtk.Actionable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public PreferencesRow ();
		public unowned string? get_title ();
		public bool get_use_underline ();
		public void set_title (string? title);
		public void set_use_underline (bool use_underline);
		public string title { get; set; }
		public bool use_underline { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_preferences_window_get_type ()")]
	[Version (since = "1.0")]
	public class PreferencesWindow : Hdy.Window, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public PreferencesWindow ();
		public void close_subpage ();
		public bool get_can_swipe_back ();
		public bool get_search_enabled ();
		public void present_subpage (Gtk.Widget subpage);
		public void set_can_swipe_back (bool can_swipe_back);
		public void set_search_enabled (bool search_enabled);
		public bool can_swipe_back { get; set; }
		public bool search_enabled { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_search_bar_get_type ()")]
	[Version (since = "1.0")]
	public class SearchBar : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public SearchBar ();
		public void connect_entry (Gtk.Entry entry);
		public bool get_search_mode ();
		public bool get_show_close_button ();
		public bool handle_event (Gdk.Event event);
		public void set_search_mode (bool search_mode);
		public void set_show_close_button (bool visible);
		[NoAccessorMethod]
		public bool search_mode_enabled { get; set; }
		public bool show_close_button { get; set construct; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_squeezer_get_type ()")]
	[Version (since = "1.0")]
	public class Squeezer : Gtk.Container, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Squeezer ();
		public bool get_child_enabled (Gtk.Widget child);
		public bool get_homogeneous ();
		public bool get_interpolate_size ();
		public uint get_transition_duration ();
		public bool get_transition_running ();
		public Hdy.SqueezerTransitionType get_transition_type ();
		public unowned Gtk.Widget? get_visible_child ();
		public float get_xalign ();
		public float get_yalign ();
		public void set_child_enabled (Gtk.Widget child, bool enabled);
		public void set_homogeneous (bool homogeneous);
		public void set_interpolate_size (bool interpolate_size);
		public void set_transition_duration (uint duration);
		public void set_transition_type (Hdy.SqueezerTransitionType transition);
		public void set_xalign (float xalign);
		public void set_yalign (float yalign);
		public bool homogeneous { get; set; }
		public bool interpolate_size { get; set; }
		public uint transition_duration { get; set; }
		public bool transition_running { get; }
		public Hdy.SqueezerTransitionType transition_type { get; set; }
		public Gtk.Widget visible_child { get; }
		public float xalign { get; set; }
		public float yalign { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_status_page_get_type ()")]
	[Version (since = "1.2")]
	public class StatusPage : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public StatusPage ();
		public unowned string? get_description ();
		public unowned string? get_icon_name ();
		public unowned string? get_title ();
		public void set_description (string? description);
		public void set_icon_name (string? icon_name);
		public void set_title (string? title);
		public string description { get; set; }
		public string icon_name { get; set; }
		public string title { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_style_manager_get_type ()")]
	[Version (since = "1.6")]
	public class StyleManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected StyleManager ();
		public Hdy.ColorScheme get_color_scheme ();
		public bool get_dark ();
		public static unowned Hdy.StyleManager get_default ();
		public unowned Gdk.Display get_display ();
		public static unowned Hdy.StyleManager get_for_display (Gdk.Display display);
		public bool get_high_contrast ();
		public bool get_system_supports_color_schemes ();
		public void set_color_scheme (Hdy.ColorScheme color_scheme);
		public Hdy.ColorScheme color_scheme { get; set; }
		public bool dark { get; }
		public Gdk.Display display { get; construct; }
		public bool high_contrast { get; }
		public bool system_supports_color_schemes { get; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_swipe_group_get_type ()")]
	[Version (deprecated = true, deprecated_since = "1.4", since = "1.0")]
	public class SwipeGroup : GLib.Object, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public SwipeGroup ();
		public void add_swipeable (Hdy.Swipeable swipeable);
		public unowned GLib.SList<Hdy.Swipeable> get_swipeables ();
		public void remove_swipeable (Hdy.Swipeable swipeable);
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_swipe_tracker_get_type ()")]
	[Version (since = "1.0")]
	public class SwipeTracker : GLib.Object, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		public SwipeTracker (Hdy.Swipeable swipeable);
		[Version (since = "1.2")]
		public bool get_allow_long_swipes ();
		public bool get_allow_mouse_drag ();
		public bool get_enabled ();
		public bool get_reversed ();
		public unowned Hdy.Swipeable get_swipeable ();
		[Version (since = "1.2")]
		public void set_allow_long_swipes (bool allow_long_swipes);
		public void set_allow_mouse_drag (bool allow_mouse_drag);
		public void set_enabled (bool enabled);
		public void set_reversed (bool reversed);
		public void shift_position (double delta);
		[Version (since = "1.2")]
		public bool allow_long_swipes { get; set; }
		public bool allow_mouse_drag { get; set; }
		public bool enabled { get; set; }
		public bool reversed { get; set; }
		public Hdy.Swipeable swipeable { get; construct; }
		public signal void begin_swipe (Hdy.NavigationDirection direction, bool direct);
		public signal void end_swipe (int64 duration, double to);
		public signal void update_swipe (double progress);
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_tab_bar_get_type ()")]
	[Version (since = "1.2")]
	public class TabBar : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public TabBar ();
		public bool get_autohide ();
		public unowned Gtk.Widget? get_end_action_widget ();
		public bool get_expand_tabs ();
		public unowned Gtk.TargetList? get_extra_drag_dest_targets ();
		public bool get_inverted ();
		public bool get_is_overflowing ();
		public unowned Gtk.Widget? get_start_action_widget ();
		public bool get_tabs_revealed ();
		public unowned Hdy.TabView? get_view ();
		public void set_autohide (bool autohide);
		public void set_end_action_widget (Gtk.Widget? widget);
		public void set_expand_tabs (bool expand_tabs);
		public void set_extra_drag_dest_targets (Gtk.TargetList? extra_drag_dest_targets);
		public void set_inverted (bool inverted);
		public void set_start_action_widget (Gtk.Widget? widget);
		public void set_view (Hdy.TabView? view);
		public bool autohide { get; set; }
		public Gtk.Widget end_action_widget { get; set; }
		public bool expand_tabs { get; set; }
		public Gtk.TargetList extra_drag_dest_targets { get; set; }
		public bool inverted { get; set; }
		public bool is_overflowing { get; }
		public Gtk.Widget start_action_widget { get; set; }
		public bool tabs_revealed { get; }
		public Hdy.TabView view { get; set; }
		public signal void extra_drag_data_received (Hdy.TabPage page, Gdk.DragContext context, Gtk.SelectionData data, uint info, uint time);
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_tab_page_get_type ()")]
	[Version (since = "1.2")]
	public class TabPage : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TabPage ();
		public unowned Gtk.Widget get_child ();
		public unowned GLib.Icon? get_icon ();
		public bool get_indicator_activatable ();
		public unowned GLib.Icon? get_indicator_icon ();
		public bool get_loading ();
		public bool get_needs_attention ();
		public unowned Hdy.TabPage? get_parent ();
		public bool get_pinned ();
		public bool get_selected ();
		public unowned string? get_title ();
		public unowned string? get_tooltip ();
		public void set_icon (GLib.Icon? icon);
		public void set_indicator_activatable (bool activatable);
		public void set_indicator_icon (GLib.Icon? indicator_icon);
		public void set_loading (bool loading);
		public void set_needs_attention (bool needs_attention);
		public void set_title (string? title);
		public void set_tooltip (string? tooltip);
		public Gtk.Widget child { get; construct; }
		public GLib.Icon icon { get; set; }
		public bool indicator_activatable { get; set; }
		public GLib.Icon indicator_icon { get; set; }
		public bool loading { get; set; }
		public bool needs_attention { get; set; }
		public Hdy.TabPage parent { get; construct; }
		public bool pinned { get; }
		public bool selected { get; }
		public string title { get; set; }
		public string tooltip { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_tab_view_get_type ()")]
	[Version (since = "1.2")]
	public class TabView : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public TabView ();
		public unowned Hdy.TabPage add_page (Gtk.Widget child, Hdy.TabPage? parent);
		public unowned Hdy.TabPage append (Gtk.Widget child);
		public unowned Hdy.TabPage append_pinned (Gtk.Widget child);
		public void close_other_pages (Hdy.TabPage page);
		public void close_page_finish (Hdy.TabPage page, bool confirm);
		public void close_pages_after (Hdy.TabPage page);
		public void close_pages_before (Hdy.TabPage page);
		public unowned GLib.Icon get_default_icon ();
		public bool get_is_transferring_page ();
		public unowned GLib.MenuModel? get_menu_model ();
		public int get_n_pages ();
		public int get_n_pinned_pages ();
		public unowned Hdy.TabPage get_nth_page (int position);
		public unowned Hdy.TabPage get_page (Gtk.Widget child);
		public int get_page_position (Hdy.TabPage page);
		public unowned GLib.ListModel get_pages ();
		public unowned Hdy.TabPage? get_selected_page ();
		public unowned Gtk.Widget? get_shortcut_widget ();
		public unowned Hdy.TabPage insert (Gtk.Widget child, int position);
		public unowned Hdy.TabPage insert_pinned (Gtk.Widget child, int position);
		public unowned Hdy.TabPage prepend (Gtk.Widget child);
		public unowned Hdy.TabPage prepend_pinned (Gtk.Widget child);
		public bool reorder_backward (Hdy.TabPage page);
		public bool reorder_first (Hdy.TabPage page);
		public bool reorder_forward (Hdy.TabPage page);
		public bool reorder_last (Hdy.TabPage page);
		public bool reorder_page (Hdy.TabPage page, int position);
		public bool select_next_page ();
		public bool select_previous_page ();
		public void set_default_icon (GLib.Icon default_icon);
		public void set_menu_model (GLib.MenuModel? menu_model);
		public void set_page_pinned (Hdy.TabPage page, bool pinned);
		public void set_selected_page (Hdy.TabPage selected_page);
		public void set_shortcut_widget (Gtk.Widget? widget);
		public void transfer_page (Hdy.TabPage page, Hdy.TabView other_view, int position);
		public GLib.Icon default_icon { get; set; }
		public bool is_transferring_page { get; }
		public GLib.MenuModel menu_model { get; set; }
		public int n_pages { get; }
		public int n_pinned_pages { get; }
		public Hdy.TabPage selected_page { get; set; }
		public Gtk.Widget shortcut_widget { get; set; }
		[HasEmitter]
		public signal bool close_page (Hdy.TabPage page);
		public signal unowned Hdy.TabView? create_window ();
		public signal void indicator_activated (Hdy.TabPage page);
		public signal void page_attached (Hdy.TabPage page, int position);
		public signal void page_detached (Hdy.TabPage page, int position);
		public signal void page_reordered (Hdy.TabPage page, int position);
		public signal void setup_menu (Hdy.TabPage page);
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_title_bar_get_type ()")]
	[Version (deprecated = true, deprecated_since = "1.4", since = "1.0")]
	public class TitleBar : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public TitleBar ();
		public bool get_selection_mode ();
		public void set_selection_mode (bool selection_mode);
		public bool selection_mode { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_value_object_get_type ()")]
	[Version (since = "1.0")]
	public class ValueObject : GLib.Object {
		[CCode (has_construct_function = false)]
		public ValueObject (GLib.Value value);
		public void copy_value (GLib.Value dest);
		public string dup_string ();
		public unowned string get_string ();
		public unowned GLib.Value? get_value ();
		public GLib.Value value { get; construct; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_view_switcher_get_type ()")]
	[Version (since = "1.0")]
	public class ViewSwitcher : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ViewSwitcher ();
		public Pango.EllipsizeMode get_narrow_ellipsize ();
		public Hdy.ViewSwitcherPolicy get_policy ();
		public unowned Gtk.Stack? get_stack ();
		public void set_narrow_ellipsize (Pango.EllipsizeMode mode);
		public void set_policy (Hdy.ViewSwitcherPolicy policy);
		public void set_stack (Gtk.Stack? stack);
		public Pango.EllipsizeMode narrow_ellipsize { get; set; }
		public Hdy.ViewSwitcherPolicy policy { get; set; }
		public Gtk.Stack stack { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_view_switcher_bar_get_type ()")]
	[Version (since = "1.0")]
	public class ViewSwitcherBar : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public ViewSwitcherBar ();
		public Hdy.ViewSwitcherPolicy get_policy ();
		public bool get_reveal ();
		public unowned Gtk.Stack? get_stack ();
		public void set_policy (Hdy.ViewSwitcherPolicy policy);
		public void set_reveal (bool reveal);
		public void set_stack (Gtk.Stack? stack);
		public Hdy.ViewSwitcherPolicy policy { get; set; }
		public bool reveal { get; set; }
		public Gtk.Stack stack { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_view_switcher_title_get_type ()")]
	[Version (since = "1.0")]
	public class ViewSwitcherTitle : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public ViewSwitcherTitle ();
		public Hdy.ViewSwitcherPolicy get_policy ();
		public unowned Gtk.Stack? get_stack ();
		public unowned string? get_subtitle ();
		public unowned string? get_title ();
		public bool get_title_visible ();
		public bool get_view_switcher_enabled ();
		public void set_policy (Hdy.ViewSwitcherPolicy policy);
		public void set_stack (Gtk.Stack? stack);
		public void set_subtitle (string? subtitle);
		public void set_title (string? title);
		public void set_view_switcher_enabled (bool enabled);
		public Hdy.ViewSwitcherPolicy policy { get; set; }
		public Gtk.Stack stack { get; set; }
		public string subtitle { get; set; }
		public string title { get; set; }
		public bool title_visible { get; }
		public bool view_switcher_enabled { get; set; }
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_window_get_type ()")]
	[Version (since = "1.0")]
	public class Window : Gtk.Window, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Window ();
	}
	[CCode (cheader_filename = "handy.h", type_id = "hdy_window_handle_get_type ()")]
	[Version (since = "1.0")]
	public class WindowHandle : Gtk.EventBox, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public WindowHandle ();
	}
	[CCode (cheader_filename = "handy.h", type_cname = "HdySwipeableInterface", type_id = "hdy_swipeable_get_type ()")]
	[Version (since = "1.0")]
	public interface Swipeable : Gtk.Widget {
		public void emit_child_switched (uint index, int64 duration);
		public abstract double get_cancel_progress ();
		public abstract double get_distance ();
		public abstract double get_progress ();
		[CCode (array_length_pos = 0.1)]
		public abstract double[] get_snap_points ();
		public abstract Gdk.Rectangle get_swipe_area (Hdy.NavigationDirection navigation_direction, bool is_drag);
		public abstract unowned Hdy.SwipeTracker get_swipe_tracker ();
		public abstract void switch_child (uint index, int64 duration);
		public signal void child_switched (uint index, int64 duration);
	}
	[CCode (cheader_filename = "handy.h", cprefix = "HDY_CENTERING_POLICY_", type_id = "hdy_centering_policy_get_type ()")]
	[Version (since = "1.0")]
	public enum CenteringPolicy {
		LOOSE,
		STRICT
	}
	[CCode (cheader_filename = "handy.h", cprefix = "HDY_COLOR_SCHEME_", type_id = "hdy_color_scheme_get_type ()")]
	[Version (since = "1.6")]
	public enum ColorScheme {
		DEFAULT,
		FORCE_LIGHT,
		PREFER_LIGHT,
		PREFER_DARK,
		FORCE_DARK
	}
	[CCode (cheader_filename = "handy.h", cprefix = "HDY_DECK_TRANSITION_TYPE_", type_id = "hdy_deck_transition_type_get_type ()")]
	[Version (since = "1.0")]
	public enum DeckTransitionType {
		OVER,
		UNDER,
		SLIDE
	}
	[CCode (cheader_filename = "handy.h", cprefix = "HDY_FLAP_FOLD_POLICY_", type_id = "hdy_flap_fold_policy_get_type ()")]
	[Version (since = "1.2")]
	public enum FlapFoldPolicy {
		NEVER,
		ALWAYS,
		AUTO
	}
	[CCode (cheader_filename = "handy.h", cprefix = "HDY_FLAP_TRANSITION_TYPE_", type_id = "hdy_flap_transition_type_get_type ()")]
	[Version (since = "1.2")]
	public enum FlapTransitionType {
		OVER,
		UNDER,
		SLIDE
	}
	[CCode (cheader_filename = "handy.h", cprefix = "HDY_HEADER_GROUP_CHILD_TYPE_", type_id = "hdy_header_group_child_type_get_type ()")]
	[Version (since = "1.0")]
	public enum HeaderGroupChildType {
		HEADER_BAR,
		GTK_HEADER_BAR,
		HEADER_GROUP
	}
	[CCode (cheader_filename = "handy.h", cprefix = "HDY_LEAFLET_TRANSITION_TYPE_", type_id = "hdy_leaflet_transition_type_get_type ()")]
	[Version (since = "1.0")]
	public enum LeafletTransitionType {
		OVER,
		UNDER,
		SLIDE
	}
	[CCode (cheader_filename = "handy.h", cprefix = "HDY_NAVIGATION_DIRECTION_", type_id = "hdy_navigation_direction_get_type ()")]
	[Version (since = "1.0")]
	public enum NavigationDirection {
		BACK,
		FORWARD
	}
	[CCode (cheader_filename = "handy.h", cprefix = "HDY_SQUEEZER_TRANSITION_TYPE_", type_id = "hdy_squeezer_transition_type_get_type ()")]
	[Version (since = "1.0")]
	public enum SqueezerTransitionType {
		NONE,
		CROSSFADE
	}
	[CCode (cheader_filename = "handy.h", cprefix = "HDY_VIEW_SWITCHER_POLICY_", type_id = "hdy_view_switcher_policy_get_type ()")]
	[Version (since = "1.0")]
	public enum ViewSwitcherPolicy {
		AUTO,
		NARROW,
		WIDE
	}
	[CCode (cheader_filename = "handy.h", instance_pos = 1.9)]
	[Version (deprecated = true, deprecated_since = "1.2", since = "1.0")]
	public delegate Gdk.Pixbuf? AvatarImageLoadFunc (int size);
	[CCode (cheader_filename = "handy.h", instance_pos = 1.9)]
	[Version (since = "1.0")]
	public delegate string ComboRowGetEnumValueNameFunc (Hdy.EnumValueObject value);
	[CCode (cheader_filename = "handy.h", instance_pos = 1.9)]
	[Version (since = "1.0")]
	public delegate string ComboRowGetNameFunc (GLib.Object item);
	[CCode (cheader_filename = "handy.h")]
	[Version (since = "1.0")]
	public static double ease_out_cubic (double t);
	[CCode (cheader_filename = "handy.h")]
	[Version (since = "1.0")]
	public static string enum_value_row_name (Hdy.EnumValueObject value, void* user_data);
	[CCode (cheader_filename = "handy.h")]
	[Version (since = "1.0")]
	public static bool get_enable_animations (Gtk.Widget widget);
	[CCode (cheader_filename = "handy.h")]
	[Version (since = "1.0")]
	public static void init ();
}
