/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "Flecs", "index.html", [
    [ "Documentation", "md_docs_2Docs.html", [
      [ "What is an Entity Component System?", "index.html#what-is-an-entity-component-system", null ],
      [ "Show me the code!", "index.html#show-me-the-code", null ],
      [ "Projects using Flecs", "index.html#projects-using-flecs", [
        [ "Tempest Rising", "index.html#tempest-rising", null ],
        [ "Territory Control 2", "index.html#territory-control-2", null ],
        [ "Resistance is Brutal", "index.html#resistance-is-brutal", null ],
        [ "Age of Respair", "index.html#age-of-respair", null ],
        [ "FEAST", "index.html#feast", null ],
        [ "The Forge", "index.html#the-forge", null ],
        [ "Extermination Shock", "index.html#extermination-shock", null ],
        [ "ECS survivors", "index.html#ecs-survivors", null ],
        [ "Ascendant", "index.html#ascendant", null ],
        [ "Tome Tumble Tournament", "index.html#tome-tumble-tournament", null ],
        [ "Hyperion Minecraft Server", "index.html#hyperion-minecraft-server", null ],
        [ "Sol Survivor", "index.html#sol-survivor", null ],
        [ "Equilibrium Engine", "index.html#equilibrium-engine", null ],
        [ "After Sun", "index.html#after-sun", null ],
        [ "Flecs Demo's", "index.html#flecs-demos", null ]
      ] ],
      [ "Flecs Hub", "index.html#flecs-hub", null ],
      [ "Language bindings", "index.html#language-bindings", null ],
      [ "Getting Started", "md_docs_2Docs.html#getting-started", null ],
      [ "Manuals", "md_docs_2Docs.html#manuals", null ],
      [ "API reference", "md_docs_2Docs.html#api-reference", null ],
      [ "Examples", "md_docs_2Docs.html#examples", null ],
      [ "Videos", "md_docs_2Docs.html#videos", null ],
      [ "Open Source Projects", "md_docs_2Docs.html#open-source-projects", null ],
      [ "Articles", "md_docs_2Docs.html#articles", null ],
      [ "Resources", "md_docs_2Docs.html#resources", [
        [ "Resources provided by the community", "md_docs_2Docs.html#resources-provided-by-the-community", null ],
        [ "Flecs around the web", "md_docs_2Docs.html#flecs-around-the-web", null ]
      ] ]
    ] ],
    [ "FAQ", "md_docs_2FAQ.html", [
      [ "What is an ECS?", "md_docs_2FAQ.html#what-is-an-ecs", null ],
      [ "Why is Flecs written in C?", "md_docs_2FAQ.html#why-is-flecs-written-in-c", null ],
      [ "Can I use Flecs with C++14 or higher?", "md_docs_2FAQ.html#can-i-use-flecs-with-c14-or-higher", null ],
      [ "Can I use std::vector or other types inside components?", "md_docs_2FAQ.html#can-i-use-stdvector-or-other-types-inside-components", null ],
      [ "What is an archetype?", "md_docs_2FAQ.html#what-is-an-archetype", null ],
      [ "How does Flecs compare with EnTT?", "md_docs_2FAQ.html#how-does-flecs-compare-with-entt", null ],
      [ "Is Flecs used for commercial projects?", "md_docs_2FAQ.html#is-flecs-used-for-commercial-projects", null ],
      [ "Why are queries slow?", "md_docs_2FAQ.html#why-are-queries-slow", null ],
      [ "Why are queries taking up a lot of RAM?", "md_docs_2FAQ.html#why-are-queries-taking-up-a-lot-of-ram", null ],
      [ "Why is my system called multiple times per frame?", "md_docs_2FAQ.html#why-is-my-system-called-multiple-times-per-frame", null ],
      [ "Can Flecs be compiled to web assembly?", "md_docs_2FAQ.html#can-flecs-be-compiled-to-web-assembly", null ],
      [ "Why am I getting an “use of undeclared identifier 'FLECS_ID …’” compiler error?", "md_docs_2FAQ.html#why-am-i-getting-an-use-of-undeclared-identifier-flecs_id--compiler-error", null ],
      [ "Why are my entity ids so large?", "md_docs_2FAQ.html#why-are-my-entity-ids-so-large", null ],
      [ "What is the difference between add &amp; set? Why do both exist?", "md_docs_2FAQ.html#what-is-the-difference-between-add--set-why-do-both-exist", null ],
      [ "Can Flecs serialize components?", "md_docs_2FAQ.html#can-flecs-serialize-components", null ],
      [ "Why is Flecs so large?", "md_docs_2FAQ.html#why-is-flecs-so-large", null ],
      [ "Why does the explorer not work?", "md_docs_2FAQ.html#why-does-the-explorer-not-work", null ],
      [ "Does the explorer collect data from my application?", "md_docs_2FAQ.html#does-the-explorer-collect-data-from-my-application", null ],
      [ "Why can't I see component values in the explorer?", "md_docs_2FAQ.html#why-cant-i-see-component-values-in-the-explorer", null ],
      [ "How do I detect which entities have changed?", "md_docs_2FAQ.html#how-do-i-detect-which-entities-have-changed", null ],
      [ "Are relationships just a component with an entity handle?", "md_docs_2FAQ.html#are-relationships-just-a-component-with-an-entity-handle", null ],
      [ "Can I create systems outside of the main function?", "md_docs_2FAQ.html#can-i-create-systems-outside-of-the-main-function", null ],
      [ "Can I use my own scheduler implementation?", "md_docs_2FAQ.html#can-i-use-my-own-scheduler-implementation", null ],
      [ "Can I use Flecs without using systems?", "md_docs_2FAQ.html#can-i-use-flecs-without-using-systems", null ],
      [ "Why does the lookup function not find my entity?", "md_docs_2FAQ.html#why-does-the-lookup-function-not-find-my-entity", null ],
      [ "Can I add or remove components from within a system?", "md_docs_2FAQ.html#can-i-add-or-remove-components-from-within-a-system", null ],
      [ "What does a LOCKED_STORAGE error mean?", "md_docs_2FAQ.html#what-does-a-locked_storage-error-mean", null ]
    ] ],
    [ "Flecs Quickstart", "md_docs_2Quickstart.html", [
      [ "Building Flecs", "md_docs_2Quickstart.html#building-flecs", [
        [ "Dynamic linking", "md_docs_2Quickstart.html#dynamic-linking", null ],
        [ "Building with CMake", "md_docs_2Quickstart.html#building-with-cmake", null ],
        [ "Building with Bake", "md_docs_2Quickstart.html#building-with-bake", null ],
        [ "Running tests (bake)", "md_docs_2Quickstart.html#running-tests-bake", [
          [ "Running tests (cmake, experimental)", "md_docs_2Quickstart.html#running-tests-cmake-experimental", null ]
        ] ],
        [ "Emscripten", "md_docs_2Quickstart.html#emscripten", null ]
      ] ],
      [ "Android(cmake)", "md_docs_2Quickstart.html#androidcmake", [
        [ "Addons", "md_docs_2Quickstart.html#addons", null ]
      ] ],
      [ "Concepts", "md_docs_2Quickstart.html#concepts", [
        [ "World", "md_docs_2Quickstart.html#world", null ],
        [ "Entity", "md_docs_2Quickstart.html#entity", null ],
        [ "Id", "md_docs_2Quickstart.html#id", null ],
        [ "Component", "md_docs_2Quickstart.html#component", null ],
        [ "Tag", "md_docs_2Quickstart.html#tag", null ],
        [ "Pair", "md_docs_2Quickstart.html#pair", null ],
        [ "Hierarchies", "md_docs_2Quickstart.html#hierarchies", null ],
        [ "Type", "md_docs_2Quickstart.html#type", null ],
        [ "Singleton", "md_docs_2Quickstart.html#singleton", null ],
        [ "Query", "md_docs_2Quickstart.html#query", null ],
        [ "System", "md_docs_2Quickstart.html#system", null ],
        [ "Pipeline", "md_docs_2Quickstart.html#pipeline", null ],
        [ "Observer", "md_docs_2Quickstart.html#observer", null ],
        [ "Module", "md_docs_2Quickstart.html#module", null ]
      ] ]
    ] ],
    [ "Designing with Flecs", "md_docs_2DesignWithFlecs.html", [
      [ "Entities", "md_docs_2DesignWithFlecs.html#entities", [
        [ "Entity Initialization", "md_docs_2DesignWithFlecs.html#entity-initialization", null ],
        [ "Entity Lifecycle", "md_docs_2DesignWithFlecs.html#entity-lifecycle", null ],
        [ "Entity Names", "md_docs_2DesignWithFlecs.html#entity-names", null ]
      ] ],
      [ "Components", "md_docs_2DesignWithFlecs.html#components", [
        [ "Component Size", "md_docs_2DesignWithFlecs.html#component-size", null ],
        [ "Complex component data", "md_docs_2DesignWithFlecs.html#complex-component-data", null ]
      ] ],
      [ "Queries", "md_docs_2DesignWithFlecs.html#queries", [
        [ "Use the right query", "md_docs_2DesignWithFlecs.html#use-the-right-query", null ],
        [ "Use in/inout/out annotations", "md_docs_2DesignWithFlecs.html#use-ininoutout-annotations", null ],
        [ "Annotations", "md_docs_2DesignWithFlecs.html#annotations", null ]
      ] ],
      [ "Systems", "md_docs_2DesignWithFlecs.html#systems", [
        [ "System Scope", "md_docs_2DesignWithFlecs.html#system-scope", null ],
        [ "System Scheduling", "md_docs_2DesignWithFlecs.html#system-scheduling", null ]
      ] ],
      [ "Phases and Pipelines", "md_docs_2DesignWithFlecs.html#phases-and-pipelines", [
        [ "Selecting a Phase", "md_docs_2DesignWithFlecs.html#selecting-a-phase", null ],
        [ "OnLoad", "md_docs_2DesignWithFlecs.html#onload", null ],
        [ "PostLoad", "md_docs_2DesignWithFlecs.html#postload", null ],
        [ "PreUpdate", "md_docs_2DesignWithFlecs.html#preupdate", null ],
        [ "OnUpdate", "md_docs_2DesignWithFlecs.html#onupdate", null ],
        [ "OnValidate", "md_docs_2DesignWithFlecs.html#onvalidate", null ],
        [ "PostUpdate", "md_docs_2DesignWithFlecs.html#postupdate", null ],
        [ "PreStore", "md_docs_2DesignWithFlecs.html#prestore", null ],
        [ "OnStore", "md_docs_2DesignWithFlecs.html#onstore", null ],
        [ "Custom phases and pipelines", "md_docs_2DesignWithFlecs.html#custom-phases-and-pipelines", null ]
      ] ],
      [ "Modules", "md_docs_2DesignWithFlecs.html#modules", [
        [ "Defining Modules", "md_docs_2DesignWithFlecs.html#defining-modules", null ],
        [ "Module Dependencies and Ordering", "md_docs_2DesignWithFlecs.html#module-dependencies-and-ordering", null ],
        [ "Modules and Feature Swapping", "md_docs_2DesignWithFlecs.html#modules-and-feature-swapping", null ],
        [ "Module Overhead", "md_docs_2DesignWithFlecs.html#module-overhead", null ]
      ] ],
      [ "Relationships", "md_docs_2DesignWithFlecs.html#relationships", null ]
    ] ],
    [ "Entities and Components", "md_docs_2EntitiesComponents.html", [
      [ "Introduction", "md_docs_2EntitiesComponents.html#introduction", null ],
      [ "Entities", "md_docs_2EntitiesComponents.html#entities-1", [
        [ "Creation", "md_docs_2EntitiesComponents.html#creation", null ],
        [ "Deletion", "md_docs_2EntitiesComponents.html#deletion", null ],
        [ "Clearing", "md_docs_2EntitiesComponents.html#clearing", null ],
        [ "Liveliness Checking", "md_docs_2EntitiesComponents.html#liveliness-checking", null ],
        [ "Manual Ids", "md_docs_2EntitiesComponents.html#manual-ids", null ],
        [ "Manual Versioning", "md_docs_2EntitiesComponents.html#manual-versioning", null ],
        [ "Ranges", "md_docs_2EntitiesComponents.html#ranges", null ],
        [ "Names", "md_docs_2EntitiesComponents.html#names", null ],
        [ "Disabling", "md_docs_2EntitiesComponents.html#disabling", null ]
      ] ],
      [ "Components", "md_docs_2EntitiesComponents.html#components-1", [
        [ "Operations", "md_docs_2EntitiesComponents.html#operations", null ],
        [ "Components are Entities", "md_docs_2EntitiesComponents.html#components-are-entities", null ],
        [ "Registration", "md_docs_2EntitiesComponents.html#registration", [
          [ "Runtime Type Registration", "md_docs_2EntitiesComponents.html#runtime-type-registration", null ]
        ] ],
        [ "Unregistration", "md_docs_2EntitiesComponents.html#unregistration", null ],
        [ "Singletons", "md_docs_2EntitiesComponents.html#singletons", null ],
        [ "Disabling", "md_docs_2EntitiesComponents.html#disabling-1", null ]
      ] ]
    ] ],
    [ "Queries", "md_docs_2Queries.html", [
      [ "Introduction", "md_docs_2Queries.html#introduction-1", null ],
      [ "Definitions", "md_docs_2Queries.html#definitions", null ],
      [ "Examples", "md_docs_2Queries.html#examples-1", null ],
      [ "Performance and Caching", "md_docs_2Queries.html#performance-and-caching", [
        [ "Caching: what is it?", "md_docs_2Queries.html#caching-what-is-it", null ],
        [ "Tradeoffs", "md_docs_2Queries.html#tradeoffs", null ],
        [ "Cache kinds", "md_docs_2Queries.html#cache-kinds", [
          [ "Default", "md_docs_2Queries.html#default", null ],
          [ "Auto", "md_docs_2Queries.html#auto", null ],
          [ "All", "md_docs_2Queries.html#all", null ],
          [ "None", "md_docs_2Queries.html#none", null ]
        ] ],
        [ "Performance tips &amp; tricks", "md_docs_2Queries.html#performance-tips--tricks", [
          [ "Rematching", "md_docs_2Queries.html#rematching", null ],
          [ "Empty archetype optimization", "md_docs_2Queries.html#empty-archetype-optimization", null ]
        ] ]
      ] ],
      [ "Creating queries", "md_docs_2Queries.html#creating-queries", null ],
      [ "Iteration", "md_docs_2Queries.html#iteration", null ],
      [ "Reference", "md_docs_2Queries.html#reference", [
        [ "Components", "md_docs_2Queries.html#components-2", null ],
        [ "Wildcards", "md_docs_2Queries.html#wildcards", null ],
        [ "Pairs", "md_docs_2Queries.html#pairs", null ],
        [ "Access modifiers", "md_docs_2Queries.html#access-modifiers", null ],
        [ "Operator Overview", "md_docs_2Queries.html#operator-overview", null ],
        [ "And Operator", "md_docs_2Queries.html#and-operator", null ],
        [ "Or Operator", "md_docs_2Queries.html#or-operator", null ],
        [ "Not Operator", "md_docs_2Queries.html#not-operator", null ],
        [ "Optional Operator", "md_docs_2Queries.html#optional-operator", null ],
        [ "Equality operators", "md_docs_2Queries.html#equality-operators", null ],
        [ "AndFrom, OrFrom, NotFrom Operators", "md_docs_2Queries.html#andfrom-orfrom-notfrom-operators", null ],
        [ "Query scopes", "md_docs_2Queries.html#query-scopes", null ],
        [ "Source", "md_docs_2Queries.html#source", null ],
        [ "Singletons", "md_docs_2Queries.html#singletons-1", null ],
        [ "Relationship Traversal", "md_docs_2Queries.html#relationship-traversal", [
          [ "Traversal Flags", "md_docs_2Queries.html#traversal-flags", null ],
          [ "Limitations", "md_docs_2Queries.html#limitations", null ]
        ] ],
        [ "Variables", "md_docs_2Queries.html#variables", [
          [ "Lookup variables", "md_docs_2Queries.html#lookup-variables", null ],
          [ "Setting Variables", "md_docs_2Queries.html#setting-variables", null ]
        ] ],
        [ "Member Value Queries", "md_docs_2Queries.html#member-value-queries", null ],
        [ "Change Detection", "md_docs_2Queries.html#change-detection", null ],
        [ "Sorting", "md_docs_2Queries.html#sorting", [
          [ "Sorting Algorithm", "md_docs_2Queries.html#sorting-algorithm", null ]
        ] ],
        [ "Grouping", "md_docs_2Queries.html#grouping", [
          [ "Group Iterators", "md_docs_2Queries.html#group-iterators", null ]
        ] ],
        [ "Component Inheritance", "md_docs_2Queries.html#component-inheritance", null ],
        [ "Transitive Relationships", "md_docs_2Queries.html#transitive-relationships", null ],
        [ "Reflexive Relationships", "md_docs_2Queries.html#reflexive-relationships", null ]
      ] ]
    ] ],
    [ "Flecs Query Language", "md_docs_2FlecsQueryLanguage.html", [
      [ "Introduction", "md_docs_2FlecsQueryLanguage.html#introduction-2", null ],
      [ "Example", "md_docs_2FlecsQueryLanguage.html#example", null ],
      [ "The Basics", "md_docs_2FlecsQueryLanguage.html#the-basics", [
        [ "Components", "md_docs_2FlecsQueryLanguage.html#components-3", null ],
        [ "Pairs", "md_docs_2FlecsQueryLanguage.html#pairs-1", null ]
      ] ],
      [ "Operators", "md_docs_2FlecsQueryLanguage.html#operators", [
        [ "Not", "md_docs_2FlecsQueryLanguage.html#not", null ],
        [ "Or", "md_docs_2FlecsQueryLanguage.html#or", null ],
        [ "Optional", "md_docs_2FlecsQueryLanguage.html#optional", null ],
        [ "AndFrom", "md_docs_2FlecsQueryLanguage.html#andfrom", null ],
        [ "NotFrom", "md_docs_2FlecsQueryLanguage.html#notfrom", null ],
        [ "OrFrom", "md_docs_2FlecsQueryLanguage.html#orfrom", null ]
      ] ],
      [ "Access Modifiers", "md_docs_2FlecsQueryLanguage.html#access-modifiers-1", null ],
      [ "Wildcards", "md_docs_2FlecsQueryLanguage.html#wildcards-1", [
        [ "Wildcard wildcard (*)", "md_docs_2FlecsQueryLanguage.html#wildcard-wildcard-", null ],
        [ "Any wildcard (_)", "md_docs_2FlecsQueryLanguage.html#any-wildcard-_", null ]
      ] ],
      [ "Variables", "md_docs_2FlecsQueryLanguage.html#variables-1", null ],
      [ "Source", "md_docs_2FlecsQueryLanguage.html#source-1", [
        [ "Static source", "md_docs_2FlecsQueryLanguage.html#static-source", null ],
        [ "Singleton source", "md_docs_2FlecsQueryLanguage.html#singleton-source", null ],
        [ "Variable source", "md_docs_2FlecsQueryLanguage.html#variable-source", null ]
      ] ],
      [ "Traversal", "md_docs_2FlecsQueryLanguage.html#traversal", null ],
      [ "Advanced", "md_docs_2FlecsQueryLanguage.html#advanced", [
        [ "Equality operators", "md_docs_2FlecsQueryLanguage.html#equality-operators-1", null ],
        [ "Lookup variables", "md_docs_2FlecsQueryLanguage.html#lookup-variables-1", null ],
        [ "Member matching", "md_docs_2FlecsQueryLanguage.html#member-matching", null ],
        [ "Dependent variables", "md_docs_2FlecsQueryLanguage.html#dependent-variables", null ],
        [ "Query scopes", "md_docs_2FlecsQueryLanguage.html#query-scopes-1", null ]
      ] ]
    ] ],
    [ "Systems", "md_docs_2Systems.html", [
      [ "System Iteration", "md_docs_2Systems.html#system-iteration", null ],
      [ "Using delta_time", "md_docs_2Systems.html#using-delta_time", null ],
      [ "Tasks", "md_docs_2Systems.html#tasks", null ],
      [ "Pipelines", "md_docs_2Systems.html#pipelines", [
        [ "Builtin Pipeline", "md_docs_2Systems.html#builtin-pipeline", [
          [ "Builtin Pipeline Query", "md_docs_2Systems.html#builtin-pipeline-query", null ]
        ] ],
        [ "Custom pipeline", "md_docs_2Systems.html#custom-pipeline", [
          [ "Pipeline switching performance", "md_docs_2Systems.html#pipeline-switching-performance", null ]
        ] ],
        [ "Disabling systems", "md_docs_2Systems.html#disabling-systems", null ]
      ] ],
      [ "Staging", "md_docs_2Systems.html#staging", [
        [ "Sync points", "md_docs_2Systems.html#sync-points", null ],
        [ "Immediate systems", "md_docs_2Systems.html#immediate-systems", null ],
        [ "Threading", "md_docs_2Systems.html#threading", null ],
        [ "Threading with Async Tasks", "md_docs_2Systems.html#threading-with-async-tasks", null ]
      ] ],
      [ "Timers", "md_docs_2Systems.html#timers", [
        [ "Interval", "md_docs_2Systems.html#interval", null ],
        [ "Rate", "md_docs_2Systems.html#rate", null ],
        [ "Tick source", "md_docs_2Systems.html#tick-source", null ],
        [ "Nested tick sources", "md_docs_2Systems.html#nested-tick-sources", null ]
      ] ]
    ] ],
    [ "Observers", "md_docs_2ObserversManual.html", [
      [ "Introduction", "md_docs_2ObserversManual.html#introduction-3", null ],
      [ "Example", "md_docs_2ObserversManual.html#example-1", null ],
      [ "The Basics", "md_docs_2ObserversManual.html#the-basics-1", [
        [ "Usage", "md_docs_2ObserversManual.html#usage", [
          [ "Limitations", "md_docs_2ObserversManual.html#limitations-1", null ],
          [ "Good Use Cases for Observers", "md_docs_2ObserversManual.html#good-use-cases-for-observers", null ],
          [ "Bad Use Cases for Observers", "md_docs_2ObserversManual.html#bad-use-cases-for-observers", null ],
          [ "Observers vs. Hooks", "md_docs_2ObserversManual.html#observers-vs-hooks", null ]
        ] ],
        [ "OnAdd Events", "md_docs_2ObserversManual.html#onadd-events", null ],
        [ "OnSet Events", "md_docs_2ObserversManual.html#onset-events", [
          [ "OnSet and Inheritance", "md_docs_2ObserversManual.html#onset-and-inheritance", null ],
          [ "Adding an IsA pair", "md_docs_2ObserversManual.html#adding-an-isa-pair", null ],
          [ "Removing an Override", "md_docs_2ObserversManual.html#removing-an-override", null ],
          [ "Setting an Inherited Component", "md_docs_2ObserversManual.html#setting-an-inherited-component", null ]
        ] ],
        [ "OnRemove Events", "md_docs_2ObserversManual.html#onremove-events", null ]
      ] ],
      [ "Multi-event Observers", "md_docs_2ObserversManual.html#multi-event-observers", null ],
      [ "Multi-term Observers", "md_docs_2ObserversManual.html#multi-term-observers", [
        [ "Filter Terms", "md_docs_2ObserversManual.html#filter-terms", null ],
        [ "Query variables", "md_docs_2ObserversManual.html#query-variables", null ],
        [ "Event Downgrading", "md_docs_2ObserversManual.html#event-downgrading", null ],
        [ "Event Inversion", "md_docs_2ObserversManual.html#event-inversion", null ]
      ] ],
      [ "Monitors", "md_docs_2ObserversManual.html#monitors", null ],
      [ "Yield Existing", "md_docs_2ObserversManual.html#yield-existing", [
        [ "Yield_existing flags", "md_docs_2ObserversManual.html#yield_existing-flags", null ]
      ] ],
      [ "Fixed Source Terms", "md_docs_2ObserversManual.html#fixed-source-terms", [
        [ "Singletons", "md_docs_2ObserversManual.html#singletons-2", null ]
      ] ],
      [ "Event Propagation", "md_docs_2ObserversManual.html#event-propagation", null ],
      [ "Event Forwarding", "md_docs_2ObserversManual.html#event-forwarding", null ],
      [ "Custom Events", "md_docs_2ObserversManual.html#custom-events", [
        [ "Entity Observers", "md_docs_2ObserversManual.html#entity-observers", null ],
        [ "Enqueue vs. Emit", "md_docs_2ObserversManual.html#enqueue-vs-emit", null ]
      ] ],
      [ "Observer Execution", "md_docs_2ObserversManual.html#observer-execution", [
        [ "Observer disabling", "md_docs_2ObserversManual.html#observer-disabling", null ],
        [ "Observer Ordering", "md_docs_2ObserversManual.html#observer-ordering", [
          [ "Observer order is undefined", "md_docs_2ObserversManual.html#observer-order-is-undefined", null ],
          [ "Event order is undefined between entities", "md_docs_2ObserversManual.html#event-order-is-undefined-between-entities", null ],
          [ "OnAdd &amp; OnRemove order is undefined", "md_docs_2ObserversManual.html#onadd--onremove-order-is-undefined", null ],
          [ "OnSet order is maintained", "md_docs_2ObserversManual.html#onset-order-is-maintained", null ],
          [ "Custom event order is maintained", "md_docs_2ObserversManual.html#custom-event-order-is-maintained", null ],
          [ "Hooks and Events", "md_docs_2ObserversManual.html#hooks-and-events", null ],
          [ "Children are cleaned up before parents", "md_docs_2ObserversManual.html#children-are-cleaned-up-before-parents", null ]
        ] ]
      ] ]
    ] ],
    [ "Prefabs", "md_docs_2PrefabsManual.html", [
      [ "Introduction", "md_docs_2PrefabsManual.html#introduction-4", null ],
      [ "The Prefab tag", "md_docs_2PrefabsManual.html#the-prefab-tag", null ],
      [ "Component Inheritance", "md_docs_2PrefabsManual.html#component-inheritance-1", null ],
      [ "Component Overriding", "md_docs_2PrefabsManual.html#component-overriding", null ],
      [ "Auto Overriding", "md_docs_2PrefabsManual.html#auto-overriding", null ],
      [ "Prefab Variants", "md_docs_2PrefabsManual.html#prefab-variants", null ],
      [ "Prefab Hierarchies", "md_docs_2PrefabsManual.html#prefab-hierarchies", null ],
      [ "Prefab Slots", "md_docs_2PrefabsManual.html#prefab-slots", null ],
      [ "Prefab Types (C++, C#)", "md_docs_2PrefabsManual.html#prefab-types-c-c", null ]
    ] ],
    [ "Component Traits", "md_docs_2ComponentTraits.html", [
      [ "Cleanup traits", "md_docs_2ComponentTraits.html#cleanup-traits", [
        [ "Examples", "md_docs_2ComponentTraits.html#examples-2", [
          [ "(OnDelete, Remove)", "md_docs_2ComponentTraits.html#ondelete-remove", null ],
          [ "(OnDelete, Delete)", "md_docs_2ComponentTraits.html#ondelete-delete", null ],
          [ "(OnDeleteTarget, Delete)", "md_docs_2ComponentTraits.html#ondeletetarget-delete", null ]
        ] ],
        [ "Cleanup order", "md_docs_2ComponentTraits.html#cleanup-order", [
          [ "Cleanup order during world teardown", "md_docs_2ComponentTraits.html#cleanup-order-during-world-teardown", null ],
          [ "World teardown sequence", "md_docs_2ComponentTraits.html#world-teardown-sequence", null ]
        ] ]
      ] ],
      [ "Trait trait", "md_docs_2ComponentTraits.html#trait-trait", null ],
      [ "Relationship trait", "md_docs_2ComponentTraits.html#relationship-trait", null ],
      [ "Target trait", "md_docs_2ComponentTraits.html#target-trait", null ],
      [ "PairIsTag trait", "md_docs_2ComponentTraits.html#pairistag-trait", null ],
      [ "Final trait", "md_docs_2ComponentTraits.html#final-trait", null ],
      [ "Inheritable trait", "md_docs_2ComponentTraits.html#inheritable-trait", null ],
      [ "OrderedChildren trait", "md_docs_2ComponentTraits.html#orderedchildren-trait", null ],
      [ "OnInstantiate trait", "md_docs_2ComponentTraits.html#oninstantiate-trait", [
        [ "Override", "md_docs_2ComponentTraits.html#override", null ],
        [ "Inherit", "md_docs_2ComponentTraits.html#inherit", null ],
        [ "DontInherit", "md_docs_2ComponentTraits.html#dontinherit", null ]
      ] ],
      [ "Transitive trait", "md_docs_2ComponentTraits.html#transitive-trait", null ],
      [ "Reflexive trait", "md_docs_2ComponentTraits.html#reflexive-trait", null ],
      [ "Acyclic trait", "md_docs_2ComponentTraits.html#acyclic-trait", null ],
      [ "Traversable trait", "md_docs_2ComponentTraits.html#traversable-trait", null ],
      [ "Exclusive trait", "md_docs_2ComponentTraits.html#exclusive-trait", null ],
      [ "CanToggle trait", "md_docs_2ComponentTraits.html#cantoggle-trait", null ],
      [ "Sparse trait", "md_docs_2ComponentTraits.html#sparse-trait", null ],
      [ "DontFragment trait", "md_docs_2ComponentTraits.html#dontfragment-trait", null ],
      [ "Symmetric trait", "md_docs_2ComponentTraits.html#symmetric-trait", null ],
      [ "With trait", "md_docs_2ComponentTraits.html#with-trait", null ],
      [ "OneOf trait", "md_docs_2ComponentTraits.html#oneof-trait", null ]
    ] ],
    [ "Relationships", "md_docs_2Relationships.html", [
      [ "Definitions", "md_docs_2Relationships.html#definitions-1", null ],
      [ "Examples", "md_docs_2Relationships.html#examples-3", null ],
      [ "Introduction", "md_docs_2Relationships.html#introduction-5", null ],
      [ "Relationship queries", "md_docs_2Relationships.html#relationship-queries", [
        [ "Test if entity has a relationship pair", "md_docs_2Relationships.html#test-if-entity-has-a-relationship-pair", null ],
        [ "Test if entity has a relationship wildcard", "md_docs_2Relationships.html#test-if-entity-has-a-relationship-wildcard", null ],
        [ "Get parent for entity", "md_docs_2Relationships.html#get-parent-for-entity", null ],
        [ "Find first target of a relationship for entity", "md_docs_2Relationships.html#find-first-target-of-a-relationship-for-entity", null ],
        [ "Find all targets of a relationship for entity", "md_docs_2Relationships.html#find-all-targets-of-a-relationship-for-entity", null ],
        [ "Find target of a relationship with component", "md_docs_2Relationships.html#find-target-of-a-relationship-with-component", null ],
        [ "Iterate all pairs for entity", "md_docs_2Relationships.html#iterate-all-pairs-for-entity", null ],
        [ "Find all entities with a pair", "md_docs_2Relationships.html#find-all-entities-with-a-pair", null ],
        [ "Find all entities with a pair wildcard", "md_docs_2Relationships.html#find-all-entities-with-a-pair-wildcard", null ],
        [ "Iterate all children for a parent", "md_docs_2Relationships.html#iterate-all-children-for-a-parent", null ]
      ] ],
      [ "Relationship components", "md_docs_2Relationships.html#relationship-components", [
        [ "Using relationships to add components multiple times", "md_docs_2Relationships.html#using-relationships-to-add-components-multiple-times", null ]
      ] ],
      [ "Relationship wildcards", "md_docs_2Relationships.html#relationship-wildcards", null ],
      [ "Inspecting relationships", "md_docs_2Relationships.html#inspecting-relationships", null ],
      [ "Builtin relationships", "md_docs_2Relationships.html#builtin-relationships", [
        [ "The IsA relationship", "md_docs_2Relationships.html#the-isa-relationship", [
          [ "Component sharing", "md_docs_2Relationships.html#component-sharing", null ]
        ] ],
        [ "The ChildOf relationship", "md_docs_2Relationships.html#the-childof-relationship", [
          [ "Namespacing", "md_docs_2Relationships.html#namespacing", null ],
          [ "Scoping", "md_docs_2Relationships.html#scoping", null ]
        ] ]
      ] ],
      [ "Relationship performance", "md_docs_2Relationships.html#relationship-performance", [
        [ "Introduction", "md_docs_2Relationships.html#introduction-6", null ],
        [ "Storing relationships", "md_docs_2Relationships.html#storing-relationships", null ],
        [ "Id ranges", "md_docs_2Relationships.html#id-ranges", null ],
        [ "Fragmentation", "md_docs_2Relationships.html#fragmentation", null ],
        [ "Table Creation", "md_docs_2Relationships.html#table-creation", null ],
        [ "Indexing", "md_docs_2Relationships.html#indexing", null ],
        [ "Wildcard Queries", "md_docs_2Relationships.html#wildcard-queries", null ]
      ] ]
    ] ],
    [ "Flecs Script", "md_docs_2FlecsScript.html", [
      [ "Introduction", "md_docs_2FlecsScript.html#introduction-7", null ],
      [ "Example", "md_docs_2FlecsScript.html#example-2", null ],
      [ "The Basics", "md_docs_2FlecsScript.html#the-basics-2", [
        [ "Entities", "md_docs_2FlecsScript.html#entities-2", null ],
        [ "Tags", "md_docs_2FlecsScript.html#tags", null ],
        [ "Pairs", "md_docs_2FlecsScript.html#pairs-2", null ],
        [ "Components", "md_docs_2FlecsScript.html#components-4", null ],
        [ "Namespacing", "md_docs_2FlecsScript.html#namespacing-1", null ],
        [ "Singletons", "md_docs_2FlecsScript.html#singletons-3", null ],
        [ "Entity kinds", "md_docs_2FlecsScript.html#entity-kinds", [
          [ "Builtin kinds", "md_docs_2FlecsScript.html#builtin-kinds", null ]
        ] ],
        [ "Inheritance", "md_docs_2FlecsScript.html#inheritance", null ],
        [ "Relationship hierarchies", "md_docs_2FlecsScript.html#relationship-hierarchies", null ]
      ] ],
      [ "Expressions", "md_docs_2FlecsScript.html#expressions", [
        [ "Operators", "md_docs_2FlecsScript.html#operators-1", null ],
        [ "Values", "md_docs_2FlecsScript.html#values", [
          [ "Initializers", "md_docs_2FlecsScript.html#initializers", null ]
        ] ],
        [ "Match expressions", "md_docs_2FlecsScript.html#match-expressions", null ],
        [ "String interpolation", "md_docs_2FlecsScript.html#string-interpolation", null ],
        [ "Types", "md_docs_2FlecsScript.html#types", [
          [ "Unary expressions", "md_docs_2FlecsScript.html#unary-expressions", null ],
          [ "Binary expressions", "md_docs_2FlecsScript.html#binary-expressions", null ],
          [ "Lvalues", "md_docs_2FlecsScript.html#lvalues", null ]
        ] ],
        [ "Functions", "md_docs_2FlecsScript.html#functions", null ],
        [ "Methods", "md_docs_2FlecsScript.html#methods", null ],
        [ "Builtin functions and constants", "md_docs_2FlecsScript.html#builtin-functions-and-constants", null ]
      ] ],
      [ "Templates", "md_docs_2FlecsScript.html#templates", null ],
      [ "Advanced Features", "md_docs_2FlecsScript.html#advanced-features", [
        [ "Module statement", "md_docs_2FlecsScript.html#module-statement", null ],
        [ "Using statement", "md_docs_2FlecsScript.html#using-statement", null ],
        [ "With statement", "md_docs_2FlecsScript.html#with-statement", null ],
        [ "Variables", "md_docs_2FlecsScript.html#variables-2", null ],
        [ "Component values", "md_docs_2FlecsScript.html#component-values", null ],
        [ "If statement", "md_docs_2FlecsScript.html#if-statement", null ],
        [ "For statement", "md_docs_2FlecsScript.html#for-statement", null ],
        [ "Default components", "md_docs_2FlecsScript.html#default-components", null ],
        [ "Semicolon operator", "md_docs_2FlecsScript.html#semicolon-operator", null ],
        [ "Comma operator", "md_docs_2FlecsScript.html#comma-operator", null ]
      ] ],
      [ "API", "md_docs_2FlecsScript.html#api", [
        [ "Run once", "md_docs_2FlecsScript.html#run-once", null ],
        [ "Run multiple times", "md_docs_2FlecsScript.html#run-multiple-times", null ],
        [ "Managed script", "md_docs_2FlecsScript.html#managed-script", null ]
      ] ]
    ] ],
    [ "FlecsScriptTutorial", "md_docs_2FlecsScriptTutorial.html", [
      [ "Flecs Script Tutorial", "md_docs_2FlecsScriptTutorial.html#flecs-script-tutorial", [
        [ "Getting Started with the Explorer", "md_docs_2FlecsScriptTutorial.html#getting-started-with-the-explorer", null ],
        [ "The Basics", "md_docs_2FlecsScriptTutorial.html#the-basics-3", null ],
        [ "Adding Components", "md_docs_2FlecsScriptTutorial.html#adding-components", null ],
        [ "Drawing Shapes", "md_docs_2FlecsScriptTutorial.html#drawing-shapes", null ],
        [ "Drawing a Fence", "md_docs_2FlecsScriptTutorial.html#drawing-a-fence", null ],
        [ "Prefabs", "md_docs_2FlecsScriptTutorial.html#prefabs-1", null ],
        [ "Templates", "md_docs_2FlecsScriptTutorial.html#templates-1", null ],
        [ "Grids", "md_docs_2FlecsScriptTutorial.html#grids", null ],
        [ "Nested Templates", "md_docs_2FlecsScriptTutorial.html#nested-templates", null ]
      ] ]
    ] ],
    [ "Flecs Remote API", "md_docs_2FlecsRemoteApi.html", [
      [ "Explorer Quickstart", "md_docs_2FlecsRemoteApi.html#explorer-quickstart", null ],
      [ "Usage", "md_docs_2FlecsRemoteApi.html#usage-1", [
        [ "JSON serialization", "md_docs_2FlecsRemoteApi.html#json-serialization", null ],
        [ "REST API", "md_docs_2FlecsRemoteApi.html#rest-api", null ]
      ] ],
      [ "JavaScript library", "md_docs_2FlecsRemoteApi.html#javascript-library", null ],
      [ "Reference", "md_docs_2FlecsRemoteApi.html#reference-1", [
        [ "GET entity", "md_docs_2FlecsRemoteApi.html#get-entity", [
          [ "Options", "md_docs_2FlecsRemoteApi.html#options", null ],
          [ "Examples", "md_docs_2FlecsRemoteApi.html#examples-4", null ]
        ] ],
        [ "PUT entity", "md_docs_2FlecsRemoteApi.html#put-entity", [
          [ "Examples", "md_docs_2FlecsRemoteApi.html#examples-5", null ]
        ] ],
        [ "DELETE entity", "md_docs_2FlecsRemoteApi.html#delete-entity", [
          [ "Examples", "md_docs_2FlecsRemoteApi.html#examples-6", null ]
        ] ],
        [ "GET component", "md_docs_2FlecsRemoteApi.html#get-component", [
          [ "Examples", "md_docs_2FlecsRemoteApi.html#examples-7", null ]
        ] ],
        [ "PUT component", "md_docs_2FlecsRemoteApi.html#put-component", [
          [ "Examples", "md_docs_2FlecsRemoteApi.html#examples-8", null ]
        ] ],
        [ "DELETE component", "md_docs_2FlecsRemoteApi.html#delete-component", [
          [ "Examples", "md_docs_2FlecsRemoteApi.html#examples-9", null ]
        ] ],
        [ "PUT toggle", "md_docs_2FlecsRemoteApi.html#put-toggle", [
          [ "Examples", "md_docs_2FlecsRemoteApi.html#examples-10", null ]
        ] ],
        [ "GET query", "md_docs_2FlecsRemoteApi.html#get-query", [
          [ "Options", "md_docs_2FlecsRemoteApi.html#options-1", null ],
          [ "Examples", "md_docs_2FlecsRemoteApi.html#examples-11", null ]
        ] ],
        [ "GET world", "md_docs_2FlecsRemoteApi.html#get-world", [
          [ "Example", "md_docs_2FlecsRemoteApi.html#example-3", null ]
        ] ],
        [ "PUT script", "md_docs_2FlecsRemoteApi.html#put-script", [
          [ "Example", "md_docs_2FlecsRemoteApi.html#example-4", null ]
        ] ]
      ] ]
    ] ],
    [ "Manual", "md_docs_2Manual.html", [
      [ "Introduction", "md_docs_2Manual.html#introduction-8", null ],
      [ "Design Goals", "md_docs_2Manual.html#design-goals", [
        [ "1. Performance", "md_docs_2Manual.html#autotoc_md1-performance", null ],
        [ "2. Portability", "md_docs_2Manual.html#autotoc_md2-portability", null ],
        [ "3. Reusability", "md_docs_2Manual.html#autotoc_md3-reusability", null ],
        [ "4. Usability", "md_docs_2Manual.html#autotoc_md4-usability", null ],
        [ "5. Extensibility", "md_docs_2Manual.html#autotoc_md5-extensibility", null ],
        [ "6. Have fun!", "md_docs_2Manual.html#autotoc_md6-have-fun", null ]
      ] ],
      [ "API design", "md_docs_2Manual.html#api-design", [
        [ "Naming conventions", "md_docs_2Manual.html#naming-conventions", null ],
        [ "Idempotence", "md_docs_2Manual.html#idempotence", null ],
        [ "Error handling", "md_docs_2Manual.html#error-handling", null ],
        [ "Memory ownership", "md_docs_2Manual.html#memory-ownership", null ],
        [ "Macros", "md_docs_2Manual.html#macros", null ]
      ] ],
      [ "Modules", "md_docs_2Manual.html#modules-1", [
        [ "Modules in C++", "md_docs_2Manual.html#modules-in-c", null ]
      ] ],
      [ "Deferred operations", "md_docs_2Manual.html#deferred-operations", null ]
    ] ],
    [ "Migration guide", "md_docs_2MigrationGuide.html", [
      [ "Queries", "md_docs_2MigrationGuide.html#queries-2", [
        [ "Caching", "md_docs_2MigrationGuide.html#caching", null ],
        [ "Iter function", "md_docs_2MigrationGuide.html#iter-function", null ],
        [ "Query DSL", "md_docs_2MigrationGuide.html#query-dsl", null ]
      ] ],
      [ "Systems &amp; Pipelines", "md_docs_2MigrationGuide.html#systems--pipelines", null ],
      [ "Observers", "md_docs_2MigrationGuide.html#observers-1", null ],
      [ "Term iterators", "md_docs_2MigrationGuide.html#term-iterators", null ],
      [ "Entity Names", "md_docs_2MigrationGuide.html#entity-names-1", null ],
      [ "ensure / get_mut", "md_docs_2MigrationGuide.html#ensure--get_mut", null ],
      [ "ecs_new", "md_docs_2MigrationGuide.html#ecs_new", null ],
      [ "Flecs Script", "md_docs_2MigrationGuide.html#flecs-script-1", null ],
      [ "Inheritance", "md_docs_2MigrationGuide.html#inheritance-1", null ],
      [ "Component disabling", "md_docs_2MigrationGuide.html#component-disabling", null ],
      [ "Union relationships", "md_docs_2MigrationGuide.html#union-relationships", null ],
      [ "Snapshots", "md_docs_2MigrationGuide.html#snapshots", null ],
      [ "Tree flattening", "md_docs_2MigrationGuide.html#tree-flattening", null ],
      [ "Addons", "md_docs_2MigrationGuide.html#addons-1", null ],
      [ "Misc", "md_docs_2MigrationGuide.html#misc", null ]
    ] ],
    [ "Topics", "topics.html", "topics" ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", "namespaces_dup" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", null ],
        [ "Functions", "namespacemembers_func.html", null ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", null ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", "globals_func" ],
        [ "Variables", "globals_vars.html", "globals_vars" ],
        [ "Typedefs", "globals_type.html", "globals_type" ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", null ],
        [ "Macros", "globals_defs.html", null ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"alerts_2builder__i_8hpp.html",
"group__builtin__tags.html#ga429fe205a699548fedb8394fdb284854",
"group__c__addons__meta.html#ga6dba5d1b917773290bace8041307cf3b",
"group__c__addons__timer.html#gadb9aec2c89c51a4da664e86868b8a023",
"group__core__types.html#gad89be37a3609d524994b418b413fa9ae",
"group__creating__entities.html#ga0bacd1d1d6725e6abd79f0a647224a14",
"group__paths.html#gae648e450d1cb2720f86447597fc4e292",
"md_docs_2DesignWithFlecs.html#complex-component-data",
"md_docs_2ObserversManual.html#event-propagation",
"query_2decl_8hpp_source.html",
"structecs__entity__desc__t.html#ac3216af1b28b37d478e2318390e37a4f",
"structecs__observer__desc__t.html",
"structecs__term__t.html#aacebdceb5defe8ea25ad6374cb1e8ab3",
"structflecs_1_1___1_1has__operator__greater.html",
"structflecs_1_1entity__builder.html#afc1787191dce47aa9a20af1c13840d17",
"structflecs_1_1iterable.html",
"structflecs_1_1units.html",
"structflecs_1_1world.html#a7c1aa50d01758770e7d0deeb9f1cfafa"
];

var SYNCONMSG = 'click to disable panel synchronization';
var SYNCOFFMSG = 'click to enable panel synchronization';
var LISTOFALLMEMBERS = 'List of all members';