#ifndef _CEGOOBJECT_H_INCLUDED_
#define _CEGOOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoObject.h
// ------------
// Database object super class class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoObject
// 
// Description: Database object super class structure
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

class CegoObject {
    
public:
    
    enum ObjectType { SYSTEM, 
		      TABLE,
		      PAVLTREE,
		      UAVLTREE,
		      AVLTREE,		      
		      VIEW,
		      RBSEG,
		      FKEY,
		      PROCEDURE,
		      CHECK,
		      JOIN,
		      PBTREE,
		      UBTREE,
		      BTREE,
		      TRIGGER,
		      ALIAS,
		      UNDEFINED};

    CegoObject();
    CegoObject(const CegoObject& oe);
    CegoObject(ObjectType type,  const Chain& objName, int tabSetId = 0);

    ~CegoObject();
    
    void setName(const Chain& name);
    const Chain& getName() const;

    void setType(ObjectType type);
    ObjectType getType() const;

    void setTabSetId(int tabSetId);
    int getTabSetId() const;

    int getBaseSize() const;
    void encodeBase(char *buf, int entrySize);
    void decodeBase(char *buf, int& entrySize);
            
    CegoObject& operator = ( const CegoObject& oe);
    bool operator == ( const CegoObject& oe);

    int size() const;
    Chain toChain() const;

private:
    
    ObjectType _type;
    Chain _name;
    int _tabSetId;
    
};

#endif
