with Ada.Containers;                  use Ada.Containers;
with Ada.Containers.Hashed_Maps;
with Ada.Containers.Vectors;
with Ada.Directories;
with Ada.Exceptions;
with Ada.Finalization;
with Ada.Strings.Wide_Wide_Unbounded; use Ada.Strings.Wide_Wide_Unbounded;
pragma Warnings (Off, "internal");
with Ada.Strings.Wide_Wide_Unbounded.Aux;
use Ada.Strings.Wide_Wide_Unbounded.Aux;
pragma Warnings (On, "internal");
with Ada.Text_IO;                     use Ada.Text_IO;
with Ada.Unchecked_Conversion;
with Ada.Unchecked_Deallocation;
with System;
with GNATCOLL.Traces;
with Langkit_Support.Hashes;  use Langkit_Support.Hashes;
with Langkit_Support.Images;  use Langkit_Support.Images;
with Langkit_Support.Relative_Get;
pragma Warnings (Off, "referenced");
with Langkit_Support.Adalog.Abstract_Relation;
use Langkit_Support.Adalog.Abstract_Relation;
with Langkit_Support.Adalog.Debug;
use Langkit_Support.Adalog.Debug;
with Langkit_Support.Adalog.Operations;
use Langkit_Support.Adalog.Operations;
with Langkit_Support.Adalog.Predicates;
use Langkit_Support.Adalog.Predicates;
with Langkit_Support.Adalog.Pure_Relations;
use Langkit_Support.Adalog.Pure_Relations;
pragma Warnings (On, "referenced");
with Libadalang.Private_Converters;
use Libadalang.Private_Converters;
with Libadalang.Introspection_Implementation;
          with Ada.Containers.Hashed_Sets;
          with Libadalang.Env_Hooks;
            use Libadalang.Env_Hooks;
          with Libadalang.Implementation.Extensions;
            use Libadalang.Implementation.Extensions;
          with Libadalang.Internal_Default_Provider;
          with Libadalang.Sources;
package body Libadalang.Implementation is
   use Libadalang.Common.Precomputed_Symbols;
   package Context_Vectors is new Ada.Containers.Vectors
     (Index_Type   => Positive,
      Element_Type => Internal_Context);
   type Contexts_Destructor is limited
      new Ada.Finalization.Limited_Controlled with null record;
   overriding procedure Finalize (CD : in out Contexts_Destructor);
   --  Helper to destroy all contexts when terminating the process
   protected Context_Pool is
      procedure Acquire (Context : out Internal_Context)
         with Post => Context /= null;
      --  If a context is free for reuse, increment its serial number and
      --  return it. Otherwise, allocate a new one. In any case, this does not
      --  initialize it, except for the Serial_Number and Released fields.
      procedure Release (Context : in out Internal_Context)
         with Pre  => Context /= null,
              Post => Context = null;
      --  Tag Context as free for reuse and set it to null
      procedure Free;
      --  Free all contexts in this pool. Intended to be called only when the
      --  process is terminating, to avoid reported memory leaks.
   private
      Available : Context_Vectors.Vector;
      --  List of allocated contexts that can be re-used right now
      CD : Contexts_Destructor with Unreferenced;
      --  Singleton whose only purpose is to free all contexts in Available
      --  when finalized.
   end Context_Pool;
   generic
      type T (<>) is limited private;
      type T_Access is access all T;
      with procedure Destroy (Object : in out T_Access);
   procedure Register_Destroyable_Gen
     (Unit : Internal_Unit; Object : T_Access);
   --  Generic procedure to register an object so that it is automatically
   --  destroyed when Unit is destroyed.
   procedure Register_Destroyable_Helper
     (Unit    : Internal_Unit;
      Object  : System.Address;
      Destroy : Destroy_Procedure);
   --  Common underlying implementation for Register_Destroyable_Gen
   function Construct_Entity_Array
     (V : AST_Envs.Entity_Vectors.Vector) return Internal_Entity_Array_Access;
   function Solve_Wrapper
     (R            : Relation;
      Context_Node : Bare_Ada_Node) return Boolean;
   --  Wrapper for Langkit_Support.Adalog.Solve; will handle setting the debug
   --  strings in the equation if in debug mode.
   procedure Destroy (Env : in out Lexical_Env_Access);
   function Snaps_At_Start (Self : Bare_Ada_Node) return Boolean;
   function Snaps_At_End (Self : Bare_Ada_Node) return Boolean;
   --  Those maps are used to give unique ids to lexical envs while pretty
   --  printing them.
   package Address_To_Id_Maps is new Ada.Containers.Hashed_Maps
     (Lexical_Env, Integer, Hash, "=");
   type Dump_Lexical_Env_State is record
      Env_Ids : Address_To_Id_Maps.Map;
      --  Mapping: Lexical_Env -> Integer, used to remember which unique Ids we
      --  assigned to the lexical environments we found.
      Next_Id : Positive := 1;
      --  Id to assign to the next unknown lexical environment
      Root_Env : Lexical_Env;
      --  Lexical environment we consider a root (this is the Root_Scope from
      --  the current analysis context), or null if unknown.
   end record;
   --  Holder for the state of lexical environment dumpers
   function Get_Env_Id
     (E : Lexical_Env; State : in out Dump_Lexical_Env_State) return String;
   --  If E is known, return its unique Id from State. Otherwise, assign it a
   --  new unique Id and return it.
   function Construct_Entity_Array
     (V : AST_Envs.Entity_Vectors.Vector) return Internal_Entity_Array_Access
   is
      Ret : Internal_Entity_Array_Access :=
        Create_Internal_Entity_Array (V.Length);
   begin
      for J in V.First_Index .. V.Last_Index loop
         Ret.Items (J) := V.Get (J);
      end loop;
      declare
         Tmp : AST_Envs.Entity_Vectors.Vector := V;
      begin
         Tmp.Destroy;
      end;
      return Ret;
   end Construct_Entity_Array;
   ----------------
   -- Enter_Call --
   ----------------
   procedure Enter_Call
     (Context : Internal_Context; Call_Depth : access Natural)
   is
      Max             : Natural renames Context.Max_Call_Depth;
      Current         : Natural renames Context.Current_Call_Depth;
      High_Water_Mark : Natural renames Context.Call_Depth_High_Water_Mark;
   begin
      Current := Current + 1;
      High_Water_Mark := Natural'Max (High_Water_Mark, Current);
      Call_Depth.all := Current;
      if Current > Max then
         raise Property_Error with "stack overflow";
      end if;
   end Enter_Call;
   ---------------
   -- Exit_Call --
   ---------------
   procedure Exit_Call (Context : Internal_Context; Call_Depth : Natural) is
      Current : Natural renames Context.Current_Call_Depth;
   begin
      if Call_Depth /= Current then
         raise Unexpected_Call_Depth with
            "Langkit code generation bug for call depth handling detected";
      end if;
      Current := Current - 1;
   end Exit_Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Symbol_Type) return Character_Type_Array_Access is
      T      : constant Text_Type := Image (Self);
      Result : constant Character_Type_Array_Access :=
         Create_Character_Type_Array (T'Length);
   begin
      Result.Items := T;
      return Result;
   end Image;
   ------------------
   -- Context_Pool --
   ------------------
   protected body Context_Pool is
      -------------
      -- Acquire --
      -------------
      procedure Acquire (Context : out Internal_Context) is
      begin
         if Available.Is_Empty then
            Context := new Analysis_Context_Type;
            Context.Serial_Number := 1;
         else
            Context := Available.Last_Element;
            Context.Serial_Number := Context.Serial_Number + 1;
            Available.Delete_Last;
         end if;
         Context.Released := False;
      end Acquire;
      -------------
      -- Release --
      -------------
      procedure Release (Context : in out Internal_Context) is
      begin
         Available.Append (Context);
         Context.Released := True;
         Context := null;
      end Release;
      ----------
      -- Free --
      ----------
      procedure Free is
      begin
         for C of Available loop
            Free (C);
         end loop;
      end Free;
   end Context_Pool;
   --------------
   -- Finalize --
   --------------
   overriding procedure Finalize (CD : in out Contexts_Destructor) is
      pragma Unreferenced (CD);
   begin
      Context_Pool.Free;
   end Finalize;
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (Provider : in out Internal_Unit_Provider_Access) is
      procedure Destroy is new Ada.Unchecked_Deallocation
        (Internal_Unit_Provider'Class, Internal_Unit_Provider_Access);
   begin
      if Provider /= null and then Provider.all.Dec_Ref then
         Destroy (Provider);
      end if;
   end Dec_Ref;
   ----------------
   -- Get_Env_Id --
   ----------------
   function Get_Env_Id
     (E : Lexical_Env; State : in out Dump_Lexical_Env_State) return String
   is
      C        : Address_To_Id_Maps.Cursor;
      Inserted : Boolean;
   begin
      if E = Null_Lexical_Env then
         return "$null";
      elsif E = State.Root_Env then
         --  Insert root env with a special Id so that we only print it once
         State.Env_Ids.Insert (E, -1, C, Inserted);
         return "$root";
      end if;
      State.Env_Ids.Insert (E, State.Next_Id, C, Inserted);
      if Inserted then
         State.Next_Id := State.Next_Id + 1;
      end if;
      return '@' & Stripped_Image (Address_To_Id_Maps.Element (C));
   end Get_Env_Id;
   function To_Lookup_Kind_Type (K : Lookup_Kind) return Lookup_Kind_Type
   is
     (Lookup_Kind_Type'Val (Lookup_Kind'Pos (K)));
   --------------------
   -- Create_Context --
   --------------------
   function Create_Context
     (Charset       : String;
      Unit_Provider : Internal_Unit_Provider_Access;
      With_Trivia   : Boolean;
      Tab_Stop       : Positive;
      Max_Call_Depth : Natural := 1000)
      return Internal_Context
   is
      Actual_Charset : constant String :=
        (if Charset = "" then Default_Charset else Charset);
      Symbols        : constant Precomputed_Symbol_Table
        := Create_Symbol_Table;
      Context        : Internal_Context;
   begin
      Context_Pool.Acquire (Context);
      Context.Ref_Count := 1;
      Context.Symbols := Symbol_Table (Symbols);
      Context.Charset := To_Unbounded_String (Actual_Charset);
      Context.Tab_Stop := Tab_Stop;
      Context.With_Trivia := With_Trivia;
      Context.Root_Scope := AST_Envs.Create_Lexical_Env
        (Parent => AST_Envs.No_Env_Getter,
         Node   => null,
         Owner  => No_Analysis_Unit);
      Context.Unit_Provider := Unit_Provider;
      --  Create an ownership share for the unit provider so that it lives at
      --  least as long as this analysis context lives.
      if Context.Unit_Provider /= null then
         Context.Unit_Provider.Inc_Ref;
      end if;
         if Context.Unit_Provider = null then
            Context.Unit_Provider := Libadalang.Internal_Default_Provider.Create;
         end if;
      Initialize (Context.Parser);
      Context.Discard_Errors_In_Populate_Lexical_Env := True;
      Context.Logic_Resolution_Timeout := 100_000;
      Context.In_Populate_Lexical_Env := False;
      Context.Cache_Version := 0;
      Context.Reparse_Cache_Version := 0;
      Context.Rewriting_Handle := No_Rewriting_Handle_Pointer;
      Context.Templates_Unit := No_Analysis_Unit;
      Context.Max_Call_Depth := Max_Call_Depth;
Fetch_Standard (Context);
      return Context;
   end Create_Context;
   -----------------
   -- Create_Unit --
   -----------------
   function Create_Unit
     (Context             : Internal_Context;
      Normalized_Filename : Virtual_File;
      Charset             : String;
      Rule                : Grammar_Rule) return Internal_Unit
   is
      use Units_Maps;
      Unit : Internal_Unit;
   begin
      Unit := Create_Special_Unit
        (Context, Normalized_Filename, Charset, Rule);
      Context.Units.Insert (Normalized_Filename, Unit);
      return Unit;
   end Create_Unit;
   --------------
   -- Get_Unit --
   --------------
   function Get_Unit
     (Context           : Internal_Context;
      Filename, Charset : String;
      Reparse           : Boolean;
      Input             : Internal_Lexer_Input;
      Rule              : Grammar_Rule) return Internal_Unit
   is
      use Units_Maps;
      Normalized_Filename : constant GNATCOLL.VFS.Virtual_File :=
         Normalized_Unit_Filename (Context, Filename);
      Cur     : constant Cursor :=
         Context.Units.Find (Normalized_Filename);
      Created : constant Boolean := Cur = No_Element;
      Unit    : Internal_Unit;
      Actual_Charset : Unbounded_String;
      Refined_Input  : Internal_Lexer_Input := Input;
   begin
      --  Determine which encoding to use. Use the Charset parameter (if
      --  provided), otherwise use the context-wide default.
      Actual_Charset := (if Charset'Length /= 0
                         then To_Unbounded_String (Charset)
                         else Context.Charset);
      if Refined_Input.Kind = File then
         Refined_Input.Filename := Normalized_Filename;
      end if;
      if Refined_Input.Kind in File | Bytes_Buffer then
         Refined_Input.Charset := Actual_Charset;
         --  Unless the caller requested a specific charset for this unit,
         --  allow the lexer to automatically discover the source file encoding
         --  before defaulting to the context-specific one. We do this trying
         --  to match a byte order mark.
         Refined_Input.Read_BOM := Charset'Length = 0;
      end if;
      --  Create the Internal_Unit if needed
      Unit :=
        (if Created
         then Create_Unit (Context, Normalized_Filename,
                           To_String (Actual_Charset), Rule)
         else Element (Cur));
      Unit.Charset := Actual_Charset;
      --  (Re)parse it if needed
      if Created or else Reparse then
         declare
            Reparsed : Reparsed_Unit;
         begin
            Do_Parsing (Unit, Refined_Input, Reparsed);
            Update_After_Reparse (Unit, Reparsed);
         end;
      end if;
      return Unit;
   end Get_Unit;
   --------------
   -- Has_Unit --
   --------------
   function Has_Unit
     (Context       : Internal_Context;
      Unit_Filename : String) return Boolean is
   begin
      return Context.Units.Contains
        (Normalized_Unit_Filename (Context, Unit_Filename));
   end Has_Unit;
   -------------------
   -- Get_From_File --
   -------------------
   function Get_From_File
     (Context  : Internal_Context;
      Filename : String;
      Charset  : String;
      Reparse  : Boolean;
      Rule     : Grammar_Rule) return Internal_Unit
   is
      Input : constant Internal_Lexer_Input :=
        (Kind     => File,
         Charset  => <>,
         Read_BOM => False,
         Filename => <>);
   begin
      return Get_Unit (Context, Filename, Charset, Reparse, Input, Rule);
   end Get_From_File;
   ---------------------
   -- Get_From_Buffer --
   ---------------------
   function Get_From_Buffer
     (Context  : Internal_Context;
      Filename : String;
      Charset  : String;
      Buffer   : String;
      Rule     : Grammar_Rule) return Internal_Unit
   is
      Input : constant Internal_Lexer_Input :=
        (Kind        => Bytes_Buffer,
         Charset     => <>,
         Read_BOM    => False,
         Bytes       => Buffer'Address,
         Bytes_Count => Buffer'Length);
   begin
      return Get_Unit (Context, Filename, Charset, True, Input, Rule);
   end Get_From_Buffer;
   --------------------
   -- Get_With_Error --
   --------------------
   function Get_With_Error
     (Context  : Internal_Context;
      Filename : String;
      Error    : Text_Type;
      Charset  : String;
      Rule     : Grammar_Rule) return Internal_Unit
   is
      use Units_Maps;
      Normalized_Filename : constant Virtual_File :=
         Normalized_Unit_Filename (Context, Filename);
      Cur                 : constant Cursor :=
         Context.Units.Find (Normalized_Filename);
   begin
      if Cur = No_Element then
         declare
            Unit : constant Internal_Unit := Create_Unit
              (Context, Normalized_Filename, Charset, Rule);
         begin
            Append (Unit.Diagnostics, No_Source_Location_Range, Error);
            return Unit;
         end;
      else
         return Element (Cur);
      end if;
   end Get_With_Error;
   -----------------------
   -- Get_From_Provider --
   -----------------------
   function Get_From_Provider
     (Context : Internal_Context;
      Name    : Text_Type;
      Kind    : Analysis_Unit_Kind;
      Charset : String;
      Reparse : Boolean) return Internal_Unit is
   begin
      return Context.Unit_Provider.Get_Unit
        (Context, Name, Kind, Charset, Reparse);
   exception
      when Property_Error =>
         raise Invalid_Unit_Name_Error with
            "Invalid unit name: " & Image (Name, With_Quotes => True)
            & " (" & Analysis_Unit_Kind'Image (Kind) & ")";
   end Get_From_Provider;
   -------------------
   -- Unit_Provider --
   -------------------
   function Unit_Provider
     (Context : Internal_Context) return Internal_Unit_Provider_Access
   is (Context.Unit_Provider);
   ----------
   -- Hash --
   ----------
   function Hash (Context : Internal_Context) return Hash_Type is
      function H is new Hash_Access (Analysis_Context_Type, Internal_Context);
   begin
      return H (Context);
   end Hash;
   ---------------------
   -- Has_With_Trivia --
   ---------------------
   function Has_With_Trivia (Context : Internal_Context) return Boolean is
   begin
      return Context.With_Trivia;
   end Has_With_Trivia;
   --------------------------------------------
   -- Discard_Errors_In_Populate_Lexical_Env --
   --------------------------------------------
   procedure Discard_Errors_In_Populate_Lexical_Env
     (Context : Internal_Context; Discard : Boolean) is
   begin
      Context.Discard_Errors_In_Populate_Lexical_Env := Discard;
   end Discard_Errors_In_Populate_Lexical_Env;
   ----------------------------------
   -- Set_Logic_Resolution_Timeout --
   ----------------------------------
   procedure Set_Logic_Resolution_Timeout
     (Context : Internal_Context; Timeout : Natural) is
   begin
      Context.Logic_Resolution_Timeout := Timeout;
   end Set_Logic_Resolution_Timeout;
   --------------------------
   -- Has_Rewriting_Handle --
   --------------------------
   function Has_Rewriting_Handle (Context : Internal_Context) return Boolean is
   begin
      return Context.Rewriting_Handle /= No_Rewriting_Handle_Pointer;
   end Has_Rewriting_Handle;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (Context : Internal_Context) is
   begin
      if Context /= null then
         Context.Ref_Count := Context.Ref_Count + 1;
      end if;
   end Inc_Ref;
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (Context : in out Internal_Context) is
   begin
      if Context /= null then
         Context.Ref_Count := Context.Ref_Count - 1;
         if Context.Ref_Count = 0 then
            Destroy (Context);
         end if;
      end if;
   end Dec_Ref;
   -------------
   -- Destroy --
   -------------
   procedure Destroy (Context : in out Internal_Context) is
   begin
      --  Destroy all named environment data structures
      for Desc of Context.Named_Envs loop
         for V of Desc.Foreign_Nodes loop
            V.Destroy;
         end loop;
         Destroy (Desc);
      end loop;
      Context.Named_Envs.Clear;
      --  Destroy env names themselves. Note that iterating on a hashed sets
      --  needs to have set elements valid (as the traversal sometimes
      --  recomputes their hash), so we need to free them after having cleared
      --  the set.
      declare
         package Env_Name_Vectors is new Langkit_Support.Vectors (Env_Name);
         Names : Env_Name_Vectors.Vector;
      begin
         Names.Reserve (Natural (Context.Env_Names.Length));
         for N of Context.Env_Names loop
            Names.Append (N);
         end loop;
         Context.Env_Names.Clear;
         for N of Names loop
            declare
               Name : Env_Name := N;
            begin
               Destroy (Name);
            end;
         end loop;
         Names.Destroy;
      end;
      --  If we are asked to free this context, it means that no one else have
      --  references to its analysis units, so it's safe to destroy these.
      for Unit of Context.Units loop
         Destroy (Unit);
      end loop;
      Context.Units := Units_Maps.Empty_Map;
      Context.Filenames := Virtual_File_Maps.Empty_Map;
      Destroy (Context.Templates_Unit);
      AST_Envs.Destroy (Context.Root_Scope);
      Destroy (Context.Symbols);
      Destroy (Context.Parser);
      Dec_Ref (Context.Unit_Provider);
      Context_Pool.Release (Context);
   end Destroy;
   -------------
   -- Context --
   -------------
   function Context (Unit : Internal_Unit) return Internal_Context is
   begin
      return Unit.Context;
   end Context;
   ----------
   -- Hash --
   ----------
   function Hash (Unit : Internal_Unit) return Hash_Type is
      function H is new Hash_Access (Analysis_Unit_Type, Internal_Unit);
   begin
      return H (Unit);
   end Hash;
   -------------
   -- Reparse --
   -------------
   procedure Reparse (Unit : Internal_Unit; Charset : String) is
      Dummy : constant Internal_Unit := Get_From_File
        (Unit.Context, +Unit.Filename.Full_Name, Charset,
         Reparse => True,
         Rule    => Unit.Rule);
   begin
      null;
   end Reparse;
   -------------
   -- Reparse --
   -------------
   procedure Reparse (Unit : Internal_Unit; Charset : String; Buffer : String)
   is
      Dummy : constant Internal_Unit := Get_From_Buffer
        (Unit.Context, +Unit.Filename.Full_Name, Charset, Buffer, Unit.Rule);
   begin
      null;
   end Reparse;
   --------------------------
   -- Populate_Lexical_Env --
   --------------------------
   procedure Populate_Lexical_Env (Unit : Internal_Unit) is
      Context : constant Internal_Context := Unit.Context;
      Has_Errors : Boolean := False;
      --  Whether at least one Property_Error occurred during this PLE pass
      Saved_In_Populate_Lexical_Env : constant Boolean :=
         Unit.Context.In_Populate_Lexical_Env;
      procedure Reset_Envs_Caches (Unit : Internal_Unit) is
         procedure Internal (Node : Bare_Ada_Node) is
         begin
            if Node = null then
               return;
            end if;
            Reset_Caches (Node.Self_Env);
            for I in 1 .. Children_Count (Node) loop
               Internal (Child (Node, I));
            end loop;
         end Internal;
      begin
         Internal (Unit.AST_Root);
      end Reset_Envs_Caches;
   begin
      --  TODO??? Handle env invalidation when reparsing a unit and when a
      --  previous call raised a Property_Error.
      if Unit.Is_Env_Populated then
         return;
      end if;
      Unit.Is_Env_Populated := True;
      if Unit.AST_Root = null then
         return;
      end if;
      GNATCOLL.Traces.Trace (Main_Trace, "Populating lexical envs for unit: "
                                         & Basename (Unit));
      GNATCOLL.Traces.Increase_Indent (Main_Trace);
      Context.In_Populate_Lexical_Env := True;
         Has_Errors := Populate_Lexical_Env (Unit.AST_Root);
      Context.In_Populate_Lexical_Env :=
         Saved_In_Populate_Lexical_Env;
      GNATCOLL.Traces.Decrease_Indent (Main_Trace);
      Reset_Envs_Caches (Unit);
      if Has_Errors and then not Context.Discard_Errors_In_Populate_Lexical_Env
      then
         raise Property_Error with
            "errors occurred in Populate_Lexical_Env";
      end if;
   end Populate_Lexical_Env;
   ------------------
   -- Get_Filename --
   ------------------
   function Get_Filename (Unit : Internal_Unit) return String is
     (+Unit.Filename.Full_Name);
   -----------------
   -- Get_Charset --
   -----------------
   function Get_Charset (Unit : Internal_Unit) return String is
   begin
      return To_String (Unit.Charset);
   end Get_Charset;
   ---------------------
   -- Has_Diagnostics --
   ---------------------
   function Has_Diagnostics (Unit : Internal_Unit) return Boolean is
   begin
      return not Unit.Diagnostics.Is_Empty;
   end Has_Diagnostics;
   -----------------
   -- Diagnostics --
   -----------------
   function Diagnostics (Unit : Internal_Unit) return Diagnostics_Array is
      Result : Diagnostics_Array (1 .. Natural (Unit.Diagnostics.Length));
      I      : Natural := 1;
   begin
      for D of Unit.Diagnostics loop
         Result (I) := D;
         I := I + 1;
      end loop;
      return Result;
   end Diagnostics;
   ---------------------------
   -- Format_GNU_Diagnostic --
   ---------------------------
   function Format_GNU_Diagnostic
     (Unit : Internal_Unit; D : Diagnostic) return String
   is
      Filename : constant String := Basename (Unit);
      Sloc     : constant Source_Location := Start_Sloc (D.Sloc_Range);
      Msg      : constant String :=
         Image
           (Ada.Strings.Wide_Wide_Unbounded.To_Wide_Wide_String (D.Message));
   begin
      return (Filename
              & (if Sloc = No_Source_Location then "" else ":" & Image (Sloc))
              & ": " & Msg);
   end Format_GNU_Diagnostic;
   ----------
   -- Root --
   ----------
   function Root (Unit : Internal_Unit) return Bare_Ada_Node is
     (Unit.AST_Root);
   -----------------
   -- First_Token --
   -----------------
   function First_Token (Unit : Internal_Unit) return Token_Reference is
     (Wrap_Token_Reference (Unit.TDH'Access,
                            First_Token_Or_Trivia (Unit.TDH)));
   ----------------
   -- Last_Token --
   ----------------
   function Last_Token (Unit : Internal_Unit) return Token_Reference is
     (Wrap_Token_Reference (Unit.TDH'Access, Last_Token_Or_Trivia (Unit.TDH)));
   -----------------
   -- Token_Count --
   -----------------
   function Token_Count (Unit : Internal_Unit) return Natural is
     (Unit.TDH.Tokens.Length);
   ------------------
   -- Trivia_Count --
   ------------------
   function Trivia_Count (Unit : Internal_Unit) return Natural is
     (Unit.TDH.Trivias.Length);
   ----------
   -- Text --
   ----------
   function Text (Unit : Internal_Unit) return Text_Type is
   begin
      return Text (First_Token (Unit), Last_Token (Unit));
   end Text;
   ------------------
   -- Lookup_Token --
   ------------------
   function Lookup_Token
     (Unit : Internal_Unit; Sloc : Source_Location) return Token_Reference
   is
      Result : constant Token_Or_Trivia_Index := Lookup_Token (Unit.TDH, Sloc);
   begin
      return Wrap_Token_Reference (Unit.TDH'Access, Result);
   end Lookup_Token;
   ----------------------
   -- Dump_Lexical_Env --
   ----------------------
   procedure Dump_Lexical_Env (Unit : Internal_Unit) is
      Node     : constant Bare_Ada_Node := Unit.AST_Root;
      Root_Env : constant Lexical_Env := Unit.Context.Root_Scope;
      State    : Dump_Lexical_Env_State := (Root_Env => Root_Env, others => <>);
      --------------------------
      -- Explore_Parent_Chain --
      --------------------------
      procedure Explore_Parent_Chain (Env : Lexical_Env) is
      begin
         if Env /= Null_Lexical_Env then
            Dump_One_Lexical_Env
              (Env, Get_Env_Id (Env, State),
               Get_Env_Id (Get_Env (Env.Env.Parent, No_Entity_Info), State));
            Explore_Parent_Chain (Get_Env (Env.Env.Parent, No_Entity_Info));
         end if;
      end Explore_Parent_Chain;
      --------------
      -- Internal --
      --------------
      procedure Internal (Current : Bare_Ada_Node) is
         Explore_Parent : Boolean := False;
         Env, Parent    : Lexical_Env;
      begin
         if Current = null then
            return;
         end if;
         --  We only dump environments that we haven't dumped before. This way
         --  we'll only dump environments at the site of their creation, and
         --  not in any subsequent link. We use the Env_Ids map to check which
         --  envs we have already seen or not.
         if not State.Env_Ids.Contains (Current.Self_Env) then
            Env := Current.Self_Env;
            Parent := Get_Env (Env.Env.Parent, No_Entity_Info);
            Explore_Parent := not State.Env_Ids.Contains (Parent);
            Dump_One_Lexical_Env
              (Env, Get_Env_Id (Env, State), Get_Env_Id (Parent, State));
            if Explore_Parent then
               Explore_Parent_Chain (Parent);
            end if;
         end if;
         for Child of Internal_Bare_Ada_Node_Array'(Children (Current))
         loop
            Internal (Child);
         end loop;
      end Internal;
      --  This procedure implements the main recursive logic of dumping the
      --  environments.
   begin
      Internal (Bare_Ada_Node (Node));
   end Dump_Lexical_Env;
   --------------
   -- Get_Line --
   --------------
   function Get_Line
     (Unit : Internal_Unit; Line_Number : Positive) return Text_Type
   is
   begin
      return Get_Line (Unit.TDH, Line_Number);
   end Get_Line;
   -----------
   -- Print --
   -----------
   procedure Print (Unit : Internal_Unit; Show_Slocs : Boolean) is
   begin
      if Unit.AST_Root = null then
         Put_Line ("<empty analysis unit>");
      else
         Print (Unit.AST_Root, Show_Slocs);
      end if;
   end Print;
   ---------------
   -- PP_Trivia --
   ---------------
   procedure PP_Trivia (Unit : Internal_Unit) is
      procedure Process (Trivia : Token_Index) is
         Data : constant Stored_Token_Data :=
            Unit.TDH.Trivias.Get (Natural (Trivia)).T;
      begin
         Put_Line (Image (Text (Unit.TDH, Data)));
      end Process;
      Last_Token : constant Token_Index :=
         Token_Index (Token_Vectors.Last_Index (Unit.TDH.Tokens) - 1);
      --  Index for the last token in Unit excluding the Termination token
      --  (hence the -1).
   begin
      for Tok of Get_Leading_Trivias (Unit.TDH) loop
         Process (Tok);
      end loop;
      PP_Trivia (Unit.AST_Root);
      for Tok of Get_Trivias (Unit.TDH, Last_Token) loop
         Process (Tok);
      end loop;
   end PP_Trivia;
   -------------
   -- Destroy --
   -------------
   procedure Destroy (Unit : in out Internal_Unit) is
   begin
      if Unit = No_Analysis_Unit then
         return;
      end if;
      Unit.Exiled_Entries.Destroy;
      Unit.Foreign_Nodes.Destroy;
      Unit.Exiled_Entries_In_NED.Destroy;
      Unit.Exiled_Envs.Destroy;
      Unit.Named_Envs.Destroy;
      Analysis_Unit_Sets.Destroy (Unit.Referenced_Units);
         Destroy (Unit.Memoization_Map);
      Destroy_Rebindings (Unit.Rebindings'Access);
      Unit.Rebindings.Destroy;
      if Unit.AST_Root /= null then
         Destroy (Unit.AST_Root);
      end if;
      Free (Unit.TDH);
      Free (Unit.AST_Mem_Pool);
      Destroy_Unit_Destroyables (Unit);
      Destroyable_Vectors.Destroy (Unit.Destroyables);
      Free (Unit);
   end Destroy;
   -------------------
   -- Is_Token_Node --
   -------------------
   function Is_Token_Node (Node : Bare_Ada_Node) return Boolean is
   begin
      return Is_Token_Node (Node.Kind);
   end Is_Token_Node;
   ------------------
   -- Is_Synthetic --
   ------------------
   function Is_Synthetic (Node : Bare_Ada_Node) return Boolean is
   begin
      return Node.Kind in Synthetic_Nodes;
   end Is_Synthetic;
   ------------------------------
   -- Register_Destroyable_Gen --
   ------------------------------
   procedure Register_Destroyable_Gen
     (Unit : Internal_Unit; Object : T_Access)
   is
      function Convert is new Ada.Unchecked_Conversion
        (System.Address, Destroy_Procedure);
      procedure Destroy_Procedure (Object : in out T_Access) renames Destroy;
   begin
      Register_Destroyable_Helper
        (Unit,
         Object.all'Address,
         Convert (Destroy_Procedure'Address));
   end Register_Destroyable_Gen;
   ---------
   -- Get --
   ---------
   function Get
     (T       : Bare_Ada_Node_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Ada_Node
   is
      function Absolute_Get
        (T : Bare_Ada_Node_Array_Access; Index : Integer)
         return Bare_Ada_Node
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Bare_Ada_Node,
         Sequence_Type => Bare_Ada_Node_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Bare_Ada_Node;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Bare_Ada_Node;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Bare_Ada_Node_Array_Access) return Bare_Ada_Node_Array_Access is
      Ret : Bare_Ada_Node_Array_Access := Create_Bare_Ada_Node_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Bare_Ada_Node_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Bare_Ada_Node_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Bare_Ada_Node_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Bare_Ada_Node_Array (Items_Count : Natural) return Bare_Ada_Node_Array_Access
   is (if Items_Count = 0
       then No_Bare_Ada_Node_Array_Type
       else new Bare_Ada_Node_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Bare_Ada_Node_Array
     (Items : Internal_Bare_Ada_Node_Array) return Bare_Ada_Node_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Bare_Ada_Node_Array_Type;
      end if;
      return new Bare_Ada_Node_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Bare_Ada_Node_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Bare_Ada_Node_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Bare_Compilation_Unit_Vectors is new Langkit_Support.Vectors (Bare_Compilation_Unit);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Bare_Compilation_Unit_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Compilation_Unit
   is
      function Absolute_Get
        (T : Bare_Compilation_Unit_Array_Access; Index : Integer)
         return Bare_Compilation_Unit
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Bare_Compilation_Unit,
         Sequence_Type => Bare_Compilation_Unit_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Bare_Compilation_Unit;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Bare_Ada_Node;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Bare_Compilation_Unit_Array_Access) return Bare_Compilation_Unit_Array_Access is
      Ret : Bare_Compilation_Unit_Array_Access := Create_Bare_Compilation_Unit_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Bare_Compilation_Unit_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Bare_Compilation_Unit_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Bare_Compilation_Unit_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Bare_Compilation_Unit_Array (Items_Count : Natural) return Bare_Compilation_Unit_Array_Access
   is (if Items_Count = 0
       then No_Bare_Compilation_Unit_Array_Type
       else new Bare_Compilation_Unit_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Bare_Compilation_Unit_Array
     (Items : Internal_Bare_Compilation_Unit_Array) return Bare_Compilation_Unit_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Bare_Compilation_Unit_Array_Type;
      end if;
      return new Bare_Compilation_Unit_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Bare_Compilation_Unit_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Bare_Compilation_Unit_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Bare_Name_Vectors is new Langkit_Support.Vectors (Bare_Name);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Bare_Name_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Name
   is
      function Absolute_Get
        (T : Bare_Name_Array_Access; Index : Integer)
         return Bare_Name
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Bare_Name,
         Sequence_Type => Bare_Name_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Bare_Name;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Bare_Ada_Node;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Bare_Name_Array_Access) return Bare_Name_Array_Access is
      Ret : Bare_Name_Array_Access := Create_Bare_Name_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Bare_Name_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Bare_Name_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Bare_Name_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Bare_Name_Array (Items_Count : Natural) return Bare_Name_Array_Access
   is (if Items_Count = 0
       then No_Bare_Name_Array_Type
       else new Bare_Name_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Bare_Name_Array
     (Items : Internal_Bare_Name_Array) return Bare_Name_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Bare_Name_Array_Type;
      end if;
      return new Bare_Name_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Bare_Name_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Bare_Name_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
   ---------
   -- Get --
   ---------
   function Get
     (T       : Bare_Single_Tok_Node_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Single_Tok_Node
   is
      function Absolute_Get
        (T : Bare_Single_Tok_Node_Array_Access; Index : Integer)
         return Bare_Single_Tok_Node
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Bare_Single_Tok_Node,
         Sequence_Type => Bare_Single_Tok_Node_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Bare_Single_Tok_Node;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Bare_Ada_Node;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Bare_Single_Tok_Node_Array_Access) return Bare_Single_Tok_Node_Array_Access is
      Ret : Bare_Single_Tok_Node_Array_Access := Create_Bare_Single_Tok_Node_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Bare_Single_Tok_Node_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Bare_Single_Tok_Node_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Bare_Single_Tok_Node_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Bare_Single_Tok_Node_Array (Items_Count : Natural) return Bare_Single_Tok_Node_Array_Access
   is (if Items_Count = 0
       then No_Bare_Single_Tok_Node_Array_Type
       else new Bare_Single_Tok_Node_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Bare_Single_Tok_Node_Array
     (Items : Internal_Bare_Single_Tok_Node_Array) return Bare_Single_Tok_Node_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Bare_Single_Tok_Node_Array_Type;
      end if;
      return new Bare_Single_Tok_Node_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Bare_Single_Tok_Node_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Bare_Single_Tok_Node_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Character_Type_Vectors is new Langkit_Support.Vectors (Character_Type);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Character_Type_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Character_Type
   is
      function Absolute_Get
        (T : Character_Type_Array_Access; Index : Integer)
         return Character_Type
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Character_Type,
         Sequence_Type => Character_Type_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Character_Type;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return Chars.NUL;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Character_Type_Array_Access) return Character_Type_Array_Access is
      Ret : Character_Type_Array_Access := Create_Character_Type_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Character_Type_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Character_Type_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Character_Type_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Character_Type_Array (Items_Count : Natural) return Character_Type_Array_Access
   is (if Items_Count = 0
       then No_Character_Type_Array_Type
       else new Character_Type_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Character_Type_Array
     (Items : Text_Type) return Character_Type_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Character_Type_Array_Type;
      end if;
      return new Character_Type_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
      function Create_Character_Type_Array
        (Items : Unbounded_Text_Type) return Character_Type_Array_Access
      is
         Result : constant Character_Type_Array_Access :=
            Create_Character_Type_Array (Length (Items));
         S      : Big_Wide_Wide_String_Access;
         L      : Natural;
      begin
         Get_Wide_Wide_String (Items, S, L);
         Result.Items (1 .. L) := S.all (1 .. L);
         return Result;
      end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Character_Type_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Character_Type_Array_Access) return String is
            begin
               return Image (A.Items);
      end Trace_Image;
      package Character_Type_Array_Access_Vectors is new Langkit_Support.Vectors (Character_Type_Array_Access);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Character_Type_Array_Access_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Character_Type_Array_Access
   is
      function Absolute_Get
        (T : Character_Type_Array_Access_Array_Access; Index : Integer)
         return Character_Type_Array_Access
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Character_Type_Array_Access,
         Sequence_Type => Character_Type_Array_Access_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Character_Type_Array_Access;
   begin
      if Relative_Get (T, Index, Result) then
            Inc_Ref (Result);
         return Result;
      elsif Or_Null then
         return No_Character_Type_Array_Type;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Character_Type_Array_Access_Array_Access) return Character_Type_Array_Access_Array_Access is
      Ret : Character_Type_Array_Access_Array_Access := Create_Character_Type_Array_Access_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
         for Item of Ret.Items loop
            Inc_Ref (Item);
         end loop;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Character_Type_Array_Access_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Character_Type_Array_Access_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Character_Type_Array_Access_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
            for Item of T.Items loop
               Dec_Ref (Item);
            end loop;
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Character_Type_Array_Access_Array (Items_Count : Natural) return Character_Type_Array_Access_Array_Access
   is (if Items_Count = 0
       then No_Character_Type_Array_Access_Array_Type
       else new Character_Type_Array_Access_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Character_Type_Array_Access_Array
     (Items : Internal_Character_Type_Array_Access_Array) return Character_Type_Array_Access_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Character_Type_Array_Access_Array_Type;
      end if;
         for El of Items loop
            Inc_Ref (El);
         end loop;
      return new Character_Type_Array_Access_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Character_Type_Array_Access_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               not Equivalent (L.Items (I), R.Items (I))
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Character_Type_Array_Access_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Completion_Item_Vectors is new Langkit_Support.Vectors (Internal_Completion_Item);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Completion_Item_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Completion_Item
   is
      function Absolute_Get
        (T : Internal_Completion_Item_Array_Access; Index : Integer)
         return Internal_Completion_Item
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Completion_Item,
         Sequence_Type => Internal_Completion_Item_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Completion_Item;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Completion_Item;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Completion_Item_Array_Access) return Internal_Completion_Item_Array_Access is
      Ret : Internal_Completion_Item_Array_Access := Create_Internal_Completion_Item_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Completion_Item_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Completion_Item_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Completion_Item_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Completion_Item_Array (Items_Count : Natural) return Internal_Completion_Item_Array_Access
   is (if Items_Count = 0
       then No_Internal_Completion_Item_Array_Type
       else new Internal_Completion_Item_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Completion_Item_Array
     (Items : Internal_Internal_Completion_Item_Array) return Internal_Completion_Item_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Completion_Item_Array_Type;
      end if;
      return new Internal_Completion_Item_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Completion_Item_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Completion_Item_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Discriminant_Values_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Discriminant_Values
   is
      function Absolute_Get
        (T : Internal_Discriminant_Values_Array_Access; Index : Integer)
         return Internal_Discriminant_Values
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Discriminant_Values,
         Sequence_Type => Internal_Discriminant_Values_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Discriminant_Values;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Discriminant_Values;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Discriminant_Values_Array_Access) return Internal_Discriminant_Values_Array_Access is
      Ret : Internal_Discriminant_Values_Array_Access := Create_Internal_Discriminant_Values_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Discriminant_Values_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Discriminant_Values_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Discriminant_Values_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Discriminant_Values_Array (Items_Count : Natural) return Internal_Discriminant_Values_Array_Access
   is (if Items_Count = 0
       then No_Internal_Discriminant_Values_Array_Type
       else new Internal_Discriminant_Values_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Discriminant_Values_Array
     (Items : Internal_Internal_Discriminant_Values_Array) return Internal_Discriminant_Values_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Discriminant_Values_Array_Type;
      end if;
      return new Internal_Discriminant_Values_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Discriminant_Values_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Discriminant_Values_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Doc_Annotation_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Doc_Annotation
   is
      function Absolute_Get
        (T : Internal_Doc_Annotation_Array_Access; Index : Integer)
         return Internal_Doc_Annotation
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Doc_Annotation,
         Sequence_Type => Internal_Doc_Annotation_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Doc_Annotation;
   begin
      if Relative_Get (T, Index, Result) then
            Inc_Ref (Result);
         return Result;
      elsif Or_Null then
         return No_Doc_Annotation;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Doc_Annotation_Array_Access) return Internal_Doc_Annotation_Array_Access is
      Ret : Internal_Doc_Annotation_Array_Access := Create_Internal_Doc_Annotation_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
         for Item of Ret.Items loop
            Inc_Ref (Item);
         end loop;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Doc_Annotation_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Doc_Annotation_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Doc_Annotation_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
            for Item of T.Items loop
               Dec_Ref (Item);
            end loop;
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Doc_Annotation_Array (Items_Count : Natural) return Internal_Doc_Annotation_Array_Access
   is (if Items_Count = 0
       then No_Internal_Doc_Annotation_Array_Type
       else new Internal_Doc_Annotation_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Doc_Annotation_Array
     (Items : Internal_Internal_Doc_Annotation_Array) return Internal_Doc_Annotation_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Doc_Annotation_Array_Type;
      end if;
         for El of Items loop
            Inc_Ref (El);
         end loop;
      return new Internal_Doc_Annotation_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Doc_Annotation_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               not Equivalent (L.Items (I), R.Items (I))
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Doc_Annotation_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Entity_Aspect_Assoc_Vectors is new Langkit_Support.Vectors (Internal_Entity_Aspect_Assoc);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Aspect_Assoc_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Aspect_Assoc
   is
      function Absolute_Get
        (T : Internal_Entity_Aspect_Assoc_Array_Access; Index : Integer)
         return Internal_Entity_Aspect_Assoc
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Aspect_Assoc,
         Sequence_Type => Internal_Entity_Aspect_Assoc_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Aspect_Assoc;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Aspect_Assoc;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Aspect_Assoc_Array_Access) return Internal_Entity_Aspect_Assoc_Array_Access is
      Ret : Internal_Entity_Aspect_Assoc_Array_Access := Create_Internal_Entity_Aspect_Assoc_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Aspect_Assoc_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Aspect_Assoc_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Aspect_Assoc_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Aspect_Assoc_Array (Items_Count : Natural) return Internal_Entity_Aspect_Assoc_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Aspect_Assoc_Array_Type
       else new Internal_Entity_Aspect_Assoc_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Aspect_Assoc_Array
     (Items : Internal_Internal_Entity_Aspect_Assoc_Array) return Internal_Entity_Aspect_Assoc_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Aspect_Assoc_Array_Type;
      end if;
      return new Internal_Entity_Aspect_Assoc_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Aspect_Assoc_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Aspect_Assoc_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Entity_Base_Formal_Param_Decl_Vectors is new Langkit_Support.Vectors (Internal_Entity_Base_Formal_Param_Decl);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Base_Formal_Param_Decl_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Base_Formal_Param_Decl
   is
      function Absolute_Get
        (T : Internal_Entity_Base_Formal_Param_Decl_Array_Access; Index : Integer)
         return Internal_Entity_Base_Formal_Param_Decl
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Base_Formal_Param_Decl,
         Sequence_Type => Internal_Entity_Base_Formal_Param_Decl_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Base_Formal_Param_Decl;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Base_Formal_Param_Decl;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Base_Formal_Param_Decl_Array_Access) return Internal_Entity_Base_Formal_Param_Decl_Array_Access is
      Ret : Internal_Entity_Base_Formal_Param_Decl_Array_Access := Create_Internal_Entity_Base_Formal_Param_Decl_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Base_Formal_Param_Decl_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Base_Formal_Param_Decl_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Base_Formal_Param_Decl_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Base_Formal_Param_Decl_Array (Items_Count : Natural) return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Base_Formal_Param_Decl_Array_Type
       else new Internal_Entity_Base_Formal_Param_Decl_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Base_Formal_Param_Decl_Array
     (Items : Internal_Internal_Entity_Base_Formal_Param_Decl_Array) return Internal_Entity_Base_Formal_Param_Decl_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Base_Formal_Param_Decl_Array_Type;
      end if;
      return new Internal_Entity_Base_Formal_Param_Decl_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Base_Formal_Param_Decl_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Base_Formal_Param_Decl_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Entity_Base_Type_Decl_Vectors is new Langkit_Support.Vectors (Internal_Entity_Base_Type_Decl);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Base_Type_Decl_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Base_Type_Decl
   is
      function Absolute_Get
        (T : Internal_Entity_Base_Type_Decl_Array_Access; Index : Integer)
         return Internal_Entity_Base_Type_Decl
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Base_Type_Decl,
         Sequence_Type => Internal_Entity_Base_Type_Decl_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Base_Type_Decl;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Base_Type_Decl;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Base_Type_Decl_Array_Access) return Internal_Entity_Base_Type_Decl_Array_Access is
      Ret : Internal_Entity_Base_Type_Decl_Array_Access := Create_Internal_Entity_Base_Type_Decl_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Base_Type_Decl_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Base_Type_Decl_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Base_Type_Decl_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Base_Type_Decl_Array (Items_Count : Natural) return Internal_Entity_Base_Type_Decl_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Base_Type_Decl_Array_Type
       else new Internal_Entity_Base_Type_Decl_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Base_Type_Decl_Array
     (Items : Internal_Internal_Entity_Base_Type_Decl_Array) return Internal_Entity_Base_Type_Decl_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Base_Type_Decl_Array_Type;
      end if;
      return new Internal_Entity_Base_Type_Decl_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Base_Type_Decl_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Base_Type_Decl_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      function Make_Unique (A : Internal_Entity_Base_Type_Decl_Array_Access) return Internal_Entity_Base_Type_Decl_Array_Access is
         --  To keep the order of the result deterministic, this function works
         --  in two steps. First, determine for each item in A whether it
         --  duplicate a previous item. Only then, go through all items in A
         --  and add only non-duplicated ones to the result.
         Duplicates : array (A.Items'Range) of Boolean := (others => False);
         --  For each item in A, indicate whether the value is a duplicate of a
         --  previous one in the array.
         Unique_Elements : Natural;
         --  Number of unique elements in A
      begin
         --  Step 1: compute Duplicates
         declare
            package Sets is new Ada.Containers.Hashed_Sets
              (Element_Type        => Internal_Entity_Base_Type_Decl,
               "="                 => "=",
               Equivalent_Elements => "=",
               Hash                => Hash);
            Set : Sets.Set;
         begin
            for I in A.Items'Range loop
               declare
                  Item : Internal_Entity_Base_Type_Decl renames A.Items (I);
               begin
                  if Set.Contains (Item) then
                     Duplicates (I) := True;
                  else
                     Set.Insert (Item);
                  end if;
               end;
            end loop;
            Unique_Elements := Natural (Set.Length);
         end;
         --  Step 2: create the result
         declare
            Next   : Positive := 1;
            Result : constant Internal_Entity_Base_Type_Decl_Array_Access :=
               Create_Internal_Entity_Base_Type_Decl_Array (Unique_Elements);
         begin
            for I in A.Items'Range loop
               declare
                  Item : Internal_Entity_Base_Type_Decl renames A.Items (I);
               begin
                  if not Duplicates (I) then
                     Result.Items (Next) := Item;
                     Next := Next + 1;
                  end if;
               end;
            end loop;
            pragma Assert (Next = Result.N + 1);
            return Result;
         end;
      end Make_Unique;
      package Internal_Entity_Basic_Assoc_Vectors is new Langkit_Support.Vectors (Internal_Entity_Basic_Assoc);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Basic_Assoc_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Basic_Assoc
   is
      function Absolute_Get
        (T : Internal_Entity_Basic_Assoc_Array_Access; Index : Integer)
         return Internal_Entity_Basic_Assoc
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Basic_Assoc,
         Sequence_Type => Internal_Entity_Basic_Assoc_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Basic_Assoc;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Basic_Assoc;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Basic_Assoc_Array_Access) return Internal_Entity_Basic_Assoc_Array_Access is
      Ret : Internal_Entity_Basic_Assoc_Array_Access := Create_Internal_Entity_Basic_Assoc_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Basic_Assoc_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Basic_Assoc_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Basic_Assoc_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Basic_Assoc_Array (Items_Count : Natural) return Internal_Entity_Basic_Assoc_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Basic_Assoc_Array_Type
       else new Internal_Entity_Basic_Assoc_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Basic_Assoc_Array
     (Items : Internal_Internal_Entity_Basic_Assoc_Array) return Internal_Entity_Basic_Assoc_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Basic_Assoc_Array_Type;
      end if;
      return new Internal_Entity_Basic_Assoc_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Basic_Assoc_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Basic_Assoc_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Entity_Basic_Decl_Vectors is new Langkit_Support.Vectors (Internal_Entity_Basic_Decl);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Basic_Decl_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Basic_Decl
   is
      function Absolute_Get
        (T : Internal_Entity_Basic_Decl_Array_Access; Index : Integer)
         return Internal_Entity_Basic_Decl
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Basic_Decl,
         Sequence_Type => Internal_Entity_Basic_Decl_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Basic_Decl;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Basic_Decl;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Basic_Decl_Array_Access) return Internal_Entity_Basic_Decl_Array_Access is
      Ret : Internal_Entity_Basic_Decl_Array_Access := Create_Internal_Entity_Basic_Decl_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Basic_Decl_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Basic_Decl_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Basic_Decl_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Basic_Decl_Array (Items_Count : Natural) return Internal_Entity_Basic_Decl_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Basic_Decl_Array_Type
       else new Internal_Entity_Basic_Decl_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Basic_Decl_Array
     (Items : Internal_Internal_Entity_Basic_Decl_Array) return Internal_Entity_Basic_Decl_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Basic_Decl_Array_Type;
      end if;
      return new Internal_Entity_Basic_Decl_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Basic_Decl_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Basic_Decl_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      function Make_Unique (A : Internal_Entity_Basic_Decl_Array_Access) return Internal_Entity_Basic_Decl_Array_Access is
         --  To keep the order of the result deterministic, this function works
         --  in two steps. First, determine for each item in A whether it
         --  duplicate a previous item. Only then, go through all items in A
         --  and add only non-duplicated ones to the result.
         Duplicates : array (A.Items'Range) of Boolean := (others => False);
         --  For each item in A, indicate whether the value is a duplicate of a
         --  previous one in the array.
         Unique_Elements : Natural;
         --  Number of unique elements in A
      begin
         --  Step 1: compute Duplicates
         declare
            package Sets is new Ada.Containers.Hashed_Sets
              (Element_Type        => Internal_Entity_Basic_Decl,
               "="                 => "=",
               Equivalent_Elements => "=",
               Hash                => Hash);
            Set : Sets.Set;
         begin
            for I in A.Items'Range loop
               declare
                  Item : Internal_Entity_Basic_Decl renames A.Items (I);
               begin
                  if Set.Contains (Item) then
                     Duplicates (I) := True;
                  else
                     Set.Insert (Item);
                  end if;
               end;
            end loop;
            Unique_Elements := Natural (Set.Length);
         end;
         --  Step 2: create the result
         declare
            Next   : Positive := 1;
            Result : constant Internal_Entity_Basic_Decl_Array_Access :=
               Create_Internal_Entity_Basic_Decl_Array (Unique_Elements);
         begin
            for I in A.Items'Range loop
               declare
                  Item : Internal_Entity_Basic_Decl renames A.Items (I);
               begin
                  if not Duplicates (I) then
                     Result.Items (Next) := Item;
                     Next := Next + 1;
                  end if;
               end;
            end loop;
            pragma Assert (Next = Result.N + 1);
            return Result;
         end;
      end Make_Unique;
      package Internal_Entity_Compilation_Unit_Vectors is new Langkit_Support.Vectors (Internal_Entity_Compilation_Unit);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Compilation_Unit_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Compilation_Unit
   is
      function Absolute_Get
        (T : Internal_Entity_Compilation_Unit_Array_Access; Index : Integer)
         return Internal_Entity_Compilation_Unit
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Compilation_Unit,
         Sequence_Type => Internal_Entity_Compilation_Unit_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Compilation_Unit;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Compilation_Unit;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Compilation_Unit_Array_Access) return Internal_Entity_Compilation_Unit_Array_Access is
      Ret : Internal_Entity_Compilation_Unit_Array_Access := Create_Internal_Entity_Compilation_Unit_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Compilation_Unit_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Compilation_Unit_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Compilation_Unit_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Compilation_Unit_Array (Items_Count : Natural) return Internal_Entity_Compilation_Unit_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Compilation_Unit_Array_Type
       else new Internal_Entity_Compilation_Unit_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Compilation_Unit_Array
     (Items : Internal_Internal_Entity_Compilation_Unit_Array) return Internal_Entity_Compilation_Unit_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Compilation_Unit_Array_Type;
      end if;
      return new Internal_Entity_Compilation_Unit_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Compilation_Unit_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Compilation_Unit_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      function Make_Unique (A : Internal_Entity_Compilation_Unit_Array_Access) return Internal_Entity_Compilation_Unit_Array_Access is
         --  To keep the order of the result deterministic, this function works
         --  in two steps. First, determine for each item in A whether it
         --  duplicate a previous item. Only then, go through all items in A
         --  and add only non-duplicated ones to the result.
         Duplicates : array (A.Items'Range) of Boolean := (others => False);
         --  For each item in A, indicate whether the value is a duplicate of a
         --  previous one in the array.
         Unique_Elements : Natural;
         --  Number of unique elements in A
      begin
         --  Step 1: compute Duplicates
         declare
            package Sets is new Ada.Containers.Hashed_Sets
              (Element_Type        => Internal_Entity_Compilation_Unit,
               "="                 => "=",
               Equivalent_Elements => "=",
               Hash                => Hash);
            Set : Sets.Set;
         begin
            for I in A.Items'Range loop
               declare
                  Item : Internal_Entity_Compilation_Unit renames A.Items (I);
               begin
                  if Set.Contains (Item) then
                     Duplicates (I) := True;
                  else
                     Set.Insert (Item);
                  end if;
               end;
            end loop;
            Unique_Elements := Natural (Set.Length);
         end;
         --  Step 2: create the result
         declare
            Next   : Positive := 1;
            Result : constant Internal_Entity_Compilation_Unit_Array_Access :=
               Create_Internal_Entity_Compilation_Unit_Array (Unique_Elements);
         begin
            for I in A.Items'Range loop
               declare
                  Item : Internal_Entity_Compilation_Unit renames A.Items (I);
               begin
                  if not Duplicates (I) then
                     Result.Items (Next) := Item;
                     Next := Next + 1;
                  end if;
               end;
            end loop;
            pragma Assert (Next = Result.N + 1);
            return Result;
         end;
      end Make_Unique;
      package Internal_Entity_Defining_Name_Vectors is new Langkit_Support.Vectors (Internal_Entity_Defining_Name);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Defining_Name_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Defining_Name
   is
      function Absolute_Get
        (T : Internal_Entity_Defining_Name_Array_Access; Index : Integer)
         return Internal_Entity_Defining_Name
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Defining_Name,
         Sequence_Type => Internal_Entity_Defining_Name_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Defining_Name;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Defining_Name;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Defining_Name_Array_Access) return Internal_Entity_Defining_Name_Array_Access is
      Ret : Internal_Entity_Defining_Name_Array_Access := Create_Internal_Entity_Defining_Name_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Defining_Name_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Defining_Name_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Defining_Name_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Defining_Name_Array (Items_Count : Natural) return Internal_Entity_Defining_Name_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Defining_Name_Array_Type
       else new Internal_Entity_Defining_Name_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Defining_Name_Array
     (Items : Internal_Internal_Entity_Defining_Name_Array) return Internal_Entity_Defining_Name_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Defining_Name_Array_Type;
      end if;
      return new Internal_Entity_Defining_Name_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Defining_Name_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Defining_Name_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Entity_Expr_Vectors is new Langkit_Support.Vectors (Internal_Entity_Expr);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Expr_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Expr
   is
      function Absolute_Get
        (T : Internal_Entity_Expr_Array_Access; Index : Integer)
         return Internal_Entity_Expr
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Expr,
         Sequence_Type => Internal_Entity_Expr_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Expr;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Expr;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Expr_Array_Access) return Internal_Entity_Expr_Array_Access is
      Ret : Internal_Entity_Expr_Array_Access := Create_Internal_Entity_Expr_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Expr_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Expr_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Expr_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Expr_Array (Items_Count : Natural) return Internal_Entity_Expr_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Expr_Array_Type
       else new Internal_Entity_Expr_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Expr_Array
     (Items : Internal_Internal_Entity_Expr_Array) return Internal_Entity_Expr_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Expr_Array_Type;
      end if;
      return new Internal_Entity_Expr_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Expr_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Expr_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Generic_Instantiation_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Generic_Instantiation
   is
      function Absolute_Get
        (T : Internal_Entity_Generic_Instantiation_Array_Access; Index : Integer)
         return Internal_Entity_Generic_Instantiation
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Generic_Instantiation,
         Sequence_Type => Internal_Entity_Generic_Instantiation_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Generic_Instantiation;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Generic_Instantiation;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Generic_Instantiation_Array_Access) return Internal_Entity_Generic_Instantiation_Array_Access is
      Ret : Internal_Entity_Generic_Instantiation_Array_Access := Create_Internal_Entity_Generic_Instantiation_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Generic_Instantiation_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Generic_Instantiation_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Generic_Instantiation_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Generic_Instantiation_Array (Items_Count : Natural) return Internal_Entity_Generic_Instantiation_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Generic_Instantiation_Array_Type
       else new Internal_Entity_Generic_Instantiation_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Generic_Instantiation_Array
     (Items : Internal_Internal_Entity_Generic_Instantiation_Array) return Internal_Entity_Generic_Instantiation_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Generic_Instantiation_Array_Type;
      end if;
      return new Internal_Entity_Generic_Instantiation_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Generic_Instantiation_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Generic_Instantiation_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Entity_Param_Spec_Vectors is new Langkit_Support.Vectors (Internal_Entity_Param_Spec);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Param_Spec_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Param_Spec
   is
      function Absolute_Get
        (T : Internal_Entity_Param_Spec_Array_Access; Index : Integer)
         return Internal_Entity_Param_Spec
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Param_Spec,
         Sequence_Type => Internal_Entity_Param_Spec_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Param_Spec;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Param_Spec;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Param_Spec_Array_Access) return Internal_Entity_Param_Spec_Array_Access is
      Ret : Internal_Entity_Param_Spec_Array_Access := Create_Internal_Entity_Param_Spec_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Param_Spec_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Param_Spec_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Param_Spec_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Param_Spec_Array (Items_Count : Natural) return Internal_Entity_Param_Spec_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Param_Spec_Array_Type
       else new Internal_Entity_Param_Spec_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Param_Spec_Array
     (Items : Internal_Internal_Entity_Param_Spec_Array) return Internal_Entity_Param_Spec_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Param_Spec_Array_Type;
      end if;
      return new Internal_Entity_Param_Spec_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Param_Spec_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Param_Spec_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Entity_Pragma_Node_Vectors is new Langkit_Support.Vectors (Internal_Entity_Pragma_Node);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Pragma_Node_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Pragma_Node
   is
      function Absolute_Get
        (T : Internal_Entity_Pragma_Node_Array_Access; Index : Integer)
         return Internal_Entity_Pragma_Node
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Pragma_Node,
         Sequence_Type => Internal_Entity_Pragma_Node_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Pragma_Node;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Pragma_Node;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Pragma_Node_Array_Access) return Internal_Entity_Pragma_Node_Array_Access is
      Ret : Internal_Entity_Pragma_Node_Array_Access := Create_Internal_Entity_Pragma_Node_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Pragma_Node_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Pragma_Node_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Pragma_Node_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Pragma_Node_Array (Items_Count : Natural) return Internal_Entity_Pragma_Node_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Pragma_Node_Array_Type
       else new Internal_Entity_Pragma_Node_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Pragma_Node_Array
     (Items : Internal_Internal_Entity_Pragma_Node_Array) return Internal_Entity_Pragma_Node_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Pragma_Node_Array_Type;
      end if;
      return new Internal_Entity_Pragma_Node_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Pragma_Node_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Pragma_Node_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Entity_Type_Decl_Vectors is new Langkit_Support.Vectors (Internal_Entity_Type_Decl);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Type_Decl_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Type_Decl
   is
      function Absolute_Get
        (T : Internal_Entity_Type_Decl_Array_Access; Index : Integer)
         return Internal_Entity_Type_Decl
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Type_Decl,
         Sequence_Type => Internal_Entity_Type_Decl_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Type_Decl;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Type_Decl;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Type_Decl_Array_Access) return Internal_Entity_Type_Decl_Array_Access is
      Ret : Internal_Entity_Type_Decl_Array_Access := Create_Internal_Entity_Type_Decl_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Type_Decl_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Type_Decl_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Type_Decl_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Type_Decl_Array (Items_Count : Natural) return Internal_Entity_Type_Decl_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Type_Decl_Array_Type
       else new Internal_Entity_Type_Decl_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Type_Decl_Array
     (Items : Internal_Internal_Entity_Type_Decl_Array) return Internal_Entity_Type_Decl_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Type_Decl_Array_Type;
      end if;
      return new Internal_Entity_Type_Decl_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Type_Decl_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Type_Decl_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Entity_Type_Expr_Vectors is new Langkit_Support.Vectors (Internal_Entity_Type_Expr);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Type_Expr_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Type_Expr
   is
      function Absolute_Get
        (T : Internal_Entity_Type_Expr_Array_Access; Index : Integer)
         return Internal_Entity_Type_Expr
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Type_Expr,
         Sequence_Type => Internal_Entity_Type_Expr_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Type_Expr;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Type_Expr;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Type_Expr_Array_Access) return Internal_Entity_Type_Expr_Array_Access is
      Ret : Internal_Entity_Type_Expr_Array_Access := Create_Internal_Entity_Type_Expr_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Type_Expr_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Type_Expr_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Type_Expr_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Type_Expr_Array (Items_Count : Natural) return Internal_Entity_Type_Expr_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Type_Expr_Array_Type
       else new Internal_Entity_Type_Expr_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Type_Expr_Array
     (Items : Internal_Internal_Entity_Type_Expr_Array) return Internal_Entity_Type_Expr_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Type_Expr_Array_Type;
      end if;
      return new Internal_Entity_Type_Expr_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Type_Expr_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Type_Expr_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Entity_Variant_Vectors is new Langkit_Support.Vectors (Internal_Entity_Variant);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Variant_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Variant
   is
      function Absolute_Get
        (T : Internal_Entity_Variant_Array_Access; Index : Integer)
         return Internal_Entity_Variant
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity_Variant,
         Sequence_Type => Internal_Entity_Variant_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity_Variant;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity_Variant;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Variant_Array_Access) return Internal_Entity_Variant_Array_Access is
      Ret : Internal_Entity_Variant_Array_Access := Create_Internal_Entity_Variant_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Variant_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Variant_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Variant_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Variant_Array (Items_Count : Natural) return Internal_Entity_Variant_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Variant_Array_Type
       else new Internal_Entity_Variant_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Variant_Array
     (Items : Internal_Internal_Entity_Variant_Array) return Internal_Entity_Variant_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Variant_Array_Type;
      end if;
      return new Internal_Entity_Variant_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Variant_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Variant_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Env_Assoc_Vectors is new Langkit_Support.Vectors (Internal_Env_Assoc);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Env_Assoc_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Env_Assoc
   is
      function Absolute_Get
        (T : Internal_Env_Assoc_Array_Access; Index : Integer)
         return Internal_Env_Assoc
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Env_Assoc,
         Sequence_Type => Internal_Env_Assoc_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Env_Assoc;
   begin
      if Relative_Get (T, Index, Result) then
            Inc_Ref (Result);
         return Result;
      elsif Or_Null then
         return No_Env_Assoc;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Env_Assoc_Array_Access) return Internal_Env_Assoc_Array_Access is
      Ret : Internal_Env_Assoc_Array_Access := Create_Internal_Env_Assoc_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
         for Item of Ret.Items loop
            Inc_Ref (Item);
         end loop;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Env_Assoc_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Env_Assoc_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Env_Assoc_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
            for Item of T.Items loop
               Dec_Ref (Item);
            end loop;
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Env_Assoc_Array (Items_Count : Natural) return Internal_Env_Assoc_Array_Access
   is (if Items_Count = 0
       then No_Internal_Env_Assoc_Array_Type
       else new Internal_Env_Assoc_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Env_Assoc_Array
     (Items : Internal_Internal_Env_Assoc_Array) return Internal_Env_Assoc_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Env_Assoc_Array_Type;
      end if;
         for El of Items loop
            Inc_Ref (El);
         end loop;
      return new Internal_Env_Assoc_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Env_Assoc_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               not Equivalent (L.Items (I), R.Items (I))
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Env_Assoc_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Expected_Type_For_Expr_Vectors is new Langkit_Support.Vectors (Internal_Expected_Type_For_Expr);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Expected_Type_For_Expr_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Expected_Type_For_Expr
   is
      function Absolute_Get
        (T : Internal_Expected_Type_For_Expr_Array_Access; Index : Integer)
         return Internal_Expected_Type_For_Expr
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Expected_Type_For_Expr,
         Sequence_Type => Internal_Expected_Type_For_Expr_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Expected_Type_For_Expr;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Expected_Type_For_Expr;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Expected_Type_For_Expr_Array_Access) return Internal_Expected_Type_For_Expr_Array_Access is
      Ret : Internal_Expected_Type_For_Expr_Array_Access := Create_Internal_Expected_Type_For_Expr_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Expected_Type_For_Expr_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Expected_Type_For_Expr_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Expected_Type_For_Expr_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Expected_Type_For_Expr_Array (Items_Count : Natural) return Internal_Expected_Type_For_Expr_Array_Access
   is (if Items_Count = 0
       then No_Internal_Expected_Type_For_Expr_Array_Type
       else new Internal_Expected_Type_For_Expr_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Expected_Type_For_Expr_Array
     (Items : Internal_Internal_Expected_Type_For_Expr_Array) return Internal_Expected_Type_For_Expr_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Expected_Type_For_Expr_Array_Type;
      end if;
      return new Internal_Expected_Type_For_Expr_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Expected_Type_For_Expr_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Expected_Type_For_Expr_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Param_Actual_Vectors is new Langkit_Support.Vectors (Internal_Param_Actual);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Param_Actual_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Param_Actual
   is
      function Absolute_Get
        (T : Internal_Param_Actual_Array_Access; Index : Integer)
         return Internal_Param_Actual
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Param_Actual,
         Sequence_Type => Internal_Param_Actual_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Param_Actual;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Param_Actual;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Param_Actual_Array_Access) return Internal_Param_Actual_Array_Access is
      Ret : Internal_Param_Actual_Array_Access := Create_Internal_Param_Actual_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Param_Actual_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Param_Actual_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Param_Actual_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Param_Actual_Array (Items_Count : Natural) return Internal_Param_Actual_Array_Access
   is (if Items_Count = 0
       then No_Internal_Param_Actual_Array_Type
       else new Internal_Param_Actual_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Param_Actual_Array
     (Items : Internal_Internal_Param_Actual_Array) return Internal_Param_Actual_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Param_Actual_Array_Type;
      end if;
      return new Internal_Param_Actual_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Param_Actual_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Param_Actual_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Param_Match_Vectors is new Langkit_Support.Vectors (Internal_Param_Match);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Param_Match_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Param_Match
   is
      function Absolute_Get
        (T : Internal_Param_Match_Array_Access; Index : Integer)
         return Internal_Param_Match
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Param_Match,
         Sequence_Type => Internal_Param_Match_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Param_Match;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Param_Match;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Param_Match_Array_Access) return Internal_Param_Match_Array_Access is
      Ret : Internal_Param_Match_Array_Access := Create_Internal_Param_Match_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Param_Match_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Param_Match_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Param_Match_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Param_Match_Array (Items_Count : Natural) return Internal_Param_Match_Array_Access
   is (if Items_Count = 0
       then No_Internal_Param_Match_Array_Type
       else new Internal_Param_Match_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Param_Match_Array
     (Items : Internal_Internal_Param_Match_Array) return Internal_Param_Match_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Param_Match_Array_Type;
      end if;
      return new Internal_Param_Match_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Param_Match_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Param_Match_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Ref_Result_Vectors is new Langkit_Support.Vectors (Internal_Ref_Result);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Ref_Result_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Ref_Result
   is
      function Absolute_Get
        (T : Internal_Ref_Result_Array_Access; Index : Integer)
         return Internal_Ref_Result
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Ref_Result,
         Sequence_Type => Internal_Ref_Result_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Ref_Result;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Ref_Result;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Ref_Result_Array_Access) return Internal_Ref_Result_Array_Access is
      Ret : Internal_Ref_Result_Array_Access := Create_Internal_Ref_Result_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Ref_Result_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Ref_Result_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Ref_Result_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Ref_Result_Array (Items_Count : Natural) return Internal_Ref_Result_Array_Access
   is (if Items_Count = 0
       then No_Internal_Ref_Result_Array_Type
       else new Internal_Ref_Result_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Ref_Result_Array
     (Items : Internal_Internal_Ref_Result_Array) return Internal_Ref_Result_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Ref_Result_Array_Type;
      end if;
      return new Internal_Ref_Result_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Ref_Result_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Ref_Result_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Shape_Vectors is new Langkit_Support.Vectors (Internal_Shape);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Shape_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Shape
   is
      function Absolute_Get
        (T : Internal_Shape_Array_Access; Index : Integer)
         return Internal_Shape
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Shape,
         Sequence_Type => Internal_Shape_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Shape;
   begin
      if Relative_Get (T, Index, Result) then
            Inc_Ref (Result);
         return Result;
      elsif Or_Null then
         return No_Shape;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Shape_Array_Access) return Internal_Shape_Array_Access is
      Ret : Internal_Shape_Array_Access := Create_Internal_Shape_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
         for Item of Ret.Items loop
            Inc_Ref (Item);
         end loop;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Shape_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Shape_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Shape_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
            for Item of T.Items loop
               Dec_Ref (Item);
            end loop;
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Shape_Array (Items_Count : Natural) return Internal_Shape_Array_Access
   is (if Items_Count = 0
       then No_Internal_Shape_Array_Type
       else new Internal_Shape_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Shape_Array
     (Items : Internal_Internal_Shape_Array) return Internal_Shape_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Shape_Array_Type;
      end if;
         for El of Items loop
            Inc_Ref (El);
         end loop;
      return new Internal_Shape_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Shape_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               not Equivalent (L.Items (I), R.Items (I))
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Shape_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Single_Actual_Vectors is new Langkit_Support.Vectors (Internal_Single_Actual);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Single_Actual_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Single_Actual
   is
      function Absolute_Get
        (T : Internal_Single_Actual_Array_Access; Index : Integer)
         return Internal_Single_Actual
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Single_Actual,
         Sequence_Type => Internal_Single_Actual_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Single_Actual;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Single_Actual;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Single_Actual_Array_Access) return Internal_Single_Actual_Array_Access is
      Ret : Internal_Single_Actual_Array_Access := Create_Internal_Single_Actual_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Single_Actual_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Single_Actual_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Single_Actual_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Single_Actual_Array (Items_Count : Natural) return Internal_Single_Actual_Array_Access
   is (if Items_Count = 0
       then No_Internal_Single_Actual_Array_Type
       else new Internal_Single_Actual_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Single_Actual_Array
     (Items : Internal_Internal_Single_Actual_Array) return Internal_Single_Actual_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Single_Actual_Array_Type;
      end if;
      return new Internal_Single_Actual_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Single_Actual_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Single_Actual_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Single_Formal_Vectors is new Langkit_Support.Vectors (Internal_Single_Formal);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Single_Formal_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Single_Formal
   is
      function Absolute_Get
        (T : Internal_Single_Formal_Array_Access; Index : Integer)
         return Internal_Single_Formal
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Single_Formal,
         Sequence_Type => Internal_Single_Formal_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Single_Formal;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Single_Formal;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Single_Formal_Array_Access) return Internal_Single_Formal_Array_Access is
      Ret : Internal_Single_Formal_Array_Access := Create_Internal_Single_Formal_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Single_Formal_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Single_Formal_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Single_Formal_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Single_Formal_Array (Items_Count : Natural) return Internal_Single_Formal_Array_Access
   is (if Items_Count = 0
       then No_Internal_Single_Formal_Array_Type
       else new Internal_Single_Formal_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Single_Formal_Array
     (Items : Internal_Internal_Single_Formal_Array) return Internal_Single_Formal_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Single_Formal_Array_Type;
      end if;
      return new Internal_Single_Formal_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Single_Formal_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Single_Formal_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Substitution_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Substitution
   is
      function Absolute_Get
        (T : Internal_Substitution_Array_Access; Index : Integer)
         return Internal_Substitution
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Substitution,
         Sequence_Type => Internal_Substitution_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Substitution;
   begin
      if Relative_Get (T, Index, Result) then
            Inc_Ref (Result);
         return Result;
      elsif Or_Null then
         return No_Substitution;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Substitution_Array_Access) return Internal_Substitution_Array_Access is
      Ret : Internal_Substitution_Array_Access := Create_Internal_Substitution_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
         for Item of Ret.Items loop
            Inc_Ref (Item);
         end loop;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Substitution_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Substitution_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Substitution_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
            for Item of T.Items loop
               Dec_Ref (Item);
            end loop;
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Substitution_Array (Items_Count : Natural) return Internal_Substitution_Array_Access
   is (if Items_Count = 0
       then No_Internal_Substitution_Array_Type
       else new Internal_Substitution_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Substitution_Array
     (Items : Internal_Internal_Substitution_Array) return Internal_Substitution_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Substitution_Array_Type;
      end if;
         for El of Items loop
            Inc_Ref (El);
         end loop;
      return new Internal_Substitution_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Substitution_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               not Equivalent (L.Items (I), R.Items (I))
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Substitution_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Unit_Vectors is new Langkit_Support.Vectors (Internal_Unit);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Unit_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Unit
   is
      function Absolute_Get
        (T : Internal_Unit_Array_Access; Index : Integer)
         return Internal_Unit
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Unit,
         Sequence_Type => Internal_Unit_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Unit;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return null;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Unit_Array_Access) return Internal_Unit_Array_Access is
      Ret : Internal_Unit_Array_Access := Create_Internal_Unit_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Unit_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Unit_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Unit_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Unit_Array (Items_Count : Natural) return Internal_Unit_Array_Access
   is (if Items_Count = 0
       then No_Internal_Unit_Array_Type
       else new Internal_Unit_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Unit_Array
     (Items : Internal_Internal_Unit_Array) return Internal_Unit_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Unit_Array_Type;
      end if;
      return new Internal_Unit_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Unit_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Unit_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      function Make_Unique (A : Internal_Unit_Array_Access) return Internal_Unit_Array_Access is
         --  To keep the order of the result deterministic, this function works
         --  in two steps. First, determine for each item in A whether it
         --  duplicate a previous item. Only then, go through all items in A
         --  and add only non-duplicated ones to the result.
         Duplicates : array (A.Items'Range) of Boolean := (others => False);
         --  For each item in A, indicate whether the value is a duplicate of a
         --  previous one in the array.
         Unique_Elements : Natural;
         --  Number of unique elements in A
      begin
         --  Step 1: compute Duplicates
         declare
            package Sets is new Ada.Containers.Hashed_Sets
              (Element_Type        => Internal_Unit,
               "="                 => "=",
               Equivalent_Elements => "=",
               Hash                => Hash);
            Set : Sets.Set;
         begin
            for I in A.Items'Range loop
               declare
                  Item : Internal_Unit renames A.Items (I);
               begin
                  if Set.Contains (Item) then
                     Duplicates (I) := True;
                  else
                     Set.Insert (Item);
                  end if;
               end;
            end loop;
            Unique_Elements := Natural (Set.Length);
         end;
         --  Step 2: create the result
         declare
            Next   : Positive := 1;
            Result : constant Internal_Unit_Array_Access :=
               Create_Internal_Unit_Array (Unique_Elements);
         begin
            for I in A.Items'Range loop
               declare
                  Item : Internal_Unit renames A.Items (I);
               begin
                  if not Duplicates (I) then
                     Result.Items (Next) := Item;
                     Next := Next + 1;
                  end if;
               end;
            end loop;
            pragma Assert (Next = Result.N + 1);
            return Result;
         end;
      end Make_Unique;
      package Logic_Equation_Vectors is new Langkit_Support.Vectors (Logic_Equation);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Logic_Equation_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Logic_Equation
   is
      function Absolute_Get
        (T : Logic_Equation_Array_Access; Index : Integer)
         return Logic_Equation
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Logic_Equation,
         Sequence_Type => Logic_Equation_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Logic_Equation;
   begin
      if Relative_Get (T, Index, Result) then
            Inc_Ref (Result);
         return Result;
      elsif Or_Null then
         return Null_Logic_Equation;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Logic_Equation_Array_Access) return Logic_Equation_Array_Access is
      Ret : Logic_Equation_Array_Access := Create_Logic_Equation_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
         for Item of Ret.Items loop
            Inc_Ref (Item);
         end loop;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Logic_Equation_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Logic_Equation_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Logic_Equation_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
            for Item of T.Items loop
               Dec_Ref (Item);
            end loop;
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Logic_Equation_Array (Items_Count : Natural) return Logic_Equation_Array_Access
   is (if Items_Count = 0
       then No_Logic_Equation_Array_Type
       else new Logic_Equation_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Logic_Equation_Array
     (Items : Internal_Logic_Equation_Array) return Logic_Equation_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Logic_Equation_Array_Type;
      end if;
         for El of Items loop
            Inc_Ref (El);
         end loop;
      return new Logic_Equation_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Logic_Equation_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Logic_Equation_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Symbol_Type_Vectors is new Langkit_Support.Vectors (Symbol_Type);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Symbol_Type_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Symbol_Type
   is
      function Absolute_Get
        (T : Symbol_Type_Array_Access; Index : Integer)
         return Symbol_Type
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Symbol_Type,
         Sequence_Type => Symbol_Type_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Symbol_Type;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return null;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Symbol_Type_Array_Access) return Symbol_Type_Array_Access is
      Ret : Symbol_Type_Array_Access := Create_Symbol_Type_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Symbol_Type_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Symbol_Type_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Symbol_Type_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Symbol_Type_Array (Items_Count : Natural) return Symbol_Type_Array_Access
   is (if Items_Count = 0
       then No_Symbol_Type_Array_Type
       else new Symbol_Type_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Symbol_Type_Array
     (Items : Internal_Symbol_Type_Array) return Symbol_Type_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Symbol_Type_Array_Type;
      end if;
      return new Symbol_Type_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Symbol_Type_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Symbol_Type_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
   ---------
   -- Get --
   ---------
   function Get
     (T       : Symbol_Type_Array_Access_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Symbol_Type_Array_Access
   is
      function Absolute_Get
        (T : Symbol_Type_Array_Access_Array_Access; Index : Integer)
         return Symbol_Type_Array_Access
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Symbol_Type_Array_Access,
         Sequence_Type => Symbol_Type_Array_Access_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Symbol_Type_Array_Access;
   begin
      if Relative_Get (T, Index, Result) then
            Inc_Ref (Result);
         return Result;
      elsif Or_Null then
         return No_Symbol_Type_Array_Type;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Symbol_Type_Array_Access_Array_Access) return Symbol_Type_Array_Access_Array_Access is
      Ret : Symbol_Type_Array_Access_Array_Access := Create_Symbol_Type_Array_Access_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
         for Item of Ret.Items loop
            Inc_Ref (Item);
         end loop;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Symbol_Type_Array_Access_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Symbol_Type_Array_Access_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Symbol_Type_Array_Access_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
            for Item of T.Items loop
               Dec_Ref (Item);
            end loop;
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Symbol_Type_Array_Access_Array (Items_Count : Natural) return Symbol_Type_Array_Access_Array_Access
   is (if Items_Count = 0
       then No_Symbol_Type_Array_Access_Array_Type
       else new Symbol_Type_Array_Access_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Symbol_Type_Array_Access_Array
     (Items : Internal_Symbol_Type_Array_Access_Array) return Symbol_Type_Array_Access_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Symbol_Type_Array_Access_Array_Type;
      end if;
         for El of Items loop
            Inc_Ref (El);
         end loop;
      return new Symbol_Type_Array_Access_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Symbol_Type_Array_Access_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               not Equivalent (L.Items (I), R.Items (I))
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Symbol_Type_Array_Access_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
   ---------
   -- "<" --
   ---------
   function "<" (Left, Right : Internal_Unit) return Boolean is
   begin
      return Left.Filename < Right.Filename;
   end "<";
function Hash (Key : Mmz_Key_Item) return Hash_Type;
function Equivalent (L, R : Mmz_Key_Item) return Boolean;
procedure Destroy (Key : in out Mmz_Key_Array_Access);
----------------
-- Equivalent --
----------------
function Equivalent (L, R : Mmz_Key_Item) return Boolean is
begin
   if L.Kind /= R.Kind then
      return False;
   end if;
   case L.Kind is
         when Mmz_Bare_Ada_Node =>
               return L.As_Bare_Ada_Node = R.As_Bare_Ada_Node;
         when Mmz_Bare_Base_Aggregate =>
               return L.As_Bare_Base_Aggregate = R.As_Bare_Base_Aggregate;
         when Mmz_Bare_Base_Id =>
               return L.As_Bare_Base_Id = R.As_Bare_Base_Id;
         when Mmz_Bare_Base_Subp_Spec =>
               return L.As_Bare_Base_Subp_Spec = R.As_Bare_Base_Subp_Spec;
         when Mmz_Bare_Base_Type_Decl =>
               return L.As_Bare_Base_Type_Decl = R.As_Bare_Base_Type_Decl;
         when Mmz_Bare_Basic_Decl =>
               return L.As_Bare_Basic_Decl = R.As_Bare_Basic_Decl;
         when Mmz_Bare_Body_Node =>
               return L.As_Bare_Body_Node = R.As_Bare_Body_Node;
         when Mmz_Bare_Classwide_Type_Decl =>
               return L.As_Bare_Classwide_Type_Decl = R.As_Bare_Classwide_Type_Decl;
         when Mmz_Bare_Compilation_Unit =>
               return L.As_Bare_Compilation_Unit = R.As_Bare_Compilation_Unit;
         when Mmz_Bare_Declarative_Part =>
               return L.As_Bare_Declarative_Part = R.As_Bare_Declarative_Part;
         when Mmz_Bare_Defining_Name =>
               return L.As_Bare_Defining_Name = R.As_Bare_Defining_Name;
         when Mmz_Bare_End_Name =>
               return L.As_Bare_End_Name = R.As_Bare_End_Name;
         when Mmz_Bare_Enum_Literal_Decl =>
               return L.As_Bare_Enum_Literal_Decl = R.As_Bare_Enum_Literal_Decl;
         when Mmz_Bare_Expr =>
               return L.As_Bare_Expr = R.As_Bare_Expr;
         when Mmz_Bare_For_Loop_Spec =>
               return L.As_Bare_For_Loop_Spec = R.As_Bare_For_Loop_Spec;
         when Mmz_Bare_For_Loop_Var_Decl =>
               return L.As_Bare_For_Loop_Var_Decl = R.As_Bare_For_Loop_Var_Decl;
         when Mmz_Bare_Name =>
               return L.As_Bare_Name = R.As_Bare_Name;
         when Mmz_Bare_Type_Decl =>
               return L.As_Bare_Type_Decl = R.As_Bare_Type_Decl;
         when Mmz_Bare_Type_Expr =>
               return L.As_Bare_Type_Expr = R.As_Bare_Type_Expr;
         when Mmz_Boolean =>
               return L.As_Boolean = R.As_Boolean;
         when Mmz_Env_Rebindings =>
               return L.As_Env_Rebindings = R.As_Env_Rebindings;
         when Mmz_Integer =>
               return L.As_Integer = R.As_Integer;
         when Mmz_Internal_Entity_Info =>
               return L.As_Internal_Entity_Info = R.As_Internal_Entity_Info;
         when Mmz_Internal_Entity_Type_Expr =>
               return L.As_Internal_Entity_Type_Expr = R.As_Internal_Entity_Type_Expr;
         when Mmz_Internal_Metadata =>
               return L.As_Internal_Metadata = R.As_Internal_Metadata;
         when Mmz_Lexical_Env =>
               return Equivalent (L.As_Lexical_Env, R.As_Lexical_Env);
         when Mmz_Symbol_Type =>
               return L.As_Symbol_Type = R.As_Symbol_Type;
   end case;
end Equivalent;
----------
-- Hash --
----------
function Hash (Key : Mmz_Key_Item) return Hash_Type is
begin
   case Key.Kind is
         when Mmz_Bare_Ada_Node =>
            return Hash (Key.As_Bare_Ada_Node);
         when Mmz_Bare_Base_Aggregate =>
            return Hash (Key.As_Bare_Base_Aggregate);
         when Mmz_Bare_Base_Id =>
            return Hash (Key.As_Bare_Base_Id);
         when Mmz_Bare_Base_Subp_Spec =>
            return Hash (Key.As_Bare_Base_Subp_Spec);
         when Mmz_Bare_Base_Type_Decl =>
            return Hash (Key.As_Bare_Base_Type_Decl);
         when Mmz_Bare_Basic_Decl =>
            return Hash (Key.As_Bare_Basic_Decl);
         when Mmz_Bare_Body_Node =>
            return Hash (Key.As_Bare_Body_Node);
         when Mmz_Bare_Classwide_Type_Decl =>
            return Hash (Key.As_Bare_Classwide_Type_Decl);
         when Mmz_Bare_Compilation_Unit =>
            return Hash (Key.As_Bare_Compilation_Unit);
         when Mmz_Bare_Declarative_Part =>
            return Hash (Key.As_Bare_Declarative_Part);
         when Mmz_Bare_Defining_Name =>
            return Hash (Key.As_Bare_Defining_Name);
         when Mmz_Bare_End_Name =>
            return Hash (Key.As_Bare_End_Name);
         when Mmz_Bare_Enum_Literal_Decl =>
            return Hash (Key.As_Bare_Enum_Literal_Decl);
         when Mmz_Bare_Expr =>
            return Hash (Key.As_Bare_Expr);
         when Mmz_Bare_For_Loop_Spec =>
            return Hash (Key.As_Bare_For_Loop_Spec);
         when Mmz_Bare_For_Loop_Var_Decl =>
            return Hash (Key.As_Bare_For_Loop_Var_Decl);
         when Mmz_Bare_Name =>
            return Hash (Key.As_Bare_Name);
         when Mmz_Bare_Type_Decl =>
            return Hash (Key.As_Bare_Type_Decl);
         when Mmz_Bare_Type_Expr =>
            return Hash (Key.As_Bare_Type_Expr);
         when Mmz_Boolean =>
            return Hash (Key.As_Boolean);
         when Mmz_Env_Rebindings =>
            return Hash (Key.As_Env_Rebindings);
         when Mmz_Integer =>
            return Hash (Key.As_Integer);
         when Mmz_Internal_Entity_Info =>
            return Hash (Key.As_Internal_Entity_Info);
         when Mmz_Internal_Entity_Type_Expr =>
            return Hash (Key.As_Internal_Entity_Type_Expr);
         when Mmz_Internal_Metadata =>
            return Hash (Key.As_Internal_Metadata);
         when Mmz_Lexical_Env =>
            return Hash (Key.As_Lexical_Env);
         when Mmz_Symbol_Type =>
            return Hash (Key.As_Symbol_Type);
   end case;
end Hash;
----------
-- Hash --
----------
function Hash (Key : Mmz_Key) return Hash_Type is
   Result : Hash_Type := Mmz_Property'Pos (Key.Property);
begin
   for K of Key.Items.all loop
      Result := Combine (Result, Hash (K));
   end loop;
   return Result;
end Hash;
----------------
-- Equivalent --
----------------
function Equivalent (L, R : Mmz_Key) return Boolean is
   L_Items : Mmz_Key_Array renames L.Items.all;
   R_Items : Mmz_Key_Array renames R.Items.all;
begin
   if L.Property /= R.Property or else L_Items'Length /= R_Items'Length then
      return False;
   end if;
   for I in L_Items'Range loop
      if not Equivalent (L_Items (I), R_Items (I)) then
         return False;
      end if;
   end loop;
   return True;
end Equivalent;
-------------
-- Destroy --
-------------
procedure Destroy (Map : in out Memoization_Maps.Map) is
   use Memoization_Maps;
   --  We need keys and values to be valid when clearing the memoization map,
   --  but on the other hand we need to free keys and values as well. To
   --  achieve both goals, we first copy key and values into arrays, then we
   --  clear the map, and then we free keys/values in the arrays. Allocate both
   --  arrays on the heap to avoid stack overflow, as they can be quite big.
   Length : constant Natural := Natural (Map.Length);
   type Key_Array is array (1 .. Length) of Mmz_Key_Array_Access;
   type Key_Array_Access is access Key_Array;
   procedure Free is new Ada.Unchecked_Deallocation
     (Key_Array, Key_Array_Access);
   type Value_Array is array (1 .. Length) of Mmz_Value;
   type Value_Array_Access is access Value_Array;
   procedure Free is new Ada.Unchecked_Deallocation
     (Value_Array, Value_Array_Access);
   Keys   : Key_Array_Access := new Key_Array;
   Values : Value_Array_Access := new Value_Array;
   I      : Positive := 1;
begin
   for Cur in Map.Iterate loop
      Keys (I) := Key (Cur).Items;
      Values (I) := Element (Cur);
      I := I + 1;
   end loop;
   Map.Clear;
   for K_Array of Keys.all loop
      Destroy (K_Array);
   end loop;
      for V of Values.all loop
         case V.Kind is
               when Mmz_Internal_Entity_Array_Access =>
                  Dec_Ref (V.As_Internal_Entity_Array_Access);
               when Mmz_Internal_Entity_Base_Formal_Param_Decl_Array_Access =>
                  Dec_Ref (V.As_Internal_Entity_Base_Formal_Param_Decl_Array_Access);
               when Mmz_Internal_Entity_Base_Type_Decl_Array_Access =>
                  Dec_Ref (V.As_Internal_Entity_Base_Type_Decl_Array_Access);
               when Mmz_Internal_Entity_Basic_Decl_Array_Access =>
                  Dec_Ref (V.As_Internal_Entity_Basic_Decl_Array_Access);
               when Mmz_Internal_Entity_Compilation_Unit_Array_Access =>
                  Dec_Ref (V.As_Internal_Entity_Compilation_Unit_Array_Access);
               when Mmz_Internal_Param_Match_Array_Access =>
                  Dec_Ref (V.As_Internal_Param_Match_Array_Access);
               when Mmz_Lexical_Env =>
                  Dec_Ref (V.As_Lexical_Env);
            when others => null;
         end case;
      end loop;
   Free (Keys);
   Free (Values);
end Destroy;
-------------
-- Destroy --
-------------
procedure Destroy (Key : in out Mmz_Key_Array_Access) is
   procedure Free is new Ada.Unchecked_Deallocation
     (Mmz_Key_Array, Mmz_Key_Array_Access);
begin
      for K of Key.all loop
         case K.Kind is
               when Mmz_Lexical_Env =>
                  Dec_Ref (K.As_Lexical_Env);
            when others => null;
         end case;
      end loop;
   Free (Key);
end Destroy;
-------------------------
-- Find_Memoized_Value --
-------------------------
function Find_Memoized_Value
  (Unit       : Internal_Unit;
   Handle     : out Memoization_Handle;
   Value      : out Mmz_Value;
   Create_Key : access function return Mmz_Key) return Boolean
is
   Inserted : Boolean;
begin
   --  Make sure that we don't lookup stale caches
   Reset_Caches (Unit);
   --  Initialize handle: create the key and create a cursor pointing to an
   --  existing entry.
   Handle.Key := Create_Key.all;
   Handle.Cache_Version := Unit.Cache_Version;
   Value := (Kind => Mmz_Evaluating);
   Unit.Memoization_Map.Insert (Handle.Key, Value, Handle.Cur, Inserted);
   --  No existing entry yet? The above just created one. Otherwise, destroy
   --  our key and reuse the existing entry's.
   if not Inserted then
      Destroy (Handle.Key.Items);
      Handle.Key := Memoization_Maps.Key (Handle.Cur);
      Value := Memoization_Maps.Element (Handle.Cur);
   end if;
   return not Inserted;
end Find_Memoized_Value;
------------------------
-- Add_Memoized_Value --
------------------------
procedure Add_Memoized_Value
  (Unit       : Internal_Unit;
   Handle     : in out Memoization_Handle;
   Value      : Mmz_Value) is
begin
   --  If Handle was created using a memoization map that has been since then
   --  reset, do nothing: the result can be partly stale due to the event that
   --  triggered the memoization tables reset.
   if Handle.Cache_Version < Unit.Cache_Version then
      return;
   end if;
   Unit.Memoization_Map.Replace_Element (Handle.Cur, Value);
end Add_Memoized_Value;
   -------------------
   -- Solve_Wrapper --
   -------------------
   function Solve_Wrapper
     (R            : Relation;
      Context_Node : Bare_Ada_Node) return Boolean is
   begin
      if Context_Node /= null and then Langkit_Support.Adalog.Debug.Debug then
         Assign_Names_To_Logic_Vars (Context_Node);
      end if;
      begin
         return Solve (R, Context_Node.Unit.Context.Logic_Resolution_Timeout);
      exception
         when Langkit_Support.Adalog.Early_Binding_Error =>
            raise Property_Error with "invalid equation for logic resolution";
         when Langkit_Support.Adalog.Timeout_Error =>
            raise Property_Error with "logic resolution timed out";
      end;
   end Solve_Wrapper;
   -------------
   -- Destroy --
   -------------
   procedure Destroy (Env : in out Lexical_Env_Access) is
      Mutable_Env : Lexical_Env := (Env, 0, Env.Kind, No_Analysis_Unit, 0);
   begin
      Destroy (Mutable_Env);
      Env := null;
   end Destroy;
   ----------------
   -- Initialize --
   ----------------
   procedure Initialize
     (Self              : Bare_Ada_Node;
      Kind              : Ada_Node_Kind_Type;
      Unit              : Internal_Unit;
      Token_Start_Index : Token_Index;
      Token_End_Index   : Token_Index;
      Parent            : Bare_Ada_Node := null;
      Self_Env          : Lexical_Env := AST_Envs.Empty_Env) is
   begin
      pragma Unreferenced (Kind);
      Self.Parent := Parent;
      Self.Unit := Unit;
      Self.Token_Start_Index := Token_Start_Index;
      Self.Token_End_Index := Token_End_Index;
      Self.Self_Env := Self_Env;
      Self.Last_Attempted_Child := -1;
   end Initialize;
   --------------------
   -- Use_Direct_Env --
   --------------------
   procedure Use_Direct_Env (State : in out PLE_Node_State; Env : Lexical_Env)
   is
   begin
      State.Current_Env := Env;
      State.Current_NED := null;
   end Use_Direct_Env;
   -------------------
   -- Use_Named_Env --
   -------------------
   procedure Use_Named_Env
     (State   : in out PLE_Node_State;
      Context : Internal_Context;
      Name    : Env_Name) is
   begin
      State.Current_NED := Get_Named_Env_Descriptor (Context, Name);
      State.Current_Env := State.Current_NED.Env_With_Precedence;
   end Use_Named_Env;
   ---------------------
   -- Set_Initial_Env --
   ---------------------
   procedure Set_Initial_Env
     (Self     : Bare_Ada_Node;
      State    : in out PLE_Node_State;
      Name     : in out Symbol_Type_Array_Access;
      Resolver : Lexical_Env_Resolver) is
   begin
      --  An empty name is the way for the expression to say to fallback on the
      --  direct initial environment computation.
      if Name /= null and then Name.N > 0 then
         declare
            Ctx : constant Internal_Context := Self.Unit.Context;
            N   : constant Env_Name := Create_Env_Name (Ctx, Name);
         begin
            Dec_Ref (Name);
            Use_Named_Env (State, Ctx, N);
         end;
      else
         --  The call to Resolver (which calls a property) can raise an
         --  exception, so we must call Dec_Ref before to avoid a memory leak
         --  in that case.
         Dec_Ref (Name);
         Use_Direct_Env
           (State,
            Resolver ((Node => Self, Info => No_Entity_Info)));
      end if;
   end Set_Initial_Env;
   ----------------
   -- Add_To_Env --
   ----------------
   procedure Add_To_Env
     (Self         : Bare_Ada_Node;
      Mapping      : Internal_Env_Assoc;
      State        : PLE_Node_State;
      Resolver     : Entity_Resolver;
      DSL_Location : String)
   is
      Root_Scope : Lexical_Env renames Self.Unit.Context.Root_Scope;
      MD         : Internal_Metadata renames Mapping.Metadata;
      Dest_Env : constant Lexical_Env :=
        (if Mapping.Dest_Env = Empty_Env
         then State.Current_Env
         else Mapping.Dest_Env);
   begin
      if Mapping = No_Env_Assoc then
         return;
      end if;
      if Mapping.Val.Unit /= Self.Unit then
         raise Property_Error with "Cannot add_to_env an AST node that comes"
                                   & " from another analysis unit";
      end if;
         --  Make sure metadata does not contain any foreign node
         if (MD.Primitive /= null and then MD.Primitive.Unit /= Self.Unit) or else (MD.Primitive_Real_Type /= null and then MD.Primitive_Real_Type.Unit /= Self.Unit)
         then
            raise Property_Error
               with "Cannot add metadata that contains foreign nodes";
         end if;
      if Dest_Env.Kind /= Primary then
         raise Property_Error with
            "Cannot add elements to a non-primary lexical env";
      elsif (Dest_Env.Env.Node = null
             or else Dest_Env.Env.Node.Unit /= Self.Unit)
            and then Is_Synthetic (Mapping.Val)
      then
         raise Property_Error with
            "Cannot add a synthetic node to a lexical env from another"
            & " analysis unit";
      end if;
      --  If requested, reject foreign destination environments. Note that this
      --  detects only explicit destination environments: foreign initial ones
      --  are already detected in SetInitialEnv actions.
      if DSL_Location'Length > 0
         and then Mapping.Dest_Env.Env.Node /= null
         and then Mapping.Dest_Env.Env.Node.Unit /= Self.Unit
      then
         raise Property_Error with
            "unsound foreign environment in AddToEnv (" & DSL_Location & ")";
      end if;
      --  Add the element to the environment. Note that this does nothing if
      --  Dest_Env is Empty_Env.
      Add (Self     => Dest_Env,
           Key      => Mapping.Key,
           Value    => Mapping.Val,
           MD       => MD,
           Resolver => Resolver);
      --  If we're adding the element to an environment by env name, we must
      --  register this association in two places: in the target named env
      --  entry, and in Mapping.Val's unit.
      if State.Current_NED /= null and then Mapping.Dest_Env = Empty_Env then
         declare
            use NED_Assoc_Maps;
            FN    : Map renames State.Current_NED.Foreign_Nodes;
            Dummy : Boolean;
            Cur   : Cursor;
         begin
            FN.Insert (Key      => Mapping.Key,
                       New_Item => Internal_Map_Node_Vectors.Empty_Vector,
                       Position => Cur,
                       Inserted => Dummy);
            declare
               V : Internal_Map_Node_Vectors.Vector renames
                  FN.Reference (Cur);
            begin
               V.Append ((Mapping.Val, MD, Resolver));
            end;
         end;
         Mapping.Val.Unit.Exiled_Entries_In_NED.Append
           ((State.Current_NED, Mapping.Key, Mapping.Val));
      --  Otherwise, if we're adding the element to an environment that belongs
      --  to a different unit, then:
      elsif Dest_Env /= Empty_Env
            and then (Dest_Env = Root_Scope
                      or else Dest_Env.Env.Node.Unit /= Self.Unit)
      then
         --  Add the environment, the key, and the value to the list of entries
         --  contained in other units, so we can remove them when reparsing
         --  Val's unit.
         Mapping.Val.Unit.Exiled_Entries.Append
           ((Dest_Env, Mapping.Key, Mapping.Val));
         if Dest_Env /= Root_Scope then
            --  Add Val to the list of foreign nodes that Dest_Env's unit
            --  contains, so that when that unit is reparsed, we can call
            --  Add_To_Env again on those nodes.
            Dest_Env.Env.Node.Unit.Foreign_Nodes.Append
              ((Mapping.Val, Self.Unit));
         end if;
      end if;
   end Add_To_Env;
   -------------
   -- Ref_Env --
   -------------
   procedure Ref_Env
     (Self                : Bare_Ada_Node;
      Dest_Env            : Lexical_Env;
      Ref_Env_Nodes       : in out Bare_Ada_Node_Array_Access;
      Resolver            : Lexical_Env_Resolver;
      Kind                : Ref_Kind;
      Cats                : Ref_Categories;
      Shed_Rebindings     : Boolean) is
   begin
      for N of Ref_Env_Nodes.Items loop
         if N /= null then
            if N.Unit /= Self.Unit then
               raise Property_Error with
                  "attempt to add a referenced environment to a foreign unit";
            end if;
            Reference (Dest_Env, N, Resolver, Kind, Cats, Shed_Rebindings);
         end if;
      end loop;
      Dec_Ref (Ref_Env_Nodes);
   end Ref_Env;
   -------------
   -- Add_Env --
   -------------
   procedure Add_Env
     (Self              : Bare_Ada_Node;
      State             : in out PLE_Node_State;
      No_Parent         : Boolean;
      Transitive_Parent : Boolean;
      Resolver          : Lexical_Env_Resolver;
      Names             : in out Symbol_Type_Array_Access_Array_Access)
   is
      Parent_From_Name : constant Boolean := State.Current_NED /= null;
      --  Does the parent environment comes from a named environment lookup?
      Parent_Foreign : constant Boolean :=
         State.Current_Env.Env.Node /= null
         and then State.Current_Env.Env.Node.Unit /= Self.Unit;
      --  Determine how to get the parent of this new environment:
      --
      --  (1) no parent if requested;
      --  (2) the current environment as the static parent if it comes from a
      --      named env lookup or if it is not foreign;
      --  (3) a dynamic parent in all other cases (the current environment is
      --      foreign and not fetched as a named environment.
      Parent_Getter : constant Env_Getter :=
        (if No_Parent
         then AST_Envs.No_Env_Getter
         elsif Parent_From_Name or else not Parent_Foreign
         then AST_Envs.Simple_Env_Getter (State.Current_Env)
         else AST_Envs.Dyn_Env_Getter (Resolver, Self));
   begin
      --  Create the environment itself
      Self.Self_Env := AST_Envs.Create_Lexical_Env
        (Parent            => Parent_Getter,
         Node              => Self,
         Transitive_Parent => Transitive_Parent,
         Owner             => Self.Unit);
      Register_Destroyable (Self.Unit, Self.Self_Env.Env);
      --  If the parent of this new environment comes from a named environment
      --  lookup, register this new environment so that its parent is updated
      --  when the precence for this named environment changes.
      if Parent_From_Name then
         declare
            NED : constant Named_Env_Descriptor_Access := State.Current_NED;
         begin
            Self.Unit.Exiled_Envs.Append ((NED, Self.Self_Env));
            NED.Foreign_Envs.Insert (Self, Self.Self_Env);
         end;
      end if;
      --  From now on, the current environment is Self.Self_Env, with a direct
      --  access to it. It does not go through the env naming scheme, since
      --  only this node and its children (i.e. non-foreign nodes) will access
      --  it as a "current" environment during PLE.
      Use_Direct_Env (State, Self.Self_Env);
      --  Register the environment we just created on all the requested names
      if Names /= null then
         declare
            Context   : constant Internal_Context := Self.Unit.Context;
            Env       : constant Lexical_Env := Self.Self_Env;
            NENU      : NED_Maps.Map renames
               State.Unit_State.Named_Envs_Needing_Update;
            Env_Names : array (Names.Items'Range) of Env_Name;
         begin
            --  Turn symbols into env names and free the DSL array
            for I in Env_Names'Range loop
               Env_Names (I) := Create_Env_Name (Context, Names.Items (I));
            end loop;
            Dec_Ref (Names);
            --  Do the registration
            for N of Env_Names loop
               Register_Named_Env (Context, N, Env, NENU);
            end loop;
         end;
      end if;
   end Add_Env;
   ---------------------
   -- Pre_Env_Actions --
   ---------------------
   procedure Pre_Env_Actions
     (Self            : Bare_Ada_Node;
      State           : in out PLE_Node_State;
      Add_To_Env_Only : Boolean := False) is
   begin
   case Self.Kind is
            when Ada_Use_Type_Clause =>
            null;
            when Ada_Use_Package_Clause =>
            Use_Package_Clause_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Access_To_Subp_Def =>
            Access_To_Subp_Def_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Named_Stmt =>
            Named_Stmt_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Extended_Return_Stmt =>
            Extended_Return_Stmt_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Begin_Block .. Ada_Decl_Block =>
            Block_Stmt_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_For_Loop_Stmt =>
            For_Loop_Stmt_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Accept_Stmt .. Ada_Accept_Stmt_With_Stmts =>
            Accept_Stmt_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Decl_Expr =>
            Decl_Expr_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Private_Part =>
            Private_Part_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Compilation_Unit =>
            Compilation_Unit_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Single_Task_Decl =>
            Single_Task_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Single_Protected_Decl =>
            Single_Protected_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Package_Renaming_Decl =>
            Package_Renaming_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Object_Decl .. Ada_Extended_Return_Stmt_Object_Decl =>
            Object_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Number_Decl =>
            Number_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Label_Decl =>
            Label_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Generic_Subp_Renaming_Decl =>
            Generic_Subp_Renaming_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Generic_Package_Renaming_Decl =>
            Generic_Package_Renaming_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Generic_Subp_Instantiation =>
            Generic_Subp_Instantiation_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Generic_Package_Instantiation =>
            Generic_Package_Instantiation_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Generic_Subp_Decl =>
            Generic_Subp_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Generic_Package_Decl =>
            Generic_Package_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_For_Loop_Var_Decl =>
            For_Loop_Var_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Exception_Handler =>
            Exception_Handler_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Exception_Decl =>
            Exception_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Entry_Index_Spec =>
            Entry_Index_Spec_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Task_Body =>
            Task_Body_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Protected_Body =>
            Protected_Body_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Package_Body =>
            Package_Body_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Entry_Body =>
            Entry_Body_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Task_Body_Stub =>
            Task_Body_Stub_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Subp_Body_Stub =>
            Subp_Body_Stub_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Protected_Body_Stub =>
            Protected_Body_Stub_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Package_Body_Stub =>
            Package_Body_Stub_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Expr_Function .. Ada_Subp_Renaming_Decl =>
            Base_Subp_Body_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Generic_Subp_Internal =>
            Generic_Subp_Internal_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Enum_Literal_Decl =>
            Enum_Literal_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Entry_Decl =>
            Entry_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Abstract_Subp_Decl .. Ada_Subp_Decl =>
            Basic_Subp_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Anonymous_Type_Decl .. Ada_Synth_Anonymous_Type_Decl =>
            null;
            when Ada_Type_Decl =>
            Type_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Single_Task_Type_Decl =>
            Single_Task_Type_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Task_Type_Decl =>
            Task_Type_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Protected_Type_Decl =>
            Protected_Type_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Incomplete_Type_Decl .. Ada_Incomplete_Tagged_Type_Decl =>
            Incomplete_Type_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Classwide_Type_Decl =>
            null;
            when Ada_Discrete_Base_Subtype_Decl .. Ada_Subtype_Decl =>
            Base_Type_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Package_Decl =>
            Package_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Generic_Package_Internal =>
            Generic_Package_Internal_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Param_Spec =>
            Param_Spec_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Discriminant_Spec =>
            Discriminant_Spec_Pre_Env_Actions (Self, State, Add_To_Env_Only);
            when Ada_Component_Decl =>
            Component_Decl_Pre_Env_Actions (Self, State, Add_To_Env_Only);
      when others =>  null; 
   end case;
   end Pre_Env_Actions;
   ----------------------
   -- Post_Env_Actions --
   ----------------------
   procedure Post_Env_Actions
     (Self : Bare_Ada_Node; State : in out PLE_Node_State) is
   begin
   case Self.Kind is
            when Ada_Use_Type_Clause =>
            Use_Type_Clause_Post_Env_Actions (Self, State);
            when Ada_Use_Package_Clause =>
            null;
            when Ada_Access_To_Subp_Def =>
            null;
            when Ada_Named_Stmt =>
            null;
            when Ada_Extended_Return_Stmt =>
            null;
            when Ada_Begin_Block .. Ada_Decl_Block =>
            null;
            when Ada_For_Loop_Stmt =>
            null;
            when Ada_Accept_Stmt .. Ada_Accept_Stmt_With_Stmts =>
            null;
            when Ada_Decl_Expr =>
            null;
            when Ada_Private_Part =>
            null;
            when Ada_Compilation_Unit =>
            null;
            when Ada_Single_Task_Decl =>
            null;
            when Ada_Single_Protected_Decl =>
            null;
            when Ada_Package_Renaming_Decl =>
            null;
            when Ada_Object_Decl .. Ada_Extended_Return_Stmt_Object_Decl =>
            null;
            when Ada_Number_Decl =>
            null;
            when Ada_Label_Decl =>
            null;
            when Ada_Generic_Subp_Renaming_Decl =>
            null;
            when Ada_Generic_Package_Renaming_Decl =>
            null;
            when Ada_Generic_Subp_Instantiation =>
            Generic_Subp_Instantiation_Post_Env_Actions (Self, State);
            when Ada_Generic_Package_Instantiation =>
            Generic_Package_Instantiation_Post_Env_Actions (Self, State);
            when Ada_Generic_Subp_Decl =>
            null;
            when Ada_Generic_Package_Decl =>
            null;
            when Ada_For_Loop_Var_Decl =>
            null;
            when Ada_Exception_Handler =>
            null;
            when Ada_Exception_Decl =>
            null;
            when Ada_Entry_Index_Spec =>
            null;
            when Ada_Task_Body =>
            null;
            when Ada_Protected_Body =>
            null;
            when Ada_Package_Body =>
            null;
            when Ada_Entry_Body =>
            null;
            when Ada_Task_Body_Stub =>
            null;
            when Ada_Subp_Body_Stub =>
            null;
            when Ada_Protected_Body_Stub =>
            null;
            when Ada_Package_Body_Stub =>
            null;
            when Ada_Expr_Function .. Ada_Subp_Renaming_Decl =>
            Base_Subp_Body_Post_Env_Actions (Self, State);
            when Ada_Generic_Subp_Internal =>
            null;
            when Ada_Enum_Literal_Decl =>
            null;
            when Ada_Entry_Decl =>
            null;
            when Ada_Abstract_Subp_Decl .. Ada_Subp_Decl =>
            Basic_Subp_Decl_Post_Env_Actions (Self, State);
            when Ada_Anonymous_Type_Decl .. Ada_Synth_Anonymous_Type_Decl =>
            null;
            when Ada_Type_Decl =>
            Type_Decl_Post_Env_Actions (Self, State);
            when Ada_Single_Task_Type_Decl =>
            null;
            when Ada_Task_Type_Decl =>
            null;
            when Ada_Protected_Type_Decl =>
            null;
            when Ada_Incomplete_Type_Decl .. Ada_Incomplete_Tagged_Type_Decl =>
            null;
            when Ada_Classwide_Type_Decl =>
            null;
            when Ada_Discrete_Base_Subtype_Decl .. Ada_Subtype_Decl =>
            null;
            when Ada_Package_Decl =>
            null;
            when Ada_Generic_Package_Internal =>
            null;
            when Ada_Param_Spec =>
            null;
            when Ada_Discriminant_Spec =>
            null;
            when Ada_Component_Decl =>
            null;
      when others =>  null; 
   end case;
   end Post_Env_Actions;
   ----------------
   -- Get_Symbol --
   ----------------
   function Get_Symbol
     (Node : Bare_Ada_Node) return Symbol_Type is
   begin
      if Node = null then
         raise Property_Error with "cannot get the symbol of a null node";
      end if;
      return Get_Symbol (Token (Node, Node.Token_Start_Index));
   end Get_Symbol;
   ----------
   -- Text --
   ----------
   function Text
     (Node : Bare_Ada_Node) return Text_Type
   is
   begin
      if Node = null then
         raise Property_Error with "cannot get the text of a null node";
      end if;
      declare
         Start_T : constant Token_Reference :=
            Token (Node, Node.Token_Start_Index);
         End_T   : constant Token_Reference :=
            Token (Node, Node.Token_End_Index);
      begin
         --  No text is associated to synthetic and ghost nodes
         if Is_Synthetic (Node) then
            return "";
         end if;
         if Is_Ghost (Node) then
            return "";
         end if;
         return Text (Start_T, End_T);
      end;
   end Text;
   ---------------------
   -- Is_Visible_From --
   ---------------------
   function Is_Visible_From
     (Referenced_Env, Base_Env : AST_Envs.Lexical_Env) return Boolean is
      Referenced_Node : constant Bare_Ada_Node :=
         Referenced_Env.Env.Node;
      Base_Node       : constant Bare_Ada_Node := Base_Env.Env.Node;
   begin
      if Referenced_Node = null then
         raise Property_Error with
            "referenced environment does not belong to any analysis unit";
      elsif Base_Node = null then
         raise Property_Error with
            "base environment does not belong to any analysis unit";
      end if;
      return Is_Referenced_From (Referenced_Node.Unit, Base_Node.Unit);
   end Is_Visible_From;
   ----------
   -- Unit --
   ----------
   function Unit (Node : Bare_Ada_Node) return Internal_Unit is
   begin
      return Node.Unit;
   end Unit;
      package Lexical_Env_Vectors is new Langkit_Support.Vectors (Lexical_Env);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Lexical_Env_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Lexical_Env
   is
      function Absolute_Get
        (T : Lexical_Env_Array_Access; Index : Integer)
         return Lexical_Env
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Lexical_Env,
         Sequence_Type => Lexical_Env_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Lexical_Env;
   begin
      if Relative_Get (T, Index, Result) then
            Inc_Ref (Result);
         return Result;
      elsif Or_Null then
         return Empty_Env;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Lexical_Env_Array_Access) return Lexical_Env_Array_Access is
      Ret : Lexical_Env_Array_Access := Create_Lexical_Env_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
         for Item of Ret.Items loop
            Inc_Ref (Item);
         end loop;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Lexical_Env_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Lexical_Env_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Lexical_Env_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
            for Item of T.Items loop
               Dec_Ref (Item);
            end loop;
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Lexical_Env_Array (Items_Count : Natural) return Lexical_Env_Array_Access
   is (if Items_Count = 0
       then No_Lexical_Env_Array_Type
       else new Lexical_Env_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Lexical_Env_Array
     (Items : Internal_Lexical_Env_Array) return Lexical_Env_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Lexical_Env_Array_Type;
      end if;
         for El of Items loop
            Inc_Ref (El);
         end loop;
      return new Lexical_Env_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Lexical_Env_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               not Equivalent (L.Items (I), R.Items (I))
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Lexical_Env_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
      package Internal_Entity_Vectors is new Langkit_Support.Vectors (Internal_Entity);
   ---------
   -- Get --
   ---------
   function Get
     (T       : Internal_Entity_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity
   is
      function Absolute_Get
        (T : Internal_Entity_Array_Access; Index : Integer)
         return Internal_Entity
      is
        (T.Items (Index + 1)); --  T.Items is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Internal_Entity,
         Sequence_Type => Internal_Entity_Array_Access,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Internal_Entity;
   begin
      if Relative_Get (T, Index, Result) then
         return Result;
      elsif Or_Null then
         return No_Entity;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   ------------
   -- Concat --
   ------------
   function Concat (L, R : Internal_Entity_Array_Access) return Internal_Entity_Array_Access is
      Ret : Internal_Entity_Array_Access := Create_Internal_Entity_Array (Length (L) + Length (R));
   begin
      Ret.Items := L.Items & R.Items;
      return Ret;
   end Concat;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (T : Internal_Entity_Array_Access) is
   begin
      if T.Ref_Count >= 0 then
         T.Ref_Count := T.Ref_Count + 1;
      end if;
   end Inc_Ref;
   ------------
   -- Length --
   ------------
   function Length (T : Internal_Entity_Array_Access) return Natural is (T.N);
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (T : in out Internal_Entity_Array_Access) is
   begin
      if T = null or else T.Ref_Count < 0 then
         return;
      end if;
      if T.Ref_Count = 1 then
         Free (T);
      else
         T.Ref_Count := T.Ref_Count - 1;
         T := null;
      end if;
   end Dec_Ref;
   function Create_Internal_Entity_Array (Items_Count : Natural) return Internal_Entity_Array_Access
   is (if Items_Count = 0
       then No_Internal_Entity_Array_Type
       else new Internal_Entity_Array_Record'(N => Items_Count, Ref_Count => 1, Items => <>));
   function Create_Internal_Entity_Array
     (Items : AST_Envs.Entity_Array) return Internal_Entity_Array_Access
   is (if Items'Length = 0
       then No_Internal_Entity_Array_Type
       else new Internal_Entity_Array_Record'
         (N         => Items'Length,
          Items     => Implementation.Internal_Internal_Entity_Array (Items),
          Ref_Count => 1));
   function Create_Internal_Entity_Array
     (Items : Internal_Internal_Entity_Array) return Internal_Entity_Array_Access is
   begin
      if Items'Length = 0 then
         return No_Internal_Entity_Array_Type;
      end if;
      return new Internal_Entity_Array_Record'
        (N => Items'Length, Ref_Count => 1, Items => Items);
   end;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (L, R : Internal_Entity_Array_Access) return Boolean is
   begin
      if L.N /= R.N then
         return False;
      end if;
      for I in L.Items'Range loop
         if
               L.Items (I) /= R.Items (I)
         then
            return False;
         end if;
      end loop;
      return True;
   end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (A : Internal_Entity_Array_Access) return String is
               Result : Unbounded_String;
            begin
               Append (Result, "[");
               for I in A.Items'Range loop
                  if I > A.Items'First then
                     Append (Result, ", ");
                  end if;
                  Append (Result, Trace_Image (A.Items (I)));
               end loop;
               Append (Result, "]");
               return To_String (Result);
      end Trace_Image;
   function Lookup_Internal
     (Node : Bare_Ada_Node;
      Sloc : Source_Location) return Bare_Ada_Node;
   procedure Lookup_Relative
     (Node       : Bare_Ada_Node;
      Sloc       : Source_Location;
      Position   : out Relative_Position;
      Node_Found : out Bare_Ada_Node);
   --  Implementation helpers for the looking up process
   -----------------
   -- Set_Parents --
   -----------------
   procedure Set_Parents
     (Node, Parent : Bare_Ada_Node)
   is
   begin
      if Node = null then
         return;
      end if;
      Node.Parent := Bare_Ada_Node (Parent);
      for I in 1 .. Children_Count (Node) loop
         Set_Parents (Child (Node, I), Node);
      end loop;
   end Set_Parents;
   -------------
   -- Destroy --
   -------------
   procedure Destroy (Node : Bare_Ada_Node) is
   begin
      if Node = null then
         return;
      end if;
      Reset_Logic_Vars (Node);
      for I in 1 .. Children_Count (Node) loop
         Destroy (Child (Node, I));
      end loop;
   end Destroy;
   -----------
   -- Child --
   -----------
   function Child (Node  : Bare_Ada_Node;
                   Index : Positive) return Bare_Ada_Node
   is
      Result          : Bare_Ada_Node;
      Index_In_Bounds : Boolean;
   begin
      Get_Child (Node, Index, Index_In_Bounds, Result);
      return (if Index_In_Bounds then Result else null);
   end Child;
   --------------
   -- Traverse --
   --------------
   function Traverse
     (Node  : Bare_Ada_Node;
      Visit : access function (Node : Bare_Ada_Node)
              return Visit_Status)
     return Visit_Status
   is
      Status : Visit_Status := Into;
   begin
      if Node /= null then
         Status := Visit (Node);
         --  Skip processing the child nodes if the returned status is Over
         --  or Stop. In the former case the previous call to Visit has taken
         --  care of processing the needed childs, and in the latter case we
         --  must immediately stop processing the tree.
         if Status = Into then
            for I in 1 .. Children_Count (Node) loop
               declare
                  Cur_Child : constant Bare_Ada_Node :=
                     Child (Node, I);
               begin
                  if Cur_Child /= null then
                     Status := Traverse (Cur_Child, Visit);
                     exit when Status /= Into;
                  end if;
               end;
            end loop;
         end if;
      end if;
      if Status = Stop then
         return Stop;
      --  At this stage the Over status has no sense and we just continue
      --  processing the tree.
      else
         return Into;
      end if;
   end Traverse;
   --------------
   -- Traverse --
   --------------
   procedure Traverse
     (Node  : Bare_Ada_Node;
      Visit : access function (Node : Bare_Ada_Node)
                               return Visit_Status)
   is
      Result_Status : Visit_Status;
      pragma Unreferenced (Result_Status);
   begin
      Result_Status := Traverse (Node, Visit);
   end Traverse;
   ------------------------
   -- Traverse_With_Data --
   ------------------------
   function Traverse_With_Data
     (Node  : Bare_Ada_Node;
      Visit : access function (Node : Bare_Ada_Node;
                               Data : in out Data_Type)
                               return Visit_Status;
      Data  : in out Data_Type)
      return Visit_Status
   is
      function Helper (Node : Bare_Ada_Node) return Visit_Status;
      ------------
      -- Helper --
      ------------
      function Helper (Node : Bare_Ada_Node) return Visit_Status is
      begin
         return Visit (Node, Data);
      end Helper;
      Saved_Data : Data_Type;
      Result     : Visit_Status;
   begin
      if Reset_After_Traversal then
         Saved_Data := Data;
      end if;
      Result := Traverse (Node, Helper'Access);
      if Reset_After_Traversal then
         Data := Saved_Data;
      end if;
      return Result;
   end Traverse_With_Data;
   ----------------
   -- Sloc_Range --
   ----------------
   function Sloc_Range
     (Node : Bare_Ada_Node) return Source_Location_Range
   is
      type Token_Anchor is (T_Start, T_End);
      type Token_Pos is record
         Pos    : Token_Index;
         Anchor : Token_Anchor;
      end record;
      TDH                    : Token_Data_Handler renames Node.Unit.TDH;
      Token_Start, Token_End : Token_Pos;
      function Get (Index : Token_Index) return Stored_Token_Data is
        (Get_Token (TDH, Index));
      function Sloc (T : Token_Pos) return Source_Location is
        (if T.Anchor = T_Start
         then Sloc_Start (TDH, Get (T.Pos))
         else Sloc_End (TDH, Get (T.Pos)));
   begin
      if Is_Synthetic (Node) then
         return Sloc_Range (Node.Parent);
      end if;
      if Is_Ghost (Node) then
         Token_Start := (if Node.Token_Start_Index = 1
                         then (1, T_Start)
                         else (Node.Token_Start_Index - 1, T_End));
         Token_End := Token_Start;
      else
         Token_Start := (Node.Token_Start_Index, T_Start);
         Token_End := (Node.Token_End_Index, T_End);
      end if;
      if Snaps_At_Start (Node)
         and then not Is_Ghost (Node)
         and then Token_Start.Pos /= 1
      then
         Token_Start := (Token_Start.Pos - 1, T_End);
      end if;
      if Snaps_At_End (Node) and then Token_End.Pos /= Last_Token (TDH) then
         Token_End := (Token_End.Pos + 1, T_Start);
      end if;
      return Make_Range (Sloc (Token_Start), Sloc (Token_End));
   end Sloc_Range;
   ------------
   -- Lookup --
   ------------
   function Lookup
     (Node : Bare_Ada_Node;
      Sloc : Source_Location) return Bare_Ada_Node
   is
      Position : Relative_Position;
      Result   : Bare_Ada_Node;
   begin
      if Sloc = No_Source_Location then
         return null;
      end if;
      Lookup_Relative
        (Bare_Ada_Node (Node), Sloc, Position, Result);
      return Result;
   end Lookup;
   ---------------------
   -- Lookup_Internal --
   ---------------------
   function Lookup_Internal
     (Node : Bare_Ada_Node;
      Sloc : Source_Location) return Bare_Ada_Node
   is
      --  For this implementation helper (i.e. internal primitive), we can
      --  assume that all lookups fall into this node's sloc range.
      pragma Assert (Compare (Sloc_Range (Node), Sloc) = Inside);
      Children : constant Internal_Bare_Ada_Node_Array :=
         Implementation.Children (Node);
      Pos      : Relative_Position;
      Result   : Bare_Ada_Node;
   begin
      --  Look for a child node that contains Sloc (i.e. return the most
      --  precise result).
      for Child of Children loop
         --  Note that we assume here that child nodes are ordered so that the
         --  first one has a sloc range that is before the sloc range of the
         --  second child node, etc.
         if Child /= null then
            Lookup_Relative (Child, Sloc, Pos, Result);
            case Pos is
               when Before =>
                   --  If this is the first node, Sloc is before it, so we can
                   --  stop here.  Otherwise, Sloc is between the previous
                   --  child node and the next one...  so we can stop here,
                   --  too.
                   return Node;
               when Inside =>
                   return Result;
               when After =>
                   --  Sloc is after the current child node, so see with the
                   --  next one.
                   null;
            end case;
         end if;
      end loop;
      --  If we reach this point, we found no children that covers Sloc, but
      --  Node still covers it (see the assertion).
      return Node;
   end Lookup_Internal;
   -------------
   -- Compare --
   -------------
   function Compare
     (Node : Bare_Ada_Node;
      Sloc : Source_Location) return Relative_Position is
   begin
      return Compare (Sloc_Range (Node), Sloc);
   end Compare;
   ---------------------
   -- Lookup_Relative --
   ---------------------
   procedure Lookup_Relative
     (Node       : Bare_Ada_Node;
      Sloc       : Source_Location;
      Position   : out Relative_Position;
      Node_Found : out Bare_Ada_Node)
   is
      Result : constant Relative_Position :=
        Compare (Node, Sloc);
   begin
      Position := Result;
      Node_Found := (if Result = Inside
                     then Lookup_Internal (Node, Sloc)
                     else null);
   end Lookup_Relative;
   -------------
   -- Compare --
   -------------
   function Compare
     (Left, Right : Bare_Ada_Node;
      Relation    : Comparison_Relation) return Boolean
   is
      LS, RS : Source_Location;
   begin
      if Left = null or else Right = null or else Left.Unit /= Right.Unit then
         raise Property_Error with "invalid node comparison";
      end if;
      LS := Start_Sloc (Sloc_Range (Left));
      RS := Start_Sloc (Sloc_Range (Right));
      return (case Relation is
              when Langkit_Support.Types.Less_Than        => LS < RS,
              when Langkit_Support.Types.Less_Or_Equal    => LS <= RS,
              when Langkit_Support.Types.Greater_Than     => LS > RS,
              when Langkit_Support.Types.Greater_Or_Equal => LS >= RS);
   end Compare;
   --------------
   -- Children --
   --------------
   function Children
     (Node : Bare_Ada_Node) return Internal_Bare_Ada_Node_Array
   is
      First : constant Integer := Bare_Ada_Node_Vectors.Index_Type'First;
      Last  : constant Integer := First + Children_Count (Node) - 1;
   begin
      return A : Internal_Bare_Ada_Node_Array (First .. Last)
      do
         for I in First .. Last loop
            A (I) := Child (Node, I);
         end loop;
      end return;
   end Children;
   function Children
     (Node : Bare_Ada_Node) return Bare_Ada_Node_Array_Access
   is
      C : Internal_Bare_Ada_Node_Array := Children (Node);
   begin
      return Ret : Bare_Ada_Node_Array_Access :=
         Create_Bare_Ada_Node_Array (C'Length)
      do
         Ret.Items := C;
      end return;
   end Children;
   ---------
   -- Get --
   ---------
   function Get
     (Node    : Bare_Ada_List;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Ada_Node
   is
      function Length (Node : Bare_Ada_List) return Natural
      is (Node.Count);
      --  Wrapper around the Length primitive to get the compiler happy for the
      --  the package instantiation below.
      function Absolute_Get
        (L     : Bare_Ada_List;
         Index : Integer) return Bare_Ada_Node
      is (L.Nodes.all (Index + 1));
      --  L.Nodes is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Bare_Ada_Node,
         Sequence_Type => Bare_Ada_List,
         Length        => Length,
         Get           => Absolute_Get);
      Result : Bare_Ada_Node;
   begin
      if Node = null and then Or_Null then
         return null;
      elsif Relative_Get (Node, Index, Result) then
         return Result;
      elsif Or_Null then
         return null;
      else
         raise Property_Error with "out-of-bounds AST list access";
      end if;
   end Get;
   ---------------
   -- PP_Trivia --
   ---------------
   procedure PP_Trivia
     (Node        : Bare_Ada_Node;
      Line_Prefix : String := "")
   is
      Children_Prefix : constant String := Line_Prefix & "|  ";
   begin
      Put_Line (Line_Prefix & Kind_Name (Node));
      for C of Children_And_Trivia (Node) loop
         case C.Kind is
            when Trivia =>
               Put_Line (Children_Prefix & Image (Text (C.Trivia)));
            when Child =>
               PP_Trivia (C.Node, Children_Prefix);
         end case;
      end loop;
   end PP_Trivia;
   --------------------------
   -- Populate_Lexical_Env --
   --------------------------
   function Populate_Lexical_Env (Node : Bare_Ada_Node) return Boolean is
      Context    : constant Internal_Context := Node.Unit.Context;
      Unit_State : aliased PLE_Unit_State := (Named_Envs_Needing_Update => <>);
      Root_State : constant PLE_Node_State :=
        (Unit_State  => Unit_State'Unchecked_Access,
         Current_Env => Context.Root_Scope,
         Current_NED => null);
      function Populate_Internal
        (Node         : Bare_Ada_Node;
         Parent_State : PLE_Node_State) return Boolean;
      --  Do the lexical env population on Node and recurse on its children
      procedure Register_Foreign_Env
        (Node : Bare_Ada_Node; State : PLE_Node_State);
      --  Given a node and its PLE state, register Node.Self_Env as being
      --  initialized through the named environment mechanism, if that's indeed
      --  the case. Do nothing otherwise.
      -----------------------
      -- Populate_Internal --
      -----------------------
      function Populate_Internal
        (Node         : Bare_Ada_Node;
         Parent_State : PLE_Node_State) return Boolean
      is
         Result : Boolean := False;
         State  : PLE_Node_State := Parent_State;
      begin
         if Node = null then
            return Result;
         end if;
         --  By default (i.e. unless env actions add a new env), the
         --  environment we store in Node is the current one.
         Node.Self_Env := State.Current_Env;
         --  Run pre/post actions, and run PLE on children in between. Make
         --  sure we register the potential foreign Node.Self_Env environment
         --  at the end, even when an exception interrupts PLE to keep the
         --  state consistent.
         begin
            Pre_Env_Actions (Node, State);
            if State.Current_Env /= Null_Lexical_Env then
               Node.Self_Env := State.Current_Env;
               Register_Foreign_Env (Node, State);
            end if;
            --  Call recursively on children
            for I in First_Child_Index (Node) .. Last_Child_Index (Node) loop
               Result := Populate_Internal
                 (Child (Node, I), State) or else Result;
            end loop;
            Post_Env_Actions (Node, State);
         exception
            when Exc : Property_Error =>
               GNATCOLL.Traces.Trace
                 (PLE_Errors_Trace, Ada.Exceptions.Exception_Message (Exc));
               Register_Foreign_Env (Node, State);
               return True;
         end;
         return Result;
      end Populate_Internal;
      --------------------------
      -- Register_Foreign_Env --
      --------------------------
      procedure Register_Foreign_Env
        (Node : Bare_Ada_Node; State : PLE_Node_State) is
      begin
         if State.Current_NED /= null then
            State.Current_NED.Nodes_With_Foreign_Env.Insert (Node);
            Node.Unit.Nodes_With_Foreign_Env.Insert (Node, State.Current_NED);
         end if;
      end Register_Foreign_Env;
   begin
      --  This function is meant to be called during an existing PLE pass. If
      --  if is called outside of this context, run the PLE pass on Node's
      --  analysis unit. Likewise, if PLE has not run on the unit that owns
      --  this PLE unit yet, do a full run, which will in the end trigger the
      --  PLE on this PLE unit.
      --
      --  We do this so that as soon as PLE is required on a PLE unit: the
      --  whole unit end up with its lexical environments populated.
      if not Context.In_Populate_Lexical_Env then
         begin
            Populate_Lexical_Env (Node.Unit);
            return False;
         exception
            when Property_Error =>
               return True;
         end;
      end if;
         --  This is intended to be called on the root node only
         if Node.Parent /= null then
            raise Program_Error;
         end if;
      return Result : constant Boolean :=
         Populate_Internal (Node, Root_State)
      do
         Update_Named_Envs (Unit_State.Named_Envs_Needing_Update);
      end return;
   end Populate_Lexical_Env;
   ------------------------------
   -- AST_Envs_Node_Text_Image --
   ------------------------------
   function AST_Envs_Node_Text_Image
     (Node  : Bare_Ada_Node;
      Short : Boolean := True) return Text_Type is
   begin
      if Short then
         return To_Text (Basename (Node.Unit))
           & ":" & To_Text (Image (Start_Sloc (Sloc_Range (Node))));
      else
         return Short_Text_Image (Node);
      end if;
   end AST_Envs_Node_Text_Image;
   -------------------
   -- Is_Rebindable --
   -------------------
   function Is_Rebindable (Node : Bare_Ada_Node) return Boolean is
   begin
         return Node.Kind in Ada_Generic_Package_Decl .. Ada_Generic_Subp_Decl;
   end Is_Rebindable;
   ------------------------
   -- Register_Rebinding --
   ------------------------
   procedure Register_Rebinding
     (Node : Bare_Ada_Node; Rebinding : System.Address)
   is
      pragma Warnings (Off, "possible aliasing problem for type");
      function Convert is new Ada.Unchecked_Conversion
        (System.Address, Env_Rebindings);
      pragma Warnings (Off, "possible aliasing problem for type");
   begin
      Node.Unit.Rebindings.Append (Convert (Rebinding));
   end Register_Rebinding;
   --------------------
   -- Element_Parent --
   --------------------
   function Element_Parent
     (Node : Bare_Ada_Node) return Bare_Ada_Node
   is (Node.Parent);
   ---------------
   -- Node_Unit --
   ---------------
   function Node_Unit (Node : Bare_Ada_Node) return Internal_Unit is
   begin
      return Node.Unit;
   end Node_Unit;
   ----------
   -- Hash --
   ----------
   function Hash (Node : Bare_Ada_Node) return Hash_Type
   is
      function H is new Hash_Access
        (Root_Node_Record, Bare_Ada_Node);
   begin
      return H (Node);
   end Hash;
      function Hash (B : Boolean) return Hash_Type is (Boolean'Pos (B));
      function Hash (I : Integer) return Hash_Type is (Hash_Type'Mod (I));
      function Hash (Info : Internal_Entity_Info) return Hash_Type is
        (Combine (Hash (Info.MD), Hash (Info.Rebindings)));
      ----------
      -- Hash --
      ----------
      function Hash (R : Internal_Entity) return Hash_Type is
      begin
            return Combine
              (Hash (R.Node), Hash (R.Info));
      end Hash;
   ------------------------
   -- Named environments --
   ------------------------
   ---------
   -- Add --
   ---------
   procedure Add
     (Self : in out NED_Assoc_Maps.Map;
      Key  : Symbol_Type;
      Node : AST_Envs.Internal_Map_Node)
   is
      use NED_Assoc_Maps;
      Pos   : Cursor;
      Dummy : Boolean;
   begin
      --  Make sure there is a vector entry for Key
      Self.Insert (Key, Internal_Map_Node_Vectors.Empty_Vector, Pos, Dummy);
      --  Append Node to that vector
      declare
         V : Internal_Map_Node_Vectors.Vector renames Self.Reference (Pos);
      begin
         V.Append (Node);
      end;
   end Add;
   ------------
   -- Remove --
   ------------
   procedure Remove
     (Self : in out NED_Assoc_Maps.Map;
      Key  : Symbol_Type;
      Node : Bare_Ada_Node)
   is
      use NED_Assoc_Maps;
      V : Internal_Map_Node_Vectors.Vector renames Self.Reference (Key);
   begin
      --  Remove the (assumed unique) entry in V whose node is Node. The order
      --  of items in V is not significant, so we can use Pop for efficient
      --  removal. Do the traversal in reverse order for correctness.
      for I in reverse 1 .. V.Length loop
         if V.Get_Access (I).Node = Node then
            V.Pop (I);
            exit;
         end if;
      end loop;
   end Remove;
   ---------------------
   -- Create_Env_Name --
   ---------------------
   function Create_Env_Name
     (Context : Internal_Context;
      Symbols : Symbol_Type_Array_Access) return Env_Name
   is
      use Env_Name_Sets;
      Pos      : Cursor;
      Inserted : Boolean;
      --  Create a valid env name (computing its hash)
      Name : Env_Name := new Env_Name_Record'
        (Size    => Symbols.N,
         Symbols => Env_Name_Internal_Array (Symbols.Items),
         Hash    => Initial_Hash);
   begin
      for S of Name.Symbols loop
         Name.Hash := Combine (Name.Hash, Hash (S));
      end loop;
      --  Try to insert it to Context's set of env names. If already present
      --  (not Inserted), discard it and return the existing one.
      Context.Env_Names.Insert (Name, Pos, Inserted);
      if not Inserted then
         Destroy (Name);
         Name := Element (Pos);
      end if;
      return Name;
   end Create_Env_Name;
   ------------------------------
   -- Get_Named_Env_Descriptor --
   ------------------------------
   function Get_Named_Env_Descriptor
     (Context : Internal_Context;
      Name    : Env_Name) return Named_Env_Descriptor_Access
   is
      use NED_Maps;
      --  Look for an existing entry for Name
      Pos : constant Cursor := Context.Named_Envs.Find (Name);
   begin
      if Has_Element (Pos) then
         return Element (Pos);
      end if;
      --  There is no such entry: create one
      return Result : constant Named_Env_Descriptor_Access :=
         new Named_Env_Descriptor'
           (Name                   => Name,
            Envs                   => <>,
            Env_With_Precedence    => Empty_Env,
            Foreign_Nodes          => <>,
            Foreign_Envs           => <>,
            Nodes_With_Foreign_Env => <>)
      do
         Context.Named_Envs.Insert (Name, Result);
      end return;
   end Get_Named_Env_Descriptor;
   ------------------------
   -- Register_Named_Env --
   ------------------------
   procedure Register_Named_Env
     (Context                   : Internal_Context;
      Name                      : Env_Name;
      Env                       : Lexical_Env;
      Named_Envs_Needing_Update : in out NED_Maps.Map)
   is
      NED_Access : constant Named_Env_Descriptor_Access :=
         Get_Named_Env_Descriptor (Context, Name);
      NED        : Named_Env_Descriptor renames NED_Access.all;
      Node       : constant Bare_Ada_Node := Env.Env.Node;
   begin
      NED.Envs.Insert (Node, Env);
      Node.Unit.Named_Envs.Append ((Name, Env));
      --  If that insertion must change the env that has precedence, signal
      --  that NED requires an update.
      if NED.Envs.First_Element /= NED.Env_With_Precedence then
         Named_Envs_Needing_Update.Include (Name, NED_Access);
      end if;
   end Register_Named_Env;
   ----------------------
   -- Update_Named_Env --
   ----------------------
   procedure Update_Named_Envs (Named_Envs : NED_Maps.Map) is
   begin
      for Cur in Named_Envs.Iterate loop
         declare
            NE      : Named_Env_Descriptor renames NED_Maps.Element (Cur).all;
            New_Env : constant Lexical_Env :=
              (if NE.Envs.Is_Empty
               then Empty_Env
               else NE.Envs.First_Element);
         begin
            --  If there was an environment with precedence, remove its foreign
            --  nodes.
            if NE.Env_With_Precedence /= Empty_Env then
               for Cur in NE.Foreign_Nodes.Iterate loop
                  declare
                     Key   : constant Symbol_Type :=
                        NED_Assoc_Maps.Key (Cur);
                     Nodes : Internal_Map_Node_Vectors.Vector renames
                        NE.Foreign_Nodes.Reference (Cur);
                  begin
                     for N of Nodes loop
                        Remove (NE.Env_With_Precedence, Key, N.Node);
                     end loop;
                  end;
               end loop;
            end if;
            --  Now, set the new environment that has precedence
            NE.Env_With_Precedence := New_Env;
            --  Add the foreign nodes to the new environment with precedence,
            --  if any.
            for Cur in NE.Foreign_Nodes.Iterate loop
               declare
                  Key   : constant Symbol_Type :=
                     NED_Assoc_Maps.Key (Cur);
                  Nodes : Internal_Map_Node_Vectors.Vector renames
                     NE.Foreign_Nodes.Reference (Cur);
               begin
                  for N of Nodes loop
                     Add (New_Env, Key, N.Node, N.MD, N.Resolver);
                  end loop;
               end;
            end loop;
            --  Set the parent environment of all foreign environments
            for Cur in NE.Foreign_Envs.Iterate loop
               declare
                  Env : Lexical_Env_Type renames
                     Sorted_Env_Maps.Element (Cur).Env.all;
               begin
                  Env.Parent := Simple_Env_Getter (New_Env);
               end;
            end loop;
            --  Update nodes whose environment was the old env with precedence
            for N of NE.Nodes_With_Foreign_Env loop
               N.Self_Env := New_Env;
            end loop;
         end;
      end loop;
   end Update_Named_Envs;
   --------------------------
   -- Big integers wrapper --
   --------------------------
   ------------------------
   -- Create_Big_Integer --
   ------------------------
   function Create_Big_Integer
     (Image : String; Base : Integer := 10) return Big_Integer_Type
   is
      use GNATCOLL.GMP;
      use GNATCOLL.GMP.Integers;
   begin
      return new Big_Integer_Record'(Value     => Make (Image, Int (Base)),
                                     Ref_Count => 1);
   end Create_Big_Integer;
   ------------------------
   -- Create_Big_Integer --
   ------------------------
   function Create_Big_Integer
     (Big_Int : GNATCOLL.GMP.Integers.Big_Integer) return Big_Integer_Type
   is
      Result : constant Big_Integer_Type :=
         new Big_Integer_Record'(Value     => <>,
                                 Ref_Count => 1);
   begin
      Result.Value.Set (Big_Int);
      return Result;
   end Create_Big_Integer;
   ------------------------
   -- Create_Big_Integer --
   ------------------------
   function Create_Big_Integer (Int : Integer) return Big_Integer_Type is
      Result : constant Big_Integer_Type :=
         new Big_Integer_Record'(Value     => <>,
                                 Ref_Count => 1);
   begin
      Result.Value.Set (GNATCOLL.GMP.Long (Int));
      return Result;
   end Create_Big_Integer;
   -------------------------------
   -- Create_Public_Big_Integer --
   -------------------------------
   function Create_Public_Big_Integer
     (Big_Int : Big_Integer_Type) return GNATCOLL.GMP.Integers.Big_Integer is
   begin
      return Result : GNATCOLL.GMP.Integers.Big_Integer do
         Result.Set (Big_Int.Value);
      end return;
   end Create_Public_Big_Integer;
   -----------------
   -- Trace_Image --
   -----------------
   function Trace_Image (I : Big_Integer_Type) return String is
   begin
      return GNATCOLL.GMP.Integers.Image (I.Value);
   end Trace_Image;
   ----------------
   -- To_Integer --
   ----------------
   function To_Integer (Big_Int : Big_Integer_Type) return Integer is
      Image : constant String := Big_Int.Value.Image;
   begin
      return Integer'Value (Image);
   exception
      when Constraint_Error =>
         raise Property_Error with "out of range big integer";
   end To_Integer;
   -------------
   -- Inc_Ref --
   -------------
   procedure Inc_Ref (Big_Int : Big_Integer_Type) is
   begin
      if Big_Int.Ref_Count /= -1 then
         Big_Int.Ref_Count := Big_Int.Ref_Count + 1;
      end if;
   end Inc_Ref;
   -------------
   -- Dec_Ref --
   -------------
   procedure Dec_Ref (Big_Int : in out Big_Integer_Type) is
      procedure Destroy is new Ada.Unchecked_Deallocation
        (Big_Integer_Record, Big_Integer_Type);
   begin
      if Big_Int = null or else Big_Int.Ref_Count = -1 then
         return;
      end if;
      Big_Int.Ref_Count := Big_Int.Ref_Count - 1;
      if Big_Int.Ref_Count = 0 then
         Destroy (Big_Int);
      end if;
   end Dec_Ref;
   ----------------
   -- Equivalent --
   ----------------
   function Equivalent (Left, Right : Big_Integer_Type) return Boolean is
      use type GNATCOLL.GMP.Integers.Big_Integer;
   begin
      return Left.Value = Right.Value;
   end Equivalent;
   ---------
   -- "<" --
   ---------
   function "<" (Left, Right : Big_Integer_Type) return Boolean is
      use type GNATCOLL.GMP.Integers.Big_Integer;
   begin
      return Left.Value < Right.Value;
   end "<";
   ----------
   -- "<=" --
   ----------
   function "<=" (Left, Right : Big_Integer_Type) return Boolean is
      use type GNATCOLL.GMP.Integers.Big_Integer;
   begin
      return Left.Value <= Right.Value;
   end "<=";
   ---------
   -- ">" --
   ---------
   function ">" (Left, Right : Big_Integer_Type) return Boolean is
      use type GNATCOLL.GMP.Integers.Big_Integer;
   begin
      return Left.Value > Right.Value;
   end ">";
   ----------
   -- ">=" --
   ----------
   function ">=" (Left, Right : Big_Integer_Type) return Boolean is
      use type GNATCOLL.GMP.Integers.Big_Integer;
   begin
      return Left.Value >= Right.Value;
   end ">=";
   ---------
   -- "+" --
   ---------
   function "+" (Left, Right : Big_Integer_Type) return Big_Integer_Type is
      use type GNATCOLL.GMP.Integers.Big_Integer;
   begin
      return Create_Big_Integer (Left.Value + Right.Value);
   end "+";
   ---------
   -- "-" --
   ---------
   function "-" (Left, Right : Big_Integer_Type) return Big_Integer_Type is
      use type GNATCOLL.GMP.Integers.Big_Integer;
   begin
      return Create_Big_Integer (Left.Value - Right.Value);
   end "-";
   ------------------
   -- Unit_Version --
   ------------------
   function Unit_Version (Unit : Internal_Unit) return Version_Number is
   begin
      return Unit.Unit_Version;
   end Unit_Version;
   ---------------------
   -- Context_Version --
   ---------------------
   function Context_Version (Unit : Internal_Unit) return Integer is
   begin
      return Unit.Context.Reparse_Cache_Version;
   end Context_Version;
   ----------------------
   -- Short_Text_Image --
   ----------------------
   function Short_Text_Image (Self : Bare_Ada_Node) return Text_Type
   is
   begin
      if Self = null then
         return "None";
      end if;
   case Self.Kind is
            when Ada_Char_Literal .. Ada_String_Literal =>
         return Base_Id_Short_Image (Self);
            when Ada_Component_Decl .. Ada_Single_Task_Decl =>
         return Basic_Decl_Short_Image (Self);
      when others => 
         return "<" & To_Text (Kind_Name (Self))
                & " "
                & To_Text
                  (Ada.Directories.Simple_Name
                     (Get_Filename (Unit (Self))))
                & ":" & To_Text (Image (Sloc_Range (Self))) & ">";
   end case;
   end Short_Text_Image;
   --------------------
   -- Snaps_At_Start --
   --------------------
   function Snaps_At_Start (Self : Bare_Ada_Node) return Boolean is
   begin
   case Self.Kind is
            when Ada_Handled_Stmts =>
         return True;
            when Ada_Declarative_Part .. Ada_Public_Part =>
         return True;
      when others => 
         return False;
   end case;
   end Snaps_At_Start;
   ------------------
   -- Snaps_At_End --
   ------------------
   function Snaps_At_End (Self : Bare_Ada_Node) return Boolean is
   begin
   case Self.Kind is
            when Ada_Handled_Stmts =>
         return True;
            when Ada_Declarative_Part .. Ada_Public_Part =>
         return True;
      when others => 
         return Is_Incomplete (Self);
   end case;
   end Snaps_At_End;
   -------------
   -- Parents --
   -------------
   function Parents
     (Node         : Bare_Ada_Node;
      Include_Self : Boolean := True)
      return Bare_Ada_Node_Array_Access
   is
      Count : Natural := 0;
      Start : Bare_Ada_Node :=
        (if Include_Self then Node else Node.Parent);
      Cur   : Bare_Ada_Node := Start;
   begin
      while Cur /= null loop
         Count := Count + 1;
         Cur := Cur.Parent;
      end loop;
      declare
         Result : constant Bare_Ada_Node_Array_Access :=
            Create_Bare_Ada_Node_Array (Count);
      begin
         Cur := Start;
         for I in Result.Items'Range loop
            Result.Items (I) := Cur;
            Cur := Cur.Parent;
         end loop;
         return Result;
      end;
   end Parents;
   -----------------------
   -- First_Child_Index --
   -----------------------
   function First_Child_Index (Node : Bare_Ada_Node) return Natural
   is (1);
   ----------------------
   -- Last_Child_Index --
   ----------------------
   function Last_Child_Index (Node : Bare_Ada_Node) return Natural
   is (Children_Count (Node));
   ---------------
   -- Get_Child --
   ---------------
   procedure Get_Child
     (Node            : Bare_Ada_Node;
      Index           : Positive;
      Index_In_Bounds : out Boolean;
      Result          : out Bare_Ada_Node)
   is
      K : constant Ada_Node_Kind_Type := Node.Kind;
   begin
      Index_In_Bounds := True;
      Result := null;
      case Ada_Ada_Node (K) is
when Ada_Ada_List =>
declare
N_Bare_Ada_List : constant Bare_Ada_List := Node;
begin
                    if Index > N_Bare_Ada_List.Count then
                        Index_In_Bounds := False;
                    else
                        Result := N_Bare_Ada_List.Nodes (Index);
                    end if;
                    return;
end;
when Ada_Protected_Body_Stub_Range =>
declare
N_Bare_Protected_Body_Stub : constant Bare_Protected_Body_Stub := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Protected_Body_Stub.Protected_Body_Stub_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Protected_Body_Stub.Protected_Body_Stub_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Subp_Body_Stub_Range =>
declare
N_Bare_Subp_Body_Stub : constant Bare_Subp_Body_Stub := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Subp_Body_Stub.Subp_Body_Stub_F_Overriding;
                            return;
                        when 2 =>
                            Result := N_Bare_Subp_Body_Stub.Subp_Body_Stub_F_Subp_Spec;
                            return;
                        when 3 =>
                            Result := N_Bare_Subp_Body_Stub.Subp_Body_Stub_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Package_Body_Stub_Range =>
declare
N_Bare_Package_Body_Stub : constant Bare_Package_Body_Stub := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Package_Body_Stub.Package_Body_Stub_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Package_Body_Stub.Package_Body_Stub_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Task_Body_Stub_Range =>
declare
N_Bare_Task_Body_Stub : constant Bare_Task_Body_Stub := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Task_Body_Stub.Task_Body_Stub_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Task_Body_Stub.Task_Body_Stub_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Base_Subp_Body =>
declare
N_Bare_Base_Subp_Body : constant Bare_Base_Subp_Body := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Base_Subp_Body.Base_Subp_Body_F_Overriding;
                            return;
                        when 2 =>
                            Result := N_Bare_Base_Subp_Body.Base_Subp_Body_F_Subp_Spec;
                            return;
                        when others => null;
                    end case;
case Ada_Base_Subp_Body (K) is
when Ada_Expr_Function_Range =>
declare
N_Bare_Expr_Function : constant Bare_Expr_Function := N_Bare_Base_Subp_Body;
begin
case Index is
                        when 3 =>
                            Result := N_Bare_Expr_Function.Expr_Function_F_Expr;
                            return;
                        when 4 =>
                            Result := N_Bare_Expr_Function.Expr_Function_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Null_Subp_Decl_Range =>
declare
N_Bare_Null_Subp_Decl : constant Bare_Null_Subp_Decl := N_Bare_Base_Subp_Body;
begin
case Index is
                        when 3 =>
                            Result := N_Bare_Null_Subp_Decl.Null_Subp_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Subp_Renaming_Decl_Range =>
declare
N_Bare_Subp_Renaming_Decl : constant Bare_Subp_Renaming_Decl := N_Bare_Base_Subp_Body;
begin
case Index is
                        when 3 =>
                            Result := N_Bare_Subp_Renaming_Decl.Subp_Renaming_Decl_F_Renames;
                            return;
                        when 4 =>
                            Result := N_Bare_Subp_Renaming_Decl.Subp_Renaming_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Subp_Body_Range =>
declare
N_Bare_Subp_Body : constant Bare_Subp_Body := N_Bare_Base_Subp_Body;
begin
case Index is
                        when 3 =>
                            Result := N_Bare_Subp_Body.Subp_Body_F_Aspects;
                            return;
                        when 4 =>
                            Result := N_Bare_Subp_Body.Subp_Body_F_Decls;
                            return;
                        when 5 =>
                            Result := N_Bare_Subp_Body.Subp_Body_F_Stmts;
                            return;
                        when 6 =>
                            Result := N_Bare_Subp_Body.Subp_Body_F_End_Name;
                            return;
                        when others => null;
                    end case;
end;
when others => null;
end case;
end;
when Ada_Package_Body_Range =>
declare
N_Bare_Package_Body : constant Bare_Package_Body := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Package_Body.Package_Body_F_Package_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Package_Body.Package_Body_F_Aspects;
                            return;
                        when 3 =>
                            Result := N_Bare_Package_Body.Package_Body_F_Decls;
                            return;
                        when 4 =>
                            Result := N_Bare_Package_Body.Package_Body_F_Stmts;
                            return;
                        when 5 =>
                            Result := N_Bare_Package_Body.Package_Body_F_End_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Task_Body_Range =>
declare
N_Bare_Task_Body : constant Bare_Task_Body := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Task_Body.Task_Body_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Task_Body.Task_Body_F_Aspects;
                            return;
                        when 3 =>
                            Result := N_Bare_Task_Body.Task_Body_F_Decls;
                            return;
                        when 4 =>
                            Result := N_Bare_Task_Body.Task_Body_F_Stmts;
                            return;
                        when 5 =>
                            Result := N_Bare_Task_Body.Task_Body_F_End_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Protected_Body_Range =>
declare
N_Bare_Protected_Body : constant Bare_Protected_Body := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Protected_Body.Protected_Body_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Protected_Body.Protected_Body_F_Aspects;
                            return;
                        when 3 =>
                            Result := N_Bare_Protected_Body.Protected_Body_F_Decls;
                            return;
                        when 4 =>
                            Result := N_Bare_Protected_Body.Protected_Body_F_End_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Entry_Body_Range =>
declare
N_Bare_Entry_Body : constant Bare_Entry_Body := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Entry_Body.Entry_Body_F_Entry_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Entry_Body.Entry_Body_F_Index_Spec;
                            return;
                        when 3 =>
                            Result := N_Bare_Entry_Body.Entry_Body_F_Params;
                            return;
                        when 4 =>
                            Result := N_Bare_Entry_Body.Entry_Body_F_Barrier;
                            return;
                        when 5 =>
                            Result := N_Bare_Entry_Body.Entry_Body_F_Decls;
                            return;
                        when 6 =>
                            Result := N_Bare_Entry_Body.Entry_Body_F_Stmts;
                            return;
                        when 7 =>
                            Result := N_Bare_Entry_Body.Entry_Body_F_End_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Discriminant_Spec_Range =>
declare
N_Bare_Discriminant_Spec : constant Bare_Discriminant_Spec := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Discriminant_Spec.Discriminant_Spec_F_Ids;
                            return;
                        when 2 =>
                            Result := N_Bare_Discriminant_Spec.Discriminant_Spec_F_Type_Expr;
                            return;
                        when 3 =>
                            Result := N_Bare_Discriminant_Spec.Discriminant_Spec_F_Default_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Component_Decl_Range =>
declare
N_Bare_Component_Decl : constant Bare_Component_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Component_Decl.Component_Decl_F_Ids;
                            return;
                        when 2 =>
                            Result := N_Bare_Component_Decl.Component_Decl_F_Component_Def;
                            return;
                        when 3 =>
                            Result := N_Bare_Component_Decl.Component_Decl_F_Default_Expr;
                            return;
                        when 4 =>
                            Result := N_Bare_Component_Decl.Component_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Param_Spec_Range =>
declare
N_Bare_Param_Spec : constant Bare_Param_Spec := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Param_Spec.Param_Spec_F_Ids;
                            return;
                        when 2 =>
                            Result := N_Bare_Param_Spec.Param_Spec_F_Has_Aliased;
                            return;
                        when 3 =>
                            Result := N_Bare_Param_Spec.Param_Spec_F_Mode;
                            return;
                        when 4 =>
                            Result := N_Bare_Param_Spec.Param_Spec_F_Type_Expr;
                            return;
                        when 5 =>
                            Result := N_Bare_Param_Spec.Param_Spec_F_Default_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Generic_Formal =>
declare
N_Bare_Generic_Formal : constant Bare_Generic_Formal := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Generic_Formal.Generic_Formal_F_Decl;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Base_Type_Decl =>
declare
N_Bare_Base_Type_Decl : constant Bare_Base_Type_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Base_Type_Decl.Base_Type_Decl_F_Name;
                            return;
                        when others => null;
                    end case;
case Ada_Base_Type_Decl (K) is
when Ada_Type_Decl_Range =>
declare
N_Bare_Type_Decl : constant Bare_Type_Decl := N_Bare_Base_Type_Decl;
begin
case Index is
                        when 2 =>
                            Result := N_Bare_Type_Decl.Type_Decl_F_Discriminants;
                            return;
                        when 3 =>
                            Result := N_Bare_Type_Decl.Type_Decl_F_Type_Def;
                            return;
                        when 4 =>
                            Result := N_Bare_Type_Decl.Type_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Subtype_Decl_Range =>
declare
N_Bare_Subtype_Decl : constant Bare_Subtype_Decl := N_Bare_Base_Type_Decl;
begin
case Index is
                        when 2 =>
                            Result := N_Bare_Subtype_Decl.Subtype_Decl_F_Subtype;
                            return;
                        when 3 =>
                            Result := N_Bare_Subtype_Decl.Subtype_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Task_Type_Decl_Range =>
declare
N_Bare_Task_Type_Decl : constant Bare_Task_Type_Decl := N_Bare_Base_Type_Decl;
begin
case Index is
                        when 2 =>
                            Result := N_Bare_Task_Type_Decl.Task_Type_Decl_F_Discriminants;
                            return;
                        when 3 =>
                            Result := N_Bare_Task_Type_Decl.Task_Type_Decl_F_Aspects;
                            return;
                        when 4 =>
                            Result := N_Bare_Task_Type_Decl.Task_Type_Decl_F_Definition;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Protected_Type_Decl_Range =>
declare
N_Bare_Protected_Type_Decl : constant Bare_Protected_Type_Decl := N_Bare_Base_Type_Decl;
begin
case Index is
                        when 2 =>
                            Result := N_Bare_Protected_Type_Decl.Protected_Type_Decl_F_Discriminants;
                            return;
                        when 3 =>
                            Result := N_Bare_Protected_Type_Decl.Protected_Type_Decl_F_Aspects;
                            return;
                        when 4 =>
                            Result := N_Bare_Protected_Type_Decl.Protected_Type_Decl_F_Interfaces;
                            return;
                        when 5 =>
                            Result := N_Bare_Protected_Type_Decl.Protected_Type_Decl_F_Definition;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Incomplete_Type_Decl_Range =>
declare
N_Bare_Incomplete_Type_Decl : constant Bare_Incomplete_Type_Decl := N_Bare_Base_Type_Decl;
begin
case Index is
                        when 2 =>
                            Result := N_Bare_Incomplete_Type_Decl.Incomplete_Type_Decl_F_Discriminants;
                            return;
                        when others => null;
                    end case;
case Ada_Incomplete_Type_Decl_Range (K) is
when Ada_Incomplete_Tagged_Type_Decl_Range =>
declare
N_Bare_Incomplete_Tagged_Type_Decl : constant Bare_Incomplete_Tagged_Type_Decl := N_Bare_Incomplete_Type_Decl;
begin
case Index is
                        when 3 =>
                            Result := N_Bare_Incomplete_Tagged_Type_Decl.Incomplete_Tagged_Type_Decl_F_Has_Abstract;
                            return;
                        when others => null;
                    end case;
end;
when others => null;
end case;
end;
when others => null;
end case;
end;
when Ada_Classic_Subp_Decl =>
declare
N_Bare_Classic_Subp_Decl : constant Bare_Classic_Subp_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Classic_Subp_Decl.Classic_Subp_Decl_F_Overriding;
                            return;
                        when 2 =>
                            Result := N_Bare_Classic_Subp_Decl.Classic_Subp_Decl_F_Subp_Spec;
                            return;
                        when others => null;
                    end case;
case Ada_Classic_Subp_Decl (K) is
when Ada_Subp_Decl_Range =>
declare
N_Bare_Subp_Decl : constant Bare_Subp_Decl := N_Bare_Classic_Subp_Decl;
begin
case Index is
                        when 3 =>
                            Result := N_Bare_Subp_Decl.Subp_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Abstract_Subp_Decl_Range =>
declare
N_Bare_Abstract_Subp_Decl : constant Bare_Abstract_Subp_Decl := N_Bare_Classic_Subp_Decl;
begin
case Index is
                        when 3 =>
                            Result := N_Bare_Abstract_Subp_Decl.Abstract_Subp_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Formal_Subp_Decl =>
declare
N_Bare_Formal_Subp_Decl : constant Bare_Formal_Subp_Decl := N_Bare_Classic_Subp_Decl;
begin
case Index is
                        when 3 =>
                            Result := N_Bare_Formal_Subp_Decl.Formal_Subp_Decl_F_Default_Expr;
                            return;
                        when 4 =>
                            Result := N_Bare_Formal_Subp_Decl.Formal_Subp_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when others => null;
end case;
end;
when Ada_Generic_Subp_Internal_Range =>
declare
N_Bare_Generic_Subp_Internal : constant Bare_Generic_Subp_Internal := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Generic_Subp_Internal.Generic_Subp_Internal_F_Subp_Spec;
                            return;
                        when 2 =>
                            Result := N_Bare_Generic_Subp_Internal.Generic_Subp_Internal_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Enum_Literal_Decl_Range =>
declare
N_Bare_Enum_Literal_Decl : constant Bare_Enum_Literal_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Enum_Literal_Decl.Enum_Literal_Decl_F_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Entry_Decl_Range =>
declare
N_Bare_Entry_Decl : constant Bare_Entry_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Entry_Decl.Entry_Decl_F_Overriding;
                            return;
                        when 2 =>
                            Result := N_Bare_Entry_Decl.Entry_Decl_F_Spec;
                            return;
                        when 3 =>
                            Result := N_Bare_Entry_Decl.Entry_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Single_Task_Decl_Range =>
declare
N_Bare_Single_Task_Decl : constant Bare_Single_Task_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Single_Task_Decl.Single_Task_Decl_F_Task_Type;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Single_Protected_Decl_Range =>
declare
N_Bare_Single_Protected_Decl : constant Bare_Single_Protected_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Single_Protected_Decl.Single_Protected_Decl_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Single_Protected_Decl.Single_Protected_Decl_F_Aspects;
                            return;
                        when 3 =>
                            Result := N_Bare_Single_Protected_Decl.Single_Protected_Decl_F_Interfaces;
                            return;
                        when 4 =>
                            Result := N_Bare_Single_Protected_Decl.Single_Protected_Decl_F_Definition;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Number_Decl_Range =>
declare
N_Bare_Number_Decl : constant Bare_Number_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Number_Decl.Number_Decl_F_Ids;
                            return;
                        when 2 =>
                            Result := N_Bare_Number_Decl.Number_Decl_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Object_Decl_Range =>
declare
N_Bare_Object_Decl : constant Bare_Object_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Object_Decl.Object_Decl_F_Ids;
                            return;
                        when 2 =>
                            Result := N_Bare_Object_Decl.Object_Decl_F_Has_Aliased;
                            return;
                        when 3 =>
                            Result := N_Bare_Object_Decl.Object_Decl_F_Has_Constant;
                            return;
                        when 4 =>
                            Result := N_Bare_Object_Decl.Object_Decl_F_Mode;
                            return;
                        when 5 =>
                            Result := N_Bare_Object_Decl.Object_Decl_F_Type_Expr;
                            return;
                        when 6 =>
                            Result := N_Bare_Object_Decl.Object_Decl_F_Default_Expr;
                            return;
                        when 7 =>
                            Result := N_Bare_Object_Decl.Object_Decl_F_Renaming_Clause;
                            return;
                        when 8 =>
                            Result := N_Bare_Object_Decl.Object_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Base_Package_Decl =>
declare
N_Bare_Base_Package_Decl : constant Bare_Base_Package_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Base_Package_Decl.Base_Package_Decl_F_Package_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Base_Package_Decl.Base_Package_Decl_F_Aspects;
                            return;
                        when 3 =>
                            Result := N_Bare_Base_Package_Decl.Base_Package_Decl_F_Public_Part;
                            return;
                        when 4 =>
                            Result := N_Bare_Base_Package_Decl.Base_Package_Decl_F_Private_Part;
                            return;
                        when 5 =>
                            Result := N_Bare_Base_Package_Decl.Base_Package_Decl_F_End_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Exception_Decl_Range =>
declare
N_Bare_Exception_Decl : constant Bare_Exception_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Exception_Decl.Exception_Decl_F_Ids;
                            return;
                        when 2 =>
                            Result := N_Bare_Exception_Decl.Exception_Decl_F_Renames;
                            return;
                        when 3 =>
                            Result := N_Bare_Exception_Decl.Exception_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Generic_Subp_Instantiation_Range =>
declare
N_Bare_Generic_Subp_Instantiation : constant Bare_Generic_Subp_Instantiation := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Generic_Subp_Instantiation.Generic_Subp_Instantiation_F_Overriding;
                            return;
                        when 2 =>
                            Result := N_Bare_Generic_Subp_Instantiation.Generic_Subp_Instantiation_F_Kind;
                            return;
                        when 3 =>
                            Result := N_Bare_Generic_Subp_Instantiation.Generic_Subp_Instantiation_F_Subp_Name;
                            return;
                        when 4 =>
                            Result := N_Bare_Generic_Subp_Instantiation.Generic_Subp_Instantiation_F_Generic_Subp_Name;
                            return;
                        when 5 =>
                            Result := N_Bare_Generic_Subp_Instantiation.Generic_Subp_Instantiation_F_Params;
                            return;
                        when 6 =>
                            Result := N_Bare_Generic_Subp_Instantiation.Generic_Subp_Instantiation_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Generic_Package_Instantiation_Range =>
declare
N_Bare_Generic_Package_Instantiation : constant Bare_Generic_Package_Instantiation := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Generic_Package_Instantiation.Generic_Package_Instantiation_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Generic_Package_Instantiation.Generic_Package_Instantiation_F_Generic_Pkg_Name;
                            return;
                        when 3 =>
                            Result := N_Bare_Generic_Package_Instantiation.Generic_Package_Instantiation_F_Params;
                            return;
                        when 4 =>
                            Result := N_Bare_Generic_Package_Instantiation.Generic_Package_Instantiation_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Package_Renaming_Decl_Range =>
declare
N_Bare_Package_Renaming_Decl : constant Bare_Package_Renaming_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Package_Renaming_Decl.Package_Renaming_Decl_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Package_Renaming_Decl.Package_Renaming_Decl_F_Renames;
                            return;
                        when 3 =>
                            Result := N_Bare_Package_Renaming_Decl.Package_Renaming_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Generic_Package_Renaming_Decl_Range =>
declare
N_Bare_Generic_Package_Renaming_Decl : constant Bare_Generic_Package_Renaming_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Generic_Package_Renaming_Decl.Generic_Package_Renaming_Decl_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Generic_Package_Renaming_Decl.Generic_Package_Renaming_Decl_F_Renames;
                            return;
                        when 3 =>
                            Result := N_Bare_Generic_Package_Renaming_Decl.Generic_Package_Renaming_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Generic_Subp_Renaming_Decl_Range =>
declare
N_Bare_Generic_Subp_Renaming_Decl : constant Bare_Generic_Subp_Renaming_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Generic_Subp_Renaming_Decl.Generic_Subp_Renaming_Decl_F_Kind;
                            return;
                        when 2 =>
                            Result := N_Bare_Generic_Subp_Renaming_Decl.Generic_Subp_Renaming_Decl_F_Name;
                            return;
                        when 3 =>
                            Result := N_Bare_Generic_Subp_Renaming_Decl.Generic_Subp_Renaming_Decl_F_Renames;
                            return;
                        when 4 =>
                            Result := N_Bare_Generic_Subp_Renaming_Decl.Generic_Subp_Renaming_Decl_F_Aspects;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Generic_Decl =>
declare
N_Bare_Generic_Decl : constant Bare_Generic_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Generic_Decl.Generic_Decl_F_Formal_Part;
                            return;
                        when others => null;
                    end case;
case Ada_Generic_Decl (K) is
when Ada_Generic_Subp_Decl_Range =>
declare
N_Bare_Generic_Subp_Decl : constant Bare_Generic_Subp_Decl := N_Bare_Generic_Decl;
begin
case Index is
                        when 2 =>
                            Result := N_Bare_Generic_Subp_Decl.Generic_Subp_Decl_F_Subp_Decl;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Generic_Package_Decl_Range =>
declare
N_Bare_Generic_Package_Decl : constant Bare_Generic_Package_Decl := N_Bare_Generic_Decl;
begin
case Index is
                        when 2 =>
                            Result := N_Bare_Generic_Package_Decl.Generic_Package_Decl_F_Package_Decl;
                            return;
                        when others => null;
                    end case;
end;
when others => null;
end case;
end;
when Ada_For_Loop_Var_Decl_Range =>
declare
N_Bare_For_Loop_Var_Decl : constant Bare_For_Loop_Var_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_For_Loop_Var_Decl.For_Loop_Var_Decl_F_Id;
                            return;
                        when 2 =>
                            Result := N_Bare_For_Loop_Var_Decl.For_Loop_Var_Decl_F_Id_Type;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Exception_Handler_Range =>
declare
N_Bare_Exception_Handler : constant Bare_Exception_Handler := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Exception_Handler.Exception_Handler_F_Exception_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Exception_Handler.Exception_Handler_F_Handled_Exceptions;
                            return;
                        when 3 =>
                            Result := N_Bare_Exception_Handler.Exception_Handler_F_Stmts;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Label_Decl_Range =>
declare
N_Bare_Label_Decl : constant Bare_Label_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Label_Decl.Label_Decl_F_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Named_Stmt_Decl_Range =>
declare
N_Bare_Named_Stmt_Decl : constant Bare_Named_Stmt_Decl := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Named_Stmt_Decl.Named_Stmt_Decl_F_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Entry_Index_Spec_Range =>
declare
N_Bare_Entry_Index_Spec : constant Bare_Entry_Index_Spec := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Entry_Index_Spec.Entry_Index_Spec_F_Id;
                            return;
                        when 2 =>
                            Result := N_Bare_Entry_Index_Spec.Entry_Index_Spec_F_Subtype;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Known_Discriminant_Part_Range =>
declare
N_Bare_Known_Discriminant_Part : constant Bare_Known_Discriminant_Part := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Known_Discriminant_Part.Known_Discriminant_Part_F_Discr_Specs;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Component_List_Range =>
declare
N_Bare_Component_List : constant Bare_Component_List := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Component_List.Component_List_F_Components;
                            return;
                        when 2 =>
                            Result := N_Bare_Component_List.Component_List_F_Variant_Part;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Generic_Formal_Part_Range =>
declare
N_Bare_Generic_Formal_Part : constant Bare_Generic_Formal_Part := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Generic_Formal_Part.Generic_Formal_Part_F_Decls;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Subp_Spec_Range =>
declare
N_Bare_Subp_Spec : constant Bare_Subp_Spec := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Subp_Spec.Subp_Spec_F_Subp_Kind;
                            return;
                        when 2 =>
                            Result := N_Bare_Subp_Spec.Subp_Spec_F_Subp_Name;
                            return;
                        when 3 =>
                            Result := N_Bare_Subp_Spec.Subp_Spec_F_Subp_Params;
                            return;
                        when 4 =>
                            Result := N_Bare_Subp_Spec.Subp_Spec_F_Subp_Returns;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Entry_Spec_Range =>
declare
N_Bare_Entry_Spec : constant Bare_Entry_Spec := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Entry_Spec.Entry_Spec_F_Entry_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Entry_Spec.Entry_Spec_F_Family_Type;
                            return;
                        when 3 =>
                            Result := N_Bare_Entry_Spec.Entry_Spec_F_Entry_Params;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Entry_Completion_Formal_Params_Range =>
declare
N_Bare_Entry_Completion_Formal_Params : constant Bare_Entry_Completion_Formal_Params := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Entry_Completion_Formal_Params.Entry_Completion_Formal_Params_F_Params;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Record_Type_Def_Range =>
declare
N_Bare_Record_Type_Def : constant Bare_Record_Type_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Record_Type_Def.Record_Type_Def_F_Has_Abstract;
                            return;
                        when 2 =>
                            Result := N_Bare_Record_Type_Def.Record_Type_Def_F_Has_Tagged;
                            return;
                        when 3 =>
                            Result := N_Bare_Record_Type_Def.Record_Type_Def_F_Has_Limited;
                            return;
                        when 4 =>
                            Result := N_Bare_Record_Type_Def.Record_Type_Def_F_Record_Def;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Floating_Point_Def_Range =>
declare
N_Bare_Floating_Point_Def : constant Bare_Floating_Point_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Floating_Point_Def.Floating_Point_Def_F_Num_Digits;
                            return;
                        when 2 =>
                            Result := N_Bare_Floating_Point_Def.Floating_Point_Def_F_Range;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Ordinary_Fixed_Point_Def_Range =>
declare
N_Bare_Ordinary_Fixed_Point_Def : constant Bare_Ordinary_Fixed_Point_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Ordinary_Fixed_Point_Def.Ordinary_Fixed_Point_Def_F_Delta;
                            return;
                        when 2 =>
                            Result := N_Bare_Ordinary_Fixed_Point_Def.Ordinary_Fixed_Point_Def_F_Range;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Decimal_Fixed_Point_Def_Range =>
declare
N_Bare_Decimal_Fixed_Point_Def : constant Bare_Decimal_Fixed_Point_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Decimal_Fixed_Point_Def.Decimal_Fixed_Point_Def_F_Delta;
                            return;
                        when 2 =>
                            Result := N_Bare_Decimal_Fixed_Point_Def.Decimal_Fixed_Point_Def_F_Digits;
                            return;
                        when 3 =>
                            Result := N_Bare_Decimal_Fixed_Point_Def.Decimal_Fixed_Point_Def_F_Range;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Enum_Type_Def_Range =>
declare
N_Bare_Enum_Type_Def : constant Bare_Enum_Type_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Enum_Type_Def.Enum_Type_Def_F_Enum_Literals;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Derived_Type_Def_Range =>
declare
N_Bare_Derived_Type_Def : constant Bare_Derived_Type_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Derived_Type_Def.Derived_Type_Def_F_Has_Abstract;
                            return;
                        when 2 =>
                            Result := N_Bare_Derived_Type_Def.Derived_Type_Def_F_Has_Limited;
                            return;
                        when 3 =>
                            Result := N_Bare_Derived_Type_Def.Derived_Type_Def_F_Has_Synchronized;
                            return;
                        when 4 =>
                            Result := N_Bare_Derived_Type_Def.Derived_Type_Def_F_Subtype_Indication;
                            return;
                        when 5 =>
                            Result := N_Bare_Derived_Type_Def.Derived_Type_Def_F_Interfaces;
                            return;
                        when 6 =>
                            Result := N_Bare_Derived_Type_Def.Derived_Type_Def_F_Record_Extension;
                            return;
                        when 7 =>
                            Result := N_Bare_Derived_Type_Def.Derived_Type_Def_F_Has_With_Private;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Private_Type_Def_Range =>
declare
N_Bare_Private_Type_Def : constant Bare_Private_Type_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Private_Type_Def.Private_Type_Def_F_Has_Abstract;
                            return;
                        when 2 =>
                            Result := N_Bare_Private_Type_Def.Private_Type_Def_F_Has_Tagged;
                            return;
                        when 3 =>
                            Result := N_Bare_Private_Type_Def.Private_Type_Def_F_Has_Limited;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Signed_Int_Type_Def_Range =>
declare
N_Bare_Signed_Int_Type_Def : constant Bare_Signed_Int_Type_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Signed_Int_Type_Def.Signed_Int_Type_Def_F_Range;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Mod_Int_Type_Def_Range =>
declare
N_Bare_Mod_Int_Type_Def : constant Bare_Mod_Int_Type_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Mod_Int_Type_Def.Mod_Int_Type_Def_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Array_Type_Def_Range =>
declare
N_Bare_Array_Type_Def : constant Bare_Array_Type_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Array_Type_Def.Array_Type_Def_F_Indices;
                            return;
                        when 2 =>
                            Result := N_Bare_Array_Type_Def.Array_Type_Def_F_Component_Type;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Interface_Type_Def_Range =>
declare
N_Bare_Interface_Type_Def : constant Bare_Interface_Type_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Interface_Type_Def.Interface_Type_Def_F_Interface_Kind;
                            return;
                        when 2 =>
                            Result := N_Bare_Interface_Type_Def.Interface_Type_Def_F_Interfaces;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Access_Def =>
declare
N_Bare_Access_Def : constant Bare_Access_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Access_Def.Access_Def_F_Has_Not_Null;
                            return;
                        when others => null;
                    end case;
case Ada_Access_Def (K) is
when Ada_Access_To_Subp_Def_Range =>
declare
N_Bare_Access_To_Subp_Def : constant Bare_Access_To_Subp_Def := N_Bare_Access_Def;
begin
case Index is
                        when 2 =>
                            Result := N_Bare_Access_To_Subp_Def.Access_To_Subp_Def_F_Has_Protected;
                            return;
                        when 3 =>
                            Result := N_Bare_Access_To_Subp_Def.Access_To_Subp_Def_F_Subp_Spec;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Type_Access_Def_Range =>
declare
N_Bare_Type_Access_Def : constant Bare_Type_Access_Def := N_Bare_Access_Def;
begin
case Index is
                        when 2 =>
                            Result := N_Bare_Type_Access_Def.Type_Access_Def_F_Has_All;
                            return;
                        when 3 =>
                            Result := N_Bare_Type_Access_Def.Type_Access_Def_F_Has_Constant;
                            return;
                        when 4 =>
                            Result := N_Bare_Type_Access_Def.Type_Access_Def_F_Subtype_Indication;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Anonymous_Type_Access_Def_Range =>
declare
N_Bare_Anonymous_Type_Access_Def : constant Bare_Anonymous_Type_Access_Def := N_Bare_Access_Def;
begin
case Index is
                        when 2 =>
                            Result := N_Bare_Anonymous_Type_Access_Def.Anonymous_Type_Access_Def_F_Type_Decl;
                            return;
                        when others => null;
                    end case;
end;
when others => null;
end case;
end;
when Ada_Variant_Range =>
declare
N_Bare_Variant : constant Bare_Variant := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Variant.Variant_F_Choices;
                            return;
                        when 2 =>
                            Result := N_Bare_Variant.Variant_F_Components;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Variant_Part_Range =>
declare
N_Bare_Variant_Part : constant Bare_Variant_Part := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Variant_Part.Variant_Part_F_Discr_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Variant_Part.Variant_Part_F_Variant;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Base_Record_Def =>
declare
N_Bare_Base_Record_Def : constant Bare_Base_Record_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Base_Record_Def.Base_Record_Def_F_Components;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Pragma_Argument_Assoc_Range =>
declare
N_Bare_Pragma_Argument_Assoc : constant Bare_Pragma_Argument_Assoc := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Pragma_Argument_Assoc.Pragma_Argument_Assoc_F_Id;
                            return;
                        when 2 =>
                            Result := N_Bare_Pragma_Argument_Assoc.Pragma_Argument_Assoc_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Contract_Case_Assoc_Range =>
declare
N_Bare_Contract_Case_Assoc : constant Bare_Contract_Case_Assoc := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Contract_Case_Assoc.Contract_Case_Assoc_F_Guard;
                            return;
                        when 2 =>
                            Result := N_Bare_Contract_Case_Assoc.Contract_Case_Assoc_F_Consequence;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Range_Constraint_Range =>
declare
N_Bare_Range_Constraint : constant Bare_Range_Constraint := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Range_Constraint.Range_Constraint_F_Range;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Digits_Constraint_Range =>
declare
N_Bare_Digits_Constraint : constant Bare_Digits_Constraint := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Digits_Constraint.Digits_Constraint_F_Digits;
                            return;
                        when 2 =>
                            Result := N_Bare_Digits_Constraint.Digits_Constraint_F_Range;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Delta_Constraint_Range =>
declare
N_Bare_Delta_Constraint : constant Bare_Delta_Constraint := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Delta_Constraint.Delta_Constraint_F_Digits;
                            return;
                        when 2 =>
                            Result := N_Bare_Delta_Constraint.Delta_Constraint_F_Range;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Index_Constraint_Range =>
declare
N_Bare_Index_Constraint : constant Bare_Index_Constraint := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Index_Constraint.Index_Constraint_F_Constraints;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Discriminant_Constraint_Range =>
declare
N_Bare_Discriminant_Constraint : constant Bare_Discriminant_Constraint := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Discriminant_Constraint.Discriminant_Constraint_F_Constraints;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Discriminant_Assoc_Range =>
declare
N_Bare_Discriminant_Assoc : constant Bare_Discriminant_Assoc := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Discriminant_Assoc.Discriminant_Assoc_F_Ids;
                            return;
                        when 2 =>
                            Result := N_Bare_Discriminant_Assoc.Discriminant_Assoc_F_Discr_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Param_Assoc_Range =>
declare
N_Bare_Param_Assoc : constant Bare_Param_Assoc := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Param_Assoc.Param_Assoc_F_Designator;
                            return;
                        when 2 =>
                            Result := N_Bare_Param_Assoc.Param_Assoc_F_R_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Aggregate_Assoc_Range =>
declare
N_Bare_Aggregate_Assoc : constant Bare_Aggregate_Assoc := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Aggregate_Assoc.Aggregate_Assoc_F_Designators;
                            return;
                        when 2 =>
                            Result := N_Bare_Aggregate_Assoc.Aggregate_Assoc_F_R_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Iterated_Assoc_Range =>
declare
N_Bare_Iterated_Assoc : constant Bare_Iterated_Assoc := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Iterated_Assoc.Iterated_Assoc_F_Spec;
                            return;
                        when 2 =>
                            Result := N_Bare_Iterated_Assoc.Iterated_Assoc_F_R_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Unconstrained_Array_Indices_Range =>
declare
N_Bare_Unconstrained_Array_Indices : constant Bare_Unconstrained_Array_Indices := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Unconstrained_Array_Indices.Unconstrained_Array_Indices_F_Types;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Constrained_Array_Indices_Range =>
declare
N_Bare_Constrained_Array_Indices : constant Bare_Constrained_Array_Indices := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Constrained_Array_Indices.Constrained_Array_Indices_F_List;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Component_Def_Range =>
declare
N_Bare_Component_Def : constant Bare_Component_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Component_Def.Component_Def_F_Has_Aliased;
                            return;
                        when 2 =>
                            Result := N_Bare_Component_Def.Component_Def_F_Has_Constant;
                            return;
                        when 3 =>
                            Result := N_Bare_Component_Def.Component_Def_F_Type_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Task_Def_Range =>
declare
N_Bare_Task_Def : constant Bare_Task_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Task_Def.Task_Def_F_Interfaces;
                            return;
                        when 2 =>
                            Result := N_Bare_Task_Def.Task_Def_F_Public_Part;
                            return;
                        when 3 =>
                            Result := N_Bare_Task_Def.Task_Def_F_Private_Part;
                            return;
                        when 4 =>
                            Result := N_Bare_Task_Def.Task_Def_F_End_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Protected_Def_Range =>
declare
N_Bare_Protected_Def : constant Bare_Protected_Def := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Protected_Def.Protected_Def_F_Public_Part;
                            return;
                        when 2 =>
                            Result := N_Bare_Protected_Def.Protected_Def_F_Private_Part;
                            return;
                        when 3 =>
                            Result := N_Bare_Protected_Def.Protected_Def_F_End_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_With_Clause_Range =>
declare
N_Bare_With_Clause : constant Bare_With_Clause := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_With_Clause.With_Clause_F_Has_Limited;
                            return;
                        when 2 =>
                            Result := N_Bare_With_Clause.With_Clause_F_Has_Private;
                            return;
                        when 3 =>
                            Result := N_Bare_With_Clause.With_Clause_F_Packages;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Use_Package_Clause_Range =>
declare
N_Bare_Use_Package_Clause : constant Bare_Use_Package_Clause := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Use_Package_Clause.Use_Package_Clause_F_Packages;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Use_Type_Clause_Range =>
declare
N_Bare_Use_Type_Clause : constant Bare_Use_Type_Clause := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Use_Type_Clause.Use_Type_Clause_F_Has_All;
                            return;
                        when 2 =>
                            Result := N_Bare_Use_Type_Clause.Use_Type_Clause_F_Types;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Anonymous_Type_Range =>
declare
N_Bare_Anonymous_Type : constant Bare_Anonymous_Type := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Anonymous_Type.Anonymous_Type_F_Type_Decl;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Subtype_Indication_Range =>
declare
N_Bare_Subtype_Indication : constant Bare_Subtype_Indication := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Subtype_Indication.Subtype_Indication_F_Has_Not_Null;
                            return;
                        when 2 =>
                            Result := N_Bare_Subtype_Indication.Subtype_Indication_F_Name;
                            return;
                        when 3 =>
                            Result := N_Bare_Subtype_Indication.Subtype_Indication_F_Constraint;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Aspect_Spec_Range =>
declare
N_Bare_Aspect_Spec : constant Bare_Aspect_Spec := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Aspect_Spec.Aspect_Spec_F_Aspect_Assocs;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Pragma_Node_Range =>
declare
N_Bare_Pragma_Node : constant Bare_Pragma_Node := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Pragma_Node.Pragma_Node_F_Id;
                            return;
                        when 2 =>
                            Result := N_Bare_Pragma_Node.Pragma_Node_F_Args;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Enum_Rep_Clause_Range =>
declare
N_Bare_Enum_Rep_Clause : constant Bare_Enum_Rep_Clause := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Enum_Rep_Clause.Enum_Rep_Clause_F_Type_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Enum_Rep_Clause.Enum_Rep_Clause_F_Aggregate;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Attribute_Def_Clause_Range =>
declare
N_Bare_Attribute_Def_Clause : constant Bare_Attribute_Def_Clause := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Attribute_Def_Clause.Attribute_Def_Clause_F_Attribute_Expr;
                            return;
                        when 2 =>
                            Result := N_Bare_Attribute_Def_Clause.Attribute_Def_Clause_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Record_Rep_Clause_Range =>
declare
N_Bare_Record_Rep_Clause : constant Bare_Record_Rep_Clause := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Record_Rep_Clause.Record_Rep_Clause_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Record_Rep_Clause.Record_Rep_Clause_F_At_Expr;
                            return;
                        when 3 =>
                            Result := N_Bare_Record_Rep_Clause.Record_Rep_Clause_F_Components;
                            return;
                        when others => null;
                    end case;
end;
when Ada_At_Clause_Range =>
declare
N_Bare_At_Clause : constant Bare_At_Clause := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_At_Clause.At_Clause_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_At_Clause.At_Clause_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Component_Clause_Range =>
declare
N_Bare_Component_Clause : constant Bare_Component_Clause := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Component_Clause.Component_Clause_F_Id;
                            return;
                        when 2 =>
                            Result := N_Bare_Component_Clause.Component_Clause_F_Position;
                            return;
                        when 3 =>
                            Result := N_Bare_Component_Clause.Component_Clause_F_Range;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Aspect_Assoc_Range =>
declare
N_Bare_Aspect_Assoc : constant Bare_Aspect_Assoc := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Aspect_Assoc.Aspect_Assoc_F_Id;
                            return;
                        when 2 =>
                            Result := N_Bare_Aspect_Assoc.Aspect_Assoc_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Declarative_Part_Range =>
declare
N_Bare_Declarative_Part : constant Bare_Declarative_Part := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Declarative_Part.Declarative_Part_F_Decls;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Renaming_Clause_Range =>
declare
N_Bare_Renaming_Clause : constant Bare_Renaming_Clause := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Renaming_Clause.Renaming_Clause_F_Renamed_Object;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Decl_Expr_Range =>
declare
N_Bare_Decl_Expr : constant Bare_Decl_Expr := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Decl_Expr.Decl_Expr_F_Decls;
                            return;
                        when 2 =>
                            Result := N_Bare_Decl_Expr.Decl_Expr_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Contract_Cases_Range =>
declare
N_Bare_Contract_Cases : constant Bare_Contract_Cases := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Contract_Cases.Contract_Cases_F_Contract_Cases;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Paren_Expr_Range =>
declare
N_Bare_Paren_Expr : constant Bare_Paren_Expr := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Paren_Expr.Paren_Expr_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Un_Op_Range =>
declare
N_Bare_Un_Op : constant Bare_Un_Op := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Un_Op.Un_Op_F_Op;
                            return;
                        when 2 =>
                            Result := N_Bare_Un_Op.Un_Op_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Bin_Op_Range =>
declare
N_Bare_Bin_Op : constant Bare_Bin_Op := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Bin_Op.Bin_Op_F_Left;
                            return;
                        when 2 =>
                            Result := N_Bare_Bin_Op.Bin_Op_F_Op;
                            return;
                        when 3 =>
                            Result := N_Bare_Bin_Op.Bin_Op_F_Right;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Membership_Expr_Range =>
declare
N_Bare_Membership_Expr : constant Bare_Membership_Expr := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Membership_Expr.Membership_Expr_F_Expr;
                            return;
                        when 2 =>
                            Result := N_Bare_Membership_Expr.Membership_Expr_F_Op;
                            return;
                        when 3 =>
                            Result := N_Bare_Membership_Expr.Membership_Expr_F_Membership_Exprs;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Base_Aggregate =>
declare
N_Bare_Base_Aggregate : constant Bare_Base_Aggregate := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Base_Aggregate.Base_Aggregate_F_Ancestor_Expr;
                            return;
                        when 2 =>
                            Result := N_Bare_Base_Aggregate.Base_Aggregate_F_Assocs;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Discrete_Subtype_Name_Range =>
declare
N_Bare_Discrete_Subtype_Name : constant Bare_Discrete_Subtype_Name := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Discrete_Subtype_Name.Discrete_Subtype_Name_F_Subtype;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Call_Expr_Range =>
declare
N_Bare_Call_Expr : constant Bare_Call_Expr := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Call_Expr.Call_Expr_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Call_Expr.Call_Expr_F_Suffix;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Explicit_Deref_Range =>
declare
N_Bare_Explicit_Deref : constant Bare_Explicit_Deref := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Explicit_Deref.Explicit_Deref_F_Prefix;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Defining_Name_Range =>
declare
N_Bare_Defining_Name : constant Bare_Defining_Name := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Defining_Name.Defining_Name_F_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_End_Name_Range =>
declare
N_Bare_End_Name : constant Bare_End_Name := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_End_Name.End_Name_F_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Qual_Expr_Range =>
declare
N_Bare_Qual_Expr : constant Bare_Qual_Expr := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Qual_Expr.Qual_Expr_F_Prefix;
                            return;
                        when 2 =>
                            Result := N_Bare_Qual_Expr.Qual_Expr_F_Suffix;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Attribute_Ref_Range =>
declare
N_Bare_Attribute_Ref : constant Bare_Attribute_Ref := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Attribute_Ref.Attribute_Ref_F_Prefix;
                            return;
                        when 2 =>
                            Result := N_Bare_Attribute_Ref.Attribute_Ref_F_Attribute;
                            return;
                        when 3 =>
                            Result := N_Bare_Attribute_Ref.Attribute_Ref_F_Args;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Dotted_Name_Range =>
declare
N_Bare_Dotted_Name : constant Bare_Dotted_Name := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Dotted_Name.Dotted_Name_F_Prefix;
                            return;
                        when 2 =>
                            Result := N_Bare_Dotted_Name.Dotted_Name_F_Suffix;
                            return;
                        when others => null;
                    end case;
end;
when Ada_If_Expr_Range =>
declare
N_Bare_If_Expr : constant Bare_If_Expr := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_If_Expr.If_Expr_F_Cond_Expr;
                            return;
                        when 2 =>
                            Result := N_Bare_If_Expr.If_Expr_F_Then_Expr;
                            return;
                        when 3 =>
                            Result := N_Bare_If_Expr.If_Expr_F_Alternatives;
                            return;
                        when 4 =>
                            Result := N_Bare_If_Expr.If_Expr_F_Else_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Case_Expr_Range =>
declare
N_Bare_Case_Expr : constant Bare_Case_Expr := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Case_Expr.Case_Expr_F_Expr;
                            return;
                        when 2 =>
                            Result := N_Bare_Case_Expr.Case_Expr_F_Cases;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Case_Expr_Alternative_Range =>
declare
N_Bare_Case_Expr_Alternative : constant Bare_Case_Expr_Alternative := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Case_Expr_Alternative.Case_Expr_Alternative_F_Choices;
                            return;
                        when 2 =>
                            Result := N_Bare_Case_Expr_Alternative.Case_Expr_Alternative_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Quantified_Expr_Range =>
declare
N_Bare_Quantified_Expr : constant Bare_Quantified_Expr := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Quantified_Expr.Quantified_Expr_F_Quantifier;
                            return;
                        when 2 =>
                            Result := N_Bare_Quantified_Expr.Quantified_Expr_F_Loop_Spec;
                            return;
                        when 3 =>
                            Result := N_Bare_Quantified_Expr.Quantified_Expr_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Allocator_Range =>
declare
N_Bare_Allocator : constant Bare_Allocator := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Allocator.Allocator_F_Subpool;
                            return;
                        when 2 =>
                            Result := N_Bare_Allocator.Allocator_F_Type_Or_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Raise_Expr_Range =>
declare
N_Bare_Raise_Expr : constant Bare_Raise_Expr := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Raise_Expr.Raise_Expr_F_Exception_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Raise_Expr.Raise_Expr_F_Error_Message;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Elsif_Expr_Part_Range =>
declare
N_Bare_Elsif_Expr_Part : constant Bare_Elsif_Expr_Part := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Elsif_Expr_Part.Elsif_Expr_Part_F_Cond_Expr;
                            return;
                        when 2 =>
                            Result := N_Bare_Elsif_Expr_Part.Elsif_Expr_Part_F_Then_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_For_Loop_Spec_Range =>
declare
N_Bare_For_Loop_Spec : constant Bare_For_Loop_Spec := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_For_Loop_Spec.For_Loop_Spec_F_Var_Decl;
                            return;
                        when 2 =>
                            Result := N_Bare_For_Loop_Spec.For_Loop_Spec_F_Loop_Type;
                            return;
                        when 3 =>
                            Result := N_Bare_For_Loop_Spec.For_Loop_Spec_F_Has_Reverse;
                            return;
                        when 4 =>
                            Result := N_Bare_For_Loop_Spec.For_Loop_Spec_F_Iter_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_While_Loop_Spec_Range =>
declare
N_Bare_While_Loop_Spec : constant Bare_While_Loop_Spec := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_While_Loop_Spec.While_Loop_Spec_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Compilation_Unit_Range =>
declare
N_Bare_Compilation_Unit : constant Bare_Compilation_Unit := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Compilation_Unit.Compilation_Unit_F_Prelude;
                            return;
                        when 2 =>
                            Result := N_Bare_Compilation_Unit.Compilation_Unit_F_Body;
                            return;
                        when 3 =>
                            Result := N_Bare_Compilation_Unit.Compilation_Unit_F_Pragmas;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Handled_Stmts_Range =>
declare
N_Bare_Handled_Stmts : constant Bare_Handled_Stmts := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Handled_Stmts.Handled_Stmts_F_Stmts;
                            return;
                        when 2 =>
                            Result := N_Bare_Handled_Stmts.Handled_Stmts_F_Exceptions;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Call_Stmt_Range =>
declare
N_Bare_Call_Stmt : constant Bare_Call_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Call_Stmt.Call_Stmt_F_Call;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Assign_Stmt_Range =>
declare
N_Bare_Assign_Stmt : constant Bare_Assign_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Assign_Stmt.Assign_Stmt_F_Dest;
                            return;
                        when 2 =>
                            Result := N_Bare_Assign_Stmt.Assign_Stmt_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Goto_Stmt_Range =>
declare
N_Bare_Goto_Stmt : constant Bare_Goto_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Goto_Stmt.Goto_Stmt_F_Label_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Exit_Stmt_Range =>
declare
N_Bare_Exit_Stmt : constant Bare_Exit_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Exit_Stmt.Exit_Stmt_F_Loop_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Exit_Stmt.Exit_Stmt_F_Cond_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Return_Stmt_Range =>
declare
N_Bare_Return_Stmt : constant Bare_Return_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Return_Stmt.Return_Stmt_F_Return_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Requeue_Stmt_Range =>
declare
N_Bare_Requeue_Stmt : constant Bare_Requeue_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Requeue_Stmt.Requeue_Stmt_F_Call_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Requeue_Stmt.Requeue_Stmt_F_Has_Abort;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Abort_Stmt_Range =>
declare
N_Bare_Abort_Stmt : constant Bare_Abort_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Abort_Stmt.Abort_Stmt_F_Names;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Delay_Stmt_Range =>
declare
N_Bare_Delay_Stmt : constant Bare_Delay_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Delay_Stmt.Delay_Stmt_F_Has_Until;
                            return;
                        when 2 =>
                            Result := N_Bare_Delay_Stmt.Delay_Stmt_F_Expr;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Raise_Stmt_Range =>
declare
N_Bare_Raise_Stmt : constant Bare_Raise_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Raise_Stmt.Raise_Stmt_F_Exception_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Raise_Stmt.Raise_Stmt_F_Error_Message;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Label_Range =>
declare
N_Bare_Label : constant Bare_Label := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Label.Label_F_Decl;
                            return;
                        when others => null;
                    end case;
end;
when Ada_If_Stmt_Range =>
declare
N_Bare_If_Stmt : constant Bare_If_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_If_Stmt.If_Stmt_F_Cond_Expr;
                            return;
                        when 2 =>
                            Result := N_Bare_If_Stmt.If_Stmt_F_Then_Stmts;
                            return;
                        when 3 =>
                            Result := N_Bare_If_Stmt.If_Stmt_F_Alternatives;
                            return;
                        when 4 =>
                            Result := N_Bare_If_Stmt.If_Stmt_F_Else_Stmts;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Named_Stmt_Range =>
declare
N_Bare_Named_Stmt : constant Bare_Named_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Named_Stmt.Named_Stmt_F_Decl;
                            return;
                        when 2 =>
                            Result := N_Bare_Named_Stmt.Named_Stmt_F_Stmt;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Base_Loop_Stmt =>
declare
N_Bare_Base_Loop_Stmt : constant Bare_Base_Loop_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Base_Loop_Stmt.Base_Loop_Stmt_F_Spec;
                            return;
                        when 2 =>
                            Result := N_Bare_Base_Loop_Stmt.Base_Loop_Stmt_F_Stmts;
                            return;
                        when 3 =>
                            Result := N_Bare_Base_Loop_Stmt.Base_Loop_Stmt_F_End_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Decl_Block_Range =>
declare
N_Bare_Decl_Block : constant Bare_Decl_Block := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Decl_Block.Decl_Block_F_Decls;
                            return;
                        when 2 =>
                            Result := N_Bare_Decl_Block.Decl_Block_F_Stmts;
                            return;
                        when 3 =>
                            Result := N_Bare_Decl_Block.Decl_Block_F_End_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Begin_Block_Range =>
declare
N_Bare_Begin_Block : constant Bare_Begin_Block := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Begin_Block.Begin_Block_F_Stmts;
                            return;
                        when 2 =>
                            Result := N_Bare_Begin_Block.Begin_Block_F_End_Name;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Extended_Return_Stmt_Range =>
declare
N_Bare_Extended_Return_Stmt : constant Bare_Extended_Return_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Extended_Return_Stmt.Extended_Return_Stmt_F_Decl;
                            return;
                        when 2 =>
                            Result := N_Bare_Extended_Return_Stmt.Extended_Return_Stmt_F_Stmts;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Case_Stmt_Range =>
declare
N_Bare_Case_Stmt : constant Bare_Case_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Case_Stmt.Case_Stmt_F_Expr;
                            return;
                        when 2 =>
                            Result := N_Bare_Case_Stmt.Case_Stmt_F_Alternatives;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Accept_Stmt_Range =>
declare
N_Bare_Accept_Stmt : constant Bare_Accept_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Accept_Stmt.Accept_Stmt_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Accept_Stmt.Accept_Stmt_F_Entry_Index_Expr;
                            return;
                        when 3 =>
                            Result := N_Bare_Accept_Stmt.Accept_Stmt_F_Params;
                            return;
                        when others => null;
                    end case;
case Ada_Accept_Stmt_Range (K) is
when Ada_Accept_Stmt_With_Stmts_Range =>
declare
N_Bare_Accept_Stmt_With_Stmts : constant Bare_Accept_Stmt_With_Stmts := N_Bare_Accept_Stmt;
begin
case Index is
                        when 4 =>
                            Result := N_Bare_Accept_Stmt_With_Stmts.Accept_Stmt_With_Stmts_F_Stmts;
                            return;
                        when 5 =>
                            Result := N_Bare_Accept_Stmt_With_Stmts.Accept_Stmt_With_Stmts_F_End_Name;
                            return;
                        when others => null;
                    end case;
end;
when others => null;
end case;
end;
when Ada_Select_Stmt_Range =>
declare
N_Bare_Select_Stmt : constant Bare_Select_Stmt := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Select_Stmt.Select_Stmt_F_Guards;
                            return;
                        when 2 =>
                            Result := N_Bare_Select_Stmt.Select_Stmt_F_Else_Stmts;
                            return;
                        when 3 =>
                            Result := N_Bare_Select_Stmt.Select_Stmt_F_Abort_Stmts;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Elsif_Stmt_Part_Range =>
declare
N_Bare_Elsif_Stmt_Part : constant Bare_Elsif_Stmt_Part := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Elsif_Stmt_Part.Elsif_Stmt_Part_F_Cond_Expr;
                            return;
                        when 2 =>
                            Result := N_Bare_Elsif_Stmt_Part.Elsif_Stmt_Part_F_Stmts;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Case_Stmt_Alternative_Range =>
declare
N_Bare_Case_Stmt_Alternative : constant Bare_Case_Stmt_Alternative := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Case_Stmt_Alternative.Case_Stmt_Alternative_F_Choices;
                            return;
                        when 2 =>
                            Result := N_Bare_Case_Stmt_Alternative.Case_Stmt_Alternative_F_Stmts;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Select_When_Part_Range =>
declare
N_Bare_Select_When_Part : constant Bare_Select_When_Part := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Select_When_Part.Select_When_Part_F_Cond_Expr;
                            return;
                        when 2 =>
                            Result := N_Bare_Select_When_Part.Select_When_Part_F_Stmts;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Subunit_Range =>
declare
N_Bare_Subunit : constant Bare_Subunit := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Subunit.Subunit_F_Name;
                            return;
                        when 2 =>
                            Result := N_Bare_Subunit.Subunit_F_Body;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Library_Item_Range =>
declare
N_Bare_Library_Item : constant Bare_Library_Item := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Library_Item.Library_Item_F_Has_Private;
                            return;
                        when 2 =>
                            Result := N_Bare_Library_Item.Library_Item_F_Item;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Range_Spec_Range =>
declare
N_Bare_Range_Spec : constant Bare_Range_Spec := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Range_Spec.Range_Spec_F_Range;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Params_Range =>
declare
N_Bare_Params : constant Bare_Params := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Params.Params_F_Params;
                            return;
                        when others => null;
                    end case;
end;
when Ada_Unconstrained_Array_Index_Range =>
declare
N_Bare_Unconstrained_Array_Index : constant Bare_Unconstrained_Array_Index := Node;
begin
case Index is
                        when 1 =>
                            Result := N_Bare_Unconstrained_Array_Index.Unconstrained_Array_Index_F_Subtype_Indication;
                            return;
                        when others => null;
                    end case;
end;
when others => null;
end case;
      --  Execution should reach this point iff nothing matched this index, so
      --  we must be out of bounds.
      Index_In_Bounds := False;
   end Get_Child;
   -----------
   -- Print --
   -----------
   procedure Print
     (Node        : Bare_Ada_Node;
      Show_Slocs  : Boolean;
      Line_Prefix : String := "")
   is
      K               : constant Ada_Node_Kind_Type := Node.Kind;
      Attr_Prefix     : constant String := Line_Prefix & "|";
      Children_Prefix : constant String := Line_Prefix & "|  ";
   begin
      Put (Line_Prefix & Kind_Name (Node));
      if Show_Slocs then
         Put ("[" & Image (Sloc_Range (Node)) & "]");
      end if;
      if Is_Incomplete (Node) then
         Put (" <<INCOMPLETE>>");
      end if;
      if Is_Token_Node (Node.Kind) then
         Put_Line (": " & Image (Text (Node)));
      elsif Node.Kind not in Ada_Ada_List then
         New_Line;
      end if;
         --  List nodes are displayed in a special way (they have no field)
         if K in Ada_Ada_List then
            if Node.Count = 0 then
               Put_Line (": <empty list>");
               return;
            end if;
            New_Line;
            for Child of Node.Nodes (1 .. Node.Count) loop
               if Child /= null then
                  Print (Child, Show_Slocs, Line_Prefix & "|  ");
               end if;
            end loop;
            return;
         end if;
         --  This is for regular nodes: display each field
         declare
            use Libadalang.Introspection_Implementation;
            Field_List : constant Field_Reference_Array := Fields (K);
         begin
            for I in Field_List'Range loop
               declare
                  Child : constant Bare_Ada_Node :=
                     Implementation.Child (Node, I);
               begin
                  Put (Attr_Prefix & Field_Name (Field_List (I)) & ":");
                  if Child /= null then
                     New_Line;
                     Print (Child, Show_Slocs, Children_Prefix);
                  else
                     Put_Line (" <null>");
                  end if;
               end;
            end loop;
         end;
   end Print;
   ------------
   -- Parent --
   ------------
   function Parent (Node : Bare_Ada_Node) return Bare_Ada_Node is
   begin
      return Node.Parent;
   end Parent;
   ------------------
   -- Stored_Token --
   ------------------
   function Stored_Token
     (Node  : Bare_Ada_Node;
      Token : Token_Reference) return Token_Index
   is
      Index : constant Token_Or_Trivia_Index := Get_Token_Index (Token);
   begin
      if Node.Unit.TDH'Access /= Get_Token_TDH (Token) then
         raise Property_Error with
           ("Cannot associate a token and a node from different analysis"
            & " units");
      elsif Index.Trivia /= No_Token_Index then
         raise Property_Error with
           ("A node cannot hold trivia");
      end if;
      return Index.Token;
   end Stored_Token;
   -------------------------
   -- Children_And_Trivia --
   -------------------------
   function Children_And_Trivia
     (Node : Bare_Ada_Node) return Bare_Children_Array
   is
      package Children_Vectors is new Ada.Containers.Vectors
        (Positive, Bare_Child_Record);
      use Children_Vectors;
      Ret_Vec : Vector;
      TDH     : Token_Data_Handler renames Node.Unit.TDH;
      procedure Append_Trivias (First, Last : Token_Index);
      --  Append all the trivias of tokens between indices First and Last to
      --  the returned vector.
      function Filter_Children
        (Parent : Bare_Ada_Node)
         return Internal_Bare_Ada_Node_Array;
      --  Return an array for all children in Parent that are not null
      --------------------
      -- Append_Trivias --
      --------------------
      procedure Append_Trivias (First, Last : Token_Index) is
      begin
         for I in First .. Last loop
            for D of Get_Trivias (TDH, I) loop
               Ret_Vec.Append
                 (Bare_Child_Record'
                    (Kind   => Trivia,
                     Trivia => Wrap_Token_Reference (TDH'Access, (I, D))));
            end loop;
         end loop;
      end Append_Trivias;
      ---------------------
      -- Filter_Children --
      ---------------------
      function Filter_Children
        (Parent : Bare_Ada_Node)
         return Internal_Bare_Ada_Node_Array
      is
         Children : constant Internal_Bare_Ada_Node_Array :=
            Implementation.Children (Parent);
         Result   : Internal_Bare_Ada_Node_Array (Children'Range);
         Next     : Integer := Result'First;
      begin
         for I in Children'Range loop
            if Children (I) /= null then
               Result (Next) := Children (I);
               Next := Next + 1;
            end if;
         end loop;
         return Result (Result'First .. Next - 1);
      end Filter_Children;
      First_Child : constant Positive := 1;
      N_Children  : constant Internal_Bare_Ada_Node_Array :=
         Filter_Children (Node);
   begin
      if N_Children'Length > 0
        and then (Node.Token_Start_Index
                    /= N_Children (First_Child).Token_Start_Index)
      then
         Append_Trivias (Node.Token_Start_Index,
                         N_Children (First_Child).Token_Start_Index - 1);
      end if;
      --  Append each node to Ret_Vec, and append trivia that follow after each
      --  non-ghost nodes.
      for I in N_Children'Range loop
         Ret_Vec.Append (Bare_Child_Record'(Child, N_Children (I)));
         if not Is_Ghost (N_Children (I)) then
            Append_Trivias (N_Children (I).Token_End_Index,
                            (if I = N_Children'Last
                             then Node.Token_End_Index - 1
                             else N_Children (I + 1).Token_Start_Index - 1));
         end if;
      end loop;
      declare
         A : Bare_Children_Array (1 .. Natural (Ret_Vec.Length));
      begin
         for I in A'Range loop
            A (I) := Ret_Vec.Element (I);
         end loop;
         return A;
      end;
   end Children_And_Trivia;
   --------------
   -- Is_Ghost --
   --------------
   function Is_Ghost (Node : Bare_Ada_Node) return Boolean
   is (Node.Token_End_Index = No_Token_Index);
   -------------------
   -- Is_Incomplete --
   -------------------
   function Is_Incomplete (Node : Bare_Ada_Node) return Boolean
   is
      LGC : Bare_Ada_Node;
   begin
     if Is_List_Node (Node.Kind) then
        LGC := (if Last_Child_Index (Node) /= 0
                then Child (Node, Last_Child_Index (Node))
                else null);
        return LGC /= null and then Is_Incomplete (LGC);
      else
         return Node.Last_Attempted_Child > -1;
      end if;
   end;
   -----------------
   -- Token_Start --
   -----------------
   function Token_Start (Node : Bare_Ada_Node) return Token_Reference
   is (Token (Node, Node.Token_Start_Index));
   ---------------
   -- Token_End --
   ---------------
   function Token_End (Node : Bare_Ada_Node) return Token_Reference
   is
     (if Node.Token_End_Index = No_Token_Index
      then Token_Start (Node)
      else Token (Node, Node.Token_End_Index));
   -----------
   -- Token --
   -----------
   function Token
     (Node  : Bare_Ada_Node;
      Index : Token_Index) return Token_Reference
   is
     (Wrap_Token_Reference (Token_Data (Node.Unit), (Index, No_Token_Index)));
   ---------
   -- "<" --
   ---------
   function "<" (Left, Right : Bare_Ada_Node) return Boolean is
   begin
      --  Reject invalid inputs
      if Left /= null and Is_Synthetic (Left) then
         raise Property_Error with "left node is synthetic";
      elsif Right /= null and Is_Synthetic (Right) then
         raise Property_Error with "right node is synthetic";
      end if;
      --  Null nodes come first
      if Left = null then
         return Right /= null;
      elsif Right = null then
         return False;
      end if;
      --  So we have two non-null nodes. Sort by unit filename
      if Left.Unit < Right.Unit then
         return True;
      elsif Left.Unit /= Right.Unit then
         return False;
      end if;
      --  Both nodes come from the same unit: compare their token indexes
      if Left.Token_Start_Index < Right.Token_Start_Index then
         return True;
      elsif Left.Token_Start_Index > Right.Token_Start_Index then
         return False;
      else
         return Left.Token_End_Index < Right.Token_End_Index;
      end if;
   end "<";
   -------------
   -- Is_Null --
   -------------
   function Is_Null (Node : Bare_Ada_Node) return Boolean
   is (Node = null);
   ----------
   -- Kind --
   ----------
   function Kind (Node : Bare_Ada_Node) return Ada_Node_Kind_Type
   is (Node.Kind);
   -----------------
   -- Child_Index --
   -----------------
   function Child_Index (Node : Bare_Ada_Node) return Integer
   is
      N : Bare_Ada_Node := null;
   begin
      if Node.Parent = null then
         raise Property_Error with
            "Trying to get the child index of a root node";
      end if;
      for I in First_Child_Index (Node.Parent)
            .. Last_Child_Index (Node.Parent)
      loop
         N := Child (Node.Parent, I);
         if N = Node then
            return I - 1;
         end if;
      end loop;
      --  If we reach this point, then Node isn't a Child of Node.Parent. This
      --  is not supposed to happen.
      raise Program_Error;
   end Child_Index;
   -------------------
   -- Fetch_Sibling --
   -------------------
   function Fetch_Sibling
     (Node   : Bare_Ada_Node;
      E_Info : Internal_Entity_Info;
      Offset : Integer) return Internal_Entity
   is
      Node_Index : constant Positive := Child_Index (Node) + 1;
      --  Child_Index is 0-based, but the Child primitive expects a 1-based
      --  index.
      Sibling_Index : constant Integer := Node_Index + Offset;
      Sibling : constant Bare_Ada_Node :=
        (if Sibling_Index >= 1
         then Child (Node.Parent, Sibling_Index)
         else null);
      --  Child returns null for out-of-bound indexes
   begin
      --  Don't forget to clear entity info if the result is null
      return (if Sibling = null then No_Entity else (Sibling, E_Info));
   end Fetch_Sibling;
   ----------------------
   -- Previous_Sibling --
   ----------------------
   function Previous_Sibling
     (Node   : Bare_Ada_Node;
      E_Info : Internal_Entity_Info := No_Entity_Info)
      return Internal_Entity is
   begin
      return Fetch_Sibling (Node, E_Info, -1);
   end Previous_Sibling;
   ------------------
   -- Next_Sibling --
   ------------------
   function Next_Sibling
     (Node   : Bare_Ada_Node;
      E_Info : Internal_Entity_Info := No_Entity_Info)
      return Internal_Entity is
   begin
      return Fetch_Sibling (Node, E_Info, 1);
   end Next_Sibling;
      ----------
      -- Hash --
      ----------
      function Hash (R : Internal_Metadata) return Hash_Type is
      begin
            return Combine ((Hash (R.Dottable_Subp), Hash (R.Access_Entity), Hash (R.Primitive), Hash (R.Primitive_Real_Type)));
      end Hash;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Metadata) return String is
      begin
            return
              ("("
                     & "Dottable_Subp => " & Trace_Image (R.Dottable_Subp)
                        & ", "
                     & "Access_Entity => " & Trace_Image (R.Access_Entity)
                        & ", "
                     & "Primitive => " & Trace_Image (R.Primitive)
                        & ", "
                     & "Primitive_Real_Type => " & Trace_Image (R.Primitive_Real_Type)
               & ")");
      end Trace_Image;
   -------------
   -- Combine --
   -------------
   function Combine
     (L, R : Internal_Metadata) return Internal_Metadata
   is
      Ret : Internal_Metadata := No_Metadata;
   begin
         Ret.Dottable_Subp := L.Dottable_Subp or R.Dottable_Subp;
         Ret.Access_Entity := L.Access_Entity or R.Access_Entity;
         if L.Primitive = No_Bare_Ada_Node then
            Ret.Primitive := R.Primitive;
         elsif R.Primitive = No_Bare_Ada_Node then
            Ret.Primitive := L.Primitive;
         else
            raise Property_Error with "Wrong combine for metadata field";
         end if;
         if L.Primitive_Real_Type = No_Bare_Ada_Node then
            Ret.Primitive_Real_Type := R.Primitive_Real_Type;
         elsif R.Primitive_Real_Type = No_Bare_Ada_Node then
            Ret.Primitive_Real_Type := L.Primitive_Real_Type;
         else
            raise Property_Error with "Wrong combine for metadata field";
         end if;
      return Ret;
   end Combine;
   ---------
   -- Get --
   ---------
   function Get
     (A     : AST_Envs.Entity_Array;
      Index : Integer) return Internal_Entity
   is
      function Length (A : AST_Envs.Entity_Array) return Natural
      is (A'Length);
      function Get
        (A     : AST_Envs.Entity_Array;
         Index : Integer) return Internal_Entity
      is (A (Index + 1)); --  A is 1-based but Index is 0-based
      function Relative_Get is new Langkit_Support.Relative_Get
        (Item_Type     => Entity,
         Sequence_Type => AST_Envs.Entity_Array,
         Length        => Length,
         Get           => Get);
      Result : Internal_Entity;
   begin
      if Relative_Get (A, Index, Result) then
         return Result;
      else
         raise Property_Error with "out-of-bounds array access";
      end if;
   end Get;
   -----------
   -- Group --
   -----------
   function Group
     (Envs   : Lexical_Env_Array_Access;
      Env_Md : Internal_Metadata := No_Metadata) return Lexical_Env
   is (Group (AST_Envs.Lexical_Env_Array (Envs.Items), Env_Md));
      --
      --  Untyped wrappers for Bare_Ada_Node
      --
function Ada_Node_P_Resolve_Generic_Actual
  (E : Entity
  ) return Internal_Entity;
function Ada_Node_P_Use_Packages_In_Spec_Of_Subp_Body
  (E : Entity
  ) return Lexical_Env;
function Ada_Node_P_Nested_Generic_Formal_Part
  (E : Entity
  ) return Lexical_Env;
      --
      --  Untyped wrappers for Bare_Type_Decl
      --
function Type_Decl_P_Parent_Primitives_Env
  (E : Entity
  ) return Lexical_Env;
      --
      --  Untyped wrappers for Bare_Body_Node
      --
function Body_Node_P_Subunit_Decl_Env
  (E : Entity
  ) return Lexical_Env;
function Body_Node_P_Body_Decl_Scope
  (E : Entity
  ) return Lexical_Env;
      --
      --  Untyped wrappers for Bare_Package_Body
      --
function Package_Body_P_Package_Decl_Uses_Clauses_Envs
  (E : Entity
  ) return Lexical_Env;
      --
      --  Untyped wrappers for Bare_Task_Body
      --
function Task_Body_P_Task_Type_Decl_Scope
  (E : Entity
  ) return Lexical_Env;
      --
      --  Untyped wrappers for Bare_Generic_Subp_Instantiation
      --
function Generic_Subp_Instantiation_P_Designated_Subp
  (E : Entity
  ) return Internal_Entity;
      --
      --  Untyped wrappers for Bare_Name
      --
function Name_P_Name_Designated_Type_Env
  (E : Entity
  ) return Lexical_Env;
function Name_P_Use_Package_Name_Designated_Env
  (E : Entity
  ) return Lexical_Env;
   ------------------
   -- Children_Env --
   ------------------
   function Children_Env
     (Node   : Bare_Ada_Node;
      E_Info : Internal_Entity_Info := No_Entity_Info)
      return Lexical_Env
   is (Rebind_Env (Node.Self_Env, E_Info));
   --------------
   -- Node_Env --
   --------------
   function Node_Env
     (Node   : Bare_Ada_Node;
      E_Info : Internal_Entity_Info := No_Entity_Info)
      return Lexical_Env
   is
      function Get_Base_Env return Lexical_Env;
      --  Return the environment that we need to rebind before returning
      ------------------
      -- Get_Base_Env --
      ------------------
      function Get_Base_Env return Lexical_Env is
         function Get_Parent_Env return Lexical_Env;
         --------------------
         -- Get_Parent_Env --
         --------------------
         function Get_Parent_Env return Lexical_Env is
            Parent : constant Lexical_Env :=
               Get_Env (Node.Self_Env.Env.Parent, No_Entity_Info);
         begin
            --  If Node is the root scope or the empty environment, Parent can
            --  be a wrapper around the null node. Turn this into the
            --  Empty_Env, as null envs are erroneous values in properties.
            return (if Parent.Env = null
                    then Empty_Env
                    else Parent);
         end Get_Parent_Env;
      begin
         return
           (if Node.Kind in Ada_Generic_Package_Internal | Ada_Package_Decl | Ada_Incomplete_Type_Decl | Ada_Incomplete_Tagged_Type_Decl | Ada_Protected_Type_Decl | Ada_Task_Type_Decl | Ada_Single_Task_Type_Decl | Ada_Type_Decl | Ada_Abstract_Subp_Decl | Ada_Abstract_Formal_Subp_Decl | Ada_Concrete_Formal_Subp_Decl | Ada_Subp_Decl | Ada_Entry_Decl | Ada_Enum_Literal_Decl | Ada_Generic_Subp_Internal | Ada_Expr_Function | Ada_Null_Subp_Decl | Ada_Subp_Body | Ada_Subp_Renaming_Decl | Ada_Package_Body_Stub | Ada_Protected_Body_Stub | Ada_Subp_Body_Stub | Ada_Task_Body_Stub | Ada_Entry_Body | Ada_Package_Body | Ada_Protected_Body | Ada_Task_Body | Ada_Exception_Handler | Ada_Generic_Package_Decl | Ada_Generic_Subp_Decl | Ada_Generic_Package_Instantiation | Ada_Generic_Subp_Instantiation | Ada_Generic_Package_Renaming_Decl | Ada_Generic_Subp_Renaming_Decl | Ada_Package_Renaming_Decl | Ada_Single_Protected_Decl | Ada_Single_Task_Decl | Ada_Private_Part | Ada_Decl_Expr | Ada_Accept_Stmt | Ada_Accept_Stmt_With_Stmts | Ada_For_Loop_Stmt | Ada_Begin_Block | Ada_Decl_Block | Ada_Extended_Return_Stmt | Ada_Named_Stmt | Ada_Access_To_Subp_Def
            then Get_Parent_Env
            else Node.Self_Env);
      end Get_Base_Env;
      Base_Env : Lexical_Env := Get_Base_Env;
      Result   : constant Lexical_Env := Rebind_Env (Base_Env, E_Info);
   begin
      Dec_Ref (Base_Env);
      return Result;
   end Node_Env;
   ------------
   -- Parent --
   ------------
   function Parent
     (Node   : Bare_Ada_Node;
      E_Info : Internal_Entity_Info := No_Entity_Info)
      return Internal_Entity is
   begin
      --  TODO: shed entity information as appropriate
      return (Node.Parent, E_Info);
   end Parent;
   -------------
   -- Parents --
   -------------
   function Parents
     (Node   : Bare_Ada_Node;
      E_Info : Internal_Entity_Info := No_Entity_Info)
      return Internal_Entity_Array_Access
   is
      Bare_Parents : Bare_Ada_Node_Array_Access := Parents (Node);
      Result       : Internal_Entity_Array_Access :=
         Create_Internal_Entity_Array (Bare_Parents.N);
   begin
      --  TODO: shed entity information as appropriate
      for I in Bare_Parents.Items'Range loop
         Result.Items (I) := (Bare_Parents.Items (I), E_Info);
      end loop;
      Dec_Ref (Bare_Parents);
      return Result;
   end Parents;
   --------------
   -- Children --
   --------------
   function Children
     (Node   : Bare_Ada_Node;
      E_Info : Internal_Entity_Info := No_Entity_Info)
      return Internal_Entity_Array_Access
   is
      Bare_Children : Bare_Ada_Node_Array_Access := Children (Node);
      Result        : Internal_Entity_Array_Access :=
         Create_Internal_Entity_Array (Bare_Children.N);
   begin
      --  TODO: shed entity information as appropriate
      for I in Bare_Children.Items'Range loop
         Result.Items (I) := (Bare_Children.Items (I), E_Info);
      end loop;
      Dec_Ref (Bare_Children);
      return Result;
   end Children;
   --------------------------------
   -- Assign_Names_To_Logic_Vars --
   --------------------------------
   procedure Assign_Names_To_Logic_Vars (Node : Bare_Ada_Node) is
      procedure Assign
        (Node  : Bare_Ada_Node;
         LV    : in out Logic_Var_Record;
         Field : String);
      --  Assign a name to the LV logic variable. Node must be the node that
      --  owns LV, and Field must be the name of the field in Node that holds
      --  LV.
      ------------
      -- Assign --
      ------------
      procedure Assign
        (Node  : Bare_Ada_Node;
         LV    : in out Logic_Var_Record;
         Field : String) is
      begin
         LV.Dbg_Name := new String'
           (Image (Short_Text_Image (Node)) & "." & Field);
      end Assign;
      K : constant Ada_Node_Kind_Type := Node.Kind;
   begin
      case Ada_Ada_Node (K) is
when Ada_Target_Name_Range =>
declare
N_Bare_Target_Name : constant Bare_Target_Name := Node;
begin
Assign (N_Bare_Target_Name, N_Bare_Target_Name.Target_Name_R_Ref_Var, "Target_Name_R_Ref_Var");
end;
when Ada_Call_Expr_Range =>
declare
N_Bare_Call_Expr : constant Bare_Call_Expr := Node;
begin
Assign (N_Bare_Call_Expr, N_Bare_Call_Expr.Call_Expr_R_Called_Spec, "Call_Expr_R_Called_Spec");
end;
when Ada_Explicit_Deref_Range =>
declare
N_Bare_Explicit_Deref : constant Bare_Explicit_Deref := Node;
begin
Assign (N_Bare_Explicit_Deref, N_Bare_Explicit_Deref.Explicit_Deref_R_Called_Spec, "Explicit_Deref_R_Called_Spec");
end;
when Ada_Attribute_Ref_Range =>
declare
N_Bare_Attribute_Ref : constant Bare_Attribute_Ref := Node;
begin
Assign (N_Bare_Attribute_Ref, N_Bare_Attribute_Ref.Attribute_Ref_R_Ref_Var, "Attribute_Ref_R_Ref_Var");
end;
when others => null;
end case;
      for Child of Internal_Bare_Ada_Node_Array'(Children (Node)) loop
         if Child /= null then
            Assign_Names_To_Logic_Vars (Child);
         end if;
      end loop;
   end Assign_Names_To_Logic_Vars;
   ----------------
   -- Text_Image --
   ----------------
   function Text_Image (Ent : Internal_Entity) return Text_Type is
   begin
      if Ent.Node /= null then
         declare
            Node_Image : constant Text_Type := Short_Text_Image (Ent.Node);
         begin
            return
            (if Ent.Info.Rebindings /= null
             then "<| "
             & Node_Image (Node_Image'First + 1 .. Node_Image'Last - 1) & " "
             & AST_Envs.Text_Image (Ent.Info.Rebindings) & " |>"
             else Node_Image);
         end;
      else
         return "None";
      end if;
   end Text_Image;
   ---------------------
   -- Full_Sloc_Image --
   ---------------------
   function Full_Sloc_Image (Node : Bare_Ada_Node) return Character_Type_Array_Access
   is
      Res      : constant Text_Type :=
        To_Text
          (Ada.Directories.Simple_Name
             (Get_Filename (Unit (Node))))
           & ":" & To_Text (Image (Start_Sloc (Sloc_Range (Node)))) & ": ";
      Result : constant Character_Type_Array_Access :=
         Create_Character_Type_Array (Res'Length);
   begin
      Result.Items := Res;
      return Result;
   end Full_Sloc_Image;
   -----------
   -- Image --
   -----------
   function Image (Ent : Internal_Entity) return String is
      Result : constant Text_Type := Text_Image (Ent);
   begin
      return Image (Result);
   end Image;
   ---------------
   -- Can_Reach --
   ---------------
   function Can_Reach (El, From : Bare_Ada_Node) return Boolean is
   begin
      --  Since this function is only used to implement sequential semantics in
      --  envs, we consider that elements coming from different units are
      --  always visible for each other, and let the user implement language
      --  specific visibility rules in the DSL.
      if El = null or else From = null or else El.Unit /= From.Unit then
         return True;
      end if;
       return Compare
         (Start_Sloc (Sloc_Range (El)),
          Start_Sloc (Sloc_Range (From))) = After;
   end Can_Reach;
   function Create_Internal_Entity
     (Node : Bare_Ada_Node;
      Info : Internal_Entity_Info) return Internal_Entity is
   begin
      return (Node => Node, Info => Info);
   end;
   -----------------
   -- Hash_Entity --
   -----------------
   function Hash_Entity (Self : Internal_Entity) return Hash_Type is
   begin
      return Combine (Hash (Self.Node), Hash (Self.Info.Rebindings));
   end Hash_Entity;
   --------------------
   -- Compare_Entity --
   --------------------
   function Compare_Entity (Left, Right : Internal_Entity) return Boolean
   is
   begin
      return (Left.Node = Right.Node
              and then Left.Info.Rebindings = Right.Info.Rebindings);
   end Compare_Entity;
   procedure Destroy_Synthetic_Node (Node : in out Bare_Ada_Node);
   --  Helper for the Register_Destroyable above
   ------------
   -- Length --
   ------------
   function Length (Node : Bare_Ada_List) return Natural
   is (if Node = null then 0 else Children_Count (Node));
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (B : Boolean) return String is
      begin
         return (if B then "True" else "False");
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (I : Integer) return String is
      begin
         return Integer'Image (I);
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (S : Symbol_Type) return String is
      begin
         return (if S = null
                 then "None"
                 else Image (S.all, With_Quotes => True));
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (Env : Lexical_Env) return String is
      begin
         if Env.Kind = Primary then
            return "<LexicalEnv for " & Trace_Image (Env.Env.Node) & ">";
         else
            return "<LexicalEnv synthetic>";
         end if;
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (E : Internal_Entity) return String is
      begin
         if E.Node = null then
            return "None";
         else
            return ("<|" & Trace_Image (E.Node, Decoration => False)
                    & " " & Trace_Image (E.Info) & "|>");
         end if;
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (Info : Internal_Entity_Info) return String is
      begin
         return ("(MD => " & Trace_Image (Info.MD)
                 & ", Rebindings => " & Trace_Image (Info.Rebindings));
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Env_Rebindings) return String is
      begin
         return Image (Text_Image (R));
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (Unit : Internal_Unit) return String is
      begin
         return "Internal_Unit (""" & Basename (Unit) & """)";
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (Eq : Logic_Equation) return String is
         pragma Unreferenced (Eq);
      begin
         return "<LogicEquation>";
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (Var : Logic_Var) return String is
         pragma Unreferenced (Var);
      begin
         return "<LogicVariable>";
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (K : Analysis_Unit_Kind) return String is
      begin
         return Analysis_Unit_Kind'Image (K);
      end Trace_Image;
      function Create_Internal_Entity_Expr
        (Node : Bare_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Expr is
      begin
         if Node = null then
            return No_Entity_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Aspect) return String is
      begin
            return
              ("("
                     & "Exists => " & Trace_Image (R.Exists)
                        & ", "
                     & "Node => " & Trace_Image (R.Node)
                        & ", "
                     & "Value => " & Trace_Image (R.Value)
               & ")");
      end Trace_Image;
      function Create_Internal_Entity_Basic_Decl
        (Node : Bare_Basic_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Basic_Decl is
      begin
         if Node = null then
            return No_Entity_Basic_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      ----------
      -- Hash --
      ----------
      function Hash (R : Internal_Entity_Basic_Decl) return Hash_Type is
      begin
            return Combine
              (Hash (R.Node), Hash (R.Info));
      end Hash;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Basic_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Completion_Item) return String is
      begin
            return
              ("("
                     & "Decl => " & Trace_Image (R.Decl)
                        & ", "
                     & "Is_Dot_Call => " & Trace_Image (R.Is_Dot_Call)
                        & ", "
                     & "Is_Visible => " & Trace_Image (R.Is_Visible)
               & ")");
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Discrete_Range) return String is
      begin
            return
              ("("
                     & "Low_Bound => " & Trace_Image (R.Low_Bound)
                        & ", "
                     & "High_Bound => " & Trace_Image (R.High_Bound)
               & ")");
      end Trace_Image;
      function Create_Internal_Entity_Ada_List
        (Node : Bare_Ada_List; Info : Internal_Entity_Info)
         return Internal_Entity_Ada_List is
      begin
         if Node = null then
            return No_Entity_Ada_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Ada_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Ada_Node_List
        (Node : Bare_Ada_Node_List; Info : Internal_Entity_Info)
         return Internal_Entity_Ada_Node_List is
      begin
         if Node = null then
            return No_Entity_Ada_Node_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Ada_Node_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Alternatives_List
        (Node : Bare_Alternatives_List; Info : Internal_Entity_Info)
         return Internal_Entity_Alternatives_List is
      begin
         if Node = null then
            return No_Entity_Alternatives_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Alternatives_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Name
        (Node : Bare_Name; Info : Internal_Entity_Info)
         return Internal_Entity_Name is
      begin
         if Node = null then
            return No_Entity_Name;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Name) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Single_Tok_Node
        (Node : Bare_Single_Tok_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Single_Tok_Node is
      begin
         if Node = null then
            return No_Entity_Single_Tok_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Single_Tok_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Id
        (Node : Bare_Base_Id; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Id is
      begin
         if Node = null then
            return No_Entity_Base_Id;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Id) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Identifier
        (Node : Bare_Identifier; Info : Internal_Entity_Info)
         return Internal_Entity_Identifier is
      begin
         if Node = null then
            return No_Entity_Identifier;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Identifier) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Discriminant_Values) return String is
      begin
            return
              ("("
                     & "Discriminant => " & Trace_Image (R.Discriminant)
                        & ", "
                     & "Values => " & Trace_Image (R.Values)
               & ")");
      end Trace_Image;
      -------------
      -- Inc_Ref --
      -------------
      procedure Inc_Ref (R : Internal_Doc_Annotation) is
      begin
               Inc_Ref (R.Key);
               Inc_Ref (R.Value);
      end Inc_Ref;
      -------------
      -- Dec_Ref --
      -------------
      procedure Dec_Ref (R : in out Internal_Doc_Annotation) is
      begin
               Dec_Ref (R.Key);
               Dec_Ref (R.Value);
      end Dec_Ref;
      ----------------
      -- Equivalent --
      ----------------
      function Equivalent (L, R : Internal_Doc_Annotation) return Boolean is
      begin
         return Equivalent (L.Key, R.Key) and then Equivalent (L.Value, R.Value);
      end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Doc_Annotation) return String is
      begin
            return
              ("("
                     & "Key => " & Trace_Image (R.Key)
                        & ", "
                     & "Value => " & Trace_Image (R.Value)
               & ")");
      end Trace_Image;
      function Create_Internal_Entity_Abort_Node
        (Node : Bare_Abort_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Abort_Node is
      begin
         if Node = null then
            return No_Entity_Abort_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Abort_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Abort_Absent
        (Node : Bare_Abort_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Abort_Absent is
      begin
         if Node = null then
            return No_Entity_Abort_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Abort_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Abort_Present
        (Node : Bare_Abort_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Abort_Present is
      begin
         if Node = null then
            return No_Entity_Abort_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Abort_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Stmt
        (Node : Bare_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Stmt is
      begin
         if Node = null then
            return No_Entity_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Simple_Stmt
        (Node : Bare_Simple_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Simple_Stmt is
      begin
         if Node = null then
            return No_Entity_Simple_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Simple_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Abort_Stmt
        (Node : Bare_Abort_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Abort_Stmt is
      begin
         if Node = null then
            return No_Entity_Abort_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Abort_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Abstract_Node
        (Node : Bare_Abstract_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_Node is
      begin
         if Node = null then
            return No_Entity_Abstract_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Abstract_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Abstract_Absent
        (Node : Bare_Abstract_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_Absent is
      begin
         if Node = null then
            return No_Entity_Abstract_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Abstract_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Basic_Subp_Decl
        (Node : Bare_Basic_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Basic_Subp_Decl is
      begin
         if Node = null then
            return No_Entity_Basic_Subp_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Basic_Subp_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Classic_Subp_Decl
        (Node : Bare_Classic_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Classic_Subp_Decl is
      begin
         if Node = null then
            return No_Entity_Classic_Subp_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Classic_Subp_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Formal_Subp_Decl
        (Node : Bare_Formal_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Formal_Subp_Decl is
      begin
         if Node = null then
            return No_Entity_Formal_Subp_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Formal_Subp_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Abstract_Formal_Subp_Decl
        (Node : Bare_Abstract_Formal_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_Formal_Subp_Decl is
      begin
         if Node = null then
            return No_Entity_Abstract_Formal_Subp_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Abstract_Formal_Subp_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Abstract_Present
        (Node : Bare_Abstract_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_Present is
      begin
         if Node = null then
            return No_Entity_Abstract_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Abstract_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Abstract_Subp_Decl
        (Node : Bare_Abstract_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_Subp_Decl is
      begin
         if Node = null then
            return No_Entity_Abstract_Subp_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Abstract_Subp_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Composite_Stmt
        (Node : Bare_Composite_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Composite_Stmt is
      begin
         if Node = null then
            return No_Entity_Composite_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Composite_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Accept_Stmt
        (Node : Bare_Accept_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Accept_Stmt is
      begin
         if Node = null then
            return No_Entity_Accept_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Accept_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Accept_Stmt_With_Stmts
        (Node : Bare_Accept_Stmt_With_Stmts; Info : Internal_Entity_Info)
         return Internal_Entity_Accept_Stmt_With_Stmts is
      begin
         if Node = null then
            return No_Entity_Accept_Stmt_With_Stmts;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Accept_Stmt_With_Stmts) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Type_Def
        (Node : Bare_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Def is
      begin
         if Node = null then
            return No_Entity_Type_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Type_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Access_Def
        (Node : Bare_Access_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Access_Def is
      begin
         if Node = null then
            return No_Entity_Access_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Access_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Access_To_Subp_Def
        (Node : Bare_Access_To_Subp_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Access_To_Subp_Def is
      begin
         if Node = null then
            return No_Entity_Access_To_Subp_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Access_To_Subp_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Aggregate
        (Node : Bare_Base_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Aggregate is
      begin
         if Node = null then
            return No_Entity_Base_Aggregate;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Aggregate) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Aggregate
        (Node : Bare_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Aggregate is
      begin
         if Node = null then
            return No_Entity_Aggregate;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Aggregate) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Basic_Assoc
        (Node : Bare_Basic_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Basic_Assoc is
      begin
         if Node = null then
            return No_Entity_Basic_Assoc;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Basic_Assoc) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Aggregate_Assoc
        (Node : Bare_Aggregate_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Aggregate_Assoc is
      begin
         if Node = null then
            return No_Entity_Aggregate_Assoc;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Aggregate_Assoc) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Aliased_Node
        (Node : Bare_Aliased_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Aliased_Node is
      begin
         if Node = null then
            return No_Entity_Aliased_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Aliased_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Aliased_Absent
        (Node : Bare_Aliased_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Aliased_Absent is
      begin
         if Node = null then
            return No_Entity_Aliased_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Aliased_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Aliased_Present
        (Node : Bare_Aliased_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Aliased_Present is
      begin
         if Node = null then
            return No_Entity_Aliased_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Aliased_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_All_Node
        (Node : Bare_All_Node; Info : Internal_Entity_Info)
         return Internal_Entity_All_Node is
      begin
         if Node = null then
            return No_Entity_All_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_All_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_All_Absent
        (Node : Bare_All_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_All_Absent is
      begin
         if Node = null then
            return No_Entity_All_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_All_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_All_Present
        (Node : Bare_All_Present; Info : Internal_Entity_Info)
         return Internal_Entity_All_Present is
      begin
         if Node = null then
            return No_Entity_All_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_All_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Allocator
        (Node : Bare_Allocator; Info : Internal_Entity_Info)
         return Internal_Entity_Allocator is
      begin
         if Node = null then
            return No_Entity_Allocator;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Allocator) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Object_Decl
        (Node : Bare_Object_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Object_Decl is
      begin
         if Node = null then
            return No_Entity_Object_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Object_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Anonymous_Object_Decl
        (Node : Bare_Anonymous_Object_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Anonymous_Object_Decl is
      begin
         if Node = null then
            return No_Entity_Anonymous_Object_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Anonymous_Object_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Type_Expr
        (Node : Bare_Type_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Expr is
      begin
         if Node = null then
            return No_Entity_Type_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      ----------
      -- Hash --
      ----------
      function Hash (R : Internal_Entity_Type_Expr) return Hash_Type is
      begin
            return Combine
              (Hash (R.Node), Hash (R.Info));
      end Hash;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Type_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Anonymous_Type
        (Node : Bare_Anonymous_Type; Info : Internal_Entity_Info)
         return Internal_Entity_Anonymous_Type is
      begin
         if Node = null then
            return No_Entity_Anonymous_Type;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Anonymous_Type) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Type_Access_Def
        (Node : Bare_Base_Type_Access_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Type_Access_Def is
      begin
         if Node = null then
            return No_Entity_Base_Type_Access_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Type_Access_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Anonymous_Type_Access_Def
        (Node : Bare_Anonymous_Type_Access_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Anonymous_Type_Access_Def is
      begin
         if Node = null then
            return No_Entity_Anonymous_Type_Access_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Anonymous_Type_Access_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Type_Decl
        (Node : Bare_Base_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Type_Decl is
      begin
         if Node = null then
            return No_Entity_Base_Type_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      ----------
      -- Hash --
      ----------
      function Hash (R : Internal_Entity_Base_Type_Decl) return Hash_Type is
      begin
            return Combine
              (Hash (R.Node), Hash (R.Info));
      end Hash;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Type_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Type_Decl
        (Node : Bare_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Decl is
      begin
         if Node = null then
            return No_Entity_Type_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Type_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Anonymous_Type_Decl
        (Node : Bare_Anonymous_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Anonymous_Type_Decl is
      begin
         if Node = null then
            return No_Entity_Anonymous_Type_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Anonymous_Type_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Array_Indices
        (Node : Bare_Array_Indices; Info : Internal_Entity_Info)
         return Internal_Entity_Array_Indices is
      begin
         if Node = null then
            return No_Entity_Array_Indices;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Array_Indices) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Array_Type_Def
        (Node : Bare_Array_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Array_Type_Def is
      begin
         if Node = null then
            return No_Entity_Array_Type_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Array_Type_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Aspect_Assoc
        (Node : Bare_Aspect_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Aspect_Assoc is
      begin
         if Node = null then
            return No_Entity_Aspect_Assoc;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Aspect_Assoc) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Aspect_Assoc_List
        (Node : Bare_Aspect_Assoc_List; Info : Internal_Entity_Info)
         return Internal_Entity_Aspect_Assoc_List is
      begin
         if Node = null then
            return No_Entity_Aspect_Assoc_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Aspect_Assoc_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Aspect_Clause
        (Node : Bare_Aspect_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Aspect_Clause is
      begin
         if Node = null then
            return No_Entity_Aspect_Clause;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Aspect_Clause) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Aspect_Spec
        (Node : Bare_Aspect_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Aspect_Spec is
      begin
         if Node = null then
            return No_Entity_Aspect_Spec;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Aspect_Spec) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Assign_Stmt
        (Node : Bare_Assign_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Assign_Stmt is
      begin
         if Node = null then
            return No_Entity_Assign_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Assign_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Basic_Assoc_List
        (Node : Bare_Basic_Assoc_List; Info : Internal_Entity_Info)
         return Internal_Entity_Basic_Assoc_List is
      begin
         if Node = null then
            return No_Entity_Basic_Assoc_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Basic_Assoc_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Assoc_List
        (Node : Bare_Assoc_List; Info : Internal_Entity_Info)
         return Internal_Entity_Assoc_List is
      begin
         if Node = null then
            return No_Entity_Assoc_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Assoc_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_At_Clause
        (Node : Bare_At_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_At_Clause is
      begin
         if Node = null then
            return No_Entity_At_Clause;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_At_Clause) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Attribute_Def_Clause
        (Node : Bare_Attribute_Def_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Attribute_Def_Clause is
      begin
         if Node = null then
            return No_Entity_Attribute_Def_Clause;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Attribute_Def_Clause) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Attribute_Ref
        (Node : Bare_Attribute_Ref; Info : Internal_Entity_Info)
         return Internal_Entity_Attribute_Ref is
      begin
         if Node = null then
            return No_Entity_Attribute_Ref;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Attribute_Ref) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Assoc
        (Node : Bare_Base_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Assoc is
      begin
         if Node = null then
            return No_Entity_Base_Assoc;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Assoc) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Assoc_List
        (Node : Bare_Base_Assoc_List; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Assoc_List is
      begin
         if Node = null then
            return No_Entity_Base_Assoc_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Assoc_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Formal_Param_Decl
        (Node : Bare_Base_Formal_Param_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Formal_Param_Decl is
      begin
         if Node = null then
            return No_Entity_Base_Formal_Param_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Formal_Param_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Formal_Param_Holder
        (Node : Bare_Base_Formal_Param_Holder; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Formal_Param_Holder is
      begin
         if Node = null then
            return No_Entity_Base_Formal_Param_Holder;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Formal_Param_Holder) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Loop_Stmt
        (Node : Bare_Base_Loop_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Loop_Stmt is
      begin
         if Node = null then
            return No_Entity_Base_Loop_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Loop_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Package_Decl
        (Node : Bare_Base_Package_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Package_Decl is
      begin
         if Node = null then
            return No_Entity_Base_Package_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Package_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Record_Def
        (Node : Bare_Base_Record_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Record_Def is
      begin
         if Node = null then
            return No_Entity_Base_Record_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Record_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Body_Node
        (Node : Bare_Body_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Body_Node is
      begin
         if Node = null then
            return No_Entity_Body_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Body_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Subp_Body
        (Node : Bare_Base_Subp_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Subp_Body is
      begin
         if Node = null then
            return No_Entity_Base_Subp_Body;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Subp_Body) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Subp_Spec
        (Node : Bare_Base_Subp_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Subp_Spec is
      begin
         if Node = null then
            return No_Entity_Base_Subp_Spec;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Subp_Spec) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Base_Subtype_Decl
        (Node : Bare_Base_Subtype_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Subtype_Decl is
      begin
         if Node = null then
            return No_Entity_Base_Subtype_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Base_Subtype_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Basic_Decl_List
        (Node : Bare_Basic_Decl_List; Info : Internal_Entity_Info)
         return Internal_Entity_Basic_Decl_List is
      begin
         if Node = null then
            return No_Entity_Basic_Decl_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Basic_Decl_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Block_Stmt
        (Node : Bare_Block_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Block_Stmt is
      begin
         if Node = null then
            return No_Entity_Block_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Block_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Begin_Block
        (Node : Bare_Begin_Block; Info : Internal_Entity_Info)
         return Internal_Entity_Begin_Block is
      begin
         if Node = null then
            return No_Entity_Begin_Block;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Begin_Block) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Bin_Op
        (Node : Bare_Bin_Op; Info : Internal_Entity_Info)
         return Internal_Entity_Bin_Op is
      begin
         if Node = null then
            return No_Entity_Bin_Op;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Bin_Op) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Body_Stub
        (Node : Bare_Body_Stub; Info : Internal_Entity_Info)
         return Internal_Entity_Body_Stub is
      begin
         if Node = null then
            return No_Entity_Body_Stub;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Body_Stub) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Box_Expr
        (Node : Bare_Box_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Box_Expr is
      begin
         if Node = null then
            return No_Entity_Box_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Box_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Bracket_Aggregate
        (Node : Bare_Bracket_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Bracket_Aggregate is
      begin
         if Node = null then
            return No_Entity_Bracket_Aggregate;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Bracket_Aggregate) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Delta_Aggregate
        (Node : Bare_Delta_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Delta_Aggregate is
      begin
         if Node = null then
            return No_Entity_Delta_Aggregate;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Delta_Aggregate) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Bracket_Delta_Aggregate
        (Node : Bare_Bracket_Delta_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Bracket_Delta_Aggregate is
      begin
         if Node = null then
            return No_Entity_Bracket_Delta_Aggregate;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Bracket_Delta_Aggregate) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Call_Expr
        (Node : Bare_Call_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Call_Expr is
      begin
         if Node = null then
            return No_Entity_Call_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Call_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Call_Stmt
        (Node : Bare_Call_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Call_Stmt is
      begin
         if Node = null then
            return No_Entity_Call_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Call_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Cond_Expr
        (Node : Bare_Cond_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Cond_Expr is
      begin
         if Node = null then
            return No_Entity_Cond_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Cond_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Case_Expr
        (Node : Bare_Case_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Case_Expr is
      begin
         if Node = null then
            return No_Entity_Case_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Case_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Case_Expr_Alternative
        (Node : Bare_Case_Expr_Alternative; Info : Internal_Entity_Info)
         return Internal_Entity_Case_Expr_Alternative is
      begin
         if Node = null then
            return No_Entity_Case_Expr_Alternative;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Case_Expr_Alternative) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Case_Expr_Alternative_List
        (Node : Bare_Case_Expr_Alternative_List; Info : Internal_Entity_Info)
         return Internal_Entity_Case_Expr_Alternative_List is
      begin
         if Node = null then
            return No_Entity_Case_Expr_Alternative_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Case_Expr_Alternative_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Case_Stmt
        (Node : Bare_Case_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Case_Stmt is
      begin
         if Node = null then
            return No_Entity_Case_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Case_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Case_Stmt_Alternative
        (Node : Bare_Case_Stmt_Alternative; Info : Internal_Entity_Info)
         return Internal_Entity_Case_Stmt_Alternative is
      begin
         if Node = null then
            return No_Entity_Case_Stmt_Alternative;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Case_Stmt_Alternative) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Case_Stmt_Alternative_List
        (Node : Bare_Case_Stmt_Alternative_List; Info : Internal_Entity_Info)
         return Internal_Entity_Case_Stmt_Alternative_List is
      begin
         if Node = null then
            return No_Entity_Case_Stmt_Alternative_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Case_Stmt_Alternative_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Char_Literal
        (Node : Bare_Char_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_Char_Literal is
      begin
         if Node = null then
            return No_Entity_Char_Literal;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Char_Literal) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Classwide_Type_Decl
        (Node : Bare_Classwide_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Classwide_Type_Decl is
      begin
         if Node = null then
            return No_Entity_Classwide_Type_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Classwide_Type_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Compilation_Unit
        (Node : Bare_Compilation_Unit; Info : Internal_Entity_Info)
         return Internal_Entity_Compilation_Unit is
      begin
         if Node = null then
            return No_Entity_Compilation_Unit;
         end if;
         return (Node => Node, Info => Info);
      end;
      ----------
      -- Hash --
      ----------
      function Hash (R : Internal_Entity_Compilation_Unit) return Hash_Type is
      begin
            return Combine
              (Hash (R.Node), Hash (R.Info));
      end Hash;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Compilation_Unit) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Compilation_Unit_List
        (Node : Bare_Compilation_Unit_List; Info : Internal_Entity_Info)
         return Internal_Entity_Compilation_Unit_List is
      begin
         if Node = null then
            return No_Entity_Compilation_Unit_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Compilation_Unit_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Component_Clause
        (Node : Bare_Component_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Component_Clause is
      begin
         if Node = null then
            return No_Entity_Component_Clause;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Component_Clause) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Component_Decl
        (Node : Bare_Component_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Component_Decl is
      begin
         if Node = null then
            return No_Entity_Component_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Component_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Component_Def
        (Node : Bare_Component_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Component_Def is
      begin
         if Node = null then
            return No_Entity_Component_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Component_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Component_List
        (Node : Bare_Component_List; Info : Internal_Entity_Info)
         return Internal_Entity_Component_List is
      begin
         if Node = null then
            return No_Entity_Component_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Component_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Concrete_Formal_Subp_Decl
        (Node : Bare_Concrete_Formal_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Concrete_Formal_Subp_Decl is
      begin
         if Node = null then
            return No_Entity_Concrete_Formal_Subp_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Concrete_Formal_Subp_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Constant_Node
        (Node : Bare_Constant_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Constant_Node is
      begin
         if Node = null then
            return No_Entity_Constant_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Constant_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Constant_Absent
        (Node : Bare_Constant_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Constant_Absent is
      begin
         if Node = null then
            return No_Entity_Constant_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Constant_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Constant_Present
        (Node : Bare_Constant_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Constant_Present is
      begin
         if Node = null then
            return No_Entity_Constant_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Constant_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Constrained_Array_Indices
        (Node : Bare_Constrained_Array_Indices; Info : Internal_Entity_Info)
         return Internal_Entity_Constrained_Array_Indices is
      begin
         if Node = null then
            return No_Entity_Constrained_Array_Indices;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Constrained_Array_Indices) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Subtype_Indication
        (Node : Bare_Subtype_Indication; Info : Internal_Entity_Info)
         return Internal_Entity_Subtype_Indication is
      begin
         if Node = null then
            return No_Entity_Subtype_Indication;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Subtype_Indication) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Constrained_Subtype_Indication
        (Node : Bare_Constrained_Subtype_Indication; Info : Internal_Entity_Info)
         return Internal_Entity_Constrained_Subtype_Indication is
      begin
         if Node = null then
            return No_Entity_Constrained_Subtype_Indication;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Constrained_Subtype_Indication) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Constraint
        (Node : Bare_Constraint; Info : Internal_Entity_Info)
         return Internal_Entity_Constraint is
      begin
         if Node = null then
            return No_Entity_Constraint;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Constraint) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Constraint_List
        (Node : Bare_Constraint_List; Info : Internal_Entity_Info)
         return Internal_Entity_Constraint_List is
      begin
         if Node = null then
            return No_Entity_Constraint_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Constraint_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Contract_Case_Assoc
        (Node : Bare_Contract_Case_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Contract_Case_Assoc is
      begin
         if Node = null then
            return No_Entity_Contract_Case_Assoc;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Contract_Case_Assoc) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Contract_Case_Assoc_List
        (Node : Bare_Contract_Case_Assoc_List; Info : Internal_Entity_Info)
         return Internal_Entity_Contract_Case_Assoc_List is
      begin
         if Node = null then
            return No_Entity_Contract_Case_Assoc_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Contract_Case_Assoc_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Contract_Cases
        (Node : Bare_Contract_Cases; Info : Internal_Entity_Info)
         return Internal_Entity_Contract_Cases is
      begin
         if Node = null then
            return No_Entity_Contract_Cases;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Contract_Cases) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Real_Type_Def
        (Node : Bare_Real_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Real_Type_Def is
      begin
         if Node = null then
            return No_Entity_Real_Type_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Real_Type_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Decimal_Fixed_Point_Def
        (Node : Bare_Decimal_Fixed_Point_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Decimal_Fixed_Point_Def is
      begin
         if Node = null then
            return No_Entity_Decimal_Fixed_Point_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Decimal_Fixed_Point_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Decl_Block
        (Node : Bare_Decl_Block; Info : Internal_Entity_Info)
         return Internal_Entity_Decl_Block is
      begin
         if Node = null then
            return No_Entity_Decl_Block;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Decl_Block) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Decl_Expr
        (Node : Bare_Decl_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Decl_Expr is
      begin
         if Node = null then
            return No_Entity_Decl_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Decl_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Decl_List
        (Node : Bare_Decl_List; Info : Internal_Entity_Info)
         return Internal_Entity_Decl_List is
      begin
         if Node = null then
            return No_Entity_Decl_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Decl_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Declarative_Part
        (Node : Bare_Declarative_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Declarative_Part is
      begin
         if Node = null then
            return No_Entity_Declarative_Part;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Declarative_Part) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Defining_Name
        (Node : Bare_Defining_Name; Info : Internal_Entity_Info)
         return Internal_Entity_Defining_Name is
      begin
         if Node = null then
            return No_Entity_Defining_Name;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Defining_Name) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Defining_Name_List
        (Node : Bare_Defining_Name_List; Info : Internal_Entity_Info)
         return Internal_Entity_Defining_Name_List is
      begin
         if Node = null then
            return No_Entity_Defining_Name_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Defining_Name_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Delay_Stmt
        (Node : Bare_Delay_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Delay_Stmt is
      begin
         if Node = null then
            return No_Entity_Delay_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Delay_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Delta_Constraint
        (Node : Bare_Delta_Constraint; Info : Internal_Entity_Info)
         return Internal_Entity_Delta_Constraint is
      begin
         if Node = null then
            return No_Entity_Delta_Constraint;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Delta_Constraint) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Derived_Type_Def
        (Node : Bare_Derived_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Derived_Type_Def is
      begin
         if Node = null then
            return No_Entity_Derived_Type_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Derived_Type_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Digits_Constraint
        (Node : Bare_Digits_Constraint; Info : Internal_Entity_Info)
         return Internal_Entity_Digits_Constraint is
      begin
         if Node = null then
            return No_Entity_Digits_Constraint;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Digits_Constraint) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Discrete_Base_Subtype_Decl
        (Node : Bare_Discrete_Base_Subtype_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Discrete_Base_Subtype_Decl is
      begin
         if Node = null then
            return No_Entity_Discrete_Base_Subtype_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Discrete_Base_Subtype_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Discrete_Subtype_Indication
        (Node : Bare_Discrete_Subtype_Indication; Info : Internal_Entity_Info)
         return Internal_Entity_Discrete_Subtype_Indication is
      begin
         if Node = null then
            return No_Entity_Discrete_Subtype_Indication;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Discrete_Subtype_Indication) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Discrete_Subtype_Name
        (Node : Bare_Discrete_Subtype_Name; Info : Internal_Entity_Info)
         return Internal_Entity_Discrete_Subtype_Name is
      begin
         if Node = null then
            return No_Entity_Discrete_Subtype_Name;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Discrete_Subtype_Name) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Discriminant_Assoc
        (Node : Bare_Discriminant_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Discriminant_Assoc is
      begin
         if Node = null then
            return No_Entity_Discriminant_Assoc;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Discriminant_Assoc) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Identifier_List
        (Node : Bare_Identifier_List; Info : Internal_Entity_Info)
         return Internal_Entity_Identifier_List is
      begin
         if Node = null then
            return No_Entity_Identifier_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Identifier_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Discriminant_Choice_List
        (Node : Bare_Discriminant_Choice_List; Info : Internal_Entity_Info)
         return Internal_Entity_Discriminant_Choice_List is
      begin
         if Node = null then
            return No_Entity_Discriminant_Choice_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Discriminant_Choice_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Discriminant_Constraint
        (Node : Bare_Discriminant_Constraint; Info : Internal_Entity_Info)
         return Internal_Entity_Discriminant_Constraint is
      begin
         if Node = null then
            return No_Entity_Discriminant_Constraint;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Discriminant_Constraint) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Discriminant_Part
        (Node : Bare_Discriminant_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Discriminant_Part is
      begin
         if Node = null then
            return No_Entity_Discriminant_Part;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Discriminant_Part) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Discriminant_Spec
        (Node : Bare_Discriminant_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Discriminant_Spec is
      begin
         if Node = null then
            return No_Entity_Discriminant_Spec;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Discriminant_Spec) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Discriminant_Spec_List
        (Node : Bare_Discriminant_Spec_List; Info : Internal_Entity_Info)
         return Internal_Entity_Discriminant_Spec_List is
      begin
         if Node = null then
            return No_Entity_Discriminant_Spec_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Discriminant_Spec_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Dotted_Name
        (Node : Bare_Dotted_Name; Info : Internal_Entity_Info)
         return Internal_Entity_Dotted_Name is
      begin
         if Node = null then
            return No_Entity_Dotted_Name;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Dotted_Name) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Elsif_Expr_Part
        (Node : Bare_Elsif_Expr_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Elsif_Expr_Part is
      begin
         if Node = null then
            return No_Entity_Elsif_Expr_Part;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Elsif_Expr_Part) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Elsif_Expr_Part_List
        (Node : Bare_Elsif_Expr_Part_List; Info : Internal_Entity_Info)
         return Internal_Entity_Elsif_Expr_Part_List is
      begin
         if Node = null then
            return No_Entity_Elsif_Expr_Part_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Elsif_Expr_Part_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Elsif_Stmt_Part
        (Node : Bare_Elsif_Stmt_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Elsif_Stmt_Part is
      begin
         if Node = null then
            return No_Entity_Elsif_Stmt_Part;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Elsif_Stmt_Part) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Elsif_Stmt_Part_List
        (Node : Bare_Elsif_Stmt_Part_List; Info : Internal_Entity_Info)
         return Internal_Entity_Elsif_Stmt_Part_List is
      begin
         if Node = null then
            return No_Entity_Elsif_Stmt_Part_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Elsif_Stmt_Part_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_End_Name
        (Node : Bare_End_Name; Info : Internal_Entity_Info)
         return Internal_Entity_End_Name is
      begin
         if Node = null then
            return No_Entity_End_Name;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_End_Name) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Entry_Body
        (Node : Bare_Entry_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Entry_Body is
      begin
         if Node = null then
            return No_Entity_Entry_Body;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Entry_Body) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Entry_Completion_Formal_Params
        (Node : Bare_Entry_Completion_Formal_Params; Info : Internal_Entity_Info)
         return Internal_Entity_Entry_Completion_Formal_Params is
      begin
         if Node = null then
            return No_Entity_Entry_Completion_Formal_Params;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Entry_Completion_Formal_Params) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Entry_Decl
        (Node : Bare_Entry_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Entry_Decl is
      begin
         if Node = null then
            return No_Entity_Entry_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Entry_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Entry_Index_Spec
        (Node : Bare_Entry_Index_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Entry_Index_Spec is
      begin
         if Node = null then
            return No_Entity_Entry_Index_Spec;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Entry_Index_Spec) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Entry_Spec
        (Node : Bare_Entry_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Entry_Spec is
      begin
         if Node = null then
            return No_Entity_Entry_Spec;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Entry_Spec) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Enum_Lit_Synth_Type_Expr
        (Node : Bare_Enum_Lit_Synth_Type_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Enum_Lit_Synth_Type_Expr is
      begin
         if Node = null then
            return No_Entity_Enum_Lit_Synth_Type_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Enum_Lit_Synth_Type_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Enum_Literal_Decl
        (Node : Bare_Enum_Literal_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Enum_Literal_Decl is
      begin
         if Node = null then
            return No_Entity_Enum_Literal_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Enum_Literal_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Enum_Literal_Decl_List
        (Node : Bare_Enum_Literal_Decl_List; Info : Internal_Entity_Info)
         return Internal_Entity_Enum_Literal_Decl_List is
      begin
         if Node = null then
            return No_Entity_Enum_Literal_Decl_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Enum_Literal_Decl_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Enum_Rep_Clause
        (Node : Bare_Enum_Rep_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Enum_Rep_Clause is
      begin
         if Node = null then
            return No_Entity_Enum_Rep_Clause;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Enum_Rep_Clause) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Enum_Subp_Spec
        (Node : Bare_Enum_Subp_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Enum_Subp_Spec is
      begin
         if Node = null then
            return No_Entity_Enum_Subp_Spec;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Enum_Subp_Spec) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Enum_Type_Def
        (Node : Bare_Enum_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Enum_Type_Def is
      begin
         if Node = null then
            return No_Entity_Enum_Type_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Enum_Type_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Error_Decl
        (Node : Bare_Error_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Error_Decl is
      begin
         if Node = null then
            return No_Entity_Error_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Error_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Error_Stmt
        (Node : Bare_Error_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Error_Stmt is
      begin
         if Node = null then
            return No_Entity_Error_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Error_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Exception_Decl
        (Node : Bare_Exception_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Exception_Decl is
      begin
         if Node = null then
            return No_Entity_Exception_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Exception_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Exception_Handler
        (Node : Bare_Exception_Handler; Info : Internal_Entity_Info)
         return Internal_Entity_Exception_Handler is
      begin
         if Node = null then
            return No_Entity_Exception_Handler;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Exception_Handler) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Exit_Stmt
        (Node : Bare_Exit_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Exit_Stmt is
      begin
         if Node = null then
            return No_Entity_Exit_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Exit_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Explicit_Deref
        (Node : Bare_Explicit_Deref; Info : Internal_Entity_Info)
         return Internal_Entity_Explicit_Deref is
      begin
         if Node = null then
            return No_Entity_Explicit_Deref;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Explicit_Deref) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Expr_List
        (Node : Bare_Expr_List; Info : Internal_Entity_Info)
         return Internal_Entity_Expr_List is
      begin
         if Node = null then
            return No_Entity_Expr_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Expr_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Expr_Alternatives_List
        (Node : Bare_Expr_Alternatives_List; Info : Internal_Entity_Info)
         return Internal_Entity_Expr_Alternatives_List is
      begin
         if Node = null then
            return No_Entity_Expr_Alternatives_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Expr_Alternatives_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Expr_Function
        (Node : Bare_Expr_Function; Info : Internal_Entity_Info)
         return Internal_Entity_Expr_Function is
      begin
         if Node = null then
            return No_Entity_Expr_Function;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Expr_Function) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Extended_Return_Stmt
        (Node : Bare_Extended_Return_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Extended_Return_Stmt is
      begin
         if Node = null then
            return No_Entity_Extended_Return_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Extended_Return_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Extended_Return_Stmt_Object_Decl
        (Node : Bare_Extended_Return_Stmt_Object_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Extended_Return_Stmt_Object_Decl is
      begin
         if Node = null then
            return No_Entity_Extended_Return_Stmt_Object_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Extended_Return_Stmt_Object_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Floating_Point_Def
        (Node : Bare_Floating_Point_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Floating_Point_Def is
      begin
         if Node = null then
            return No_Entity_Floating_Point_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Floating_Point_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Loop_Spec
        (Node : Bare_Loop_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Loop_Spec is
      begin
         if Node = null then
            return No_Entity_Loop_Spec;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Loop_Spec) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_For_Loop_Spec
        (Node : Bare_For_Loop_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_For_Loop_Spec is
      begin
         if Node = null then
            return No_Entity_For_Loop_Spec;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_For_Loop_Spec) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_For_Loop_Stmt
        (Node : Bare_For_Loop_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_For_Loop_Stmt is
      begin
         if Node = null then
            return No_Entity_For_Loop_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_For_Loop_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_For_Loop_Var_Decl
        (Node : Bare_For_Loop_Var_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_For_Loop_Var_Decl is
      begin
         if Node = null then
            return No_Entity_For_Loop_Var_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_For_Loop_Var_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Formal_Discrete_Type_Def
        (Node : Bare_Formal_Discrete_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Formal_Discrete_Type_Def is
      begin
         if Node = null then
            return No_Entity_Formal_Discrete_Type_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Formal_Discrete_Type_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Decl
        (Node : Bare_Generic_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Decl is
      begin
         if Node = null then
            return No_Entity_Generic_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Formal
        (Node : Bare_Generic_Formal; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Formal is
      begin
         if Node = null then
            return No_Entity_Generic_Formal;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Formal) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Formal_Obj_Decl
        (Node : Bare_Generic_Formal_Obj_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Formal_Obj_Decl is
      begin
         if Node = null then
            return No_Entity_Generic_Formal_Obj_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Formal_Obj_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Formal_Package
        (Node : Bare_Generic_Formal_Package; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Formal_Package is
      begin
         if Node = null then
            return No_Entity_Generic_Formal_Package;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Formal_Package) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Formal_Part
        (Node : Bare_Generic_Formal_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Formal_Part is
      begin
         if Node = null then
            return No_Entity_Generic_Formal_Part;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Formal_Part) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Formal_Subp_Decl
        (Node : Bare_Generic_Formal_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Formal_Subp_Decl is
      begin
         if Node = null then
            return No_Entity_Generic_Formal_Subp_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Formal_Subp_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Formal_Type_Decl
        (Node : Bare_Generic_Formal_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Formal_Type_Decl is
      begin
         if Node = null then
            return No_Entity_Generic_Formal_Type_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Formal_Type_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Instantiation
        (Node : Bare_Generic_Instantiation; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Instantiation is
      begin
         if Node = null then
            return No_Entity_Generic_Instantiation;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Instantiation) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Package_Decl
        (Node : Bare_Generic_Package_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Package_Decl is
      begin
         if Node = null then
            return No_Entity_Generic_Package_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Package_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Package_Instantiation
        (Node : Bare_Generic_Package_Instantiation; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Package_Instantiation is
      begin
         if Node = null then
            return No_Entity_Generic_Package_Instantiation;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Package_Instantiation) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Package_Internal
        (Node : Bare_Generic_Package_Internal; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Package_Internal is
      begin
         if Node = null then
            return No_Entity_Generic_Package_Internal;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Package_Internal) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Renaming_Decl
        (Node : Bare_Generic_Renaming_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Renaming_Decl is
      begin
         if Node = null then
            return No_Entity_Generic_Renaming_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Renaming_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Package_Renaming_Decl
        (Node : Bare_Generic_Package_Renaming_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Package_Renaming_Decl is
      begin
         if Node = null then
            return No_Entity_Generic_Package_Renaming_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Package_Renaming_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Subp_Decl
        (Node : Bare_Generic_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Subp_Decl is
      begin
         if Node = null then
            return No_Entity_Generic_Subp_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Subp_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Subp_Instantiation
        (Node : Bare_Generic_Subp_Instantiation; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Subp_Instantiation is
      begin
         if Node = null then
            return No_Entity_Generic_Subp_Instantiation;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Subp_Instantiation) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Subp_Internal
        (Node : Bare_Generic_Subp_Internal; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Subp_Internal is
      begin
         if Node = null then
            return No_Entity_Generic_Subp_Internal;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Subp_Internal) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Generic_Subp_Renaming_Decl
        (Node : Bare_Generic_Subp_Renaming_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Subp_Renaming_Decl is
      begin
         if Node = null then
            return No_Entity_Generic_Subp_Renaming_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Generic_Subp_Renaming_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Goto_Stmt
        (Node : Bare_Goto_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Goto_Stmt is
      begin
         if Node = null then
            return No_Entity_Goto_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Goto_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Handled_Stmts
        (Node : Bare_Handled_Stmts; Info : Internal_Entity_Info)
         return Internal_Entity_Handled_Stmts is
      begin
         if Node = null then
            return No_Entity_Handled_Stmts;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Handled_Stmts) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_If_Expr
        (Node : Bare_If_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_If_Expr is
      begin
         if Node = null then
            return No_Entity_If_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_If_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_If_Stmt
        (Node : Bare_If_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_If_Stmt is
      begin
         if Node = null then
            return No_Entity_If_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_If_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Incomplete_Type_Decl
        (Node : Bare_Incomplete_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Incomplete_Type_Decl is
      begin
         if Node = null then
            return No_Entity_Incomplete_Type_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Incomplete_Type_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Incomplete_Tagged_Type_Decl
        (Node : Bare_Incomplete_Tagged_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Incomplete_Tagged_Type_Decl is
      begin
         if Node = null then
            return No_Entity_Incomplete_Tagged_Type_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Incomplete_Tagged_Type_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Index_Constraint
        (Node : Bare_Index_Constraint; Info : Internal_Entity_Info)
         return Internal_Entity_Index_Constraint is
      begin
         if Node = null then
            return No_Entity_Index_Constraint;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Index_Constraint) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Num_Literal
        (Node : Bare_Num_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_Num_Literal is
      begin
         if Node = null then
            return No_Entity_Num_Literal;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Num_Literal) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Int_Literal
        (Node : Bare_Int_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_Int_Literal is
      begin
         if Node = null then
            return No_Entity_Int_Literal;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Int_Literal) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Interface_Kind
        (Node : Bare_Interface_Kind; Info : Internal_Entity_Info)
         return Internal_Entity_Interface_Kind is
      begin
         if Node = null then
            return No_Entity_Interface_Kind;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Interface_Kind) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Interface_Kind_Limited
        (Node : Bare_Interface_Kind_Limited; Info : Internal_Entity_Info)
         return Internal_Entity_Interface_Kind_Limited is
      begin
         if Node = null then
            return No_Entity_Interface_Kind_Limited;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Interface_Kind_Limited) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Interface_Kind_Protected
        (Node : Bare_Interface_Kind_Protected; Info : Internal_Entity_Info)
         return Internal_Entity_Interface_Kind_Protected is
      begin
         if Node = null then
            return No_Entity_Interface_Kind_Protected;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Interface_Kind_Protected) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Interface_Kind_Synchronized
        (Node : Bare_Interface_Kind_Synchronized; Info : Internal_Entity_Info)
         return Internal_Entity_Interface_Kind_Synchronized is
      begin
         if Node = null then
            return No_Entity_Interface_Kind_Synchronized;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Interface_Kind_Synchronized) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Interface_Kind_Task
        (Node : Bare_Interface_Kind_Task; Info : Internal_Entity_Info)
         return Internal_Entity_Interface_Kind_Task is
      begin
         if Node = null then
            return No_Entity_Interface_Kind_Task;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Interface_Kind_Task) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Interface_Type_Def
        (Node : Bare_Interface_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Interface_Type_Def is
      begin
         if Node = null then
            return No_Entity_Interface_Type_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Interface_Type_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Iter_Type
        (Node : Bare_Iter_Type; Info : Internal_Entity_Info)
         return Internal_Entity_Iter_Type is
      begin
         if Node = null then
            return No_Entity_Iter_Type;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Iter_Type) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Iter_Type_In
        (Node : Bare_Iter_Type_In; Info : Internal_Entity_Info)
         return Internal_Entity_Iter_Type_In is
      begin
         if Node = null then
            return No_Entity_Iter_Type_In;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Iter_Type_In) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Iter_Type_Of
        (Node : Bare_Iter_Type_Of; Info : Internal_Entity_Info)
         return Internal_Entity_Iter_Type_Of is
      begin
         if Node = null then
            return No_Entity_Iter_Type_Of;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Iter_Type_Of) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Iterated_Assoc
        (Node : Bare_Iterated_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Iterated_Assoc is
      begin
         if Node = null then
            return No_Entity_Iterated_Assoc;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Iterated_Assoc) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Known_Discriminant_Part
        (Node : Bare_Known_Discriminant_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Known_Discriminant_Part is
      begin
         if Node = null then
            return No_Entity_Known_Discriminant_Part;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Known_Discriminant_Part) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Label
        (Node : Bare_Label; Info : Internal_Entity_Info)
         return Internal_Entity_Label is
      begin
         if Node = null then
            return No_Entity_Label;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Label) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Label_Decl
        (Node : Bare_Label_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Label_Decl is
      begin
         if Node = null then
            return No_Entity_Label_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Label_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Library_Item
        (Node : Bare_Library_Item; Info : Internal_Entity_Info)
         return Internal_Entity_Library_Item is
      begin
         if Node = null then
            return No_Entity_Library_Item;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Library_Item) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Limited_Node
        (Node : Bare_Limited_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Limited_Node is
      begin
         if Node = null then
            return No_Entity_Limited_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Limited_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Limited_Absent
        (Node : Bare_Limited_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Limited_Absent is
      begin
         if Node = null then
            return No_Entity_Limited_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Limited_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Limited_Present
        (Node : Bare_Limited_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Limited_Present is
      begin
         if Node = null then
            return No_Entity_Limited_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Limited_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Loop_Stmt
        (Node : Bare_Loop_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Loop_Stmt is
      begin
         if Node = null then
            return No_Entity_Loop_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Loop_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Membership_Expr
        (Node : Bare_Membership_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Membership_Expr is
      begin
         if Node = null then
            return No_Entity_Membership_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Membership_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Mod_Int_Type_Def
        (Node : Bare_Mod_Int_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Mod_Int_Type_Def is
      begin
         if Node = null then
            return No_Entity_Mod_Int_Type_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Mod_Int_Type_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Mode
        (Node : Bare_Mode; Info : Internal_Entity_Info)
         return Internal_Entity_Mode is
      begin
         if Node = null then
            return No_Entity_Mode;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Mode) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Mode_Default
        (Node : Bare_Mode_Default; Info : Internal_Entity_Info)
         return Internal_Entity_Mode_Default is
      begin
         if Node = null then
            return No_Entity_Mode_Default;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Mode_Default) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Mode_In
        (Node : Bare_Mode_In; Info : Internal_Entity_Info)
         return Internal_Entity_Mode_In is
      begin
         if Node = null then
            return No_Entity_Mode_In;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Mode_In) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Mode_In_Out
        (Node : Bare_Mode_In_Out; Info : Internal_Entity_Info)
         return Internal_Entity_Mode_In_Out is
      begin
         if Node = null then
            return No_Entity_Mode_In_Out;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Mode_In_Out) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Mode_Out
        (Node : Bare_Mode_Out; Info : Internal_Entity_Info)
         return Internal_Entity_Mode_Out is
      begin
         if Node = null then
            return No_Entity_Mode_Out;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Mode_Out) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Multi_Dim_Array_Assoc
        (Node : Bare_Multi_Dim_Array_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Multi_Dim_Array_Assoc is
      begin
         if Node = null then
            return No_Entity_Multi_Dim_Array_Assoc;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Multi_Dim_Array_Assoc) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Name_List
        (Node : Bare_Name_List; Info : Internal_Entity_Info)
         return Internal_Entity_Name_List is
      begin
         if Node = null then
            return No_Entity_Name_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Name_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Named_Stmt
        (Node : Bare_Named_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Named_Stmt is
      begin
         if Node = null then
            return No_Entity_Named_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Named_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Named_Stmt_Decl
        (Node : Bare_Named_Stmt_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Named_Stmt_Decl is
      begin
         if Node = null then
            return No_Entity_Named_Stmt_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Named_Stmt_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Not_Null
        (Node : Bare_Not_Null; Info : Internal_Entity_Info)
         return Internal_Entity_Not_Null is
      begin
         if Node = null then
            return No_Entity_Not_Null;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Not_Null) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Not_Null_Absent
        (Node : Bare_Not_Null_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Not_Null_Absent is
      begin
         if Node = null then
            return No_Entity_Not_Null_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Not_Null_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Not_Null_Present
        (Node : Bare_Not_Null_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Not_Null_Present is
      begin
         if Node = null then
            return No_Entity_Not_Null_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Not_Null_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Null_Component_Decl
        (Node : Bare_Null_Component_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Component_Decl is
      begin
         if Node = null then
            return No_Entity_Null_Component_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Null_Component_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Null_Literal
        (Node : Bare_Null_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Literal is
      begin
         if Node = null then
            return No_Entity_Null_Literal;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Null_Literal) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Null_Record_Aggregate
        (Node : Bare_Null_Record_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Record_Aggregate is
      begin
         if Node = null then
            return No_Entity_Null_Record_Aggregate;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Null_Record_Aggregate) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Null_Record_Def
        (Node : Bare_Null_Record_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Record_Def is
      begin
         if Node = null then
            return No_Entity_Null_Record_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Null_Record_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Null_Stmt
        (Node : Bare_Null_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Stmt is
      begin
         if Node = null then
            return No_Entity_Null_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Null_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Null_Subp_Decl
        (Node : Bare_Null_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Subp_Decl is
      begin
         if Node = null then
            return No_Entity_Null_Subp_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Null_Subp_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Number_Decl
        (Node : Bare_Number_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Number_Decl is
      begin
         if Node = null then
            return No_Entity_Number_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Number_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op
        (Node : Bare_Op; Info : Internal_Entity_Info)
         return Internal_Entity_Op is
      begin
         if Node = null then
            return No_Entity_Op;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Abs
        (Node : Bare_Op_Abs; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Abs is
      begin
         if Node = null then
            return No_Entity_Op_Abs;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Abs) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_And
        (Node : Bare_Op_And; Info : Internal_Entity_Info)
         return Internal_Entity_Op_And is
      begin
         if Node = null then
            return No_Entity_Op_And;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_And) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_And_Then
        (Node : Bare_Op_And_Then; Info : Internal_Entity_Info)
         return Internal_Entity_Op_And_Then is
      begin
         if Node = null then
            return No_Entity_Op_And_Then;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_And_Then) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Concat
        (Node : Bare_Op_Concat; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Concat is
      begin
         if Node = null then
            return No_Entity_Op_Concat;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Concat) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Div
        (Node : Bare_Op_Div; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Div is
      begin
         if Node = null then
            return No_Entity_Op_Div;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Div) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Double_Dot
        (Node : Bare_Op_Double_Dot; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Double_Dot is
      begin
         if Node = null then
            return No_Entity_Op_Double_Dot;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Double_Dot) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Eq
        (Node : Bare_Op_Eq; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Eq is
      begin
         if Node = null then
            return No_Entity_Op_Eq;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Eq) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Gt
        (Node : Bare_Op_Gt; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Gt is
      begin
         if Node = null then
            return No_Entity_Op_Gt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Gt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Gte
        (Node : Bare_Op_Gte; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Gte is
      begin
         if Node = null then
            return No_Entity_Op_Gte;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Gte) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_In
        (Node : Bare_Op_In; Info : Internal_Entity_Info)
         return Internal_Entity_Op_In is
      begin
         if Node = null then
            return No_Entity_Op_In;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_In) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Lt
        (Node : Bare_Op_Lt; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Lt is
      begin
         if Node = null then
            return No_Entity_Op_Lt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Lt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Lte
        (Node : Bare_Op_Lte; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Lte is
      begin
         if Node = null then
            return No_Entity_Op_Lte;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Lte) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Minus
        (Node : Bare_Op_Minus; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Minus is
      begin
         if Node = null then
            return No_Entity_Op_Minus;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Minus) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Mod
        (Node : Bare_Op_Mod; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Mod is
      begin
         if Node = null then
            return No_Entity_Op_Mod;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Mod) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Mult
        (Node : Bare_Op_Mult; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Mult is
      begin
         if Node = null then
            return No_Entity_Op_Mult;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Mult) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Neq
        (Node : Bare_Op_Neq; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Neq is
      begin
         if Node = null then
            return No_Entity_Op_Neq;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Neq) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Not
        (Node : Bare_Op_Not; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Not is
      begin
         if Node = null then
            return No_Entity_Op_Not;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Not) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Not_In
        (Node : Bare_Op_Not_In; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Not_In is
      begin
         if Node = null then
            return No_Entity_Op_Not_In;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Not_In) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Or
        (Node : Bare_Op_Or; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Or is
      begin
         if Node = null then
            return No_Entity_Op_Or;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Or) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Or_Else
        (Node : Bare_Op_Or_Else; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Or_Else is
      begin
         if Node = null then
            return No_Entity_Op_Or_Else;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Or_Else) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Plus
        (Node : Bare_Op_Plus; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Plus is
      begin
         if Node = null then
            return No_Entity_Op_Plus;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Plus) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Pow
        (Node : Bare_Op_Pow; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Pow is
      begin
         if Node = null then
            return No_Entity_Op_Pow;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Pow) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Rem
        (Node : Bare_Op_Rem; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Rem is
      begin
         if Node = null then
            return No_Entity_Op_Rem;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Rem) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Op_Xor
        (Node : Bare_Op_Xor; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Xor is
      begin
         if Node = null then
            return No_Entity_Op_Xor;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Op_Xor) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Ordinary_Fixed_Point_Def
        (Node : Bare_Ordinary_Fixed_Point_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Ordinary_Fixed_Point_Def is
      begin
         if Node = null then
            return No_Entity_Ordinary_Fixed_Point_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Ordinary_Fixed_Point_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Others_Designator
        (Node : Bare_Others_Designator; Info : Internal_Entity_Info)
         return Internal_Entity_Others_Designator is
      begin
         if Node = null then
            return No_Entity_Others_Designator;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Others_Designator) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Overriding_Node
        (Node : Bare_Overriding_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Overriding_Node is
      begin
         if Node = null then
            return No_Entity_Overriding_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Overriding_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Overriding_Not_Overriding
        (Node : Bare_Overriding_Not_Overriding; Info : Internal_Entity_Info)
         return Internal_Entity_Overriding_Not_Overriding is
      begin
         if Node = null then
            return No_Entity_Overriding_Not_Overriding;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Overriding_Not_Overriding) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Overriding_Overriding
        (Node : Bare_Overriding_Overriding; Info : Internal_Entity_Info)
         return Internal_Entity_Overriding_Overriding is
      begin
         if Node = null then
            return No_Entity_Overriding_Overriding;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Overriding_Overriding) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Overriding_Unspecified
        (Node : Bare_Overriding_Unspecified; Info : Internal_Entity_Info)
         return Internal_Entity_Overriding_Unspecified is
      begin
         if Node = null then
            return No_Entity_Overriding_Unspecified;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Overriding_Unspecified) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Package_Body
        (Node : Bare_Package_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Package_Body is
      begin
         if Node = null then
            return No_Entity_Package_Body;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Package_Body) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Package_Body_Stub
        (Node : Bare_Package_Body_Stub; Info : Internal_Entity_Info)
         return Internal_Entity_Package_Body_Stub is
      begin
         if Node = null then
            return No_Entity_Package_Body_Stub;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Package_Body_Stub) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Package_Decl
        (Node : Bare_Package_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Package_Decl is
      begin
         if Node = null then
            return No_Entity_Package_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Package_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Package_Renaming_Decl
        (Node : Bare_Package_Renaming_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Package_Renaming_Decl is
      begin
         if Node = null then
            return No_Entity_Package_Renaming_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Package_Renaming_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Param_Assoc
        (Node : Bare_Param_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Param_Assoc is
      begin
         if Node = null then
            return No_Entity_Param_Assoc;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Param_Assoc) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Param_Spec
        (Node : Bare_Param_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Param_Spec is
      begin
         if Node = null then
            return No_Entity_Param_Spec;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Param_Spec) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Param_Spec_List
        (Node : Bare_Param_Spec_List; Info : Internal_Entity_Info)
         return Internal_Entity_Param_Spec_List is
      begin
         if Node = null then
            return No_Entity_Param_Spec_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Param_Spec_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Params
        (Node : Bare_Params; Info : Internal_Entity_Info)
         return Internal_Entity_Params is
      begin
         if Node = null then
            return No_Entity_Params;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Params) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Paren_Expr
        (Node : Bare_Paren_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Paren_Expr is
      begin
         if Node = null then
            return No_Entity_Paren_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Paren_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Parent_List
        (Node : Bare_Parent_List; Info : Internal_Entity_Info)
         return Internal_Entity_Parent_List is
      begin
         if Node = null then
            return No_Entity_Parent_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Parent_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Pragma_Argument_Assoc
        (Node : Bare_Pragma_Argument_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Pragma_Argument_Assoc is
      begin
         if Node = null then
            return No_Entity_Pragma_Argument_Assoc;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Pragma_Argument_Assoc) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Pragma_Node
        (Node : Bare_Pragma_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Pragma_Node is
      begin
         if Node = null then
            return No_Entity_Pragma_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Pragma_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Pragma_Node_List
        (Node : Bare_Pragma_Node_List; Info : Internal_Entity_Info)
         return Internal_Entity_Pragma_Node_List is
      begin
         if Node = null then
            return No_Entity_Pragma_Node_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Pragma_Node_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Prim_Type_Accessor
        (Node : Bare_Prim_Type_Accessor; Info : Internal_Entity_Info)
         return Internal_Entity_Prim_Type_Accessor is
      begin
         if Node = null then
            return No_Entity_Prim_Type_Accessor;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Prim_Type_Accessor) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Private_Node
        (Node : Bare_Private_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Private_Node is
      begin
         if Node = null then
            return No_Entity_Private_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Private_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Private_Absent
        (Node : Bare_Private_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Private_Absent is
      begin
         if Node = null then
            return No_Entity_Private_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Private_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Private_Part
        (Node : Bare_Private_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Private_Part is
      begin
         if Node = null then
            return No_Entity_Private_Part;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Private_Part) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Private_Present
        (Node : Bare_Private_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Private_Present is
      begin
         if Node = null then
            return No_Entity_Private_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Private_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Private_Type_Def
        (Node : Bare_Private_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Private_Type_Def is
      begin
         if Node = null then
            return No_Entity_Private_Type_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Private_Type_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Protected_Node
        (Node : Bare_Protected_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Node is
      begin
         if Node = null then
            return No_Entity_Protected_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Protected_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Protected_Absent
        (Node : Bare_Protected_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Absent is
      begin
         if Node = null then
            return No_Entity_Protected_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Protected_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Protected_Body
        (Node : Bare_Protected_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Body is
      begin
         if Node = null then
            return No_Entity_Protected_Body;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Protected_Body) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Protected_Body_Stub
        (Node : Bare_Protected_Body_Stub; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Body_Stub is
      begin
         if Node = null then
            return No_Entity_Protected_Body_Stub;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Protected_Body_Stub) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Protected_Def
        (Node : Bare_Protected_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Def is
      begin
         if Node = null then
            return No_Entity_Protected_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Protected_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Protected_Present
        (Node : Bare_Protected_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Present is
      begin
         if Node = null then
            return No_Entity_Protected_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Protected_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Protected_Type_Decl
        (Node : Bare_Protected_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Type_Decl is
      begin
         if Node = null then
            return No_Entity_Protected_Type_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Protected_Type_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Public_Part
        (Node : Bare_Public_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Public_Part is
      begin
         if Node = null then
            return No_Entity_Public_Part;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Public_Part) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Qual_Expr
        (Node : Bare_Qual_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Qual_Expr is
      begin
         if Node = null then
            return No_Entity_Qual_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Qual_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Quantified_Expr
        (Node : Bare_Quantified_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Quantified_Expr is
      begin
         if Node = null then
            return No_Entity_Quantified_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Quantified_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Quantifier
        (Node : Bare_Quantifier; Info : Internal_Entity_Info)
         return Internal_Entity_Quantifier is
      begin
         if Node = null then
            return No_Entity_Quantifier;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Quantifier) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Quantifier_All
        (Node : Bare_Quantifier_All; Info : Internal_Entity_Info)
         return Internal_Entity_Quantifier_All is
      begin
         if Node = null then
            return No_Entity_Quantifier_All;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Quantifier_All) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Quantifier_Some
        (Node : Bare_Quantifier_Some; Info : Internal_Entity_Info)
         return Internal_Entity_Quantifier_Some is
      begin
         if Node = null then
            return No_Entity_Quantifier_Some;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Quantifier_Some) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Raise_Expr
        (Node : Bare_Raise_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Raise_Expr is
      begin
         if Node = null then
            return No_Entity_Raise_Expr;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Raise_Expr) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Raise_Stmt
        (Node : Bare_Raise_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Raise_Stmt is
      begin
         if Node = null then
            return No_Entity_Raise_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Raise_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Range_Constraint
        (Node : Bare_Range_Constraint; Info : Internal_Entity_Info)
         return Internal_Entity_Range_Constraint is
      begin
         if Node = null then
            return No_Entity_Range_Constraint;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Range_Constraint) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Range_Spec
        (Node : Bare_Range_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Range_Spec is
      begin
         if Node = null then
            return No_Entity_Range_Spec;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Range_Spec) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Real_Literal
        (Node : Bare_Real_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_Real_Literal is
      begin
         if Node = null then
            return No_Entity_Real_Literal;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Real_Literal) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Record_Def
        (Node : Bare_Record_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Record_Def is
      begin
         if Node = null then
            return No_Entity_Record_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Record_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Record_Rep_Clause
        (Node : Bare_Record_Rep_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Record_Rep_Clause is
      begin
         if Node = null then
            return No_Entity_Record_Rep_Clause;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Record_Rep_Clause) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Record_Type_Def
        (Node : Bare_Record_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Record_Type_Def is
      begin
         if Node = null then
            return No_Entity_Record_Type_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Record_Type_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Relation_Op
        (Node : Bare_Relation_Op; Info : Internal_Entity_Info)
         return Internal_Entity_Relation_Op is
      begin
         if Node = null then
            return No_Entity_Relation_Op;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Relation_Op) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Renaming_Clause
        (Node : Bare_Renaming_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Renaming_Clause is
      begin
         if Node = null then
            return No_Entity_Renaming_Clause;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Renaming_Clause) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Requeue_Stmt
        (Node : Bare_Requeue_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Requeue_Stmt is
      begin
         if Node = null then
            return No_Entity_Requeue_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Requeue_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Return_Stmt
        (Node : Bare_Return_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Return_Stmt is
      begin
         if Node = null then
            return No_Entity_Return_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Return_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Reverse_Node
        (Node : Bare_Reverse_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Reverse_Node is
      begin
         if Node = null then
            return No_Entity_Reverse_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Reverse_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Reverse_Absent
        (Node : Bare_Reverse_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Reverse_Absent is
      begin
         if Node = null then
            return No_Entity_Reverse_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Reverse_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Reverse_Present
        (Node : Bare_Reverse_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Reverse_Present is
      begin
         if Node = null then
            return No_Entity_Reverse_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Reverse_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Select_Stmt
        (Node : Bare_Select_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Select_Stmt is
      begin
         if Node = null then
            return No_Entity_Select_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Select_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Select_When_Part
        (Node : Bare_Select_When_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Select_When_Part is
      begin
         if Node = null then
            return No_Entity_Select_When_Part;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Select_When_Part) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Select_When_Part_List
        (Node : Bare_Select_When_Part_List; Info : Internal_Entity_Info)
         return Internal_Entity_Select_When_Part_List is
      begin
         if Node = null then
            return No_Entity_Select_When_Part_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Select_When_Part_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Signed_Int_Type_Def
        (Node : Bare_Signed_Int_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Signed_Int_Type_Def is
      begin
         if Node = null then
            return No_Entity_Signed_Int_Type_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Signed_Int_Type_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Single_Protected_Decl
        (Node : Bare_Single_Protected_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Single_Protected_Decl is
      begin
         if Node = null then
            return No_Entity_Single_Protected_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Single_Protected_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Single_Task_Decl
        (Node : Bare_Single_Task_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Single_Task_Decl is
      begin
         if Node = null then
            return No_Entity_Single_Task_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Single_Task_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Task_Type_Decl
        (Node : Bare_Task_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Task_Type_Decl is
      begin
         if Node = null then
            return No_Entity_Task_Type_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Task_Type_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Single_Task_Type_Decl
        (Node : Bare_Single_Task_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Single_Task_Type_Decl is
      begin
         if Node = null then
            return No_Entity_Single_Task_Type_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Single_Task_Type_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Stmt_List
        (Node : Bare_Stmt_List; Info : Internal_Entity_Info)
         return Internal_Entity_Stmt_List is
      begin
         if Node = null then
            return No_Entity_Stmt_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Stmt_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_String_Literal
        (Node : Bare_String_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_String_Literal is
      begin
         if Node = null then
            return No_Entity_String_Literal;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_String_Literal) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Subp_Body
        (Node : Bare_Subp_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Body is
      begin
         if Node = null then
            return No_Entity_Subp_Body;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Subp_Body) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Subp_Body_Stub
        (Node : Bare_Subp_Body_Stub; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Body_Stub is
      begin
         if Node = null then
            return No_Entity_Subp_Body_Stub;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Subp_Body_Stub) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Subp_Decl
        (Node : Bare_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Decl is
      begin
         if Node = null then
            return No_Entity_Subp_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Subp_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Subp_Kind
        (Node : Bare_Subp_Kind; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Kind is
      begin
         if Node = null then
            return No_Entity_Subp_Kind;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Subp_Kind) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Subp_Kind_Function
        (Node : Bare_Subp_Kind_Function; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Kind_Function is
      begin
         if Node = null then
            return No_Entity_Subp_Kind_Function;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Subp_Kind_Function) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Subp_Kind_Procedure
        (Node : Bare_Subp_Kind_Procedure; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Kind_Procedure is
      begin
         if Node = null then
            return No_Entity_Subp_Kind_Procedure;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Subp_Kind_Procedure) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Subp_Renaming_Decl
        (Node : Bare_Subp_Renaming_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Renaming_Decl is
      begin
         if Node = null then
            return No_Entity_Subp_Renaming_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Subp_Renaming_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Subp_Spec
        (Node : Bare_Subp_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Spec is
      begin
         if Node = null then
            return No_Entity_Subp_Spec;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Subp_Spec) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Subtype_Decl
        (Node : Bare_Subtype_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Subtype_Decl is
      begin
         if Node = null then
            return No_Entity_Subtype_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Subtype_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Subunit
        (Node : Bare_Subunit; Info : Internal_Entity_Info)
         return Internal_Entity_Subunit is
      begin
         if Node = null then
            return No_Entity_Subunit;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Subunit) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Synchronized_Node
        (Node : Bare_Synchronized_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Synchronized_Node is
      begin
         if Node = null then
            return No_Entity_Synchronized_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Synchronized_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Synchronized_Absent
        (Node : Bare_Synchronized_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Synchronized_Absent is
      begin
         if Node = null then
            return No_Entity_Synchronized_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Synchronized_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Synchronized_Present
        (Node : Bare_Synchronized_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Synchronized_Present is
      begin
         if Node = null then
            return No_Entity_Synchronized_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Synchronized_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Synth_Anonymous_Type_Decl
        (Node : Bare_Synth_Anonymous_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Synth_Anonymous_Type_Decl is
      begin
         if Node = null then
            return No_Entity_Synth_Anonymous_Type_Decl;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Synth_Anonymous_Type_Decl) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Synthetic_Renaming_Clause
        (Node : Bare_Synthetic_Renaming_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Synthetic_Renaming_Clause is
      begin
         if Node = null then
            return No_Entity_Synthetic_Renaming_Clause;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Synthetic_Renaming_Clause) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Tagged_Node
        (Node : Bare_Tagged_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Tagged_Node is
      begin
         if Node = null then
            return No_Entity_Tagged_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Tagged_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Tagged_Absent
        (Node : Bare_Tagged_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Tagged_Absent is
      begin
         if Node = null then
            return No_Entity_Tagged_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Tagged_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Tagged_Present
        (Node : Bare_Tagged_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Tagged_Present is
      begin
         if Node = null then
            return No_Entity_Tagged_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Tagged_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Target_Name
        (Node : Bare_Target_Name; Info : Internal_Entity_Info)
         return Internal_Entity_Target_Name is
      begin
         if Node = null then
            return No_Entity_Target_Name;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Target_Name) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Task_Body
        (Node : Bare_Task_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Task_Body is
      begin
         if Node = null then
            return No_Entity_Task_Body;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Task_Body) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Task_Body_Stub
        (Node : Bare_Task_Body_Stub; Info : Internal_Entity_Info)
         return Internal_Entity_Task_Body_Stub is
      begin
         if Node = null then
            return No_Entity_Task_Body_Stub;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Task_Body_Stub) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Task_Def
        (Node : Bare_Task_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Task_Def is
      begin
         if Node = null then
            return No_Entity_Task_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Task_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Terminate_Alternative
        (Node : Bare_Terminate_Alternative; Info : Internal_Entity_Info)
         return Internal_Entity_Terminate_Alternative is
      begin
         if Node = null then
            return No_Entity_Terminate_Alternative;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Terminate_Alternative) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Type_Access_Def
        (Node : Bare_Type_Access_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Access_Def is
      begin
         if Node = null then
            return No_Entity_Type_Access_Def;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Type_Access_Def) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Un_Op
        (Node : Bare_Un_Op; Info : Internal_Entity_Info)
         return Internal_Entity_Un_Op is
      begin
         if Node = null then
            return No_Entity_Un_Op;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Un_Op) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Unconstrained_Array_Index
        (Node : Bare_Unconstrained_Array_Index; Info : Internal_Entity_Info)
         return Internal_Entity_Unconstrained_Array_Index is
      begin
         if Node = null then
            return No_Entity_Unconstrained_Array_Index;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Unconstrained_Array_Index) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Unconstrained_Array_Index_List
        (Node : Bare_Unconstrained_Array_Index_List; Info : Internal_Entity_Info)
         return Internal_Entity_Unconstrained_Array_Index_List is
      begin
         if Node = null then
            return No_Entity_Unconstrained_Array_Index_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Unconstrained_Array_Index_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Unconstrained_Array_Indices
        (Node : Bare_Unconstrained_Array_Indices; Info : Internal_Entity_Info)
         return Internal_Entity_Unconstrained_Array_Indices is
      begin
         if Node = null then
            return No_Entity_Unconstrained_Array_Indices;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Unconstrained_Array_Indices) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Unknown_Discriminant_Part
        (Node : Bare_Unknown_Discriminant_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Unknown_Discriminant_Part is
      begin
         if Node = null then
            return No_Entity_Unknown_Discriminant_Part;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Unknown_Discriminant_Part) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Until_Node
        (Node : Bare_Until_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Until_Node is
      begin
         if Node = null then
            return No_Entity_Until_Node;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Until_Node) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Until_Absent
        (Node : Bare_Until_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Until_Absent is
      begin
         if Node = null then
            return No_Entity_Until_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Until_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Until_Present
        (Node : Bare_Until_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Until_Present is
      begin
         if Node = null then
            return No_Entity_Until_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Until_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Update_Attribute_Ref
        (Node : Bare_Update_Attribute_Ref; Info : Internal_Entity_Info)
         return Internal_Entity_Update_Attribute_Ref is
      begin
         if Node = null then
            return No_Entity_Update_Attribute_Ref;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Update_Attribute_Ref) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Use_Clause
        (Node : Bare_Use_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Use_Clause is
      begin
         if Node = null then
            return No_Entity_Use_Clause;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Use_Clause) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Use_Package_Clause
        (Node : Bare_Use_Package_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Use_Package_Clause is
      begin
         if Node = null then
            return No_Entity_Use_Package_Clause;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Use_Package_Clause) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Use_Type_Clause
        (Node : Bare_Use_Type_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Use_Type_Clause is
      begin
         if Node = null then
            return No_Entity_Use_Type_Clause;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Use_Type_Clause) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Variant
        (Node : Bare_Variant; Info : Internal_Entity_Info)
         return Internal_Entity_Variant is
      begin
         if Node = null then
            return No_Entity_Variant;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Variant) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Variant_List
        (Node : Bare_Variant_List; Info : Internal_Entity_Info)
         return Internal_Entity_Variant_List is
      begin
         if Node = null then
            return No_Entity_Variant_List;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Variant_List) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_Variant_Part
        (Node : Bare_Variant_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Variant_Part is
      begin
         if Node = null then
            return No_Entity_Variant_Part;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_Variant_Part) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_While_Loop_Spec
        (Node : Bare_While_Loop_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_While_Loop_Spec is
      begin
         if Node = null then
            return No_Entity_While_Loop_Spec;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_While_Loop_Spec) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_While_Loop_Stmt
        (Node : Bare_While_Loop_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_While_Loop_Stmt is
      begin
         if Node = null then
            return No_Entity_While_Loop_Stmt;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_While_Loop_Stmt) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_With_Clause
        (Node : Bare_With_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_With_Clause is
      begin
         if Node = null then
            return No_Entity_With_Clause;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_With_Clause) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_With_Private
        (Node : Bare_With_Private; Info : Internal_Entity_Info)
         return Internal_Entity_With_Private is
      begin
         if Node = null then
            return No_Entity_With_Private;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_With_Private) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_With_Private_Absent
        (Node : Bare_With_Private_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_With_Private_Absent is
      begin
         if Node = null then
            return No_Entity_With_Private_Absent;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_With_Private_Absent) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      function Create_Internal_Entity_With_Private_Present
        (Node : Bare_With_Private_Present; Info : Internal_Entity_Info)
         return Internal_Entity_With_Private_Present is
      begin
         if Node = null then
            return No_Entity_With_Private_Present;
         end if;
         return (Node => Node, Info => Info);
      end;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Entity_With_Private_Present) return String is
      begin
            return Image (Entity'(Node => R.Node, Info => R.Info));
      end Trace_Image;
      -------------
      -- Inc_Ref --
      -------------
      procedure Inc_Ref (R : Internal_Env_Assoc) is
      begin
               Inc_Ref (R.Dest_Env);
      end Inc_Ref;
      -------------
      -- Dec_Ref --
      -------------
      procedure Dec_Ref (R : in out Internal_Env_Assoc) is
      begin
               Dec_Ref (R.Dest_Env);
      end Dec_Ref;
      ----------------
      -- Equivalent --
      ----------------
      function Equivalent (L, R : Internal_Env_Assoc) return Boolean is
      begin
         return L.Key = R.Key and then L.Val = R.Val and then Equivalent (L.Dest_Env, R.Dest_Env) and then L.Metadata = R.Metadata;
      end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Env_Assoc) return String is
      begin
            return
              ("("
                     & "Key => " & Trace_Image (R.Key)
                        & ", "
                     & "Val => " & Trace_Image (R.Val)
                        & ", "
                     & "Dest_Env => " & Trace_Image (R.Dest_Env)
                        & ", "
                     & "Metadata => " & Trace_Image (R.Metadata)
               & ")");
      end Trace_Image;
      -------------
      -- Inc_Ref --
      -------------
      procedure Inc_Ref (R : Internal_Eval_Discrete_Range) is
      begin
               Inc_Ref (R.Low_Bound);
               Inc_Ref (R.High_Bound);
      end Inc_Ref;
      -------------
      -- Dec_Ref --
      -------------
      procedure Dec_Ref (R : in out Internal_Eval_Discrete_Range) is
      begin
               Dec_Ref (R.Low_Bound);
               Dec_Ref (R.High_Bound);
      end Dec_Ref;
      ----------------
      -- Equivalent --
      ----------------
      function Equivalent (L, R : Internal_Eval_Discrete_Range) return Boolean is
      begin
         return Equivalent (L.Low_Bound, R.Low_Bound) and then Equivalent (L.High_Bound, R.High_Bound);
      end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Eval_Discrete_Range) return String is
      begin
            return
              ("("
                     & "Low_Bound => " & Trace_Image (R.Low_Bound)
                        & ", "
                     & "High_Bound => " & Trace_Image (R.High_Bound)
               & ")");
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Expected_Type_For_Expr) return String is
      begin
            return
              ("("
                     & "Expected_Type => " & Trace_Image (R.Expected_Type)
                        & ", "
                     & "Expr => " & Trace_Image (R.Expr)
               & ")");
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Logic_Val_Result) return String is
      begin
            return
              ("("
                     & "Success => " & Trace_Image (R.Success)
                        & ", "
                     & "Value => " & Trace_Image (R.Value)
               & ")");
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Multidim_Aggregate_Info) return String is
      begin
            return
              ("("
                     & "Agg => " & Trace_Image (R.Agg)
                        & ", "
                     & "Typ => " & Trace_Image (R.Typ)
                        & ", "
                     & "Rank => " & Trace_Image (R.Rank)
               & ")");
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Param_Actual) return String is
      begin
            return
              ("("
                     & "Param => " & Trace_Image (R.Param)
                        & ", "
                     & "Actual => " & Trace_Image (R.Actual)
               & ")");
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Single_Actual) return String is
      begin
            return
              ("("
                     & "Name => " & Trace_Image (R.Name)
                        & ", "
                     & "Assoc => " & Trace_Image (R.Assoc)
               & ")");
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Single_Formal) return String is
      begin
            return
              ("("
                     & "Name => " & Trace_Image (R.Name)
                        & ", "
                     & "Spec => " & Trace_Image (R.Spec)
               & ")");
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Param_Match) return String is
      begin
            return
              ("("
                     & "Has_Matched => " & Trace_Image (R.Has_Matched)
                        & ", "
                     & "Actual => " & Trace_Image (R.Actual)
                        & ", "
                     & "Formal => " & Trace_Image (R.Formal)
               & ")");
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Ref_Result) return String is
      begin
            return
              ("("
                     & "Ref => " & Trace_Image (R.Ref)
                        & ", "
                     & "Kind => " & Trace_Image (R.Kind)
               & ")");
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Refd_Decl) return String is
      begin
            return
              ("("
                     & "Decl => " & Trace_Image (R.Decl)
                        & ", "
                     & "Kind => " & Trace_Image (R.Kind)
               & ")");
      end Trace_Image;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Refd_Def) return String is
      begin
            return
              ("("
                     & "Def_Name => " & Trace_Image (R.Def_Name)
                        & ", "
                     & "Kind => " & Trace_Image (R.Kind)
               & ")");
      end Trace_Image;
      -------------
      -- Inc_Ref --
      -------------
      procedure Inc_Ref (R : Internal_Shape) is
      begin
               Inc_Ref (R.Components);
               Inc_Ref (R.Discriminants_Values);
      end Inc_Ref;
      -------------
      -- Dec_Ref --
      -------------
      procedure Dec_Ref (R : in out Internal_Shape) is
      begin
               Dec_Ref (R.Components);
               Dec_Ref (R.Discriminants_Values);
      end Dec_Ref;
      ----------------
      -- Equivalent --
      ----------------
      function Equivalent (L, R : Internal_Shape) return Boolean is
      begin
         return Equivalent (L.Components, R.Components) and then Equivalent (L.Discriminants_Values, R.Discriminants_Values);
      end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Shape) return String is
      begin
            return
              ("("
                     & "Components => " & Trace_Image (R.Components)
                        & ", "
                     & "Discriminants_Values => " & Trace_Image (R.Discriminants_Values)
               & ")");
      end Trace_Image;
      -------------
      -- Inc_Ref --
      -------------
      procedure Inc_Ref (R : Internal_Substitution) is
      begin
               Inc_Ref (R.To_Value);
      end Inc_Ref;
      -------------
      -- Dec_Ref --
      -------------
      procedure Dec_Ref (R : in out Internal_Substitution) is
      begin
               Dec_Ref (R.To_Value);
      end Dec_Ref;
      ----------------
      -- Equivalent --
      ----------------
      function Equivalent (L, R : Internal_Substitution) return Boolean is
      begin
         return L.From_Decl = R.From_Decl and then Equivalent (L.To_Value, R.To_Value) and then L.Value_Type = R.Value_Type;
      end Equivalent;
      -----------------
      -- Trace_Image --
      -----------------
      function Trace_Image (R : Internal_Substitution) return String is
      begin
            return
              ("("
                     & "From_Decl => " & Trace_Image (R.From_Decl)
                        & ", "
                     & "To_Value => " & Trace_Image (R.To_Value)
                        & ", "
                     & "Value_Type => " & Trace_Image (R.Value_Type)
               & ")");
      end Trace_Image;
   pragma Warnings (Off, "referenced");
   type Logic_Converter_Default is null record;
   No_Logic_Converter_Default : constant Logic_Converter_Default :=
     (null record);
   function Convert
     (Self : Logic_Converter_Default;
      From : Internal_Entity) return Internal_Entity
   is
      pragma Unreferenced (Self);
   begin
      return From;
   end Convert;
   type Equals_Data_Default is null record;
   No_Equals_Data_Default : constant Equals_Data_Default := (null record);
   function Eq_Default
     (Data : Equals_Data_Default; L, R : Internal_Entity) return Boolean
   is (Equivalent (L, R))
      with Inline;
   pragma Warnings (On, "referenced");
   type Ada_Node_P_Is_Not_Null_0_Predicate_Caller is record
      Dbg_Img : String_Access := null;
   end record;
   function Create_Ada_Node_P_Is_Not_Null_0_Predicate (
      Dbg_Img : String_Access := null
   ) return Ada_Node_P_Is_Not_Null_0_Predicate_Caller is
   begin
      return Ada_Node_P_Is_Not_Null_0_Predicate_Caller'(
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Ada_Node_P_Is_Not_Null_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
         pragma Unreferenced (Self);
   begin
      return Ada_Node_P_Is_Not_Null (Node_0.Node, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Ada_Node_P_Is_Not_Null_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Ada_Node_P_Is_Not_Null_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Ada_Node_P_Is_Not_Null_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Ada_Node_P_Is_Not_Null_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Basic_Decl_P_Subp_Decl_Match_Signature_0_Predicate_Caller is record
         Field_0 : Internal_Entity_Basic_Decl;
      Dbg_Img : String_Access := null;
   end record;
   function Create_Basic_Decl_P_Subp_Decl_Match_Signature_0_Predicate (
         Field_0 : Internal_Entity_Basic_Decl;
      Dbg_Img : String_Access := null
   ) return Basic_Decl_P_Subp_Decl_Match_Signature_0_Predicate_Caller is
   begin
      return Basic_Decl_P_Subp_Decl_Match_Signature_0_Predicate_Caller'(
            Field_0 => Field_0,
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Basic_Decl_P_Subp_Decl_Match_Signature_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
   begin
      return Basic_Decl_P_Subp_Decl_Match_Signature (Node_0.Node, Self.Field_0, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Basic_Decl_P_Subp_Decl_Match_Signature_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Basic_Decl_P_Subp_Decl_Match_Signature_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Basic_Decl_P_Subp_Decl_Match_Signature_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Basic_Decl_P_Subp_Decl_Match_Signature_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Basic_Decl_P_Is_Subprogram_0_Predicate_Caller is record
      Dbg_Img : String_Access := null;
   end record;
   function Create_Basic_Decl_P_Is_Subprogram_0_Predicate (
      Dbg_Img : String_Access := null
   ) return Basic_Decl_P_Is_Subprogram_0_Predicate_Caller is
   begin
      return Basic_Decl_P_Is_Subprogram_0_Predicate_Caller'(
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Basic_Decl_P_Is_Subprogram_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
         pragma Unreferenced (Self);
   begin
      return Basic_Decl_P_Is_Subprogram (Node_0.Node);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Basic_Decl_P_Is_Subprogram_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Basic_Decl_P_Is_Subprogram_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Basic_Decl_P_Is_Subprogram_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Basic_Decl_P_Is_Subprogram_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Basic_Decl_P_Is_Stream_Subprogram_For_Type_0_Predicate_Caller is record
         Field_0 : Internal_Entity_Base_Type_Decl;
         Field_1 : Boolean;
      Dbg_Img : String_Access := null;
   end record;
   function Create_Basic_Decl_P_Is_Stream_Subprogram_For_Type_0_Predicate (
         Field_0 : Internal_Entity_Base_Type_Decl;
         Field_1 : Boolean;
      Dbg_Img : String_Access := null
   ) return Basic_Decl_P_Is_Stream_Subprogram_For_Type_0_Predicate_Caller is
   begin
      return Basic_Decl_P_Is_Stream_Subprogram_For_Type_0_Predicate_Caller'(
            Field_0 => Field_0,
            Field_1 => Field_1,
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Basic_Decl_P_Is_Stream_Subprogram_For_Type_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
   begin
      return Basic_Decl_P_Is_Stream_Subprogram_For_Type (Node_0.Node, Self.Field_0, Self.Field_1, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Basic_Decl_P_Is_Stream_Subprogram_For_Type_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Basic_Decl_P_Is_Stream_Subprogram_For_Type_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Basic_Decl_P_Is_Stream_Subprogram_For_Type_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Basic_Decl_P_Is_Stream_Subprogram_For_Type_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Base_Type_Decl_P_Is_Array_Or_Rec_0_Predicate_Caller is record
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null;
   end record;
   function Create_Base_Type_Decl_P_Is_Array_Or_Rec_0_Predicate (
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null
   ) return Base_Type_Decl_P_Is_Array_Or_Rec_0_Predicate_Caller is
   begin
      return Base_Type_Decl_P_Is_Array_Or_Rec_0_Predicate_Caller'(
            Field_0 => Field_0,
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Base_Type_Decl_P_Is_Array_Or_Rec_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
   begin
      return Base_Type_Decl_P_Is_Array_Or_Rec (Node_0.Node, Self.Field_0, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Base_Type_Decl_P_Is_Array_Or_Rec_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Base_Type_Decl_P_Is_Array_Or_Rec_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Base_Type_Decl_P_Is_Array_Or_Rec_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Base_Type_Decl_P_Is_Array_Or_Rec_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Base_Type_Decl_P_Is_Task_Type_0_Predicate_Caller is record
      Dbg_Img : String_Access := null;
   end record;
   function Create_Base_Type_Decl_P_Is_Task_Type_0_Predicate (
      Dbg_Img : String_Access := null
   ) return Base_Type_Decl_P_Is_Task_Type_0_Predicate_Caller is
   begin
      return Base_Type_Decl_P_Is_Task_Type_0_Predicate_Caller'(
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Base_Type_Decl_P_Is_Task_Type_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
         pragma Unreferenced (Self);
   begin
      return Dispatcher_Base_Type_Decl_P_Is_Task_Type (Node_0.Node);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Base_Type_Decl_P_Is_Task_Type_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Base_Type_Decl_P_Is_Task_Type_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Base_Type_Decl_P_Is_Task_Type_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Base_Type_Decl_P_Is_Task_Type_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Base_Type_Decl_P_Is_Char_Type_0_Predicate_Caller is record
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null;
   end record;
   function Create_Base_Type_Decl_P_Is_Char_Type_0_Predicate (
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null
   ) return Base_Type_Decl_P_Is_Char_Type_0_Predicate_Caller is
   begin
      return Base_Type_Decl_P_Is_Char_Type_0_Predicate_Caller'(
            Field_0 => Field_0,
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Base_Type_Decl_P_Is_Char_Type_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
   begin
      return Dispatcher_Base_Type_Decl_P_Is_Char_Type (Node_0.Node, Self.Field_0, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Base_Type_Decl_P_Is_Char_Type_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Base_Type_Decl_P_Is_Char_Type_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Base_Type_Decl_P_Is_Char_Type_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Base_Type_Decl_P_Is_Char_Type_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Base_Type_Decl_P_Is_Universal_Type_0_Predicate_Caller is record
      Dbg_Img : String_Access := null;
   end record;
   function Create_Base_Type_Decl_P_Is_Universal_Type_0_Predicate (
      Dbg_Img : String_Access := null
   ) return Base_Type_Decl_P_Is_Universal_Type_0_Predicate_Caller is
   begin
      return Base_Type_Decl_P_Is_Universal_Type_0_Predicate_Caller'(
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Base_Type_Decl_P_Is_Universal_Type_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
         pragma Unreferenced (Self);
   begin
      return Base_Type_Decl_P_Is_Universal_Type (Node_0.Node, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Base_Type_Decl_P_Is_Universal_Type_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Base_Type_Decl_P_Is_Universal_Type_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Base_Type_Decl_P_Is_Universal_Type_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Base_Type_Decl_P_Is_Universal_Type_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Base_Type_Decl_P_Is_Not_Universal_Type_0_Predicate_Caller is record
      Dbg_Img : String_Access := null;
   end record;
   function Create_Base_Type_Decl_P_Is_Not_Universal_Type_0_Predicate (
      Dbg_Img : String_Access := null
   ) return Base_Type_Decl_P_Is_Not_Universal_Type_0_Predicate_Caller is
   begin
      return Base_Type_Decl_P_Is_Not_Universal_Type_0_Predicate_Caller'(
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Base_Type_Decl_P_Is_Not_Universal_Type_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
         pragma Unreferenced (Self);
   begin
      return Base_Type_Decl_P_Is_Not_Universal_Type (Node_0.Node, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Base_Type_Decl_P_Is_Not_Universal_Type_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Base_Type_Decl_P_Is_Not_Universal_Type_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Base_Type_Decl_P_Is_Not_Universal_Type_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Base_Type_Decl_P_Is_Not_Universal_Type_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Base_Type_Decl_P_Is_Access_Type_Predicate_0_Predicate_Caller is record
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null;
   end record;
   function Create_Base_Type_Decl_P_Is_Access_Type_Predicate_0_Predicate (
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null
   ) return Base_Type_Decl_P_Is_Access_Type_Predicate_0_Predicate_Caller is
   begin
      return Base_Type_Decl_P_Is_Access_Type_Predicate_0_Predicate_Caller'(
            Field_0 => Field_0,
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Base_Type_Decl_P_Is_Access_Type_Predicate_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
   begin
      return Base_Type_Decl_P_Is_Access_Type_Predicate (Node_0.Node, Self.Field_0, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Base_Type_Decl_P_Is_Access_Type_Predicate_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Base_Type_Decl_P_Is_Access_Type_Predicate_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Base_Type_Decl_P_Is_Access_Type_Predicate_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Base_Type_Decl_P_Is_Access_Type_Predicate_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Base_Type_Decl_P_Is_Iterator_Type_0_Predicate_Caller is record
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null;
   end record;
   function Create_Base_Type_Decl_P_Is_Iterator_Type_0_Predicate (
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null
   ) return Base_Type_Decl_P_Is_Iterator_Type_0_Predicate_Caller is
   begin
      return Base_Type_Decl_P_Is_Iterator_Type_0_Predicate_Caller'(
            Field_0 => Field_0,
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Base_Type_Decl_P_Is_Iterator_Type_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
   begin
      return Base_Type_Decl_P_Is_Iterator_Type (Node_0.Node, Self.Field_0, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Base_Type_Decl_P_Is_Iterator_Type_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Base_Type_Decl_P_Is_Iterator_Type_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Base_Type_Decl_P_Is_Iterator_Type_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Base_Type_Decl_P_Is_Iterator_Type_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Base_Type_Decl_P_Is_Discrete_Type_0_Predicate_Caller is record
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null;
   end record;
   function Create_Base_Type_Decl_P_Is_Discrete_Type_0_Predicate (
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null
   ) return Base_Type_Decl_P_Is_Discrete_Type_0_Predicate_Caller is
   begin
      return Base_Type_Decl_P_Is_Discrete_Type_0_Predicate_Caller'(
            Field_0 => Field_0,
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Base_Type_Decl_P_Is_Discrete_Type_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
   begin
      return Dispatcher_Base_Type_Decl_P_Is_Discrete_Type (Node_0.Node, Self.Field_0, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Base_Type_Decl_P_Is_Discrete_Type_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Base_Type_Decl_P_Is_Discrete_Type_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Base_Type_Decl_P_Is_Discrete_Type_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Base_Type_Decl_P_Is_Discrete_Type_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Base_Type_Decl_P_Is_Str_Type_Or_Null_0_Predicate_Caller is record
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null;
   end record;
   function Create_Base_Type_Decl_P_Is_Str_Type_Or_Null_0_Predicate (
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null
   ) return Base_Type_Decl_P_Is_Str_Type_Or_Null_0_Predicate_Caller is
   begin
      return Base_Type_Decl_P_Is_Str_Type_Or_Null_0_Predicate_Caller'(
            Field_0 => Field_0,
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Base_Type_Decl_P_Is_Str_Type_Or_Null_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
   begin
      return Base_Type_Decl_P_Is_Str_Type_Or_Null (Node_0.Node, Self.Field_0, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Base_Type_Decl_P_Is_Str_Type_Or_Null_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Base_Type_Decl_P_Is_Str_Type_Or_Null_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Base_Type_Decl_P_Is_Str_Type_Or_Null_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Base_Type_Decl_P_Is_Str_Type_Or_Null_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Base_Type_Decl_P_Is_Subp_Access_Of_0_Predicate_Caller is record
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null;
   end record;
   function Create_Base_Type_Decl_P_Is_Subp_Access_Of_0_Predicate (
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null
   ) return Base_Type_Decl_P_Is_Subp_Access_Of_0_Predicate_Caller is
   begin
      return Base_Type_Decl_P_Is_Subp_Access_Of_0_Predicate_Caller'(
            Field_0 => Field_0,
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Base_Type_Decl_P_Is_Subp_Access_Of_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ; Node_1 : Internal_Entity
     ) return Boolean
   is
   begin
      return Base_Type_Decl_P_Is_Subp_Access_Of (Node_0.Node, (Node => Node_1.Node, Info => Node_1.Info), Self.Field_0, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Base_Type_Decl_P_Is_Subp_Access_Of_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Base_Type_Decl_P_Is_Subp_Access_Of_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Base_Type_Decl_P_Is_Subp_Access_Of_0_Pred is new Predicate_2
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Base_Type_Decl_P_Is_Subp_Access_Of_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Base_Type_Decl_P_Is_Array_Def_With_Deref_0_Predicate_Caller is record
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null;
   end record;
   function Create_Base_Type_Decl_P_Is_Array_Def_With_Deref_0_Predicate (
         Field_0 : Bare_Ada_Node;
      Dbg_Img : String_Access := null
   ) return Base_Type_Decl_P_Is_Array_Def_With_Deref_0_Predicate_Caller is
   begin
      return Base_Type_Decl_P_Is_Array_Def_With_Deref_0_Predicate_Caller'(
            Field_0 => Field_0,
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Base_Type_Decl_P_Is_Array_Def_With_Deref_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
   begin
      return Base_Type_Decl_P_Is_Array_Def_With_Deref (Node_0.Node, Self.Field_0, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Base_Type_Decl_P_Is_Array_Def_With_Deref_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Base_Type_Decl_P_Is_Array_Def_With_Deref_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Base_Type_Decl_P_Is_Array_Def_With_Deref_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Base_Type_Decl_P_Is_Array_Def_With_Deref_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   type Base_Type_Decl_P_Matching_Allocator_Type_0_Predicate_Caller is record
         Field_0 : Internal_Entity_Base_Type_Decl;
         Field_1 : Bare_Ada_Node;
      Dbg_Img : String_Access := null;
   end record;
   function Create_Base_Type_Decl_P_Matching_Allocator_Type_0_Predicate (
         Field_0 : Internal_Entity_Base_Type_Decl;
         Field_1 : Bare_Ada_Node;
      Dbg_Img : String_Access := null
   ) return Base_Type_Decl_P_Matching_Allocator_Type_0_Predicate_Caller is
   begin
      return Base_Type_Decl_P_Matching_Allocator_Type_0_Predicate_Caller'(
            Field_0 => Field_0,
            Field_1 => Field_1,
         Dbg_Img => Dbg_Img
      );
   end;
   ----------
   -- Call --
   ----------
   function Call
     (Self       : Base_Type_Decl_P_Matching_Allocator_Type_0_Predicate_Caller
     ; Node_0 : Internal_Entity
     ) return Boolean
   is
   begin
      return Base_Type_Decl_P_Matching_Allocator_Type (Node_0.Node, Self.Field_0, Self.Field_1, E_Info => Node_0.Info);
   end Call;
   -----------
   -- Image --
   -----------
   function Image (Self : Base_Type_Decl_P_Matching_Allocator_Type_0_Predicate_Caller) return String
   is (if Self.Dbg_Img /= null then Self.Dbg_Img.all else "");
   ----------
   -- Free --
   ----------
   procedure Free (Self : in out Base_Type_Decl_P_Matching_Allocator_Type_0_Predicate_Caller) is
      procedure Free is new Ada.Unchecked_Deallocation (String, String_Access);
   begin
      Free (Self.Dbg_Img);
   end Free;
   package Base_Type_Decl_P_Matching_Allocator_Type_0_Pred is new Predicate_1
     (El_Type        => Internal_Entity,
      Var            => Eq_Node.Refs.Raw_Logic_Var,
      Predicate_Type => Base_Type_Decl_P_Matching_Allocator_Type_0_Predicate_Caller,
      Free           => Free,
      Image          => Image);
   package Bind_Default_Default is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_Default,
      No_Data          => No_Logic_Converter_Default,
      Equals_Data      => Equals_Data_Default,
      No_Equals_Data   => No_Equals_Data_Default,
      Convert          => Convert,
      Equals           => Eq_Default,
      Convert_Image    =>
        "",
      Equals_Image     => "",
      One_Side_Convert => False
      );
   type Logic_Converter_475 is
      null record;
   No_Logic_Converter_475 : constant Logic_Converter_475 := (
         null record
   );
   function Convert (Self : Logic_Converter_475; From : Internal_Entity) return Internal_Entity
      with Inline;
   -------------
   -- Convert --
   -------------
   function Convert (Self : Logic_Converter_475; From : Internal_Entity) return Internal_Entity is
         pragma Unreferenced (Self);
      Ret : Internal_Entity_Base_Type_Decl;
   begin
      Ret := Base_Type_Decl_P_Anonymous_Access_Type_Or_Null
        (Node => From.Node,
         E_Info => From.Info);
      return (Node => Ret.Node, Info => Ret.Info);
   end Convert;
   type Equals_Data_535 is
      record
            Origin : Bare_Ada_Node;
      end record;
   No_Equals_Data_535 : constant Equals_Data_535 := (
         Origin => No_Bare_Ada_Node
   );
   function Eq_535
     (Data : Equals_Data_535; L, R : Internal_Entity) return Boolean is
   begin
      --  If any node pointer is null, then use that for equality
      if L.Node = null or else R.Node = null then
         return L.Node = R.Node;
      end if;
      --  Check that both arguments have appropriate types for the property
      --  call.
      if L.Node.Kind not in Ada_Base_Type_Decl then
         raise Property_Error with
            "Wrong type for BaseTypeDecl.matching_prefix_type's ""self"" argument";
      elsif R.Node.Kind not in Ada_Base_Type_Decl then
         raise Property_Error with
            "Wrong type for BaseTypeDecl.matching_prefix_type's"
            & " ""container_type"" argument";
      end if;
      --  All is good: do the call
      declare
         R_Entity : constant Internal_Entity_Base_Type_Decl := (R.Node, R.Info);
      begin
         return Base_Type_Decl_P_Matching_Prefix_Type
          (Node             => L.Node,
           Container_Type => R_Entity,
              Origin => Data.Origin,
           E_Info          => L.Info);
       end;
   end Eq_535;
   package Bind_475_535 is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_475,
      No_Data          => No_Logic_Converter_475,
      Equals_Data      => Equals_Data_535,
      No_Equals_Data   => No_Equals_Data_535,
      Convert          => Convert,
      Equals           => Eq_535,
      Convert_Image    =>
        "BaseTypeDecl.anonymous_access_type_or_null",
      Equals_Image     => "BaseTypeDecl.matching_prefix_type",
      One_Side_Convert => True
      );
   type Logic_Converter_545 is
      record
            Origin : Bare_Ada_Node;
      end record;
   No_Logic_Converter_545 : constant Logic_Converter_545 := (
         Origin => No_Bare_Ada_Node
   );
   function Convert (Self : Logic_Converter_545; From : Internal_Entity) return Internal_Entity
      with Inline;
   -------------
   -- Convert --
   -------------
   function Convert (Self : Logic_Converter_545; From : Internal_Entity) return Internal_Entity is
      Ret : Internal_Entity_Base_Type_Decl;
   begin
      Ret := Base_Type_Decl_P_Base_Subtype_Or_Null
        (Node => From.Node,
            Origin => Self.Origin,
         E_Info => From.Info);
      return (Node => Ret.Node, Info => Ret.Info);
   end Convert;
   type Equals_Data_542 is
      record
            Origin : Bare_Ada_Node;
      end record;
   No_Equals_Data_542 : constant Equals_Data_542 := (
         Origin => No_Bare_Ada_Node
   );
   function Eq_542
     (Data : Equals_Data_542; L, R : Internal_Entity) return Boolean is
   begin
      --  If any node pointer is null, then use that for equality
      if L.Node = null or else R.Node = null then
         return L.Node = R.Node;
      end if;
      --  Check that both arguments have appropriate types for the property
      --  call.
      if L.Node.Kind not in Ada_Base_Type_Decl then
         raise Property_Error with
            "Wrong type for BaseTypeDecl.matching_type's ""self"" argument";
      elsif R.Node.Kind not in Ada_Base_Type_Decl then
         raise Property_Error with
            "Wrong type for BaseTypeDecl.matching_type's"
            & " ""expected_type"" argument";
      end if;
      --  All is good: do the call
      declare
         R_Entity : constant Internal_Entity_Base_Type_Decl := (R.Node, R.Info);
      begin
         return Base_Type_Decl_P_Matching_Type
          (Node             => L.Node,
           Expected_Type => R_Entity,
              Origin => Data.Origin,
           E_Info          => L.Info);
       end;
   end Eq_542;
   package Bind_545_542 is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_545,
      No_Data          => No_Logic_Converter_545,
      Equals_Data      => Equals_Data_542,
      No_Equals_Data   => No_Equals_Data_542,
      Convert          => Convert,
      Equals           => Eq_542,
      Convert_Image    =>
        "BaseTypeDecl.base_subtype_or_null",
      Equals_Image     => "BaseTypeDecl.matching_type",
      One_Side_Convert => True
      );
   type Logic_Converter_528 is
      record
            Origin : Bare_Ada_Node;
      end record;
   No_Logic_Converter_528 : constant Logic_Converter_528 := (
         Origin => No_Bare_Ada_Node
   );
   function Convert (Self : Logic_Converter_528; From : Internal_Entity) return Internal_Entity
      with Inline;
   -------------
   -- Convert --
   -------------
   function Convert (Self : Logic_Converter_528; From : Internal_Entity) return Internal_Entity is
      Ret : Internal_Entity_Base_Type_Decl;
   begin
      Ret := Base_Type_Decl_P_Comp_Type
        (Node => From.Node,
            Origin => Self.Origin,
         E_Info => From.Info);
      return (Node => Ret.Node, Info => Ret.Info);
   end Convert;
   package Bind_528_542 is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_528,
      No_Data          => No_Logic_Converter_528,
      Equals_Data      => Equals_Data_542,
      No_Equals_Data   => No_Equals_Data_542,
      Convert          => Convert,
      Equals           => Eq_542,
      Convert_Image    =>
        "BaseTypeDecl.comp_type",
      Equals_Image     => "BaseTypeDecl.matching_type",
      One_Side_Convert => True
      );
   type Equals_Data_541 is
      record
            Origin : Bare_Ada_Node;
      end record;
   No_Equals_Data_541 : constant Equals_Data_541 := (
         Origin => No_Bare_Ada_Node
   );
   function Eq_541
     (Data : Equals_Data_541; L, R : Internal_Entity) return Boolean is
   begin
      --  If any node pointer is null, then use that for equality
      if L.Node = null or else R.Node = null then
         return L.Node = R.Node;
      end if;
      --  Check that both arguments have appropriate types for the property
      --  call.
      if L.Node.Kind not in Ada_Base_Type_Decl then
         raise Property_Error with
            "Wrong type for BaseTypeDecl.matching_assign_type's ""self"" argument";
      elsif R.Node.Kind not in Ada_Base_Type_Decl then
         raise Property_Error with
            "Wrong type for BaseTypeDecl.matching_assign_type's"
            & " ""expected_type"" argument";
      end if;
      --  All is good: do the call
      declare
         R_Entity : constant Internal_Entity_Base_Type_Decl := (R.Node, R.Info);
      begin
         return Base_Type_Decl_P_Matching_Assign_Type
          (Node             => L.Node,
           Expected_Type => R_Entity,
              Origin => Data.Origin,
           E_Info          => L.Info);
       end;
   end Eq_541;
   package Bind_Default_541 is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_Default,
      No_Data          => No_Logic_Converter_Default,
      Equals_Data      => Equals_Data_541,
      No_Equals_Data   => No_Equals_Data_541,
      Convert          => Convert,
      Equals           => Eq_541,
      Convert_Image    =>
        "",
      Equals_Image     => "BaseTypeDecl.matching_assign_type",
      One_Side_Convert => False
      );
   type Equals_Data_537 is
      record
            Origin : Bare_Ada_Node;
      end record;
   No_Equals_Data_537 : constant Equals_Data_537 := (
         Origin => No_Bare_Ada_Node
   );
   function Eq_537
     (Data : Equals_Data_537; L, R : Internal_Entity) return Boolean is
   begin
      --  If any node pointer is null, then use that for equality
      if L.Node = null or else R.Node = null then
         return L.Node = R.Node;
      end if;
      --  Check that both arguments have appropriate types for the property
      --  call.
      if L.Node.Kind not in Ada_Base_Type_Decl then
         raise Property_Error with
            "Wrong type for BaseTypeDecl.matching_formal_prim_type's ""self"" argument";
      elsif R.Node.Kind not in Ada_Base_Type_Decl then
         raise Property_Error with
            "Wrong type for BaseTypeDecl.matching_formal_prim_type's"
            & " ""formal_type"" argument";
      end if;
      --  All is good: do the call
      declare
         R_Entity : constant Internal_Entity_Base_Type_Decl := (R.Node, R.Info);
      begin
         return Base_Type_Decl_P_Matching_Formal_Prim_Type
          (Node             => L.Node,
           Formal_Type => R_Entity,
              Origin => Data.Origin,
           E_Info          => L.Info);
       end;
   end Eq_537;
   package Bind_Default_537 is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_Default,
      No_Data          => No_Logic_Converter_Default,
      Equals_Data      => Equals_Data_537,
      No_Equals_Data   => No_Equals_Data_537,
      Convert          => Convert,
      Equals           => Eq_537,
      Convert_Image    =>
        "",
      Equals_Image     => "BaseTypeDecl.matching_formal_prim_type",
      One_Side_Convert => False
      );
   type Equals_Data_539 is
      record
            Origin : Bare_Ada_Node;
      end record;
   No_Equals_Data_539 : constant Equals_Data_539 := (
         Origin => No_Bare_Ada_Node
   );
   function Eq_539
     (Data : Equals_Data_539; L, R : Internal_Entity) return Boolean is
   begin
      --  If any node pointer is null, then use that for equality
      if L.Node = null or else R.Node = null then
         return L.Node = R.Node;
      end if;
      --  Check that both arguments have appropriate types for the property
      --  call.
      if L.Node.Kind not in Ada_Base_Type_Decl then
         raise Property_Error with
            "Wrong type for BaseTypeDecl.matching_formal_type's ""self"" argument";
      elsif R.Node.Kind not in Ada_Base_Type_Decl then
         raise Property_Error with
            "Wrong type for BaseTypeDecl.matching_formal_type's"
            & " ""formal_type"" argument";
      end if;
      --  All is good: do the call
      declare
         R_Entity : constant Internal_Entity_Base_Type_Decl := (R.Node, R.Info);
      begin
         return Base_Type_Decl_P_Matching_Formal_Type
          (Node             => L.Node,
           Formal_Type => R_Entity,
              Origin => Data.Origin,
           E_Info          => L.Info);
       end;
   end Eq_539;
   package Bind_Default_539 is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_Default,
      No_Data          => No_Logic_Converter_Default,
      Equals_Data      => Equals_Data_539,
      No_Equals_Data   => No_Equals_Data_539,
      Convert          => Convert,
      Equals           => Eq_539,
      Convert_Image    =>
        "",
      Equals_Image     => "BaseTypeDecl.matching_formal_type",
      One_Side_Convert => False
      );
   package Bind_Default_535 is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_Default,
      No_Data          => No_Logic_Converter_Default,
      Equals_Data      => Equals_Data_535,
      No_Equals_Data   => No_Equals_Data_535,
      Convert          => Convert,
      Equals           => Eq_535,
      Convert_Image    =>
        "",
      Equals_Image     => "BaseTypeDecl.matching_prefix_type",
      One_Side_Convert => False
      );
   package Bind_Default_542 is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_Default,
      No_Data          => No_Logic_Converter_Default,
      Equals_Data      => Equals_Data_542,
      No_Equals_Data   => No_Equals_Data_542,
      Convert          => Convert,
      Equals           => Eq_542,
      Convert_Image    =>
        "",
      Equals_Image     => "BaseTypeDecl.matching_type",
      One_Side_Convert => False
      );
   type Logic_Converter_477 is
      null record;
   No_Logic_Converter_477 : constant Logic_Converter_477 := (
         null record
   );
   function Convert (Self : Logic_Converter_477; From : Internal_Entity) return Internal_Entity
      with Inline;
   -------------
   -- Convert --
   -------------
   function Convert (Self : Logic_Converter_477; From : Internal_Entity) return Internal_Entity is
         pragma Unreferenced (Self);
      Ret : Internal_Entity_Base_Type_Decl;
   begin
      Ret := Base_Type_Decl_P_Model_Of_Type
        (Node => From.Node,
         E_Info => From.Info);
      return (Node => Ret.Node, Info => Ret.Info);
   end Convert;
   package Bind_477_542 is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_477,
      No_Data          => No_Logic_Converter_477,
      Equals_Data      => Equals_Data_542,
      No_Equals_Data   => No_Equals_Data_542,
      Convert          => Convert,
      Equals           => Eq_542,
      Convert_Image    =>
        "BaseTypeDecl.model_of_type",
      Equals_Image     => "BaseTypeDecl.matching_type",
      One_Side_Convert => True
      );
   type Logic_Converter_152 is
      record
            Origin : Bare_Ada_Node;
      end record;
   No_Logic_Converter_152 : constant Logic_Converter_152 := (
         Origin => No_Bare_Ada_Node
   );
   function Convert (Self : Logic_Converter_152; From : Internal_Entity) return Internal_Entity
      with Inline;
   -------------
   -- Convert --
   -------------
   function Convert (Self : Logic_Converter_152; From : Internal_Entity) return Internal_Entity is
      Ret : Internal_Entity_Base_Type_Decl;
   begin
      Ret := Basic_Decl_P_Identity_Type
        (Node => From.Node,
            Origin => Self.Origin,
         E_Info => From.Info);
      return (Node => Ret.Node, Info => Ret.Info);
   end Convert;
   package Bind_152_542 is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_152,
      No_Data          => No_Logic_Converter_152,
      Equals_Data      => Equals_Data_542,
      No_Equals_Data   => No_Equals_Data_542,
      Convert          => Convert,
      Equals           => Eq_542,
      Convert_Image    =>
        "BasicDecl.identity_type",
      Equals_Image     => "BaseTypeDecl.matching_type",
      One_Side_Convert => True
      );
   type Logic_Converter_157 is
      null record;
   No_Logic_Converter_157 : constant Logic_Converter_157 := (
         null record
   );
   function Convert (Self : Logic_Converter_157; From : Internal_Entity) return Internal_Entity
      with Inline;
   -------------
   -- Convert --
   -------------
   function Convert (Self : Logic_Converter_157; From : Internal_Entity) return Internal_Entity is
         pragma Unreferenced (Self);
      Ret : Internal_Entity_Base_Subp_Spec;
   begin
      Ret := Basic_Decl_P_Subp_Spec_Or_Null
        (Node => From.Node,
         E_Info => From.Info);
      return (Node => Ret.Node, Info => Ret.Info);
   end Convert;
   package Bind_157_Default is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_157,
      No_Data          => No_Logic_Converter_157,
      Equals_Data      => Equals_Data_Default,
      No_Equals_Data   => No_Equals_Data_Default,
      Convert          => Convert,
      Equals           => Eq_Default,
      Convert_Image    =>
        "BasicDecl.subp_spec_or_null",
      Equals_Image     => "",
      One_Side_Convert => True
      );
   type Logic_Converter_514 is
      record
            Origin : Bare_Ada_Node;
      end record;
   No_Logic_Converter_514 : constant Logic_Converter_514 := (
         Origin => No_Bare_Ada_Node
   );
   function Convert (Self : Logic_Converter_514; From : Internal_Entity) return Internal_Entity
      with Inline;
   -------------
   -- Convert --
   -------------
   function Convert (Self : Logic_Converter_514; From : Internal_Entity) return Internal_Entity is
      Ret : Internal_Entity_Base_Type_Decl;
   begin
      Ret := Dispatcher_Base_Type_Decl_P_Accessed_Type
        (Node => From.Node,
            Origin => Self.Origin,
         E_Info => From.Info);
      return (Node => Ret.Node, Info => Ret.Info);
   end Convert;
   type Equals_Data_538 is
      record
            Origin : Bare_Ada_Node;
      end record;
   No_Equals_Data_538 : constant Equals_Data_538 := (
         Origin => No_Bare_Ada_Node
   );
   function Eq_538
     (Data : Equals_Data_538; L, R : Internal_Entity) return Boolean is
   begin
      --  If any node pointer is null, then use that for equality
      if L.Node = null or else R.Node = null then
         return L.Node = R.Node;
      end if;
      --  Check that both arguments have appropriate types for the property
      --  call.
      if L.Node.Kind not in Ada_Base_Type_Decl then
         raise Property_Error with
            "Wrong type for BaseTypeDecl.matching_formal_type_inverted's ""self"" argument";
      elsif R.Node.Kind not in Ada_Base_Type_Decl then
         raise Property_Error with
            "Wrong type for BaseTypeDecl.matching_formal_type_inverted's"
            & " ""formal_type"" argument";
      end if;
      --  All is good: do the call
      declare
         R_Entity : constant Internal_Entity_Base_Type_Decl := (R.Node, R.Info);
      begin
         return Base_Type_Decl_P_Matching_Formal_Type_Inverted
          (Node             => L.Node,
           Formal_Type => R_Entity,
              Origin => Data.Origin,
           E_Info          => L.Info);
       end;
   end Eq_538;
   package Bind_514_538 is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_514,
      No_Data          => No_Logic_Converter_514,
      Equals_Data      => Equals_Data_538,
      No_Equals_Data   => No_Equals_Data_538,
      Convert          => Convert,
      Equals           => Eq_538,
      Convert_Image    =>
        "BaseTypeDecl.accessed_type",
      Equals_Image     => "BaseTypeDecl.matching_formal_type_inverted",
      One_Side_Convert => True
      );
   type Logic_Converter_502 is
      null record;
   No_Logic_Converter_502 : constant Logic_Converter_502 := (
         null record
   );
   function Convert (Self : Logic_Converter_502; From : Internal_Entity) return Internal_Entity
      with Inline;
   -------------
   -- Convert --
   -------------
   function Convert (Self : Logic_Converter_502; From : Internal_Entity) return Internal_Entity is
         pragma Unreferenced (Self);
      Ret : Internal_Entity_Classwide_Type_Decl;
   begin
      Ret := Dispatcher_Base_Type_Decl_P_Classwide_Type
        (Node => From.Node,
         E_Info => From.Info);
      return (Node => Ret.Node, Info => Ret.Info);
   end Convert;
   package Bind_502_Default is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_502,
      No_Data          => No_Logic_Converter_502,
      Equals_Data      => Equals_Data_Default,
      No_Equals_Data   => No_Equals_Data_Default,
      Convert          => Convert,
      Equals           => Eq_Default,
      Convert_Image    =>
        "BaseTypeDecl.classwide_type",
      Equals_Image     => "",
      One_Side_Convert => True
      );
   type Logic_Converter_155 is
      record
            Origin : Bare_Ada_Node;
      end record;
   No_Logic_Converter_155 : constant Logic_Converter_155 := (
         Origin => No_Bare_Ada_Node
   );
   function Convert (Self : Logic_Converter_155; From : Internal_Entity) return Internal_Entity
      with Inline;
   -------------
   -- Convert --
   -------------
   function Convert (Self : Logic_Converter_155; From : Internal_Entity) return Internal_Entity is
      Ret : Internal_Entity_Base_Type_Decl;
   begin
      Ret := Dispatcher_Basic_Decl_P_Expr_Type
        (Node => From.Node,
            Origin => Self.Origin,
         E_Info => From.Info);
      return (Node => Ret.Node, Info => Ret.Info);
   end Convert;
   package Bind_155_542 is new Eq_Node.Raw_Custom_Bind
     (Converter        => Logic_Converter_155,
      No_Data          => No_Logic_Converter_155,
      Equals_Data      => Equals_Data_542,
      No_Equals_Data   => No_Equals_Data_542,
      Convert          => Convert,
      Equals           => Eq_542,
      Convert_Image    =>
        "BasicDecl.expr_type",
      Equals_Image     => "BaseTypeDecl.matching_type",
      One_Side_Convert => True
      );
   --
   --  Primitives for Bare_Ada_Node
   --
--# property-start AdaNode.declarative_scope /tmp/lal-21.0.0/ada/language/ast.py:92
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Declarative_Scope
  (Node : Bare_Ada_Node
  )
   return Bare_Declarative_Part
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Bare_Declarative_Part;
            procedure Finalizer_Scope_2;
      Node_Parents : Bare_Ada_Node_Array_Access;
Is_A : Boolean;
Map_Result : Bare_Ada_Node_Array_Access;
Get_Result : Bare_Ada_Node;
Cast_Result : Bare_Declarative_Part;
            procedure Finalizer_Scope_2 is
            begin
                     Dec_Ref (Node_Parents);
                     Dec_Ref (Map_Result);
            end Finalizer_Scope_2;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 5 '<Cast to DeclarativePart>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:93
--# expr-start 4 '<at(<filter>, 0)>' Get_Result /tmp/lal-21.0.0/ada/language/ast.py:93
--# expr-start 3 '<filter>' Map_Result /tmp/lal-21.0.0/ada/language/ast.py:93
--# expr-start 1 '<parents(<Var Self>)>' Node_Parents /tmp/lal-21.0.0/ada/language/ast.py:93
Node_Parents := Parents (Self); 
--# expr-done 1
declare
   Map_Result_Vec : Bare_Ada_Node_Vectors.Vector;
begin
      declare
         Collection : constant Bare_Ada_Node_Array_Access := Node_Parents;
      begin
         for Item_0 of
               Collection.Items
         loop
   --# scope-start
               --# bind p Item_0
               --# expr-start 2 '<IsA DeclarativePart>' Is_A /tmp/lal-21.0.0/ada/language/ast.py:94
Is_A := Item_0 /= null 
and then Item_0.Kind in Ada_Declarative_Part_Range; 
--# expr-done 2
               if Is_A then
         declare
            Item_To_Append : constant Bare_Ada_Node :=
               Item_0;
         begin
            Bare_Ada_Node_Vectors.Append (Map_Result_Vec, Item_To_Append);
         end;
               end if;
   --# end
         end loop;
      end;
      Map_Result := Create_Bare_Ada_Node_Array
        (Items_Count => Natural (Bare_Ada_Node_Vectors.Length (Map_Result_Vec)));
      for I in Map_Result.Items'Range loop
         Map_Result.Items (I) := Bare_Ada_Node_Vectors.Get
           (Map_Result_Vec,
            I + Bare_Ada_Node_Vectors.Index_Type'First - Map_Result.Items'First);
      end loop;
      Bare_Ada_Node_Vectors.Destroy (Map_Result_Vec);
end;
--# expr-done 3
Get_Result := Get (Map_Result, 0, True); 
--# expr-done 4
   if Get_Result = null
      or else Get_Result.Kind in Ada_Declarative_Part_Range
   then
      Cast_Result := Get_Result;
   else
         Cast_Result := No_Bare_Ada_Node;
   end if;
--# expr-done 5
      Property_Result := Cast_Result;
   --# end
      Finalizer_Scope_2;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_2;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Declarative_Scope;
--# end
--# property-start '[dispatcher]AdaNode.custom_id_text' dispatcher
pragma Warnings (Off, "is not referenced");
 function Dispatcher_Ada_Node_P_Custom_Id_Text
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Character_Type_Array_Access
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Character_Type_Array_Access;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
      if Self = null then
         raise Property_Error with "dispatching on null node";
      end if;
      case Ada_Ada_Node (Self.Kind) is
               when Ada_Abort_Absent .. Ada_Param_Assoc | Ada_Case_Stmt_Alternative .. Ada_Signed_Int_Type_Def | Ada_Unconstrained_Array_Index .. Ada_With_Private_Present =>
                  --# property-call-start AdaNode.custom_id_text
                  Property_Result := Ada_Node_P_Custom_Id_Text
                    (Self
                        , E_Info
                    );
                  --# end
               when Ada_Component_Decl .. Ada_Single_Task_Decl =>
                  --# property-call-start BasicDecl.custom_id_text
                  Property_Result := Basic_Decl_P_Custom_Id_Text
                    (Self
                        , E_Info
                    );
                  --# end
               when Ada_Anonymous_Type =>
                  --# property-call-start AnonymousType.custom_id_text
                  Property_Result := Anonymous_Type_P_Custom_Id_Text
                    (Self
                        , E_Info
                    );
                  --# end
               when Ada_Enum_Lit_Synth_Type_Expr =>
                  --# property-call-start EnumLitSynthTypeExpr.custom_id_text
                  Property_Result := Enum_Lit_Synth_Type_Expr_P_Custom_Id_Text
                    (Self
                        , E_Info
                    );
                  --# end
               when Ada_Subtype_Indication .. Ada_Discrete_Subtype_Indication =>
                  --# property-call-start SubtypeIndication.custom_id_text
                  Property_Result := Subtype_Indication_P_Custom_Id_Text
                    (Self
                        , E_Info
                    );
                  --# end
      end case;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Dispatcher_Ada_Node_P_Custom_Id_Text;
--# end
--# property-start AdaNode.in_contract /tmp/lal-21.0.0/ada/language/ast.py:110
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_In_Contract
  (Node : Bare_Ada_Node
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Boolean;
            procedure Finalizer_Scope_4;
      Var_Expr : Bare_Aspect_Assoc;
Node_Parents : Bare_Ada_Node_Array_Access;
Cast_Expr : Bare_Ada_Node;
Cast_Result : Bare_Aspect_Assoc;
Fld : Bare_Name;
As_Entity : Internal_Entity_Name;
Is_Null : Boolean;
If_Result : Internal_Entity_Name;
Fld_1 : Symbol_Type;
Sym : Symbol_Type;
Is_Equal : Boolean;
Fld_2 : Bare_Name;
As_Entity_1 : Internal_Entity_Name;
Is_Null_1 : Boolean;
If_Result_1 : Internal_Entity_Name;
Fld_3 : Symbol_Type;
Sym_1 : Symbol_Type;
Is_Equal_1 : Boolean;
If_Result_2 : Boolean;
Fld_4 : Bare_Name;
As_Entity_2 : Internal_Entity_Name;
Is_Null_2 : Boolean;
If_Result_3 : Internal_Entity_Name;
Fld_5 : Symbol_Type;
Sym_2 : Symbol_Type;
Is_Equal_2 : Boolean;
If_Result_4 : Boolean;
Fld_6 : Bare_Name;
As_Entity_3 : Internal_Entity_Name;
Is_Null_3 : Boolean;
If_Result_5 : Internal_Entity_Name;
Fld_7 : Symbol_Type;
Sym_3 : Symbol_Type;
Is_Equal_3 : Boolean;
If_Result_6 : Boolean;
Fld_8 : Bare_Name;
As_Entity_4 : Internal_Entity_Name;
Is_Null_4 : Boolean;
If_Result_7 : Internal_Entity_Name;
Fld_9 : Symbol_Type;
Sym_4 : Symbol_Type;
Is_Equal_4 : Boolean;
If_Result_8 : Boolean;
Fld_10 : Bare_Name;
As_Entity_5 : Internal_Entity_Name;
Is_Null_5 : Boolean;
If_Result_9 : Internal_Entity_Name;
Fld_11 : Symbol_Type;
Sym_5 : Symbol_Type;
Is_Equal_5 : Boolean;
If_Result_10 : Boolean;
Fld_12 : Bare_Name;
As_Entity_6 : Internal_Entity_Name;
Is_Null_6 : Boolean;
If_Result_11 : Internal_Entity_Name;
Fld_13 : Symbol_Type;
Sym_6 : Symbol_Type;
Is_Equal_6 : Boolean;
If_Result_12 : Boolean;
Scope_Result : Boolean;
Result_Var : Boolean;
Map_Result : Bare_Ada_Node_Array_Access;
Get_Result : Bare_Ada_Node;
Is_Null_7 : Boolean;
Not_Val : Boolean;
            procedure Finalizer_Scope_4 is
            begin
                     Dec_Ref (Node_Parents);
                     Dec_Ref (Map_Result);
            end Finalizer_Scope_4;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 46 '<Not>' Not_Val /tmp/lal-21.0.0/ada/language/ast.py:110
--# expr-start 45 '<IsNull>' Is_Null_7 /tmp/lal-21.0.0/ada/language/ast.py:110
--# expr-start 44 '<at(<filter>, 0)>' Get_Result /tmp/lal-21.0.0/ada/language/ast.py:110
--# expr-start 43 '<filter>' Map_Result /tmp/lal-21.0.0/ada/language/ast.py:110
--# expr-start 6 '<parents(<Var Self>)>' Node_Parents /tmp/lal-21.0.0/ada/language/ast.py:110
Node_Parents := Parents (Self); 
--# expr-done 6
declare
   Map_Result_Vec : Bare_Ada_Node_Vectors.Vector;
begin
      declare
         Collection : constant Bare_Ada_Node_Array_Access := Node_Parents;
      begin
         for Item_1 of
               Collection.Items
         loop
   --# scope-start
               --# bind p Item_1
--# expr-start 7 '<Cast to AspectAssoc>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:111
Cast_Expr := Item_1; 
   if Cast_Expr = null
      or else Cast_Expr.Kind in Ada_Aspect_Assoc_Range
   then
      Cast_Result := Cast_Expr;
   else
         Cast_Result := No_Bare_Ada_Node;
   end if;
--# expr-done 7
Var_Expr := Cast_Result;
if Var_Expr /= No_Bare_Ada_Node then
   --# scope-start
   --# bind a Var_Expr
--# expr-start 12 '<Eq>' Is_Equal /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 10 '<FieldAccess .name_symbol>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 9 '<as_bare_entity(<FieldAccess .id>)>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 8 '<FieldAccess .id>' Fld /tmp/lal-21.0.0/ada/language/ast.py:112
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Var_Expr.Aspect_Assoc_F_Id;
--# expr-done 8
Is_Null := Fld = null; 
if Is_Null then
   If_Result := No_Entity_Name;
else
As_Entity := (Info => No_Entity_Info, Node => Fld); 
   If_Result := As_Entity;
end if;
--# expr-done 9
      if If_Result.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]Name.name_symbol'
Fld_1 := Libadalang.Implementation.Dispatcher_Name_P_Name_Symbol (Node => If_Result.Node);
--# end
--# expr-done 10
--# expr-start 11 '<Symbol Pre>' Sym None
Sym := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Pre); 
--# expr-done 11
Is_Equal := Fld_1 = Sym; 
--# expr-done 12
if Is_Equal then
   If_Result_2 := True;
else
   --# expr-start 17 '<Eq>' Is_Equal_1 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 15 '<FieldAccess .name_symbol>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 14 '<as_bare_entity(<FieldAccess .id>)>' If_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 13 '<FieldAccess .id>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:112
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_2 := Var_Expr.Aspect_Assoc_F_Id;
--# expr-done 13
Is_Null_1 := Fld_2 = null; 
if Is_Null_1 then
   If_Result_1 := No_Entity_Name;
else
As_Entity_1 := (Info => No_Entity_Info, Node => Fld_2); 
   If_Result_1 := As_Entity_1;
end if;
--# expr-done 14
      if If_Result_1.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]Name.name_symbol'
Fld_3 := Libadalang.Implementation.Dispatcher_Name_P_Name_Symbol (Node => If_Result_1.Node);
--# end
--# expr-done 15
--# expr-start 16 '<Symbol Post>' Sym_1 None
Sym_1 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Post); 
--# expr-done 16
Is_Equal_1 := Fld_3 = Sym_1; 
--# expr-done 17
   If_Result_2 := Is_Equal_1;
end if;
if If_Result_2 then
   If_Result_4 := True;
else
   --# expr-start 22 '<Eq>' Is_Equal_2 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 20 '<FieldAccess .name_symbol>' Fld_5 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 19 '<as_bare_entity(<FieldAccess .id>)>' If_Result_3 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 18 '<FieldAccess .id>' Fld_4 /tmp/lal-21.0.0/ada/language/ast.py:112
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_4 := Var_Expr.Aspect_Assoc_F_Id;
--# expr-done 18
Is_Null_2 := Fld_4 = null; 
if Is_Null_2 then
   If_Result_3 := No_Entity_Name;
else
As_Entity_2 := (Info => No_Entity_Info, Node => Fld_4); 
   If_Result_3 := As_Entity_2;
end if;
--# expr-done 19
      if If_Result_3.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]Name.name_symbol'
Fld_5 := Libadalang.Implementation.Dispatcher_Name_P_Name_Symbol (Node => If_Result_3.Node);
--# end
--# expr-done 20
--# expr-start 21 '<Symbol Type_Invariant>' Sym_2 None
Sym_2 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Type_Invariant); 
--# expr-done 21
Is_Equal_2 := Fld_5 = Sym_2; 
--# expr-done 22
   If_Result_4 := Is_Equal_2;
end if;
if If_Result_4 then
   If_Result_6 := True;
else
   --# expr-start 27 '<Eq>' Is_Equal_3 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 25 '<FieldAccess .name_symbol>' Fld_7 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 24 '<as_bare_entity(<FieldAccess .id>)>' If_Result_5 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 23 '<FieldAccess .id>' Fld_6 /tmp/lal-21.0.0/ada/language/ast.py:112
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_6 := Var_Expr.Aspect_Assoc_F_Id;
--# expr-done 23
Is_Null_3 := Fld_6 = null; 
if Is_Null_3 then
   If_Result_5 := No_Entity_Name;
else
As_Entity_3 := (Info => No_Entity_Info, Node => Fld_6); 
   If_Result_5 := As_Entity_3;
end if;
--# expr-done 24
      if If_Result_5.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]Name.name_symbol'
Fld_7 := Libadalang.Implementation.Dispatcher_Name_P_Name_Symbol (Node => If_Result_5.Node);
--# end
--# expr-done 25
--# expr-start 26 '<Symbol Predicate>' Sym_3 None
Sym_3 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Predicate); 
--# expr-done 26
Is_Equal_3 := Fld_7 = Sym_3; 
--# expr-done 27
   If_Result_6 := Is_Equal_3;
end if;
if If_Result_6 then
   If_Result_8 := True;
else
   --# expr-start 32 '<Eq>' Is_Equal_4 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 30 '<FieldAccess .name_symbol>' Fld_9 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 29 '<as_bare_entity(<FieldAccess .id>)>' If_Result_7 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 28 '<FieldAccess .id>' Fld_8 /tmp/lal-21.0.0/ada/language/ast.py:112
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_8 := Var_Expr.Aspect_Assoc_F_Id;
--# expr-done 28
Is_Null_4 := Fld_8 = null; 
if Is_Null_4 then
   If_Result_7 := No_Entity_Name;
else
As_Entity_4 := (Info => No_Entity_Info, Node => Fld_8); 
   If_Result_7 := As_Entity_4;
end if;
--# expr-done 29
      if If_Result_7.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]Name.name_symbol'
Fld_9 := Libadalang.Implementation.Dispatcher_Name_P_Name_Symbol (Node => If_Result_7.Node);
--# end
--# expr-done 30
--# expr-start 31 '<Symbol Static_Predicate>' Sym_4 None
Sym_4 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Static_Predicate); 
--# expr-done 31
Is_Equal_4 := Fld_9 = Sym_4; 
--# expr-done 32
   If_Result_8 := Is_Equal_4;
end if;
if If_Result_8 then
   If_Result_10 := True;
else
   --# expr-start 37 '<Eq>' Is_Equal_5 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 35 '<FieldAccess .name_symbol>' Fld_11 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 34 '<as_bare_entity(<FieldAccess .id>)>' If_Result_9 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 33 '<FieldAccess .id>' Fld_10 /tmp/lal-21.0.0/ada/language/ast.py:112
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_10 := Var_Expr.Aspect_Assoc_F_Id;
--# expr-done 33
Is_Null_5 := Fld_10 = null; 
if Is_Null_5 then
   If_Result_9 := No_Entity_Name;
else
As_Entity_5 := (Info => No_Entity_Info, Node => Fld_10); 
   If_Result_9 := As_Entity_5;
end if;
--# expr-done 34
      if If_Result_9.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]Name.name_symbol'
Fld_11 := Libadalang.Implementation.Dispatcher_Name_P_Name_Symbol (Node => If_Result_9.Node);
--# end
--# expr-done 35
--# expr-start 36 '<Symbol Dynamic_Predicate>' Sym_5 None
Sym_5 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Dynamic_Predicate); 
--# expr-done 36
Is_Equal_5 := Fld_11 = Sym_5; 
--# expr-done 37
   If_Result_10 := Is_Equal_5;
end if;
if If_Result_10 then
   If_Result_12 := True;
else
   --# expr-start 42 '<Eq>' Is_Equal_6 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 40 '<FieldAccess .name_symbol>' Fld_13 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 39 '<as_bare_entity(<FieldAccess .id>)>' If_Result_11 /tmp/lal-21.0.0/ada/language/ast.py:112
--# expr-start 38 '<FieldAccess .id>' Fld_12 /tmp/lal-21.0.0/ada/language/ast.py:112
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_12 := Var_Expr.Aspect_Assoc_F_Id;
--# expr-done 38
Is_Null_6 := Fld_12 = null; 
if Is_Null_6 then
   If_Result_11 := No_Entity_Name;
else
As_Entity_6 := (Info => No_Entity_Info, Node => Fld_12); 
   If_Result_11 := As_Entity_6;
end if;
--# expr-done 39
      if If_Result_11.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]Name.name_symbol'
Fld_13 := Libadalang.Implementation.Dispatcher_Name_P_Name_Symbol (Node => If_Result_11.Node);
--# end
--# expr-done 40
--# expr-start 41 '<Symbol Test_Case>' Sym_6 None
Sym_6 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Test_Case); 
--# expr-done 41
Is_Equal_6 := Fld_13 = Sym_6; 
--# expr-done 42
   If_Result_12 := Is_Equal_6;
end if;
Scope_Result := If_Result_12;
   --# end
   Result_Var := Scope_Result;
else
   Result_Var := False;
end if;
               if Result_Var then
         declare
            Item_To_Append : constant Bare_Ada_Node :=
               Item_1;
         begin
            Bare_Ada_Node_Vectors.Append (Map_Result_Vec, Item_To_Append);
         end;
               end if;
   --# end
         end loop;
      end;
      Map_Result := Create_Bare_Ada_Node_Array
        (Items_Count => Natural (Bare_Ada_Node_Vectors.Length (Map_Result_Vec)));
      for I in Map_Result.Items'Range loop
         Map_Result.Items (I) := Bare_Ada_Node_Vectors.Get
           (Map_Result_Vec,
            I + Bare_Ada_Node_Vectors.Index_Type'First - Map_Result.Items'First);
      end loop;
      Bare_Ada_Node_Vectors.Destroy (Map_Result_Vec);
end;
--# expr-done 43
Get_Result := Get (Map_Result, 0, True); 
--# expr-done 44
Is_Null_7 := Get_Result = null; 
--# expr-done 45
Not_Val := not (Is_Null_7); 
--# expr-done 46
      Property_Result := Not_Val;
   --# end
      Finalizer_Scope_4;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_4;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_In_Contract;
--# end
--# property-start AdaNode.in_aspect /tmp/lal-21.0.0/ada/language/ast.py:121
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_In_Aspect
  (Node : Bare_Ada_Node
      ; Name : Symbol_Type
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind name Name
   Property_Result : Boolean;
            procedure Finalizer_Scope_5;
      Var_Expr : Bare_Aspect_Assoc;
Node_Parents : Bare_Ada_Node_Array_Access;
Cast_Expr : Bare_Ada_Node;
Cast_Result : Bare_Aspect_Assoc;
Fld : Bare_Name;
Fld_1 : Boolean;
Scope_Result : Boolean;
Result_Var : Boolean;
Quantifier_Result : Boolean;
Let_Result : Boolean;
            procedure Finalizer_Scope_5 is
            begin
                     Dec_Ref (Node_Parents);
            end Finalizer_Scope_5;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 51 '<Block>' Let_Result None
--# scope-start
--# expr-start 47 '<parents(<Var Self>)>' Node_Parents /tmp/lal-21.0.0/ada/language/ast.py:125
Node_Parents := Parents (Self); 
--# expr-done 47
Quantifier_Result := False;
   declare
      Collection : constant Bare_Ada_Node_Array_Access := Node_Parents;
   begin
      for Item_2 of
            Collection.Items
      loop
   --# scope-start
            --# bind p Item_2
--# expr-start 48 '<Cast to AspectAssoc>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:126
Cast_Expr := Item_2; 
   if Cast_Expr = null
      or else Cast_Expr.Kind in Ada_Aspect_Assoc_Range
   then
      Cast_Result := Cast_Expr;
   else
         Cast_Result := No_Bare_Ada_Node;
   end if;
--# expr-done 48
Var_Expr := Cast_Result;
if Var_Expr /= No_Bare_Ada_Node then
   --# scope-start
   --# bind a Var_Expr
--# expr-start 50 '<FieldAccess .name_is(...)>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:126
--# expr-start 49 '<FieldAccess .id>' Fld /tmp/lal-21.0.0/ada/language/ast.py:126
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Var_Expr.Aspect_Assoc_F_Id;
--# expr-done 49
      if Fld = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start Name.name_is
Fld_1 := Libadalang.Implementation.Name_P_Name_Is (Node => Fld, Sym => Name);
--# end
--# expr-done 50
Scope_Result := Fld_1;
   --# end
   Result_Var := Scope_Result;
else
   Result_Var := False;
end if;
            if Result_Var then
               Quantifier_Result := True;
               exit;
            end if;
   --# end
      end loop;
   end;
Let_Result := Quantifier_Result; 
--# end
--# expr-done 51
      Property_Result := Let_Result;
   --# end
      Finalizer_Scope_5;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_5;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_In_Aspect;
--# end
--# property-start AdaNode.empty_env /tmp/lal-21.0.0/ada/language/ast.py:129
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Empty_Env
  (Node : Bare_Ada_Node
  )
   return Lexical_Env
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Lexical_Env;
            procedure Finalizer_Scope_6;
      Node_Parents : Bare_Ada_Node_Array_Access;
Is_A : Boolean;
Map_Result : Bare_Ada_Node_Array_Access;
Get_Result : Bare_Ada_Node;
Cast_Result : Bare_Compilation_Unit;
Fld : Lexical_Env := Empty_Env;
            procedure Finalizer_Scope_6 is
            begin
                     Dec_Ref (Node_Parents);
                     Dec_Ref (Map_Result);
                     Dec_Ref (Fld);
            end Finalizer_Scope_6;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 57 '<FieldAccess .get_empty_env>' Fld /tmp/lal-21.0.0/ada/language/ast.py:130
--# expr-start 56 '<Cast to CompilationUnit>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:130
--# expr-start 55 '<at(<filter>, 0)>' Get_Result /tmp/lal-21.0.0/ada/language/ast.py:130
--# expr-start 54 '<filter>' Map_Result /tmp/lal-21.0.0/ada/language/ast.py:130
--# expr-start 52 '<parents(<Var Self>)>' Node_Parents /tmp/lal-21.0.0/ada/language/ast.py:130
Node_Parents := Parents (Self); 
--# expr-done 52
declare
   Map_Result_Vec : Bare_Ada_Node_Vectors.Vector;
begin
      declare
         Collection : constant Bare_Ada_Node_Array_Access := Node_Parents;
      begin
         for Item_3 of
               Collection.Items
         loop
   --# scope-start
               --# bind p Item_3
               --# expr-start 53 '<IsA CompilationUnit>' Is_A /tmp/lal-21.0.0/ada/language/ast.py:130
Is_A := Item_3 /= null 
and then Item_3.Kind in Ada_Compilation_Unit_Range; 
--# expr-done 53
               if Is_A then
         declare
            Item_To_Append : constant Bare_Ada_Node :=
               Item_3;
         begin
            Bare_Ada_Node_Vectors.Append (Map_Result_Vec, Item_To_Append);
         end;
               end if;
   --# end
         end loop;
      end;
      Map_Result := Create_Bare_Ada_Node_Array
        (Items_Count => Natural (Bare_Ada_Node_Vectors.Length (Map_Result_Vec)));
      for I in Map_Result.Items'Range loop
         Map_Result.Items (I) := Bare_Ada_Node_Vectors.Get
           (Map_Result_Vec,
            I + Bare_Ada_Node_Vectors.Index_Type'First - Map_Result.Items'First);
      end loop;
      Bare_Ada_Node_Vectors.Destroy (Map_Result_Vec);
end;
--# expr-done 54
Get_Result := Get (Map_Result, 0, True); 
--# expr-done 55
   if Get_Result = null
      or else Get_Result.Kind in Ada_Compilation_Unit_Range
   then
      Cast_Result := Get_Result;
   else
         Cast_Result := No_Bare_Ada_Node;
   end if;
--# expr-done 56
      if Cast_Result = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Libadalang.Implementation.Extensions.Compilation_Unit_P_Get_Empty_Env (Node => Cast_Result);
--# expr-done 57
      Property_Result := Fld;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_6;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_6;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Empty_Env;
--# end
--# property-start AdaNode.is_not_null /tmp/lal-21.0.0/ada/language/ast.py:135
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Is_Not_Null
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   Property_Result : Boolean;
      Is_Null : Boolean;
Not_Val : Boolean;
Let_Result : Boolean;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 60 '<Block>' Let_Result None
--# scope-start
--# expr-start 59 '<Not>' Not_Val /tmp/lal-21.0.0/ada/language/ast.py:143
--# expr-start 58 '<IsNull>' Is_Null /tmp/lal-21.0.0/ada/language/ast.py:143
Is_Null := Ent.Node = null; 
--# expr-done 58
Not_Val := not (Is_Null); 
--# expr-done 59
Let_Result := Not_Val; 
--# end
--# expr-done 60
      Property_Result := Let_Result;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Is_Not_Null;
--# end
--# property-start AdaNode.eval_discrete_range /tmp/lal-21.0.0/ada/language/ast.py:146
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Eval_Discrete_Range
  (Node : Bare_Ada_Node
      ; Dr : Internal_Discrete_Range
  )
   return Internal_Eval_Discrete_Range
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind dr Dr
   Property_Result : Internal_Eval_Discrete_Range;
            procedure Finalizer_Scope_8;
            procedure Finalizer_Scope_1315;
      Var_Expr : Internal_Entity_Expr;
Fld : Internal_Entity_Expr;
Fld_1 : Big_Integer_Type;
Scope_Result : Big_Integer_Type;
Big_Int : Big_Integer_Type;
Result_Var : Big_Integer_Type;
Fld_2 : Internal_Entity_Expr;
Fld_3 : Big_Integer_Type;
New_Struct : Internal_Eval_Discrete_Range := No_Eval_Discrete_Range;
Is_Equal : Boolean;
If_Result : Internal_Eval_Discrete_Range := No_Eval_Discrete_Range;
Let_Result : Internal_Eval_Discrete_Range := No_Eval_Discrete_Range;
            procedure Finalizer_Scope_8 is
            begin
                     Dec_Ref (Scope_Result);
                     Dec_Ref (Big_Int);
                     Dec_Ref (Result_Var);
                     Dec_Ref (Fld_3);
                     Dec_Ref (New_Struct);
                     Dec_Ref (If_Result);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_8;
            procedure Finalizer_Scope_1315 is
            begin
                     Dec_Ref (Fld_1);
            end Finalizer_Scope_1315;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 69 '<Block>' Let_Result None
--# scope-start
--# expr-start 68 '<If>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:150
--# expr-start 61 '<Eq>' Is_Equal /tmp/lal-21.0.0/ada/language/ast.py:151
Is_Equal := Dr = No_Discrete_Range; 
--# expr-done 61
if Is_Equal then
   If_Result := raise Property_Error with "Attempting to evaluate a null discrete range";
else
   --# expr-start 67 '<New InternalEvalDiscreteRange>' New_Struct /tmp/lal-21.0.0/ada/language/ast.py:156
--# expr-start 63 '<FieldAccess .eval_as_int>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:161
--# expr-start 62 '<FieldAccess .high_bound>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:161
Fld_2 := Dr.High_Bound;
--# expr-done 62
      if Fld_2.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start Expr.eval_as_int
Fld_3 := Libadalang.Implementation.Expr_P_Eval_As_Int (Node => Fld_2.Node, E_Info => Fld_2.Info);
--# end
--# expr-done 63
--# expr-start 64 '<FieldAccess .low_bound>' Fld /tmp/lal-21.0.0/ada/language/ast.py:157
Fld := Dr.Low_Bound;
--# expr-done 64
Var_Expr := Fld;
if Var_Expr /= No_Entity_Expr then
   --# scope-start
   --# bind lb Var_Expr
--# expr-start 65 '<FieldAccess .eval_as_int>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:158
      if Var_Expr.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start Expr.eval_as_int
Fld_1 := Libadalang.Implementation.Expr_P_Eval_As_Int (Node => Var_Expr.Node, E_Info => Var_Expr.Info);
--# end
--# expr-done 65
Scope_Result := Fld_1;
   Inc_Ref (Scope_Result);
   --# end
      Finalizer_Scope_1315;
   Result_Var := Scope_Result;
else
   --# expr-start 66 '<BigInteger 0>' Big_Int /tmp/lal-21.0.0/ada/language/ast.py:159
Big_Int := Create_Big_Integer ("0"); 
--# expr-done 66
   Result_Var := Big_Int;
end if;
      Inc_Ref (Result_Var);
Inc_Ref (Fld_3);
Inc_Ref (Result_Var);
New_Struct := (High_Bound => Fld_3, Low_Bound => Result_Var); 
--# expr-done 67
   If_Result := New_Struct;
end if;
      Inc_Ref (If_Result);
--# expr-done 68
Let_Result := If_Result; Inc_Ref (Let_Result);
--# end
--# expr-done 69
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_8;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_8;
               Finalizer_Scope_1315;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Eval_Discrete_Range;
--# end
--# property-start AdaNode.string_join /tmp/lal-21.0.0/ada/language/ast.py:166
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_String_Join
  (Node : Bare_Ada_Node
      ; Strns : Character_Type_Array_Access_Array_Access
      ; Sep : Character_Type_Array_Access
  )
   return Character_Type_Array_Access
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind strns Strns
   --# bind sep Sep
   Property_Result : Character_Type_Array_Access;
            procedure Finalizer_Scope_9;
            procedure Finalizer_Scope_1316;
      Block_Var : Integer;
Len : Integer;
Concat_Result : Character_Type_Array_Access;
Arith_Result : Integer;
Is_Equal : Boolean;
If_Result : Character_Type_Array_Access;
I : Integer;
Map_Result : Character_Type_Array_Access;
Let_Result : Character_Type_Array_Access;
            procedure Finalizer_Scope_9 is
            begin
                     Dec_Ref (Map_Result);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_9;
            procedure Finalizer_Scope_1316 is
            begin
                     Dec_Ref (Concat_Result);
                     Dec_Ref (If_Result);
            end Finalizer_Scope_1316;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 76 '<Block>' Let_Result None
--# scope-start
--# expr-start 70 '<length(<Var strns>)>' Len /tmp/lal-21.0.0/ada/language/ast.py:170
Len := Length (Strns); 
--# expr-done 70
Block_Var := Len; 
--# bind arr_len Block_Var
--# expr-start 75 '<mapcat>' Map_Result /tmp/lal-21.0.0/ada/language/ast.py:172
declare
   Map_Result_Vec : Character_Type_Vectors.Vector;
begin
         I := 0;
      declare
         Collection : constant Character_Type_Array_Access_Array_Access := Strns;
      begin
         for Item_4 of
               Collection.Items
         loop
   --# scope-start
               --# bind n Item_4
               --# bind i I
      --# expr-start 74 '<If>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:173
--# expr-start 72 '<Eq>' Is_Equal /tmp/lal-21.0.0/ada/language/ast.py:173
--# expr-start 71 '<Op ->' Arith_Result /tmp/lal-21.0.0/ada/language/ast.py:173
Arith_Result := (Block_Var - 1); 
--# expr-done 71
Is_Equal := I = Arith_Result; 
--# expr-done 72
if Is_Equal then
   If_Result := Item_4;
else
   --# expr-start 73 '<Concat>' Concat_Result /tmp/lal-21.0.0/ada/language/ast.py:173
Concat_Result := Concat (Item_4, Sep); 
--# expr-done 73
   If_Result := Concat_Result;
end if;
      Inc_Ref (If_Result);
--# expr-done 74
         for Item_To_Append of
               If_Result.Items
         loop
            Character_Type_Vectors.Append (Map_Result_Vec, Item_To_Append);
         end loop;
               I := I + 1;
   --# end
      Finalizer_Scope_1316;
         end loop;
      end;
      Map_Result := Create_Character_Type_Array
        (Items_Count => Natural (Character_Type_Vectors.Length (Map_Result_Vec)));
      for I in Map_Result.Items'Range loop
         Map_Result.Items (I) := Character_Type_Vectors.Get
           (Map_Result_Vec,
            I + Character_Type_Vectors.Index_Type'First - Map_Result.Items'First);
      end loop;
      Character_Type_Vectors.Destroy (Map_Result_Vec);
end;
--# expr-done 75
Let_Result := Map_Result; Inc_Ref (Let_Result);
--# end
--# expr-done 76
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_9;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_9;
               Finalizer_Scope_1316;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_String_Join;
--# end
--# property-start AdaNode.sym_join /tmp/lal-21.0.0/ada/language/ast.py:177
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Sym_Join
  (Node : Bare_Ada_Node
      ; Syms : Symbol_Type_Array_Access
      ; Sep : Character_Type_Array_Access
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Character_Type_Array_Access
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   --# bind syms Syms
   --# bind sep Sep
   Property_Result : Character_Type_Array_Access;
            procedure Finalizer_Scope_10;
            procedure Finalizer_Scope_1317;
      Fld : Character_Type_Array_Access;
Map_Result : Character_Type_Array_Access_Array_Access;
Fld_1 : Character_Type_Array_Access;
Let_Result : Character_Type_Array_Access;
            procedure Finalizer_Scope_10 is
            begin
                     Dec_Ref (Map_Result);
                     Dec_Ref (Fld_1);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_10;
            procedure Finalizer_Scope_1317 is
            begin
                     Dec_Ref (Fld);
            end Finalizer_Scope_1317;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 80 '<Block>' Let_Result None
--# scope-start
--# expr-start 79 '<FieldAccess .string_join(...)>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:181
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 78 '<map>' Map_Result /tmp/lal-21.0.0/ada/language/ast.py:181
declare
   Map_Result_Vec : Character_Type_Array_Access_Vectors.Vector;
begin
      declare
         Collection : constant Symbol_Type_Array_Access := Syms;
      begin
         for Item_5 of
               Collection.Items
         loop
   --# scope-start
               --# bind s Item_5
      --# expr-start 77 '<FieldAccess .image>' Fld /tmp/lal-21.0.0/ada/language/ast.py:181
      if Item_5 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Libadalang.Implementation.Image (Self => Item_5);
--# expr-done 77
         declare
            Item_To_Append : constant Character_Type_Array_Access :=
               Fld;
         begin
               Inc_Ref (Item_To_Append);
            Character_Type_Array_Access_Vectors.Append (Map_Result_Vec, Item_To_Append);
         end;
   --# end
      Finalizer_Scope_1317;
         end loop;
      end;
      Map_Result := Create_Character_Type_Array_Access_Array
        (Items_Count => Natural (Character_Type_Array_Access_Vectors.Length (Map_Result_Vec)));
      for I in Map_Result.Items'Range loop
         Map_Result.Items (I) := Character_Type_Array_Access_Vectors.Get
           (Map_Result_Vec,
            I + Character_Type_Array_Access_Vectors.Index_Type'First - Map_Result.Items'First);
      end loop;
      Character_Type_Array_Access_Vectors.Destroy (Map_Result_Vec);
end;
--# expr-done 78
--# property-call-start AdaNode.string_join
Fld_1 := Libadalang.Implementation.Ada_Node_P_String_Join (Node => Ent.Node, Strns => Map_Result, Sep => Sep);
--# end
--# expr-done 79
Let_Result := Fld_1; Inc_Ref (Let_Result);
--# end
--# expr-done 80
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_10;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_10;
               Finalizer_Scope_1317;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Sym_Join;
--# end
--# property-start AdaNode.enclosing_compilation_unit /tmp/lal-21.0.0/ada/language/ast.py:185
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Enclosing_Compilation_Unit
  (Node : Bare_Ada_Node
  )
   return Bare_Compilation_Unit
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Bare_Compilation_Unit;
            procedure Finalizer_Scope_11;
      Node_Parents : Bare_Ada_Node_Array_Access;
Is_A : Boolean;
Map_Result : Bare_Ada_Node_Array_Access;
Get_Result : Bare_Ada_Node;
Cast_Result : Bare_Compilation_Unit;
Let_Result : Bare_Compilation_Unit;
            procedure Finalizer_Scope_11 is
            begin
                     Dec_Ref (Node_Parents);
                     Dec_Ref (Map_Result);
            end Finalizer_Scope_11;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 86 '<Block>' Let_Result None
--# scope-start
--# expr-start 85 '<Cast to CompilationUnit>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:193
--# expr-start 84 '<at(<filter>, 0)>' Get_Result /tmp/lal-21.0.0/ada/language/ast.py:193
--# expr-start 83 '<filter>' Map_Result /tmp/lal-21.0.0/ada/language/ast.py:193
--# expr-start 81 '<parents(<Var Self>)>' Node_Parents /tmp/lal-21.0.0/ada/language/ast.py:193
Node_Parents := Parents (Self); 
--# expr-done 81
declare
   Map_Result_Vec : Bare_Ada_Node_Vectors.Vector;
begin
      declare
         Collection : constant Bare_Ada_Node_Array_Access := Node_Parents;
      begin
         for Item_6 of
               Collection.Items
         loop
   --# scope-start
               --# bind n Item_6
               --# expr-start 82 '<IsA CompilationUnit>' Is_A /tmp/lal-21.0.0/ada/language/ast.py:194
Is_A := Item_6 /= null 
and then Item_6.Kind in Ada_Compilation_Unit_Range; 
--# expr-done 82
               if Is_A then
         declare
            Item_To_Append : constant Bare_Ada_Node :=
               Item_6;
         begin
            Bare_Ada_Node_Vectors.Append (Map_Result_Vec, Item_To_Append);
         end;
               end if;
   --# end
         end loop;
      end;
      Map_Result := Create_Bare_Ada_Node_Array
        (Items_Count => Natural (Bare_Ada_Node_Vectors.Length (Map_Result_Vec)));
      for I in Map_Result.Items'Range loop
         Map_Result.Items (I) := Bare_Ada_Node_Vectors.Get
           (Map_Result_Vec,
            I + Bare_Ada_Node_Vectors.Index_Type'First - Map_Result.Items'First);
      end loop;
      Bare_Ada_Node_Vectors.Destroy (Map_Result_Vec);
end;
--# expr-done 83
Get_Result := Get (Map_Result, 0, True); 
--# expr-done 84
   if Get_Result = null
      or else Get_Result.Kind in Ada_Compilation_Unit_Range
   then
      Cast_Result := Get_Result;
   else
         raise Property_Error with "invalid object cast";
   end if;
--# expr-done 85
Let_Result := Cast_Result; 
--# end
--# expr-done 86
      Property_Result := Let_Result;
   --# end
      Finalizer_Scope_11;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_11;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Enclosing_Compilation_Unit;
--# end
--# property-start AdaNode.is_children_env /tmp/lal-21.0.0/ada/language/ast.py:198
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Is_Children_Env
  (Node : Bare_Ada_Node
      ; Parent : Lexical_Env
      ; Current_Env : Lexical_Env
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind parent Parent
   --# bind current_env Current_Env
   Property_Result : Boolean;
            procedure Finalizer_Scope_12;
      Is_Equal : Boolean;
Is_Equal_1 : Boolean;
Is_Equal_2 : Boolean;
Env_Parent : Lexical_Env := Empty_Env;
Fld : Boolean;
If_Result : Boolean;
If_Result_1 : Boolean;
If_Result_2 : Boolean;
Let_Result : Boolean;
            procedure Finalizer_Scope_12 is
            begin
                     Dec_Ref (Env_Parent);
            end Finalizer_Scope_12;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 93 '<Block>' Let_Result None
--# scope-start
--# expr-start 92 '<Cond>' If_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:203
--# expr-start 87 '<Eq>' Is_Equal /tmp/lal-21.0.0/ada/language/ast.py:204
Is_Equal := Equivalent (Parent, AST_Envs.Empty_Env); 
--# expr-done 87
if Is_Equal then
   If_Result_2 := False;
else
--# expr-start 88 '<Eq>' Is_Equal_1 /tmp/lal-21.0.0/ada/language/ast.py:205
Is_Equal_1 := Equivalent (Current_Env, Parent); 
--# expr-done 88
if Is_Equal_1 then
   If_Result_1 := True;
else
--# expr-start 89 '<IsNull>' Is_Equal_2 /tmp/lal-21.0.0/ada/language/ast.py:206
Is_Equal_2 := Equivalent (Current_Env, Empty_Env); 
--# expr-done 89
if Is_Equal_2 then
   If_Result := False;
else
   --# expr-start 91 '<FieldAccess .is_children_env(...)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:207
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 90 '<env_parent(<Var current_env>)>' Env_Parent /tmp/lal-21.0.0/ada/language/ast.py:207
Env_Parent := AST_Envs.Parent (Current_Env); 
--# expr-done 90
--# property-call-start AdaNode.is_children_env
Fld := Libadalang.Implementation.Ada_Node_P_Is_Children_Env (Node => Self, Parent => Parent, Current_Env => Env_Parent);
--# end
--# expr-done 91
   If_Result := Fld;
end if;
   If_Result_1 := If_Result;
end if;
   If_Result_2 := If_Result_1;
end if;
--# expr-done 92
Let_Result := If_Result_2; 
--# end
--# expr-done 93
      Property_Result := Let_Result;
   --# end
      Finalizer_Scope_12;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_12;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Is_Children_Env;
--# end
--# property-start AdaNode.trigger_access_entity /tmp/lal-21.0.0/ada/language/ast.py:211
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Trigger_Access_Entity
  (Node : Bare_Ada_Node
      ; Val : Boolean
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Internal_Entity
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   --# bind val Val
   Property_Result : Internal_Entity;
      Block_Var : Internal_Metadata;
Fld : Internal_Entity_Info;
Fld_1 : Internal_Metadata;
Update_Result : Internal_Metadata;
Fld_2 : Bare_Ada_Node;
Fld_3 : Internal_Entity_Info;
Fld_4 : Env_Rebindings;
Fld_5 : Internal_Entity_Info;
Fld_6 : Boolean;
New_Struct : Internal_Entity_Info;
New_Struct_1 : Internal_Entity;
Let_Result : Internal_Entity;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 104 '<Block>' Let_Result None
--# scope-start
--# expr-start 96 '<StructUpdate>' Update_Result /tmp/lal-21.0.0/ada/language/ast.py:216
--# expr-start 95 '<FieldAccess .md>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:216
--# expr-start 94 '<FieldAccess .info>' Fld /tmp/lal-21.0.0/ada/language/ast.py:216
Fld := Ent.Info;
--# expr-done 94
Fld_1 := Fld.MD;
--# expr-done 95
   Update_Result.Dottable_Subp := Fld_1.Dottable_Subp;
   Update_Result.Primitive := Fld_1.Primitive;
   Update_Result.Primitive_Real_Type := Fld_1.Primitive_Real_Type;
   Update_Result.Access_Entity := Val;
--# expr-done 96
Block_Var := Update_Result; 
--# bind new_md Block_Var
--# expr-start 103 '<New InternalEntity>' New_Struct_1 None
--# expr-start 101 '<New InternalEntityInfo>' New_Struct /tmp/lal-21.0.0/ada/language/ast.py:219
--# expr-start 98 '<FieldAccess .from_rebound>' Fld_6 /tmp/lal-21.0.0/ada/language/ast.py:222
--# expr-start 97 '<FieldAccess .info>' Fld_5 /tmp/lal-21.0.0/ada/language/ast.py:222
Fld_5 := Ent.Info;
--# expr-done 97
Fld_6 := Fld_5.From_Rebound;
--# expr-done 98
--# expr-start 100 '<FieldAccess .rebindings>' Fld_4 /tmp/lal-21.0.0/ada/language/ast.py:220
--# expr-start 99 '<FieldAccess .info>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:220
Fld_3 := Ent.Info;
--# expr-done 99
Fld_4 := Fld_3.Rebindings;
--# expr-done 100
New_Struct := (From_Rebound => Fld_6, MD => Block_Var, Rebindings => Fld_4); 
--# expr-done 101
--# expr-start 102 '<FieldAccess .node>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:219
Fld_2 := Ent.Node;
--# expr-done 102
New_Struct_1 := (Info => New_Struct, Node => Fld_2); 
--# expr-done 103
Let_Result := New_Struct_1; 
--# end
--# expr-done 104
      Property_Result := Let_Result;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Trigger_Access_Entity;
--# end
--# property-start AdaNode.without_md /tmp/lal-21.0.0/ada/language/ast.py:227
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Without_Md
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Internal_Entity
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   Property_Result : Internal_Entity;
      Fld : Bare_Ada_Node;
Fld_1 : Internal_Entity_Info;
Fld_2 : Env_Rebindings;
Fld_3 : Internal_Entity_Info;
Fld_4 : Boolean;
New_Struct : Internal_Entity_Info;
New_Struct_1 : Internal_Entity;
Let_Result : Internal_Entity;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 112 '<Block>' Let_Result None
--# scope-start
--# expr-start 111 '<New InternalEntity>' New_Struct_1 None
--# expr-start 109 '<New InternalEntityInfo>' New_Struct /tmp/lal-21.0.0/ada/language/ast.py:232
--# expr-start 106 '<FieldAccess .from_rebound>' Fld_4 /tmp/lal-21.0.0/ada/language/ast.py:235
--# expr-start 105 '<FieldAccess .info>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:235
Fld_3 := Ent.Info;
--# expr-done 105
Fld_4 := Fld_3.From_Rebound;
--# expr-done 106
--# expr-start 108 '<FieldAccess .rebindings>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:233
--# expr-start 107 '<FieldAccess .info>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:233
Fld_1 := Ent.Info;
--# expr-done 107
Fld_2 := Fld_1.Rebindings;
--# expr-done 108
New_Struct := (From_Rebound => Fld_4, MD => No_Metadata, Rebindings => Fld_2); 
--# expr-done 109
--# expr-start 110 '<FieldAccess .node>' Fld /tmp/lal-21.0.0/ada/language/ast.py:232
Fld := Ent.Node;
--# expr-done 110
New_Struct_1 := (Info => New_Struct, Node => Fld); 
--# expr-done 111
Let_Result := New_Struct_1; 
--# end
--# expr-done 112
      Property_Result := Let_Result;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Without_Md;
--# end
--# property-start '[dispatcher]AdaNode.complete' dispatcher
pragma Warnings (Off, "is not referenced");
 function Dispatcher_Ada_Node_P_Complete
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Internal_Completion_Item_Array_Access
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Internal_Completion_Item_Array_Access;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
            Populate_Lexical_Env (Self.Unit);
      end if;
      if Self = null then
         raise Property_Error with "dispatching on null node";
      end if;
      case Ada_Ada_Node (Self.Kind) is
               when Ada_Abort_Absent .. Ada_Discrete_Subtype_Name | Ada_End_Name .. Ada_With_Private_Present =>
                  --# property-call-start AdaNode.complete
                  Property_Result := Ada_Node_P_Complete
                    (Self
                        , E_Info
                    );
                  --# end
               when Ada_Dotted_Name =>
                  --# property-call-start DottedName.complete
                  Property_Result := Dotted_Name_P_Complete
                    (Self
                        , E_Info
                    );
                  --# end
      end case;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Dispatcher_Ada_Node_P_Complete;
--# end
--# property-start AdaNode.valid_keywords /tmp/lal-21.0.0/ada/language/ast.py:253
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Valid_Keywords
  (Node : Bare_Ada_Node
  )
   return Symbol_Type_Array_Access
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Symbol_Type_Array_Access;
            procedure Finalizer_Scope_16;
      Sym : Symbol_Type;
Sym_1 : Symbol_Type;
Sym_2 : Symbol_Type;
Sym_3 : Symbol_Type;
Sym_4 : Symbol_Type;
Sym_5 : Symbol_Type;
Sym_6 : Symbol_Type;
Sym_7 : Symbol_Type;
Sym_8 : Symbol_Type;
Sym_9 : Symbol_Type;
Sym_10 : Symbol_Type;
Sym_11 : Symbol_Type;
Sym_12 : Symbol_Type;
Sym_13 : Symbol_Type;
Sym_14 : Symbol_Type;
Sym_15 : Symbol_Type;
Sym_16 : Symbol_Type;
Sym_17 : Symbol_Type;
Sym_18 : Symbol_Type;
Sym_19 : Symbol_Type;
Sym_20 : Symbol_Type;
Sym_21 : Symbol_Type;
Sym_22 : Symbol_Type;
Sym_23 : Symbol_Type;
Sym_24 : Symbol_Type;
Sym_25 : Symbol_Type;
Sym_26 : Symbol_Type;
Sym_27 : Symbol_Type;
Sym_28 : Symbol_Type;
Sym_29 : Symbol_Type;
Sym_30 : Symbol_Type;
Sym_31 : Symbol_Type;
Sym_32 : Symbol_Type;
Sym_33 : Symbol_Type;
Sym_34 : Symbol_Type;
Sym_35 : Symbol_Type;
Sym_36 : Symbol_Type;
Sym_37 : Symbol_Type;
Sym_38 : Symbol_Type;
Sym_39 : Symbol_Type;
Sym_40 : Symbol_Type;
Sym_41 : Symbol_Type;
Sym_42 : Symbol_Type;
Sym_43 : Symbol_Type;
Sym_44 : Symbol_Type;
Sym_45 : Symbol_Type;
Sym_46 : Symbol_Type;
Sym_47 : Symbol_Type;
Sym_48 : Symbol_Type;
Sym_49 : Symbol_Type;
Sym_50 : Symbol_Type;
Sym_51 : Symbol_Type;
Sym_52 : Symbol_Type;
Sym_53 : Symbol_Type;
Sym_54 : Symbol_Type;
Sym_55 : Symbol_Type;
Sym_56 : Symbol_Type;
Sym_57 : Symbol_Type;
Sym_58 : Symbol_Type;
Sym_59 : Symbol_Type;
Sym_60 : Symbol_Type;
Sym_61 : Symbol_Type;
Sym_62 : Symbol_Type;
Sym_63 : Symbol_Type;
Sym_64 : Symbol_Type;
Sym_65 : Symbol_Type;
Sym_66 : Symbol_Type;
Sym_67 : Symbol_Type;
Sym_68 : Symbol_Type;
Sym_69 : Symbol_Type;
Sym_70 : Symbol_Type;
Sym_71 : Symbol_Type;
Sym_72 : Symbol_Type;
Array_Lit : Symbol_Type_Array_Access;
Let_Result : Symbol_Type_Array_Access;
            procedure Finalizer_Scope_16 is
            begin
                     Dec_Ref (Array_Lit);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_16;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 187 '<Block>' Let_Result None
--# scope-start
--# expr-start 186 '<ArrayLiteral>' Array_Lit /tmp/lal-21.0.0/ada/language/ast.py:261
--# expr-start 113 '<Symbol abort>' Sym None
Sym := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Abort); 
--# expr-done 113
--# expr-start 114 '<Symbol abs>' Sym_1 None
Sym_1 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Abs_182); 
--# expr-done 114
--# expr-start 115 '<Symbol abstract>' Sym_2 None
Sym_2 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Abstract); 
--# expr-done 115
--# expr-start 116 '<Symbol accept>' Sym_3 None
Sym_3 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Accept); 
--# expr-done 116
--# expr-start 117 '<Symbol access>' Sym_4 None
Sym_4 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Access_185); 
--# expr-done 117
--# expr-start 118 '<Symbol aliased>' Sym_5 None
Sym_5 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Aliased); 
--# expr-done 118
--# expr-start 119 '<Symbol all>' Sym_6 None
Sym_6 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_All); 
--# expr-done 119
--# expr-start 120 '<Symbol and>' Sym_7 None
Sym_7 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_And_189); 
--# expr-done 120
--# expr-start 121 '<Symbol array>' Sym_8 None
Sym_8 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Array); 
--# expr-done 121
--# expr-start 122 '<Symbol at>' Sym_9 None
Sym_9 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_At); 
--# expr-done 122
--# expr-start 123 '<Symbol begin>' Sym_10 None
Sym_10 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Begin); 
--# expr-done 123
--# expr-start 124 '<Symbol body>' Sym_11 None
Sym_11 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Body); 
--# expr-done 124
--# expr-start 125 '<Symbol case>' Sym_12 None
Sym_12 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Case); 
--# expr-done 125
--# expr-start 126 '<Symbol constant>' Sym_13 None
Sym_13 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Constant); 
--# expr-done 126
--# expr-start 127 '<Symbol declare>' Sym_14 None
Sym_14 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Declare); 
--# expr-done 127
--# expr-start 128 '<Symbol delay>' Sym_15 None
Sym_15 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Delay); 
--# expr-done 128
--# expr-start 129 '<Symbol delta>' Sym_16 None
Sym_16 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Delta); 
--# expr-done 129
--# expr-start 130 '<Symbol digits>' Sym_17 None
Sym_17 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Digits_199); 
--# expr-done 130
--# expr-start 131 '<Symbol do>' Sym_18 None
Sym_18 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Do); 
--# expr-done 131
--# expr-start 132 '<Symbol else>' Sym_19 None
Sym_19 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Else); 
--# expr-done 132
--# expr-start 133 '<Symbol elsif>' Sym_20 None
Sym_20 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Elsif); 
--# expr-done 133
--# expr-start 134 '<Symbol end>' Sym_21 None
Sym_21 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_End); 
--# expr-done 134
--# expr-start 135 '<Symbol entry>' Sym_22 None
Sym_22 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Entry); 
--# expr-done 135
--# expr-start 136 '<Symbol exception>' Sym_23 None
Sym_23 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Exception); 
--# expr-done 136
--# expr-start 137 '<Symbol exit>' Sym_24 None
Sym_24 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Exit); 
--# expr-done 137
--# expr-start 138 '<Symbol for>' Sym_25 None
Sym_25 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_For); 
--# expr-done 138
--# expr-start 139 '<Symbol function>' Sym_26 None
Sym_26 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Function); 
--# expr-done 139
--# expr-start 140 '<Symbol generic>' Sym_27 None
Sym_27 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Generic); 
--# expr-done 140
--# expr-start 141 '<Symbol goto>' Sym_28 None
Sym_28 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Goto); 
--# expr-done 141
--# expr-start 142 '<Symbol if>' Sym_29 None
Sym_29 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_If); 
--# expr-done 142
--# expr-start 143 '<Symbol in>' Sym_30 None
Sym_30 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_In); 
--# expr-done 143
--# expr-start 144 '<Symbol interface>' Sym_31 None
Sym_31 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Interface_213); 
--# expr-done 144
--# expr-start 145 '<Symbol is>' Sym_32 None
Sym_32 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Is); 
--# expr-done 145
--# expr-start 146 '<Symbol limited>' Sym_33 None
Sym_33 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Limited); 
--# expr-done 146
--# expr-start 147 '<Symbol loop>' Sym_34 None
Sym_34 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Loop); 
--# expr-done 147
--# expr-start 148 '<Symbol mod>' Sym_35 None
Sym_35 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Mod_217); 
--# expr-done 148
--# expr-start 149 '<Symbol new>' Sym_36 None
Sym_36 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_New); 
--# expr-done 149
--# expr-start 150 '<Symbol not>' Sym_37 None
Sym_37 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Not_219); 
--# expr-done 150
--# expr-start 151 '<Symbol null>' Sym_38 None
Sym_38 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Null); 
--# expr-done 151
--# expr-start 152 '<Symbol others>' Sym_39 None
Sym_39 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Others); 
--# expr-done 152
--# expr-start 153 '<Symbol out>' Sym_40 None
Sym_40 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Out); 
--# expr-done 153
--# expr-start 154 '<Symbol of>' Sym_41 None
Sym_41 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Of); 
--# expr-done 154
--# expr-start 155 '<Symbol or>' Sym_42 None
Sym_42 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Or_222); 
--# expr-done 155
--# expr-start 156 '<Symbol overriding>' Sym_43 None
Sym_43 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Overriding); 
--# expr-done 156
--# expr-start 157 '<Symbol package>' Sym_44 None
Sym_44 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Package); 
--# expr-done 157
--# expr-start 158 '<Symbol pragma>' Sym_45 None
Sym_45 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Pragma); 
--# expr-done 158
--# expr-start 159 '<Symbol private>' Sym_46 None
Sym_46 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Private); 
--# expr-done 159
--# expr-start 160 '<Symbol procedure>' Sym_47 None
Sym_47 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Procedure); 
--# expr-done 160
--# expr-start 161 '<Symbol protected>' Sym_48 None
Sym_48 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Protected); 
--# expr-done 161
--# expr-start 162 '<Symbol raise>' Sym_49 None
Sym_49 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Raise); 
--# expr-done 162
--# expr-start 163 '<Symbol range>' Sym_50 None
Sym_50 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Range_232); 
--# expr-done 163
--# expr-start 164 '<Symbol record>' Sym_51 None
Sym_51 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Record); 
--# expr-done 164
--# expr-start 165 '<Symbol rem>' Sym_52 None
Sym_52 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Rem_234); 
--# expr-done 165
--# expr-start 166 '<Symbol renames>' Sym_53 None
Sym_53 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Renames); 
--# expr-done 166
--# expr-start 167 '<Symbol requeue>' Sym_54 None
Sym_54 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Requeue); 
--# expr-done 167
--# expr-start 168 '<Symbol return>' Sym_55 None
Sym_55 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Return); 
--# expr-done 168
--# expr-start 169 '<Symbol reverse>' Sym_56 None
Sym_56 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Reverse); 
--# expr-done 169
--# expr-start 170 '<Symbol select>' Sym_57 None
Sym_57 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Select); 
--# expr-done 170
--# expr-start 171 '<Symbol separate>' Sym_58 None
Sym_58 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Separate); 
--# expr-done 171
--# expr-start 172 '<Symbol some>' Sym_59 None
Sym_59 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Some); 
--# expr-done 172
--# expr-start 173 '<Symbol subtype>' Sym_60 None
Sym_60 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Subtype); 
--# expr-done 173
--# expr-start 174 '<Symbol synchronized>' Sym_61 None
Sym_61 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Synchronized); 
--# expr-done 174
--# expr-start 175 '<Symbol tagged>' Sym_62 None
Sym_62 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Tagged); 
--# expr-done 175
--# expr-start 176 '<Symbol task>' Sym_63 None
Sym_63 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Task); 
--# expr-done 176
--# expr-start 177 '<Symbol terminate>' Sym_64 None
Sym_64 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Terminate); 
--# expr-done 177
--# expr-start 178 '<Symbol then>' Sym_65 None
Sym_65 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Then); 
--# expr-done 178
--# expr-start 179 '<Symbol type>' Sym_66 None
Sym_66 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Type); 
--# expr-done 179
--# expr-start 180 '<Symbol until>' Sym_67 None
Sym_67 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Until); 
--# expr-done 180
--# expr-start 181 '<Symbol use>' Sym_68 None
Sym_68 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Use); 
--# expr-done 181
--# expr-start 182 '<Symbol when>' Sym_69 None
Sym_69 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_When); 
--# expr-done 182
--# expr-start 183 '<Symbol while>' Sym_70 None
Sym_70 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_While); 
--# expr-done 183
--# expr-start 184 '<Symbol with>' Sym_71 None
Sym_71 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_With); 
--# expr-done 184
--# expr-start 185 '<Symbol xor>' Sym_72 None
Sym_72 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Xor_257); 
--# expr-done 185
Array_Lit := Create_Symbol_Type_Array (Internal_Symbol_Type_Array'(1 => Sym, 2 => Sym_1, 3 => Sym_2, 4 => Sym_3, 5 => Sym_4, 6 => Sym_5, 7 => Sym_6, 8 => Sym_7, 9 => Sym_8, 10 => Sym_9, 11 => Sym_10, 12 => Sym_11, 13 => Sym_12, 14 => Sym_13, 15 => Sym_14, 16 => Sym_15, 17 => Sym_16, 18 => Sym_17, 19 => Sym_18, 20 => Sym_19, 21 => Sym_20, 22 => Sym_21, 23 => Sym_22, 24 => Sym_23, 25 => Sym_24, 26 => Sym_25, 27 => Sym_26, 28 => Sym_27, 29 => Sym_28, 30 => Sym_29, 31 => Sym_30, 32 => Sym_31, 33 => Sym_32, 34 => Sym_33, 35 => Sym_34, 36 => Sym_35, 37 => Sym_36, 38 => Sym_37, 39 => Sym_38, 40 => Sym_39, 41 => Sym_40, 42 => Sym_41, 43 => Sym_42, 44 => Sym_43, 45 => Sym_44, 46 => Sym_45, 47 => Sym_46, 48 => Sym_47, 49 => Sym_48, 50 => Sym_49, 51 => Sym_50, 52 => Sym_51, 53 => Sym_52, 54 => Sym_53, 55 => Sym_54, 56 => Sym_55, 57 => Sym_56, 58 => Sym_57, 59 => Sym_58, 60 => Sym_59, 61 => Sym_60, 62 => Sym_61, 63 => Sym_62, 64 => Sym_63, 65 => Sym_64, 66 => Sym_65, 67 => Sym_66, 68 => Sym_67, 69 => Sym_68, 70 => Sym_69, 71 => Sym_70, 72 => Sym_71, 73 => Sym_72)); 
--# expr-done 186
Let_Result := Array_Lit; Inc_Ref (Let_Result);
--# end
--# expr-done 187
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_16;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_16;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Valid_Keywords;
--# end
--# property-start AdaNode.generic_instantiations /tmp/lal-21.0.0/ada/language/ast.py:276
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Generic_Instantiations
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Internal_Entity_Generic_Instantiation_Array_Access
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   Property_Result : Internal_Entity_Generic_Instantiation_Array_Access;
            procedure Finalizer_Scope_17;
      Fld : Internal_Entity_Info;
Fld_1 : Env_Rebindings;
Fld_2 : Internal_Entity_Generic_Instantiation_Array_Access;
Let_Result : Internal_Entity_Generic_Instantiation_Array_Access;
            procedure Finalizer_Scope_17 is
            begin
                     Dec_Ref (Fld_2);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_17;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 191 '<Block>' Let_Result None
--# scope-start
--# expr-start 190 '<FieldAccess .generic_instantiations_internal(...)>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:282
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 189 '<FieldAccess .rebindings>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:282
--# expr-start 188 '<FieldAccess .info>' Fld /tmp/lal-21.0.0/ada/language/ast.py:282
Fld := Ent.Info;
--# expr-done 188
Fld_1 := Fld.Rebindings;
--# expr-done 189
--# property-call-start AdaNode.generic_instantiations_internal
Fld_2 := Libadalang.Implementation.Ada_Node_P_Generic_Instantiations_Internal (Node => Self, R => Fld_1);
--# end
--# expr-done 190
Let_Result := Fld_2; Inc_Ref (Let_Result);
--# end
--# expr-done 191
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_17;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_17;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Generic_Instantiations;
--# end
--# property-start AdaNode.generic_instantiations_internal /tmp/lal-21.0.0/ada/language/ast.py:285
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Generic_Instantiations_Internal
  (Node : Bare_Ada_Node
      ; R : Env_Rebindings
  )
   return Internal_Entity_Generic_Instantiation_Array_Access
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind r R
   Property_Result : Internal_Entity_Generic_Instantiation_Array_Access;
            procedure Finalizer_Scope_18;
      Head : Internal_Entity_Generic_Instantiation;
Tail : Internal_Entity_Generic_Instantiation_Array_Access;
Fld : Lexical_Env := Empty_Env;
Env_Node : Bare_Ada_Node;
Cast_Result : Bare_Generic_Instantiation;
As_Entity : Internal_Entity_Generic_Instantiation;
Is_Null : Boolean;
If_Result : Internal_Entity_Generic_Instantiation;
Fld_1 : Env_Rebindings;
Fld_2 : Internal_Entity_Generic_Instantiation_Array_Access;
Singleton : Internal_Entity_Generic_Instantiation_Array_Access;
Concat_Result : Internal_Entity_Generic_Instantiation_Array_Access;
Let_Result : Internal_Entity_Generic_Instantiation_Array_Access;
Is_Equal : Boolean;
If_Result_1 : Internal_Entity_Generic_Instantiation_Array_Access;
Let_Result_1 : Internal_Entity_Generic_Instantiation_Array_Access;
            procedure Finalizer_Scope_18 is
            begin
                     Dec_Ref (Fld);
                     Dec_Ref (Fld_2);
                     Dec_Ref (Tail);
                     Dec_Ref (Singleton);
                     Dec_Ref (Concat_Result);
                     Dec_Ref (Let_Result);
                     Dec_Ref (If_Result_1);
                     Dec_Ref (Let_Result_1);
            end Finalizer_Scope_18;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 202 '<Block>' Let_Result_1 None
--# scope-start
--# expr-start 201 '<If>' If_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:286
--# expr-start 192 '<Eq>' Is_Equal /tmp/lal-21.0.0/ada/language/ast.py:287
Is_Equal := R = null; 
--# expr-done 192
if Is_Equal then
   If_Result_1 := No_Internal_Entity_Generic_Instantiation_Array_Type;
else
   --# expr-start 200 '<Let head, tail>' Let_Result /tmp/lal-21.0.0/ada/language/ast.py:290
--# scope-start
--# expr-start 196 '<as_bare_entity(<Cast to GenericInstantiation>)>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:291
--# expr-start 195 '<Cast to GenericInstantiation>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:291
--# expr-start 194 '<env_node(<FieldAccess .new_env>)>' Env_Node /tmp/lal-21.0.0/ada/language/ast.py:291
--# expr-start 193 '<FieldAccess .new_env>' Fld /tmp/lal-21.0.0/ada/language/ast.py:291
      if R = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := R.New_Env;
Inc_Ref (Fld);
--# expr-done 193
Env_Node := AST_Envs.Env_Node (Fld); 
--# expr-done 194
   if Env_Node = null
      or else Env_Node.Kind in Ada_Generic_Instantiation
   then
      Cast_Result := Env_Node;
   else
         raise Property_Error with "invalid object cast";
   end if;
--# expr-done 195
Is_Null := Cast_Result = null; 
if Is_Null then
   If_Result := No_Entity_Generic_Instantiation;
else
As_Entity := (Info => No_Entity_Info, Node => Cast_Result); 
   If_Result := As_Entity;
end if;
--# expr-done 196
Head := If_Result; 
--# bind head Head
--# expr-start 198 '<FieldAccess .generic_instantiations_internal(...)>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:293
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 197 '<FieldAccess .get_parent>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:293
      if R = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := R.Parent;
--# expr-done 197
--# property-call-start AdaNode.generic_instantiations_internal
Fld_2 := Libadalang.Implementation.Ada_Node_P_Generic_Instantiations_Internal (Node => Self, R => Fld_1);
--# end
--# expr-done 198
Tail := Fld_2; Inc_Ref (Tail);
--# bind tail Tail
--# expr-start 199 '<Concat>' Concat_Result /tmp/lal-21.0.0/ada/language/ast.py:294
                Singleton := Create_Internal_Entity_Generic_Instantiation_Array (Items_Count => 1);
                Singleton.Items (1) := Head;
Concat_Result := Concat (Singleton, Tail); 
--# expr-done 199
Let_Result := Concat_Result; Inc_Ref (Let_Result);
--# end
--# expr-done 200
   If_Result_1 := Let_Result;
end if;
      Inc_Ref (If_Result_1);
--# expr-done 201
Let_Result_1 := If_Result_1; Inc_Ref (Let_Result_1);
--# end
--# expr-done 202
      Property_Result := Let_Result_1;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_18;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_18;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Generic_Instantiations_Internal;
--# end
--# property-start AdaNode.logic_val /tmp/lal-21.0.0/ada/language/ast.py:302
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Logic_Val
  (Node : Bare_Ada_Node
      ; From_Node : Internal_Entity
      ; Lvar : Logic_Var
  )
   return Internal_Logic_Val_Result
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind from_node From_Node
   --# bind lvar Lvar
   Property_Result : Internal_Logic_Val_Result;
      Block_Var : Boolean;
Fld : Boolean;
Is_Logic_Var_Defined : Boolean;
Eq_Solution : Internal_Entity;
If_Result : Internal_Entity;
If_Result_1 : Internal_Entity;
New_Struct : Internal_Logic_Val_Result;
Let_Result : Internal_Logic_Val_Result;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 207 '<Block>' Let_Result None
--# scope-start
--# expr-start 203 '<FieldAccess .resolve_names_from_closest_entry_point>' Fld /tmp/lal-21.0.0/ada/language/ast.py:303
      if From_Node.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.resolve_names_from_closest_entry_point
Fld := Libadalang.Implementation.Ada_Node_P_Resolve_Names_From_Closest_Entry_Point (Node => From_Node.Node, E_Info => From_Node.Info);
--# end
--# expr-done 203
Block_Var := Fld; 
--# bind success Block_Var
--# expr-start 206 '<New InternalLogicValResult>' New_Struct /tmp/lal-21.0.0/ada/language/ast.py:305
--# expr-start 205 '<If>' If_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:305
if Block_Var then
   --# expr-start 204 '<get_value(<Var lvar>)>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:306
Is_Logic_Var_Defined := Eq_Node.Refs.Is_Defined (Lvar); 
if Is_Logic_Var_Defined then
Eq_Solution := Eq_Node.Refs.Get_Value (Lvar); 
   If_Result := Eq_Solution;
else
   If_Result := No_Entity;
end if;
--# expr-done 204
   If_Result_1 := If_Result;
else
   If_Result_1 := No_Entity;
end if;
--# expr-done 205
New_Struct := (Success => Block_Var, Value => If_Result_1); 
--# expr-done 206
Let_Result := New_Struct; 
--# end
--# expr-done 207
      Property_Result := Let_Result;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Logic_Val;
--# end
--# property-start AdaNode.semantic_parent_helper /tmp/lal-21.0.0/ada/language/ast.py:310
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Semantic_Parent_Helper
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Internal_Entity
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   --# bind env Env
   Property_Result : Internal_Entity;
            procedure Finalizer_Scope_1320;
      Var_Expr : Lexical_Env := Empty_Env;
Var_Expr_1 : Internal_Entity;
Env_Node : Bare_Ada_Node;
As_Entity : Internal_Entity;
Is_Null : Boolean;
If_Result : Internal_Entity;
Scope_Result : Internal_Entity;
Env_Parent : Lexical_Env := Empty_Env;
Fld : Internal_Entity;
Result_Var : Internal_Entity;
Scope_Result_1 : Internal_Entity;
Result_Var_1 : Internal_Entity;
Let_Result : Internal_Entity;
            procedure Finalizer_Scope_1320 is
            begin
                     Dec_Ref (Var_Expr);
                     Dec_Ref (Env_Parent);
            end Finalizer_Scope_1320;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 212 '<Block>' Let_Result None
--# scope-start
Var_Expr := Env;
      Inc_Ref (Var_Expr);
if Var_Expr /= Empty_Env then
   --# scope-start
   --# bind env Var_Expr
--# expr-start 209 '<as_entity(<env_node(<Var env>)>)>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:311
--# expr-start 208 '<env_node(<Var env>)>' Env_Node /tmp/lal-21.0.0/ada/language/ast.py:311
Env_Node := AST_Envs.Env_Node (Var_Expr); 
--# expr-done 208
Is_Null := Env_Node = null; 
if Is_Null then
   If_Result := No_Entity;
else
As_Entity := (Info => E_Info, Node => Env_Node); 
   If_Result := As_Entity;
end if;
--# expr-done 209
Var_Expr_1 := If_Result;
if Var_Expr_1 /= No_Entity then
   --# scope-start
   --# bind e Var_Expr_1
Scope_Result := Var_Expr_1;
   --# end
   Result_Var := Scope_Result;
else
   --# expr-start 211 '<FieldAccess .semantic_parent_helper(...)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:312
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 210 '<env_parent(<Var env>)>' Env_Parent /tmp/lal-21.0.0/ada/language/ast.py:312
Env_Parent := AST_Envs.Parent (Var_Expr); 
--# expr-done 210
--# property-call-start AdaNode.semantic_parent_helper
Fld := Libadalang.Implementation.Ada_Node_P_Semantic_Parent_Helper (Node => Ent.Node, Env => Env_Parent, E_Info => Ent.Info);
--# end
--# expr-done 211
   Result_Var := Fld;
end if;
Scope_Result_1 := Result_Var;
   --# end
      Finalizer_Scope_1320;
   Result_Var_1 := Scope_Result_1;
else
   Result_Var_1 := No_Entity;
end if;
Let_Result := Result_Var_1; 
--# end
--# expr-done 212
      Property_Result := Let_Result;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_1320;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Semantic_Parent_Helper;
--# end
--# property-start AdaNode.semantic_parent /tmp/lal-21.0.0/ada/language/ast.py:316
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Semantic_Parent
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Internal_Entity
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   Property_Result : Internal_Entity;
            procedure Finalizer_Scope_21;
      Fld : Lexical_Env := Empty_Env;
Fld_1 : Internal_Entity;
Let_Result : Internal_Entity;
            procedure Finalizer_Scope_21 is
            begin
                     Dec_Ref (Fld);
            end Finalizer_Scope_21;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
            Populate_Lexical_Env (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 215 '<Block>' Let_Result None
--# scope-start
--# expr-start 214 '<FieldAccess .semantic_parent_helper(...)>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:321
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 213 '<FieldAccess .node_env>' Fld /tmp/lal-21.0.0/ada/language/ast.py:321
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Libadalang.Implementation.Node_Env (Node => Ent.Node, E_Info => Ent.Info);
--# expr-done 213
--# property-call-start AdaNode.semantic_parent_helper
Fld_1 := Libadalang.Implementation.Ada_Node_P_Semantic_Parent_Helper (Node => Ent.Node, Env => Fld, E_Info => Ent.Info);
--# end
--# expr-done 214
Let_Result := Fld_1; 
--# end
--# expr-done 215
      Property_Result := Let_Result;
   --# end
      Finalizer_Scope_21;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_21;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Semantic_Parent;
--# end
--# property-start AdaNode.parent_basic_decl /tmp/lal-21.0.0/ada/language/ast.py:324
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Parent_Basic_Decl
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Internal_Entity_Basic_Decl
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   Property_Result : Internal_Entity_Basic_Decl;
            procedure Finalizer_Scope_1322;
            procedure Finalizer_Scope_1323;
      Var_Expr : Internal_Entity;
Inst : Bare_Basic_Decl;
Var_Expr_1 : Env_Rebindings;
Designated : Internal_Entity;
Var_Expr_2 : Internal_Entity_Generic_Package_Instantiation;
Var_Expr_3 : Internal_Entity_Generic_Subp_Instantiation;
Var_Expr_4 : Internal_Entity_Basic_Decl;
Fld : Internal_Entity;
Fld_1 : Internal_Entity_Info;
Fld_2 : Env_Rebindings;
Fld_3 : Lexical_Env := Empty_Env;
Scope_Result : Lexical_Env := Empty_Env;
Result_Var : Lexical_Env := Empty_Env;
Env_Node : Bare_Ada_Node;
Cast_Result : Bare_Basic_Decl;
Cast_Expr : Bare_Basic_Decl;
Cast_Result_1 : Bare_Generic_Package_Instantiation;
As_Entity : Internal_Entity_Generic_Package_Instantiation;
Is_Null : Boolean;
If_Result : Internal_Entity_Generic_Package_Instantiation;
Fld_4 : Internal_Entity_Base_Package_Decl;
Scope_Result_1 : Internal_Entity_Base_Package_Decl;
Result_Var_1 : Internal_Entity_Base_Package_Decl;
Cast_Expr_1 : Bare_Basic_Decl;
Cast_Result_2 : Bare_Generic_Subp_Instantiation;
As_Entity_1 : Internal_Entity_Generic_Subp_Instantiation;
Is_Null_1 : Boolean;
If_Result_1 : Internal_Entity_Generic_Subp_Instantiation;
Fld_5 : Internal_Entity;
Scope_Result_2 : Internal_Entity;
Result_Var_2 : Internal_Entity;
Cast_Result_3 : Internal_Entity;
Is_A : Boolean;
If_Result_2 : Internal_Entity;
Fld_6 : Internal_Entity_Info;
Fld_7 : Env_Rebindings;
Fld_8 : Env_Rebindings;
New_Struct : Internal_Entity_Info;
New_Struct_1 : Internal_Entity_Basic_Decl;
Fld_9 : Internal_Entity;
Cast_Result_4 : Internal_Entity_Basic_Decl;
Fld_10 : Bare_Ada_Node;
Fld_11 : Bare_Ada_Node;
Cast_Result_5 : Bare_Ada_Node;
Is_Equal : Boolean;
If_Result_3 : Internal_Entity_Basic_Decl;
Let_Result : Internal_Entity_Basic_Decl;
Let_Result_1 : Internal_Entity_Basic_Decl;
Cast_Expr_2 : Internal_Entity;
Cast_Result_6 : Internal_Entity_Basic_Decl;
Scope_Result_3 : Internal_Entity_Basic_Decl;
Fld_12 : Internal_Entity_Basic_Decl;
Result_Var_3 : Internal_Entity_Basic_Decl;
Is_A_1 : Boolean;
Is_A_2 : Boolean;
If_Result_4 : Boolean;
If_Result_5 : Internal_Entity_Basic_Decl;
Scope_Result_4 : Internal_Entity_Basic_Decl;
Result_Var_4 : Internal_Entity_Basic_Decl;
Let_Result_2 : Internal_Entity_Basic_Decl;
            procedure Finalizer_Scope_1322 is
            begin
                     Dec_Ref (Scope_Result);
                     Dec_Ref (Result_Var);
            end Finalizer_Scope_1322;
            procedure Finalizer_Scope_1323 is
            begin
                     Dec_Ref (Fld_3);
            end Finalizer_Scope_1323;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
            Populate_Lexical_Env (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 248 '<Block>' Let_Result_2 None
--# scope-start
--# expr-start 216 '<FieldAccess .semantic_parent>' Fld /tmp/lal-21.0.0/ada/language/ast.py:333
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.semantic_parent
Fld := Libadalang.Implementation.Ada_Node_P_Semantic_Parent (Node => Ent.Node, E_Info => Ent.Info);
--# end
--# expr-done 216
Var_Expr := Fld;
if Var_Expr /= No_Entity then
   --# scope-start
   --# bind sp Var_Expr
--# expr-start 247 '<If>' If_Result_5 /tmp/lal-21.0.0/ada/language/ast.py:334
--# expr-start 217 '<IsA GenericPackageInternal>' Is_A_1 /tmp/lal-21.0.0/ada/language/ast.py:335
Is_A_1 := Var_Expr.Node /= null 
and then Var_Expr.Node.Kind in Ada_Generic_Package_Internal_Range; 
--# expr-done 217
if Is_A_1 then
   If_Result_4 := True;
else
   --# expr-start 218 '<IsA GenericSubpInternal>' Is_A_2 /tmp/lal-21.0.0/ada/language/ast.py:335
Is_A_2 := Var_Expr.Node /= null 
and then Var_Expr.Node.Kind in Ada_Generic_Subp_Internal_Range; 
--# expr-done 218
   If_Result_4 := Is_A_2;
end if;
if If_Result_4 then
   --# expr-start 244 '<Let inst>' Let_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:336
--# scope-start
--# expr-start 223 '<Cast to BasicDecl>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:338
--# expr-start 222 '<env_node(<Then <FieldAccess .rebindings>: <Var Var_Expr_1> <FieldAccess .new_env>>)>' Env_Node /tmp/lal-21.0.0/ada/language/ast.py:338
--# expr-start 220 '<FieldAccess .rebindings>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:338
--# expr-start 219 '<FieldAccess .info>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:338
Fld_1 := Var_Expr.Info;
--# expr-done 219
Fld_2 := Fld_1.Rebindings;
--# expr-done 220
Var_Expr_1 := Fld_2;
if Var_Expr_1 /= null then
   --# scope-start
--# expr-start 221 '<FieldAccess .new_env>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:338
      if Var_Expr_1 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_3 := Var_Expr_1.New_Env;
Inc_Ref (Fld_3);
--# expr-done 221
Scope_Result := Fld_3;
   Inc_Ref (Scope_Result);
   --# end
      Finalizer_Scope_1323;
   Result_Var := Scope_Result;
else
   Result_Var := Empty_Env;
end if;
      Inc_Ref (Result_Var);
Env_Node := AST_Envs.Env_Node (Result_Var); 
--# expr-done 222
   if Env_Node = null
      or else Env_Node.Kind in Ada_Basic_Decl
   then
      Cast_Result := Env_Node;
   else
         Cast_Result := No_Bare_Ada_Node;
   end if;
--# expr-done 223
Inst := Cast_Result; 
--# bind inst Inst
--# expr-start 243 '<Let designated>' Let_Result /tmp/lal-21.0.0/ada/language/ast.py:344
--# scope-start
--# expr-start 231 '<If>' If_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:345
--# expr-start 224 '<IsA GenericPackageInternal>' Is_A /tmp/lal-21.0.0/ada/language/ast.py:346
Is_A := Var_Expr.Node /= null 
and then Var_Expr.Node.Kind in Ada_Generic_Package_Internal_Range; 
--# expr-done 224
if Is_A then
--# expr-start 226 '<as_bare_entity(<Cast to GenericPackageInstantiation>)>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:348
--# expr-start 225 '<Cast to GenericPackageInstantiation>' Cast_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:348
Cast_Expr := Inst; 
   if Cast_Expr = null
      or else Cast_Expr.Kind in Ada_Generic_Package_Instantiation_Range
   then
      Cast_Result_1 := Cast_Expr;
   else
         Cast_Result_1 := No_Bare_Ada_Node;
   end if;
--# expr-done 225
Is_Null := Cast_Result_1 = null; 
if Is_Null then
   If_Result := No_Entity_Generic_Package_Instantiation;
else
As_Entity := (Info => No_Entity_Info, Node => Cast_Result_1); 
   If_Result := As_Entity;
end if;
--# expr-done 226
Var_Expr_2 := If_Result;
if Var_Expr_2 /= No_Entity_Generic_Package_Instantiation then
   --# scope-start
--# expr-start 227 '<FieldAccess .designated_package>' Fld_4 /tmp/lal-21.0.0/ada/language/ast.py:348
      if Var_Expr_2.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start GenericPackageInstantiation.designated_package
Fld_4 := Libadalang.Implementation.Generic_Package_Instantiation_P_Designated_Package (Node => Var_Expr_2.Node, E_Info => Var_Expr_2.Info);
--# end
--# expr-done 227
Scope_Result_1 := Fld_4;
   --# end
   Result_Var_1 := Scope_Result_1;
else
   Result_Var_1 := No_Entity_Base_Package_Decl;
end if;
      Cast_Result_3 := Create_Internal_Entity
        (Node => Result_Var_1.Node,
         Info => Result_Var_1.Info);
   If_Result_2 := Cast_Result_3;
else
--# expr-start 229 '<as_bare_entity(<Cast to GenericSubpInstantiation>)>' If_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:351
--# expr-start 228 '<Cast to GenericSubpInstantiation>' Cast_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:351
Cast_Expr_1 := Inst; 
   if Cast_Expr_1 = null
      or else Cast_Expr_1.Kind in Ada_Generic_Subp_Instantiation_Range
   then
      Cast_Result_2 := Cast_Expr_1;
   else
         Cast_Result_2 := No_Bare_Ada_Node;
   end if;
--# expr-done 228
Is_Null_1 := Cast_Result_2 = null; 
if Is_Null_1 then
   If_Result_1 := No_Entity_Generic_Subp_Instantiation;
else
As_Entity_1 := (Info => No_Entity_Info, Node => Cast_Result_2); 
   If_Result_1 := As_Entity_1;
end if;
--# expr-done 229
Var_Expr_3 := If_Result_1;
if Var_Expr_3 /= No_Entity_Generic_Subp_Instantiation then
   --# scope-start
--# expr-start 230 '<FieldAccess .designated_subp>' Fld_5 /tmp/lal-21.0.0/ada/language/ast.py:351
      if Var_Expr_3.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start GenericSubpInstantiation.designated_subp
Fld_5 := Libadalang.Implementation.Generic_Subp_Instantiation_P_Designated_Subp (Node => Var_Expr_3.Node, E_Info => Var_Expr_3.Info);
--# end
--# expr-done 230
Scope_Result_2 := Fld_5;
   --# end
   Result_Var_2 := Scope_Result_2;
else
   Result_Var_2 := No_Entity;
end if;
   If_Result_2 := Result_Var_2;
end if;
--# expr-done 231
Designated := If_Result_2; 
--# bind designated Designated
--# expr-start 242 '<If>' If_Result_3 /tmp/lal-21.0.0/ada/language/ast.py:353
--# expr-start 234 '<Eq>' Is_Equal /tmp/lal-21.0.0/ada/language/ast.py:354
--# expr-start 232 '<FieldAccess .node>' Fld_10 /tmp/lal-21.0.0/ada/language/ast.py:354
Fld_10 := Designated.Node;
--# expr-done 232
      Cast_Result_5 := Fld_10;
--# expr-start 233 '<FieldAccess .node>' Fld_11 /tmp/lal-21.0.0/ada/language/ast.py:354
Fld_11 := Var_Expr.Node;
--# expr-done 233
Is_Equal := Cast_Result_5 = Fld_11; 
--# expr-done 234
if Is_Equal then
   --# expr-start 239 '<New InternalEntityBasicDecl>' New_Struct_1 None
--# expr-start 238 '<New InternalEntityInfo>' New_Struct /tmp/lal-21.0.0/ada/language/ast.py:357
--# expr-start 237 '<FieldAccess .get_parent>' Fld_8 /tmp/lal-21.0.0/ada/language/ast.py:359
--# expr-start 236 '<FieldAccess .rebindings>' Fld_7 /tmp/lal-21.0.0/ada/language/ast.py:359
--# expr-start 235 '<FieldAccess .info>' Fld_6 /tmp/lal-21.0.0/ada/language/ast.py:359
Fld_6 := Var_Expr.Info;
--# expr-done 235
Fld_7 := Fld_6.Rebindings;
--# expr-done 236
      if Fld_7 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_8 := Fld_7.Parent;
--# expr-done 237
New_Struct := (From_Rebound => False, MD => No_Metadata, Rebindings => Fld_8); 
--# expr-done 238
New_Struct_1 := (Info => New_Struct, Node => Inst); 
--# expr-done 239
   If_Result_3 := New_Struct_1;
else
   --# expr-start 241 '<Cast to BasicDecl>' Cast_Result_4 /tmp/lal-21.0.0/ada/language/ast.py:363
--# expr-start 240 '<parent(<Var sp>)>' Fld_9 /tmp/lal-21.0.0/ada/language/ast.py:363
      if Var_Expr.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_9 := Libadalang.Implementation.Parent (Node => Var_Expr.Node, E_Info => Var_Expr.Info);
--# expr-done 240
   if Fld_9.Node = null
      or else Fld_9.Node.Kind in Ada_Basic_Decl
   then
      Cast_Result_4 := Create_Internal_Entity_Basic_Decl
        (Node => Fld_9.Node,
         Info => Fld_9.Info);
   else
         Cast_Result_4 := No_Entity_Basic_Decl;
   end if;
--# expr-done 241
   If_Result_3 := Cast_Result_4;
end if;
--# expr-done 242
Let_Result := If_Result_3; 
--# end
--# expr-done 243
Let_Result_1 := Let_Result; 
--# end
--# expr-done 244
   If_Result_5 := Let_Result_1;
else
--# expr-start 245 '<Cast to BasicDecl>' Cast_Result_6 /tmp/lal-21.0.0/ada/language/ast.py:367
Cast_Expr_2 := Var_Expr; 
   if Cast_Expr_2.Node = null
      or else Cast_Expr_2.Node.Kind in Ada_Basic_Decl
   then
      Cast_Result_6 := Create_Internal_Entity_Basic_Decl
        (Node => Cast_Expr_2.Node,
         Info => Cast_Expr_2.Info);
   else
         Cast_Result_6 := No_Entity_Basic_Decl;
   end if;
--# expr-done 245
Var_Expr_4 := Cast_Result_6;
if Var_Expr_4 /= No_Entity_Basic_Decl then
   --# scope-start
   --# bind e Var_Expr_4
Scope_Result_3 := Var_Expr_4;
   --# end
   Result_Var_3 := Scope_Result_3;
else
   --# expr-start 246 '<FieldAccess .parent_basic_decl>' Fld_12 /tmp/lal-21.0.0/ada/language/ast.py:367
      if Var_Expr.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.parent_basic_decl
Fld_12 := Libadalang.Implementation.Ada_Node_P_Parent_Basic_Decl (Node => Var_Expr.Node, E_Info => Var_Expr.Info);
--# end
--# expr-done 246
   Result_Var_3 := Fld_12;
end if;
   If_Result_5 := Result_Var_3;
end if;
--# expr-done 247
Scope_Result_4 := If_Result_5;
   --# end
      Finalizer_Scope_1322;
   Result_Var_4 := Scope_Result_4;
else
   Result_Var_4 := No_Entity_Basic_Decl;
end if;
Let_Result_2 := Result_Var_4; 
--# end
--# expr-done 248
      Property_Result := Let_Result_2;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_1322;
               Finalizer_Scope_1323;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Parent_Basic_Decl;
--# end
--# property-start AdaNode.designated_compilation_unit /tmp/lal-21.0.0/ada/language/ast.py:391
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Designated_Compilation_Unit
  (Node : Bare_Ada_Node
      ; Name : Symbol_Type_Array_Access
      ; Kind : Analysis_Unit_Kind
      ; Load_If_Needed : Boolean
         := True
  )
   return Bare_Compilation_Unit
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind name Name
   --# bind kind Kind
   --# bind load_if_needed Load_If_Needed
   Property_Result : Bare_Compilation_Unit;
            procedure Finalizer_Scope_1343;
            procedure Finalizer_Scope_1344;
      Block_Var : Internal_Unit;
Var_Expr : Bare_Ada_Node;
Match_0 : Bare_Compilation_Unit;
Match_1 : Bare_Compilation_Unit_List;
Match_2 : Bare_Ada_Node;
Fld : Internal_Unit;
Fld_1 : Bare_Ada_Node;
Item_8 : Bare_Compilation_Unit;
Fld_2 : Symbol_Type_Array_Access;
Is_Equal : Boolean;
Map_Result : Bare_Compilation_Unit_Array_Access;
Get_Result : Bare_Compilation_Unit;
Match_Prefix : Bare_Ada_Node;
Cast_Result : Bare_Compilation_Unit;
Let_Result : Bare_Compilation_Unit;
Scope_Result : Bare_Compilation_Unit;
Cast_Result_1 : Bare_Compilation_Unit_List;
Let_Result_1 : Bare_Compilation_Unit;
Scope_Result_1 : Bare_Compilation_Unit;
Cast_Result_2 : Bare_Ada_Node;
Let_Result_2 : Bare_Compilation_Unit;
Scope_Result_2 : Bare_Compilation_Unit;
Match_Result : Bare_Compilation_Unit;
Scope_Result_3 : Bare_Compilation_Unit;
Result_Var : Bare_Compilation_Unit;
Let_Result_3 : Bare_Compilation_Unit;
            procedure Finalizer_Scope_1343 is
            begin
                     Dec_Ref (Map_Result);
            end Finalizer_Scope_1343;
            procedure Finalizer_Scope_1344 is
            begin
                     Dec_Ref (Fld_2);
            end Finalizer_Scope_1344;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 256 '<Block>' Let_Result_3 None
--# scope-start
--# expr-start 249 '<FieldAccess .get_unit(...)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:399
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Libadalang.Implementation.Extensions.Ada_Node_P_Get_Unit (Node => Self, Name => Name, Kind => Kind, Load_If_Needed => Load_If_Needed);
--# expr-done 249
Block_Var := Fld; 
--# bind designated_analysis_unit Block_Var
--# expr-start 250 '<FieldAccess .root>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:402
      if Block_Var = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := Block_Var.AST_Root;
--# expr-done 250
Var_Expr := Fld_1;
if Var_Expr /= No_Bare_Ada_Node then
   --# scope-start
--# expr-start 255 '<Match>' Match_Result /tmp/lal-21.0.0/ada/language/ast.py:402
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Match_Prefix := Var_Expr; 
case Ada_Ada_Node (Match_Prefix.Kind) is
         when Ada_Compilation_Unit =>
   --# scope-start
--# scope-start
      Cast_Result := Match_Prefix;
Match_0 := Cast_Result; 
--# bind single Match_0
Let_Result := Match_0; 
--# end
Scope_Result := Let_Result;
   --# end
            Match_Result := Scope_Result; 
         when Ada_Compilation_Unit_List =>
   --# scope-start
--# scope-start
      Cast_Result_1 := Match_Prefix;
Match_1 := Cast_Result_1; 
--# bind multi Match_1
--# expr-start 254 '<at(<filter>, 0)>' Get_Result /tmp/lal-21.0.0/ada/language/ast.py:409
--# expr-start 253 '<filter>' Map_Result /tmp/lal-21.0.0/ada/language/ast.py:409
declare
   Map_Result_Vec : Bare_Compilation_Unit_Vectors.Vector;
begin
      if Match_1 = null then
         Map_Result := Create_Bare_Compilation_Unit_Array (0);
      else
      declare
         Collection : constant Bare_Compilation_Unit_List := Match_1;
      begin
         for Untyped_Item_8 of
               Collection.Nodes (1 .. Children_Count (Collection))
         loop
                  Item_8 := Untyped_Item_8; 
   --# scope-start
               --# bind c Item_8
               --# expr-start 252 '<Eq>' Is_Equal /tmp/lal-21.0.0/ada/language/ast.py:410
--# expr-start 251 '<FieldAccess .syntactic_fully_qualified_name>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:410
      if Item_8 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start CompilationUnit.syntactic_fully_qualified_name
Fld_2 := Libadalang.Implementation.Compilation_Unit_P_Syntactic_Fully_Qualified_Name (Node => Item_8);
--# end
--# expr-done 251
Is_Equal := Equivalent (Fld_2, Name); 
--# expr-done 252
               if Is_Equal then
         declare
            Item_To_Append : constant Bare_Compilation_Unit :=
               Item_8;
         begin
            Bare_Compilation_Unit_Vectors.Append (Map_Result_Vec, Item_To_Append);
         end;
               end if;
   --# end
      Finalizer_Scope_1344;
         end loop;
      end;
      Map_Result := Create_Bare_Compilation_Unit_Array
        (Items_Count => Natural (Bare_Compilation_Unit_Vectors.Length (Map_Result_Vec)));
      for I in Map_Result.Items'Range loop
         Map_Result.Items (I) := Bare_Compilation_Unit_Vectors.Get
           (Map_Result_Vec,
            I + Bare_Compilation_Unit_Vectors.Index_Type'First - Map_Result.Items'First);
      end loop;
      Bare_Compilation_Unit_Vectors.Destroy (Map_Result_Vec);
      end if;
end;
--# expr-done 253
Get_Result := Get (Map_Result, 0, True); 
--# expr-done 254
Let_Result_1 := Get_Result; 
--# end
Scope_Result_1 := Let_Result_1;
   --# end
      Finalizer_Scope_1343;
            Match_Result := Scope_Result_1; 
         when Ada_Abort_Absent .. Ada_Case_Stmt_Alternative_List | Ada_Contract_Case_Assoc_List .. Ada_Case_Stmt_Alternative | Ada_Component_Clause .. Ada_With_Private_Present =>
   --# scope-start
--# scope-start
      Cast_Result_2 := Match_Prefix;
Match_2 := Cast_Result_2; 
--# bind _ Match_2
Let_Result_2 := raise Property_Error with "Unexpected analysis unit root"; 
--# end
Scope_Result_2 := Let_Result_2;
   --# end
            Match_Result := Scope_Result_2; 
end case;
--# expr-done 255
Scope_Result_3 := Match_Result;
   --# end
   Result_Var := Scope_Result_3;
else
   Result_Var := No_Bare_Ada_Node;
end if;
Let_Result_3 := Result_Var; 
--# end
--# expr-done 256
      Property_Result := Let_Result_3;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_1343;
               Finalizer_Scope_1344;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Designated_Compilation_Unit;
--# end
--# property-start AdaNode.get_unit_root_decl /tmp/lal-21.0.0/ada/language/ast.py:419
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Get_Unit_Root_Decl
  (Node : Bare_Ada_Node
      ; Name : Symbol_Type_Array_Access
      ; Kind : Analysis_Unit_Kind
      ; Load_If_Needed : Boolean
         := False
  )
   return Bare_Basic_Decl
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind name Name
   --# bind kind Kind
   --# bind load_if_needed Load_If_Needed
   Property_Result : Bare_Basic_Decl;
      Block_Var : Bare_Compilation_Unit;
Var_Expr : Bare_Compilation_Unit;
Fld : Bare_Compilation_Unit;
Fld_1 : Bare_Basic_Decl;
Scope_Result : Bare_Basic_Decl;
Result_Var : Bare_Basic_Decl;
Let_Result : Bare_Basic_Decl;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 259 '<Block>' Let_Result None
--# scope-start
--# expr-start 257 '<FieldAccess .designated_compilation_unit(...)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:426
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.designated_compilation_unit
Fld := Libadalang.Implementation.Ada_Node_P_Designated_Compilation_Unit (Node => Self, Name => Name, Kind => Kind, Load_If_Needed => Load_If_Needed);
--# end
--# expr-done 257
Block_Var := Fld; 
--# bind cu Block_Var
Var_Expr := Block_Var;
if Var_Expr /= No_Bare_Ada_Node then
   --# scope-start
--# expr-start 258 '<FieldAccess .decl>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:427
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start CompilationUnit.decl
Fld_1 := Libadalang.Implementation.Compilation_Unit_P_Decl (Node => Var_Expr);
--# end
--# expr-done 258
Scope_Result := Fld_1;
   --# end
   Result_Var := Scope_Result;
else
   Result_Var := No_Bare_Ada_Node;
end if;
Let_Result := Result_Var; 
--# end
--# expr-done 259
      Property_Result := Let_Result;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Get_Unit_Root_Decl;
--# end
--# property-start '[dispatcher]AdaNode.xref_equation' dispatcher
pragma Warnings (Off, "is not referenced");
 function Dispatcher_Ada_Node_P_Xref_Equation
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Logic_Equation
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind env Env
   --# bind origin Origin
   Property_Result : Logic_Equation;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
      if Self = null then
         raise Property_Error with "dispatching on null node";
      end if;
      case Ada_Ada_Node (Self.Kind) is
               when Ada_Abort_Absent .. Ada_All_Present | Ada_Aspect_Spec .. Ada_Pragma_Argument_Assoc | Ada_Component_List .. Ada_Record_Def | Ada_Discriminant_Assoc | Ada_Generic_Package_Internal .. Ada_Discrete_Base_Subtype_Decl | Ada_Classwide_Type_Decl .. Ada_Single_Task_Type_Decl | Ada_Abstract_Subp_Decl | Ada_Subp_Decl .. Ada_Generic_Subp_Internal | Ada_Null_Subp_Decl .. Ada_Subp_Body | Ada_Package_Body_Stub .. Ada_Task_Body_Stub | Ada_Package_Body .. Ada_Task_Body | Ada_Error_Decl | Ada_For_Loop_Var_Decl .. Ada_Generic_Subp_Decl | Ada_Label_Decl .. Ada_Named_Stmt_Decl | Ada_Single_Protected_Decl .. Ada_Single_Task_Decl | Ada_Compilation_Unit | Ada_Constant_Absent .. Ada_Constant_Present | Ada_Declarative_Part .. Ada_Elsif_Expr_Part | Ada_Case_Expr_Alternative | Ada_Contract_Cases | Ada_Discrete_Subtype_Name | Ada_Handled_Stmts .. Ada_Limited_Present | Ada_Mode_Default .. Ada_Null_Component_Decl | Ada_Overriding_Not_Overriding .. Ada_Params | Ada_Prim_Type_Accessor .. Ada_Quantifier_Some | Ada_Renaming_Clause .. Ada_Reverse_Present | Ada_Error_Stmt | Ada_Subp_Kind_Function .. Ada_Subp_Kind_Procedure | Ada_Synchronized_Absent .. Ada_Task_Def | Ada_Anonymous_Type_Access_Def | Ada_Enum_Lit_Synth_Type_Expr | Ada_Unconstrained_Array_Index .. Ada_Until_Present | Ada_Variant | Ada_With_Private_Absent .. Ada_With_Private_Present =>
                  --# property-call-start AdaNode.xref_equation
                  Property_Result := Ada_Node_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Constrained_Array_Indices =>
                  --# property-call-start ConstrainedArrayIndices.xref_equation
                  Property_Result := Constrained_Array_Indices_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Unconstrained_Array_Indices =>
                  --# property-call-start UnconstrainedArrayIndices.xref_equation
                  Property_Result := Unconstrained_Array_Indices_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Aspect_Assoc =>
                  --# property-call-start AspectAssoc.xref_equation
                  Property_Result := Aspect_Assoc_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_At_Clause =>
                  --# property-call-start AtClause.xref_equation
                  Property_Result := At_Clause_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Attribute_Def_Clause =>
                  --# property-call-start AttributeDefClause.xref_equation
                  Property_Result := Attribute_Def_Clause_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Enum_Rep_Clause =>
                  --# property-call-start EnumRepClause.xref_equation
                  Property_Result := Enum_Rep_Clause_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Record_Rep_Clause =>
                  --# property-call-start RecordRepClause.xref_equation
                  Property_Result := Record_Rep_Clause_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Entry_Spec .. Ada_Subp_Spec =>
                  --# property-call-start BaseSubpSpec.xref_equation
                  Property_Result := Base_Subp_Spec_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Aggregate_Assoc .. Ada_Multi_Dim_Array_Assoc =>
                  --# property-call-start AggregateAssoc.xref_equation
                  Property_Result := Aggregate_Assoc_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Iterated_Assoc =>
                  --# property-call-start IteratedAssoc.xref_equation
                  Property_Result := Iterated_Assoc_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Param_Assoc =>
                  --# property-call-start ParamAssoc.xref_equation
                  Property_Result := Param_Assoc_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Component_Decl =>
                  --# property-call-start ComponentDecl.xref_equation
                  Property_Result := Component_Decl_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Discriminant_Spec =>
                  --# property-call-start DiscriminantSpec.xref_equation
                  Property_Result := Discriminant_Spec_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Generic_Formal_Obj_Decl .. Ada_Generic_Formal_Type_Decl =>
                  --# property-call-start GenericFormal.xref_equation
                  Property_Result := Generic_Formal_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Param_Spec =>
                  --# property-call-start ParamSpec.xref_equation
                  Property_Result := Param_Spec_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Subtype_Decl =>
                  --# property-call-start SubtypeDecl.xref_equation
                  Property_Result := Subtype_Decl_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Type_Decl .. Ada_Synth_Anonymous_Type_Decl =>
                  --# property-call-start TypeDecl.xref_equation
                  Property_Result := Type_Decl_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Abstract_Formal_Subp_Decl .. Ada_Concrete_Formal_Subp_Decl =>
                  --# property-call-start FormalSubpDecl.xref_equation
                  Property_Result := Formal_Subp_Decl_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Expr_Function =>
                  --# property-call-start ExprFunction.xref_equation
                  Property_Result := Expr_Function_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Subp_Renaming_Decl =>
                  --# property-call-start SubpRenamingDecl.xref_equation
                  Property_Result := Subp_Renaming_Decl_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Entry_Body =>
                  --# property-call-start EntryBody.xref_equation
                  Property_Result := Entry_Body_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Entry_Index_Spec =>
                  --# property-call-start EntryIndexSpec.xref_equation
                  Property_Result := Entry_Index_Spec_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Exception_Decl =>
                  --# property-call-start ExceptionDecl.xref_equation
                  Property_Result := Exception_Decl_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Exception_Handler =>
                  --# property-call-start ExceptionHandler.xref_equation
                  Property_Result := Exception_Handler_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Generic_Package_Instantiation .. Ada_Generic_Subp_Instantiation =>
                  --# property-call-start GenericInstantiation.xref_equation
                  Property_Result := Generic_Instantiation_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Generic_Package_Renaming_Decl .. Ada_Generic_Subp_Renaming_Decl =>
                  --# property-call-start GenericRenamingDecl.xref_equation
                  Property_Result := Generic_Renaming_Decl_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Number_Decl =>
                  --# property-call-start NumberDecl.xref_equation
                  Property_Result := Number_Decl_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Object_Decl .. Ada_Extended_Return_Stmt_Object_Decl =>
                  --# property-call-start ObjectDecl.xref_equation
                  Property_Result := Object_Decl_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Package_Renaming_Decl =>
                  --# property-call-start PackageRenamingDecl.xref_equation
                  Property_Result := Package_Renaming_Decl_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Case_Stmt_Alternative =>
                  --# property-call-start CaseStmtAlternative.xref_equation
                  Property_Result := Case_Stmt_Alternative_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Component_Clause =>
                  --# property-call-start ComponentClause.xref_equation
                  Property_Result := Component_Clause_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Component_Def =>
                  --# property-call-start ComponentDef.xref_equation
                  Property_Result := Component_Def_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Delta_Constraint =>
                  --# property-call-start DeltaConstraint.xref_equation
                  Property_Result := Delta_Constraint_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Digits_Constraint =>
                  --# property-call-start DigitsConstraint.xref_equation
                  Property_Result := Digits_Constraint_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Discriminant_Constraint =>
                  --# property-call-start DiscriminantConstraint.xref_equation
                  Property_Result := Discriminant_Constraint_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Index_Constraint =>
                  --# property-call-start IndexConstraint.xref_equation
                  Property_Result := Index_Constraint_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Range_Constraint =>
                  --# property-call-start RangeConstraint.xref_equation
                  Property_Result := Range_Constraint_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Elsif_Stmt_Part =>
                  --# property-call-start ElsifStmtPart.xref_equation
                  Property_Result := Elsif_Stmt_Part_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Allocator =>
                  --# property-call-start Allocator.xref_equation
                  Property_Result := Allocator_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Aggregate .. Ada_Null_Record_Aggregate =>
                  --# property-call-start BaseAggregate.xref_equation
                  Property_Result := Base_Aggregate_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Bin_Op .. Ada_Relation_Op =>
                  --# property-call-start BinOp.xref_equation
                  Property_Result := Bin_Op_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Box_Expr =>
                  --# property-call-start BoxExpr.xref_equation
                  Property_Result := Box_Expr_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Case_Expr =>
                  --# property-call-start CaseExpr.xref_equation
                  Property_Result := Case_Expr_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_If_Expr =>
                  --# property-call-start IfExpr.xref_equation
                  Property_Result := If_Expr_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Decl_Expr =>
                  --# property-call-start DeclExpr.xref_equation
                  Property_Result := Decl_Expr_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Membership_Expr =>
                  --# property-call-start MembershipExpr.xref_equation
                  Property_Result := Membership_Expr_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Attribute_Ref .. Ada_Update_Attribute_Ref =>
                  --# property-call-start AttributeRef.xref_equation
                  Property_Result := Attribute_Ref_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Call_Expr =>
                  --# property-call-start CallExpr.xref_equation
                  Property_Result := Call_Expr_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Defining_Name =>
                  --# property-call-start DefiningName.xref_equation
                  Property_Result := Defining_Name_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Dotted_Name =>
                  --# property-call-start DottedName.xref_equation
                  Property_Result := Dotted_Name_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_End_Name =>
                  --# property-call-start EndName.xref_equation
                  Property_Result := End_Name_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Explicit_Deref =>
                  --# property-call-start ExplicitDeref.xref_equation
                  Property_Result := Explicit_Deref_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Qual_Expr =>
                  --# property-call-start QualExpr.xref_equation
                  Property_Result := Qual_Expr_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Identifier =>
                  --# property-call-start BaseId.xref_equation
                  Property_Result := Base_Id_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Char_Literal =>
                  --# property-call-start CharLiteral.xref_equation
                  Property_Result := Char_Literal_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Op_Abs .. Ada_Op_Xor =>
                  --# property-call-start Op.xref_equation
                  Property_Result := Op_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_String_Literal =>
                  --# property-call-start StringLiteral.xref_equation
                  Property_Result := String_Literal_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Null_Literal =>
                  --# property-call-start NullLiteral.xref_equation
                  Property_Result := Null_Literal_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Int_Literal =>
                  --# property-call-start IntLiteral.xref_equation
                  Property_Result := Int_Literal_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Real_Literal =>
                  --# property-call-start RealLiteral.xref_equation
                  Property_Result := Real_Literal_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Target_Name =>
                  --# property-call-start TargetName.xref_equation
                  Property_Result := Target_Name_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Paren_Expr =>
                  --# property-call-start ParenExpr.xref_equation
                  Property_Result := Paren_Expr_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Quantified_Expr =>
                  --# property-call-start QuantifiedExpr.xref_equation
                  Property_Result := Quantified_Expr_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Raise_Expr =>
                  --# property-call-start RaiseExpr.xref_equation
                  Property_Result := Raise_Expr_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Un_Op =>
                  --# property-call-start UnOp.xref_equation
                  Property_Result := Un_Op_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_For_Loop_Spec =>
                  --# property-call-start ForLoopSpec.xref_equation
                  Property_Result := For_Loop_Spec_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_While_Loop_Spec =>
                  --# property-call-start WhileLoopSpec.xref_equation
                  Property_Result := While_Loop_Spec_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Others_Designator =>
                  --# property-call-start OthersDesignator.xref_equation
                  Property_Result := Others_Designator_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Pragma_Node =>
                  --# property-call-start Pragma.xref_equation
                  Property_Result := Pragma_Node_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Range_Spec =>
                  --# property-call-start RangeSpec.xref_equation
                  Property_Result := Range_Spec_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Select_When_Part =>
                  --# property-call-start SelectWhenPart.xref_equation
                  Property_Result := Select_When_Part_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Accept_Stmt .. Ada_Accept_Stmt_With_Stmts =>
                  --# property-call-start AcceptStmt.xref_equation
                  Property_Result := Accept_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_For_Loop_Stmt .. Ada_While_Loop_Stmt =>
                  --# property-call-start BaseLoopStmt.xref_equation
                  Property_Result := Base_Loop_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Begin_Block .. Ada_Decl_Block =>
                  --# property-call-start BlockStmt.xref_equation
                  Property_Result := Block_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Case_Stmt =>
                  --# property-call-start CaseStmt.xref_equation
                  Property_Result := Case_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Extended_Return_Stmt =>
                  --# property-call-start ExtendedReturnStmt.xref_equation
                  Property_Result := Extended_Return_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_If_Stmt =>
                  --# property-call-start IfStmt.xref_equation
                  Property_Result := If_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Named_Stmt =>
                  --# property-call-start NamedStmt.xref_equation
                  Property_Result := Named_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Select_Stmt =>
                  --# property-call-start SelectStmt.xref_equation
                  Property_Result := Select_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Abort_Stmt =>
                  --# property-call-start AbortStmt.xref_equation
                  Property_Result := Abort_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Assign_Stmt =>
                  --# property-call-start AssignStmt.xref_equation
                  Property_Result := Assign_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Call_Stmt =>
                  --# property-call-start CallStmt.xref_equation
                  Property_Result := Call_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Delay_Stmt =>
                  --# property-call-start DelayStmt.xref_equation
                  Property_Result := Delay_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Exit_Stmt =>
                  --# property-call-start ExitStmt.xref_equation
                  Property_Result := Exit_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Goto_Stmt =>
                  --# property-call-start GotoStmt.xref_equation
                  Property_Result := Goto_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Label =>
                  --# property-call-start Label.xref_equation
                  Property_Result := Label_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Null_Stmt =>
                  --# property-call-start NullStmt.xref_equation
                  Property_Result := Null_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Raise_Stmt =>
                  --# property-call-start RaiseStmt.xref_equation
                  Property_Result := Raise_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Requeue_Stmt =>
                  --# property-call-start RequeueStmt.xref_equation
                  Property_Result := Requeue_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Return_Stmt =>
                  --# property-call-start ReturnStmt.xref_equation
                  Property_Result := Return_Stmt_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Terminate_Alternative =>
                  --# property-call-start TerminateAlternative.xref_equation
                  Property_Result := Terminate_Alternative_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Subunit =>
                  --# property-call-start Subunit.xref_equation
                  Property_Result := Subunit_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Access_To_Subp_Def =>
                  --# property-call-start AccessToSubpDef.xref_equation
                  Property_Result := Access_To_Subp_Def_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Type_Access_Def =>
                  --# property-call-start TypeAccessDef.xref_equation
                  Property_Result := Type_Access_Def_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Array_Type_Def =>
                  --# property-call-start ArrayTypeDef.xref_equation
                  Property_Result := Array_Type_Def_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Derived_Type_Def =>
                  --# property-call-start DerivedTypeDef.xref_equation
                  Property_Result := Derived_Type_Def_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Enum_Type_Def =>
                  --# property-call-start EnumTypeDef.xref_equation
                  Property_Result := Enum_Type_Def_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Formal_Discrete_Type_Def =>
                  --# property-call-start FormalDiscreteTypeDef.xref_equation
                  Property_Result := Formal_Discrete_Type_Def_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Interface_Type_Def =>
                  --# property-call-start InterfaceTypeDef.xref_equation
                  Property_Result := Interface_Type_Def_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Mod_Int_Type_Def =>
                  --# property-call-start ModIntTypeDef.xref_equation
                  Property_Result := Mod_Int_Type_Def_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Private_Type_Def =>
                  --# property-call-start PrivateTypeDef.xref_equation
                  Property_Result := Private_Type_Def_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Decimal_Fixed_Point_Def .. Ada_Ordinary_Fixed_Point_Def =>
                  --# property-call-start RealTypeDef.xref_equation
                  Property_Result := Real_Type_Def_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Record_Type_Def =>
                  --# property-call-start RecordTypeDef.xref_equation
                  Property_Result := Record_Type_Def_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Signed_Int_Type_Def =>
                  --# property-call-start SignedIntTypeDef.xref_equation
                  Property_Result := Signed_Int_Type_Def_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Anonymous_Type =>
                  --# property-call-start AnonymousType.xref_equation
                  Property_Result := Anonymous_Type_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Subtype_Indication .. Ada_Discrete_Subtype_Indication =>
                  --# property-call-start SubtypeIndication.xref_equation
                  Property_Result := Subtype_Indication_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Use_Package_Clause =>
                  --# property-call-start UsePackageClause.xref_equation
                  Property_Result := Use_Package_Clause_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Use_Type_Clause =>
                  --# property-call-start UseTypeClause.xref_equation
                  Property_Result := Use_Type_Clause_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_Variant_Part =>
                  --# property-call-start VariantPart.xref_equation
                  Property_Result := Variant_Part_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
               when Ada_With_Clause =>
                  --# property-call-start WithClause.xref_equation
                  Property_Result := With_Clause_P_Xref_Equation
                    (Self
                        , Env
                        , Origin
                        , E_Info
                    );
                  --# end
      end case;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Dispatcher_Ada_Node_P_Xref_Equation;
--# end
--# property-start '[dispatcher]AdaNode.xref_stop_resolution' dispatcher
pragma Warnings (Off, "is not referenced");
 function Dispatcher_Ada_Node_P_Xref_Stop_Resolution
  (Node : Bare_Ada_Node
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Boolean;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self = null then
         raise Property_Error with "dispatching on null node";
      end if;
      case Ada_Ada_Node (Self.Kind) is
               when Ada_Abort_Absent .. Ada_Record_Def | Ada_Discriminant_Assoc | Ada_Param_Assoc .. Ada_With_Private_Present =>
                  --# property-call-start AdaNode.xref_stop_resolution
                  Property_Result := Ada_Node_P_Xref_Stop_Resolution
                    (Self
                    );
                  --# end
               when Ada_Aggregate_Assoc .. Ada_Multi_Dim_Array_Assoc =>
                  --# property-call-start AggregateAssoc.xref_stop_resolution
                  Property_Result := Aggregate_Assoc_P_Xref_Stop_Resolution
                    (Self
                    );
                  --# end
               when Ada_Iterated_Assoc =>
                  --# property-call-start IteratedAssoc.xref_stop_resolution
                  Property_Result := Iterated_Assoc_P_Xref_Stop_Resolution
                    (Self
                    );
                  --# end
      end case;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Dispatcher_Ada_Node_P_Xref_Stop_Resolution;
--# end
--# property-start AdaNode.stop_resolution_equation /tmp/lal-21.0.0/ada/language/ast.py:454
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Stop_Resolution_Equation
  (Node : Bare_Ada_Node
  )
   return Logic_Equation
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Logic_Equation;
            procedure Finalizer_Scope_29;
      Logic_True : Logic_Equation;
            procedure Finalizer_Scope_29 is
            begin
                     Dec_Ref (Logic_True);
            end Finalizer_Scope_29;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      Logic_True := True_Rel ((if Langkit_Support.Adalog.Debug.Debug then new String'("ast.py:454") else null)); 
      Property_Result := Logic_True;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_29;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_29;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Stop_Resolution_Equation;
--# end
--# property-start AdaNode.sub_equation /tmp/lal-21.0.0/ada/language/ast.py:457
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Sub_Equation
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Logic_Equation
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   --# bind env Env
   --# bind origin Origin
   Property_Result : Logic_Equation;
            procedure Finalizer_Scope_30;
      Fld : Logic_Equation;
Fld_1 : Logic_Equation;
Fld_2 : Boolean;
If_Result : Logic_Equation;
Let_Result : Logic_Equation;
            procedure Finalizer_Scope_30 is
            begin
                     Dec_Ref (Fld);
                     Dec_Ref (Fld_1);
                     Dec_Ref (If_Result);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_30;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 264 '<Block>' Let_Result None
--# scope-start
--# expr-start 263 '<If>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:465
--# expr-start 260 '<FieldAccess .xref_stop_resolution>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:465
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]AdaNode.xref_stop_resolution'
Fld_2 := Libadalang.Implementation.Dispatcher_Ada_Node_P_Xref_Stop_Resolution (Node => Ent.Node);
--# end
--# expr-done 260
if Fld_2 then
   --# expr-start 261 '<FieldAccess .stop_resolution_equation>' Fld /tmp/lal-21.0.0/ada/language/ast.py:466
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.stop_resolution_equation
Fld := Libadalang.Implementation.Ada_Node_P_Stop_Resolution_Equation (Node => Ent.Node);
--# end
--# expr-done 261
   If_Result := Fld;
else
   --# expr-start 262 '<FieldAccess .xref_equation>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:467
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]AdaNode.xref_equation'
Fld_1 := Libadalang.Implementation.Dispatcher_Ada_Node_P_Xref_Equation (Node => Ent.Node, Env => Env, Origin => Origin, E_Info => Ent.Info);
--# end
--# expr-done 262
   If_Result := Fld_1;
end if;
      Inc_Ref (If_Result);
--# expr-done 263
Let_Result := If_Result; Inc_Ref (Let_Result);
--# end
--# expr-done 264
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_30;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_30;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Sub_Equation;
--# end
--# property-start AdaNode.resolve_own_names /tmp/lal-21.0.0/ada/language/ast.py:471
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Resolve_Own_Names
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   --# bind env Env
   --# bind origin Origin
   Property_Result : Boolean;
            procedure Finalizer_Scope_31;
      Fld : Logic_Equation;
Solve_Success : Boolean;
Let_Result : Boolean;
            procedure Finalizer_Scope_31 is
            begin
                     Dec_Ref (Fld);
            end Finalizer_Scope_31;
      Mmz_Handle : Memoization_Handle;
      Mmz_Val    : Mmz_Value;
      function Create_Mmz_Key return Mmz_Key;
      --  Create a memoization key for this property call and return it
      --------------------
      -- Create_Mmz_Key --
      --------------------
      function Create_Mmz_Key return Mmz_Key is
      begin
         return Mmz_K : Mmz_Key :=
           (Property => Mmz_Bare_Ada_Node_Ada_Node_P_Resolve_Own_Names,
            Items    => new Mmz_Key_Array (1 ..  4))
         do
            Mmz_K.Items (1) := (Kind => Mmz_Bare_Ada_Node,
                                As_Bare_Ada_Node => Self);
               Mmz_K.Items (2) := (Kind => Mmz_Lexical_Env,
                                      As_Lexical_Env => Env);
                  Inc_Ref (Mmz_K.Items (2).As_Lexical_Env);
               Mmz_K.Items (3) := (Kind => Mmz_Bare_Ada_Node,
                                      As_Bare_Ada_Node => Origin);
               Mmz_K.Items (4) :=
                 (Kind => Mmz_Internal_Entity_Info,
                  As_Internal_Entity_Info => E_Info);
         end return;
      end Create_Mmz_Key;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
      if Self = null then
         raise Property_Error with "property called on null node";
      end if;
      if not Self.Unit.Context.In_Populate_Lexical_Env then
         if Find_Memoized_Value
           (Self.Unit, Mmz_Handle, Mmz_Val, Create_Mmz_Key'Access)
         then
            --# memoization-lookup
            if Mmz_Val.Kind = Mmz_Evaluating then
               --# memoization-return
               raise Property_Error with "Infinite recursion detected";
            elsif Mmz_Val.Kind = Mmz_Property_Error then
               --# memoization-return
               raise Property_Error with "Memoized error";
            else
               Property_Result := Mmz_Val.As_Boolean;
               --# memoization-return
               Exit_Call (Self.Unit.Context, Call_Depth);
               return Property_Result;
            end if;
            --# end
         end if;
      end if;
   --# scope-start
      --# expr-start 267 '<Block>' Let_Result None
--# scope-start
--# expr-start 266 '<solve(<FieldAccess .xref_equation>)>' Solve_Success /tmp/lal-21.0.0/ada/language/ast.py:476
--# expr-start 265 '<FieldAccess .xref_equation>' Fld /tmp/lal-21.0.0/ada/language/ast.py:476
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]AdaNode.xref_equation'
Fld := Libadalang.Implementation.Dispatcher_Ada_Node_P_Xref_Equation (Node => Ent.Node, Env => Env, Origin => Origin, E_Info => Ent.Info);
--# end
--# expr-done 265
Solve_Success := Solve_Wrapper (Fld, Self); 
--# expr-done 266
Let_Result := Solve_Success; 
--# end
--# expr-done 267
      Property_Result := Let_Result;
   --# end
      Finalizer_Scope_31;
      if not Self.Unit.Context.In_Populate_Lexical_Env then
         Mmz_Val := (Kind => Mmz_Boolean,
                     As_Boolean => Property_Result);
         Add_Memoized_Value (Self.Unit, Mmz_Handle, Mmz_Val);
      end if;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_31;
         if Self /= null then
            if not Self.Unit.Context.In_Populate_Lexical_Env then
               Add_Memoized_Value
                 (Self.Unit, Mmz_Handle, (Kind => Mmz_Property_Error));
            end if;
         end if;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Resolve_Own_Names;
--# end
--# property-start AdaNode.resolve_children_names /tmp/lal-21.0.0/ada/language/ast.py:479
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Resolve_Children_Names
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind env Env
   --# bind origin Origin
   Property_Result : Boolean;
            procedure Finalizer_Scope_32;
      Var_Expr : Bare_Ada_Node;
Node_Children : Bare_Ada_Node_Array_Access;
As_Entity : Internal_Entity;
Is_Null : Boolean;
If_Result : Internal_Entity;
Fld : Boolean;
Fld_1 : Boolean;
If_Result_1 : Boolean;
As_Entity_1 : Internal_Entity;
Is_Null_1 : Boolean;
If_Result_2 : Internal_Entity;
Fld_2 : Boolean;
If_Result_3 : Boolean;
Fld_3 : Boolean;
If_Result_4 : Boolean;
Scope_Result : Boolean;
Result_Var : Boolean;
Quantifier_Result : Boolean;
Let_Result : Boolean;
            procedure Finalizer_Scope_32 is
            begin
                     Dec_Ref (Node_Children);
            end Finalizer_Scope_32;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 277 '<Block>' Let_Result None
--# scope-start
--# expr-start 268 '<children(<Var Self>)>' Node_Children /tmp/lal-21.0.0/ada/language/ast.py:484
Node_Children := Children (Self); 
--# expr-done 268
Quantifier_Result := True;
   declare
      Collection : constant Bare_Ada_Node_Array_Access := Node_Children;
   begin
      for Item_9 of
            Collection.Items
      loop
   --# scope-start
            --# bind c Item_9
Var_Expr := Item_9;
if Var_Expr /= No_Bare_Ada_Node then
   --# scope-start
   --# bind c Var_Expr
--# expr-start 276 '<If>' If_Result_4 /tmp/lal-21.0.0/ada/language/ast.py:487
--# expr-start 269 '<FieldAccess .xref_entry_point>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:488
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]AdaNode.xref_entry_point'
Fld_3 := Libadalang.Implementation.Dispatcher_Ada_Node_P_Xref_Entry_Point (Node => Var_Expr);
--# end
--# expr-done 269
if Fld_3 then
   If_Result_4 := True;
else
--# expr-start 273 '<If>' If_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:490
--# expr-start 270 '<FieldAccess .xref_stop_resolution>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:490
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]AdaNode.xref_stop_resolution'
Fld_1 := Libadalang.Implementation.Dispatcher_Ada_Node_P_Xref_Stop_Resolution (Node => Var_Expr);
--# end
--# expr-done 270
if Fld_1 then
   --# expr-start 272 '<FieldAccess .resolve_own_names>' Fld /tmp/lal-21.0.0/ada/language/ast.py:490
--# expr-start 271 '<as_entity(<Var c>)>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:490
Is_Null := Var_Expr = null; 
if Is_Null then
   If_Result := No_Entity;
else
As_Entity := (Info => E_Info, Node => Var_Expr); 
   If_Result := As_Entity;
end if;
--# expr-done 271
      if If_Result.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.resolve_own_names
Fld := Libadalang.Implementation.Ada_Node_P_Resolve_Own_Names (Node => If_Result.Node, Env => Env, Origin => Origin, E_Info => If_Result.Info);
--# end
--# expr-done 272
   If_Result_1 := Fld;
else
   If_Result_1 := True;
end if;
--# expr-done 273
if If_Result_1 then
   --# expr-start 275 '<FieldAccess .resolve_children_names>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:491
--# expr-start 274 '<as_entity(<Var c>)>' If_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:491
Is_Null_1 := Var_Expr = null; 
if Is_Null_1 then
   If_Result_2 := No_Entity;
else
As_Entity_1 := (Info => E_Info, Node => Var_Expr); 
   If_Result_2 := As_Entity_1;
end if;
--# expr-done 274
      if If_Result_2.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.resolve_children_names
Fld_2 := Libadalang.Implementation.Ada_Node_P_Resolve_Children_Names (Node => If_Result_2.Node, Env => Env, Origin => Origin, E_Info => If_Result_2.Info);
--# end
--# expr-done 275
   If_Result_3 := Fld_2;
else
   If_Result_3 := False;
end if;
   If_Result_4 := If_Result_3;
end if;
--# expr-done 276
Scope_Result := If_Result_4;
   --# end
   Result_Var := Scope_Result;
else
   Result_Var := True;
end if;
            if not (Result_Var) then
               Quantifier_Result := False;
               exit;
            end if;
   --# end
      end loop;
   end;
Let_Result := Quantifier_Result; 
--# end
--# expr-done 277
      Property_Result := Let_Result;
   --# end
      Finalizer_Scope_32;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_32;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Resolve_Children_Names;
--# end
--# property-start AdaNode.resolve_names_internal /tmp/lal-21.0.0/ada/language/ast.py:497
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Resolve_Names_Internal
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   --# bind env Env
   --# bind origin Origin
   Property_Result : Boolean;
      Fld : Boolean;
Fld_1 : Boolean;
If_Result : Boolean;
Let_Result : Boolean;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 280 '<Block>' Let_Result None
--# scope-start
--# expr-start 278 '<FieldAccess .resolve_own_names>' Fld /tmp/lal-21.0.0/ada/language/ast.py:501
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.resolve_own_names
Fld := Libadalang.Implementation.Ada_Node_P_Resolve_Own_Names (Node => Ent.Node, Env => Env, Origin => Origin, E_Info => Ent.Info);
--# end
--# expr-done 278
if Fld then
   --# expr-start 279 '<FieldAccess .resolve_children_names>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:501
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.resolve_children_names
Fld_1 := Libadalang.Implementation.Ada_Node_P_Resolve_Children_Names (Node => Ent.Node, Env => Env, Origin => Origin, E_Info => Ent.Info);
--# end
--# expr-done 279
   If_Result := Fld_1;
else
   If_Result := False;
end if;
Let_Result := If_Result; 
--# end
--# expr-done 280
      Property_Result := Let_Result;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Resolve_Names_Internal;
--# end
--# property-start AdaNode.resolve_names_internal_with_eq /tmp/lal-21.0.0/ada/language/ast.py:504
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Resolve_Names_Internal_With_Eq
  (Node : Bare_Ada_Node
      ; Additional_Equation : Logic_Equation
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   --# bind additional_equation Additional_Equation
   --# bind env Env
   --# bind origin Origin
   Property_Result : Boolean;
            procedure Finalizer_Scope_34;
      Fld : Logic_Equation;
And_Pred : Logic_Equation;
Solve_Success : Boolean;
Fld_1 : Boolean;
If_Result : Boolean;
Let_Result : Boolean;
            procedure Finalizer_Scope_34 is
            begin
                     Dec_Ref (Fld);
                     Dec_Ref (And_Pred);
            end Finalizer_Scope_34;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 285 '<Block>' Let_Result None
--# scope-start
--# expr-start 283 '<solve(<And>)>' Solve_Success /tmp/lal-21.0.0/ada/language/ast.py:509
--# expr-start 282 '<And>' And_Pred /tmp/lal-21.0.0/ada/language/ast.py:509
--# expr-start 281 '<FieldAccess .xref_equation>' Fld /tmp/lal-21.0.0/ada/language/ast.py:509
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]AdaNode.xref_equation'
Fld := Libadalang.Implementation.Dispatcher_Ada_Node_P_Xref_Equation (Node => Ent.Node, Env => Env, Origin => Origin, E_Info => Ent.Info);
--# end
--# expr-done 281
And_Pred := Logic_And (Fld, Additional_Equation, (if Langkit_Support.Adalog.Debug.Debug then new String'("ast.py:509") else null)); 
--# expr-done 282
Solve_Success := Solve_Wrapper (And_Pred, Self); 
--# expr-done 283
if Solve_Success then
   --# expr-start 284 '<FieldAccess .resolve_children_names>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:510
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.resolve_children_names
Fld_1 := Libadalang.Implementation.Ada_Node_P_Resolve_Children_Names (Node => Ent.Node, Env => Env, Origin => Origin, E_Info => Ent.Info);
--# end
--# expr-done 284
   If_Result := Fld_1;
else
   If_Result := False;
end if;
Let_Result := If_Result; 
--# end
--# expr-done 285
      Property_Result := Let_Result;
   --# end
      Finalizer_Scope_34;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_34;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Resolve_Names_Internal_With_Eq;
--# end
--# property-start '[dispatcher]AdaNode.xref_entry_point' dispatcher
pragma Warnings (Off, "is not referenced");
 function Dispatcher_Ada_Node_P_Xref_Entry_Point
  (Node : Bare_Ada_Node
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Boolean;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self = null then
         raise Property_Error with "dispatching on null node";
      end if;
      case Ada_Ada_Node (Self.Kind) is
               when Ada_Abort_Absent .. Ada_Unconstrained_Array_Indices | Ada_Aspect_Spec .. Ada_Pragma_Argument_Assoc | Ada_Component_List .. Ada_Iterated_Assoc | Ada_Generic_Package_Internal .. Ada_Discrete_Base_Subtype_Decl | Ada_Classwide_Type_Decl .. Ada_Single_Task_Type_Decl | Ada_Abstract_Subp_Decl .. Ada_Generic_Subp_Internal | Ada_Null_Subp_Decl .. Ada_Subp_Body | Ada_Package_Body_Stub .. Ada_Task_Body_Stub | Ada_Package_Body .. Ada_Task_Body | Ada_Error_Decl | Ada_For_Loop_Var_Decl .. Ada_Generic_Subp_Decl | Ada_Label_Decl .. Ada_Named_Stmt_Decl | Ada_Single_Protected_Decl .. Ada_Single_Task_Decl | Ada_Compilation_Unit | Ada_Component_Def .. Ada_Elsif_Expr_Part | Ada_Allocator .. Ada_Call_Expr | Ada_Discrete_Subtype_Name .. Ada_Dotted_Name | Ada_Explicit_Deref .. Ada_Limited_Present | Ada_While_Loop_Spec .. Ada_Params | Ada_Prim_Type_Accessor .. Ada_Select_When_Part | Ada_Subp_Kind_Function .. Ada_Subp_Kind_Procedure | Ada_Synchronized_Absent .. Ada_Type_Access_Def | Ada_Derived_Type_Def .. Ada_Until_Present | Ada_Variant | Ada_With_Private_Absent .. Ada_With_Private_Present =>
                  --# property-call-start AdaNode.xref_entry_point
                  Property_Result := Ada_Node_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Aspect_Assoc =>
                  --# property-call-start AspectAssoc.xref_entry_point
                  Property_Result := Aspect_Assoc_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_At_Clause .. Ada_Record_Rep_Clause =>
                  --# property-call-start AspectClause.xref_entry_point
                  Property_Result := Aspect_Clause_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Entry_Spec .. Ada_Subp_Spec =>
                  --# property-call-start BaseSubpSpec.xref_entry_point
                  Property_Result := Base_Subp_Spec_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Param_Assoc =>
                  --# property-call-start ParamAssoc.xref_entry_point
                  Property_Result := Param_Assoc_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Component_Decl =>
                  --# property-call-start ComponentDecl.xref_entry_point
                  Property_Result := Component_Decl_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Discriminant_Spec =>
                  --# property-call-start DiscriminantSpec.xref_entry_point
                  Property_Result := Discriminant_Spec_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Generic_Formal_Obj_Decl .. Ada_Generic_Formal_Type_Decl =>
                  --# property-call-start GenericFormal.xref_entry_point
                  Property_Result := Generic_Formal_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Param_Spec =>
                  --# property-call-start ParamSpec.xref_entry_point
                  Property_Result := Param_Spec_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Subtype_Decl =>
                  --# property-call-start SubtypeDecl.xref_entry_point
                  Property_Result := Subtype_Decl_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Type_Decl =>
                  --# property-call-start TypeDecl.xref_entry_point
                  Property_Result := Type_Decl_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Anonymous_Type_Decl .. Ada_Synth_Anonymous_Type_Decl =>
                  --# property-call-start AnonymousTypeDecl.xref_entry_point
                  Property_Result := Anonymous_Type_Decl_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Expr_Function =>
                  --# property-call-start ExprFunction.xref_entry_point
                  Property_Result := Expr_Function_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Subp_Renaming_Decl =>
                  --# property-call-start SubpRenamingDecl.xref_entry_point
                  Property_Result := Subp_Renaming_Decl_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Entry_Body =>
                  --# property-call-start EntryBody.xref_entry_point
                  Property_Result := Entry_Body_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Entry_Index_Spec =>
                  --# property-call-start EntryIndexSpec.xref_entry_point
                  Property_Result := Entry_Index_Spec_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Exception_Decl =>
                  --# property-call-start ExceptionDecl.xref_entry_point
                  Property_Result := Exception_Decl_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Exception_Handler =>
                  --# property-call-start ExceptionHandler.xref_entry_point
                  Property_Result := Exception_Handler_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Generic_Package_Instantiation .. Ada_Generic_Subp_Instantiation =>
                  --# property-call-start GenericInstantiation.xref_entry_point
                  Property_Result := Generic_Instantiation_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Generic_Package_Renaming_Decl .. Ada_Generic_Subp_Renaming_Decl =>
                  --# property-call-start GenericRenamingDecl.xref_entry_point
                  Property_Result := Generic_Renaming_Decl_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Number_Decl =>
                  --# property-call-start NumberDecl.xref_entry_point
                  Property_Result := Number_Decl_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Object_Decl .. Ada_Extended_Return_Stmt_Object_Decl =>
                  --# property-call-start ObjectDecl.xref_entry_point
                  Property_Result := Object_Decl_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Package_Renaming_Decl =>
                  --# property-call-start PackageRenamingDecl.xref_entry_point
                  Property_Result := Package_Renaming_Decl_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Case_Stmt_Alternative =>
                  --# property-call-start CaseStmtAlternative.xref_entry_point
                  Property_Result := Case_Stmt_Alternative_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Component_Clause =>
                  --# property-call-start ComponentClause.xref_entry_point
                  Property_Result := Component_Clause_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Elsif_Stmt_Part =>
                  --# property-call-start ElsifStmtPart.xref_entry_point
                  Property_Result := Elsif_Stmt_Part_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Defining_Name =>
                  --# property-call-start DefiningName.xref_entry_point
                  Property_Result := Defining_Name_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_End_Name =>
                  --# property-call-start EndName.xref_entry_point
                  Property_Result := End_Name_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_For_Loop_Spec =>
                  --# property-call-start ForLoopSpec.xref_entry_point
                  Property_Result := For_Loop_Spec_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Pragma_Node =>
                  --# property-call-start Pragma.xref_entry_point
                  Property_Result := Pragma_Node_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Accept_Stmt .. Ada_Terminate_Alternative =>
                  --# property-call-start Stmt.xref_entry_point
                  Property_Result := Stmt_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Subunit =>
                  --# property-call-start Subunit.xref_entry_point
                  Property_Result := Subunit_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Array_Type_Def =>
                  --# property-call-start ArrayTypeDef.xref_entry_point
                  Property_Result := Array_Type_Def_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Use_Package_Clause .. Ada_Use_Type_Clause =>
                  --# property-call-start UseClause.xref_entry_point
                  Property_Result := Use_Clause_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_Variant_Part =>
                  --# property-call-start VariantPart.xref_entry_point
                  Property_Result := Variant_Part_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
               when Ada_With_Clause =>
                  --# property-call-start WithClause.xref_entry_point
                  Property_Result := With_Clause_P_Xref_Entry_Point
                    (Self
                    );
                  --# end
      end case;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Dispatcher_Ada_Node_P_Xref_Entry_Point;
--# end
--# property-start AdaNode.resolve_names /tmp/lal-21.0.0/ada/language/ast.py:529
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Resolve_Names
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   Property_Result : Boolean;
            procedure Finalizer_Scope_36;
      Fld : Lexical_Env := Empty_Env;
Bound_Env : Lexical_Env := Empty_Env;
Fld_1 : Bare_Ada_Node;
Bound_Origin : Bare_Ada_Node;
Fld_2 : Boolean;
Dyn_Var_Bind_Result : Boolean;
Dyn_Var_Bind_Result_1 : Boolean;
Let_Result : Boolean;
            procedure Finalizer_Scope_36 is
            begin
                     Dec_Ref (Fld);
                     Dec_Ref (Bound_Env);
            end Finalizer_Scope_36;
      Mmz_Handle : Memoization_Handle;
      Mmz_Val    : Mmz_Value;
      function Create_Mmz_Key return Mmz_Key;
      --  Create a memoization key for this property call and return it
      --------------------
      -- Create_Mmz_Key --
      --------------------
      function Create_Mmz_Key return Mmz_Key is
      begin
         return Mmz_K : Mmz_Key :=
           (Property => Mmz_Bare_Ada_Node_Ada_Node_P_Resolve_Names,
            Items    => new Mmz_Key_Array (1 ..  2))
         do
            Mmz_K.Items (1) := (Kind => Mmz_Bare_Ada_Node,
                                As_Bare_Ada_Node => Self);
               Mmz_K.Items (2) :=
                 (Kind => Mmz_Internal_Entity_Info,
                  As_Internal_Entity_Info => E_Info);
         end return;
      end Create_Mmz_Key;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
            Populate_Lexical_Env (Self.Unit);
      end if;
      if Self = null then
         raise Property_Error with "property called on null node";
      end if;
      if not Self.Unit.Context.In_Populate_Lexical_Env then
         if Find_Memoized_Value
           (Self.Unit, Mmz_Handle, Mmz_Val, Create_Mmz_Key'Access)
         then
            --# memoization-lookup
            if Mmz_Val.Kind = Mmz_Evaluating then
               --# memoization-return
               raise Property_Error with "Infinite recursion detected";
            elsif Mmz_Val.Kind = Mmz_Property_Error then
               --# memoization-return
               raise Property_Error with "Memoized error";
            else
               Property_Result := Mmz_Val.As_Boolean;
               --# memoization-return
               Exit_Call (Self.Unit.Context, Call_Depth);
               return Property_Result;
            end if;
            --# end
         end if;
      end if;
   --# scope-start
      --# expr-start 291 '<Block>' Let_Result None
--# scope-start
--# expr-start 290 '<bind(<DynamicVariable env>, <FieldAccess .children_env>, <bind(<DynamicVariable origin>, <FieldAccess .origin_node>, <FieldAccess .resolve_names_internal>)>)>' Dyn_Var_Bind_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:535
--# expr-start 286 '<FieldAccess .children_env>' Fld /tmp/lal-21.0.0/ada/language/ast.py:536
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Libadalang.Implementation.Children_Env (Node => Ent.Node, E_Info => Ent.Info);
--# expr-done 286
Bound_Env := Fld; Inc_Ref (Bound_Env);
--# expr-start 289 '<bind(<DynamicVariable origin>, <FieldAccess .origin_node>, <FieldAccess .resolve_names_internal>)>' Dyn_Var_Bind_Result /tmp/lal-21.0.0/ada/language/ast.py:537
--# expr-start 287 '<FieldAccess .origin_node>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:537
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.origin_node
Fld_1 := Libadalang.Implementation.Ada_Node_P_Origin_Node (Node => Self);
--# end
--# expr-done 287
Bound_Origin := Fld_1; 
--# expr-start 288 '<FieldAccess .resolve_names_internal>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:537
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.resolve_names_internal
Fld_2 := Libadalang.Implementation.Ada_Node_P_Resolve_Names_Internal (Node => Ent.Node, Env => Bound_Env, Origin => Bound_Origin, E_Info => Ent.Info);
--# end
--# expr-done 288
Dyn_Var_Bind_Result := Fld_2; 
--# expr-done 289
Dyn_Var_Bind_Result_1 := Dyn_Var_Bind_Result; 
--# expr-done 290
Let_Result := Dyn_Var_Bind_Result_1; 
--# end
--# expr-done 291
      Property_Result := Let_Result;
   --# end
      Finalizer_Scope_36;
      if not Self.Unit.Context.In_Populate_Lexical_Env then
         Mmz_Val := (Kind => Mmz_Boolean,
                     As_Boolean => Property_Result);
         Add_Memoized_Value (Self.Unit, Mmz_Handle, Mmz_Val);
      end if;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_36;
         if Self /= null then
            if not Self.Unit.Context.In_Populate_Lexical_Env then
               Add_Memoized_Value
                 (Self.Unit, Mmz_Handle, (Kind => Mmz_Property_Error));
            end if;
         end if;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Resolve_Names;
--# end
--# property-start AdaNode.resolve_names_from_closest_entry_point /tmp/lal-21.0.0/ada/language/ast.py:541
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Resolve_Names_From_Closest_Entry_Point
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   Property_Result : Boolean;
            procedure Finalizer_Scope_37;
      Fld : Lexical_Env := Empty_Env;
Bound_Env : Lexical_Env := Empty_Env;
Fld_1 : Bare_Ada_Node;
Bound_Origin : Bare_Ada_Node;
Fld_2 : Boolean;
Dyn_Var_Bind_Result : Boolean;
Dyn_Var_Bind_Result_1 : Boolean;
Fld_3 : Internal_Entity;
Fld_4 : Boolean;
Fld_5 : Lexical_Env := Empty_Env;
Bound_Env_1 : Lexical_Env := Empty_Env;
Fld_6 : Bare_Ada_Node;
Bound_Origin_1 : Bare_Ada_Node;
Fld_7 : Boolean;
Dyn_Var_Bind_Result_2 : Boolean;
Dyn_Var_Bind_Result_3 : Boolean;
Fld_8 : Boolean;
If_Result : Boolean;
If_Result_1 : Boolean;
Fld_9 : Boolean;
If_Result_2 : Boolean;
Let_Result : Boolean;
            procedure Finalizer_Scope_37 is
            begin
                     Dec_Ref (Fld);
                     Dec_Ref (Bound_Env);
                     Dec_Ref (Fld_5);
                     Dec_Ref (Bound_Env_1);
            end Finalizer_Scope_37;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 308 '<Block>' Let_Result None
--# scope-start
--# expr-start 307 '<If>' If_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:563
--# expr-start 292 '<FieldAccess .xref_entry_point>' Fld_9 /tmp/lal-21.0.0/ada/language/ast.py:564
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]AdaNode.xref_entry_point'
Fld_9 := Libadalang.Implementation.Dispatcher_Ada_Node_P_Xref_Entry_Point (Node => Ent.Node);
--# end
--# expr-done 292
if Fld_9 then
   --# expr-start 297 '<bind(<DynamicVariable env>, <FieldAccess .children_env>, <bind(<DynamicVariable origin>, <FieldAccess .origin_node>, <FieldAccess .resolve_own_names>)>)>' Dyn_Var_Bind_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:565
--# expr-start 293 '<FieldAccess .children_env>' Fld /tmp/lal-21.0.0/ada/language/ast.py:566
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Libadalang.Implementation.Children_Env (Node => Ent.Node, E_Info => Ent.Info);
--# expr-done 293
Bound_Env := Fld; Inc_Ref (Bound_Env);
--# expr-start 296 '<bind(<DynamicVariable origin>, <FieldAccess .origin_node>, <FieldAccess .resolve_own_names>)>' Dyn_Var_Bind_Result /tmp/lal-21.0.0/ada/language/ast.py:567
--# expr-start 294 '<FieldAccess .origin_node>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:567
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.origin_node
Fld_1 := Libadalang.Implementation.Ada_Node_P_Origin_Node (Node => Self);
--# end
--# expr-done 294
Bound_Origin := Fld_1; 
--# expr-start 295 '<FieldAccess .resolve_own_names>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:567
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.resolve_own_names
Fld_2 := Libadalang.Implementation.Ada_Node_P_Resolve_Own_Names (Node => Ent.Node, Env => Bound_Env, Origin => Bound_Origin, E_Info => Ent.Info);
--# end
--# expr-done 295
Dyn_Var_Bind_Result := Fld_2; 
--# expr-done 296
Dyn_Var_Bind_Result_1 := Dyn_Var_Bind_Result; 
--# expr-done 297
   If_Result_2 := Dyn_Var_Bind_Result_1;
else
--# expr-start 299 '<FieldAccess .resolve_names_from_closest_entry_point>' Fld_4 /tmp/lal-21.0.0/ada/language/ast.py:570
--# expr-start 298 '<parent(<Var Ent>)>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:570
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_3 := Libadalang.Implementation.Parent (Node => Ent.Node, E_Info => Ent.Info);
--# expr-done 298
      if Fld_3.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.resolve_names_from_closest_entry_point
Fld_4 := Libadalang.Implementation.Ada_Node_P_Resolve_Names_From_Closest_Entry_Point (Node => Fld_3.Node, E_Info => Fld_3.Info);
--# end
--# expr-done 299
if Fld_4 then
   --# expr-start 306 '<If>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:570
--# expr-start 300 '<FieldAccess .xref_stop_resolution>' Fld_8 /tmp/lal-21.0.0/ada/language/ast.py:571
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]AdaNode.xref_stop_resolution'
Fld_8 := Libadalang.Implementation.Dispatcher_Ada_Node_P_Xref_Stop_Resolution (Node => Ent.Node);
--# end
--# expr-done 300
if Fld_8 then
   --# expr-start 305 '<bind(<DynamicVariable env>, <FieldAccess .children_env>, <bind(<DynamicVariable origin>, <FieldAccess .origin_node>, <FieldAccess .resolve_own_names>)>)>' Dyn_Var_Bind_Result_3 /tmp/lal-21.0.0/ada/language/ast.py:572
--# expr-start 301 '<FieldAccess .children_env>' Fld_5 /tmp/lal-21.0.0/ada/language/ast.py:573
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_5 := Libadalang.Implementation.Children_Env (Node => Ent.Node, E_Info => Ent.Info);
--# expr-done 301
Bound_Env_1 := Fld_5; Inc_Ref (Bound_Env_1);
--# expr-start 304 '<bind(<DynamicVariable origin>, <FieldAccess .origin_node>, <FieldAccess .resolve_own_names>)>' Dyn_Var_Bind_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:574
--# expr-start 302 '<FieldAccess .origin_node>' Fld_6 /tmp/lal-21.0.0/ada/language/ast.py:574
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.origin_node
Fld_6 := Libadalang.Implementation.Ada_Node_P_Origin_Node (Node => Self);
--# end
--# expr-done 302
Bound_Origin_1 := Fld_6; 
--# expr-start 303 '<FieldAccess .resolve_own_names>' Fld_7 /tmp/lal-21.0.0/ada/language/ast.py:575
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.resolve_own_names
Fld_7 := Libadalang.Implementation.Ada_Node_P_Resolve_Own_Names (Node => Ent.Node, Env => Bound_Env_1, Origin => Bound_Origin_1, E_Info => Ent.Info);
--# end
--# expr-done 303
Dyn_Var_Bind_Result_2 := Fld_7; 
--# expr-done 304
Dyn_Var_Bind_Result_3 := Dyn_Var_Bind_Result_2; 
--# expr-done 305
   If_Result := Dyn_Var_Bind_Result_3;
else
   If_Result := True;
end if;
--# expr-done 306
   If_Result_1 := If_Result;
else
   If_Result_1 := False;
end if;
   If_Result_2 := If_Result_1;
end if;
--# expr-done 307
Let_Result := If_Result_2; 
--# end
--# expr-done 308
      Property_Result := Let_Result;
   --# end
      Finalizer_Scope_37;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_37;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Resolve_Names_From_Closest_Entry_Point;
--# end
--# property-start AdaNode.parent_unit_env_helper /tmp/lal-21.0.0/ada/language/ast.py:582
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Parent_Unit_Env_Helper
  (Node : Bare_Ada_Node
      ; Unit : Internal_Unit
      ; Env : Lexical_Env
  )
   return Lexical_Env
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind unit Unit
   --# bind env Env
   Property_Result : Lexical_Env;
            procedure Finalizer_Scope_38;
            procedure Finalizer_Scope_1353;
            procedure Finalizer_Scope_1354;
      Var_Expr : Lexical_Env := Empty_Env;
Var_Expr_1 : Bare_Ada_Node;
Env_Parent : Lexical_Env := Empty_Env;
Env_Node : Bare_Ada_Node;
Fld : Lexical_Env := Empty_Env;
Fld_1 : Internal_Unit;
Is_Equal : Boolean;
If_Result : Lexical_Env := Empty_Env;
Scope_Result : Lexical_Env := Empty_Env;
Result_Var : Lexical_Env := Empty_Env;
Scope_Result_1 : Lexical_Env := Empty_Env;
Result_Var_1 : Lexical_Env := Empty_Env;
Let_Result : Lexical_Env := Empty_Env;
            procedure Finalizer_Scope_38 is
            begin
                     Dec_Ref (Env_Parent);
                     Dec_Ref (Scope_Result_1);
                     Dec_Ref (Result_Var_1);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_38;
            procedure Finalizer_Scope_1353 is
            begin
                     Dec_Ref (Var_Expr);
                     Dec_Ref (Scope_Result);
                     Dec_Ref (Result_Var);
            end Finalizer_Scope_1353;
            procedure Finalizer_Scope_1354 is
            begin
                     Dec_Ref (Fld);
                     Dec_Ref (If_Result);
            end Finalizer_Scope_1354;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 315 '<Block>' Let_Result None
--# scope-start
--# expr-start 309 '<env_parent(<Var env>)>' Env_Parent /tmp/lal-21.0.0/ada/language/ast.py:583
Env_Parent := AST_Envs.Parent (Env); 
--# expr-done 309
Var_Expr := Env_Parent;
      Inc_Ref (Var_Expr);
if Var_Expr /= Empty_Env then
   --# scope-start
   --# bind parent_env Var_Expr
--# expr-start 310 '<env_node(<Var parent_env>)>' Env_Node /tmp/lal-21.0.0/ada/language/ast.py:583
Env_Node := AST_Envs.Env_Node (Var_Expr); 
--# expr-done 310
Var_Expr_1 := Env_Node;
if Var_Expr_1 /= No_Bare_Ada_Node then
   --# scope-start
   --# bind parent_node Var_Expr_1
--# expr-start 314 '<If>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:584
--# expr-start 312 '<Eq>' Is_Equal /tmp/lal-21.0.0/ada/language/ast.py:585
--# expr-start 311 '<FieldAccess .unit>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:585
      if Var_Expr_1 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := Libadalang.Implementation.Unit (Node => Var_Expr_1);
--# expr-done 311
Is_Equal := Fld_1 = Unit; 
--# expr-done 312
if Is_Equal then
   --# expr-start 313 '<FieldAccess .parent_unit_env_helper(...)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:586
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.parent_unit_env_helper
Fld := Libadalang.Implementation.Ada_Node_P_Parent_Unit_Env_Helper (Node => Self, Unit => Unit, Env => Var_Expr);
--# end
--# expr-done 313
   If_Result := Fld;
else
   If_Result := Var_Expr;
end if;
      Inc_Ref (If_Result);
--# expr-done 314
Scope_Result := If_Result;
   Inc_Ref (Scope_Result);
   --# end
      Finalizer_Scope_1354;
   Result_Var := Scope_Result;
else
   Result_Var := Empty_Env;
end if;
      Inc_Ref (Result_Var);
Scope_Result_1 := Result_Var;
   Inc_Ref (Scope_Result_1);
   --# end
      Finalizer_Scope_1353;
   Result_Var_1 := Scope_Result_1;
else
   Result_Var_1 := Empty_Env;
end if;
      Inc_Ref (Result_Var_1);
Let_Result := Result_Var_1; Inc_Ref (Let_Result);
--# end
--# expr-done 315
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_38;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_38;
               Finalizer_Scope_1353;
               Finalizer_Scope_1354;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Parent_Unit_Env_Helper;
--# end
--# property-start AdaNode.parent_unit_env /tmp/lal-21.0.0/ada/language/ast.py:592
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Parent_Unit_Env
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
  )
   return Lexical_Env
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind env Env
   Property_Result : Lexical_Env;
            procedure Finalizer_Scope_39;
            procedure Finalizer_Scope_1355;
      Var_Expr : Lexical_Env := Empty_Env;
Env_Node : Bare_Ada_Node;
Fld : Internal_Unit;
Fld_1 : Lexical_Env := Empty_Env;
Scope_Result : Lexical_Env := Empty_Env;
Result_Var : Lexical_Env := Empty_Env;
Let_Result : Lexical_Env := Empty_Env;
            procedure Finalizer_Scope_39 is
            begin
                     Dec_Ref (Scope_Result);
                     Dec_Ref (Result_Var);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_39;
            procedure Finalizer_Scope_1355 is
            begin
                     Dec_Ref (Var_Expr);
                     Dec_Ref (Fld_1);
            end Finalizer_Scope_1355;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 319 '<Block>' Let_Result None
--# scope-start
Var_Expr := Env;
      Inc_Ref (Var_Expr);
if Var_Expr /= Empty_Env then
   --# scope-start
   --# bind env Var_Expr
--# expr-start 318 '<FieldAccess .parent_unit_env_helper(...)>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:598
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 317 '<FieldAccess .unit>' Fld /tmp/lal-21.0.0/ada/language/ast.py:598
--# expr-start 316 '<env_node(<Var env>)>' Env_Node /tmp/lal-21.0.0/ada/language/ast.py:598
Env_Node := AST_Envs.Env_Node (Var_Expr); 
--# expr-done 316
      if Env_Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Libadalang.Implementation.Unit (Node => Env_Node);
--# expr-done 317
--# property-call-start AdaNode.parent_unit_env_helper
Fld_1 := Libadalang.Implementation.Ada_Node_P_Parent_Unit_Env_Helper (Node => Self, Unit => Fld, Env => Var_Expr);
--# end
--# expr-done 318
Scope_Result := Fld_1;
   Inc_Ref (Scope_Result);
   --# end
      Finalizer_Scope_1355;
   Result_Var := Scope_Result;
else
   Result_Var := Empty_Env;
end if;
      Inc_Ref (Result_Var);
Let_Result := Result_Var; Inc_Ref (Let_Result);
--# end
--# expr-done 319
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_39;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_39;
               Finalizer_Scope_1355;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Parent_Unit_Env;
--# end
--# property-start AdaNode.std /tmp/lal-21.0.0/ada/language/ast.py:610
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Std
  (Node : Bare_Ada_Node
  )
   return Internal_Entity_Basic_Decl
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Internal_Entity_Basic_Decl;
      Fld : Internal_Unit;
Fld_1 : Bare_Ada_Node;
Cast_Result : Bare_Compilation_Unit;
Fld_2 : Bare_Ada_Node;
Cast_Result_1 : Bare_Library_Item;
Fld_3 : Bare_Basic_Decl;
As_Entity : Internal_Entity_Basic_Decl;
Is_Null : Boolean;
If_Result : Internal_Entity_Basic_Decl;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 326 '<as_bare_entity(<FieldAccess .item>)>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:611
--# expr-start 325 '<FieldAccess .item>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:611
--# expr-start 324 '<Cast to LibraryItem>' Cast_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:611
--# expr-start 323 '<FieldAccess .body>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:611
--# expr-start 322 '<Cast to CompilationUnit>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:611
--# expr-start 321 '<FieldAccess .root>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:611
--# expr-start 320 '<FieldAccess .standard_unit>' Fld /tmp/lal-21.0.0/ada/language/ast.py:611
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Libadalang.Implementation.Extensions.Ada_Node_P_Standard_Unit (Node => Self);
--# expr-done 320
      if Fld = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := Fld.AST_Root;
--# expr-done 321
   if Fld_1 = null
      or else Fld_1.Kind in Ada_Compilation_Unit_Range
   then
      Cast_Result := Fld_1;
   else
         Cast_Result := No_Bare_Ada_Node;
   end if;
--# expr-done 322
      if Cast_Result = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_2 := Cast_Result.Compilation_Unit_F_Body;
--# expr-done 323
   if Fld_2 = null
      or else Fld_2.Kind in Ada_Library_Item_Range
   then
      Cast_Result_1 := Fld_2;
   else
         Cast_Result_1 := No_Bare_Ada_Node;
   end if;
--# expr-done 324
      if Cast_Result_1 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_3 := Cast_Result_1.Library_Item_F_Item;
--# expr-done 325
Is_Null := Fld_3 = null; 
if Is_Null then
   If_Result := No_Entity_Basic_Decl;
else
As_Entity := (Info => No_Entity_Info, Node => Fld_3); 
   If_Result := As_Entity;
end if;
--# expr-done 326
      Property_Result := If_Result;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Std;
--# end
--# property-start AdaNode.std_env /tmp/lal-21.0.0/ada/language/ast.py:619
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Std_Env
  (Node : Bare_Ada_Node
  )
   return Lexical_Env
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Lexical_Env;
            procedure Finalizer_Scope_42;
      Fld : Internal_Entity_Basic_Decl;
Fld_1 : Lexical_Env := Empty_Env;
            procedure Finalizer_Scope_42 is
            begin
                     Dec_Ref (Fld_1);
            end Finalizer_Scope_42;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 328 '<FieldAccess .children_env>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:620
--# expr-start 327 '<FieldAccess .std>' Fld /tmp/lal-21.0.0/ada/language/ast.py:620
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.std
Fld := Libadalang.Implementation.Ada_Node_P_Std (Node => Self);
--# end
--# expr-done 327
      if Fld.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := Libadalang.Implementation.Children_Env (Node => Fld.Node, E_Info => Fld.Info);
--# expr-done 328
      Property_Result := Fld_1;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_42;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_42;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Std_Env;
--# end
--# property-start AdaNode.std_entity /tmp/lal-21.0.0/ada/language/ast.py:624
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Std_Entity
  (Node : Bare_Ada_Node
      ; Sym : Symbol_Type
  )
   return Internal_Entity
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind sym Sym
   Property_Result : Internal_Entity;
      Fld : Internal_Unit;
Fld_1 : Bare_Ada_Node;
Fld_2 : Internal_Entity;
Let_Result : Internal_Entity;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
            Populate_Lexical_Env (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 332 '<Block>' Let_Result None
--# scope-start
--# expr-start 331 '<FieldAccess .std_entity_implem(...)>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:625
--# expr-start 330 '<FieldAccess .root>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:625
--# expr-start 329 '<FieldAccess .unit>' Fld /tmp/lal-21.0.0/ada/language/ast.py:625
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Libadalang.Implementation.Unit (Node => Self);
--# expr-done 329
      if Fld = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := Fld.AST_Root;
--# expr-done 330
      if Fld_1 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.std_entity_implem
Fld_2 := Libadalang.Implementation.Ada_Node_P_Std_Entity_Implem (Node => Fld_1, Sym => Sym);
--# end
--# expr-done 331
Let_Result := Fld_2; 
--# end
--# expr-done 332
      Property_Result := Let_Result;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Std_Entity;
--# end
--# property-start AdaNode.std_entity_implem /tmp/lal-21.0.0/ada/language/ast.py:631
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Std_Entity_Implem
  (Node : Bare_Ada_Node
      ; Sym : Symbol_Type
  )
   return Internal_Entity
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind sym Sym
   Property_Result : Internal_Entity;
            procedure Finalizer_Scope_44;
      Fld : Lexical_Env := Empty_Env;
Env_Get_Result : Internal_Entity;
Let_Result : Internal_Entity;
            procedure Finalizer_Scope_44 is
            begin
                     Dec_Ref (Fld);
            end Finalizer_Scope_44;
      Mmz_Handle : Memoization_Handle;
      Mmz_Val    : Mmz_Value;
      function Create_Mmz_Key return Mmz_Key;
      --  Create a memoization key for this property call and return it
      --------------------
      -- Create_Mmz_Key --
      --------------------
      function Create_Mmz_Key return Mmz_Key is
      begin
         return Mmz_K : Mmz_Key :=
           (Property => Mmz_Bare_Ada_Node_Ada_Node_P_Std_Entity_Implem,
            Items    => new Mmz_Key_Array (1 ..  2))
         do
            Mmz_K.Items (1) := (Kind => Mmz_Bare_Ada_Node,
                                As_Bare_Ada_Node => Self);
               Mmz_K.Items (2) := (Kind => Mmz_Symbol_Type,
                                      As_Symbol_Type => Sym);
         end return;
      end Create_Mmz_Key;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
      if Self = null then
         raise Property_Error with "property called on null node";
      end if;
      if not Self.Unit.Context.In_Populate_Lexical_Env then
         if Find_Memoized_Value
           (Self.Unit, Mmz_Handle, Mmz_Val, Create_Mmz_Key'Access)
         then
            --# memoization-lookup
            if Mmz_Val.Kind = Mmz_Evaluating then
               --# memoization-return
               raise Property_Error with "Infinite recursion detected";
            elsif Mmz_Val.Kind = Mmz_Property_Error then
               --# memoization-return
               raise Property_Error with "Memoized error";
            else
               Property_Result := Mmz_Val.As_Internal_Entity;
               --# memoization-return
               Exit_Call (Self.Unit.Context, Call_Depth);
               return Property_Result;
            end if;
            --# end
         end if;
      end if;
   --# scope-start
      --# expr-start 335 '<Block>' Let_Result None
--# scope-start
--# expr-start 334 '<EnvGet(<FieldAccess .std_env>, <Var sym>)>' Env_Get_Result /tmp/lal-21.0.0/ada/language/ast.py:632
--# expr-start 333 '<FieldAccess .std_env>' Fld /tmp/lal-21.0.0/ada/language/ast.py:632
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.std_env
Fld := Libadalang.Implementation.Ada_Node_P_Std_Env (Node => Self);
--# end
--# expr-done 333
Env_Get_Result := AST_Envs.Get_First (Self => Fld, Key => Sym, Lookup_Kind => To_Lookup_Kind_Type (Recursive), Categories => (Inherited_Primitives => False, Nocat => True)); 
--# expr-done 334
Let_Result := Env_Get_Result; 
--# end
--# expr-done 335
      Property_Result := Let_Result;
   --# end
      Finalizer_Scope_44;
      if not Self.Unit.Context.In_Populate_Lexical_Env then
         Mmz_Val := (Kind => Mmz_Internal_Entity,
                     As_Internal_Entity => Property_Result);
         Add_Memoized_Value (Self.Unit, Mmz_Handle, Mmz_Val);
      end if;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_44;
         if Self /= null then
            if not Self.Unit.Context.In_Populate_Lexical_Env then
               Add_Memoized_Value
                 (Self.Unit, Mmz_Handle, (Kind => Mmz_Property_Error));
            end if;
         end if;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Std_Entity_Implem;
--# end
--# property-start AdaNode.bool_type /tmp/lal-21.0.0/ada/language/ast.py:636
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Bool_Type
  (Node : Bare_Ada_Node
  )
   return Internal_Entity
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Internal_Entity;
      Sym : Symbol_Type;
Fld : Internal_Entity;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
            Populate_Lexical_Env (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 337 '<FieldAccess .std_entity(...)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:637
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 336 '<Symbol Boolean>' Sym None
Sym := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Boolean); 
--# expr-done 336
--# property-call-start AdaNode.std_entity
Fld := Libadalang.Implementation.Ada_Node_P_Std_Entity (Node => Self, Sym => Sym);
--# end
--# expr-done 337
      Property_Result := Fld;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Bool_Type;
--# end
--# property-start AdaNode.int_type /tmp/lal-21.0.0/ada/language/ast.py:641
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Int_Type
  (Node : Bare_Ada_Node
  )
   return Internal_Entity
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Internal_Entity;
      Sym : Symbol_Type;
Fld : Internal_Entity;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
            Populate_Lexical_Env (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 339 '<FieldAccess .std_entity(...)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:642
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 338 '<Symbol Integer>' Sym None
Sym := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Integer); 
--# expr-done 338
--# property-call-start AdaNode.std_entity
Fld := Libadalang.Implementation.Ada_Node_P_Std_Entity (Node => Self, Sym => Sym);
--# end
--# expr-done 339
      Property_Result := Fld;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Int_Type;
--# end
--# property-start AdaNode.universal_int_type /tmp/lal-21.0.0/ada/language/ast.py:646
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Universal_Int_Type
  (Node : Bare_Ada_Node
  )
   return Internal_Entity
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Internal_Entity;
      Sym : Symbol_Type;
Fld : Internal_Entity;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
            Populate_Lexical_Env (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 341 '<FieldAccess .std_entity(...)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:647
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 340 '<Symbol Universal_Int_Type_>' Sym None
Sym := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Universal_Int_Type); 
--# expr-done 340
--# property-call-start AdaNode.std_entity
Fld := Libadalang.Implementation.Ada_Node_P_Std_Entity (Node => Self, Sym => Sym);
--# end
--# expr-done 341
      Property_Result := Fld;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Universal_Int_Type;
--# end
--# property-start AdaNode.universal_real_type /tmp/lal-21.0.0/ada/language/ast.py:651
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Universal_Real_Type
  (Node : Bare_Ada_Node
  )
   return Internal_Entity
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Internal_Entity;
      Sym : Symbol_Type;
Fld : Internal_Entity;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
            Populate_Lexical_Env (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 343 '<FieldAccess .std_entity(...)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:652
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 342 '<Symbol Universal_Real_Type_>' Sym None
Sym := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Universal_Real_Type); 
--# expr-done 342
--# property-call-start AdaNode.std_entity
Fld := Libadalang.Implementation.Ada_Node_P_Std_Entity (Node => Self, Sym => Sym);
--# end
--# expr-done 343
      Property_Result := Fld;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Universal_Real_Type;
--# end
--# property-start AdaNode.exc_id_type /tmp/lal-21.0.0/ada/language/ast.py:657
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Exc_Id_Type
  (Node : Bare_Ada_Node
  )
   return Internal_Entity_Base_Type_Decl
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Internal_Entity_Base_Type_Decl;
            procedure Finalizer_Scope_49;
            procedure Finalizer_Scope_1356;
      Var_Expr : Bare_Basic_Decl;
Sym : Symbol_Type;
Sym_1 : Symbol_Type;
Array_Lit : Symbol_Type_Array_Access;
Fld : Bare_Basic_Decl;
Fld_1 : Lexical_Env := Empty_Env;
Scope_Result : Lexical_Env := Empty_Env;
Result_Var : Lexical_Env := Empty_Env;
Sym_2 : Symbol_Type;
Env_Get_Result : Internal_Entity;
Cast_Result : Internal_Entity_Base_Type_Decl;
            procedure Finalizer_Scope_49 is
            begin
                     Dec_Ref (Array_Lit);
                     Dec_Ref (Scope_Result);
                     Dec_Ref (Result_Var);
            end Finalizer_Scope_49;
            procedure Finalizer_Scope_1356 is
            begin
                     Dec_Ref (Fld_1);
            end Finalizer_Scope_1356;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 351 '<Cast to BaseTypeDecl>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:658
--# expr-start 350 '<EnvGet(<Then <FieldAccess .get_unit_root_decl(...)>: <Var Var_Expr> <FieldAccess .children_env>>, Exception_Id)>' Env_Get_Result /tmp/lal-21.0.0/ada/language/ast.py:658
--# expr-start 347 '<FieldAccess .get_unit_root_decl(...)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:658
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 346 '<ArrayLiteral>' Array_Lit None
--# expr-start 344 '<Symbol Ada>' Sym None
Sym := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Ada); 
--# expr-done 344
--# expr-start 345 '<Symbol Exceptions>' Sym_1 None
Sym_1 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Exceptions); 
--# expr-done 345
Array_Lit := Create_Symbol_Type_Array (Internal_Symbol_Type_Array'(1 => Sym, 2 => Sym_1)); 
--# expr-done 346
--# property-call-start AdaNode.get_unit_root_decl
Fld := Libadalang.Implementation.Ada_Node_P_Get_Unit_Root_Decl (Node => Self, Name => Array_Lit, Kind => Unit_Specification);
--# end
--# expr-done 347
Var_Expr := Fld;
if Var_Expr /= No_Bare_Ada_Node then
   --# scope-start
--# expr-start 348 '<FieldAccess .children_env>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:658
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := Libadalang.Implementation.Children_Env (Node => Var_Expr);
--# expr-done 348
Scope_Result := Fld_1;
   Inc_Ref (Scope_Result);
   --# end
      Finalizer_Scope_1356;
   Result_Var := Scope_Result;
else
   Result_Var := Empty_Env;
end if;
      Inc_Ref (Result_Var);
--# expr-start 349 '<Symbol Exception_Id>' Sym_2 None
Sym_2 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Exception_Id); 
--# expr-done 349
Env_Get_Result := AST_Envs.Get_First (Self => Result_Var, Key => Sym_2, Lookup_Kind => To_Lookup_Kind_Type (Flat), Categories => (Inherited_Primitives => True, Nocat => True)); 
--# expr-done 350
   if Env_Get_Result.Node = null
      or else Env_Get_Result.Node.Kind in Ada_Base_Type_Decl
   then
      Cast_Result := Create_Internal_Entity_Base_Type_Decl
        (Node => Env_Get_Result.Node,
         Info => Env_Get_Result.Info);
   else
         Cast_Result := No_Entity_Base_Type_Decl;
   end if;
--# expr-done 351
      Property_Result := Cast_Result;
   --# end
      Finalizer_Scope_49;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_49;
               Finalizer_Scope_1356;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Exc_Id_Type;
--# end
--# property-start AdaNode.task_id_type /tmp/lal-21.0.0/ada/language/ast.py:667
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Task_Id_Type
  (Node : Bare_Ada_Node
  )
   return Internal_Entity_Base_Type_Decl
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Internal_Entity_Base_Type_Decl;
            procedure Finalizer_Scope_50;
            procedure Finalizer_Scope_1357;
      Var_Expr : Bare_Basic_Decl;
Sym : Symbol_Type;
Sym_1 : Symbol_Type;
Array_Lit : Symbol_Type_Array_Access;
Fld : Bare_Basic_Decl;
Fld_1 : Lexical_Env := Empty_Env;
Scope_Result : Lexical_Env := Empty_Env;
Result_Var : Lexical_Env := Empty_Env;
Sym_2 : Symbol_Type;
Env_Get_Result : Internal_Entity;
Cast_Result : Internal_Entity_Base_Type_Decl;
            procedure Finalizer_Scope_50 is
            begin
                     Dec_Ref (Array_Lit);
                     Dec_Ref (Scope_Result);
                     Dec_Ref (Result_Var);
            end Finalizer_Scope_50;
            procedure Finalizer_Scope_1357 is
            begin
                     Dec_Ref (Fld_1);
            end Finalizer_Scope_1357;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 359 '<Cast to BaseTypeDecl>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:668
--# expr-start 358 '<EnvGet(<Then <FieldAccess .get_unit_root_decl(...)>: <Var Var_Expr> <FieldAccess .children_env>>, Task_Id)>' Env_Get_Result /tmp/lal-21.0.0/ada/language/ast.py:668
--# expr-start 355 '<FieldAccess .get_unit_root_decl(...)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:668
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 354 '<ArrayLiteral>' Array_Lit None
--# expr-start 352 '<Symbol Ada>' Sym None
Sym := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Ada); 
--# expr-done 352
--# expr-start 353 '<Symbol Task_Identification>' Sym_1 None
Sym_1 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Task_Identification); 
--# expr-done 353
Array_Lit := Create_Symbol_Type_Array (Internal_Symbol_Type_Array'(1 => Sym, 2 => Sym_1)); 
--# expr-done 354
--# property-call-start AdaNode.get_unit_root_decl
Fld := Libadalang.Implementation.Ada_Node_P_Get_Unit_Root_Decl (Node => Self, Name => Array_Lit, Kind => Unit_Specification);
--# end
--# expr-done 355
Var_Expr := Fld;
if Var_Expr /= No_Bare_Ada_Node then
   --# scope-start
--# expr-start 356 '<FieldAccess .children_env>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:668
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := Libadalang.Implementation.Children_Env (Node => Var_Expr);
--# expr-done 356
Scope_Result := Fld_1;
   Inc_Ref (Scope_Result);
   --# end
      Finalizer_Scope_1357;
   Result_Var := Scope_Result;
else
   Result_Var := Empty_Env;
end if;
      Inc_Ref (Result_Var);
--# expr-start 357 '<Symbol Task_Id>' Sym_2 None
Sym_2 := Precomputed_Symbol (Precomputed_Symbol_Table (Self.Unit.Context.Symbols), Precomputed_Symbol_Task_Id); 
--# expr-done 357
Env_Get_Result := AST_Envs.Get_First (Self => Result_Var, Key => Sym_2, Lookup_Kind => To_Lookup_Kind_Type (Flat), Categories => (Inherited_Primitives => True, Nocat => True)); 
--# expr-done 358
   if Env_Get_Result.Node = null
      or else Env_Get_Result.Node.Kind in Ada_Base_Type_Decl
   then
      Cast_Result := Create_Internal_Entity_Base_Type_Decl
        (Node => Env_Get_Result.Node,
         Info => Env_Get_Result.Info);
   else
         Cast_Result := No_Entity_Base_Type_Decl;
   end if;
--# expr-done 359
      Property_Result := Cast_Result;
   --# end
      Finalizer_Scope_50;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_50;
               Finalizer_Scope_1357;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Task_Id_Type;
--# end
--# property-start AdaNode.has_with_visibility /tmp/lal-21.0.0/ada/language/ast.py:677
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Has_With_Visibility
  (Node : Bare_Ada_Node
      ; Refd_Unit : Internal_Unit
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind refd_unit Refd_Unit
   Property_Result : Boolean;
            procedure Finalizer_Scope_51;
      Var_Expr : Bare_Ada_Node;
Var_Expr_1 : Bare_Compilation_Unit;
Fld : Internal_Unit;
Fld_1 : Boolean;
Fld_2 : Internal_Unit;
Fld_3 : Bare_Basic_Decl;
Fld_4 : Lexical_Env := Empty_Env;
Fld_5 : Lexical_Env := Empty_Env;
Env_Node : Bare_Ada_Node;
Fld_6 : Boolean;
Scope_Result : Boolean;
Result_Var : Boolean;
If_Result : Boolean;
Fld_7 : Bare_Ada_Node;
Cast_Result : Bare_Compilation_Unit;
Fld_8 : Boolean;
Scope_Result_1 : Boolean;
Result_Var_1 : Boolean;
If_Result_1 : Boolean;
Let_Result : Boolean;
            procedure Finalizer_Scope_51 is
            begin
                     Dec_Ref (Fld_4);
                     Dec_Ref (Fld_5);
            end Finalizer_Scope_51;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 371 '<Block>' Let_Result None
--# scope-start
--# expr-start 361 '<FieldAccess .is_referenced_from(...)>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:685
      if Refd_Unit = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 360 '<FieldAccess .unit>' Fld /tmp/lal-21.0.0/ada/language/ast.py:685
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Libadalang.Implementation.Unit (Node => Self);
--# expr-done 360
Fld_1 := Libadalang.Implementation.Is_Referenced_From (Self => Refd_Unit, Unit => Fld);
--# expr-done 361
if Fld_1 then
   If_Result := True;
else
--# expr-start 366 '<env_node(<FieldAccess .parent_unit_env(...)>)>' Env_Node /tmp/lal-21.0.0/ada/language/ast.py:686
--# expr-start 365 '<FieldAccess .parent_unit_env(...)>' Fld_5 /tmp/lal-21.0.0/ada/language/ast.py:686
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 364 '<FieldAccess .children_env>' Fld_4 /tmp/lal-21.0.0/ada/language/ast.py:691
--# expr-start 363 '<FieldAccess .top_level_decl(...)>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:691
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 362 '<FieldAccess .unit>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:691
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_2 := Libadalang.Implementation.Unit (Node => Self);
--# expr-done 362
--# property-call-start AdaNode.top_level_decl
Fld_3 := Libadalang.Implementation.Ada_Node_P_Top_Level_Decl (Node => Self, Unit => Fld_2);
--# end
--# expr-done 363
      if Fld_3 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_4 := Libadalang.Implementation.Children_Env (Node => Fld_3);
--# expr-done 364
--# property-call-start AdaNode.parent_unit_env
Fld_5 := Libadalang.Implementation.Ada_Node_P_Parent_Unit_Env (Node => Self, Env => Fld_4);
--# end
--# expr-done 365
Env_Node := AST_Envs.Env_Node (Fld_5); 
--# expr-done 366
Var_Expr := Env_Node;
if Var_Expr /= No_Bare_Ada_Node then
   --# scope-start
--# expr-start 367 '<FieldAccess .has_with_visibility(...)>' Fld_6 /tmp/lal-21.0.0/ada/language/ast.py:686
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.has_with_visibility
Fld_6 := Libadalang.Implementation.Ada_Node_P_Has_With_Visibility (Node => Var_Expr, Refd_Unit => Refd_Unit);
--# end
--# expr-done 367
Scope_Result := Fld_6;
   --# end
   Result_Var := Scope_Result;
else
   Result_Var := False;
end if;
   If_Result := Result_Var;
end if;
if If_Result then
   If_Result_1 := True;
else
--# expr-start 369 '<Cast to CompilationUnit>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:702
--# expr-start 368 '<FieldAccess .root>' Fld_7 /tmp/lal-21.0.0/ada/language/ast.py:702
      if Refd_Unit = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_7 := Refd_Unit.AST_Root;
--# expr-done 368
   if Fld_7 = null
      or else Fld_7.Kind in Ada_Compilation_Unit_Range
   then
      Cast_Result := Fld_7;
   else
         Cast_Result := No_Bare_Ada_Node;
   end if;
--# expr-done 369
Var_Expr_1 := Cast_Result;
if Var_Expr_1 /= No_Bare_Ada_Node then
   --# scope-start
--# expr-start 370 '<FieldAccess .is_text_io_child>' Fld_8 /tmp/lal-21.0.0/ada/language/ast.py:702
      if Var_Expr_1 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start CompilationUnit.is_text_io_child
Fld_8 := Libadalang.Implementation.Compilation_Unit_P_Is_Text_Io_Child (Node => Var_Expr_1);
--# end
--# expr-done 370
Scope_Result_1 := Fld_8;
   --# end
   Result_Var_1 := Scope_Result_1;
else
   Result_Var_1 := False;
end if;
   If_Result_1 := Result_Var_1;
end if;
Let_Result := If_Result_1; 
--# end
--# expr-done 371
      Property_Result := Let_Result;
   --# end
      Finalizer_Scope_51;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_51;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Has_With_Visibility;
--# end
--# property-start AdaNode.has_visibility /tmp/lal-21.0.0/ada/language/ast.py:706
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Has_Visibility
  (Node : Bare_Ada_Node
      ; Other_Entity : Internal_Entity
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind other_entity Other_Entity
   Property_Result : Boolean;
      Var_Expr : Internal_Entity_Generic_Package_Instantiation;
Var_Expr_1 : Internal_Entity_Package_Renaming_Decl;
Cast_Expr : Internal_Entity;
Cast_Result : Internal_Entity_Generic_Package_Instantiation;
Fld : Internal_Entity_Info;
Fld_1 : Boolean;
Scope_Result : Boolean;
Result_Var : Boolean;
Cast_Expr_1 : Internal_Entity;
Cast_Result_1 : Internal_Entity_Package_Renaming_Decl;
Fld_2 : Internal_Entity_Info;
Fld_3 : Boolean;
Scope_Result_1 : Boolean;
Result_Var_1 : Boolean;
If_Result : Boolean;
Cast_Expr_2 : Internal_Entity;
Cast_Result_2 : Internal_Entity_Basic_Decl;
Fld_4 : Boolean;
Not_Val : Boolean;
If_Result_1 : Boolean;
Fld_5 : Bare_Ada_Node;
Fld_6 : Internal_Unit;
Fld_7 : Boolean;
If_Result_2 : Boolean;
Let_Result : Boolean;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 384 '<Block>' Let_Result None
--# scope-start
--# expr-start 372 '<Cast to GenericPackageInstantiation>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:710
Cast_Expr := Other_Entity; 
   if Cast_Expr.Node = null
      or else Cast_Expr.Node.Kind in Ada_Generic_Package_Instantiation_Range
   then
      Cast_Result := Create_Internal_Entity_Generic_Package_Instantiation
        (Node => Cast_Expr.Node,
         Info => Cast_Expr.Info);
   else
         Cast_Result := No_Entity_Generic_Package_Instantiation;
   end if;
--# expr-done 372
Var_Expr := Cast_Result;
if Var_Expr /= No_Entity_Generic_Package_Instantiation then
   --# scope-start
--# expr-start 374 '<FieldAccess .from_rebound>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:710
--# expr-start 373 '<FieldAccess .info>' Fld /tmp/lal-21.0.0/ada/language/ast.py:710
Fld := Var_Expr.Info;
--# expr-done 373
Fld_1 := Fld.From_Rebound;
--# expr-done 374
Scope_Result := Fld_1;
   --# end
   Result_Var := Scope_Result;
else
   Result_Var := False;
end if;
if Result_Var then
   If_Result := True;
else
--# expr-start 375 '<Cast to PackageRenamingDecl>' Cast_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:712
Cast_Expr_1 := Other_Entity; 
   if Cast_Expr_1.Node = null
      or else Cast_Expr_1.Node.Kind in Ada_Package_Renaming_Decl_Range
   then
      Cast_Result_1 := Create_Internal_Entity_Package_Renaming_Decl
        (Node => Cast_Expr_1.Node,
         Info => Cast_Expr_1.Info);
   else
         Cast_Result_1 := No_Entity_Package_Renaming_Decl;
   end if;
--# expr-done 375
Var_Expr_1 := Cast_Result_1;
if Var_Expr_1 /= No_Entity_Package_Renaming_Decl then
   --# scope-start
--# expr-start 377 '<FieldAccess .from_rebound>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:712
--# expr-start 376 '<FieldAccess .info>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:712
Fld_2 := Var_Expr_1.Info;
--# expr-done 376
Fld_3 := Fld_2.From_Rebound;
--# expr-done 377
Scope_Result_1 := Fld_3;
   --# end
   Result_Var_1 := Scope_Result_1;
else
   Result_Var_1 := False;
end if;
   If_Result := Result_Var_1;
end if;
if If_Result then
   If_Result_1 := True;
else
   --# expr-start 380 '<Not>' Not_Val /tmp/lal-21.0.0/ada/language/ast.py:715
--# expr-start 379 '<FieldAccess .is_compilation_unit_root>' Fld_4 /tmp/lal-21.0.0/ada/language/ast.py:715
--# expr-start 378 '<Cast to BasicDecl>' Cast_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:715
Cast_Expr_2 := Other_Entity; 
   if Cast_Expr_2.Node = null
      or else Cast_Expr_2.Node.Kind in Ada_Basic_Decl
   then
      Cast_Result_2 := Create_Internal_Entity_Basic_Decl
        (Node => Cast_Expr_2.Node,
         Info => Cast_Expr_2.Info);
   else
         Cast_Result_2 := No_Entity_Basic_Decl;
   end if;
--# expr-done 378
      if Cast_Result_2.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start BasicDecl.is_compilation_unit_root
Fld_4 := Libadalang.Implementation.Basic_Decl_P_Is_Compilation_Unit_Root (Node => Cast_Result_2.Node);
--# end
--# expr-done 379
Not_Val := not (Fld_4); 
--# expr-done 380
   If_Result_1 := Not_Val;
end if;
if If_Result_1 then
   If_Result_2 := True;
else
   --# expr-start 383 '<FieldAccess .has_with_visibility(...)>' Fld_7 /tmp/lal-21.0.0/ada/language/ast.py:718
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# expr-start 382 '<FieldAccess .unit>' Fld_6 /tmp/lal-21.0.0/ada/language/ast.py:718
--# expr-start 381 '<FieldAccess .node>' Fld_5 /tmp/lal-21.0.0/ada/language/ast.py:718
Fld_5 := Other_Entity.Node;
--# expr-done 381
      if Fld_5 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_6 := Libadalang.Implementation.Unit (Node => Fld_5);
--# expr-done 382
--# property-call-start AdaNode.has_with_visibility
Fld_7 := Libadalang.Implementation.Ada_Node_P_Has_With_Visibility (Node => Self, Refd_Unit => Fld_6);
--# end
--# expr-done 383
   If_Result_2 := Fld_7;
end if;
Let_Result := If_Result_2; 
--# end
--# expr-done 384
      Property_Result := Let_Result;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Has_Visibility;
--# end
--# property-start AdaNode.resolve_generic_actual /tmp/lal-21.0.0/ada/language/ast.py:722
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Resolve_Generic_Actual
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Internal_Entity
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   Property_Result : Internal_Entity;
            procedure Finalizer_Scope_1371;
      Match_0 : Internal_Entity_Anonymous_Object_Decl;
Match_1 : Internal_Entity_Name;
Match_2 : Internal_Entity;
Var_Expr : Internal_Entity;
Fld : Internal_Entity_Base_Type_Decl;
Cast_Result : Internal_Entity;
Scope_Result : Internal_Entity;
Fld_1 : Lexical_Env := Empty_Env;
Bound_Env : Lexical_Env := Empty_Env;
Fld_2 : Internal_Entity_Array_Access;
Get_Result : Internal_Entity;
Dyn_Var_Bind_Result : Internal_Entity;
Result_Var : Internal_Entity;
Match_Prefix : Internal_Entity;
Cast_Result_1 : Internal_Entity_Anonymous_Object_Decl;
Cast_Expr : Internal_Entity_Anonymous_Object_Decl;
Cast_Result_2 : Internal_Entity;
Let_Result : Internal_Entity;
Scope_Result_1 : Internal_Entity;
Cast_Result_3 : Internal_Entity_Name;
Let_Result_1 : Internal_Entity;
Scope_Result_2 : Internal_Entity;
Cast_Result_4 : Internal_Entity;
Let_Result_2 : Internal_Entity;
Scope_Result_3 : Internal_Entity;
Match_Result : Internal_Entity;
Let_Result_3 : Internal_Entity;
            procedure Finalizer_Scope_1371 is
            begin
                     Dec_Ref (Fld_1);
                     Dec_Ref (Bound_Env);
                     Dec_Ref (Fld_2);
            end Finalizer_Scope_1371;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 392 '<Block>' Let_Result_3 None
--# scope-start
--# expr-start 391 '<Match>' Match_Result /tmp/lal-21.0.0/ada/language/ast.py:726
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Match_Prefix := Ent; 
case Ada_Ada_Node (Match_Prefix.Node.Kind) is
         when Ada_Anonymous_Object_Decl =>
   --# scope-start
--# scope-start
      Cast_Result_1 := Create_Internal_Entity_Anonymous_Object_Decl
        (Node => Match_Prefix.Node,
         Info => Match_Prefix.Info);
Match_0 := Cast_Result_1; 
--# bind aod Match_0
Cast_Expr := Match_0; 
      Cast_Result_2 := Create_Internal_Entity
        (Node => Cast_Expr.Node,
         Info => Cast_Expr.Info);
Let_Result := Cast_Result_2; 
--# end
Scope_Result_1 := Let_Result;
   --# end
            Match_Result := Scope_Result_1; 
         when Ada_Attribute_Ref .. Ada_Target_Name =>
   --# scope-start
--# scope-start
      Cast_Result_3 := Create_Internal_Entity_Name
        (Node => Match_Prefix.Node,
         Info => Match_Prefix.Info);
Match_1 := Cast_Result_3; 
--# bind n Match_1
--# expr-start 386 '<Cast to AdaNode.entity>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:732
--# expr-start 385 '<FieldAccess .name_designated_type>' Fld /tmp/lal-21.0.0/ada/language/ast.py:732
      if Match_1.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start Name.name_designated_type
Fld := Libadalang.Implementation.Name_P_Name_Designated_Type (Node => Match_1.Node, E_Info => Match_1.Info);
--# end
--# expr-done 385
      Cast_Result := Create_Internal_Entity
        (Node => Fld.Node,
         Info => Fld.Info);
--# expr-done 386
Var_Expr := Cast_Result;
if Var_Expr /= No_Entity then
   --# scope-start
   --# bind e Var_Expr
Scope_Result := Var_Expr;
   --# end
   Result_Var := Scope_Result;
else
   --# expr-start 390 '<bind(<DynamicVariable env>, <FieldAccess .children_env>, <at(<FieldAccess .env_elements>, 0)>)>' Dyn_Var_Bind_Result /tmp/lal-21.0.0/ada/language/ast.py:734
--# expr-start 387 '<FieldAccess .children_env>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:734
      if Match_1.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := Libadalang.Implementation.Children_Env (Node => Match_1.Node, E_Info => Match_1.Info);
--# expr-done 387
Bound_Env := Fld_1; Inc_Ref (Bound_Env);
--# expr-start 389 '<at(<FieldAccess .env_elements>, 0)>' Get_Result /tmp/lal-21.0.0/ada/language/ast.py:734
--# expr-start 388 '<FieldAccess .env_elements>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:734
      if Match_1.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start Expr.env_elements
Fld_2 := Libadalang.Implementation.Expr_P_Env_Elements (Node => Match_1.Node, Env => Bound_Env, E_Info => Match_1.Info);
--# end
--# expr-done 388
Get_Result := Get (Fld_2, 0, True); 
--# expr-done 389
Dyn_Var_Bind_Result := Get_Result; 
--# expr-done 390
   Result_Var := Dyn_Var_Bind_Result;
end if;
Let_Result_1 := Result_Var; 
--# end
Scope_Result_2 := Let_Result_1;
   --# end
      Finalizer_Scope_1371;
            Match_Result := Scope_Result_2; 
         when Ada_Abort_Absent .. Ada_Object_Decl | Ada_Extended_Return_Stmt_Object_Decl .. Ada_Membership_Expr | Ada_Paren_Expr .. Ada_With_Private_Present =>
   --# scope-start
--# scope-start
      Cast_Result_4 := Create_Internal_Entity
        (Node => Match_Prefix.Node,
         Info => Match_Prefix.Info);
Match_2 := Cast_Result_4; 
--# bind _ Match_2
Let_Result_2 := No_Entity; 
--# end
Scope_Result_3 := Let_Result_2;
   --# end
            Match_Result := Scope_Result_3; 
end case;
--# expr-done 391
Let_Result_3 := Match_Result; 
--# end
--# expr-done 392
      Property_Result := Let_Result_3;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_1371;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Resolve_Generic_Actual;
--# end
--# property-start AdaNode.top_level_use_package_clauses /tmp/lal-21.0.0/ada/language/ast.py:741
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Top_Level_Use_Package_Clauses
  (Node : Bare_Ada_Node
  )
   return Bare_Ada_Node_Array_Access
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Bare_Ada_Node_Array_Access;
            procedure Finalizer_Scope_54;
            procedure Finalizer_Scope_1376;
      Fld : Bare_Ada_Node;
Fld_1 : Bare_Ada_Node;
Cast_Result : Bare_Compilation_Unit;
Fld_2 : Bare_Ada_Node_List;
Item_11 : Bare_Ada_Node;
Is_A : Boolean;
Map_Result : Bare_Ada_Node_Array_Access;
Cast_Expr : Bare_Ada_Node;
Cast_Result_1 : Bare_Use_Package_Clause;
Fld_3 : Bare_Name_List;
Cast_Expr_1 : Bare_Name;
Cast_Result_2 : Bare_Ada_Node;
Item_12 : Bare_Name;
Map_Result_1 : Bare_Ada_Node_Array_Access;
Map_Result_2 : Bare_Ada_Node_Array_Access;
Let_Result : Bare_Ada_Node_Array_Access;
            procedure Finalizer_Scope_54 is
            begin
                     Dec_Ref (Map_Result);
                     Dec_Ref (Map_Result_2);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_54;
            procedure Finalizer_Scope_1376 is
            begin
                     Dec_Ref (Map_Result_1);
            end Finalizer_Scope_1376;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 404 '<Block>' Let_Result None
--# scope-start
--# expr-start 403 '<mapcat>' Map_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:748
--# expr-start 398 '<filter>' Map_Result /tmp/lal-21.0.0/ada/language/ast.py:748
--# expr-start 396 '<FieldAccess .prelude>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:748
--# expr-start 395 '<Cast to CompilationUnit>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:748
--# expr-start 394 '<parent(<parent(<Var Self>)>)>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:748
--# expr-start 393 '<parent(<Var Self>)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:748
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Self.Parent; 
--# expr-done 393
      if Fld = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := Fld.Parent; 
--# expr-done 394
   if Fld_1 = null
      or else Fld_1.Kind in Ada_Compilation_Unit_Range
   then
      Cast_Result := Fld_1;
   else
         raise Property_Error with "invalid object cast";
   end if;
--# expr-done 395
      if Cast_Result = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_2 := Cast_Result.Compilation_Unit_F_Prelude;
--# expr-done 396
declare
   Map_Result_Vec : Bare_Ada_Node_Vectors.Vector;
begin
      if Fld_2 = null then
         Map_Result := Create_Bare_Ada_Node_Array (0);
      else
      declare
         Collection : constant Bare_Ada_Node_List := Fld_2;
      begin
         for Untyped_Item_11 of
               Collection.Nodes (1 .. Children_Count (Collection))
         loop
                  Item_11 := Untyped_Item_11; 
   --# scope-start
               --# bind p Item_11
               --# expr-start 397 '<IsA UsePackageClause>' Is_A /tmp/lal-21.0.0/ada/language/ast.py:750
Is_A := Item_11 /= null 
and then Item_11.Kind in Ada_Use_Package_Clause_Range; 
--# expr-done 397
               if Is_A then
         declare
            Item_To_Append : constant Bare_Ada_Node :=
               Item_11;
         begin
            Bare_Ada_Node_Vectors.Append (Map_Result_Vec, Item_To_Append);
         end;
               end if;
   --# end
         end loop;
      end;
      Map_Result := Create_Bare_Ada_Node_Array
        (Items_Count => Natural (Bare_Ada_Node_Vectors.Length (Map_Result_Vec)));
      for I in Map_Result.Items'Range loop
         Map_Result.Items (I) := Bare_Ada_Node_Vectors.Get
           (Map_Result_Vec,
            I + Bare_Ada_Node_Vectors.Index_Type'First - Map_Result.Items'First);
      end loop;
      Bare_Ada_Node_Vectors.Destroy (Map_Result_Vec);
      end if;
end;
--# expr-done 398
declare
   Map_Result_2_Vec : Bare_Ada_Node_Vectors.Vector;
begin
      declare
         Collection : constant Bare_Ada_Node_Array_Access := Map_Result;
      begin
         for Item_10 of
               Collection.Items
         loop
   --# scope-start
               --# bind p Item_10
      --# expr-start 402 '<map>' Map_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:752
--# expr-start 400 '<FieldAccess .packages>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:752
--# expr-start 399 '<Cast to UsePackageClause>' Cast_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:752
Cast_Expr := Item_10; 
   if Cast_Expr = null
      or else Cast_Expr.Kind in Ada_Use_Package_Clause_Range
   then
      Cast_Result_1 := Cast_Expr;
   else
         raise Property_Error with "invalid object cast";
   end if;
--# expr-done 399
      if Cast_Result_1 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_3 := Cast_Result_1.Use_Package_Clause_F_Packages;
--# expr-done 400
declare
   Map_Result_1_Vec : Bare_Ada_Node_Vectors.Vector;
begin
      if Fld_3 = null then
         Map_Result_1 := Create_Bare_Ada_Node_Array (0);
      else
      declare
         Collection : constant Bare_Name_List := Fld_3;
      begin
         for Untyped_Item_12 of
               Collection.Nodes (1 .. Children_Count (Collection))
         loop
                  Item_12 := Untyped_Item_12; 
   --# scope-start
               --# bind n Item_12
      --# expr-start 401 '<Cast to AdaNode>' Cast_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:753
Cast_Expr_1 := Item_12; 
      Cast_Result_2 := Cast_Expr_1;
--# expr-done 401
         declare
            Item_To_Append : constant Bare_Ada_Node :=
               Cast_Result_2;
         begin
            Bare_Ada_Node_Vectors.Append (Map_Result_1_Vec, Item_To_Append);
         end;
   --# end
         end loop;
      end;
      Map_Result_1 := Create_Bare_Ada_Node_Array
        (Items_Count => Natural (Bare_Ada_Node_Vectors.Length (Map_Result_1_Vec)));
      for I in Map_Result_1.Items'Range loop
         Map_Result_1.Items (I) := Bare_Ada_Node_Vectors.Get
           (Map_Result_1_Vec,
            I + Bare_Ada_Node_Vectors.Index_Type'First - Map_Result_1.Items'First);
      end loop;
      Bare_Ada_Node_Vectors.Destroy (Map_Result_1_Vec);
      end if;
end;
--# expr-done 402
         for Item_To_Append of
               Map_Result_1.Items
         loop
            Bare_Ada_Node_Vectors.Append (Map_Result_2_Vec, Item_To_Append);
         end loop;
   --# end
      Finalizer_Scope_1376;
         end loop;
      end;
      Map_Result_2 := Create_Bare_Ada_Node_Array
        (Items_Count => Natural (Bare_Ada_Node_Vectors.Length (Map_Result_2_Vec)));
      for I in Map_Result_2.Items'Range loop
         Map_Result_2.Items (I) := Bare_Ada_Node_Vectors.Get
           (Map_Result_2_Vec,
            I + Bare_Ada_Node_Vectors.Index_Type'First - Map_Result_2.Items'First);
      end loop;
      Bare_Ada_Node_Vectors.Destroy (Map_Result_2_Vec);
end;
--# expr-done 403
Let_Result := Map_Result_2; Inc_Ref (Let_Result);
--# end
--# expr-done 404
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_54;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_54;
               Finalizer_Scope_1376;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Top_Level_Use_Package_Clauses;
--# end
--# property-start AdaNode.top_level_use_type_clauses /tmp/lal-21.0.0/ada/language/ast.py:759
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Top_Level_Use_Type_Clauses
  (Node : Bare_Ada_Node
  )
   return Bare_Ada_Node_Array_Access
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Bare_Ada_Node_Array_Access;
            procedure Finalizer_Scope_55;
            procedure Finalizer_Scope_1379;
      Fld : Bare_Ada_Node;
Fld_1 : Bare_Ada_Node;
Cast_Result : Bare_Compilation_Unit;
Fld_2 : Bare_Ada_Node_List;
Item_14 : Bare_Ada_Node;
Is_A : Boolean;
Map_Result : Bare_Ada_Node_Array_Access;
Cast_Expr : Bare_Ada_Node;
Cast_Result_1 : Bare_Use_Type_Clause;
Fld_3 : Bare_Name_List;
Cast_Expr_1 : Bare_Name;
Cast_Result_2 : Bare_Ada_Node;
Item_15 : Bare_Name;
Map_Result_1 : Bare_Ada_Node_Array_Access;
Map_Result_2 : Bare_Ada_Node_Array_Access;
Let_Result : Bare_Ada_Node_Array_Access;
            procedure Finalizer_Scope_55 is
            begin
                     Dec_Ref (Map_Result);
                     Dec_Ref (Map_Result_2);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_55;
            procedure Finalizer_Scope_1379 is
            begin
                     Dec_Ref (Map_Result_1);
            end Finalizer_Scope_1379;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 416 '<Block>' Let_Result None
--# scope-start
--# expr-start 415 '<mapcat>' Map_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:766
--# expr-start 410 '<filter>' Map_Result /tmp/lal-21.0.0/ada/language/ast.py:766
--# expr-start 408 '<FieldAccess .prelude>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:766
--# expr-start 407 '<Cast to CompilationUnit>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:766
--# expr-start 406 '<parent(<parent(<Var Self>)>)>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:766
--# expr-start 405 '<parent(<Var Self>)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:766
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Self.Parent; 
--# expr-done 405
      if Fld = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := Fld.Parent; 
--# expr-done 406
   if Fld_1 = null
      or else Fld_1.Kind in Ada_Compilation_Unit_Range
   then
      Cast_Result := Fld_1;
   else
         raise Property_Error with "invalid object cast";
   end if;
--# expr-done 407
      if Cast_Result = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_2 := Cast_Result.Compilation_Unit_F_Prelude;
--# expr-done 408
declare
   Map_Result_Vec : Bare_Ada_Node_Vectors.Vector;
begin
      if Fld_2 = null then
         Map_Result := Create_Bare_Ada_Node_Array (0);
      else
      declare
         Collection : constant Bare_Ada_Node_List := Fld_2;
      begin
         for Untyped_Item_14 of
               Collection.Nodes (1 .. Children_Count (Collection))
         loop
                  Item_14 := Untyped_Item_14; 
   --# scope-start
               --# bind p Item_14
               --# expr-start 409 '<IsA UseTypeClause>' Is_A /tmp/lal-21.0.0/ada/language/ast.py:768
Is_A := Item_14 /= null 
and then Item_14.Kind in Ada_Use_Type_Clause_Range; 
--# expr-done 409
               if Is_A then
         declare
            Item_To_Append : constant Bare_Ada_Node :=
               Item_14;
         begin
            Bare_Ada_Node_Vectors.Append (Map_Result_Vec, Item_To_Append);
         end;
               end if;
   --# end
         end loop;
      end;
      Map_Result := Create_Bare_Ada_Node_Array
        (Items_Count => Natural (Bare_Ada_Node_Vectors.Length (Map_Result_Vec)));
      for I in Map_Result.Items'Range loop
         Map_Result.Items (I) := Bare_Ada_Node_Vectors.Get
           (Map_Result_Vec,
            I + Bare_Ada_Node_Vectors.Index_Type'First - Map_Result.Items'First);
      end loop;
      Bare_Ada_Node_Vectors.Destroy (Map_Result_Vec);
      end if;
end;
--# expr-done 410
declare
   Map_Result_2_Vec : Bare_Ada_Node_Vectors.Vector;
begin
      declare
         Collection : constant Bare_Ada_Node_Array_Access := Map_Result;
      begin
         for Item_13 of
               Collection.Items
         loop
   --# scope-start
               --# bind p Item_13
      --# expr-start 414 '<map>' Map_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:770
--# expr-start 412 '<FieldAccess .types>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:770
--# expr-start 411 '<Cast to UseTypeClause>' Cast_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:770
Cast_Expr := Item_13; 
   if Cast_Expr = null
      or else Cast_Expr.Kind in Ada_Use_Type_Clause_Range
   then
      Cast_Result_1 := Cast_Expr;
   else
         raise Property_Error with "invalid object cast";
   end if;
--# expr-done 411
      if Cast_Result_1 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_3 := Cast_Result_1.Use_Type_Clause_F_Types;
--# expr-done 412
declare
   Map_Result_1_Vec : Bare_Ada_Node_Vectors.Vector;
begin
      if Fld_3 = null then
         Map_Result_1 := Create_Bare_Ada_Node_Array (0);
      else
      declare
         Collection : constant Bare_Name_List := Fld_3;
      begin
         for Untyped_Item_15 of
               Collection.Nodes (1 .. Children_Count (Collection))
         loop
                  Item_15 := Untyped_Item_15; 
   --# scope-start
               --# bind n Item_15
      --# expr-start 413 '<Cast to AdaNode>' Cast_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:771
Cast_Expr_1 := Item_15; 
      Cast_Result_2 := Cast_Expr_1;
--# expr-done 413
         declare
            Item_To_Append : constant Bare_Ada_Node :=
               Cast_Result_2;
         begin
            Bare_Ada_Node_Vectors.Append (Map_Result_1_Vec, Item_To_Append);
         end;
   --# end
         end loop;
      end;
      Map_Result_1 := Create_Bare_Ada_Node_Array
        (Items_Count => Natural (Bare_Ada_Node_Vectors.Length (Map_Result_1_Vec)));
      for I in Map_Result_1.Items'Range loop
         Map_Result_1.Items (I) := Bare_Ada_Node_Vectors.Get
           (Map_Result_1_Vec,
            I + Bare_Ada_Node_Vectors.Index_Type'First - Map_Result_1.Items'First);
      end loop;
      Bare_Ada_Node_Vectors.Destroy (Map_Result_1_Vec);
      end if;
end;
--# expr-done 414
         for Item_To_Append of
               Map_Result_1.Items
         loop
            Bare_Ada_Node_Vectors.Append (Map_Result_2_Vec, Item_To_Append);
         end loop;
   --# end
      Finalizer_Scope_1379;
         end loop;
      end;
      Map_Result_2 := Create_Bare_Ada_Node_Array
        (Items_Count => Natural (Bare_Ada_Node_Vectors.Length (Map_Result_2_Vec)));
      for I in Map_Result_2.Items'Range loop
         Map_Result_2.Items (I) := Bare_Ada_Node_Vectors.Get
           (Map_Result_2_Vec,
            I + Bare_Ada_Node_Vectors.Index_Type'First - Map_Result_2.Items'First);
      end loop;
      Bare_Ada_Node_Vectors.Destroy (Map_Result_2_Vec);
end;
--# expr-done 415
Let_Result := Map_Result_2; Inc_Ref (Let_Result);
--# end
--# expr-done 416
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_55;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_55;
               Finalizer_Scope_1379;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Top_Level_Use_Type_Clauses;
--# end
--# property-start AdaNode.top_level_with_package_clauses /tmp/lal-21.0.0/ada/language/ast.py:777
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Top_Level_With_Package_Clauses
  (Node : Bare_Ada_Node
  )
   return Bare_Name_Array_Access
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Bare_Name_Array_Access;
            procedure Finalizer_Scope_56;
            procedure Finalizer_Scope_1381;
      Var_Expr : Bare_With_Clause;
Fld : Bare_Compilation_Unit;
Fld_1 : Bare_Ada_Node_List;
Cast_Expr : Bare_Ada_Node;
Cast_Result : Bare_With_Clause;
Fld_2 : Bare_Name_List;
Scope_Result : Bare_Name_List;
Result_Var : Bare_Name_List;
Item_253 : Bare_Name;
Map_Result : Bare_Name_Array_Access;
Item_16 : Bare_Ada_Node;
Map_Result_1 : Bare_Name_Array_Access;
Let_Result : Bare_Name_Array_Access;
            procedure Finalizer_Scope_56 is
            begin
                     Dec_Ref (Map_Result_1);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_56;
            procedure Finalizer_Scope_1381 is
            begin
                     Dec_Ref (Map_Result);
            end Finalizer_Scope_1381;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 423 '<Block>' Let_Result None
--# scope-start
--# expr-start 422 '<mapcat>' Map_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:783
--# expr-start 418 '<FieldAccess .prelude>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:783
--# expr-start 417 '<FieldAccess .enclosing_compilation_unit>' Fld /tmp/lal-21.0.0/ada/language/ast.py:783
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.enclosing_compilation_unit
Fld := Libadalang.Implementation.Ada_Node_P_Enclosing_Compilation_Unit (Node => Self);
--# end
--# expr-done 417
      if Fld = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := Fld.Compilation_Unit_F_Prelude;
--# expr-done 418
declare
   Map_Result_1_Vec : Bare_Name_Vectors.Vector;
begin
      if Fld_1 = null then
         Map_Result_1 := Create_Bare_Name_Array (0);
      else
      declare
         Collection : constant Bare_Ada_Node_List := Fld_1;
      begin
         for Untyped_Item_16 of
               Collection.Nodes (1 .. Children_Count (Collection))
         loop
                  Item_16 := Untyped_Item_16; 
   --# scope-start
               --# bind p Item_16
      --# expr-start 421 '<take_while>' Map_Result None
--# expr-start 419 '<Cast to WithClause>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:785
Cast_Expr := Item_16; 
   if Cast_Expr = null
      or else Cast_Expr.Kind in Ada_With_Clause_Range
   then
      Cast_Result := Cast_Expr;
   else
         Cast_Result := No_Bare_Ada_Node;
   end if;
--# expr-done 419
Var_Expr := Cast_Result;
if Var_Expr /= No_Bare_Ada_Node then
   --# scope-start
--# expr-start 420 '<FieldAccess .packages>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:785
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_2 := Var_Expr.With_Clause_F_Packages;
--# expr-done 420
Scope_Result := Fld_2;
   --# end
   Result_Var := Scope_Result;
else
   Result_Var := No_Bare_Ada_Node;
end if;
declare
   Map_Result_Vec : Bare_Name_Vectors.Vector;
begin
      if Result_Var = null then
         Map_Result := Create_Bare_Name_Array (0);
      else
      declare
         Collection : constant Bare_Name_List := Result_Var;
      begin
         for Untyped_Item_253 of
               Collection.Nodes (1 .. Children_Count (Collection))
         loop
                  Item_253 := Untyped_Item_253; 
   --# scope-start
         declare
            Item_To_Append : constant Bare_Name :=
               Item_253;
         begin
            Bare_Name_Vectors.Append (Map_Result_Vec, Item_To_Append);
         end;
   --# end
         end loop;
      end;
      Map_Result := Create_Bare_Name_Array
        (Items_Count => Natural (Bare_Name_Vectors.Length (Map_Result_Vec)));
      for I in Map_Result.Items'Range loop
         Map_Result.Items (I) := Bare_Name_Vectors.Get
           (Map_Result_Vec,
            I + Bare_Name_Vectors.Index_Type'First - Map_Result.Items'First);
      end loop;
      Bare_Name_Vectors.Destroy (Map_Result_Vec);
      end if;
end;
--# expr-done 421
         for Item_To_Append of
               Map_Result.Items
         loop
            Bare_Name_Vectors.Append (Map_Result_1_Vec, Item_To_Append);
         end loop;
   --# end
      Finalizer_Scope_1381;
         end loop;
      end;
      Map_Result_1 := Create_Bare_Name_Array
        (Items_Count => Natural (Bare_Name_Vectors.Length (Map_Result_1_Vec)));
      for I in Map_Result_1.Items'Range loop
         Map_Result_1.Items (I) := Bare_Name_Vectors.Get
           (Map_Result_1_Vec,
            I + Bare_Name_Vectors.Index_Type'First - Map_Result_1.Items'First);
      end loop;
      Bare_Name_Vectors.Destroy (Map_Result_1_Vec);
      end if;
end;
--# expr-done 422
Let_Result := Map_Result_1; Inc_Ref (Let_Result);
--# end
--# expr-done 423
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_56;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_56;
               Finalizer_Scope_1381;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Top_Level_With_Package_Clauses;
--# end
--# property-start AdaNode.use_packages_in_spec_of_subp_body /tmp/lal-21.0.0/ada/language/ast.py:789
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Use_Packages_In_Spec_Of_Subp_Body
  (Node : Bare_Ada_Node
  )
   return Lexical_Env
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Lexical_Env;
            procedure Finalizer_Scope_57;
            procedure Finalizer_Scope_1384;
            procedure Finalizer_Scope_1385;
      Subpb : Bare_Base_Subp_Body;
Var_Expr : Internal_Entity_Basic_Decl;
Cast_Expr : Bare_Ada_Node;
Cast_Result : Bare_Base_Subp_Body;
Bound_Imprecise_Fallback : Boolean;
As_Entity : Internal_Entity_Base_Subp_Body;
Is_Null : Boolean;
If_Result : Internal_Entity_Base_Subp_Body;
Fld : Internal_Entity_Basic_Decl;
Dyn_Var_Bind_Result : Internal_Entity_Basic_Decl;
Fld_1 : Bare_Ada_Node_Array_Access;
Fld_2 : Bare_Ada_Node;
Bound_Origin : Bare_Ada_Node;
Fld_3 : Lexical_Env := Empty_Env;
Bound_Env : Lexical_Env := Empty_Env;
Cast_Expr_1 : Bare_Ada_Node;
Cast_Result_1 : Bare_Name;
As_Entity_1 : Internal_Entity_Name;
Is_Null_1 : Boolean;
If_Result_1 : Internal_Entity_Name;
Fld_4 : Lexical_Env := Empty_Env;
Dyn_Var_Bind_Result_1 : Lexical_Env := Empty_Env;
Dyn_Var_Bind_Result_2 : Lexical_Env := Empty_Env;
Map_Result : Lexical_Env_Array_Access;
Group_Env : Lexical_Env := Empty_Env;
Scope_Result : Lexical_Env := Empty_Env;
Result_Var : Lexical_Env := Empty_Env;
Fld_5 : Bare_Ada_Node;
Is_A : Boolean;
If_Result_2 : Lexical_Env := Empty_Env;
Let_Result : Lexical_Env := Empty_Env;
Let_Result_1 : Lexical_Env := Empty_Env;
            procedure Finalizer_Scope_57 is
            begin
                     Dec_Ref (Scope_Result);
                     Dec_Ref (Result_Var);
                     Dec_Ref (If_Result_2);
                     Dec_Ref (Let_Result);
                     Dec_Ref (Let_Result_1);
            end Finalizer_Scope_57;
            procedure Finalizer_Scope_1384 is
            begin
                     Dec_Ref (Fld_1);
                     Dec_Ref (Map_Result);
                     Dec_Ref (Group_Env);
            end Finalizer_Scope_1384;
            procedure Finalizer_Scope_1385 is
            begin
                     Dec_Ref (Fld_3);
                     Dec_Ref (Bound_Env);
                     Dec_Ref (Fld_4);
                     Dec_Ref (Dyn_Var_Bind_Result_1);
                     Dec_Ref (Dyn_Var_Bind_Result_2);
            end Finalizer_Scope_1385;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 442 '<Block>' Let_Result_1 None
--# scope-start
--# expr-start 441 '<Let subpb>' Let_Result /tmp/lal-21.0.0/ada/language/ast.py:794
--# scope-start
--# expr-start 424 '<Cast to BaseSubpBody>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:794
Cast_Expr := Self; 
   if Cast_Expr = null
      or else Cast_Expr.Kind in Ada_Base_Subp_Body
   then
      Cast_Result := Cast_Expr;
   else
         Cast_Result := No_Bare_Ada_Node;
   end if;
--# expr-done 424
Subpb := Cast_Result; 
--# bind subpb Subpb
--# expr-start 440 '<If>' If_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:794
--# expr-start 426 '<IsA LibraryItem>' Is_A /tmp/lal-21.0.0/ada/language/ast.py:795
--# expr-start 425 '<parent(<Var subpb>)>' Fld_5 /tmp/lal-21.0.0/ada/language/ast.py:795
      if Subpb = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_5 := Subpb.Parent; 
--# expr-done 425
Is_A := Fld_5 /= null 
and then Fld_5.Kind in Ada_Library_Item_Range; 
--# expr-done 426
if Is_A then
--# expr-start 429 '<bind(<DynamicVariable imprecise_fallback>, False, <FieldAccess .decl_part>)>' Dyn_Var_Bind_Result /tmp/lal-21.0.0/ada/language/ast.py:797
Bound_Imprecise_Fallback := False; 
--# expr-start 428 '<FieldAccess .decl_part>' Fld /tmp/lal-21.0.0/ada/language/ast.py:797
--# expr-start 427 '<as_bare_entity(<Var subpb>)>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:797
Is_Null := Subpb = null; 
if Is_Null then
   If_Result := No_Entity_Base_Subp_Body;
else
As_Entity := (Info => No_Entity_Info, Node => Subpb); 
   If_Result := As_Entity;
end if;
--# expr-done 427
      if If_Result.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start Body.decl_part
Fld := Libadalang.Implementation.Body_Node_P_Decl_Part (Node => If_Result.Node, Imprecise_Fallback => Bound_Imprecise_Fallback, E_Info => If_Result.Info);
--# end
--# expr-done 428
Dyn_Var_Bind_Result := Fld; 
--# expr-done 429
Var_Expr := Dyn_Var_Bind_Result;
if Var_Expr /= No_Entity_Basic_Decl then
   --# scope-start
   --# bind subp_decl Var_Expr
--# expr-start 439 '<env_group(<map>)>' Group_Env /tmp/lal-21.0.0/ada/language/ast.py:799
--# expr-start 438 '<map>' Map_Result /tmp/lal-21.0.0/ada/language/ast.py:799
--# expr-start 430 '<FieldAccess .top_level_use_package_clauses>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:799
      if Var_Expr.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.top_level_use_package_clauses
Fld_1 := Libadalang.Implementation.Ada_Node_P_Top_Level_Use_Package_Clauses (Node => Var_Expr.Node);
--# end
--# expr-done 430
declare
   Map_Result_Vec : Lexical_Env_Vectors.Vector;
begin
      declare
         Collection : constant Bare_Ada_Node_Array_Access := Fld_1;
      begin
         for Item_17 of
               Collection.Items
         loop
   --# scope-start
               --# bind use_name Item_17
      --# expr-start 437 '<bind(<DynamicVariable origin>, <FieldAccess .origin_node>, <bind(<DynamicVariable env>, <FieldAccess .node_env>, <FieldAccess .designated_env>)>)>' Dyn_Var_Bind_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:801
--# expr-start 431 '<FieldAccess .origin_node>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:801
      if Item_17 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.origin_node
Fld_2 := Libadalang.Implementation.Ada_Node_P_Origin_Node (Node => Item_17);
--# end
--# expr-done 431
Bound_Origin := Fld_2; 
--# expr-start 436 '<bind(<DynamicVariable env>, <FieldAccess .node_env>, <FieldAccess .designated_env>)>' Dyn_Var_Bind_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:801
--# expr-start 432 '<FieldAccess .node_env>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:802
      if Item_17 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_3 := Libadalang.Implementation.Node_Env (Node => Item_17);
--# expr-done 432
Bound_Env := Fld_3; Inc_Ref (Bound_Env);
--# expr-start 435 '<FieldAccess .designated_env>' Fld_4 /tmp/lal-21.0.0/ada/language/ast.py:803
--# expr-start 434 '<as_bare_entity(<Cast to Name>)>' If_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:803
--# expr-start 433 '<Cast to Name>' Cast_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:803
Cast_Expr_1 := Item_17; 
   if Cast_Expr_1 = null
      or else Cast_Expr_1.Kind in Ada_Name
   then
      Cast_Result_1 := Cast_Expr_1;
   else
         raise Property_Error with "invalid object cast";
   end if;
--# expr-done 433
Is_Null_1 := Cast_Result_1 = null; 
if Is_Null_1 then
   If_Result_1 := No_Entity_Name;
else
As_Entity_1 := (Info => No_Entity_Info, Node => Cast_Result_1); 
   If_Result_1 := As_Entity_1;
end if;
--# expr-done 434
      if If_Result_1.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]Expr.designated_env'
Fld_4 := Libadalang.Implementation.Dispatcher_Expr_P_Designated_Env (Node => If_Result_1.Node, Env => Bound_Env, Origin => Bound_Origin, E_Info => If_Result_1.Info);
--# end
--# expr-done 435
Dyn_Var_Bind_Result_1 := Fld_4; Inc_Ref (Dyn_Var_Bind_Result_1);
--# expr-done 436
Dyn_Var_Bind_Result_2 := Dyn_Var_Bind_Result_1; Inc_Ref (Dyn_Var_Bind_Result_2);
--# expr-done 437
         declare
            Item_To_Append : constant Lexical_Env :=
               Dyn_Var_Bind_Result_2;
         begin
               Inc_Ref (Item_To_Append);
            Lexical_Env_Vectors.Append (Map_Result_Vec, Item_To_Append);
         end;
   --# end
      Finalizer_Scope_1385;
         end loop;
      end;
      Map_Result := Create_Lexical_Env_Array
        (Items_Count => Natural (Lexical_Env_Vectors.Length (Map_Result_Vec)));
      for I in Map_Result.Items'Range loop
         Map_Result.Items (I) := Lexical_Env_Vectors.Get
           (Map_Result_Vec,
            I + Lexical_Env_Vectors.Index_Type'First - Map_Result.Items'First);
      end loop;
      Lexical_Env_Vectors.Destroy (Map_Result_Vec);
end;
--# expr-done 438
Group_Env := Group (Map_Result, No_Metadata); 
--# expr-done 439
Scope_Result := Group_Env;
   Inc_Ref (Scope_Result);
   --# end
      Finalizer_Scope_1384;
   Result_Var := Scope_Result;
else
   Result_Var := AST_Envs.Empty_Env;
end if;
      Inc_Ref (Result_Var);
   If_Result_2 := Result_Var;
else
   If_Result_2 := AST_Envs.Empty_Env;
end if;
      Inc_Ref (If_Result_2);
--# expr-done 440
Let_Result := If_Result_2; Inc_Ref (Let_Result);
--# end
--# expr-done 441
Let_Result_1 := Let_Result; Inc_Ref (Let_Result_1);
--# end
--# expr-done 442
      Property_Result := Let_Result_1;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_57;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_57;
               Finalizer_Scope_1384;
               Finalizer_Scope_1385;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Use_Packages_In_Spec_Of_Subp_Body;
--# end
--# property-start AdaNode.nested_generic_formal_part /tmp/lal-21.0.0/ada/language/ast.py:814
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Nested_Generic_Formal_Part
  (Node : Bare_Ada_Node
  )
   return Lexical_Env
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Lexical_Env;
            procedure Finalizer_Scope_58;
            procedure Finalizer_Scope_1388;
            procedure Finalizer_Scope_1390;
            procedure Finalizer_Scope_1393;
      Block_Var : Bare_Ada_Node;
Match_0 : Internal_Entity_Package_Body;
Match_1 : Internal_Entity_Base_Subp_Body;
Match_2 : Internal_Entity;
Var_Expr : Internal_Entity_Basic_Decl;
Var_Expr_1 : Internal_Entity_Array_Access;
Var_Expr_2 : Bare_Generic_Subp_Decl;
Var_Expr_3 : Bare_Ada_Node;
Bound_Imprecise_Fallback : Boolean;
As_Entity : Internal_Entity;
Is_Null : Boolean;
If_Result : Internal_Entity;
Fld : Internal_Entity_Basic_Decl;
Fld_1 : Bare_Basic_Decl;
Fld_2 : Bare_Ada_Node;
Cast_Result : Bare_Generic_Package_Decl;
Scope_Result : Bare_Generic_Package_Decl;
Result_Var : Bare_Generic_Package_Decl;
Fld_3 : Lexical_Env := Empty_Env;
Env_Parent : Lexical_Env := Empty_Env;
Fld_4 : Symbol_Type;
Env_Get_Result : Internal_Entity_Array_Access;
Get_Result : Internal_Entity;
Fld_5 : Bare_Ada_Node;
Cast_Result_1 : Bare_Generic_Subp_Decl;
Scope_Result_1 : Bare_Generic_Subp_Decl;
Get_Result_1 : Internal_Entity;
Fld_6 : Bare_Ada_Node;
Cast_Result_2 : Bare_Generic_Subp_Decl;
Result_Var_1 : Bare_Generic_Subp_Decl;
Scope_Result_2 : Bare_Generic_Subp_Decl;
Result_Var_2 : Bare_Generic_Subp_Decl;
Cast_Result_3 : Bare_Ada_Node;
Match_Prefix : Internal_Entity;
Cast_Result_4 : Internal_Entity_Package_Body;
Cast_Result_5 : Bare_Ada_Node;
Let_Result : Bare_Ada_Node;
Scope_Result_3 : Bare_Ada_Node;
Cast_Result_6 : Internal_Entity_Base_Subp_Body;
Let_Result_1 : Bare_Ada_Node;
Scope_Result_4 : Bare_Ada_Node;
Cast_Result_7 : Internal_Entity;
Let_Result_2 : Bare_Ada_Node;
Scope_Result_5 : Bare_Ada_Node;
Match_Result : Bare_Ada_Node;
Dyn_Var_Bind_Result : Bare_Ada_Node;
Fld_7 : Lexical_Env := Empty_Env;
Scope_Result_6 : Lexical_Env := Empty_Env;
Fld_8 : Lexical_Env := Empty_Env;
Result_Var_3 : Lexical_Env := Empty_Env;
Let_Result_3 : Lexical_Env := Empty_Env;
            procedure Finalizer_Scope_58 is
            begin
                     Dec_Ref (Scope_Result_6);
                     Dec_Ref (Fld_8);
                     Dec_Ref (Result_Var_3);
                     Dec_Ref (Let_Result_3);
            end Finalizer_Scope_58;
            procedure Finalizer_Scope_1388 is
            begin
                     Dec_Ref (Fld_3);
                     Dec_Ref (Env_Parent);
                     Dec_Ref (Env_Get_Result);
            end Finalizer_Scope_1388;
            procedure Finalizer_Scope_1390 is
            begin
                     Dec_Ref (Var_Expr_1);
            end Finalizer_Scope_1390;
            procedure Finalizer_Scope_1393 is
            begin
                     Dec_Ref (Fld_7);
            end Finalizer_Scope_1393;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 463 '<Block>' Let_Result_3 None
--# scope-start
--# expr-start 460 '<bind(<DynamicVariable imprecise_fallback>, False, <Match>)>' Dyn_Var_Bind_Result /tmp/lal-21.0.0/ada/language/ast.py:828
Bound_Imprecise_Fallback := False; 
--# expr-start 459 '<Match>' Match_Result /tmp/lal-21.0.0/ada/language/ast.py:830
--# expr-start 443 '<as_bare_entity(<Var Self>)>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:830
Is_Null := Self = null; 
if Is_Null then
   If_Result := No_Entity;
else
As_Entity := (Info => No_Entity_Info, Node => Self); 
   If_Result := As_Entity;
end if;
--# expr-done 443
      if If_Result.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Match_Prefix := If_Result; 
case Ada_Ada_Node (Match_Prefix.Node.Kind) is
         when Ada_Package_Body =>
   --# scope-start
--# scope-start
      Cast_Result_4 := Create_Internal_Entity_Package_Body
        (Node => Match_Prefix.Node,
         Info => Match_Prefix.Info);
Match_0 := Cast_Result_4; 
--# bind pkg_body Match_0
--# expr-start 444 '<FieldAccess .decl_part>' Fld /tmp/lal-21.0.0/ada/language/ast.py:832
      if Match_0.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start Body.decl_part
Fld := Libadalang.Implementation.Body_Node_P_Decl_Part (Node => Match_0.Node, Imprecise_Fallback => Bound_Imprecise_Fallback, E_Info => Match_0.Info);
--# end
--# expr-done 444
Var_Expr := Fld;
if Var_Expr /= No_Entity_Basic_Decl then
   --# scope-start
   --# bind d Var_Expr
--# expr-start 447 '<Cast to GenericPackageDecl>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:833
--# expr-start 446 '<parent(<FieldAccess .node>)>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:833
--# expr-start 445 '<FieldAccess .node>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:833
Fld_1 := Var_Expr.Node;
--# expr-done 445
      if Fld_1 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_2 := Fld_1.Parent; 
--# expr-done 446
   if Fld_2 = null
      or else Fld_2.Kind in Ada_Generic_Package_Decl_Range
   then
      Cast_Result := Fld_2;
   else
         Cast_Result := No_Bare_Ada_Node;
   end if;
--# expr-done 447
Scope_Result := Cast_Result;
   --# end
   Result_Var := Scope_Result;
else
   Result_Var := No_Bare_Ada_Node;
end if;
      Cast_Result_5 := Result_Var;
Let_Result := Cast_Result_5; 
--# end
Scope_Result_3 := Let_Result;
   --# end
            Match_Result := Scope_Result_3; 
         when Ada_Expr_Function .. Ada_Subp_Renaming_Decl =>
   --# scope-start
--# scope-start
      Cast_Result_6 := Create_Internal_Entity_Base_Subp_Body
        (Node => Match_Prefix.Node,
         Info => Match_Prefix.Info);
Match_1 := Cast_Result_6; 
--# bind bod Match_1
--# expr-start 458 '<Cast to AdaNode>' Cast_Result_3 /tmp/lal-21.0.0/ada/language/ast.py:841
--# expr-start 451 '<EnvGet(<env_parent(<FieldAccess .children_env>)>, <FieldAccess .name_symbol>)>' Env_Get_Result /tmp/lal-21.0.0/ada/language/ast.py:841
--# expr-start 449 '<env_parent(<FieldAccess .children_env>)>' Env_Parent /tmp/lal-21.0.0/ada/language/ast.py:841
--# expr-start 448 '<FieldAccess .children_env>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:841
      if Match_1.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_3 := Libadalang.Implementation.Children_Env (Node => Match_1.Node, E_Info => Match_1.Info);
--# expr-done 448
Env_Parent := AST_Envs.Parent (Fld_3); 
--# expr-done 449
--# expr-start 450 '<FieldAccess .name_symbol>' Fld_4 /tmp/lal-21.0.0/ada/language/ast.py:842
      if Match_1.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start BasicDecl.name_symbol
Fld_4 := Libadalang.Implementation.Basic_Decl_P_Name_Symbol (Node => Match_1.Node);
--# end
--# expr-done 450
Env_Get_Result := Construct_Entity_Array (AST_Envs.Get (Self => Env_Parent, Key => Fld_4, Lookup_Kind => To_Lookup_Kind_Type (Recursive), Categories => (Inherited_Primitives => False, Nocat => True))); 
--# expr-done 451
Var_Expr_1 := Env_Get_Result;
      Inc_Ref (Var_Expr_1);
if Var_Expr_1 /= No_Internal_Entity_Array_Type then
   --# scope-start
   --# bind results Var_Expr_1
--# expr-start 454 '<Cast to GenericSubpDecl>' Cast_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:845
--# expr-start 453 '<FieldAccess .node>' Fld_5 /tmp/lal-21.0.0/ada/language/ast.py:845
--# expr-start 452 '<at(<Var results>, 1)>' Get_Result /tmp/lal-21.0.0/ada/language/ast.py:845
Get_Result := Get (Var_Expr_1, 1, True); 
--# expr-done 452
Fld_5 := Get_Result.Node;
--# expr-done 453
   if Fld_5 = null
      or else Fld_5.Kind in Ada_Generic_Subp_Decl_Range
   then
      Cast_Result_1 := Fld_5;
   else
         Cast_Result_1 := No_Bare_Ada_Node;
   end if;
--# expr-done 454
Var_Expr_2 := Cast_Result_1;
if Var_Expr_2 /= No_Bare_Ada_Node then
   --# scope-start
   --# bind e Var_Expr_2
Scope_Result_1 := Var_Expr_2;
   --# end
   Result_Var_1 := Scope_Result_1;
else
   --# expr-start 457 '<Cast to GenericSubpDecl>' Cast_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:846
--# expr-start 456 '<FieldAccess .node>' Fld_6 /tmp/lal-21.0.0/ada/language/ast.py:846
--# expr-start 455 '<at(<Var results>, 2)>' Get_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:846
Get_Result_1 := Get (Var_Expr_1, 2, True); 
--# expr-done 455
Fld_6 := Get_Result_1.Node;
--# expr-done 456
   if Fld_6 = null
      or else Fld_6.Kind in Ada_Generic_Subp_Decl_Range
   then
      Cast_Result_2 := Fld_6;
   else
         Cast_Result_2 := No_Bare_Ada_Node;
   end if;
--# expr-done 457
   Result_Var_1 := Cast_Result_2;
end if;
Scope_Result_2 := Result_Var_1;
   --# end
      Finalizer_Scope_1390;
   Result_Var_2 := Scope_Result_2;
else
   Result_Var_2 := No_Bare_Ada_Node;
end if;
      Cast_Result_3 := Result_Var_2;
--# expr-done 458
Let_Result_1 := Cast_Result_3; 
--# end
Scope_Result_4 := Let_Result_1;
   --# end
      Finalizer_Scope_1388;
            Match_Result := Scope_Result_4; 
         when Ada_Abort_Absent .. Ada_Generic_Subp_Internal | Ada_Package_Body_Stub .. Ada_Entry_Body | Ada_Protected_Body .. Ada_With_Private_Present =>
   --# scope-start
--# scope-start
      Cast_Result_7 := Create_Internal_Entity
        (Node => Match_Prefix.Node,
         Info => Match_Prefix.Info);
Match_2 := Cast_Result_7; 
--# bind _ Match_2
Let_Result_2 := No_Bare_Ada_Node; 
--# end
Scope_Result_5 := Let_Result_2;
   --# end
            Match_Result := Scope_Result_5; 
end case;
--# expr-done 459
Dyn_Var_Bind_Result := Match_Result; 
--# expr-done 460
Block_Var := Dyn_Var_Bind_Result; 
--# bind gen_decl Block_Var
Var_Expr_3 := Block_Var;
if Var_Expr_3 /= No_Bare_Ada_Node then
   --# scope-start
   --# bind gd Var_Expr_3
--# expr-start 461 '<FieldAccess .children_env>' Fld_7 /tmp/lal-21.0.0/ada/language/ast.py:854
      if Var_Expr_3 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_7 := Libadalang.Implementation.Children_Env (Node => Var_Expr_3);
--# expr-done 461
Scope_Result_6 := Fld_7;
   Inc_Ref (Scope_Result_6);
   --# end
      Finalizer_Scope_1393;
   Result_Var_3 := Scope_Result_6;
else
   --# expr-start 462 '<FieldAccess .empty_env>' Fld_8 /tmp/lal-21.0.0/ada/language/ast.py:854
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.empty_env
Fld_8 := Libadalang.Implementation.Ada_Node_P_Empty_Env (Node => Self);
--# end
--# expr-done 462
   Result_Var_3 := Fld_8;
end if;
      Inc_Ref (Result_Var_3);
Let_Result_3 := Result_Var_3; Inc_Ref (Let_Result_3);
--# end
--# expr-done 463
      Property_Result := Let_Result_3;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_58;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_58;
               Finalizer_Scope_1388;
               Finalizer_Scope_1390;
               Finalizer_Scope_1393;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Nested_Generic_Formal_Part;
--# end
--# property-start AdaNode.is_package /tmp/lal-21.0.0/ada/language/ast.py:858
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Is_Package
  (Node : Bare_Ada_Node
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Boolean;
      Is_A : Boolean;
Let_Result : Boolean;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 465 '<Block>' Let_Result None
--# scope-start
--# expr-start 464 '<IsA PackageDecl, PackageBody, GenericPackageInstantiation, PackageRenamingDecl, GenericPackageDecl>' Is_A /tmp/lal-21.0.0/ada/language/ast.py:862
Is_A := Self /= null 
and then Self.Kind in Ada_Package_Decl_Range | Ada_Package_Body_Range | Ada_Generic_Package_Instantiation_Range | Ada_Package_Renaming_Decl_Range | Ada_Generic_Package_Decl_Range; 
--# expr-done 464
Let_Result := Is_A; 
--# end
--# expr-done 465
      Property_Result := Let_Result;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Is_Package;
--# end
--# property-start AdaNode.default_initial_env /tmp/lal-21.0.0/ada/language/ast.py:866
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Default_Initial_Env
  (Node : Bare_Ada_Node
  )
   return Lexical_Env
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   Property_Result : Lexical_Env;
            procedure Finalizer_Scope_60;
            procedure Finalizer_Scope_1394;
      Var_Expr : Bare_Ada_Node;
Fld : Bare_Ada_Node;
Fld_1 : Lexical_Env := Empty_Env;
Scope_Result : Lexical_Env := Empty_Env;
Fld_2 : Lexical_Env := Empty_Env;
Result_Var : Lexical_Env := Empty_Env;
Let_Result : Lexical_Env := Empty_Env;
            procedure Finalizer_Scope_60 is
            begin
                     Dec_Ref (Scope_Result);
                     Dec_Ref (Fld_2);
                     Dec_Ref (Result_Var);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_60;
            procedure Finalizer_Scope_1394 is
            begin
                     Dec_Ref (Fld_1);
            end Finalizer_Scope_1394;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 469 '<Block>' Let_Result None
--# scope-start
--# expr-start 466 '<parent(<Var Self>)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:871
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Self.Parent; 
--# expr-done 466
Var_Expr := Fld;
if Var_Expr /= No_Bare_Ada_Node then
   --# scope-start
   --# bind p Var_Expr
--# expr-start 467 '<FieldAccess .children_env>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:871
      if Var_Expr = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := Libadalang.Implementation.Children_Env (Node => Var_Expr);
--# expr-done 467
Scope_Result := Fld_1;
   Inc_Ref (Scope_Result);
   --# end
      Finalizer_Scope_1394;
   Result_Var := Scope_Result;
else
   --# expr-start 468 '<FieldAccess .children_env>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:872
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_2 := Libadalang.Implementation.Children_Env (Node => Self);
--# expr-done 468
   Result_Var := Fld_2;
end if;
      Inc_Ref (Result_Var);
Let_Result := Result_Var; Inc_Ref (Let_Result);
--# end
--# expr-done 469
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_60;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_60;
               Finalizer_Scope_1394;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Default_Initial_Env;
--# end
--# property-start AdaNode.initial_env /tmp/lal-21.0.0/ada/language/ast.py:875
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Initial_Env
  (Node : Bare_Ada_Node
      ; Scope : Lexical_Env
      ; Env : Lexical_Env
  )
   return Lexical_Env
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind scope Scope
   --# bind env Env
   Property_Result : Lexical_Env;
            procedure Finalizer_Scope_61;
            procedure Finalizer_Scope_1395;
      Var_Expr : Lexical_Env := Empty_Env;
Scope_Result : Lexical_Env := Empty_Env;
Result_Var : Lexical_Env := Empty_Env;
Let_Result : Lexical_Env := Empty_Env;
            procedure Finalizer_Scope_61 is
            begin
                     Dec_Ref (Scope_Result);
                     Dec_Ref (Result_Var);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_61;
            procedure Finalizer_Scope_1395 is
            begin
                     Dec_Ref (Var_Expr);
            end Finalizer_Scope_1395;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 470 '<Block>' Let_Result None
--# scope-start
Var_Expr := Scope;
      Inc_Ref (Var_Expr);
if Var_Expr /= Empty_Env then
   --# scope-start
   --# bind s Var_Expr
Scope_Result := Var_Expr;
   Inc_Ref (Scope_Result);
   --# end
      Finalizer_Scope_1395;
   Result_Var := Scope_Result;
else
   Result_Var := Env;
end if;
      Inc_Ref (Result_Var);
Let_Result := Result_Var; Inc_Ref (Let_Result);
--# end
--# expr-done 470
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_61;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_61;
               Finalizer_Scope_1395;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Initial_Env;
--# end
--# property-start AdaNode.env_assoc /tmp/lal-21.0.0/ada/language/ast.py:883
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Env_Assoc
  (Node : Bare_Ada_Node
      ; Key : Symbol_Type
      ; Dest_Env : Lexical_Env
  )
   return Internal_Env_Assoc
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind key Key
   --# bind dest_env Dest_Env
   Property_Result : Internal_Env_Assoc;
            procedure Finalizer_Scope_62;
            procedure Finalizer_Scope_1396;
      Var_Expr : Lexical_Env := Empty_Env;
New_Struct : Internal_Env_Assoc := No_Env_Assoc;
Scope_Result : Internal_Env_Assoc := No_Env_Assoc;
Result_Var : Internal_Env_Assoc := No_Env_Assoc;
Let_Result : Internal_Env_Assoc := No_Env_Assoc;
            procedure Finalizer_Scope_62 is
            begin
                     Dec_Ref (Scope_Result);
                     Dec_Ref (Result_Var);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_62;
            procedure Finalizer_Scope_1396 is
            begin
                     Dec_Ref (Var_Expr);
                     Dec_Ref (New_Struct);
            end Finalizer_Scope_1396;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 472 '<Block>' Let_Result None
--# scope-start
Var_Expr := Dest_Env;
      Inc_Ref (Var_Expr);
if Var_Expr /= Empty_Env then
   --# scope-start
   --# bind env Var_Expr
--# expr-start 471 '<New InternalEnvAssoc>' New_Struct /tmp/lal-21.0.0/ada/language/ast.py:890
Inc_Ref (Var_Expr);
New_Struct := (Dest_Env => Var_Expr, Key => Key, Metadata => No_Metadata, Val => Self); 
--# expr-done 471
Scope_Result := New_Struct;
   Inc_Ref (Scope_Result);
   --# end
      Finalizer_Scope_1396;
   Result_Var := Scope_Result;
else
   Result_Var := No_Env_Assoc;
end if;
      Inc_Ref (Result_Var);
Let_Result := Result_Var; Inc_Ref (Let_Result);
--# end
--# expr-done 472
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_62;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_62;
               Finalizer_Scope_1396;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Env_Assoc;
--# end
--# property-start AdaNode.top_level_decl /tmp/lal-21.0.0/ada/language/ast.py:893
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Top_Level_Decl
  (Node : Bare_Ada_Node
      ; Unit : Internal_Unit
  )
   return Bare_Basic_Decl
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind unit Unit
   Property_Result : Bare_Basic_Decl;
      Var_Expr : Bare_Ada_Node;
Var_Expr_1 : Internal_Unit;
Fld : Bare_Ada_Node;
Scope_Result : Bare_Ada_Node;
Result_Var : Bare_Ada_Node;
Cast_Expr : Bare_Ada_Node;
Cast_Result : Bare_Compilation_Unit;
Fld_1 : Bare_Basic_Decl;
Scope_Result_1 : Bare_Basic_Decl;
Result_Var_1 : Bare_Basic_Decl;
Let_Result : Bare_Basic_Decl;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 476 '<Block>' Let_Result None
--# scope-start
Var_Expr_1 := Unit;
if Var_Expr_1 /= null then
   --# scope-start
--# expr-start 473 '<FieldAccess .root>' Fld /tmp/lal-21.0.0/ada/language/ast.py:898
      if Var_Expr_1 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Var_Expr_1.AST_Root;
--# expr-done 473
Scope_Result := Fld;
   --# end
   Result_Var := Scope_Result;
else
   Result_Var := No_Bare_Ada_Node;
end if;
Var_Expr := Result_Var;
if Var_Expr /= No_Bare_Ada_Node then
   --# scope-start
--# expr-start 475 '<FieldAccess .decl>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:898
--# expr-start 474 '<Cast to CompilationUnit>' Cast_Result /tmp/lal-21.0.0/ada/language/ast.py:898
Cast_Expr := Var_Expr; 
   if Cast_Expr = null
      or else Cast_Expr.Kind in Ada_Compilation_Unit_Range
   then
      Cast_Result := Cast_Expr;
   else
         raise Property_Error with "invalid object cast";
   end if;
--# expr-done 474
      if Cast_Result = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start CompilationUnit.decl
Fld_1 := Libadalang.Implementation.Compilation_Unit_P_Decl (Node => Cast_Result);
--# end
--# expr-done 475
Scope_Result_1 := Fld_1;
   --# end
   Result_Var_1 := Scope_Result_1;
else
   Result_Var_1 := No_Bare_Ada_Node;
end if;
Let_Result := Result_Var_1; 
--# end
--# expr-done 476
      Property_Result := Let_Result;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Top_Level_Decl;
--# end
--# property-start AdaNode.unpack_formals /tmp/lal-21.0.0/ada/language/ast.py:901
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Unpack_Formals
  (Node : Bare_Ada_Node
      ; Formal_Params : Internal_Entity_Base_Formal_Param_Decl_Array_Access
  )
   return Internal_Single_Formal_Array_Access
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind formal_params Formal_Params
   Property_Result : Internal_Single_Formal_Array_Access;
            procedure Finalizer_Scope_64;
      Fld : Internal_Unit;
Fld_1 : Bare_Ada_Node;
Fld_2 : Internal_Single_Formal_Array_Access;
Let_Result : Internal_Single_Formal_Array_Access;
            procedure Finalizer_Scope_64 is
            begin
                     Dec_Ref (Fld_2);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_64;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 480 '<Block>' Let_Result None
--# scope-start
--# expr-start 479 '<FieldAccess .unpack_formals_impl(...)>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:905
--# expr-start 478 '<FieldAccess .root>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:905
--# expr-start 477 '<FieldAccess .unit>' Fld /tmp/lal-21.0.0/ada/language/ast.py:905
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Libadalang.Implementation.Unit (Node => Self);
--# expr-done 477
      if Fld = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_1 := Fld.AST_Root;
--# expr-done 478
      if Fld_1 = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.unpack_formals_impl
Fld_2 := Libadalang.Implementation.Ada_Node_P_Unpack_Formals_Impl (Node => Fld_1, Formal_Params => Formal_Params);
--# end
--# expr-done 479
Let_Result := Fld_2; Inc_Ref (Let_Result);
--# end
--# expr-done 480
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_64;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_64;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Unpack_Formals;
--# end
--# property-start AdaNode.unpack_formals_impl /tmp/lal-21.0.0/ada/language/ast.py:908
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Unpack_Formals_Impl
  (Node : Bare_Ada_Node
      ; Formal_Params : Internal_Entity_Base_Formal_Param_Decl_Array_Access
  )
   return Internal_Single_Formal_Array_Access
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind formal_params Formal_Params
   Property_Result : Internal_Single_Formal_Array_Access;
            procedure Finalizer_Scope_65;
            procedure Finalizer_Scope_1397;
      Fld : Internal_Entity_Defining_Name_Array_Access;
New_Struct : Internal_Single_Formal;
Map_Result : Internal_Single_Formal_Array_Access;
Map_Result_1 : Internal_Single_Formal_Array_Access;
Let_Result : Internal_Single_Formal_Array_Access;
            procedure Finalizer_Scope_65 is
            begin
                     Dec_Ref (Map_Result_1);
                     Dec_Ref (Let_Result);
            end Finalizer_Scope_65;
            procedure Finalizer_Scope_1397 is
            begin
                     Dec_Ref (Fld);
                     Dec_Ref (Map_Result);
            end Finalizer_Scope_1397;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 485 '<Block>' Let_Result None
--# scope-start
--# expr-start 484 '<mapcat>' Map_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:909
declare
   Map_Result_1_Vec : Internal_Single_Formal_Vectors.Vector;
begin
      declare
         Collection : constant Internal_Entity_Base_Formal_Param_Decl_Array_Access := Formal_Params;
      begin
         for Item_18 of
               Collection.Items
         loop
   --# scope-start
               --# bind spec Item_18
      --# expr-start 483 '<map>' Map_Result /tmp/lal-21.0.0/ada/language/ast.py:910
--# expr-start 481 '<FieldAccess .defining_names>' Fld /tmp/lal-21.0.0/ada/language/ast.py:910
      if Item_18.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]BasicDecl.defining_names'
Fld := Libadalang.Implementation.Dispatcher_Basic_Decl_P_Defining_Names (Node => Item_18.Node, E_Info => Item_18.Info);
--# end
--# expr-done 481
declare
   Map_Result_Vec : Internal_Single_Formal_Vectors.Vector;
begin
      declare
         Collection : constant Internal_Entity_Defining_Name_Array_Access := Fld;
      begin
         for Item_19 of
               Collection.Items
         loop
   --# scope-start
               --# bind id Item_19
      --# expr-start 482 '<New InternalSingleFormal>' New_Struct /tmp/lal-21.0.0/ada/language/ast.py:910
New_Struct := (Name => Item_19, Spec => Item_18); 
--# expr-done 482
         declare
            Item_To_Append : constant Internal_Single_Formal :=
               New_Struct;
         begin
            Internal_Single_Formal_Vectors.Append (Map_Result_Vec, Item_To_Append);
         end;
   --# end
         end loop;
      end;
      Map_Result := Create_Internal_Single_Formal_Array
        (Items_Count => Natural (Internal_Single_Formal_Vectors.Length (Map_Result_Vec)));
      for I in Map_Result.Items'Range loop
         Map_Result.Items (I) := Internal_Single_Formal_Vectors.Get
           (Map_Result_Vec,
            I + Internal_Single_Formal_Vectors.Index_Type'First - Map_Result.Items'First);
      end loop;
      Internal_Single_Formal_Vectors.Destroy (Map_Result_Vec);
end;
--# expr-done 483
         for Item_To_Append of
               Map_Result.Items
         loop
            Internal_Single_Formal_Vectors.Append (Map_Result_1_Vec, Item_To_Append);
         end loop;
   --# end
      Finalizer_Scope_1397;
         end loop;
      end;
      Map_Result_1 := Create_Internal_Single_Formal_Array
        (Items_Count => Natural (Internal_Single_Formal_Vectors.Length (Map_Result_1_Vec)));
      for I in Map_Result_1.Items'Range loop
         Map_Result_1.Items (I) := Internal_Single_Formal_Vectors.Get
           (Map_Result_1_Vec,
            I + Internal_Single_Formal_Vectors.Index_Type'First - Map_Result_1.Items'First);
      end loop;
      Internal_Single_Formal_Vectors.Destroy (Map_Result_1_Vec);
end;
--# expr-done 484
Let_Result := Map_Result_1; Inc_Ref (Let_Result);
--# end
--# expr-done 485
      Property_Result := Let_Result;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_65;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_65;
               Finalizer_Scope_1397;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Unpack_Formals_Impl;
--# end
--# property-start AdaNode.match_formals /tmp/lal-21.0.0/ada/language/ast.py:916
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Match_Formals
  (Node : Bare_Ada_Node
      ; Formal_Params : Internal_Entity_Base_Formal_Param_Decl_Array_Access
      ; Params : Internal_Entity_Assoc_List
      ; Is_Dottable_Subp : Boolean
  )
   return Internal_Param_Match_Array_Access
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   --# bind self Self
   --# bind formal_params Formal_Params
   --# bind params Params
   --# bind is_dottable_subp Is_Dottable_Subp
   Property_Result : Internal_Param_Match_Array_Access;
            procedure Finalizer_Scope_66;
            procedure Finalizer_Scope_1399;
            procedure Finalizer_Scope_1404;
      Block_Var : Internal_Single_Formal_Array_Access;
Var_Expr : Internal_Entity_Assoc_List;
Idx : Integer;
Var_Expr_1 : Internal_Single_Formal;
Var_Expr_2 : Bare_Base_Id;
Var_Expr_3 : Internal_Single_Formal;
Fld : Internal_Single_Formal_Array_Access;
Fld_1 : Internal_Single_Actual_Array_Access;
Arith_Result : Integer;
If_Result : Integer;
Get_Result : Internal_Single_Formal;
New_Struct : Internal_Param_Match;
Scope_Result : Internal_Param_Match;
Result_Var : Internal_Param_Match;
Let_Result : Internal_Param_Match;
Fld_2 : Bare_Base_Id;
Fld_3 : Internal_Entity_Defining_Name;
Cast_Expr : Bare_Base_Id;
Cast_Result : Bare_Name;
Fld_4 : Boolean;
Map_Result : Internal_Single_Formal_Array_Access;
Get_Result_1 : Internal_Single_Formal;
New_Struct_1 : Internal_Param_Match;
Scope_Result_1 : Internal_Param_Match;
Result_Var_1 : Internal_Param_Match;
Scope_Result_2 : Internal_Param_Match;
Result_Var_2 : Internal_Param_Match;
Fld_5 : Bare_Base_Id;
Is_Null : Boolean;
If_Result_1 : Internal_Param_Match;
I : Integer;
Map_Result_1 : Internal_Param_Match_Array_Access;
Scope_Result_3 : Internal_Param_Match_Array_Access;
Result_Var_3 : Internal_Param_Match_Array_Access;
Let_Result_1 : Internal_Param_Match_Array_Access;
            procedure Finalizer_Scope_66 is
            begin
                     Dec_Ref (Fld);
                     Dec_Ref (Block_Var);
                     Dec_Ref (Scope_Result_3);
                     Dec_Ref (Result_Var_3);
                     Dec_Ref (Let_Result_1);
            end Finalizer_Scope_66;
            procedure Finalizer_Scope_1399 is
            begin
                     Dec_Ref (Fld_1);
                     Dec_Ref (Map_Result_1);
            end Finalizer_Scope_1399;
            procedure Finalizer_Scope_1404 is
            begin
                     Dec_Ref (Map_Result);
            end Finalizer_Scope_1404;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
   --# scope-start
      --# expr-start 503 '<Block>' Let_Result_1 None
--# scope-start
--# expr-start 486 '<FieldAccess .unpack_formals(...)>' Fld /tmp/lal-21.0.0/ada/language/ast.py:924
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.unpack_formals
Fld := Libadalang.Implementation.Ada_Node_P_Unpack_Formals (Node => Self, Formal_Params => Formal_Params);
--# end
--# expr-done 486
Block_Var := Fld; Inc_Ref (Block_Var);
--# bind unpacked_formals Block_Var
Var_Expr := Params;
if Var_Expr /= No_Entity_Assoc_List then
   --# scope-start
   --# bind p Var_Expr
--# expr-start 502 '<map>' Map_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:926
--# expr-start 487 '<FieldAccess .unpacked_params>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:926
      if Var_Expr.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AssocList.unpacked_params
Fld_1 := Libadalang.Implementation.Assoc_List_P_Unpacked_Params (Node => Var_Expr.Node, E_Info => Var_Expr.Info);
--# end
--# expr-done 487
declare
   Map_Result_1_Vec : Internal_Param_Match_Vectors.Vector;
begin
         I := 0;
      declare
         Collection : constant Internal_Single_Actual_Array_Access := Fld_1;
      begin
         for Item_20 of
               Collection.Items
         loop
   --# scope-start
               --# bind a Item_20
               --# bind i I
      --# expr-start 501 '<If>' If_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:926
--# expr-start 489 '<IsNull>' Is_Null /tmp/lal-21.0.0/ada/language/ast.py:927
--# expr-start 488 '<FieldAccess .name>' Fld_5 /tmp/lal-21.0.0/ada/language/ast.py:927
Fld_5 := Item_20.Name;
--# expr-done 488
Is_Null := Fld_5 = null; 
--# expr-done 489
if Is_Null then
   --# expr-start 494 '<Let idx>' Let_Result /tmp/lal-21.0.0/ada/language/ast.py:929
--# scope-start
--# expr-start 491 '<If>' If_Result /tmp/lal-21.0.0/ada/language/ast.py:930
if Is_Dottable_Subp then
   --# expr-start 490 '<Op +>' Arith_Result /tmp/lal-21.0.0/ada/language/ast.py:930
Arith_Result := (I + 1); 
--# expr-done 490
   If_Result := Arith_Result;
else
   If_Result := I;
end if;
--# expr-done 491
Idx := If_Result; 
--# bind idx Idx
--# expr-start 492 '<at(<Var unpacked_formals>, <Var idx>)>' Get_Result /tmp/lal-21.0.0/ada/language/ast.py:933
Get_Result := Get (Block_Var, Idx, True); 
--# expr-done 492
Var_Expr_1 := Get_Result;
if Var_Expr_1 /= No_Single_Formal then
   --# scope-start
   --# bind sp Var_Expr_1
--# expr-start 493 '<New InternalParamMatch>' New_Struct /tmp/lal-21.0.0/ada/language/ast.py:934
New_Struct := (Actual => Item_20, Formal => Var_Expr_1, Has_Matched => True); 
--# expr-done 493
Scope_Result := New_Struct;
   --# end
   Result_Var := Scope_Result;
else
   Result_Var := No_Param_Match;
end if;
Let_Result := Result_Var; 
--# end
--# expr-done 494
   If_Result_1 := Let_Result;
else
--# expr-start 495 '<FieldAccess .name>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:944
Fld_2 := Item_20.Name;
--# expr-done 495
Var_Expr_2 := Fld_2;
if Var_Expr_2 /= No_Bare_Ada_Node then
   --# scope-start
   --# bind id Var_Expr_2
--# expr-start 499 '<at(<filter>, 0)>' Get_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:945
--# expr-start 498 '<filter>' Map_Result /tmp/lal-21.0.0/ada/language/ast.py:945
declare
   Map_Result_Vec : Internal_Single_Formal_Vectors.Vector;
begin
      declare
         Collection : constant Internal_Single_Formal_Array_Access := Block_Var;
      begin
         for Item_21 of
               Collection.Items
         loop
   --# scope-start
               --# bind p Item_21
               --# expr-start 497 '<FieldAccess .matches(...)>' Fld_4 /tmp/lal-21.0.0/ada/language/ast.py:945
--# expr-start 496 '<FieldAccess .name>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:945
Fld_3 := Item_21.Name;
--# expr-done 496
      if Fld_3.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Cast_Expr := Var_Expr_2; 
      Cast_Result := Cast_Expr;
--# property-call-start Name.matches
Fld_4 := Libadalang.Implementation.Name_P_Matches (Node => Fld_3.Node, N => Cast_Result);
--# end
--# expr-done 497
               if Fld_4 then
         declare
            Item_To_Append : constant Internal_Single_Formal :=
               Item_21;
         begin
            Internal_Single_Formal_Vectors.Append (Map_Result_Vec, Item_To_Append);
         end;
               end if;
   --# end
         end loop;
      end;
      Map_Result := Create_Internal_Single_Formal_Array
        (Items_Count => Natural (Internal_Single_Formal_Vectors.Length (Map_Result_Vec)));
      for I in Map_Result.Items'Range loop
         Map_Result.Items (I) := Internal_Single_Formal_Vectors.Get
           (Map_Result_Vec,
            I + Internal_Single_Formal_Vectors.Index_Type'First - Map_Result.Items'First);
      end loop;
      Internal_Single_Formal_Vectors.Destroy (Map_Result_Vec);
end;
--# expr-done 498
Get_Result_1 := Get (Map_Result, 0, True); 
--# expr-done 499
Var_Expr_3 := Get_Result_1;
if Var_Expr_3 /= No_Single_Formal then
   --# scope-start
   --# bind sp Var_Expr_3
--# expr-start 500 '<New InternalParamMatch>' New_Struct_1 /tmp/lal-21.0.0/ada/language/ast.py:946
New_Struct_1 := (Actual => Item_20, Formal => Var_Expr_3, Has_Matched => True); 
--# expr-done 500
Scope_Result_1 := New_Struct_1;
   --# end
   Result_Var_1 := Scope_Result_1;
else
   Result_Var_1 := No_Param_Match;
end if;
Scope_Result_2 := Result_Var_1;
   --# end
      Finalizer_Scope_1404;
   Result_Var_2 := Scope_Result_2;
else
   Result_Var_2 := No_Param_Match;
end if;
   If_Result_1 := Result_Var_2;
end if;
--# expr-done 501
         declare
            Item_To_Append : constant Internal_Param_Match :=
               If_Result_1;
         begin
            Internal_Param_Match_Vectors.Append (Map_Result_1_Vec, Item_To_Append);
         end;
               I := I + 1;
   --# end
         end loop;
      end;
      Map_Result_1 := Create_Internal_Param_Match_Array
        (Items_Count => Natural (Internal_Param_Match_Vectors.Length (Map_Result_1_Vec)));
      for I in Map_Result_1.Items'Range loop
         Map_Result_1.Items (I) := Internal_Param_Match_Vectors.Get
           (Map_Result_1_Vec,
            I + Internal_Param_Match_Vectors.Index_Type'First - Map_Result_1.Items'First);
      end loop;
      Internal_Param_Match_Vectors.Destroy (Map_Result_1_Vec);
end;
--# expr-done 502
Scope_Result_3 := Map_Result_1;
   Inc_Ref (Scope_Result_3);
   --# end
      Finalizer_Scope_1399;
   Result_Var_3 := Scope_Result_3;
else
   Result_Var_3 := No_Internal_Param_Match_Array_Type;
end if;
      Inc_Ref (Result_Var_3);
Let_Result_1 := Result_Var_3; Inc_Ref (Let_Result_1);
--# end
--# expr-done 503
      Property_Result := Let_Result_1;
         Inc_Ref (Property_Result);
   --# end
      Finalizer_Scope_66;
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_66;
               Finalizer_Scope_1399;
               Finalizer_Scope_1404;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Match_Formals;
--# end
--# property-start AdaNode.choice_match /tmp/lal-21.0.0/ada/language/ast.py:955
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Choice_Match
  (Node : Bare_Ada_Node
      ; Value : Big_Integer_Type
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Boolean
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   --# bind value Value
   Property_Result : Boolean;
            procedure Finalizer_Scope_1407;
            procedure Finalizer_Scope_1408;
            procedure Finalizer_Scope_1410;
            procedure Finalizer_Scope_1413;
            procedure Finalizer_Scope_1414;
      Match_0 : Internal_Entity_Bin_Op;
Match_1 : Internal_Entity_Name;
Match_2 : Internal_Entity_Subtype_Indication;
Match_3 : Internal_Entity_Expr;
Match_4 : Internal_Entity_Others_Designator;
Match_5 : Internal_Entity;
Var_Expr : Internal_Entity_Base_Type_Decl;
Var_Expr_1 : Internal_Discrete_Range;
Edr : Internal_Eval_Discrete_Range := No_Eval_Discrete_Range;
Var_Expr_2 : Internal_Discrete_Range;
Edr_1 : Internal_Eval_Discrete_Range := No_Eval_Discrete_Range;
Fld : Internal_Entity_Expr;
Fld_1 : Big_Integer_Type;
Comp_Result : Boolean;
Fld_2 : Internal_Entity_Expr;
Fld_3 : Big_Integer_Type;
Comp_Result_1 : Boolean;
If_Result : Boolean;
Fld_4 : Big_Integer_Type;
Is_Equal : Boolean;
Fld_5 : Internal_Entity_Op;
Is_A : Boolean;
If_Result_1 : Boolean;
Fld_6 : Internal_Entity_Base_Type_Decl;
Fld_7 : Internal_Discrete_Range;
Fld_8 : Internal_Eval_Discrete_Range := No_Eval_Discrete_Range;
Fld_9 : Big_Integer_Type;
Comp_Result_2 : Boolean;
Fld_10 : Big_Integer_Type;
Comp_Result_3 : Boolean;
If_Result_2 : Boolean;
Let_Result : Boolean;
Scope_Result : Boolean;
Result_Var : Boolean;
Bound_Origin : Bare_Ada_Node;
Bound_Imprecise_Fallback : Boolean;
Fld_11 : Boolean;
Dyn_Var_Bind_Result : Boolean;
Dyn_Var_Bind_Result_1 : Boolean;
If_Result_3 : Boolean;
Scope_Result_1 : Boolean;
Fld_12 : Big_Integer_Type;
Is_Equal_1 : Boolean;
Result_Var_1 : Boolean;
Fld_13 : Internal_Discrete_Range;
Fld_14 : Internal_Eval_Discrete_Range := No_Eval_Discrete_Range;
Fld_15 : Big_Integer_Type;
Comp_Result_4 : Boolean;
Fld_16 : Big_Integer_Type;
Comp_Result_5 : Boolean;
If_Result_4 : Boolean;
Let_Result_1 : Boolean;
Scope_Result_2 : Boolean;
Result_Var_2 : Boolean;
Bound_Origin_1 : Bare_Ada_Node;
Bound_Imprecise_Fallback_1 : Boolean;
Fld_17 : Internal_Entity_Base_Type_Decl;
Fld_18 : Boolean;
Dyn_Var_Bind_Result_2 : Boolean;
Dyn_Var_Bind_Result_3 : Boolean;
If_Result_5 : Boolean;
Fld_19 : Big_Integer_Type;
Is_Equal_2 : Boolean;
Match_Prefix : Internal_Entity;
Cast_Result : Internal_Entity_Bin_Op;
Let_Result_2 : Boolean;
Scope_Result_3 : Boolean;
Cast_Result_1 : Internal_Entity_Name;
Let_Result_3 : Boolean;
Scope_Result_4 : Boolean;
Cast_Result_2 : Internal_Entity_Subtype_Indication;
Let_Result_4 : Boolean;
Scope_Result_5 : Boolean;
Cast_Result_3 : Internal_Entity_Expr;
Let_Result_5 : Boolean;
Scope_Result_6 : Boolean;
Cast_Result_4 : Internal_Entity_Others_Designator;
Let_Result_6 : Boolean;
Scope_Result_7 : Boolean;
Cast_Result_5 : Internal_Entity;
Let_Result_7 : Boolean;
Scope_Result_8 : Boolean;
Match_Result : Boolean;
Let_Result_8 : Boolean;
            procedure Finalizer_Scope_1407 is
            begin
                     Dec_Ref (Fld_1);
                     Dec_Ref (Fld_3);
                     Dec_Ref (Fld_4);
            end Finalizer_Scope_1407;
            procedure Finalizer_Scope_1408 is
            begin
                     Dec_Ref (Fld_12);
            end Finalizer_Scope_1408;
            procedure Finalizer_Scope_1410 is
            begin
                     Dec_Ref (Fld_8);
                     Dec_Ref (Edr);
                     Dec_Ref (Fld_9);
                     Dec_Ref (Fld_10);
            end Finalizer_Scope_1410;
            procedure Finalizer_Scope_1413 is
            begin
                     Dec_Ref (Fld_14);
                     Dec_Ref (Edr_1);
                     Dec_Ref (Fld_15);
                     Dec_Ref (Fld_16);
            end Finalizer_Scope_1413;
            procedure Finalizer_Scope_1414 is
            begin
                     Dec_Ref (Fld_19);
            end Finalizer_Scope_1414;
begin
   --# property-body-start
   if Self /= null then
      Enter_Call (Self.Unit.Context, Call_Depth'Access);
   end if;
      if Self /= null then
         Reset_Caches (Self.Unit);
            Populate_Lexical_Env (Self.Unit);
      end if;
   --# scope-start
      --# expr-start 536 '<Block>' Let_Result_8 None
--# scope-start
--# expr-start 535 '<Match>' Match_Result /tmp/lal-21.0.0/ada/language/ast.py:966
      if Ent.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Match_Prefix := Ent; 
case Ada_Ada_Node (Match_Prefix.Node.Kind) is
         when Ada_Bin_Op .. Ada_Relation_Op =>
   --# scope-start
--# scope-start
      Cast_Result := Create_Internal_Entity_Bin_Op
        (Node => Match_Prefix.Node,
         Info => Match_Prefix.Info);
Match_0 := Cast_Result; 
--# bind bo Match_0
--# expr-start 512 '<If>' If_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:970
--# expr-start 505 '<IsA Op.DoubleDot>' Is_A /tmp/lal-21.0.0/ada/language/ast.py:972
--# expr-start 504 '<FieldAccess .op>' Fld_5 /tmp/lal-21.0.0/ada/language/ast.py:972
      if Match_0.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_5 := Create_Internal_Entity_Op (Node => Match_0.Node.Bin_Op_F_Op, Info => Match_0.Info);
--# expr-done 504
Is_A := Fld_5.Node /= null 
and then Fld_5.Node.Kind in Ada_Op_Double_Dot_Range; 
--# expr-done 505
if Is_A then
--# expr-start 507 '<FieldAccess .eval_as_int>' Fld_1 /tmp/lal-21.0.0/ada/language/ast.py:974
--# expr-start 506 '<FieldAccess .left>' Fld /tmp/lal-21.0.0/ada/language/ast.py:974
      if Match_0.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld := Create_Internal_Entity_Expr (Node => Match_0.Node.Bin_Op_F_Left, Info => Match_0.Info);
--# expr-done 506
      if Fld.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start Expr.eval_as_int
Fld_1 := Libadalang.Implementation.Expr_P_Eval_As_Int (Node => Fld.Node, E_Info => Fld.Info);
--# end
--# expr-done 507
Comp_Result := Value >= Fld_1; 
if Comp_Result then
--# expr-start 509 '<FieldAccess .eval_as_int>' Fld_3 /tmp/lal-21.0.0/ada/language/ast.py:975
--# expr-start 508 '<FieldAccess .right>' Fld_2 /tmp/lal-21.0.0/ada/language/ast.py:975
      if Match_0.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
Fld_2 := Create_Internal_Entity_Expr (Node => Match_0.Node.Bin_Op_F_Right, Info => Match_0.Info);
--# expr-done 508
      if Fld_2.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start Expr.eval_as_int
Fld_3 := Libadalang.Implementation.Expr_P_Eval_As_Int (Node => Fld_2.Node, E_Info => Fld_2.Info);
--# end
--# expr-done 509
Comp_Result_1 := Value <= Fld_3; 
   If_Result := Comp_Result_1;
else
   If_Result := False;
end if;
   If_Result_1 := If_Result;
else
   --# expr-start 511 '<Eq>' Is_Equal /tmp/lal-21.0.0/ada/language/ast.py:977
--# expr-start 510 '<FieldAccess .eval_as_int>' Fld_4 /tmp/lal-21.0.0/ada/language/ast.py:977
      if Match_0.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start Expr.eval_as_int
Fld_4 := Libadalang.Implementation.Expr_P_Eval_As_Int (Node => Match_0.Node, E_Info => Match_0.Info);
--# end
--# expr-done 510
Is_Equal := Equivalent (Value, Fld_4); 
--# expr-done 511
   If_Result_1 := Is_Equal;
end if;
--# expr-done 512
Let_Result_2 := If_Result_1; 
--# end
Scope_Result_3 := Let_Result_2;
   --# end
      Finalizer_Scope_1407;
            Match_Result := Scope_Result_3; 
         when Ada_Attribute_Ref .. Ada_Target_Name =>
   --# scope-start
--# scope-start
      Cast_Result_1 := Create_Internal_Entity_Name
        (Node => Match_Prefix.Node,
         Info => Match_Prefix.Info);
Match_1 := Cast_Result_1; 
--# bind n Match_1
--# expr-start 513 '<FieldAccess .name_designated_type>' Fld_6 /tmp/lal-21.0.0/ada/language/ast.py:982
      if Match_1.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start Name.name_designated_type
Fld_6 := Libadalang.Implementation.Name_P_Name_Designated_Type (Node => Match_1.Node, E_Info => Match_1.Info);
--# end
--# expr-done 513
Var_Expr := Fld_6;
if Var_Expr /= No_Entity_Base_Type_Decl then
   --# scope-start
   --# bind dt Var_Expr
--# expr-start 514 '<FieldAccess .discrete_range>' Fld_7 /tmp/lal-21.0.0/ada/language/ast.py:983
      if Var_Expr.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]BaseTypeDecl.discrete_range'
Fld_7 := Libadalang.Implementation.Dispatcher_Base_Type_Decl_P_Discrete_Range (Node => Var_Expr.Node, E_Info => Var_Expr.Info);
--# end
--# expr-done 514
Var_Expr_1 := Fld_7;
if Var_Expr_1 /= No_Discrete_Range then
   --# scope-start
   --# bind dr Var_Expr_1
--# expr-start 518 '<Let edr>' Let_Result /tmp/lal-21.0.0/ada/language/ast.py:984
--# scope-start
--# expr-start 515 '<FieldAccess .eval_discrete_range(...)>' Fld_8 /tmp/lal-21.0.0/ada/language/ast.py:985
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.eval_discrete_range
Fld_8 := Libadalang.Implementation.Ada_Node_P_Eval_Discrete_Range (Node => Self, Dr => Var_Expr_1);
--# end
--# expr-done 515
Edr := Fld_8; Inc_Ref (Edr);
--# bind edr Edr
--# expr-start 516 '<FieldAccess .low_bound>' Fld_9 /tmp/lal-21.0.0/ada/language/ast.py:986
Fld_9 := Edr.Low_Bound;
Inc_Ref (Fld_9);
--# expr-done 516
Comp_Result_2 := Value >= Fld_9; 
if Comp_Result_2 then
--# expr-start 517 '<FieldAccess .high_bound>' Fld_10 /tmp/lal-21.0.0/ada/language/ast.py:986
Fld_10 := Edr.High_Bound;
Inc_Ref (Fld_10);
--# expr-done 517
Comp_Result_3 := Value <= Fld_10; 
   If_Result_2 := Comp_Result_3;
else
   If_Result_2 := False;
end if;
Let_Result := If_Result_2; 
--# end
--# expr-done 518
Scope_Result := Let_Result;
   --# end
      Finalizer_Scope_1410;
   Result_Var := Scope_Result;
else
   Result_Var := True;
end if;
if Result_Var then
   --# expr-start 521 '<bind(<DynamicVariable origin>, <Var Self>, <bind(<DynamicVariable imprecise_fallback>, False, <FieldAccess .satisfies_type_predicates(...)>)>)>' Dyn_Var_Bind_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:990
Bound_Origin := Self; 
--# expr-start 520 '<bind(<DynamicVariable imprecise_fallback>, False, <FieldAccess .satisfies_type_predicates(...)>)>' Dyn_Var_Bind_Result /tmp/lal-21.0.0/ada/language/ast.py:991
Bound_Imprecise_Fallback := False; 
--# expr-start 519 '<FieldAccess .satisfies_type_predicates(...)>' Fld_11 /tmp/lal-21.0.0/ada/language/ast.py:992
      if Var_Expr.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start BaseTypeDecl.satisfies_type_predicates
Fld_11 := Libadalang.Implementation.Base_Type_Decl_P_Satisfies_Type_Predicates (Node => Var_Expr.Node, Value => Value, Imprecise_Fallback => Bound_Imprecise_Fallback, Origin => Bound_Origin, E_Info => Var_Expr.Info);
--# end
--# expr-done 519
Dyn_Var_Bind_Result := Fld_11; 
--# expr-done 520
Dyn_Var_Bind_Result_1 := Dyn_Var_Bind_Result; 
--# expr-done 521
   If_Result_3 := Dyn_Var_Bind_Result_1;
else
   If_Result_3 := False;
end if;
Scope_Result_1 := If_Result_3;
   --# end
   Result_Var_1 := Scope_Result_1;
else
   --# expr-start 523 '<Eq>' Is_Equal_1 /tmp/lal-21.0.0/ada/language/ast.py:995
--# expr-start 522 '<FieldAccess .eval_as_int>' Fld_12 /tmp/lal-21.0.0/ada/language/ast.py:995
      if Match_1.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start Expr.eval_as_int
Fld_12 := Libadalang.Implementation.Expr_P_Eval_As_Int (Node => Match_1.Node, E_Info => Match_1.Info);
--# end
--# expr-done 522
Is_Equal_1 := Equivalent (Value, Fld_12); 
--# expr-done 523
   Result_Var_1 := Is_Equal_1;
end if;
Let_Result_3 := Result_Var_1; 
--# end
Scope_Result_4 := Let_Result_3;
   --# end
      Finalizer_Scope_1408;
            Match_Result := Scope_Result_4; 
         when Ada_Subtype_Indication .. Ada_Discrete_Subtype_Indication =>
   --# scope-start
--# scope-start
      Cast_Result_2 := Create_Internal_Entity_Subtype_Indication
        (Node => Match_Prefix.Node,
         Info => Match_Prefix.Info);
Match_2 := Cast_Result_2; 
--# bind st Match_2
--# expr-start 524 '<FieldAccess .discrete_range>' Fld_13 /tmp/lal-21.0.0/ada/language/ast.py:999
      if Match_2.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start SubtypeIndication.discrete_range
Fld_13 := Libadalang.Implementation.Subtype_Indication_P_Discrete_Range (Node => Match_2.Node, E_Info => Match_2.Info);
--# end
--# expr-done 524
Var_Expr_2 := Fld_13;
if Var_Expr_2 /= No_Discrete_Range then
   --# scope-start
   --# bind dr Var_Expr_2
--# expr-start 528 '<Let edr>' Let_Result_1 /tmp/lal-21.0.0/ada/language/ast.py:1000
--# scope-start
--# expr-start 525 '<FieldAccess .eval_discrete_range(...)>' Fld_14 /tmp/lal-21.0.0/ada/language/ast.py:1001
      if Self = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start AdaNode.eval_discrete_range
Fld_14 := Libadalang.Implementation.Ada_Node_P_Eval_Discrete_Range (Node => Self, Dr => Var_Expr_2);
--# end
--# expr-done 525
Edr_1 := Fld_14; Inc_Ref (Edr_1);
--# bind edr Edr_1
--# expr-start 526 '<FieldAccess .low_bound>' Fld_15 /tmp/lal-21.0.0/ada/language/ast.py:1002
Fld_15 := Edr_1.Low_Bound;
Inc_Ref (Fld_15);
--# expr-done 526
Comp_Result_4 := Value >= Fld_15; 
if Comp_Result_4 then
--# expr-start 527 '<FieldAccess .high_bound>' Fld_16 /tmp/lal-21.0.0/ada/language/ast.py:1002
Fld_16 := Edr_1.High_Bound;
Inc_Ref (Fld_16);
--# expr-done 527
Comp_Result_5 := Value <= Fld_16; 
   If_Result_4 := Comp_Result_5;
else
   If_Result_4 := False;
end if;
Let_Result_1 := If_Result_4; 
--# end
--# expr-done 528
Scope_Result_2 := Let_Result_1;
   --# end
      Finalizer_Scope_1413;
   Result_Var_2 := Scope_Result_2;
else
   Result_Var_2 := True;
end if;
if Result_Var_2 then
   --# expr-start 532 '<bind(<DynamicVariable origin>, <Var Self>, <bind(<DynamicVariable imprecise_fallback>, False, <FieldAccess .satisfies_type_predicates(...)>)>)>' Dyn_Var_Bind_Result_3 /tmp/lal-21.0.0/ada/language/ast.py:1006
Bound_Origin_1 := Self; 
--# expr-start 531 '<bind(<DynamicVariable imprecise_fallback>, False, <FieldAccess .satisfies_type_predicates(...)>)>' Dyn_Var_Bind_Result_2 /tmp/lal-21.0.0/ada/language/ast.py:1007
Bound_Imprecise_Fallback_1 := False; 
--# expr-start 530 '<FieldAccess .satisfies_type_predicates(...)>' Fld_18 /tmp/lal-21.0.0/ada/language/ast.py:1008
--# expr-start 529 '<FieldAccess .designated_type>' Fld_17 /tmp/lal-21.0.0/ada/language/ast.py:1008
      if Match_2.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start '[dispatcher]TypeExpr.designated_type'
Fld_17 := Libadalang.Implementation.Dispatcher_Type_Expr_P_Designated_Type (Node => Match_2.Node, Origin => Bound_Origin_1, E_Info => Match_2.Info);
--# end
--# expr-done 529
      if Fld_17.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start BaseTypeDecl.satisfies_type_predicates
Fld_18 := Libadalang.Implementation.Base_Type_Decl_P_Satisfies_Type_Predicates (Node => Fld_17.Node, Value => Value, Imprecise_Fallback => Bound_Imprecise_Fallback_1, Origin => Bound_Origin_1, E_Info => Fld_17.Info);
--# end
--# expr-done 530
Dyn_Var_Bind_Result_2 := Fld_18; 
--# expr-done 531
Dyn_Var_Bind_Result_3 := Dyn_Var_Bind_Result_2; 
--# expr-done 532
   If_Result_5 := Dyn_Var_Bind_Result_3;
else
   If_Result_5 := False;
end if;
Let_Result_4 := If_Result_5; 
--# end
Scope_Result_5 := Let_Result_4;
   --# end
            Match_Result := Scope_Result_5; 
         when Ada_Allocator .. Ada_Null_Record_Aggregate | Ada_Box_Expr .. Ada_Membership_Expr | Ada_Paren_Expr .. Ada_Un_Op =>
   --# scope-start
--# scope-start
      Cast_Result_3 := Create_Internal_Entity_Expr
        (Node => Match_Prefix.Node,
         Info => Match_Prefix.Info);
Match_3 := Cast_Result_3; 
--# bind e Match_3
--# expr-start 534 '<Eq>' Is_Equal_2 /tmp/lal-21.0.0/ada/language/ast.py:1013
--# expr-start 533 '<FieldAccess .eval_as_int>' Fld_19 /tmp/lal-21.0.0/ada/language/ast.py:1013
      if Match_3.Node = null then
         raise Property_Error with "dereferencing a null access";
      end if;
--# property-call-start Expr.eval_as_int
Fld_19 := Libadalang.Implementation.Expr_P_Eval_As_Int (Node => Match_3.Node, E_Info => Match_3.Info);
--# end
--# expr-done 533
Is_Equal_2 := Equivalent (Value, Fld_19); 
--# expr-done 534
Let_Result_5 := Is_Equal_2; 
--# end
Scope_Result_6 := Let_Result_5;
   --# end
      Finalizer_Scope_1414;
            Match_Result := Scope_Result_6; 
         when Ada_Others_Designator =>
   --# scope-start
--# scope-start
      Cast_Result_4 := Create_Internal_Entity_Others_Designator
        (Node => Match_Prefix.Node,
         Info => Match_Prefix.Info);
Match_4 := Cast_Result_4; 
--# bind _ Match_4
Let_Result_6 := True; 
--# end
Scope_Result_7 := Let_Result_6;
   --# end
            Match_Result := Scope_Result_7; 
         when Ada_Abort_Absent .. Ada_Elsif_Stmt_Part | Ada_Handled_Stmts .. Ada_Null_Component_Decl | Ada_Overriding_Not_Overriding .. Ada_Enum_Lit_Synth_Type_Expr | Ada_Unconstrained_Array_Index .. Ada_With_Private_Present =>
   --# scope-start
--# scope-start
      Cast_Result_5 := Create_Internal_Entity
        (Node => Match_Prefix.Node,
         Info => Match_Prefix.Info);
Match_5 := Cast_Result_5; 
--# bind _ Match_5
Let_Result_7 := False; 
--# end
Scope_Result_8 := Let_Result_7;
   --# end
            Match_Result := Scope_Result_8; 
end case;
--# expr-done 535
Let_Result_8 := Match_Result; 
--# end
--# expr-done 536
      Property_Result := Let_Result_8;
   --# end
   if Self /= null then
      Exit_Call (Self.Unit.Context, Call_Depth);
   end if;
   return Property_Result;
exception
   when Property_Error =>
               Finalizer_Scope_1407;
               Finalizer_Scope_1408;
               Finalizer_Scope_1410;
               Finalizer_Scope_1413;
               Finalizer_Scope_1414;
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
   when others =>
      if Self /= null then
         Exit_Call (Self.Unit.Context, Call_Depth);
      end if;
      raise;
end Ada_Node_P_Choice_Match;
--# end
--# property-start AdaNode.gnat_xref /tmp/lal-21.0.0/ada/language/ast.py:1022
pragma Warnings (Off, "is not referenced");
 function Ada_Node_P_Gnat_Xref
  (Node : Bare_Ada_Node
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )
   return Internal_Entity_Defining_Name
is
   Self : Bare_Ada_Node := Bare_Ada_Node (Node);
   Call_Depth : aliased Natural;
   Ent : Internal_Entity :=
     Internal_Entity'(Node => Self, Info => E_Info);
   --# bind entity Ent
   --# bind imprecise_fallback Imprecise_Fallback
   Property_Result : Internal_Entity_Defining_Name;
            procedure Finalizer_Scope_1430;
      Block_Var : Internal_Entity_Basic_Decl;
Var_Expr : Internal_Entity_Defining_Name;
Var_Expr_1 : Internal_Entity_Basic_Decl;
Var_Expr_2 : Internal_Entity_Basic_Decl;
Var_Expr_3 : Internal_Entity_Basic_Decl;
Var_Expr_4 : Internal_Entity_Basic_Decl;
Var_Expr_5 : Internal_Entity_Basic_Decl;
Var_Expr_6 : Internal_Entity_Base_Type_Decl;
Var_Expr_7 : Boolean;
Var_Expr_8 : Internal_Entity_Defining_Name;
Var_Expr_9 : Internal_Entity_Base_Type_Decl;
Var_Expr_10 : Internal_Entity_Defining_Name;
Var_Expr_11 : Internal_Entity_Name;
Dbd : Internal_Entity_Basic_Decl;
Var_Expr_12 : Internal_Entity_Generic_Instantiation;
Var_Expr_13 : Internal_Entity_Defining_Name;
Var_Expr_14 : Internal_Entity_Basic_Decl;
Var_Expr_15 : Internal_Entity_Basic_Decl;
Cast_Expr : Internal_Entity;
Cast_Result : Internal_Entity_Name;
Fld : Internal_Entity_Defining_Name;
Fld_1 : Internal_Entity_Basic_Decl;
Scope_Result : Internal_Entity_Basic_Decl;
Result_Var : Internal_Entity_Basic_Decl;
Bound_Origin : Bare_Ada_Node;
Is_A : Boolean;
Scope_Result_1 : Boolean;
Result_Var_1 : Boolean;
Fld_2 : Internal_Entity;
Is_A_1 : Boolean;
If_Result : Boolean;
Fld_3 : Internal_Entity;
Cast_Result_1 : Internal_Entity_Basic_Decl;
Fld_4 : Internal_Entity_Defining_Name;
Is_A_2 : Boolean;
Scope_Result_2 : Boolean;
Result_Var_2 : Boolean;
Fld_5 : Internal_Entity;
Cast_Result_2 : Internal_Entity_Basic_Decl;
Fld_6 : Internal_Entity_Defining_Name;
Is_A_3 : Boolean;
Scope_Result_3 : Boolean;
Result_Var_3 : Boolean;
Fld_7 : Internal_Entity;
Is_A_4 : Boolean;
If_Result_1 : Boolean;
Fld_8 : Internal_Entity;
Cast_Result_3 : Internal_Entity_Basic_Decl;
Fld_9 : Internal_Entity_Defining_Name;
Is_A_5 : Boolean;
Scope_Result_4 : Boolean;
Result_Var_4 : Boolean;
Cast_Expr_1 : Internal_Entity_Basic_Decl;
Cast_Result_4 : Internal_Entity_Abstract_Subp_Decl;
Fld_10 : Internal_Entity_Base_Subp_Spec;
Fld_11 : Internal_Entity_Base_Type_Decl;
Fld_12 : Internal_Entity_Defining_Name;
Is_A_6 : Boolean;
Scope_Result_5 : Boolean;
Result_Var_5 : Boolean;
Cast_Expr_2 : Internal_Entity_Basic_Decl;
Cast_Result_5 : Internal_Entity_Basic_Subp_Decl;
Fld_13 : Internal_Entity_Base_Subp_Spec;
Fld_14 : Internal_Entity_Base_Type_Decl;
Fld_15 : Boolean;
Fld_16 : Internal_Entity_Base_Type_Decl;
Fld_17 : Internal_Entity_Defining_Name;
Scope_Result_6 : Internal_Entity_Defining_Name;
Result_Var_6 : Internal_Entity_Defining_Name;
Scope_Result_7 : Internal_Entity_Defining_Name;
Fld_18 : Internal_Entity_Defining_Name;
Result_Var_7 : Internal_Entity_Defining_Name;
Scope_Result_8 : Internal_Entity_Defining_Name;
Result_Var_8 : Internal_Entity_Defining_Name;
Scope_Result_9 : Internal_Entity_Defining_Name;
Result_Var_9 : Internal_Entity_Defining_Name;
Cast_Expr_3 : Internal_Entity;
Cast_Result_6 : Internal_Entity_Name;
Fld_19 : Internal_Entity_Defining_Name;
Scope_Result_10 : Internal_Entity_Defining_Name;
Result_Var_10 : Internal_Entity_Defining_Name;
Fld_20 : Internal_Entity_Basic_Decl;
Is_A_7 : Boolean;
Cast_Expr_4 : Internal_Entity_Basic_Decl;
Cast_Result_7 : Internal_Entity_Param_Spec;
Fld_21 : Internal_Entity_Defining_Name;
Is_A_8 : Boolean;
Fld_22 : Internal_Entity_Generic_Instantiation_Array_Access;
Get_Result : Internal_Entity_Generic_Instantiation;
Cast_Expr_5 : Internal_Entity_Generic_Instantiation;
Cast_Result_8 : Internal_Entity_Basic_Decl;
Fld_23 : Internal_Entity_Defining_Name;
Scope_Result_11 : Internal_Entity_Defining_Name;
Result_Var_11 : Internal_Entity_Defining_Name;
Is_A_9 : Boolean;
Cast_Expr_6 : Internal_Entity_Basic_Decl;
Cast_Result_9 : Internal_Entity_Object_Decl;
Fld_24 : Internal_Entity_Basic_Decl;
Fld_25 : Internal_Entity_Defining_Name;
Scope_Result_12 : Internal_Entity_Defining_Name;
Result_Var_12 : Internal_Entity_Defining_Name;
Scope_Result_13 : Internal_Entity_Defining_Name;
Result_Var_13 : Internal_Entity_Defining_Name;
Is_A_10 : Boolean;
Cast_Expr_7 : Internal_Entity_Basic_Decl;
Cast_Result_10 : Internal_Entity_Base_Subp_Body;
Fld_26 : Internal_Entity_Basic_Decl;
Scope_Result_14 : Internal_Entity_Basic_Decl;
Result_Var_14 : Internal_Entity_Basic_Decl;
Fld_27 : Internal_Entity_Defining_Name;
If_Result_2 : Internal_Entity_Defining_Name;
If_Result_3 : Internal_Entity_Defining_Name;
If_Result_4 : Internal_Entity_Defining_Name;
If_Result_5 : Internal_Entity_Defining_Name;
Let_Result : Internal_Entity_Defining_Name;
Scope_Result_15 : Internal_Entity_Defining_Name;
Result_Var_15 : Internal_Entity_Defining_Name;
If_Result_6 : Internal_Entity_Defining_Name;
If_Result_7 : Internal_Entity_Defining_Name;
If_Result_8 : Internal_Entity_Defining_Name;
If_Result_9 : Internal_Entity_Defining_Name;
If_Result_10 : Internal_Entity_Defining_Name;
Dyn_Var_Bind_Result : Internal_Entity_Defining_Name;
Let_Result_1 : Internal_Entity_Defining_Name;
            procedure Finalizer_Scope_1430 is
            begin
                     Dec_Ref (Fld_22);
            end Finalizer_Scope_1430;
begin
   --# property-body-start
   if Self 