


package body Libadalang.Lexer_State_Machine is

   Is_Trivia : constant array (Token_Kind) of Boolean := (
      Ada_Termination => False, Ada_Lexing_Failure => True, Ada_Identifier => False, Ada_All => False, Ada_Abort => False, Ada_Else => False, Ada_New => False, Ada_Return => False, Ada_Abs => False, Ada_Elsif => False, Ada_Not => False, Ada_Reverse => False, Ada_End => False, Ada_Null => False, Ada_Accept => False, Ada_Entry => False, Ada_Select => False, Ada_Access => False, Ada_Exception => False, Ada_Of => False, Ada_Separate => False, Ada_Exit => False, Ada_Or => False, Ada_Others => False, Ada_Subtype => False, Ada_And => False, Ada_For => False, Ada_Out => False, Ada_Array => False, Ada_Function => False, Ada_At => False, Ada_Generic => False, Ada_Package => False, Ada_Task => False, Ada_Begin => False, Ada_Goto => False, Ada_Pragma => False, Ada_Terminate => False, Ada_Body => False, Ada_Private => False, Ada_Then => False, Ada_If => False, Ada_Procedure => False, Ada_Type => False, Ada_Case => False, Ada_In => False, Ada_Constant => False, Ada_Is => False, Ada_Raise => False, Ada_Use => False, Ada_Declare => False, Ada_Range => False, Ada_Delay => False, Ada_Limited => False, Ada_Record => False, Ada_When => False, Ada_Delta => False, Ada_Loop => False, Ada_Rem => False, Ada_While => False, Ada_Digits => False, Ada_Renames => False, Ada_Do => False, Ada_Mod => False, Ada_Xor => False, Ada_Par_Close => False, Ada_Par_Open => False, Ada_Brack_Close => False, Ada_Brack_Open => False, Ada_Semicolon => False, Ada_Colon => False, Ada_Comma => False, Ada_Doubledot => False, Ada_Dot => False, Ada_Diamond => False, Ada_Lte => False, Ada_Gte => False, Ada_Arrow => False, Ada_Equal => False, Ada_Lt => False, Ada_Gt => False, Ada_Plus => False, Ada_Minus => False, Ada_Power => False, Ada_Mult => False, Ada_Amp => False, Ada_Notequal => False, Ada_Divide => False, Ada_Tick => False, Ada_Pipe => False, Ada_Assign => False, Ada_Label_Start => False, Ada_Label_End => False, Ada_Target => False, Ada_String => False, Ada_Char => False, Ada_With => False, Ada_Decimal => False, Ada_Integer => False, Ada_Comment => True, Ada_Prep_Line => True, Ada_Whitespace => True
   );

   type Character_Range is record
      First, Last : Character_Type;
   end record;

   type Character_Range_Array is array (Positive range <>) of Character_Range;
   --  Sorted list of dijoint character ranges

   function Contains
     (Char : Character_Type; Ranges : Character_Range_Array) return Boolean;
   --  Return whether Char is included in the given ranges

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize
     (Self        : out Lexer_State;
      Input       : Text_Access;
      Input_First : Positive;
      Input_Last  : Natural) is
   begin
      Self.Input := Input;
      Self.Input_First := Input_First;
      Self.Input_Last := Input_Last;
      Self.Has_Next := True;
      Self.Last_Token := (Kind       => Ada_Termination,
                          Text_First => Input_First,
                          Text_Last  => Input_First - 1);
      Self.Last_Token_Kind := Ada_Termination;
   end Initialize;

   ----------------
   -- Last_Token --
   ----------------

   function Last_Token (Self : Lexer_State) return Lexed_Token is
   begin
      return Self.Last_Token;
   end Last_Token;

   --------------
   -- Has_Next --
   --------------

   function Has_Next (Self : Lexer_State) return Boolean is
   begin
      return Self.Has_Next;
   end Has_Next;

   --------------
   -- Contains --
   --------------

   function Contains
     (Char : Character_Type; Ranges : Character_Range_Array) return Boolean
   is
      Low  : Natural := Ranges'First;
      High : Natural := Ranges'Last;
   begin
      while Low <= High loop
         declare
            Middle : constant Natural := (Low + High) / 2;
            R      : Character_Range renames Ranges (Middle);
         begin
            if Char < R.First then
               High := Middle - 1;
            elsif Char > R.Last then
               Low := Middle + 1;
            else
               return True;
            end if;
         end;
      end loop;
      return False;
   end Contains;

   Ranges_0 : constant Character_Range_Array := (
   (Character_Type'Val (192), Character_Type'Val (214)),
   (Character_Type'Val (216), Character_Type'Val (222)),
   (Character_Type'Val (256), Character_Type'Val (256)),
   (Character_Type'Val (258), Character_Type'Val (258)),
   (Character_Type'Val (260), Character_Type'Val (260)),
   (Character_Type'Val (262), Character_Type'Val (262)),
   (Character_Type'Val (264), Character_Type'Val (264)),
   (Character_Type'Val (266), Character_Type'Val (266)),
   (Character_Type'Val (268), Character_Type'Val (268)),
   (Character_Type'Val (270), Character_Type'Val (270)),
   (Character_Type'Val (272), Character_Type'Val (272)),
   (Character_Type'Val (274), Character_Type'Val (274)),
   (Character_Type'Val (276), Character_Type'Val (276)),
   (Character_Type'Val (278), Character_Type'Val (278)),
   (Character_Type'Val (280), Character_Type'Val (280)),
   (Character_Type'Val (282), Character_Type'Val (282)),
   (Character_Type'Val (284), Character_Type'Val (284)),
   (Character_Type'Val (286), Character_Type'Val (286)),
   (Character_Type'Val (288), Character_Type'Val (288)),
   (Character_Type'Val (290), Character_Type'Val (290)),
   (Character_Type'Val (292), Character_Type'Val (292)),
   (Character_Type'Val (294), Character_Type'Val (294)),
   (Character_Type'Val (296), Character_Type'Val (296)),
   (Character_Type'Val (298), Character_Type'Val (298)),
   (Character_Type'Val (300), Character_Type'Val (300)),
   (Character_Type'Val (302), Character_Type'Val (302)),
   (Character_Type'Val (304), Character_Type'Val (304)),
   (Character_Type'Val (306), Character_Type'Val (306)),
   (Character_Type'Val (308), Character_Type'Val (308)),
   (Character_Type'Val (310), Character_Type'Val (310)),
   (Character_Type'Val (313), Character_Type'Val (313)),
   (Character_Type'Val (315), Character_Type'Val (315)),
   (Character_Type'Val (317), Character_Type'Val (317)),
   (Character_Type'Val (319), Character_Type'Val (319)),
   (Character_Type'Val (321), Character_Type'Val (321)),
   (Character_Type'Val (323), Character_Type'Val (323)),
   (Character_Type'Val (325), Character_Type'Val (325)),
   (Character_Type'Val (327), Character_Type'Val (327)),
   (Character_Type'Val (330), Character_Type'Val (330)),
   (Character_Type'Val (332), Character_Type'Val (332)),
   (Character_Type'Val (334), Character_Type'Val (334)),
   (Character_Type'Val (336), Character_Type'Val (336)),
   (Character_Type'Val (338), Character_Type'Val (338)),
   (Character_Type'Val (340), Character_Type'Val (340)),
   (Character_Type'Val (342), Character_Type'Val (342)),
   (Character_Type'Val (344), Character_Type'Val (344)),
   (Character_Type'Val (346), Character_Type'Val (346)),
   (Character_Type'Val (348), Character_Type'Val (348)),
   (Character_Type'Val (350), Character_Type'Val (350)),
   (Character_Type'Val (352), Character_Type'Val (352)),
   (Character_Type'Val (354), Character_Type'Val (354)),
   (Character_Type'Val (356), Character_Type'Val (356)),
   (Character_Type'Val (358), Character_Type'Val (358)),
   (Character_Type'Val (360), Character_Type'Val (360)),
   (Character_Type'Val (362), Character_Type'Val (362)),
   (Character_Type'Val (364), Character_Type'Val (364)),
   (Character_Type'Val (366), Character_Type'Val (366)),
   (Character_Type'Val (368), Character_Type'Val (368)),
   (Character_Type'Val (370), Character_Type'Val (370)),
   (Character_Type'Val (372), Character_Type'Val (372)),
   (Character_Type'Val (374), Character_Type'Val (374)),
   (Character_Type'Val (376), Character_Type'Val (377)),
   (Character_Type'Val (379), Character_Type'Val (379)),
   (Character_Type'Val (381), Character_Type'Val (381)),
   (Character_Type'Val (385), Character_Type'Val (386)),
   (Character_Type'Val (388), Character_Type'Val (388)),
   (Character_Type'Val (390), Character_Type'Val (391)),
   (Character_Type'Val (393), Character_Type'Val (395)),
   (Character_Type'Val (398), Character_Type'Val (401)),
   (Character_Type'Val (403), Character_Type'Val (404)),
   (Character_Type'Val (406), Character_Type'Val (408)),
   (Character_Type'Val (412), Character_Type'Val (413)),
   (Character_Type'Val (415), Character_Type'Val (416)),
   (Character_Type'Val (418), Character_Type'Val (418)),
   (Character_Type'Val (420), Character_Type'Val (420)),
   (Character_Type'Val (422), Character_Type'Val (423)),
   (Character_Type'Val (425), Character_Type'Val (425)),
   (Character_Type'Val (428), Character_Type'Val (428)),
   (Character_Type'Val (430), Character_Type'Val (431)),
   (Character_Type'Val (433), Character_Type'Val (435)),
   (Character_Type'Val (437), Character_Type'Val (437)),
   (Character_Type'Val (439), Character_Type'Val (440)),
   (Character_Type'Val (444), Character_Type'Val (444)),
   (Character_Type'Val (452), Character_Type'Val (452)),
   (Character_Type'Val (455), Character_Type'Val (455)),
   (Character_Type'Val (458), Character_Type'Val (458)),
   (Character_Type'Val (461), Character_Type'Val (461)),
   (Character_Type'Val (463), Character_Type'Val (463)),
   (Character_Type'Val (465), Character_Type'Val (465)),
   (Character_Type'Val (467), Character_Type'Val (467)),
   (Character_Type'Val (469), Character_Type'Val (469)),
   (Character_Type'Val (471), Character_Type'Val (471)),
   (Character_Type'Val (473), Character_Type'Val (473)),
   (Character_Type'Val (475), Character_Type'Val (475)),
   (Character_Type'Val (478), Character_Type'Val (478)),
   (Character_Type'Val (480), Character_Type'Val (480)),
   (Character_Type'Val (482), Character_Type'Val (482)),
   (Character_Type'Val (484), Character_Type'Val (484)),
   (Character_Type'Val (486), Character_Type'Val (486)),
   (Character_Type'Val (488), Character_Type'Val (488)),
   (Character_Type'Val (490), Character_Type'Val (490)),
   (Character_Type'Val (492), Character_Type'Val (492)),
   (Character_Type'Val (494), Character_Type'Val (494)),
   (Character_Type'Val (497), Character_Type'Val (497)),
   (Character_Type'Val (500), Character_Type'Val (500)),
   (Character_Type'Val (502), Character_Type'Val (504)),
   (Character_Type'Val (506), Character_Type'Val (506)),
   (Character_Type'Val (508), Character_Type'Val (508)),
   (Character_Type'Val (510), Character_Type'Val (510)),
   (Character_Type'Val (512), Character_Type'Val (512)),
   (Character_Type'Val (514), Character_Type'Val (514)),
   (Character_Type'Val (516), Character_Type'Val (516)),
   (Character_Type'Val (518), Character_Type'Val (518)),
   (Character_Type'Val (520), Character_Type'Val (520)),
   (Character_Type'Val (522), Character_Type'Val (522)),
   (Character_Type'Val (524), Character_Type'Val (524)),
   (Character_Type'Val (526), Character_Type'Val (526)),
   (Character_Type'Val (528), Character_Type'Val (528)),
   (Character_Type'Val (530), Character_Type'Val (530)),
   (Character_Type'Val (532), Character_Type'Val (532)),
   (Character_Type'Val (534), Character_Type'Val (534)),
   (Character_Type'Val (536), Character_Type'Val (536)),
   (Character_Type'Val (538), Character_Type'Val (538)),
   (Character_Type'Val (540), Character_Type'Val (540)),
   (Character_Type'Val (542), Character_Type'Val (542)),
   (Character_Type'Val (544), Character_Type'Val (544)),
   (Character_Type'Val (546), Character_Type'Val (546)),
   (Character_Type'Val (548), Character_Type'Val (548)),
   (Character_Type'Val (550), Character_Type'Val (550)),
   (Character_Type'Val (552), Character_Type'Val (552)),
   (Character_Type'Val (554), Character_Type'Val (554)),
   (Character_Type'Val (556), Character_Type'Val (556)),
   (Character_Type'Val (558), Character_Type'Val (558)),
   (Character_Type'Val (560), Character_Type'Val (560)),
   (Character_Type'Val (562), Character_Type'Val (562)),
   (Character_Type'Val (570), Character_Type'Val (571)),
   (Character_Type'Val (573), Character_Type'Val (574)),
   (Character_Type'Val (577), Character_Type'Val (577)),
   (Character_Type'Val (579), Character_Type'Val (582)),
   (Character_Type'Val (584), Character_Type'Val (584)),
   (Character_Type'Val (586), Character_Type'Val (586)),
   (Character_Type'Val (588), Character_Type'Val (588)),
   (Character_Type'Val (590), Character_Type'Val (590)),
   (Character_Type'Val (880), Character_Type'Val (880)),
   (Character_Type'Val (882), Character_Type'Val (882)),
   (Character_Type'Val (886), Character_Type'Val (886)),
   (Character_Type'Val (902), Character_Type'Val (902)),
   (Character_Type'Val (904), Character_Type'Val (906)),
   (Character_Type'Val (908), Character_Type'Val (908)),
   (Character_Type'Val (910), Character_Type'Val (911)),
   (Character_Type'Val (913), Character_Type'Val (929)),
   (Character_Type'Val (931), Character_Type'Val (939)),
   (Character_Type'Val (975), Character_Type'Val (975)),
   (Character_Type'Val (978), Character_Type'Val (980)),
   (Character_Type'Val (984), Character_Type'Val (984)),
   (Character_Type'Val (986), Character_Type'Val (986)),
   (Character_Type'Val (988), Character_Type'Val (988)),
   (Character_Type'Val (990), Character_Type'Val (990)),
   (Character_Type'Val (992), Character_Type'Val (992)),
   (Character_Type'Val (994), Character_Type'Val (994)),
   (Character_Type'Val (996), Character_Type'Val (996)),
   (Character_Type'Val (998), Character_Type'Val (998)),
   (Character_Type'Val (1000), Character_Type'Val (1000)),
   (Character_Type'Val (1002), Character_Type'Val (1002)),
   (Character_Type'Val (1004), Character_Type'Val (1004)),
   (Character_Type'Val (1006), Character_Type'Val (1006)),
   (Character_Type'Val (1012), Character_Type'Val (1012)),
   (Character_Type'Val (1015), Character_Type'Val (1015)),
   (Character_Type'Val (1017), Character_Type'Val (1018)),
   (Character_Type'Val (1021), Character_Type'Val (1071)),
   (Character_Type'Val (1120), Character_Type'Val (1120)),
   (Character_Type'Val (1122), Character_Type'Val (1122)),
   (Character_Type'Val (1124), Character_Type'Val (1124)),
   (Character_Type'Val (1126), Character_Type'Val (1126)),
   (Character_Type'Val (1128), Character_Type'Val (1128)),
   (Character_Type'Val (1130), Character_Type'Val (1130)),
   (Character_Type'Val (1132), Character_Type'Val (1132)),
   (Character_Type'Val (1134), Character_Type'Val (1134)),
   (Character_Type'Val (1136), Character_Type'Val (1136)),
   (Character_Type'Val (1138), Character_Type'Val (1138)),
   (Character_Type'Val (1140), Character_Type'Val (1140)),
   (Character_Type'Val (1142), Character_Type'Val (1142)),
   (Character_Type'Val (1144), Character_Type'Val (1144)),
   (Character_Type'Val (1146), Character_Type'Val (1146)),
   (Character_Type'Val (1148), Character_Type'Val (1148)),
   (Character_Type'Val (1150), Character_Type'Val (1150)),
   (Character_Type'Val (1152), Character_Type'Val (1152)),
   (Character_Type'Val (1162), Character_Type'Val (1162)),
   (Character_Type'Val (1164), Character_Type'Val (1164)),
   (Character_Type'Val (1166), Character_Type'Val (1166)),
   (Character_Type'Val (1168), Character_Type'Val (1168)),
   (Character_Type'Val (1170), Character_Type'Val (1170)),
   (Character_Type'Val (1172), Character_Type'Val (1172)),
   (Character_Type'Val (1174), Character_Type'Val (1174)),
   (Character_Type'Val (1176), Character_Type'Val (1176)),
   (Character_Type'Val (1178), Character_Type'Val (1178)),
   (Character_Type'Val (1180), Character_Type'Val (1180)),
   (Character_Type'Val (1182), Character_Type'Val (1182)),
   (Character_Type'Val (1184), Character_Type'Val (1184)),
   (Character_Type'Val (1186), Character_Type'Val (1186)),
   (Character_Type'Val (1188), Character_Type'Val (1188)),
   (Character_Type'Val (1190), Character_Type'Val (1190)),
   (Character_Type'Val (1192), Character_Type'Val (1192)),
   (Character_Type'Val (1194), Character_Type'Val (1194)),
   (Character_Type'Val (1196), Character_Type'Val (1196)),
   (Character_Type'Val (1198), Character_Type'Val (1198)),
   (Character_Type'Val (1200), Character_Type'Val (1200)),
   (Character_Type'Val (1202), Character_Type'Val (1202)),
   (Character_Type'Val (1204), Character_Type'Val (1204)),
   (Character_Type'Val (1206), Character_Type'Val (1206)),
   (Character_Type'Val (1208), Character_Type'Val (1208)),
   (Character_Type'Val (1210), Character_Type'Val (1210)),
   (Character_Type'Val (1212), Character_Type'Val (1212)),
   (Character_Type'Val (1214), Character_Type'Val (1214)),
   (Character_Type'Val (1216), Character_Type'Val (1217)),
   (Character_Type'Val (1219), Character_Type'Val (1219)),
   (Character_Type'Val (1221), Character_Type'Val (1221)),
   (Character_Type'Val (1223), Character_Type'Val (1223)),
   (Character_Type'Val (1225), Character_Type'Val (1225)),
   (Character_Type'Val (1227), Character_Type'Val (1227)),
   (Character_Type'Val (1229), Character_Type'Val (1229)),
   (Character_Type'Val (1232), Character_Type'Val (1232)),
   (Character_Type'Val (1234), Character_Type'Val (1234)),
   (Character_Type'Val (1236), Character_Type'Val (1236)),
   (Character_Type'Val (1238), Character_Type'Val (1238)),
   (Character_Type'Val (1240), Character_Type'Val (1240)),
   (Character_Type'Val (1242), Character_Type'Val (1242)),
   (Character_Type'Val (1244), Character_Type'Val (1244)),
   (Character_Type'Val (1246), Character_Type'Val (1246)),
   (Character_Type'Val (1248), Character_Type'Val (1248)),
   (Character_Type'Val (1250), Character_Type'Val (1250)),
   (Character_Type'Val (1252), Character_Type'Val (1252)),
   (Character_Type'Val (1254), Character_Type'Val (1254)),
   (Character_Type'Val (1256), Character_Type'Val (1256)),
   (Character_Type'Val (1258), Character_Type'Val (1258)),
   (Character_Type'Val (1260), Character_Type'Val (1260)),
   (Character_Type'Val (1262), Character_Type'Val (1262)),
   (Character_Type'Val (1264), Character_Type'Val (1264)),
   (Character_Type'Val (1266), Character_Type'Val (1266)),
   (Character_Type'Val (1268), Character_Type'Val (1268)),
   (Character_Type'Val (1270), Character_Type'Val (1270)),
   (Character_Type'Val (1272), Character_Type'Val (1272)),
   (Character_Type'Val (1274), Character_Type'Val (1274)),
   (Character_Type'Val (1276), Character_Type'Val (1276)),
   (Character_Type'Val (1278), Character_Type'Val (1278)),
   (Character_Type'Val (1280), Character_Type'Val (1280)),
   (Character_Type'Val (1282), Character_Type'Val (1282)),
   (Character_Type'Val (1284), Character_Type'Val (1284)),
   (Character_Type'Val (1286), Character_Type'Val (1286)),
   (Character_Type'Val (1288), Character_Type'Val (1288)),
   (Character_Type'Val (1290), Character_Type'Val (1290)),
   (Character_Type'Val (1292), Character_Type'Val (1292)),
   (Character_Type'Val (1294), Character_Type'Val (1294)),
   (Character_Type'Val (1296), Character_Type'Val (1296)),
   (Character_Type'Val (1298), Character_Type'Val (1298)),
   (Character_Type'Val (1300), Character_Type'Val (1300)),
   (Character_Type'Val (1302), Character_Type'Val (1302)),
   (Character_Type'Val (1304), Character_Type'Val (1304)),
   (Character_Type'Val (1306), Character_Type'Val (1306)),
   (Character_Type'Val (1308), Character_Type'Val (1308)),
   (Character_Type'Val (1310), Character_Type'Val (1310)),
   (Character_Type'Val (1312), Character_Type'Val (1312)),
   (Character_Type'Val (1314), Character_Type'Val (1314)),
   (Character_Type'Val (1316), Character_Type'Val (1316)),
   (Character_Type'Val (1329), Character_Type'Val (1366)),
   (Character_Type'Val (4256), Character_Type'Val (4293)),
   (Character_Type'Val (7680), Character_Type'Val (7680)),
   (Character_Type'Val (7682), Character_Type'Val (7682)),
   (Character_Type'Val (7684), Character_Type'Val (7684)),
   (Character_Type'Val (7686), Character_Type'Val (7686)),
   (Character_Type'Val (7688), Character_Type'Val (7688)),
   (Character_Type'Val (7690), Character_Type'Val (7690)),
   (Character_Type'Val (7692), Character_Type'Val (7692)),
   (Character_Type'Val (7694), Character_Type'Val (7694)),
   (Character_Type'Val (7696), Character_Type'Val (7696)),
   (Character_Type'Val (7698), Character_Type'Val (7698)),
   (Character_Type'Val (7700), Character_Type'Val (7700)),
   (Character_Type'Val (7702), Character_Type'Val (7702)),
   (Character_Type'Val (7704), Character_Type'Val (7704)),
   (Character_Type'Val (7706), Character_Type'Val (7706)),
   (Character_Type'Val (7708), Character_Type'Val (7708)),
   (Character_Type'Val (7710), Character_Type'Val (7710)),
   (Character_Type'Val (7712), Character_Type'Val (7712)),
   (Character_Type'Val (7714), Character_Type'Val (7714)),
   (Character_Type'Val (7716), Character_Type'Val (7716)),
   (Character_Type'Val (7718), Character_Type'Val (7718)),
   (Character_Type'Val (7720), Character_Type'Val (7720)),
   (Character_Type'Val (7722), Character_Type'Val (7722)),
   (Character_Type'Val (7724), Character_Type'Val (7724)),
   (Character_Type'Val (7726), Character_Type'Val (7726)),
   (Character_Type'Val (7728), Character_Type'Val (7728)),
   (Character_Type'Val (7730), Character_Type'Val (7730)),
   (Character_Type'Val (7732), Character_Type'Val (7732)),
   (Character_Type'Val (7734), Character_Type'Val (7734)),
   (Character_Type'Val (7736), Character_Type'Val (7736)),
   (Character_Type'Val (7738), Character_Type'Val (7738)),
   (Character_Type'Val (7740), Character_Type'Val (7740)),
   (Character_Type'Val (7742), Character_Type'Val (7742)),
   (Character_Type'Val (7744), Character_Type'Val (7744)),
   (Character_Type'Val (7746), Character_Type'Val (7746)),
   (Character_Type'Val (7748), Character_Type'Val (7748)),
   (Character_Type'Val (7750), Character_Type'Val (7750)),
   (Character_Type'Val (7752), Character_Type'Val (7752)),
   (Character_Type'Val (7754), Character_Type'Val (7754)),
   (Character_Type'Val (7756), Character_Type'Val (7756)),
   (Character_Type'Val (7758), Character_Type'Val (7758)),
   (Character_Type'Val (7760), Character_Type'Val (7760)),
   (Character_Type'Val (7762), Character_Type'Val (7762)),
   (Character_Type'Val (7764), Character_Type'Val (7764)),
   (Character_Type'Val (7766), Character_Type'Val (7766)),
   (Character_Type'Val (7768), Character_Type'Val (7768)),
   (Character_Type'Val (7770), Character_Type'Val (7770)),
   (Character_Type'Val (7772), Character_Type'Val (7772)),
   (Character_Type'Val (7774), Character_Type'Val (7774)),
   (Character_Type'Val (7776), Character_Type'Val (7776)),
   (Character_Type'Val (7778), Character_Type'Val (7778)),
   (Character_Type'Val (7780), Character_Type'Val (7780)),
   (Character_Type'Val (7782), Character_Type'Val (7782)),
   (Character_Type'Val (7784), Character_Type'Val (7784)),
   (Character_Type'Val (7786), Character_Type'Val (7786)),
   (Character_Type'Val (7788), Character_Type'Val (7788)),
   (Character_Type'Val (7790), Character_Type'Val (7790)),
   (Character_Type'Val (7792), Character_Type'Val (7792)),
   (Character_Type'Val (7794), Character_Type'Val (7794)),
   (Character_Type'Val (7796), Character_Type'Val (7796)),
   (Character_Type'Val (7798), Character_Type'Val (7798)),
   (Character_Type'Val (7800), Character_Type'Val (7800)),
   (Character_Type'Val (7802), Character_Type'Val (7802)),
   (Character_Type'Val (7804), Character_Type'Val (7804)),
   (Character_Type'Val (7806), Character_Type'Val (7806)),
   (Character_Type'Val (7808), Character_Type'Val (7808)),
   (Character_Type'Val (7810), Character_Type'Val (7810)),
   (Character_Type'Val (7812), Character_Type'Val (7812)),
   (Character_Type'Val (7814), Character_Type'Val (7814)),
   (Character_Type'Val (7816), Character_Type'Val (7816)),
   (Character_Type'Val (7818), Character_Type'Val (7818)),
   (Character_Type'Val (7820), Character_Type'Val (7820)),
   (Character_Type'Val (7822), Character_Type'Val (7822)),
   (Character_Type'Val (7824), Character_Type'Val (7824)),
   (Character_Type'Val (7826), Character_Type'Val (7826)),
   (Character_Type'Val (7828), Character_Type'Val (7828)),
   (Character_Type'Val (7838), Character_Type'Val (7838)),
   (Character_Type'Val (7840), Character_Type'Val (7840)),
   (Character_Type'Val (7842), Character_Type'Val (7842)),
   (Character_Type'Val (7844), Character_Type'Val (7844)),
   (Character_Type'Val (7846), Character_Type'Val (7846)),
   (Character_Type'Val (7848), Character_Type'Val (7848)),
   (Character_Type'Val (7850), Character_Type'Val (7850)),
   (Character_Type'Val (7852), Character_Type'Val (7852)),
   (Character_Type'Val (7854), Character_Type'Val (7854)),
   (Character_Type'Val (7856), Character_Type'Val (7856)),
   (Character_Type'Val (7858), Character_Type'Val (7858)),
   (Character_Type'Val (7860), Character_Type'Val (7860)),
   (Character_Type'Val (7862), Character_Type'Val (7862)),
   (Character_Type'Val (7864), Character_Type'Val (7864)),
   (Character_Type'Val (7866), Character_Type'Val (7866)),
   (Character_Type'Val (7868), Character_Type'Val (7868)),
   (Character_Type'Val (7870), Character_Type'Val (7870)),
   (Character_Type'Val (7872), Character_Type'Val (7872)),
   (Character_Type'Val (7874), Character_Type'Val (7874)),
   (Character_Type'Val (7876), Character_Type'Val (7876)),
   (Character_Type'Val (7878), Character_Type'Val (7878)),
   (Character_Type'Val (7880), Character_Type'Val (7880)),
   (Character_Type'Val (7882), Character_Type'Val (7882)),
   (Character_Type'Val (7884), Character_Type'Val (7884)),
   (Character_Type'Val (7886), Character_Type'Val (7886)),
   (Character_Type'Val (7888), Character_Type'Val (7888)),
   (Character_Type'Val (7890), Character_Type'Val (7890)),
   (Character_Type'Val (7892), Character_Type'Val (7892)),
   (Character_Type'Val (7894), Character_Type'Val (7894)),
   (Character_Type'Val (7896), Character_Type'Val (7896)),
   (Character_Type'Val (7898), Character_Type'Val (7898)),
   (Character_Type'Val (7900), Character_Type'Val (7900)),
   (Character_Type'Val (7902), Character_Type'Val (7902)),
   (Character_Type'Val (7904), Character_Type'Val (7904)),
   (Character_Type'Val (7906), Character_Type'Val (7906)),
   (Character_Type'Val (7908), Character_Type'Val (7908)),
   (Character_Type'Val (7910), Character_Type'Val (7910)),
   (Character_Type'Val (7912), Character_Type'Val (7912)),
   (Character_Type'Val (7914), Character_Type'Val (7914)),
   (Character_Type'Val (7916), Character_Type'Val (7916)),
   (Character_Type'Val (7918), Character_Type'Val (7918)),
   (Character_Type'Val (7920), Character_Type'Val (7920)),
   (Character_Type'Val (7922), Character_Type'Val (7922)),
   (Character_Type'Val (7924), Character_Type'Val (7924)),
   (Character_Type'Val (7926), Character_Type'Val (7926)),
   (Character_Type'Val (7928), Character_Type'Val (7928)),
   (Character_Type'Val (7930), Character_Type'Val (7930)),
   (Character_Type'Val (7932), Character_Type'Val (7932)),
   (Character_Type'Val (7934), Character_Type'Val (7934)),
   (Character_Type'Val (7944), Character_Type'Val (7951)),
   (Character_Type'Val (7960), Character_Type'Val (7965)),
   (Character_Type'Val (7976), Character_Type'Val (7983)),
   (Character_Type'Val (7992), Character_Type'Val (7999)),
   (Character_Type'Val (8008), Character_Type'Val (8013)),
   (Character_Type'Val (8025), Character_Type'Val (8025)),
   (Character_Type'Val (8027), Character_Type'Val (8027)),
   (Character_Type'Val (8029), Character_Type'Val (8029)),
   (Character_Type'Val (8031), Character_Type'Val (8031)),
   (Character_Type'Val (8040), Character_Type'Val (8047)),
   (Character_Type'Val (8120), Character_Type'Val (8123)),
   (Character_Type'Val (8136), Character_Type'Val (8139)),
   (Character_Type'Val (8152), Character_Type'Val (8155)),
   (Character_Type'Val (8168), Character_Type'Val (8172)),
   (Character_Type'Val (8184), Character_Type'Val (8187)),
   (Character_Type'Val (8450), Character_Type'Val (8450)),
   (Character_Type'Val (8455), Character_Type'Val (8455)),
   (Character_Type'Val (8459), Character_Type'Val (8461)),
   (Character_Type'Val (8464), Character_Type'Val (8466)),
   (Character_Type'Val (8469), Character_Type'Val (8469)),
   (Character_Type'Val (8473), Character_Type'Val (8477)),
   (Character_Type'Val (8484), Character_Type'Val (8484)),
   (Character_Type'Val (8486), Character_Type'Val (8486)),
   (Character_Type'Val (8488), Character_Type'Val (8488)),
   (Character_Type'Val (8490), Character_Type'Val (8493)),
   (Character_Type'Val (8496), Character_Type'Val (8499)),
   (Character_Type'Val (8510), Character_Type'Val (8511)),
   (Character_Type'Val (8517), Character_Type'Val (8517)),
   (Character_Type'Val (8579), Character_Type'Val (8579)),
   (Character_Type'Val (11264), Character_Type'Val (11310)),
   (Character_Type'Val (11360), Character_Type'Val (11360)),
   (Character_Type'Val (11362), Character_Type'Val (11364)),
   (Character_Type'Val (11367), Character_Type'Val (11367)),
   (Character_Type'Val (11369), Character_Type'Val (11369)),
   (Character_Type'Val (11371), Character_Type'Val (11371)),
   (Character_Type'Val (11373), Character_Type'Val (11376)),
   (Character_Type'Val (11378), Character_Type'Val (11378)),
   (Character_Type'Val (11381), Character_Type'Val (11381)),
   (Character_Type'Val (11390), Character_Type'Val (11392)),
   (Character_Type'Val (11394), Character_Type'Val (11394)),
   (Character_Type'Val (11396), Character_Type'Val (11396)),
   (Character_Type'Val (11398), Character_Type'Val (11398)),
   (Character_Type'Val (11400), Character_Type'Val (11400)),
   (Character_Type'Val (11402), Character_Type'Val (11402)),
   (Character_Type'Val (11404), Character_Type'Val (11404)),
   (Character_Type'Val (11406), Character_Type'Val (11406)),
   (Character_Type'Val (11408), Character_Type'Val (11408)),
   (Character_Type'Val (11410), Character_Type'Val (11410)),
   (Character_Type'Val (11412), Character_Type'Val (11412)),
   (Character_Type'Val (11414), Character_Type'Val (11414)),
   (Character_Type'Val (11416), Character_Type'Val (11416)),
   (Character_Type'Val (11418), Character_Type'Val (11418)),
   (Character_Type'Val (11420), Character_Type'Val (11420)),
   (Character_Type'Val (11422), Character_Type'Val (11422)),
   (Character_Type'Val (11424), Character_Type'Val (11424)),
   (Character_Type'Val (11426), Character_Type'Val (11426)),
   (Character_Type'Val (11428), Character_Type'Val (11428)),
   (Character_Type'Val (11430), Character_Type'Val (11430)),
   (Character_Type'Val (11432), Character_Type'Val (11432)),
   (Character_Type'Val (11434), Character_Type'Val (11434)),
   (Character_Type'Val (11436), Character_Type'Val (11436)),
   (Character_Type'Val (11438), Character_Type'Val (11438)),
   (Character_Type'Val (11440), Character_Type'Val (11440)),
   (Character_Type'Val (11442), Character_Type'Val (11442)),
   (Character_Type'Val (11444), Character_Type'Val (11444)),
   (Character_Type'Val (11446), Character_Type'Val (11446)),
   (Character_Type'Val (11448), Character_Type'Val (11448)),
   (Character_Type'Val (11450), Character_Type'Val (11450)),
   (Character_Type'Val (11452), Character_Type'Val (11452)),
   (Character_Type'Val (11454), Character_Type'Val (11454)),
   (Character_Type'Val (11456), Character_Type'Val (11456)),
   (Character_Type'Val (11458), Character_Type'Val (11458)),
   (Character_Type'Val (11460), Character_Type'Val (11460)),
   (Character_Type'Val (11462), Character_Type'Val (11462)),
   (Character_Type'Val (11464), Character_Type'Val (11464)),
   (Character_Type'Val (11466), Character_Type'Val (11466)),
   (Character_Type'Val (11468), Character_Type'Val (11468)),
   (Character_Type'Val (11470), Character_Type'Val (11470)),
   (Character_Type'Val (11472), Character_Type'Val (11472)),
   (Character_Type'Val (11474), Character_Type'Val (11474)),
   (Character_Type'Val (11476), Character_Type'Val (11476)),
   (Character_Type'Val (11478), Character_Type'Val (11478)),
   (Character_Type'Val (11480), Character_Type'Val (11480)),
   (Character_Type'Val (11482), Character_Type'Val (11482)),
   (Character_Type'Val (11484), Character_Type'Val (11484)),
   (Character_Type'Val (11486), Character_Type'Val (11486)),
   (Character_Type'Val (11488), Character_Type'Val (11488)),
   (Character_Type'Val (11490), Character_Type'Val (11490)),
   (Character_Type'Val (11499), Character_Type'Val (11499)),
   (Character_Type'Val (11501), Character_Type'Val (11501)),
   (Character_Type'Val (42560), Character_Type'Val (42560)),
   (Character_Type'Val (42562), Character_Type'Val (42562)),
   (Character_Type'Val (42564), Character_Type'Val (42564)),
   (Character_Type'Val (42566), Character_Type'Val (42566)),
   (Character_Type'Val (42568), Character_Type'Val (42568)),
   (Character_Type'Val (42570), Character_Type'Val (42570)),
   (Character_Type'Val (42572), Character_Type'Val (42572)),
   (Character_Type'Val (42574), Character_Type'Val (42574)),
   (Character_Type'Val (42576), Character_Type'Val (42576)),
   (Character_Type'Val (42578), Character_Type'Val (42578)),
   (Character_Type'Val (42580), Character_Type'Val (42580)),
   (Character_Type'Val (42582), Character_Type'Val (42582)),
   (Character_Type'Val (42584), Character_Type'Val (42584)),
   (Character_Type'Val (42586), Character_Type'Val (42586)),
   (Character_Type'Val (42588), Character_Type'Val (42588)),
   (Character_Type'Val (42590), Character_Type'Val (42590)),
   (Character_Type'Val (42594), Character_Type'Val (42594)),
   (Character_Type'Val (42596), Character_Type'Val (42596)),
   (Character_Type'Val (42598), Character_Type'Val (42598)),
   (Character_Type'Val (42600), Character_Type'Val (42600)),
   (Character_Type'Val (42602), Character_Type'Val (42602)),
   (Character_Type'Val (42604), Character_Type'Val (42604)),
   (Character_Type'Val (42624), Character_Type'Val (42624)),
   (Character_Type'Val (42626), Character_Type'Val (42626)),
   (Character_Type'Val (42628), Character_Type'Val (42628)),
   (Character_Type'Val (42630), Character_Type'Val (42630)),
   (Character_Type'Val (42632), Character_Type'Val (42632)),
   (Character_Type'Val (42634), Character_Type'Val (42634)),
   (Character_Type'Val (42636), Character_Type'Val (42636)),
   (Character_Type'Val (42638), Character_Type'Val (42638)),
   (Character_Type'Val (42640), Character_Type'Val (42640)),
   (Character_Type'Val (42642), Character_Type'Val (42642)),
   (Character_Type'Val (42644), Character_Type'Val (42644)),
   (Character_Type'Val (42646), Character_Type'Val (42646)),
   (Character_Type'Val (42786), Character_Type'Val (42786)),
   (Character_Type'Val (42788), Character_Type'Val (42788)),
   (Character_Type'Val (42790), Character_Type'Val (42790)),
   (Character_Type'Val (42792), Character_Type'Val (42792)),
   (Character_Type'Val (42794), Character_Type'Val (42794)),
   (Character_Type'Val (42796), Character_Type'Val (42796)),
   (Character_Type'Val (42798), Character_Type'Val (42798)),
   (Character_Type'Val (42802), Character_Type'Val (42802)),
   (Character_Type'Val (42804), Character_Type'Val (42804)),
   (Character_Type'Val (42806), Character_Type'Val (42806)),
   (Character_Type'Val (42808), Character_Type'Val (42808)),
   (Character_Type'Val (42810), Character_Type'Val (42810)),
   (Character_Type'Val (42812), Character_Type'Val (42812)),
   (Character_Type'Val (42814), Character_Type'Val (42814)),
   (Character_Type'Val (42816), Character_Type'Val (42816)),
   (Character_Type'Val (42818), Character_Type'Val (42818)),
   (Character_Type'Val (42820), Character_Type'Val (42820)),
   (Character_Type'Val (42822), Character_Type'Val (42822)),
   (Character_Type'Val (42824), Character_Type'Val (42824)),
   (Character_Type'Val (42826), Character_Type'Val (42826)),
   (Character_Type'Val (42828), Character_Type'Val (42828)),
   (Character_Type'Val (42830), Character_Type'Val (42830)),
   (Character_Type'Val (42832), Character_Type'Val (42832)),
   (Character_Type'Val (42834), Character_Type'Val (42834)),
   (Character_Type'Val (42836), Character_Type'Val (42836)),
   (Character_Type'Val (42838), Character_Type'Val (42838)),
   (Character_Type'Val (42840), Character_Type'Val (42840)),
   (Character_Type'Val (42842), Character_Type'Val (42842)),
   (Character_Type'Val (42844), Character_Type'Val (42844)),
   (Character_Type'Val (42846), Character_Type'Val (42846)),
   (Character_Type'Val (42848), Character_Type'Val (42848)),
   (Character_Type'Val (42850), Character_Type'Val (42850)),
   (Character_Type'Val (42852), Character_Type'Val (42852)),
   (Character_Type'Val (42854), Character_Type'Val (42854)),
   (Character_Type'Val (42856), Character_Type'Val (42856)),
   (Character_Type'Val (42858), Character_Type'Val (42858)),
   (Character_Type'Val (42860), Character_Type'Val (42860)),
   (Character_Type'Val (42862), Character_Type'Val (42862)),
   (Character_Type'Val (42873), Character_Type'Val (42873)),
   (Character_Type'Val (42875), Character_Type'Val (42875)),
   (Character_Type'Val (42877), Character_Type'Val (42878)),
   (Character_Type'Val (42880), Character_Type'Val (42880)),
   (Character_Type'Val (42882), Character_Type'Val (42882)),
   (Character_Type'Val (42884), Character_Type'Val (42884)),
   (Character_Type'Val (42886), Character_Type'Val (42886)),
   (Character_Type'Val (42891), Character_Type'Val (42891)),
   (Character_Type'Val (65313), Character_Type'Val (65338)),
   (Character_Type'Val (66560), Character_Type'Val (66599)),
   (Character_Type'Val (119808), Character_Type'Val (119833)),
   (Character_Type'Val (119860), Character_Type'Val (119885)),
   (Character_Type'Val (119912), Character_Type'Val (119937)),
   (Character_Type'Val (119964), Character_Type'Val (119964)),
   (Character_Type'Val (119966), Character_Type'Val (119967)),
   (Character_Type'Val (119970), Character_Type'Val (119970)),
   (Character_Type'Val (119973), Character_Type'Val (119974)),
   (Character_Type'Val (119977), Character_Type'Val (119980)),
   (Character_Type'Val (119982), Character_Type'Val (119989)),
   (Character_Type'Val (120016), Character_Type'Val (120041)),
   (Character_Type'Val (120068), Character_Type'Val (120069)),
   (Character_Type'Val (120071), Character_Type'Val (120074)),
   (Character_Type'Val (120077), Character_Type'Val (120084)),
   (Character_Type'Val (120086), Character_Type'Val (120092)),
   (Character_Type'Val (120120), Character_Type'Val (120121)),
   (Character_Type'Val (120123), Character_Type'Val (120126)),
   (Character_Type'Val (120128), Character_Type'Val (120132)),
   (Character_Type'Val (120134), Character_Type'Val (120134)),
   (Character_Type'Val (120138), Character_Type'Val (120144)),
   (Character_Type'Val (120172), Character_Type'Val (120197)),
   (Character_Type'Val (120224), Character_Type'Val (120249)),
   (Character_Type'Val (120276), Character_Type'Val (120301)),
   (Character_Type'Val (120328), Character_Type'Val (120353)),
   (Character_Type'Val (120380), Character_Type'Val (120405)),
   (Character_Type'Val (120432), Character_Type'Val (120457)),
   (Character_Type'Val (120488), Character_Type'Val (120512)),
   (Character_Type'Val (120546), Character_Type'Val (120570)),
   (Character_Type'Val (120604), Character_Type'Val (120628)),
   (Character_Type'Val (120662), Character_Type'Val (120686)),
   (Character_Type'Val (120720), Character_Type'Val (120744)),
   (Character_Type'Val (120778), Character_Type'Val (120778))
   );
   Ranges_1 : constant Character_Range_Array := (
   (Character_Type'Val (170), Character_Type'Val (170)),
   (Character_Type'Val (181), Character_Type'Val (181)),
   (Character_Type'Val (186), Character_Type'Val (186)),
   (Character_Type'Val (223), Character_Type'Val (246)),
   (Character_Type'Val (248), Character_Type'Val (255)),
   (Character_Type'Val (257), Character_Type'Val (257)),
   (Character_Type'Val (259), Character_Type'Val (259)),
   (Character_Type'Val (261), Character_Type'Val (261)),
   (Character_Type'Val (263), Character_Type'Val (263)),
   (Character_Type'Val (265), Character_Type'Val (265)),
   (Character_Type'Val (267), Character_Type'Val (267)),
   (Character_Type'Val (269), Character_Type'Val (269)),
   (Character_Type'Val (271), Character_Type'Val (271)),
   (Character_Type'Val (273), Character_Type'Val (273)),
   (Character_Type'Val (275), Character_Type'Val (275)),
   (Character_Type'Val (277), Character_Type'Val (277)),
   (Character_Type'Val (279), Character_Type'Val (279)),
   (Character_Type'Val (281), Character_Type'Val (281)),
   (Character_Type'Val (283), Character_Type'Val (283)),
   (Character_Type'Val (285), Character_Type'Val (285)),
   (Character_Type'Val (287), Character_Type'Val (287)),
   (Character_Type'Val (289), Character_Type'Val (289)),
   (Character_Type'Val (291), Character_Type'Val (291)),
   (Character_Type'Val (293), Character_Type'Val (293)),
   (Character_Type'Val (295), Character_Type'Val (295)),
   (Character_Type'Val (297), Character_Type'Val (297)),
   (Character_Type'Val (299), Character_Type'Val (299)),
   (Character_Type'Val (301), Character_Type'Val (301)),
   (Character_Type'Val (303), Character_Type'Val (303)),
   (Character_Type'Val (305), Character_Type'Val (305)),
   (Character_Type'Val (307), Character_Type'Val (307)),
   (Character_Type'Val (309), Character_Type'Val (309)),
   (Character_Type'Val (311), Character_Type'Val (312)),
   (Character_Type'Val (314), Character_Type'Val (314)),
   (Character_Type'Val (316), Character_Type'Val (316)),
   (Character_Type'Val (318), Character_Type'Val (318)),
   (Character_Type'Val (320), Character_Type'Val (320)),
   (Character_Type'Val (322), Character_Type'Val (322)),
   (Character_Type'Val (324), Character_Type'Val (324)),
   (Character_Type'Val (326), Character_Type'Val (326)),
   (Character_Type'Val (328), Character_Type'Val (329)),
   (Character_Type'Val (331), Character_Type'Val (331)),
   (Character_Type'Val (333), Character_Type'Val (333)),
   (Character_Type'Val (335), Character_Type'Val (335)),
   (Character_Type'Val (337), Character_Type'Val (337)),
   (Character_Type'Val (339), Character_Type'Val (339)),
   (Character_Type'Val (341), Character_Type'Val (341)),
   (Character_Type'Val (343), Character_Type'Val (343)),
   (Character_Type'Val (345), Character_Type'Val (345)),
   (Character_Type'Val (347), Character_Type'Val (347)),
   (Character_Type'Val (349), Character_Type'Val (349)),
   (Character_Type'Val (351), Character_Type'Val (351)),
   (Character_Type'Val (353), Character_Type'Val (353)),
   (Character_Type'Val (355), Character_Type'Val (355)),
   (Character_Type'Val (357), Character_Type'Val (357)),
   (Character_Type'Val (359), Character_Type'Val (359)),
   (Character_Type'Val (361), Character_Type'Val (361)),
   (Character_Type'Val (363), Character_Type'Val (363)),
   (Character_Type'Val (365), Character_Type'Val (365)),
   (Character_Type'Val (367), Character_Type'Val (367)),
   (Character_Type'Val (369), Character_Type'Val (369)),
   (Character_Type'Val (371), Character_Type'Val (371)),
   (Character_Type'Val (373), Character_Type'Val (373)),
   (Character_Type'Val (375), Character_Type'Val (375)),
   (Character_Type'Val (378), Character_Type'Val (378)),
   (Character_Type'Val (380), Character_Type'Val (380)),
   (Character_Type'Val (382), Character_Type'Val (384)),
   (Character_Type'Val (387), Character_Type'Val (387)),
   (Character_Type'Val (389), Character_Type'Val (389)),
   (Character_Type'Val (392), Character_Type'Val (392)),
   (Character_Type'Val (396), Character_Type'Val (397)),
   (Character_Type'Val (402), Character_Type'Val (402)),
   (Character_Type'Val (405), Character_Type'Val (405)),
   (Character_Type'Val (409), Character_Type'Val (411)),
   (Character_Type'Val (414), Character_Type'Val (414)),
   (Character_Type'Val (417), Character_Type'Val (417)),
   (Character_Type'Val (419), Character_Type'Val (419)),
   (Character_Type'Val (421), Character_Type'Val (421)),
   (Character_Type'Val (424), Character_Type'Val (424)),
   (Character_Type'Val (426), Character_Type'Val (427)),
   (Character_Type'Val (429), Character_Type'Val (429)),
   (Character_Type'Val (432), Character_Type'Val (432)),
   (Character_Type'Val (436), Character_Type'Val (436)),
   (Character_Type'Val (438), Character_Type'Val (438)),
   (Character_Type'Val (441), Character_Type'Val (442)),
   (Character_Type'Val (445), Character_Type'Val (447)),
   (Character_Type'Val (454), Character_Type'Val (454)),
   (Character_Type'Val (457), Character_Type'Val (457)),
   (Character_Type'Val (460), Character_Type'Val (460)),
   (Character_Type'Val (462), Character_Type'Val (462)),
   (Character_Type'Val (464), Character_Type'Val (464)),
   (Character_Type'Val (466), Character_Type'Val (466)),
   (Character_Type'Val (468), Character_Type'Val (468)),
   (Character_Type'Val (470), Character_Type'Val (470)),
   (Character_Type'Val (472), Character_Type'Val (472)),
   (Character_Type'Val (474), Character_Type'Val (474)),
   (Character_Type'Val (476), Character_Type'Val (477)),
   (Character_Type'Val (479), Character_Type'Val (479)),
   (Character_Type'Val (481), Character_Type'Val (481)),
   (Character_Type'Val (483), Character_Type'Val (483)),
   (Character_Type'Val (485), Character_Type'Val (485)),
   (Character_Type'Val (487), Character_Type'Val (487)),
   (Character_Type'Val (489), Character_Type'Val (489)),
   (Character_Type'Val (491), Character_Type'Val (491)),
   (Character_Type'Val (493), Character_Type'Val (493)),
   (Character_Type'Val (495), Character_Type'Val (496)),
   (Character_Type'Val (499), Character_Type'Val (499)),
   (Character_Type'Val (501), Character_Type'Val (501)),
   (Character_Type'Val (505), Character_Type'Val (505)),
   (Character_Type'Val (507), Character_Type'Val (507)),
   (Character_Type'Val (509), Character_Type'Val (509)),
   (Character_Type'Val (511), Character_Type'Val (511)),
   (Character_Type'Val (513), Character_Type'Val (513)),
   (Character_Type'Val (515), Character_Type'Val (515)),
   (Character_Type'Val (517), Character_Type'Val (517)),
   (Character_Type'Val (519), Character_Type'Val (519)),
   (Character_Type'Val (521), Character_Type'Val (521)),
   (Character_Type'Val (523), Character_Type'Val (523)),
   (Character_Type'Val (525), Character_Type'Val (525)),
   (Character_Type'Val (527), Character_Type'Val (527)),
   (Character_Type'Val (529), Character_Type'Val (529)),
   (Character_Type'Val (531), Character_Type'Val (531)),
   (Character_Type'Val (533), Character_Type'Val (533)),
   (Character_Type'Val (535), Character_Type'Val (535)),
   (Character_Type'Val (537), Character_Type'Val (537)),
   (Character_Type'Val (539), Character_Type'Val (539)),
   (Character_Type'Val (541), Character_Type'Val (541)),
   (Character_Type'Val (543), Character_Type'Val (543)),
   (Character_Type'Val (545), Character_Type'Val (545)),
   (Character_Type'Val (547), Character_Type'Val (547)),
   (Character_Type'Val (549), Character_Type'Val (549)),
   (Character_Type'Val (551), Character_Type'Val (551)),
   (Character_Type'Val (553), Character_Type'Val (553)),
   (Character_Type'Val (555), Character_Type'Val (555)),
   (Character_Type'Val (557), Character_Type'Val (557)),
   (Character_Type'Val (559), Character_Type'Val (559)),
   (Character_Type'Val (561), Character_Type'Val (561)),
   (Character_Type'Val (563), Character_Type'Val (569)),
   (Character_Type'Val (572), Character_Type'Val (572)),
   (Character_Type'Val (575), Character_Type'Val (576)),
   (Character_Type'Val (578), Character_Type'Val (578)),
   (Character_Type'Val (583), Character_Type'Val (583)),
   (Character_Type'Val (585), Character_Type'Val (585)),
   (Character_Type'Val (587), Character_Type'Val (587)),
   (Character_Type'Val (589), Character_Type'Val (589)),
   (Character_Type'Val (591), Character_Type'Val (659)),
   (Character_Type'Val (661), Character_Type'Val (687)),
   (Character_Type'Val (881), Character_Type'Val (881)),
   (Character_Type'Val (883), Character_Type'Val (883)),
   (Character_Type'Val (887), Character_Type'Val (887)),
   (Character_Type'Val (891), Character_Type'Val (893)),
   (Character_Type'Val (912), Character_Type'Val (912)),
   (Character_Type'Val (940), Character_Type'Val (974)),
   (Character_Type'Val (976), Character_Type'Val (977)),
   (Character_Type'Val (981), Character_Type'Val (983)),
   (Character_Type'Val (985), Character_Type'Val (985)),
   (Character_Type'Val (987), Character_Type'Val (987)),
   (Character_Type'Val (989), Character_Type'Val (989)),
   (Character_Type'Val (991), Character_Type'Val (991)),
   (Character_Type'Val (993), Character_Type'Val (993)),
   (Character_Type'Val (995), Character_Type'Val (995)),
   (Character_Type'Val (997), Character_Type'Val (997)),
   (Character_Type'Val (999), Character_Type'Val (999)),
   (Character_Type'Val (1001), Character_Type'Val (1001)),
   (Character_Type'Val (1003), Character_Type'Val (1003)),
   (Character_Type'Val (1005), Character_Type'Val (1005)),
   (Character_Type'Val (1007), Character_Type'Val (1011)),
   (Character_Type'Val (1013), Character_Type'Val (1013)),
   (Character_Type'Val (1016), Character_Type'Val (1016)),
   (Character_Type'Val (1019), Character_Type'Val (1020)),
   (Character_Type'Val (1072), Character_Type'Val (1119)),
   (Character_Type'Val (1121), Character_Type'Val (1121)),
   (Character_Type'Val (1123), Character_Type'Val (1123)),
   (Character_Type'Val (1125), Character_Type'Val (1125)),
   (Character_Type'Val (1127), Character_Type'Val (1127)),
   (Character_Type'Val (1129), Character_Type'Val (1129)),
   (Character_Type'Val (1131), Character_Type'Val (1131)),
   (Character_Type'Val (1133), Character_Type'Val (1133)),
   (Character_Type'Val (1135), Character_Type'Val (1135)),
   (Character_Type'Val (1137), Character_Type'Val (1137)),
   (Character_Type'Val (1139), Character_Type'Val (1139)),
   (Character_Type'Val (1141), Character_Type'Val (1141)),
   (Character_Type'Val (1143), Character_Type'Val (1143)),
   (Character_Type'Val (1145), Character_Type'Val (1145)),
   (Character_Type'Val (1147), Character_Type'Val (1147)),
   (Character_Type'Val (1149), Character_Type'Val (1149)),
   (Character_Type'Val (1151), Character_Type'Val (1151)),
   (Character_Type'Val (1153), Character_Type'Val (1153)),
   (Character_Type'Val (1163), Character_Type'Val (1163)),
   (Character_Type'Val (1165), Character_Type'Val (1165)),
   (Character_Type'Val (1167), Character_Type'Val (1167)),
   (Character_Type'Val (1169), Character_Type'Val (1169)),
   (Character_Type'Val (1171), Character_Type'Val (1171)),
   (Character_Type'Val (1173), Character_Type'Val (1173)),
   (Character_Type'Val (1175), Character_Type'Val (1175)),
   (Character_Type'Val (1177), Character_Type'Val (1177)),
   (Character_Type'Val (1179), Character_Type'Val (1179)),
   (Character_Type'Val (1181), Character_Type'Val (1181)),
   (Character_Type'Val (1183), Character_Type'Val (1183)),
   (Character_Type'Val (1185), Character_Type'Val (1185)),
   (Character_Type'Val (1187), Character_Type'Val (1187)),
   (Character_Type'Val (1189), Character_Type'Val (1189)),
   (Character_Type'Val (1191), Character_Type'Val (1191)),
   (Character_Type'Val (1193), Character_Type'Val (1193)),
   (Character_Type'Val (1195), Character_Type'Val (1195)),
   (Character_Type'Val (1197), Character_Type'Val (1197)),
   (Character_Type'Val (1199), Character_Type'Val (1199)),
   (Character_Type'Val (1201), Character_Type'Val (1201)),
   (Character_Type'Val (1203), Character_Type'Val (1203)),
   (Character_Type'Val (1205), Character_Type'Val (1205)),
   (Character_Type'Val (1207), Character_Type'Val (1207)),
   (Character_Type'Val (1209), Character_Type'Val (1209)),
   (Character_Type'Val (1211), Character_Type'Val (1211)),
   (Character_Type'Val (1213), Character_Type'Val (1213)),
   (Character_Type'Val (1215), Character_Type'Val (1215)),
   (Character_Type'Val (1218), Character_Type'Val (1218)),
   (Character_Type'Val (1220), Character_Type'Val (1220)),
   (Character_Type'Val (1222), Character_Type'Val (1222)),
   (Character_Type'Val (1224), Character_Type'Val (1224)),
   (Character_Type'Val (1226), Character_Type'Val (1226)),
   (Character_Type'Val (1228), Character_Type'Val (1228)),
   (Character_Type'Val (1230), Character_Type'Val (1231)),
   (Character_Type'Val (1233), Character_Type'Val (1233)),
   (Character_Type'Val (1235), Character_Type'Val (1235)),
   (Character_Type'Val (1237), Character_Type'Val (1237)),
   (Character_Type'Val (1239), Character_Type'Val (1239)),
   (Character_Type'Val (1241), Character_Type'Val (1241)),
   (Character_Type'Val (1243), Character_Type'Val (1243)),
   (Character_Type'Val (1245), Character_Type'Val (1245)),
   (Character_Type'Val (1247), Character_Type'Val (1247)),
   (Character_Type'Val (1249), Character_Type'Val (1249)),
   (Character_Type'Val (1251), Character_Type'Val (1251)),
   (Character_Type'Val (1253), Character_Type'Val (1253)),
   (Character_Type'Val (1255), Character_Type'Val (1255)),
   (Character_Type'Val (1257), Character_Type'Val (1257)),
   (Character_Type'Val (1259), Character_Type'Val (1259)),
   (Character_Type'Val (1261), Character_Type'Val (1261)),
   (Character_Type'Val (1263), Character_Type'Val (1263)),
   (Character_Type'Val (1265), Character_Type'Val (1265)),
   (Character_Type'Val (1267), Character_Type'Val (1267)),
   (Character_Type'Val (1269), Character_Type'Val (1269)),
   (Character_Type'Val (1271), Character_Type'Val (1271)),
   (Character_Type'Val (1273), Character_Type'Val (1273)),
   (Character_Type'Val (1275), Character_Type'Val (1275)),
   (Character_Type'Val (1277), Character_Type'Val (1277)),
   (Character_Type'Val (1279), Character_Type'Val (1279)),
   (Character_Type'Val (1281), Character_Type'Val (1281)),
   (Character_Type'Val (1283), Character_Type'Val (1283)),
   (Character_Type'Val (1285), Character_Type'Val (1285)),
   (Character_Type'Val (1287), Character_Type'Val (1287)),
   (Character_Type'Val (1289), Character_Type'Val (1289)),
   (Character_Type'Val (1291), Character_Type'Val (1291)),
   (Character_Type'Val (1293), Character_Type'Val (1293)),
   (Character_Type'Val (1295), Character_Type'Val (1295)),
   (Character_Type'Val (1297), Character_Type'Val (1297)),
   (Character_Type'Val (1299), Character_Type'Val (1299)),
   (Character_Type'Val (1301), Character_Type'Val (1301)),
   (Character_Type'Val (1303), Character_Type'Val (1303)),
   (Character_Type'Val (1305), Character_Type'Val (1305)),
   (Character_Type'Val (1307), Character_Type'Val (1307)),
   (Character_Type'Val (1309), Character_Type'Val (1309)),
   (Character_Type'Val (1311), Character_Type'Val (1311)),
   (Character_Type'Val (1313), Character_Type'Val (1313)),
   (Character_Type'Val (1315), Character_Type'Val (1315)),
   (Character_Type'Val (1317), Character_Type'Val (1317)),
   (Character_Type'Val (1377), Character_Type'Val (1415)),
   (Character_Type'Val (7424), Character_Type'Val (7467)),
   (Character_Type'Val (7522), Character_Type'Val (7543)),
   (Character_Type'Val (7545), Character_Type'Val (7578)),
   (Character_Type'Val (7681), Character_Type'Val (7681)),
   (Character_Type'Val (7683), Character_Type'Val (7683)),
   (Character_Type'Val (7685), Character_Type'Val (7685)),
   (Character_Type'Val (7687), Character_Type'Val (7687)),
   (Character_Type'Val (7689), Character_Type'Val (7689)),
   (Character_Type'Val (7691), Character_Type'Val (7691)),
   (Character_Type'Val (7693), Character_Type'Val (7693)),
   (Character_Type'Val (7695), Character_Type'Val (7695)),
   (Character_Type'Val (7697), Character_Type'Val (7697)),
   (Character_Type'Val (7699), Character_Type'Val (7699)),
   (Character_Type'Val (7701), Character_Type'Val (7701)),
   (Character_Type'Val (7703), Character_Type'Val (7703)),
   (Character_Type'Val (7705), Character_Type'Val (7705)),
   (Character_Type'Val (7707), Character_Type'Val (7707)),
   (Character_Type'Val (7709), Character_Type'Val (7709)),
   (Character_Type'Val (7711), Character_Type'Val (7711)),
   (Character_Type'Val (7713), Character_Type'Val (7713)),
   (Character_Type'Val (7715), Character_Type'Val (7715)),
   (Character_Type'Val (7717), Character_Type'Val (7717)),
   (Character_Type'Val (7719), Character_Type'Val (7719)),
   (Character_Type'Val (7721), Character_Type'Val (7721)),
   (Character_Type'Val (7723), Character_Type'Val (7723)),
   (Character_Type'Val (7725), Character_Type'Val (7725)),
   (Character_Type'Val (7727), Character_Type'Val (7727)),
   (Character_Type'Val (7729), Character_Type'Val (7729)),
   (Character_Type'Val (7731), Character_Type'Val (7731)),
   (Character_Type'Val (7733), Character_Type'Val (7733)),
   (Character_Type'Val (7735), Character_Type'Val (7735)),
   (Character_Type'Val (7737), Character_Type'Val (7737)),
   (Character_Type'Val (7739), Character_Type'Val (7739)),
   (Character_Type'Val (7741), Character_Type'Val (7741)),
   (Character_Type'Val (7743), Character_Type'Val (7743)),
   (Character_Type'Val (7745), Character_Type'Val (7745)),
   (Character_Type'Val (7747), Character_Type'Val (7747)),
   (Character_Type'Val (7749), Character_Type'Val (7749)),
   (Character_Type'Val (7751), Character_Type'Val (7751)),
   (Character_Type'Val (7753), Character_Type'Val (7753)),
   (Character_Type'Val (7755), Character_Type'Val (7755)),
   (Character_Type'Val (7757), Character_Type'Val (7757)),
   (Character_Type'Val (7759), Character_Type'Val (7759)),
   (Character_Type'Val (7761), Character_Type'Val (7761)),
   (Character_Type'Val (7763), Character_Type'Val (7763)),
   (Character_Type'Val (7765), Character_Type'Val (7765)),
   (Character_Type'Val (7767), Character_Type'Val (7767)),
   (Character_Type'Val (7769), Character_Type'Val (7769)),
   (Character_Type'Val (7771), Character_Type'Val (7771)),
   (Character_Type'Val (7773), Character_Type'Val (7773)),
   (Character_Type'Val (7775), Character_Type'Val (7775)),
   (Character_Type'Val (7777), Character_Type'Val (7777)),
   (Character_Type'Val (7779), Character_Type'Val (7779)),
   (Character_Type'Val (7781), Character_Type'Val (7781)),
   (Character_Type'Val (7783), Character_Type'Val (7783)),
   (Character_Type'Val (7785), Character_Type'Val (7785)),
   (Character_Type'Val (7787), Character_Type'Val (7787)),
   (Character_Type'Val (7789), Character_Type'Val (7789)),
   (Character_Type'Val (7791), Character_Type'Val (7791)),
   (Character_Type'Val (7793), Character_Type'Val (7793)),
   (Character_Type'Val (7795), Character_Type'Val (7795)),
   (Character_Type'Val (7797), Character_Type'Val (7797)),
   (Character_Type'Val (7799), Character_Type'Val (7799)),
   (Character_Type'Val (7801), Character_Type'Val (7801)),
   (Character_Type'Val (7803), Character_Type'Val (7803)),
   (Character_Type'Val (7805), Character_Type'Val (7805)),
   (Character_Type'Val (7807), Character_Type'Val (7807)),
   (Character_Type'Val (7809), Character_Type'Val (7809)),
   (Character_Type'Val (7811), Character_Type'Val (7811)),
   (Character_Type'Val (7813), Character_Type'Val (7813)),
   (Character_Type'Val (7815), Character_Type'Val (7815)),
   (Character_Type'Val (7817), Character_Type'Val (7817)),
   (Character_Type'Val (7819), Character_Type'Val (7819)),
   (Character_Type'Val (7821), Character_Type'Val (7821)),
   (Character_Type'Val (7823), Character_Type'Val (7823)),
   (Character_Type'Val (7825), Character_Type'Val (7825)),
   (Character_Type'Val (7827), Character_Type'Val (7827)),
   (Character_Type'Val (7829), Character_Type'Val (7837)),
   (Character_Type'Val (7839), Character_Type'Val (7839)),
   (Character_Type'Val (7841), Character_Type'Val (7841)),
   (Character_Type'Val (7843), Character_Type'Val (7843)),
   (Character_Type'Val (7845), Character_Type'Val (7845)),
   (Character_Type'Val (7847), Character_Type'Val (7847)),
   (Character_Type'Val (7849), Character_Type'Val (7849)),
   (Character_Type'Val (7851), Character_Type'Val (7851)),
   (Character_Type'Val (7853), Character_Type'Val (7853)),
   (Character_Type'Val (7855), Character_Type'Val (7855)),
   (Character_Type'Val (7857), Character_Type'Val (7857)),
   (Character_Type'Val (7859), Character_Type'Val (7859)),
   (Character_Type'Val (7861), Character_Type'Val (7861)),
   (Character_Type'Val (7863), Character_Type'Val (7863)),
   (Character_Type'Val (7865), Character_Type'Val (7865)),
   (Character_Type'Val (7867), Character_Type'Val (7867)),
   (Character_Type'Val (7869), Character_Type'Val (7869)),
   (Character_Type'Val (7871), Character_Type'Val (7871)),
   (Character_Type'Val (7873), Character_Type'Val (7873)),
   (Character_Type'Val (7875), Character_Type'Val (7875)),
   (Character_Type'Val (7877), Character_Type'Val (7877)),
   (Character_Type'Val (7879), Character_Type'Val (7879)),
   (Character_Type'Val (7881), Character_Type'Val (7881)),
   (Character_Type'Val (7883), Character_Type'Val (7883)),
   (Character_Type'Val (7885), Character_Type'Val (7885)),
   (Character_Type'Val (7887), Character_Type'Val (7887)),
   (Character_Type'Val (7889), Character_Type'Val (7889)),
   (Character_Type'Val (7891), Character_Type'Val (7891)),
   (Character_Type'Val (7893), Character_Type'Val (7893)),
   (Character_Type'Val (7895), Character_Type'Val (7895)),
   (Character_Type'Val (7897), Character_Type'Val (7897)),
   (Character_Type'Val (7899), Character_Type'Val (7899)),
   (Character_Type'Val (7901), Character_Type'Val (7901)),
   (Character_Type'Val (7903), Character_Type'Val (7903)),
   (Character_Type'Val (7905), Character_Type'Val (7905)),
   (Character_Type'Val (7907), Character_Type'Val (7907)),
   (Character_Type'Val (7909), Character_Type'Val (7909)),
   (Character_Type'Val (7911), Character_Type'Val (7911)),
   (Character_Type'Val (7913), Character_Type'Val (7913)),
   (Character_Type'Val (7915), Character_Type'Val (7915)),
   (Character_Type'Val (7917), Character_Type'Val (7917)),
   (Character_Type'Val (7919), Character_Type'Val (7919)),
   (Character_Type'Val (7921), Character_Type'Val (7921)),
   (Character_Type'Val (7923), Character_Type'Val (7923)),
   (Character_Type'Val (7925), Character_Type'Val (7925)),
   (Character_Type'Val (7927), Character_Type'Val (7927)),
   (Character_Type'Val (7929), Character_Type'Val (7929)),
   (Character_Type'Val (7931), Character_Type'Val (7931)),
   (Character_Type'Val (7933), Character_Type'Val (7933)),
   (Character_Type'Val (7935), Character_Type'Val (7943)),
   (Character_Type'Val (7952), Character_Type'Val (7957)),
   (Character_Type'Val (7968), Character_Type'Val (7975)),
   (Character_Type'Val (7984), Character_Type'Val (7991)),
   (Character_Type'Val (8000), Character_Type'Val (8005)),
   (Character_Type'Val (8016), Character_Type'Val (8023)),
   (Character_Type'Val (8032), Character_Type'Val (8039)),
   (Character_Type'Val (8048), Character_Type'Val (8061)),
   (Character_Type'Val (8064), Character_Type'Val (8071)),
   (Character_Type'Val (8080), Character_Type'Val (8087)),
   (Character_Type'Val (8096), Character_Type'Val (8103)),
   (Character_Type'Val (8112), Character_Type'Val (8116)),
   (Character_Type'Val (8118), Character_Type'Val (8119)),
   (Character_Type'Val (8126), Character_Type'Val (8126)),
   (Character_Type'Val (8130), Character_Type'Val (8132)),
   (Character_Type'Val (8134), Character_Type'Val (8135)),
   (Character_Type'Val (8144), Character_Type'Val (8147)),
   (Character_Type'Val (8150), Character_Type'Val (8151)),
   (Character_Type'Val (8160), Character_Type'Val (8167)),
   (Character_Type'Val (8178), Character_Type'Val (8180)),
   (Character_Type'Val (8182), Character_Type'Val (8183)),
   (Character_Type'Val (8458), Character_Type'Val (8458)),
   (Character_Type'Val (8462), Character_Type'Val (8463)),
   (Character_Type'Val (8467), Character_Type'Val (8467)),
   (Character_Type'Val (8495), Character_Type'Val (8495)),
   (Character_Type'Val (8500), Character_Type'Val (8500)),
   (Character_Type'Val (8505), Character_Type'Val (8505)),
   (Character_Type'Val (8508), Character_Type'Val (8509)),
   (Character_Type'Val (8518), Character_Type'Val (8521)),
   (Character_Type'Val (8526), Character_Type'Val (8526)),
   (Character_Type'Val (8580), Character_Type'Val (8580)),
   (Character_Type'Val (11312), Character_Type'Val (11358)),
   (Character_Type'Val (11361), Character_Type'Val (11361)),
   (Character_Type'Val (11365), Character_Type'Val (11366)),
   (Character_Type'Val (11368), Character_Type'Val (11368)),
   (Character_Type'Val (11370), Character_Type'Val (11370)),
   (Character_Type'Val (11372), Character_Type'Val (11372)),
   (Character_Type'Val (11377), Character_Type'Val (11377)),
   (Character_Type'Val (11379), Character_Type'Val (11380)),
   (Character_Type'Val (11382), Character_Type'Val (11388)),
   (Character_Type'Val (11393), Character_Type'Val (11393)),
   (Character_Type'Val (11395), Character_Type'Val (11395)),
   (Character_Type'Val (11397), Character_Type'Val (11397)),
   (Character_Type'Val (11399), Character_Type'Val (11399)),
   (Character_Type'Val (11401), Character_Type'Val (11401)),
   (Character_Type'Val (11403), Character_Type'Val (11403)),
   (Character_Type'Val (11405), Character_Type'Val (11405)),
   (Character_Type'Val (11407), Character_Type'Val (11407)),
   (Character_Type'Val (11409), Character_Type'Val (11409)),
   (Character_Type'Val (11411), Character_Type'Val (11411)),
   (Character_Type'Val (11413), Character_Type'Val (11413)),
   (Character_Type'Val (11415), Character_Type'Val (11415)),
   (Character_Type'Val (11417), Character_Type'Val (11417)),
   (Character_Type'Val (11419), Character_Type'Val (11419)),
   (Character_Type'Val (11421), Character_Type'Val (11421)),
   (Character_Type'Val (11423), Character_Type'Val (11423)),
   (Character_Type'Val (11425), Character_Type'Val (11425)),
   (Character_Type'Val (11427), Character_Type'Val (11427)),
   (Character_Type'Val (11429), Character_Type'Val (11429)),
   (Character_Type'Val (11431), Character_Type'Val (11431)),
   (Character_Type'Val (11433), Character_Type'Val (11433)),
   (Character_Type'Val (11435), Character_Type'Val (11435)),
   (Character_Type'Val (11437), Character_Type'Val (11437)),
   (Character_Type'Val (11439), Character_Type'Val (11439)),
   (Character_Type'Val (11441), Character_Type'Val (11441)),
   (Character_Type'Val (11443), Character_Type'Val (11443)),
   (Character_Type'Val (11445), Character_Type'Val (11445)),
   (Character_Type'Val (11447), Character_Type'Val (11447)),
   (Character_Type'Val (11449), Character_Type'Val (11449)),
   (Character_Type'Val (11451), Character_Type'Val (11451)),
   (Character_Type'Val (11453), Character_Type'Val (11453)),
   (Character_Type'Val (11455), Character_Type'Val (11455)),
   (Character_Type'Val (11457), Character_Type'Val (11457)),
   (Character_Type'Val (11459), Character_Type'Val (11459)),
   (Character_Type'Val (11461), Character_Type'Val (11461)),
   (Character_Type'Val (11463), Character_Type'Val (11463)),
   (Character_Type'Val (11465), Character_Type'Val (11465)),
   (Character_Type'Val (11467), Character_Type'Val (11467)),
   (Character_Type'Val (11469), Character_Type'Val (11469)),
   (Character_Type'Val (11471), Character_Type'Val (11471)),
   (Character_Type'Val (11473), Character_Type'Val (11473)),
   (Character_Type'Val (11475), Character_Type'Val (11475)),
   (Character_Type'Val (11477), Character_Type'Val (11477)),
   (Character_Type'Val (11479), Character_Type'Val (11479)),
   (Character_Type'Val (11481), Character_Type'Val (11481)),
   (Character_Type'Val (11483), Character_Type'Val (11483)),
   (Character_Type'Val (11485), Character_Type'Val (11485)),
   (Character_Type'Val (11487), Character_Type'Val (11487)),
   (Character_Type'Val (11489), Character_Type'Val (11489)),
   (Character_Type'Val (11491), Character_Type'Val (11492)),
   (Character_Type'Val (11500), Character_Type'Val (11500)),
   (Character_Type'Val (11502), Character_Type'Val (11502)),
   (Character_Type'Val (11520), Character_Type'Val (11557)),
   (Character_Type'Val (42561), Character_Type'Val (42561)),
   (Character_Type'Val (42563), Character_Type'Val (42563)),
   (Character_Type'Val (42565), Character_Type'Val (42565)),
   (Character_Type'Val (42567), Character_Type'Val (42567)),
   (Character_Type'Val (42569), Character_Type'Val (42569)),
   (Character_Type'Val (42571), Character_Type'Val (42571)),
   (Character_Type'Val (42573), Character_Type'Val (42573)),
   (Character_Type'Val (42575), Character_Type'Val (42575)),
   (Character_Type'Val (42577), Character_Type'Val (42577)),
   (Character_Type'Val (42579), Character_Type'Val (42579)),
   (Character_Type'Val (42581), Character_Type'Val (42581)),
   (Character_Type'Val (42583), Character_Type'Val (42583)),
   (Character_Type'Val (42585), Character_Type'Val (42585)),
   (Character_Type'Val (42587), Character_Type'Val (42587)),
   (Character_Type'Val (42589), Character_Type'Val (42589)),
   (Character_Type'Val (42591), Character_Type'Val (42591)),
   (Character_Type'Val (42595), Character_Type'Val (42595)),
   (Character_Type'Val (42597), Character_Type'Val (42597)),
   (Character_Type'Val (42599), Character_Type'Val (42599)),
   (Character_Type'Val (42601), Character_Type'Val (42601)),
   (Character_Type'Val (42603), Character_Type'Val (42603)),
   (Character_Type'Val (42605), Character_Type'Val (42605)),
   (Character_Type'Val (42625), Character_Type'Val (42625)),
   (Character_Type'Val (42627), Character_Type'Val (42627)),
   (Character_Type'Val (42629), Character_Type'Val (42629)),
   (Character_Type'Val (42631), Character_Type'Val (42631)),
   (Character_Type'Val (42633), Character_Type'Val (42633)),
   (Character_Type'Val (42635), Character_Type'Val (42635)),
   (Character_Type'Val (42637), Character_Type'Val (42637)),
   (Character_Type'Val (42639), Character_Type'Val (42639)),
   (Character_Type'Val (42641), Character_Type'Val (42641)),
   (Character_Type'Val (42643), Character_Type'Val (42643)),
   (Character_Type'Val (42645), Character_Type'Val (42645)),
   (Character_Type'Val (42647), Character_Type'Val (42647)),
   (Character_Type'Val (42787), Character_Type'Val (42787)),
   (Character_Type'Val (42789), Character_Type'Val (42789)),
   (Character_Type'Val (42791), Character_Type'Val (42791)),
   (Character_Type'Val (42793), Character_Type'Val (42793)),
   (Character_Type'Val (42795), Character_Type'Val (42795)),
   (Character_Type'Val (42797), Character_Type'Val (42797)),
   (Character_Type'Val (42799), Character_Type'Val (42801)),
   (Character_Type'Val (42803), Character_Type'Val (42803)),
   (Character_Type'Val (42805), Character_Type'Val (42805)),
   (Character_Type'Val (42807), Character_Type'Val (42807)),
   (Character_Type'Val (42809), Character_Type'Val (42809)),
   (Character_Type'Val (42811), Character_Type'Val (42811)),
   (Character_Type'Val (42813), Character_Type'Val (42813)),
   (Character_Type'Val (42815), Character_Type'Val (42815)),
   (Character_Type'Val (42817), Character_Type'Val (42817)),
   (Character_Type'Val (42819), Character_Type'Val (42819)),
   (Character_Type'Val (42821), Character_Type'Val (42821)),
   (Character_Type'Val (42823), Character_Type'Val (42823)),
   (Character_Type'Val (42825), Character_Type'Val (42825)),
   (Character_Type'Val (42827), Character_Type'Val (42827)),
   (Character_Type'Val (42829), Character_Type'Val (42829)),
   (Character_Type'Val (42831), Character_Type'Val (42831)),
   (Character_Type'Val (42833), Character_Type'Val (42833)),
   (Character_Type'Val (42835), Character_Type'Val (42835)),
   (Character_Type'Val (42837), Character_Type'Val (42837)),
   (Character_Type'Val (42839), Character_Type'Val (42839)),
   (Character_Type'Val (42841), Character_Type'Val (42841)),
   (Character_Type'Val (42843), Character_Type'Val (42843)),
   (Character_Type'Val (42845), Character_Type'Val (42845)),
   (Character_Type'Val (42847), Character_Type'Val (42847)),
   (Character_Type'Val (42849), Character_Type'Val (42849)),
   (Character_Type'Val (42851), Character_Type'Val (42851)),
   (Character_Type'Val (42853), Character_Type'Val (42853)),
   (Character_Type'Val (42855), Character_Type'Val (42855)),
   (Character_Type'Val (42857), Character_Type'Val (42857)),
   (Character_Type'Val (42859), Character_Type'Val (42859)),
   (Character_Type'Val (42861), Character_Type'Val (42861)),
   (Character_Type'Val (42863), Character_Type'Val (42863)),
   (Character_Type'Val (42865), Character_Type'Val (42872)),
   (Character_Type'Val (42874), Character_Type'Val (42874)),
   (Character_Type'Val (42876), Character_Type'Val (42876)),
   (Character_Type'Val (42879), Character_Type'Val (42879)),
   (Character_Type'Val (42881), Character_Type'Val (42881)),
   (Character_Type'Val (42883), Character_Type'Val (42883)),
   (Character_Type'Val (42885), Character_Type'Val (42885)),
   (Character_Type'Val (42887), Character_Type'Val (42887)),
   (Character_Type'Val (42892), Character_Type'Val (42892)),
   (Character_Type'Val (64256), Character_Type'Val (64262)),
   (Character_Type'Val (64275), Character_Type'Val (64279)),
   (Character_Type'Val (65345), Character_Type'Val (65370)),
   (Character_Type'Val (66600), Character_Type'Val (66639)),
   (Character_Type'Val (119834), Character_Type'Val (119859)),
   (Character_Type'Val (119886), Character_Type'Val (119892)),
   (Character_Type'Val (119894), Character_Type'Val (119911)),
   (Character_Type'Val (119938), Character_Type'Val (119963)),
   (Character_Type'Val (119990), Character_Type'Val (119993)),
   (Character_Type'Val (119995), Character_Type'Val (119995)),
   (Character_Type'Val (119997), Character_Type'Val (120003)),
   (Character_Type'Val (120005), Character_Type'Val (120015)),
   (Character_Type'Val (120042), Character_Type'Val (120067)),
   (Character_Type'Val (120094), Character_Type'Val (120119)),
   (Character_Type'Val (120146), Character_Type'Val (120171)),
   (Character_Type'Val (120198), Character_Type'Val (120223)),
   (Character_Type'Val (120250), Character_Type'Val (120275)),
   (Character_Type'Val (120302), Character_Type'Val (120327)),
   (Character_Type'Val (120354), Character_Type'Val (120379)),
   (Character_Type'Val (120406), Character_Type'Val (120431)),
   (Character_Type'Val (120458), Character_Type'Val (120485)),
   (Character_Type'Val (120514), Character_Type'Val (120538)),
   (Character_Type'Val (120540), Character_Type'Val (120545)),
   (Character_Type'Val (120572), Character_Type'Val (120596)),
   (Character_Type'Val (120598), Character_Type'Val (120603)),
   (Character_Type'Val (120630), Character_Type'Val (120654)),
   (Character_Type'Val (120656), Character_Type'Val (120661)),
   (Character_Type'Val (120688), Character_Type'Val (120712)),
   (Character_Type'Val (120714), Character_Type'Val (120719)),
   (Character_Type'Val (120746), Character_Type'Val (120770)),
   (Character_Type'Val (120772), Character_Type'Val (120777)),
   (Character_Type'Val (120779), Character_Type'Val (120779))
   );
   Ranges_2 : constant Character_Range_Array := (
   (Character_Type'Val (443), Character_Type'Val (443)),
   (Character_Type'Val (448), Character_Type'Val (451)),
   (Character_Type'Val (660), Character_Type'Val (660)),
   (Character_Type'Val (1488), Character_Type'Val (1514)),
   (Character_Type'Val (1520), Character_Type'Val (1522)),
   (Character_Type'Val (1569), Character_Type'Val (1599)),
   (Character_Type'Val (1601), Character_Type'Val (1610)),
   (Character_Type'Val (1646), Character_Type'Val (1647)),
   (Character_Type'Val (1649), Character_Type'Val (1747)),
   (Character_Type'Val (1749), Character_Type'Val (1749)),
   (Character_Type'Val (1774), Character_Type'Val (1775)),
   (Character_Type'Val (1786), Character_Type'Val (1788)),
   (Character_Type'Val (1791), Character_Type'Val (1791)),
   (Character_Type'Val (1808), Character_Type'Val (1808)),
   (Character_Type'Val (1810), Character_Type'Val (1839)),
   (Character_Type'Val (1869), Character_Type'Val (1957)),
   (Character_Type'Val (1969), Character_Type'Val (1969)),
   (Character_Type'Val (1994), Character_Type'Val (2026)),
   (Character_Type'Val (2048), Character_Type'Val (2069)),
   (Character_Type'Val (2308), Character_Type'Val (2361)),
   (Character_Type'Val (2365), Character_Type'Val (2365)),
   (Character_Type'Val (2384), Character_Type'Val (2384)),
   (Character_Type'Val (2392), Character_Type'Val (2401)),
   (Character_Type'Val (2418), Character_Type'Val (2418)),
   (Character_Type'Val (2425), Character_Type'Val (2431)),
   (Character_Type'Val (2437), Character_Type'Val (2444)),
   (Character_Type'Val (2447), Character_Type'Val (2448)),
   (Character_Type'Val (2451), Character_Type'Val (2472)),
   (Character_Type'Val (2474), Character_Type'Val (2480)),
   (Character_Type'Val (2482), Character_Type'Val (2482)),
   (Character_Type'Val (2486), Character_Type'Val (2489)),
   (Character_Type'Val (2493), Character_Type'Val (2493)),
   (Character_Type'Val (2510), Character_Type'Val (2510)),
   (Character_Type'Val (2524), Character_Type'Val (2525)),
   (Character_Type'Val (2527), Character_Type'Val (2529)),
   (Character_Type'Val (2544), Character_Type'Val (2545)),
   (Character_Type'Val (2565), Character_Type'Val (2570)),
   (Character_Type'Val (2575), Character_Type'Val (2576)),
   (Character_Type'Val (2579), Character_Type'Val (2600)),
   (Character_Type'Val (2602), Character_Type'Val (2608)),
   (Character_Type'Val (2610), Character_Type'Val (2611)),
   (Character_Type'Val (2613), Character_Type'Val (2614)),
   (Character_Type'Val (2616), Character_Type'Val (2617)),
   (Character_Type'Val (2649), Character_Type'Val (2652)),
   (Character_Type'Val (2654), Character_Type'Val (2654)),
   (Character_Type'Val (2674), Character_Type'Val (2676)),
   (Character_Type'Val (2693), Character_Type'Val (2701)),
   (Character_Type'Val (2703), Character_Type'Val (2705)),
   (Character_Type'Val (2707), Character_Type'Val (2728)),
   (Character_Type'Val (2730), Character_Type'Val (2736)),
   (Character_Type'Val (2738), Character_Type'Val (2739)),
   (Character_Type'Val (2741), Character_Type'Val (2745)),
   (Character_Type'Val (2749), Character_Type'Val (2749)),
   (Character_Type'Val (2768), Character_Type'Val (2768)),
   (Character_Type'Val (2784), Character_Type'Val (2785)),
   (Character_Type'Val (2821), Character_Type'Val (2828)),
   (Character_Type'Val (2831), Character_Type'Val (2832)),
   (Character_Type'Val (2835), Character_Type'Val (2856)),
   (Character_Type'Val (2858), Character_Type'Val (2864)),
   (Character_Type'Val (2866), Character_Type'Val (2867)),
   (Character_Type'Val (2869), Character_Type'Val (2873)),
   (Character_Type'Val (2877), Character_Type'Val (2877)),
   (Character_Type'Val (2908), Character_Type'Val (2909)),
   (Character_Type'Val (2911), Character_Type'Val (2913)),
   (Character_Type'Val (2929), Character_Type'Val (2929)),
   (Character_Type'Val (2947), Character_Type'Val (2947)),
   (Character_Type'Val (2949), Character_Type'Val (2954)),
   (Character_Type'Val (2958), Character_Type'Val (2960)),
   (Character_Type'Val (2962), Character_Type'Val (2965)),
   (Character_Type'Val (2969), Character_Type'Val (2970)),
   (Character_Type'Val (2972), Character_Type'Val (2972)),
   (Character_Type'Val (2974), Character_Type'Val (2975)),
   (Character_Type'Val (2979), Character_Type'Val (2980)),
   (Character_Type'Val (2984), Character_Type'Val (2986)),
   (Character_Type'Val (2990), Character_Type'Val (3001)),
   (Character_Type'Val (3024), Character_Type'Val (3024)),
   (Character_Type'Val (3077), Character_Type'Val (3084)),
   (Character_Type'Val (3086), Character_Type'Val (3088)),
   (Character_Type'Val (3090), Character_Type'Val (3112)),
   (Character_Type'Val (3114), Character_Type'Val (3123)),
   (Character_Type'Val (3125), Character_Type'Val (3129)),
   (Character_Type'Val (3133), Character_Type'Val (3133)),
   (Character_Type'Val (3160), Character_Type'Val (3161)),
   (Character_Type'Val (3168), Character_Type'Val (3169)),
   (Character_Type'Val (3205), Character_Type'Val (3212)),
   (Character_Type'Val (3214), Character_Type'Val (3216)),
   (Character_Type'Val (3218), Character_Type'Val (3240)),
   (Character_Type'Val (3242), Character_Type'Val (3251)),
   (Character_Type'Val (3253), Character_Type'Val (3257)),
   (Character_Type'Val (3261), Character_Type'Val (3261)),
   (Character_Type'Val (3294), Character_Type'Val (3294)),
   (Character_Type'Val (3296), Character_Type'Val (3297)),
   (Character_Type'Val (3333), Character_Type'Val (3340)),
   (Character_Type'Val (3342), Character_Type'Val (3344)),
   (Character_Type'Val (3346), Character_Type'Val (3368)),
   (Character_Type'Val (3370), Character_Type'Val (3385)),
   (Character_Type'Val (3389), Character_Type'Val (3389)),
   (Character_Type'Val (3424), Character_Type'Val (3425)),
   (Character_Type'Val (3450), Character_Type'Val (3455)),
   (Character_Type'Val (3461), Character_Type'Val (3478)),
   (Character_Type'Val (3482), Character_Type'Val (3505)),
   (Character_Type'Val (3507), Character_Type'Val (3515)),
   (Character_Type'Val (3517), Character_Type'Val (3517)),
   (Character_Type'Val (3520), Character_Type'Val (3526)),
   (Character_Type'Val (3585), Character_Type'Val (3632)),
   (Character_Type'Val (3634), Character_Type'Val (3635)),
   (Character_Type'Val (3648), Character_Type'Val (3653)),
   (Character_Type'Val (3713), Character_Type'Val (3714)),
   (Character_Type'Val (3716), Character_Type'Val (3716)),
   (Character_Type'Val (3719), Character_Type'Val (3720)),
   (Character_Type'Val (3722), Character_Type'Val (3722)),
   (Character_Type'Val (3725), Character_Type'Val (3725)),
   (Character_Type'Val (3732), Character_Type'Val (3735)),
   (Character_Type'Val (3737), Character_Type'Val (3743)),
   (Character_Type'Val (3745), Character_Type'Val (3747)),
   (Character_Type'Val (3749), Character_Type'Val (3749)),
   (Character_Type'Val (3751), Character_Type'Val (3751)),
   (Character_Type'Val (3754), Character_Type'Val (3755)),
   (Character_Type'Val (3757), Character_Type'Val (3760)),
   (Character_Type'Val (3762), Character_Type'Val (3763)),
   (Character_Type'Val (3773), Character_Type'Val (3773)),
   (Character_Type'Val (3776), Character_Type'Val (3780)),
   (Character_Type'Val (3804), Character_Type'Val (3805)),
   (Character_Type'Val (3840), Character_Type'Val (3840)),
   (Character_Type'Val (3904), Character_Type'Val (3911)),
   (Character_Type'Val (3913), Character_Type'Val (3948)),
   (Character_Type'Val (3976), Character_Type'Val (3979)),
   (Character_Type'Val (4096), Character_Type'Val (4138)),
   (Character_Type'Val (4159), Character_Type'Val (4159)),
   (Character_Type'Val (4176), Character_Type'Val (4181)),
   (Character_Type'Val (4186), Character_Type'Val (4189)),
   (Character_Type'Val (4193), Character_Type'Val (4193)),
   (Character_Type'Val (4197), Character_Type'Val (4198)),
   (Character_Type'Val (4206), Character_Type'Val (4208)),
   (Character_Type'Val (4213), Character_Type'Val (4225)),
   (Character_Type'Val (4238), Character_Type'Val (4238)),
   (Character_Type'Val (4304), Character_Type'Val (4346)),
   (Character_Type'Val (4352), Character_Type'Val (4680)),
   (Character_Type'Val (4682), Character_Type'Val (4685)),
   (Character_Type'Val (4688), Character_Type'Val (4694)),
   (Character_Type'Val (4696), Character_Type'Val (4696)),
   (Character_Type'Val (4698), Character_Type'Val (4701)),
   (Character_Type'Val (4704), Character_Type'Val (4744)),
   (Character_Type'Val (4746), Character_Type'Val (4749)),
   (Character_Type'Val (4752), Character_Type'Val (4784)),
   (Character_Type'Val (4786), Character_Type'Val (4789)),
   (Character_Type'Val (4792), Character_Type'Val (4798)),
   (Character_Type'Val (4800), Character_Type'Val (4800)),
   (Character_Type'Val (4802), Character_Type'Val (4805)),
   (Character_Type'Val (4808), Character_Type'Val (4822)),
   (Character_Type'Val (4824), Character_Type'Val (4880)),
   (Character_Type'Val (4882), Character_Type'Val (4885)),
   (Character_Type'Val (4888), Character_Type'Val (4954)),
   (Character_Type'Val (4992), Character_Type'Val (5007)),
   (Character_Type'Val (5024), Character_Type'Val (5108)),
   (Character_Type'Val (5121), Character_Type'Val (5740)),
   (Character_Type'Val (5743), Character_Type'Val (5759)),
   (Character_Type'Val (5761), Character_Type'Val (5786)),
   (Character_Type'Val (5792), Character_Type'Val (5866)),
   (Character_Type'Val (5888), Character_Type'Val (5900)),
   (Character_Type'Val (5902), Character_Type'Val (5905)),
   (Character_Type'Val (5920), Character_Type'Val (5937)),
   (Character_Type'Val (5952), Character_Type'Val (5969)),
   (Character_Type'Val (5984), Character_Type'Val (5996)),
   (Character_Type'Val (5998), Character_Type'Val (6000)),
   (Character_Type'Val (6016), Character_Type'Val (6067)),
   (Character_Type'Val (6108), Character_Type'Val (6108)),
   (Character_Type'Val (6176), Character_Type'Val (6210)),
   (Character_Type'Val (6212), Character_Type'Val (6263)),
   (Character_Type'Val (6272), Character_Type'Val (6312)),
   (Character_Type'Val (6314), Character_Type'Val (6314)),
   (Character_Type'Val (6320), Character_Type'Val (6389)),
   (Character_Type'Val (6400), Character_Type'Val (6428)),
   (Character_Type'Val (6480), Character_Type'Val (6509)),
   (Character_Type'Val (6512), Character_Type'Val (6516)),
   (Character_Type'Val (6528), Character_Type'Val (6571)),
   (Character_Type'Val (6593), Character_Type'Val (6599)),
   (Character_Type'Val (6656), Character_Type'Val (6678)),
   (Character_Type'Val (6688), Character_Type'Val (6740)),
   (Character_Type'Val (6917), Character_Type'Val (6963)),
   (Character_Type'Val (6981), Character_Type'Val (6987)),
   (Character_Type'Val (7043), Character_Type'Val (7072)),
   (Character_Type'Val (7086), Character_Type'Val (7087)),
   (Character_Type'Val (7168), Character_Type'Val (7203)),
   (Character_Type'Val (7245), Character_Type'Val (7247)),
   (Character_Type'Val (7258), Character_Type'Val (7287)),
   (Character_Type'Val (7401), Character_Type'Val (7404)),
   (Character_Type'Val (7406), Character_Type'Val (7409)),
   (Character_Type'Val (8501), Character_Type'Val (8504)),
   (Character_Type'Val (11568), Character_Type'Val (11621)),
   (Character_Type'Val (11648), Character_Type'Val (11670)),
   (Character_Type'Val (11680), Character_Type'Val (11686)),
   (Character_Type'Val (11688), Character_Type'Val (11694)),
   (Character_Type'Val (11696), Character_Type'Val (11702)),
   (Character_Type'Val (11704), Character_Type'Val (11710)),
   (Character_Type'Val (11712), Character_Type'Val (11718)),
   (Character_Type'Val (11720), Character_Type'Val (11726)),
   (Character_Type'Val (11728), Character_Type'Val (11734)),
   (Character_Type'Val (11736), Character_Type'Val (11742)),
   (Character_Type'Val (12294), Character_Type'Val (12294)),
   (Character_Type'Val (12348), Character_Type'Val (12348)),
   (Character_Type'Val (12353), Character_Type'Val (12438)),
   (Character_Type'Val (12447), Character_Type'Val (12447)),
   (Character_Type'Val (12449), Character_Type'Val (12538)),
   (Character_Type'Val (12543), Character_Type'Val (12543)),
   (Character_Type'Val (12549), Character_Type'Val (12589)),
   (Character_Type'Val (12593), Character_Type'Val (12686)),
   (Character_Type'Val (12704), Character_Type'Val (12727)),
   (Character_Type'Val (12784), Character_Type'Val (12799)),
   (Character_Type'Val (13312), Character_Type'Val (19893)),
   (Character_Type'Val (19968), Character_Type'Val (40907)),
   (Character_Type'Val (40960), Character_Type'Val (40980)),
   (Character_Type'Val (40982), Character_Type'Val (42124)),
   (Character_Type'Val (42192), Character_Type'Val (42231)),
   (Character_Type'Val (42240), Character_Type'Val (42507)),
   (Character_Type'Val (42512), Character_Type'Val (42527)),
   (Character_Type'Val (42538), Character_Type'Val (42539)),
   (Character_Type'Val (42606), Character_Type'Val (42606)),
   (Character_Type'Val (42656), Character_Type'Val (42725)),
   (Character_Type'Val (43003), Character_Type'Val (43009)),
   (Character_Type'Val (43011), Character_Type'Val (43013)),
   (Character_Type'Val (43015), Character_Type'Val (43018)),
   (Character_Type'Val (43020), Character_Type'Val (43042)),
   (Character_Type'Val (43072), Character_Type'Val (43123)),
   (Character_Type'Val (43138), Character_Type'Val (43187)),
   (Character_Type'Val (43250), Character_Type'Val (43255)),
   (Character_Type'Val (43259), Character_Type'Val (43259)),
   (Character_Type'Val (43274), Character_Type'Val (43301)),
   (Character_Type'Val (43312), Character_Type'Val (43334)),
   (Character_Type'Val (43360), Character_Type'Val (43388)),
   (Character_Type'Val (43396), Character_Type'Val (43442)),
   (Character_Type'Val (43520), Character_Type'Val (43560)),
   (Character_Type'Val (43584), Character_Type'Val (43586)),
   (Character_Type'Val (43588), Character_Type'Val (43595)),
   (Character_Type'Val (43616), Character_Type'Val (43631)),
   (Character_Type'Val (43633), Character_Type'Val (43638)),
   (Character_Type'Val (43642), Character_Type'Val (43642)),
   (Character_Type'Val (43648), Character_Type'Val (43695)),
   (Character_Type'Val (43697), Character_Type'Val (43697)),
   (Character_Type'Val (43701), Character_Type'Val (43702)),
   (Character_Type'Val (43705), Character_Type'Val (43709)),
   (Character_Type'Val (43712), Character_Type'Val (43712)),
   (Character_Type'Val (43714), Character_Type'Val (43714)),
   (Character_Type'Val (43739), Character_Type'Val (43740)),
   (Character_Type'Val (43968), Character_Type'Val (44002)),
   (Character_Type'Val (44032), Character_Type'Val (55203)),
   (Character_Type'Val (55216), Character_Type'Val (55238)),
   (Character_Type'Val (55243), Character_Type'Val (55291)),
   (Character_Type'Val (63744), Character_Type'Val (64045)),
   (Character_Type'Val (64048), Character_Type'Val (64109)),
   (Character_Type'Val (64112), Character_Type'Val (64217)),
   (Character_Type'Val (64285), Character_Type'Val (64285)),
   (Character_Type'Val (64287), Character_Type'Val (64296)),
   (Character_Type'Val (64298), Character_Type'Val (64310)),
   (Character_Type'Val (64312), Character_Type'Val (64316)),
   (Character_Type'Val (64318), Character_Type'Val (64318)),
   (Character_Type'Val (64320), Character_Type'Val (64321)),
   (Character_Type'Val (64323), Character_Type'Val (64324)),
   (Character_Type'Val (64326), Character_Type'Val (64433)),
   (Character_Type'Val (64467), Character_Type'Val (64829)),
   (Character_Type'Val (64848), Character_Type'Val (64911)),
   (Character_Type'Val (64914), Character_Type'Val (64967)),
   (Character_Type'Val (65008), Character_Type'Val (65019)),
   (Character_Type'Val (65136), Character_Type'Val (65140)),
   (Character_Type'Val (65142), Character_Type'Val (65276)),
   (Character_Type'Val (65382), Character_Type'Val (65391)),
   (Character_Type'Val (65393), Character_Type'Val (65437)),
   (Character_Type'Val (65440), Character_Type'Val (65470)),
   (Character_Type'Val (65474), Character_Type'Val (65479)),
   (Character_Type'Val (65482), Character_Type'Val (65487)),
   (Character_Type'Val (65490), Character_Type'Val (65495)),
   (Character_Type'Val (65498), Character_Type'Val (65500)),
   (Character_Type'Val (65536), Character_Type'Val (65547)),
   (Character_Type'Val (65549), Character_Type'Val (65574)),
   (Character_Type'Val (65576), Character_Type'Val (65594)),
   (Character_Type'Val (65596), Character_Type'Val (65597)),
   (Character_Type'Val (65599), Character_Type'Val (65613)),
   (Character_Type'Val (65616), Character_Type'Val (65629)),
   (Character_Type'Val (65664), Character_Type'Val (65786)),
   (Character_Type'Val (66176), Character_Type'Val (66204)),
   (Character_Type'Val (66208), Character_Type'Val (66256)),
   (Character_Type'Val (66304), Character_Type'Val (66334)),
   (Character_Type'Val (66352), Character_Type'Val (66368)),
   (Character_Type'Val (66370), Character_Type'Val (66377)),
   (Character_Type'Val (66432), Character_Type'Val (66461)),
   (Character_Type'Val (66464), Character_Type'Val (66499)),
   (Character_Type'Val (66504), Character_Type'Val (66511)),
   (Character_Type'Val (66640), Character_Type'Val (66717)),
   (Character_Type'Val (67584), Character_Type'Val (67589)),
   (Character_Type'Val (67592), Character_Type'Val (67592)),
   (Character_Type'Val (67594), Character_Type'Val (67637)),
   (Character_Type'Val (67639), Character_Type'Val (67640)),
   (Character_Type'Val (67644), Character_Type'Val (67644)),
   (Character_Type'Val (67647), Character_Type'Val (67669)),
   (Character_Type'Val (67840), Character_Type'Val (67861)),
   (Character_Type'Val (67872), Character_Type'Val (67897)),
   (Character_Type'Val (68096), Character_Type'Val (68096)),
   (Character_Type'Val (68112), Character_Type'Val (68115)),
   (Character_Type'Val (68117), Character_Type'Val (68119)),
   (Character_Type'Val (68121), Character_Type'Val (68147)),
   (Character_Type'Val (68192), Character_Type'Val (68220)),
   (Character_Type'Val (68352), Character_Type'Val (68405)),
   (Character_Type'Val (68416), Character_Type'Val (68437)),
   (Character_Type'Val (68448), Character_Type'Val (68466)),
   (Character_Type'Val (68608), Character_Type'Val (68680)),
   (Character_Type'Val (69763), Character_Type'Val (69807)),
   (Character_Type'Val (73728), Character_Type'Val (74606)),
   (Character_Type'Val (77824), Character_Type'Val (78894)),
   (Character_Type'Val (131072), Character_Type'Val (173782)),
   (Character_Type'Val (173824), Character_Type'Val (177972)),
   (Character_Type'Val (194560), Character_Type'Val (195101))
   );
   Ranges_3 : constant Character_Range_Array := (
   (Character_Type'Val (453), Character_Type'Val (453)),
   (Character_Type'Val (456), Character_Type'Val (456)),
   (Character_Type'Val (459), Character_Type'Val (459)),
   (Character_Type'Val (498), Character_Type'Val (498)),
   (Character_Type'Val (8072), Character_Type'Val (8079)),
   (Character_Type'Val (8088), Character_Type'Val (8095)),
   (Character_Type'Val (8104), Character_Type'Val (8111)),
   (Character_Type'Val (8124), Character_Type'Val (8124)),
   (Character_Type'Val (8140), Character_Type'Val (8140)),
   (Character_Type'Val (8188), Character_Type'Val (8188))
   );
   Ranges_4 : constant Character_Range_Array := (
   (Character_Type'Val (688), Character_Type'Val (705)),
   (Character_Type'Val (710), Character_Type'Val (721)),
   (Character_Type'Val (736), Character_Type'Val (740)),
   (Character_Type'Val (748), Character_Type'Val (748)),
   (Character_Type'Val (750), Character_Type'Val (750)),
   (Character_Type'Val (884), Character_Type'Val (884)),
   (Character_Type'Val (890), Character_Type'Val (890)),
   (Character_Type'Val (1369), Character_Type'Val (1369)),
   (Character_Type'Val (1600), Character_Type'Val (1600)),
   (Character_Type'Val (1765), Character_Type'Val (1766)),
   (Character_Type'Val (2036), Character_Type'Val (2037)),
   (Character_Type'Val (2042), Character_Type'Val (2042)),
   (Character_Type'Val (2074), Character_Type'Val (2074)),
   (Character_Type'Val (2084), Character_Type'Val (2084)),
   (Character_Type'Val (2088), Character_Type'Val (2088)),
   (Character_Type'Val (2417), Character_Type'Val (2417)),
   (Character_Type'Val (3654), Character_Type'Val (3654)),
   (Character_Type'Val (3782), Character_Type'Val (3782)),
   (Character_Type'Val (4348), Character_Type'Val (4348)),
   (Character_Type'Val (6103), Character_Type'Val (6103)),
   (Character_Type'Val (6211), Character_Type'Val (6211)),
   (Character_Type'Val (6823), Character_Type'Val (6823)),
   (Character_Type'Val (7288), Character_Type'Val (7293)),
   (Character_Type'Val (7468), Character_Type'Val (7521)),
   (Character_Type'Val (7544), Character_Type'Val (7544)),
   (Character_Type'Val (7579), Character_Type'Val (7615)),
   (Character_Type'Val (8305), Character_Type'Val (8305)),
   (Character_Type'Val (8319), Character_Type'Val (8319)),
   (Character_Type'Val (8336), Character_Type'Val (8340)),
   (Character_Type'Val (11389), Character_Type'Val (11389)),
   (Character_Type'Val (11631), Character_Type'Val (11631)),
   (Character_Type'Val (11823), Character_Type'Val (11823)),
   (Character_Type'Val (12293), Character_Type'Val (12293)),
   (Character_Type'Val (12337), Character_Type'Val (12341)),
   (Character_Type'Val (12347), Character_Type'Val (12347)),
   (Character_Type'Val (12445), Character_Type'Val (12446)),
   (Character_Type'Val (12540), Character_Type'Val (12542)),
   (Character_Type'Val (40981), Character_Type'Val (40981)),
   (Character_Type'Val (42232), Character_Type'Val (42237)),
   (Character_Type'Val (42508), Character_Type'Val (42508)),
   (Character_Type'Val (42623), Character_Type'Val (42623)),
   (Character_Type'Val (42775), Character_Type'Val (42783)),
   (Character_Type'Val (42864), Character_Type'Val (42864)),
   (Character_Type'Val (42888), Character_Type'Val (42888)),
   (Character_Type'Val (43471), Character_Type'Val (43471)),
   (Character_Type'Val (43632), Character_Type'Val (43632)),
   (Character_Type'Val (43741), Character_Type'Val (43741)),
   (Character_Type'Val (65392), Character_Type'Val (65392)),
   (Character_Type'Val (65438), Character_Type'Val (65439))
   );
   Ranges_5 : constant Character_Range_Array := (
   (Character_Type'Val (5870), Character_Type'Val (5872)),
   (Character_Type'Val (8544), Character_Type'Val (8578)),
   (Character_Type'Val (8581), Character_Type'Val (8584)),
   (Character_Type'Val (12295), Character_Type'Val (12295)),
   (Character_Type'Val (12321), Character_Type'Val (12329)),
   (Character_Type'Val (12344), Character_Type'Val (12346)),
   (Character_Type'Val (42726), Character_Type'Val (42735)),
   (Character_Type'Val (65856), Character_Type'Val (65908)),
   (Character_Type'Val (66369), Character_Type'Val (66369)),
   (Character_Type'Val (66378), Character_Type'Val (66378)),
   (Character_Type'Val (66513), Character_Type'Val (66517)),
   (Character_Type'Val (74752), Character_Type'Val (74850))
   );
   Ranges_6 : constant Character_Range_Array := (
   (Character_Type'Val (1632), Character_Type'Val (1641)),
   (Character_Type'Val (1776), Character_Type'Val (1785)),
   (Character_Type'Val (1984), Character_Type'Val (1993)),
   (Character_Type'Val (2406), Character_Type'Val (2415)),
   (Character_Type'Val (2534), Character_Type'Val (2543)),
   (Character_Type'Val (2662), Character_Type'Val (2671)),
   (Character_Type'Val (2790), Character_Type'Val (2799)),
   (Character_Type'Val (2918), Character_Type'Val (2927)),
   (Character_Type'Val (3046), Character_Type'Val (3055)),
   (Character_Type'Val (3174), Character_Type'Val (3183)),
   (Character_Type'Val (3302), Character_Type'Val (3311)),
   (Character_Type'Val (3430), Character_Type'Val (3439)),
   (Character_Type'Val (3664), Character_Type'Val (3673)),
   (Character_Type'Val (3792), Character_Type'Val (3801)),
   (Character_Type'Val (3872), Character_Type'Val (3881)),
   (Character_Type'Val (4160), Character_Type'Val (4169)),
   (Character_Type'Val (4240), Character_Type'Val (4249)),
   (Character_Type'Val (6112), Character_Type'Val (6121)),
   (Character_Type'Val (6160), Character_Type'Val (6169)),
   (Character_Type'Val (6470), Character_Type'Val (6479)),
   (Character_Type'Val (6608), Character_Type'Val (6618)),
   (Character_Type'Val (6784), Character_Type'Val (6793)),
   (Character_Type'Val (6800), Character_Type'Val (6809)),
   (Character_Type'Val (6992), Character_Type'Val (7001)),
   (Character_Type'Val (7088), Character_Type'Val (7097)),
   (Character_Type'Val (7232), Character_Type'Val (7241)),
   (Character_Type'Val (7248), Character_Type'Val (7257)),
   (Character_Type'Val (42528), Character_Type'Val (42537)),
   (Character_Type'Val (43216), Character_Type'Val (43225)),
   (Character_Type'Val (43264), Character_Type'Val (43273)),
   (Character_Type'Val (43472), Character_Type'Val (43481)),
   (Character_Type'Val (43600), Character_Type'Val (43609)),
   (Character_Type'Val (44016), Character_Type'Val (44025)),
   (Character_Type'Val (65296), Character_Type'Val (65305)),
   (Character_Type'Val (66720), Character_Type'Val (66729)),
   (Character_Type'Val (120782), Character_Type'Val (120831))
   );
   Ranges_7 : constant Character_Range_Array := (
   (Character_Type'Val (768), Character_Type'Val (879)),
   (Character_Type'Val (1155), Character_Type'Val (1159)),
   (Character_Type'Val (1425), Character_Type'Val (1469)),
   (Character_Type'Val (1471), Character_Type'Val (1471)),
   (Character_Type'Val (1473), Character_Type'Val (1474)),
   (Character_Type'Val (1476), Character_Type'Val (1477)),
   (Character_Type'Val (1479), Character_Type'Val (1479)),
   (Character_Type'Val (1552), Character_Type'Val (1562)),
   (Character_Type'Val (1611), Character_Type'Val (1630)),
   (Character_Type'Val (1648), Character_Type'Val (1648)),
   (Character_Type'Val (1750), Character_Type'Val (1756)),
   (Character_Type'Val (1759), Character_Type'Val (1764)),
   (Character_Type'Val (1767), Character_Type'Val (1768)),
   (Character_Type'Val (1770), Character_Type'Val (1773)),
   (Character_Type'Val (1809), Character_Type'Val (1809)),
   (Character_Type'Val (1840), Character_Type'Val (1866)),
   (Character_Type'Val (1958), Character_Type'Val (1968)),
   (Character_Type'Val (2027), Character_Type'Val (2035)),
   (Character_Type'Val (2070), Character_Type'Val (2073)),
   (Character_Type'Val (2075), Character_Type'Val (2083)),
   (Character_Type'Val (2085), Character_Type'Val (2087)),
   (Character_Type'Val (2089), Character_Type'Val (2093)),
   (Character_Type'Val (2304), Character_Type'Val (2306)),
   (Character_Type'Val (2364), Character_Type'Val (2364)),
   (Character_Type'Val (2369), Character_Type'Val (2376)),
   (Character_Type'Val (2381), Character_Type'Val (2381)),
   (Character_Type'Val (2385), Character_Type'Val (2389)),
   (Character_Type'Val (2402), Character_Type'Val (2403)),
   (Character_Type'Val (2433), Character_Type'Val (2433)),
   (Character_Type'Val (2492), Character_Type'Val (2492)),
   (Character_Type'Val (2497), Character_Type'Val (2500)),
   (Character_Type'Val (2509), Character_Type'Val (2509)),
   (Character_Type'Val (2530), Character_Type'Val (2531)),
   (Character_Type'Val (2561), Character_Type'Val (2562)),
   (Character_Type'Val (2620), Character_Type'Val (2620)),
   (Character_Type'Val (2625), Character_Type'Val (2626)),
   (Character_Type'Val (2631), Character_Type'Val (2632)),
   (Character_Type'Val (2635), Character_Type'Val (2637)),
   (Character_Type'Val (2641), Character_Type'Val (2641)),
   (Character_Type'Val (2672), Character_Type'Val (2673)),
   (Character_Type'Val (2677), Character_Type'Val (2677)),
   (Character_Type'Val (2689), Character_Type'Val (2690)),
   (Character_Type'Val (2748), Character_Type'Val (2748)),
   (Character_Type'Val (2753), Character_Type'Val (2757)),
   (Character_Type'Val (2759), Character_Type'Val (2760)),
   (Character_Type'Val (2765), Character_Type'Val (2765)),
   (Character_Type'Val (2786), Character_Type'Val (2787)),
   (Character_Type'Val (2817), Character_Type'Val (2817)),
   (Character_Type'Val (2876), Character_Type'Val (2876)),
   (Character_Type'Val (2879), Character_Type'Val (2879)),
   (Character_Type'Val (2881), Character_Type'Val (2884)),
   (Character_Type'Val (2893), Character_Type'Val (2893)),
   (Character_Type'Val (2902), Character_Type'Val (2902)),
   (Character_Type'Val (2914), Character_Type'Val (2915)),
   (Character_Type'Val (2946), Character_Type'Val (2946)),
   (Character_Type'Val (3008), Character_Type'Val (3008)),
   (Character_Type'Val (3021), Character_Type'Val (3021)),
   (Character_Type'Val (3134), Character_Type'Val (3136)),
   (Character_Type'Val (3142), Character_Type'Val (3144)),
   (Character_Type'Val (3146), Character_Type'Val (3149)),
   (Character_Type'Val (3157), Character_Type'Val (3158)),
   (Character_Type'Val (3170), Character_Type'Val (3171)),
   (Character_Type'Val (3260), Character_Type'Val (3260)),
   (Character_Type'Val (3263), Character_Type'Val (3263)),
   (Character_Type'Val (3270), Character_Type'Val (3270)),
   (Character_Type'Val (3276), Character_Type'Val (3277)),
   (Character_Type'Val (3298), Character_Type'Val (3299)),
   (Character_Type'Val (3393), Character_Type'Val (3396)),
   (Character_Type'Val (3405), Character_Type'Val (3405)),
   (Character_Type'Val (3426), Character_Type'Val (3427)),
   (Character_Type'Val (3530), Character_Type'Val (3530)),
   (Character_Type'Val (3538), Character_Type'Val (3540)),
   (Character_Type'Val (3542), Character_Type'Val (3542)),
   (Character_Type'Val (3633), Character_Type'Val (3633)),
   (Character_Type'Val (3636), Character_Type'Val (3642)),
   (Character_Type'Val (3655), Character_Type'Val (3662)),
   (Character_Type'Val (3761), Character_Type'Val (3761)),
   (Character_Type'Val (3764), Character_Type'Val (3769)),
   (Character_Type'Val (3771), Character_Type'Val (3772)),
   (Character_Type'Val (3784), Character_Type'Val (3789)),
   (Character_Type'Val (3864), Character_Type'Val (3865)),
   (Character_Type'Val (3893), Character_Type'Val (3893)),
   (Character_Type'Val (3895), Character_Type'Val (3895)),
   (Character_Type'Val (3897), Character_Type'Val (3897)),
   (Character_Type'Val (3953), Character_Type'Val (3966)),
   (Character_Type'Val (3968), Character_Type'Val (3972)),
   (Character_Type'Val (3974), Character_Type'Val (3975)),
   (Character_Type'Val (3984), Character_Type'Val (3991)),
   (Character_Type'Val (3993), Character_Type'Val (4028)),
   (Character_Type'Val (4038), Character_Type'Val (4038)),
   (Character_Type'Val (4141), Character_Type'Val (4144)),
   (Character_Type'Val (4146), Character_Type'Val (4151)),
   (Character_Type'Val (4153), Character_Type'Val (4154)),
   (Character_Type'Val (4157), Character_Type'Val (4158)),
   (Character_Type'Val (4184), Character_Type'Val (4185)),
   (Character_Type'Val (4190), Character_Type'Val (4192)),
   (Character_Type'Val (4209), Character_Type'Val (4212)),
   (Character_Type'Val (4226), Character_Type'Val (4226)),
   (Character_Type'Val (4229), Character_Type'Val (4230)),
   (Character_Type'Val (4237), Character_Type'Val (4237)),
   (Character_Type'Val (4253), Character_Type'Val (4253)),
   (Character_Type'Val (4959), Character_Type'Val (4959)),
   (Character_Type'Val (5906), Character_Type'Val (5908)),
   (Character_Type'Val (5938), Character_Type'Val (5940)),
   (Character_Type'Val (5970), Character_Type'Val (5971)),
   (Character_Type'Val (6002), Character_Type'Val (6003)),
   (Character_Type'Val (6071), Character_Type'Val (6077)),
   (Character_Type'Val (6086), Character_Type'Val (6086)),
   (Character_Type'Val (6089), Character_Type'Val (6099)),
   (Character_Type'Val (6109), Character_Type'Val (6109)),
   (Character_Type'Val (6155), Character_Type'Val (6157)),
   (Character_Type'Val (6313), Character_Type'Val (6313)),
   (Character_Type'Val (6432), Character_Type'Val (6434)),
   (Character_Type'Val (6439), Character_Type'Val (6440)),
   (Character_Type'Val (6450), Character_Type'Val (6450)),
   (Character_Type'Val (6457), Character_Type'Val (6459)),
   (Character_Type'Val (6679), Character_Type'Val (6680)),
   (Character_Type'Val (6742), Character_Type'Val (6742)),
   (Character_Type'Val (6744), Character_Type'Val (6750)),
   (Character_Type'Val (6752), Character_Type'Val (6752)),
   (Character_Type'Val (6754), Character_Type'Val (6754)),
   (Character_Type'Val (6757), Character_Type'Val (6764)),
   (Character_Type'Val (6771), Character_Type'Val (6780)),
   (Character_Type'Val (6783), Character_Type'Val (6783)),
   (Character_Type'Val (6912), Character_Type'Val (6915)),
   (Character_Type'Val (6964), Character_Type'Val (6964)),
   (Character_Type'Val (6966), Character_Type'Val (6970)),
   (Character_Type'Val (6972), Character_Type'Val (6972)),
   (Character_Type'Val (6978), Character_Type'Val (6978)),
   (Character_Type'Val (7019), Character_Type'Val (7027)),
   (Character_Type'Val (7040), Character_Type'Val (7041)),
   (Character_Type'Val (7074), Character_Type'Val (7077)),
   (Character_Type'Val (7080), Character_Type'Val (7081)),
   (Character_Type'Val (7212), Character_Type'Val (7219)),
   (Character_Type'Val (7222), Character_Type'Val (7223)),
   (Character_Type'Val (7376), Character_Type'Val (7378)),
   (Character_Type'Val (7380), Character_Type'Val (7392)),
   (Character_Type'Val (7394), Character_Type'Val (7400)),
   (Character_Type'Val (7405), Character_Type'Val (7405)),
   (Character_Type'Val (7616), Character_Type'Val (7654)),
   (Character_Type'Val (7677), Character_Type'Val (7679)),
   (Character_Type'Val (8400), Character_Type'Val (8412)),
   (Character_Type'Val (8417), Character_Type'Val (8417)),
   (Character_Type'Val (8421), Character_Type'Val (8432)),
   (Character_Type'Val (11503), Character_Type'Val (11505)),
   (Character_Type'Val (11744), Character_Type'Val (11775)),
   (Character_Type'Val (12330), Character_Type'Val (12335)),
   (Character_Type'Val (12441), Character_Type'Val (12442)),
   (Character_Type'Val (42607), Character_Type'Val (42607)),
   (Character_Type'Val (42620), Character_Type'Val (42621)),
   (Character_Type'Val (42736), Character_Type'Val (42737)),
   (Character_Type'Val (43010), Character_Type'Val (43010)),
   (Character_Type'Val (43014), Character_Type'Val (43014)),
   (Character_Type'Val (43019), Character_Type'Val (43019)),
   (Character_Type'Val (43045), Character_Type'Val (43046)),
   (Character_Type'Val (43204), Character_Type'Val (43204)),
   (Character_Type'Val (43232), Character_Type'Val (43249)),
   (Character_Type'Val (43302), Character_Type'Val (43309)),
   (Character_Type'Val (43335), Character_Type'Val (43345)),
   (Character_Type'Val (43392), Character_Type'Val (43394)),
   (Character_Type'Val (43443), Character_Type'Val (43443)),
   (Character_Type'Val (43446), Character_Type'Val (43449)),
   (Character_Type'Val (43452), Character_Type'Val (43452)),
   (Character_Type'Val (43561), Character_Type'Val (43566)),
   (Character_Type'Val (43569), Character_Type'Val (43570)),
   (Character_Type'Val (43573), Character_Type'Val (43574)),
   (Character_Type'Val (43587), Character_Type'Val (43587)),
   (Character_Type'Val (43596), Character_Type'Val (43596)),
   (Character_Type'Val (43696), Character_Type'Val (43696)),
   (Character_Type'Val (43698), Character_Type'Val (43700)),
   (Character_Type'Val (43703), Character_Type'Val (43704)),
   (Character_Type'Val (43710), Character_Type'Val (43711)),
   (Character_Type'Val (43713), Character_Type'Val (43713)),
   (Character_Type'Val (44005), Character_Type'Val (44005)),
   (Character_Type'Val (44008), Character_Type'Val (44008)),
   (Character_Type'Val (44013), Character_Type'Val (44013)),
   (Character_Type'Val (64286), Character_Type'Val (64286)),
   (Character_Type'Val (65024), Character_Type'Val (65039)),
   (Character_Type'Val (65056), Character_Type'Val (65062)),
   (Character_Type'Val (66045), Character_Type'Val (66045)),
   (Character_Type'Val (68097), Character_Type'Val (68099)),
   (Character_Type'Val (68101), Character_Type'Val (68102)),
   (Character_Type'Val (68108), Character_Type'Val (68111)),
   (Character_Type'Val (68152), Character_Type'Val (68154)),
   (Character_Type'Val (68159), Character_Type'Val (68159)),
   (Character_Type'Val (69760), Character_Type'Val (69761)),
   (Character_Type'Val (69811), Character_Type'Val (69814)),
   (Character_Type'Val (69817), Character_Type'Val (69818)),
   (Character_Type'Val (119143), Character_Type'Val (119145)),
   (Character_Type'Val (119163), Character_Type'Val (119170)),
   (Character_Type'Val (119173), Character_Type'Val (119179)),
   (Character_Type'Val (119210), Character_Type'Val (119213)),
   (Character_Type'Val (119362), Character_Type'Val (119364)),
   (Character_Type'Val (917760), Character_Type'Val (917999))
   );
   Ranges_8 : constant Character_Range_Array := (
   (Character_Type'Val (2307), Character_Type'Val (2307)),
   (Character_Type'Val (2366), Character_Type'Val (2368)),
   (Character_Type'Val (2377), Character_Type'Val (2380)),
   (Character_Type'Val (2382), Character_Type'Val (2382)),
   (Character_Type'Val (2434), Character_Type'Val (2435)),
   (Character_Type'Val (2494), Character_Type'Val (2496)),
   (Character_Type'Val (2503), Character_Type'Val (2504)),
   (Character_Type'Val (2507), Character_Type'Val (2508)),
   (Character_Type'Val (2519), Character_Type'Val (2519)),
   (Character_Type'Val (2563), Character_Type'Val (2563)),
   (Character_Type'Val (2622), Character_Type'Val (2624)),
   (Character_Type'Val (2691), Character_Type'Val (2691)),
   (Character_Type'Val (2750), Character_Type'Val (2752)),
   (Character_Type'Val (2761), Character_Type'Val (2761)),
   (Character_Type'Val (2763), Character_Type'Val (2764)),
   (Character_Type'Val (2818), Character_Type'Val (2819)),
   (Character_Type'Val (2878), Character_Type'Val (2878)),
   (Character_Type'Val (2880), Character_Type'Val (2880)),
   (Character_Type'Val (2887), Character_Type'Val (2888)),
   (Character_Type'Val (2891), Character_Type'Val (2892)),
   (Character_Type'Val (2903), Character_Type'Val (2903)),
   (Character_Type'Val (3006), Character_Type'Val (3007)),
   (Character_Type'Val (3009), Character_Type'Val (3010)),
   (Character_Type'Val (3014), Character_Type'Val (3016)),
   (Character_Type'Val (3018), Character_Type'Val (3020)),
   (Character_Type'Val (3031), Character_Type'Val (3031)),
   (Character_Type'Val (3073), Character_Type'Val (3075)),
   (Character_Type'Val (3137), Character_Type'Val (3140)),
   (Character_Type'Val (3202), Character_Type'Val (3203)),
   (Character_Type'Val (3262), Character_Type'Val (3262)),
   (Character_Type'Val (3264), Character_Type'Val (3268)),
   (Character_Type'Val (3271), Character_Type'Val (3272)),
   (Character_Type'Val (3274), Character_Type'Val (3275)),
   (Character_Type'Val (3285), Character_Type'Val (3286)),
   (Character_Type'Val (3330), Character_Type'Val (3331)),
   (Character_Type'Val (3390), Character_Type'Val (3392)),
   (Character_Type'Val (3398), Character_Type'Val (3400)),
   (Character_Type'Val (3402), Character_Type'Val (3404)),
   (Character_Type'Val (3415), Character_Type'Val (3415)),
   (Character_Type'Val (3458), Character_Type'Val (3459)),
   (Character_Type'Val (3535), Character_Type'Val (3537)),
   (Character_Type'Val (3544), Character_Type'Val (3551)),
   (Character_Type'Val (3570), Character_Type'Val (3571)),
   (Character_Type'Val (3902), Character_Type'Val (3903)),
   (Character_Type'Val (3967), Character_Type'Val (3967)),
   (Character_Type'Val (4139), Character_Type'Val (4140)),
   (Character_Type'Val (4145), Character_Type'Val (4145)),
   (Character_Type'Val (4152), Character_Type'Val (4152)),
   (Character_Type'Val (4155), Character_Type'Val (4156)),
   (Character_Type'Val (4182), Character_Type'Val (4183)),
   (Character_Type'Val (4194), Character_Type'Val (4196)),
   (Character_Type'Val (4199), Character_Type'Val (4205)),
   (Character_Type'Val (4227), Character_Type'Val (4228)),
   (Character_Type'Val (4231), Character_Type'Val (4236)),
   (Character_Type'Val (4239), Character_Type'Val (4239)),
   (Character_Type'Val (4250), Character_Type'Val (4252)),
   (Character_Type'Val (6070), Character_Type'Val (6070)),
   (Character_Type'Val (6078), Character_Type'Val (6085)),
   (Character_Type'Val (6087), Character_Type'Val (6088)),
   (Character_Type'Val (6435), Character_Type'Val (6438)),
   (Character_Type'Val (6441), Character_Type'Val (6443)),
   (Character_Type'Val (6448), Character_Type'Val (6449)),
   (Character_Type'Val (6451), Character_Type'Val (6456)),
   (Character_Type'Val (6576), Character_Type'Val (6592)),
   (Character_Type'Val (6600), Character_Type'Val (6601)),
   (Character_Type'Val (6681), Character_Type'Val (6683)),
   (Character_Type'Val (6741), Character_Type'Val (6741)),
   (Character_Type'Val (6743), Character_Type'Val (6743)),
   (Character_Type'Val (6753), Character_Type'Val (6753)),
   (Character_Type'Val (6755), Character_Type'Val (6756)),
   (Character_Type'Val (6765), Character_Type'Val (6770)),
   (Character_Type'Val (6916), Character_Type'Val (6916)),
   (Character_Type'Val (6965), Character_Type'Val (6965)),
   (Character_Type'Val (6971), Character_Type'Val (6971)),
   (Character_Type'Val (6973), Character_Type'Val (6977)),
   (Character_Type'Val (6979), Character_Type'Val (6980)),
   (Character_Type'Val (7042), Character_Type'Val (7042)),
   (Character_Type'Val (7073), Character_Type'Val (7073)),
   (Character_Type'Val (7078), Character_Type'Val (7079)),
   (Character_Type'Val (7082), Character_Type'Val (7082)),
   (Character_Type'Val (7204), Character_Type'Val (7211)),
   (Character_Type'Val (7220), Character_Type'Val (7221)),
   (Character_Type'Val (7393), Character_Type'Val (7393)),
   (Character_Type'Val (7410), Character_Type'Val (7410)),
   (Character_Type'Val (43043), Character_Type'Val (43044)),
   (Character_Type'Val (43047), Character_Type'Val (43047)),
   (Character_Type'Val (43136), Character_Type'Val (43137)),
   (Character_Type'Val (43188), Character_Type'Val (43203)),
   (Character_Type'Val (43346), Character_Type'Val (43347)),
   (Character_Type'Val (43395), Character_Type'Val (43395)),
   (Character_Type'Val (43444), Character_Type'Val (43445)),
   (Character_Type'Val (43450), Character_Type'Val (43451)),
   (Character_Type'Val (43453), Character_Type'Val (43456)),
   (Character_Type'Val (43567), Character_Type'Val (43568)),
   (Character_Type'Val (43571), Character_Type'Val (43572)),
   (Character_Type'Val (43597), Character_Type'Val (43597)),
   (Character_Type'Val (43643), Character_Type'Val (43643)),
   (Character_Type'Val (44003), Character_Type'Val (44004)),
   (Character_Type'Val (44006), Character_Type'Val (44007)),
   (Character_Type'Val (44009), Character_Type'Val (44010)),
   (Character_Type'Val (44012), Character_Type'Val (44012)),
   (Character_Type'Val (69762), Character_Type'Val (69762)),
   (Character_Type'Val (69808), Character_Type'Val (69810)),
   (Character_Type'Val (69815), Character_Type'Val (69816)),
   (Character_Type'Val (119141), Character_Type'Val (119142)),
   (Character_Type'Val (119149), Character_Type'Val (119154))
   );

   ----------------
   -- Next_Token --
   ----------------

   procedure Next_Token
     (Self : in out Lexer_State; Token : out Lexed_Token)
   is
      Input : constant Text_Access := Self.Input;

      First_Index : Positive;
      --  Index of the first input character for the token to return

      Index : Positive;
      --  Index for the next input character to be analyzed

      Match_Index : Natural;
      --  If we found a match, index for its last character. Otherwise, zero.

      Match_Ignore : Boolean;
      --  If we found a match, whether we must ignore it and restart the
      --  automaton after its character range.

      Match_Kind : Token_Kind;
      --  If we found a match and it is not ignored, kind for the token to
      --  emit. Meaningless otherwise.
   begin
      First_Index := Self.Last_Token.Text_Last + 1;

      <<Start>>
      Index := First_Index;
      Match_Index := 0;
      Match_Ignore := False;



         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#9#) .. Character_Type'Val (16#a#) | Character_Type'Val (16#c#) .. Character_Type'Val (16#d#) | ' ' => goto State_1;
               when '!' => goto State_2;
               when '"' => goto State_3;
               when '#' => goto State_4;
               when '$' => goto State_5;
               when '%' => goto State_6;
               when '&' => goto State_7;
               when ''' => goto State_8;
               when '(' => goto State_9;
               when ')' => goto State_10;
               when '*' => goto State_11;
               when '+' => goto State_12;
               when ',' => goto State_13;
               when '-' => goto State_14;
               when '.' => goto State_15;
               when '/' => goto State_16;
               when '0' .. '9' => goto State_17;
               when ':' => goto State_18;
               when ';' => goto State_19;
               when '<' => goto State_20;
               when '=' => goto State_21;
               when '>' => goto State_22;
               when '@' => goto State_23;
               when 'A' => goto State_24;
               when 'B' .. 'A' | 'C' .. 'B' | 'D' .. 'C' | 'E' .. 'D' | 'F' .. 'E' | 'G' .. 'F' | 'H' | 'J' .. 'K' | 'M' .. 'L' | 'N' .. 'M' | 'O' .. 'N' | 'P' .. 'O' | 'Q' | 'S' .. 'R' | 'T' .. 'S' | 'U' .. 'T' | 'V' | 'X' .. 'W' | 'Y' .. 'Z' => goto State_25;
               when 'B' => goto State_26;
               when 'C' => goto State_27;
               when 'D' => goto State_28;
               when 'E' => goto State_29;
               when 'F' => goto State_30;
               when 'G' => goto State_31;
               when 'I' => goto State_32;
               when 'L' => goto State_33;
               when 'M' => goto State_34;
               when 'N' => goto State_35;
               when 'O' => goto State_36;
               when 'P' => goto State_37;
               when 'R' => goto State_38;
               when 'S' => goto State_39;
               when 'T' => goto State_40;
               when 'U' => goto State_41;
               when 'W' => goto State_42;
               when 'X' => goto State_43;
               when '[' => goto State_44;
               when ']' => goto State_45;
               when 'a' => goto State_46;
               when 'b' .. 'a' | 'c' .. 'b' | 'd' .. 'c' | 'e' .. 'd' | 'f' .. 'e' | 'g' .. 'f' | 'h' | 'j' .. 'k' | 'm' .. 'l' | 'n' .. 'm' | 'o' .. 'n' | 'p' .. 'o' | 'q' | 's' .. 'r' | 't' .. 's' | 'u' .. 't' | 'v' | 'x' .. 'w' | 'y' .. 'z' => goto State_47;
               when 'b' => goto State_48;
               when 'c' => goto State_49;
               when 'd' => goto State_50;
               when 'e' => goto State_51;
               when 'f' => goto State_52;
               when 'g' => goto State_53;
               when 'i' => goto State_54;
               when 'l' => goto State_55;
               when 'm' => goto State_56;
               when 'n' => goto State_57;
               when 'o' => goto State_58;
               when 'p' => goto State_59;
               when 'r' => goto State_60;
               when 's' => goto State_61;
               when 't' => goto State_62;
               when 'u' => goto State_63;
               when 'w' => goto State_64;
               when 'x' => goto State_65;
               when '|' => goto State_66;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_0) then
                        goto State_25;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_47;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_67;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_68;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_69;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_70;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_1>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Whitespace;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#9#) .. Character_Type'Val (16#a#) | Character_Type'Val (16#c#) .. Character_Type'Val (16#d#) | ' ' => goto State_71;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_2>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Pipe;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_3>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. '!' | '#' .. 'Z' | '\' .. Character_Type'Val (16#10ffff#) => goto State_72;
               when '"' => goto State_73;
               when '[' => goto State_74;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_4>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Prep_Line;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. Character_Type'Val (16#10ffff#) => goto State_75;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_5>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when 'A' .. 'Z' => goto State_25;
               when '[' => goto State_76;
               when 'a' .. 'z' => goto State_47;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_0) then
                        goto State_25;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_47;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_67;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_68;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_69;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_70;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_6>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. '$' | '&' .. 'Z' | '\' .. Character_Type'Val (16#10ffff#) => goto State_77;
               when '%' => goto State_78;
               when '[' => goto State_79;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_7>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Amp;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_8>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Tick;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. 'Z' | '\' .. Character_Type'Val (16#10ffff#) => goto State_80;
               when '[' => goto State_81;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_9>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Par_Open;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_10>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Par_Close;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_11>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Mult;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '*' => goto State_82;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_12>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Plus;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_13>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Comma;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_14>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Minus;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '-' => goto State_83;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_15>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Dot;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '.' => goto State_84;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_16>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Divide;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '=' => goto State_85;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_17>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Integer;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '#' | ':' => goto State_86;
               when '.' => goto State_87;
               when '0' .. '9' => goto State_88;
               when 'E' | 'e' => goto State_89;
               when '_' => goto State_90;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_18>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Colon;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '=' => goto State_91;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_19>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Semicolon;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_20>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Lt;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '<' => goto State_92;
               when '=' => goto State_93;
               when '>' => goto State_94;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_21>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Equal;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '>' => goto State_95;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_22>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Gt;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '=' => goto State_96;
               when '>' => goto State_97;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_23>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Target;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_24>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' | 'C' .. 'B' | 'D' .. 'K' | 'M' | 'O' .. 'Q' | 'S' | 'U' .. 'Z' => goto State_99;
               when 'B' => goto State_100;
               when 'C' => goto State_101;
               when 'L' => goto State_102;
               when 'N' => goto State_103;
               when 'R' => goto State_104;
               when 'T' => goto State_105;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' | 'c' .. 'b' | 'd' .. 'k' | 'm' | 'o' .. 'q' | 's' | 'u' .. 'z' => goto State_108;
               when 'b' => goto State_109;
               when 'c' => goto State_110;
               when 'l' => goto State_111;
               when 'n' => goto State_112;
               when 'r' => goto State_113;
               when 't' => goto State_114;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_25>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_26>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'E' => goto State_121;
               when 'O' => goto State_122;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'e' => goto State_123;
               when 'o' => goto State_124;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_27>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_125;
               when 'B' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'O' => goto State_126;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_127;
               when 'b' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'o' => goto State_128;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_28>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'H' | 'J' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'E' => goto State_129;
               when 'I' => goto State_130;
               when 'O' => goto State_131;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'h' | 'j' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'e' => goto State_132;
               when 'i' => goto State_133;
               when 'o' => goto State_134;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_29>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' | 'O' .. 'W' | 'Y' .. 'Z' => goto State_99;
               when 'L' => goto State_135;
               when 'N' => goto State_136;
               when 'X' => goto State_137;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' | 'o' .. 'w' | 'y' .. 'z' => goto State_108;
               when 'l' => goto State_138;
               when 'n' => goto State_139;
               when 'x' => goto State_140;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_30>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'T' | 'V' .. 'Z' => goto State_99;
               when 'O' => goto State_141;
               when 'U' => goto State_142;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 't' | 'v' .. 'z' => goto State_108;
               when 'o' => goto State_143;
               when 'u' => goto State_144;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_31>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'E' => goto State_145;
               when 'O' => goto State_146;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'e' => goto State_147;
               when 'o' => goto State_148;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_32>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'E' | 'G' .. 'M' | 'O' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'F' => goto State_149;
               when 'N' => goto State_150;
               when 'S' => goto State_151;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'e' | 'g' .. 'm' | 'o' .. 'r' | 't' .. 'z' => goto State_108;
               when 'f' => goto State_152;
               when 'n' => goto State_153;
               when 's' => goto State_154;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_33>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'I' => goto State_155;
               when 'O' => goto State_156;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'i' => goto State_157;
               when 'o' => goto State_158;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_34>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'O' => goto State_159;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'o' => goto State_160;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_35>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'N' | 'P' .. 'T' | 'V' .. 'Z' => goto State_99;
               when 'E' => goto State_161;
               when 'O' => goto State_162;
               when 'U' => goto State_163;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'n' | 'p' .. 't' | 'v' .. 'z' => goto State_108;
               when 'e' => goto State_164;
               when 'o' => goto State_165;
               when 'u' => goto State_166;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_36>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'E' | 'G' .. 'Q' | 'S' | 'U' .. 'T' | 'V' .. 'Z' => goto State_99;
               when 'F' => goto State_167;
               when 'R' => goto State_168;
               when 'T' => goto State_169;
               when 'U' => goto State_170;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'e' | 'g' .. 'q' | 's' | 'u' .. 't' | 'v' .. 'z' => goto State_108;
               when 'f' => goto State_171;
               when 'r' => goto State_172;
               when 't' => goto State_173;
               when 'u' => goto State_174;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_37>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_175;
               when 'B' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_176;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_177;
               when 'b' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_178;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_38>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_179;
               when 'B' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_180;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_181;
               when 'b' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_182;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_39>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'T' | 'V' .. 'Z' => goto State_99;
               when 'E' => goto State_183;
               when 'U' => goto State_184;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 't' | 'v' .. 'z' => goto State_108;
               when 'e' => goto State_185;
               when 'u' => goto State_186;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_40>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_187;
               when 'B' .. 'D' | 'F' .. 'G' | 'I' .. 'X' | 'Z' => goto State_99;
               when 'E' => goto State_188;
               when 'H' => goto State_189;
               when 'Y' => goto State_190;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_191;
               when 'b' .. 'd' | 'f' .. 'g' | 'i' .. 'x' | 'z' => goto State_108;
               when 'e' => goto State_192;
               when 'h' => goto State_193;
               when 'y' => goto State_194;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_41>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_195;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_196;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_42>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'G' | 'I' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'H' => goto State_197;
               when 'I' => goto State_198;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'g' | 'i' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'h' => goto State_199;
               when 'i' => goto State_200;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_43>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'O' => goto State_201;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'o' => goto State_202;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_44>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Brack_Open;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_203;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_45>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Brack_Close;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_46>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' | 'C' .. 'B' | 'D' .. 'K' | 'M' | 'O' .. 'Q' | 'S' | 'U' .. 'Z' => goto State_99;
               when 'B' => goto State_100;
               when 'C' => goto State_101;
               when 'L' => goto State_102;
               when 'N' => goto State_103;
               when 'R' => goto State_104;
               when 'T' => goto State_105;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' | 'c' .. 'b' | 'd' .. 'k' | 'm' | 'o' .. 'q' | 's' | 'u' .. 'z' => goto State_108;
               when 'b' => goto State_109;
               when 'c' => goto State_110;
               when 'l' => goto State_111;
               when 'n' => goto State_112;
               when 'r' => goto State_113;
               when 't' => goto State_114;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_47>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_48>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'E' => goto State_121;
               when 'O' => goto State_122;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'e' => goto State_123;
               when 'o' => goto State_124;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_49>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_125;
               when 'B' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'O' => goto State_126;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_127;
               when 'b' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'o' => goto State_128;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_50>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'H' | 'J' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'E' => goto State_129;
               when 'I' => goto State_130;
               when 'O' => goto State_131;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'h' | 'j' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'e' => goto State_132;
               when 'i' => goto State_133;
               when 'o' => goto State_134;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_51>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' | 'O' .. 'W' | 'Y' .. 'Z' => goto State_99;
               when 'L' => goto State_135;
               when 'N' => goto State_136;
               when 'X' => goto State_137;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' | 'o' .. 'w' | 'y' .. 'z' => goto State_108;
               when 'l' => goto State_138;
               when 'n' => goto State_139;
               when 'x' => goto State_140;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_52>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'T' | 'V' .. 'Z' => goto State_99;
               when 'O' => goto State_141;
               when 'U' => goto State_142;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 't' | 'v' .. 'z' => goto State_108;
               when 'o' => goto State_143;
               when 'u' => goto State_144;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_53>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'E' => goto State_145;
               when 'O' => goto State_146;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'e' => goto State_147;
               when 'o' => goto State_148;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_54>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'E' | 'G' .. 'M' | 'O' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'F' => goto State_149;
               when 'N' => goto State_150;
               when 'S' => goto State_151;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'e' | 'g' .. 'm' | 'o' .. 'r' | 't' .. 'z' => goto State_108;
               when 'f' => goto State_152;
               when 'n' => goto State_153;
               when 's' => goto State_154;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_55>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'I' => goto State_155;
               when 'O' => goto State_156;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'i' => goto State_157;
               when 'o' => goto State_158;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_56>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'O' => goto State_159;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'o' => goto State_160;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_57>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'N' | 'P' .. 'T' | 'V' .. 'Z' => goto State_99;
               when 'E' => goto State_161;
               when 'O' => goto State_162;
               when 'U' => goto State_163;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'n' | 'p' .. 't' | 'v' .. 'z' => goto State_108;
               when 'e' => goto State_164;
               when 'o' => goto State_165;
               when 'u' => goto State_166;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_58>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'E' | 'G' .. 'Q' | 'S' | 'U' .. 'T' | 'V' .. 'Z' => goto State_99;
               when 'F' => goto State_167;
               when 'R' => goto State_168;
               when 'T' => goto State_169;
               when 'U' => goto State_170;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'e' | 'g' .. 'q' | 's' | 'u' .. 't' | 'v' .. 'z' => goto State_108;
               when 'f' => goto State_171;
               when 'r' => goto State_172;
               when 't' => goto State_173;
               when 'u' => goto State_174;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_59>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_175;
               when 'B' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_176;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_177;
               when 'b' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_178;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_60>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_179;
               when 'B' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_180;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_181;
               when 'b' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_182;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_61>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'T' | 'V' .. 'Z' => goto State_99;
               when 'E' => goto State_183;
               when 'U' => goto State_184;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 't' | 'v' .. 'z' => goto State_108;
               when 'e' => goto State_185;
               when 'u' => goto State_186;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_62>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_187;
               when 'B' .. 'D' | 'F' .. 'G' | 'I' .. 'X' | 'Z' => goto State_99;
               when 'E' => goto State_188;
               when 'H' => goto State_189;
               when 'Y' => goto State_190;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_191;
               when 'b' .. 'd' | 'f' .. 'g' | 'i' .. 'x' | 'z' => goto State_108;
               when 'e' => goto State_192;
               when 'h' => goto State_193;
               when 'y' => goto State_194;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_63>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_195;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_196;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_64>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'G' | 'I' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'H' => goto State_197;
               when 'I' => goto State_198;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'g' | 'i' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'h' => goto State_199;
               when 'i' => goto State_200;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_65>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'O' => goto State_201;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'o' => goto State_202;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_66>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Pipe;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_67>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_68>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_69>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_70>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_71>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Whitespace;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#9#) .. Character_Type'Val (16#a#) | Character_Type'Val (16#c#) .. Character_Type'Val (16#d#) | ' ' => goto State_71;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_72>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. '!' | '#' .. 'Z' | '\' .. Character_Type'Val (16#10ffff#) => goto State_72;
               when '"' => goto State_73;
               when '[' => goto State_74;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_73>>

               Match_Index := Index - 1;
               Match_Kind := Ada_String;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_204;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_74>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. '!' | '#' .. 'Z' | '\' .. Character_Type'Val (16#10ffff#) => goto State_72;
               when '"' => goto State_205;
               when '[' => goto State_74;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_75>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Prep_Line;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. Character_Type'Val (16#10ffff#) => goto State_206;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_76>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_203;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_77>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. '$' | '&' .. 'Z' | '\' .. Character_Type'Val (16#10ffff#) => goto State_77;
               when '%' => goto State_78;
               when '[' => goto State_79;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_78>>

               Match_Index := Index - 1;
               Match_Kind := Ada_String;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '%' => goto State_207;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_79>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. '!' | '#' .. '$' | '&' .. 'Z' | '\' .. Character_Type'Val (16#10ffff#) => goto State_77;
               when '"' => goto State_208;
               when '%' => goto State_78;
               when '[' => goto State_79;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_80>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when ''' => goto State_209;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_81>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_210;
               when ''' => goto State_209;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_82>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Power;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_83>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Comment;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. Character_Type'Val (16#10ffff#) => goto State_211;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_84>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Doubledot;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_85>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Notequal;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_86>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' | 'A' .. 'Z' | 'a' .. 'z' => goto State_212;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_87>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_213;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_88>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Integer;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '#' | ':' => goto State_86;
               when '.' => goto State_87;
               when '0' .. '9' => goto State_214;
               when 'E' | 'e' => goto State_89;
               when '_' => goto State_215;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_89>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '+' => goto State_216;
               when '-' => goto State_217;
               when '0' .. '9' => goto State_218;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_90>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_219;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_91>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Assign;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_92>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Label_Start;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_93>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Lte;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_94>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Diamond;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_95>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Arrow;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_96>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Gte;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_97>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Label_End;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_98>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_99>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_100>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'O' => goto State_220;
               when 'S' => goto State_221;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 'r' | 't' .. 'z' => goto State_108;
               when 'o' => goto State_222;
               when 's' => goto State_223;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_101>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'Z' => goto State_99;
               when 'C' => goto State_224;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'z' => goto State_108;
               when 'c' => goto State_225;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_102>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' .. 'Z' => goto State_99;
               when 'L' => goto State_226;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' .. 'z' => goto State_108;
               when 'l' => goto State_227;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_103>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'C' | 'E' .. 'Z' => goto State_99;
               when 'D' => goto State_228;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'c' | 'e' .. 'z' => goto State_108;
               when 'd' => goto State_229;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_104>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_230;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_231;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_105>>

               Match_Index := Index - 1;
               Match_Kind := Ada_At;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_106>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_232;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_107>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_108>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_109>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'O' => goto State_220;
               when 'S' => goto State_221;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 'r' | 't' .. 'z' => goto State_108;
               when 'o' => goto State_222;
               when 's' => goto State_223;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_110>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'Z' => goto State_99;
               when 'C' => goto State_224;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'z' => goto State_108;
               when 'c' => goto State_225;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_111>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' .. 'Z' => goto State_99;
               when 'L' => goto State_226;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' .. 'z' => goto State_108;
               when 'l' => goto State_227;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_112>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'C' | 'E' .. 'Z' => goto State_99;
               when 'D' => goto State_228;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'c' | 'e' .. 'z' => goto State_108;
               when 'd' => goto State_229;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_113>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_230;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_231;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_114>>

               Match_Index := Index - 1;
               Match_Kind := Ada_At;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_115>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_116>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_117>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_118>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_119>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_120>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_121>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'F' | 'H' .. 'Z' => goto State_99;
               when 'G' => goto State_233;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'f' | 'h' .. 'z' => goto State_108;
               when 'g' => goto State_234;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_122>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'C' | 'E' .. 'Z' => goto State_99;
               when 'D' => goto State_235;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'c' | 'e' .. 'z' => goto State_108;
               when 'd' => goto State_236;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_123>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'F' | 'H' .. 'Z' => goto State_99;
               when 'G' => goto State_233;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'f' | 'h' .. 'z' => goto State_108;
               when 'g' => goto State_234;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_124>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'C' | 'E' .. 'Z' => goto State_99;
               when 'D' => goto State_235;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'c' | 'e' .. 'z' => goto State_108;
               when 'd' => goto State_236;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_125>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_237;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_238;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_126>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_239;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_240;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_127>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_237;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_238;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_128>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_239;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_240;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_129>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'K' | 'M' .. 'Z' => goto State_99;
               when 'C' => goto State_241;
               when 'L' => goto State_242;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'k' | 'm' .. 'z' => goto State_108;
               when 'c' => goto State_243;
               when 'l' => goto State_244;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_130>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'F' | 'H' .. 'Z' => goto State_99;
               when 'G' => goto State_245;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'f' | 'h' .. 'z' => goto State_108;
               when 'g' => goto State_246;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_131>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Do;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_132>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'K' | 'M' .. 'Z' => goto State_99;
               when 'C' => goto State_241;
               when 'L' => goto State_242;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'k' | 'm' .. 'z' => goto State_108;
               when 'c' => goto State_243;
               when 'l' => goto State_244;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_133>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'F' | 'H' .. 'Z' => goto State_99;
               when 'G' => goto State_245;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'f' | 'h' .. 'z' => goto State_108;
               when 'g' => goto State_246;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_134>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Do;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_135>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_247;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_248;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_136>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'C' | 'E' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'D' => goto State_249;
               when 'T' => goto State_250;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'c' | 'e' .. 's' | 'u' .. 'z' => goto State_108;
               when 'd' => goto State_251;
               when 't' => goto State_252;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_137>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'C' => goto State_253;
               when 'I' => goto State_254;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'c' => goto State_255;
               when 'i' => goto State_256;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_138>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_247;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_248;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_139>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'C' | 'E' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'D' => goto State_249;
               when 'T' => goto State_250;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'c' | 'e' .. 's' | 'u' .. 'z' => goto State_108;
               when 'd' => goto State_251;
               when 't' => goto State_252;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_140>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'C' => goto State_253;
               when 'I' => goto State_254;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'c' => goto State_255;
               when 'i' => goto State_256;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_141>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_257;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_258;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_142>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_259;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_260;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_143>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_257;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_258;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_144>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_259;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_260;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_145>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_261;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_262;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_146>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_263;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_264;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_147>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_261;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_262;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_148>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_263;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_264;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_149>>

               Match_Index := Index - 1;
               Match_Kind := Ada_If;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_150>>

               Match_Index := Index - 1;
               Match_Kind := Ada_In;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_151>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Is;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_152>>

               Match_Index := Index - 1;
               Match_Kind := Ada_If;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_153>>

               Match_Index := Index - 1;
               Match_Kind := Ada_In;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_154>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Is;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_155>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'L' | 'N' .. 'Z' => goto State_99;
               when 'M' => goto State_265;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'l' | 'n' .. 'z' => goto State_108;
               when 'm' => goto State_266;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_156>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'O' => goto State_267;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'o' => goto State_268;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_157>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'L' | 'N' .. 'Z' => goto State_99;
               when 'M' => goto State_265;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'l' | 'n' .. 'z' => goto State_108;
               when 'm' => goto State_266;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_158>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'O' => goto State_267;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'o' => goto State_268;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_159>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'C' | 'E' .. 'Z' => goto State_99;
               when 'D' => goto State_269;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'c' | 'e' .. 'z' => goto State_108;
               when 'd' => goto State_270;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_160>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'C' | 'E' .. 'Z' => goto State_99;
               when 'D' => goto State_269;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'c' | 'e' .. 'z' => goto State_108;
               when 'd' => goto State_270;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_161>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'V' | 'X' .. 'Z' => goto State_99;
               when 'W' => goto State_271;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'v' | 'x' .. 'z' => goto State_108;
               when 'w' => goto State_272;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_162>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_273;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_274;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_163>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' .. 'Z' => goto State_99;
               when 'L' => goto State_275;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' .. 'z' => goto State_108;
               when 'l' => goto State_276;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_164>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'V' | 'X' .. 'Z' => goto State_99;
               when 'W' => goto State_271;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'v' | 'x' .. 'z' => goto State_108;
               when 'w' => goto State_272;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_165>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_273;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_274;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_166>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' .. 'Z' => goto State_99;
               when 'L' => goto State_275;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' .. 'z' => goto State_108;
               when 'l' => goto State_276;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_167>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Of;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_168>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Or;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_169>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'G' | 'I' .. 'Z' => goto State_99;
               when 'H' => goto State_277;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'g' | 'i' .. 'z' => goto State_108;
               when 'h' => goto State_278;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_170>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_279;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_280;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_171>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Of;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_172>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Or;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_173>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'G' | 'I' .. 'Z' => goto State_99;
               when 'H' => goto State_277;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'g' | 'i' .. 'z' => goto State_108;
               when 'h' => goto State_278;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_174>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_279;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_280;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_175>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'Z' => goto State_99;
               when 'C' => goto State_281;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'z' => goto State_108;
               when 'c' => goto State_282;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_176>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_283;
               when 'B' .. 'H' | 'J' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'I' => goto State_284;
               when 'O' => goto State_285;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_286;
               when 'b' .. 'h' | 'j' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'i' => goto State_287;
               when 'o' => goto State_288;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_177>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'Z' => goto State_99;
               when 'C' => goto State_281;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'z' => goto State_108;
               when 'c' => goto State_282;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_178>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_283;
               when 'B' .. 'H' | 'J' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'I' => goto State_284;
               when 'O' => goto State_285;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_286;
               when 'b' .. 'h' | 'j' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'i' => goto State_287;
               when 'o' => goto State_288;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_179>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'I' => goto State_289;
               when 'N' => goto State_290;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'i' => goto State_291;
               when 'n' => goto State_292;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_180>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'L' | 'N' .. 'M' | 'O' .. 'S' | 'U' | 'W' .. 'Z' => goto State_99;
               when 'C' => goto State_293;
               when 'M' => goto State_294;
               when 'N' => goto State_295;
               when 'T' => goto State_296;
               when 'V' => goto State_297;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'l' | 'n' .. 'm' | 'o' .. 's' | 'u' | 'w' .. 'z' => goto State_108;
               when 'c' => goto State_298;
               when 'm' => goto State_299;
               when 'n' => goto State_300;
               when 't' => goto State_301;
               when 'v' => goto State_302;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_181>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'I' => goto State_289;
               when 'N' => goto State_290;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'i' => goto State_291;
               when 'n' => goto State_292;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_182>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'L' | 'N' .. 'M' | 'O' .. 'S' | 'U' | 'W' .. 'Z' => goto State_99;
               when 'C' => goto State_293;
               when 'M' => goto State_294;
               when 'N' => goto State_295;
               when 'T' => goto State_296;
               when 'V' => goto State_297;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'l' | 'n' .. 'm' | 'o' .. 's' | 'u' | 'w' .. 'z' => goto State_108;
               when 'c' => goto State_298;
               when 'm' => goto State_299;
               when 'n' => goto State_300;
               when 't' => goto State_301;
               when 'v' => goto State_302;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_183>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' .. 'O' | 'Q' .. 'Z' => goto State_99;
               when 'L' => goto State_303;
               when 'P' => goto State_304;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' .. 'o' | 'q' .. 'z' => goto State_108;
               when 'l' => goto State_305;
               when 'p' => goto State_306;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_184>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' | 'C' .. 'Z' => goto State_99;
               when 'B' => goto State_307;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' | 'c' .. 'z' => goto State_108;
               when 'b' => goto State_308;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_185>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' .. 'O' | 'Q' .. 'Z' => goto State_99;
               when 'L' => goto State_303;
               when 'P' => goto State_304;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' .. 'o' | 'q' .. 'z' => goto State_108;
               when 'l' => goto State_305;
               when 'p' => goto State_306;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_186>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' | 'C' .. 'Z' => goto State_99;
               when 'B' => goto State_307;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' | 'c' .. 'z' => goto State_108;
               when 'b' => goto State_308;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_187>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_309;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_310;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_188>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_311;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_312;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_189>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_313;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_314;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_190>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'O' | 'Q' .. 'Z' => goto State_99;
               when 'P' => goto State_315;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'o' | 'q' .. 'z' => goto State_108;
               when 'p' => goto State_316;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_191>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_309;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_310;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_192>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_311;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_312;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_193>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_313;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_314;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_194>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'O' | 'Q' .. 'Z' => goto State_99;
               when 'P' => goto State_315;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'o' | 'q' .. 'z' => goto State_108;
               when 'p' => goto State_316;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_195>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_317;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_318;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_196>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_317;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_318;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_197>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'E' => goto State_319;
               when 'I' => goto State_320;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'e' => goto State_321;
               when 'i' => goto State_322;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_198>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_323;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_324;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_199>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'E' => goto State_319;
               when 'I' => goto State_320;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'e' => goto State_321;
               when 'i' => goto State_322;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_200>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_323;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_324;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_201>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_325;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_326;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_202>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_325;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_326;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_203>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_327;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_204>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. '!' | '#' .. 'Z' | '\' .. Character_Type'Val (16#10ffff#) => goto State_72;
               when '"' => goto State_73;
               when '[' => goto State_74;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_205>>

               Match_Index := Index - 1;
               Match_Kind := Ada_String;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_204;
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_328;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_206>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Prep_Line;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. Character_Type'Val (16#10ffff#) => goto State_206;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_207>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. '$' | '&' .. 'Z' | '\' .. Character_Type'Val (16#10ffff#) => goto State_77;
               when '%' => goto State_78;
               when '[' => goto State_79;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_208>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. '$' | '&' .. '/' | ':' .. '@' | 'G' .. 'Z' | '\' .. '`' | 'g' .. Character_Type'Val (16#10ffff#) => goto State_77;
               when '%' => goto State_78;
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_329;
               when '[' => goto State_79;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_209>>

               case Self.Last_Token_Kind is
                     when Ada_Identifier =>
                        Match_Kind := Ada_Tick;
                        Match_Index := Index - 1 - 2;
                     when others =>
                        Match_Kind := Ada_Char;
                        Match_Index := Index - 1 - 0;
               end case;


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         Index := Index + 1;
         goto Stop;

            <<State_210>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_330;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_211>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Comment;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. Character_Type'Val (16#10ffff#) => goto State_331;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_212>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '#' | ':' => goto State_332;
               when '.' => goto State_333;
               when '0' .. '9' | 'A' .. 'Z' | 'a' .. 'z' => goto State_334;
               when '_' => goto State_335;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_213>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Decimal;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_336;
               when 'E' | 'e' => goto State_337;
               when '_' => goto State_338;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_214>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Integer;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '#' | ':' => goto State_86;
               when '.' => goto State_87;
               when '0' .. '9' => goto State_214;
               when 'E' | 'e' => goto State_89;
               when '_' => goto State_215;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_215>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_339;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_216>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_218;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_217>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_218;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_218>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Integer;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_340;
               when '_' => goto State_341;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_219>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Integer;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '#' | ':' => goto State_86;
               when '.' => goto State_87;
               when '0' .. '9' => goto State_88;
               when 'E' | 'e' => goto State_89;
               when '_' => goto State_90;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_220>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_342;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_343;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_221>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Abs;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_222>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_342;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_343;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_223>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Abs;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_224>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_344;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_345;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_225>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_344;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_345;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_226>>

               Match_Index := Index - 1;
               Match_Kind := Ada_All;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_227>>

               Match_Index := Index - 1;
               Match_Kind := Ada_All;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_228>>

               Match_Index := Index - 1;
               Match_Kind := Ada_And;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_229>>

               Match_Index := Index - 1;
               Match_Kind := Ada_And;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_230>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_346;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_347;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_231>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_346;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_347;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_232>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_348;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_233>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'I' => goto State_349;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'i' => goto State_350;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_234>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'I' => goto State_349;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'i' => goto State_350;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_235>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'X' | 'Z' => goto State_99;
               when 'Y' => goto State_351;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'x' | 'z' => goto State_108;
               when 'y' => goto State_352;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_236>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'X' | 'Z' => goto State_99;
               when 'Y' => goto State_351;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'x' | 'z' => goto State_108;
               when 'y' => goto State_352;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_237>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_353;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_354;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_238>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_353;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_354;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_239>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_355;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_356;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_240>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_355;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_356;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_241>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' .. 'Z' => goto State_99;
               when 'L' => goto State_357;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' .. 'z' => goto State_108;
               when 'l' => goto State_358;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_242>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_359;
               when 'B' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_360;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_361;
               when 'b' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_362;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_243>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' .. 'Z' => goto State_99;
               when 'L' => goto State_357;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' .. 'z' => goto State_108;
               when 'l' => goto State_358;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_244>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_359;
               when 'B' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_360;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_361;
               when 'b' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_362;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_245>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'I' => goto State_363;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'i' => goto State_364;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_246>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'I' => goto State_363;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'i' => goto State_364;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_247>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'E' => goto State_365;
               when 'I' => goto State_366;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'e' => goto State_367;
               when 'i' => goto State_368;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_248>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'E' => goto State_365;
               when 'I' => goto State_366;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'e' => goto State_367;
               when 'i' => goto State_368;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_249>>

               Match_Index := Index - 1;
               Match_Kind := Ada_End;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_250>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_369;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_370;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_251>>

               Match_Index := Index - 1;
               Match_Kind := Ada_End;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_252>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_369;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_370;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_253>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_371;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_372;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_254>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_373;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_374;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_255>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_371;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_372;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_256>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_373;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_374;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_257>>

               Match_Index := Index - 1;
               Match_Kind := Ada_For;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_258>>

               Match_Index := Index - 1;
               Match_Kind := Ada_For;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_259>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'Z' => goto State_99;
               when 'C' => goto State_375;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'z' => goto State_108;
               when 'c' => goto State_376;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_260>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'Z' => goto State_99;
               when 'C' => goto State_375;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'z' => goto State_108;
               when 'c' => goto State_376;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_261>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_377;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_378;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_262>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_377;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_378;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_263>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'O' => goto State_379;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'o' => goto State_380;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_264>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'O' => goto State_379;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'o' => goto State_380;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_265>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'I' => goto State_381;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'i' => goto State_382;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_266>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'I' => goto State_381;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'i' => goto State_382;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_267>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'O' | 'Q' .. 'Z' => goto State_99;
               when 'P' => goto State_383;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'o' | 'q' .. 'z' => goto State_108;
               when 'p' => goto State_384;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_268>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'O' | 'Q' .. 'Z' => goto State_99;
               when 'P' => goto State_383;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'o' | 'q' .. 'z' => goto State_108;
               when 'p' => goto State_384;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_269>>

               case Self.Last_Token_Kind is
                     when Ada_Tick =>
                        Match_Kind := Ada_Identifier;
                        Match_Index := Index - 1 - 0;
                     when others =>
                        Match_Kind := Ada_Mod;
                        Match_Index := Index - 1 - 0;
               end case;


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_270>>

               case Self.Last_Token_Kind is
                     when Ada_Tick =>
                        Match_Kind := Ada_Identifier;
                        Match_Index := Index - 1 - 0;
                     when others =>
                        Match_Kind := Ada_Mod;
                        Match_Index := Index - 1 - 0;
               end case;


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_271>>

               Match_Index := Index - 1;
               Match_Kind := Ada_New;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_272>>

               Match_Index := Index - 1;
               Match_Kind := Ada_New;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_273>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Not;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_274>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Not;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_275>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' .. 'Z' => goto State_99;
               when 'L' => goto State_385;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' .. 'z' => goto State_108;
               when 'l' => goto State_386;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_276>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' .. 'Z' => goto State_99;
               when 'L' => goto State_385;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' .. 'z' => goto State_108;
               when 'l' => goto State_386;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_277>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_387;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_388;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_278>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_387;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_388;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_279>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Out;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_280>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Out;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_281>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'J' | 'L' .. 'Z' => goto State_99;
               when 'K' => goto State_389;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'j' | 'l' .. 'z' => goto State_108;
               when 'k' => goto State_390;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_282>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'J' | 'L' .. 'Z' => goto State_99;
               when 'K' => goto State_389;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'j' | 'l' .. 'z' => goto State_108;
               when 'k' => goto State_390;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_283>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'F' | 'H' .. 'Z' => goto State_99;
               when 'G' => goto State_391;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'f' | 'h' .. 'z' => goto State_108;
               when 'g' => goto State_392;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_284>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'U' | 'W' .. 'Z' => goto State_99;
               when 'V' => goto State_393;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'u' | 'w' .. 'z' => goto State_108;
               when 'v' => goto State_394;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_285>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'Z' => goto State_99;
               when 'C' => goto State_395;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'z' => goto State_108;
               when 'c' => goto State_396;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_286>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'F' | 'H' .. 'Z' => goto State_99;
               when 'G' => goto State_391;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'f' | 'h' .. 'z' => goto State_108;
               when 'g' => goto State_392;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_287>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'U' | 'W' .. 'Z' => goto State_99;
               when 'V' => goto State_393;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'u' | 'w' .. 'z' => goto State_108;
               when 'v' => goto State_394;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_288>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'Z' => goto State_99;
               when 'C' => goto State_395;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'z' => goto State_108;
               when 'c' => goto State_396;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_289>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_397;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_398;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_290>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'F' | 'H' .. 'Z' => goto State_99;
               when 'G' => goto State_399;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'f' | 'h' .. 'z' => goto State_108;
               when 'g' => goto State_400;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_291>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_397;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_398;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_292>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'F' | 'H' .. 'Z' => goto State_99;
               when 'G' => goto State_399;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'f' | 'h' .. 'z' => goto State_108;
               when 'g' => goto State_400;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_293>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'O' => goto State_401;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'o' => goto State_402;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_294>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Rem;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_295>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_403;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_404;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_296>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'T' | 'V' .. 'Z' => goto State_99;
               when 'U' => goto State_405;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 't' | 'v' .. 'z' => goto State_108;
               when 'u' => goto State_406;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_297>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_407;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_408;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_298>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'N' | 'P' .. 'Z' => goto State_99;
               when 'O' => goto State_401;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'n' | 'p' .. 'z' => goto State_108;
               when 'o' => goto State_402;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_299>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Rem;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_300>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_403;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_404;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_301>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'T' | 'V' .. 'Z' => goto State_99;
               when 'U' => goto State_405;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 't' | 'v' .. 'z' => goto State_108;
               when 'u' => goto State_406;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_302>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_407;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_408;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_303>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_409;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_410;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_304>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_411;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_412;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_305>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_409;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_410;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_306>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_411;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_412;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_307>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_413;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_414;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_308>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_413;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_414;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_309>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'J' | 'L' .. 'Z' => goto State_99;
               when 'K' => goto State_415;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'j' | 'l' .. 'z' => goto State_108;
               when 'k' => goto State_416;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_310>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'J' | 'L' .. 'Z' => goto State_99;
               when 'K' => goto State_415;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'j' | 'l' .. 'z' => goto State_108;
               when 'k' => goto State_416;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_311>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'L' | 'N' .. 'Z' => goto State_99;
               when 'M' => goto State_417;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'l' | 'n' .. 'z' => goto State_108;
               when 'm' => goto State_418;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_312>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'L' | 'N' .. 'Z' => goto State_99;
               when 'M' => goto State_417;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'l' | 'n' .. 'z' => goto State_108;
               when 'm' => goto State_418;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_313>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_419;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_420;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_314>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_419;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_420;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_315>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_421;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_422;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_316>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_421;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_422;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_317>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Use;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_318>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Use;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_319>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_423;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_424;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_320>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' .. 'Z' => goto State_99;
               when 'L' => goto State_425;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' .. 'z' => goto State_108;
               when 'l' => goto State_426;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_321>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_423;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_424;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_322>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'K' | 'M' .. 'Z' => goto State_99;
               when 'L' => goto State_425;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'k' | 'm' .. 'z' => goto State_108;
               when 'l' => goto State_426;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_323>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'G' | 'I' .. 'Z' => goto State_99;
               when 'H' => goto State_427;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'g' | 'i' .. 'z' => goto State_108;
               when 'h' => goto State_428;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_324>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'G' | 'I' .. 'Z' => goto State_99;
               when 'H' => goto State_427;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'g' | 'i' .. 'z' => goto State_108;
               when 'h' => goto State_428;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_325>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Xor;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_326>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Xor;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_327>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_429;
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_430;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_328>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_431;
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_432;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_329>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. '!' | '#' .. '$' | '&' .. '/' | ':' .. '@' | 'G' .. 'Z' | '\' .. '`' | 'g' .. Character_Type'Val (16#10ffff#) => goto State_77;
               when '"' => goto State_433;
               when '%' => goto State_78;
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_434;
               when '[' => goto State_79;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_330>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_435;
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_436;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_331>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Comment;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. Character_Type'Val (16#10ffff#) => goto State_331;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_332>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Integer;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when 'E' | 'e' => goto State_437;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_333>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' | 'A' .. 'Z' | 'a' .. 'z' => goto State_438;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_334>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '#' | ':' => goto State_332;
               when '.' => goto State_333;
               when '0' .. '9' | 'A' .. 'Z' | 'a' .. 'z' => goto State_334;
               when '_' => goto State_335;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_335>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' | 'A' .. 'Z' | 'a' .. 'z' => goto State_334;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_336>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Decimal;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_336;
               when 'E' | 'e' => goto State_337;
               when '_' => goto State_338;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_337>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '+' => goto State_439;
               when '-' => goto State_440;
               when '0' .. '9' => goto State_441;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_338>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_336;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_339>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Integer;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '#' | ':' => goto State_86;
               when '.' => goto State_87;
               when '0' .. '9' => goto State_214;
               when 'E' | 'e' => goto State_89;
               when '_' => goto State_215;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_340>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Integer;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_340;
               when '_' => goto State_341;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_341>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_340;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_342>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_442;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_443;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_343>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_442;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_443;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_344>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'O' | 'Q' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'P' => goto State_444;
               when 'S' => goto State_445;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'o' | 'q' .. 'r' | 't' .. 'z' => goto State_108;
               when 'p' => goto State_446;
               when 's' => goto State_447;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_345>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'O' | 'Q' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'P' => goto State_444;
               when 'S' => goto State_445;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'o' | 'q' .. 'r' | 't' .. 'z' => goto State_108;
               when 'p' => goto State_446;
               when 's' => goto State_447;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_346>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'X' | 'Z' => goto State_99;
               when 'Y' => goto State_448;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'x' | 'z' => goto State_108;
               when 'y' => goto State_449;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_347>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'X' | 'Z' => goto State_99;
               when 'Y' => goto State_448;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'x' | 'z' => goto State_108;
               when 'y' => goto State_449;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_348>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_450;
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_451;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_349>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_452;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_453;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_350>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_452;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_453;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_351>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Body;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_352>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Body;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_353>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Case;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_354>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Case;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_355>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_454;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_455;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_356>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_454;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_455;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_357>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_456;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_457;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_358>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_456;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_457;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_359>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'X' | 'Z' => goto State_99;
               when 'Y' => goto State_458;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'x' | 'z' => goto State_108;
               when 'y' => goto State_459;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_360>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_460;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_461;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_361>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'X' | 'Z' => goto State_99;
               when 'Y' => goto State_458;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'x' | 'z' => goto State_108;
               when 'y' => goto State_459;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_362>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_460;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_461;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_363>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_462;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_463;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_364>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_462;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_463;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_365>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Else;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_366>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'E' | 'G' .. 'Z' => goto State_99;
               when 'F' => goto State_464;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'e' | 'g' .. 'z' => goto State_108;
               when 'f' => goto State_465;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_367>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Else;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_368>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'E' | 'G' .. 'Z' => goto State_99;
               when 'F' => goto State_464;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'e' | 'g' .. 'z' => goto State_108;
               when 'f' => goto State_465;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_369>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'X' | 'Z' => goto State_99;
               when 'Y' => goto State_466;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'x' | 'z' => goto State_108;
               when 'y' => goto State_467;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_370>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'X' | 'Z' => goto State_99;
               when 'Y' => goto State_466;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'x' | 'z' => goto State_108;
               when 'y' => goto State_467;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_371>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'O' | 'Q' .. 'Z' => goto State_99;
               when 'P' => goto State_468;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'o' | 'q' .. 'z' => goto State_108;
               when 'p' => goto State_469;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_372>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'O' | 'Q' .. 'Z' => goto State_99;
               when 'P' => goto State_468;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'o' | 'q' .. 'z' => goto State_108;
               when 'p' => goto State_469;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_373>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Exit;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_374>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Exit;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_375>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_470;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_471;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_376>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_470;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_471;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_377>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_472;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_473;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_378>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_472;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_473;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_379>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Goto;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_380>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Goto;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_381>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_474;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_475;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_382>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_474;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_475;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_383>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Loop;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_384>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Loop;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_385>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Null;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_386>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Null;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_387>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_476;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_477;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_388>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_476;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_477;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_389>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_478;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_479;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_390>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_478;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_479;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_391>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'L' | 'N' .. 'Z' => goto State_99;
               when 'M' => goto State_480;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'l' | 'n' .. 'z' => goto State_108;
               when 'm' => goto State_481;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_392>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'L' | 'N' .. 'Z' => goto State_99;
               when 'M' => goto State_480;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'l' | 'n' .. 'z' => goto State_108;
               when 'm' => goto State_481;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_393>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_482;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_483;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_394>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_482;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_483;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_395>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_484;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_485;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_396>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_484;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_485;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_397>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_486;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_487;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_398>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_486;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_487;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_399>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_488;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_489;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_400>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_488;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_489;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_401>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_490;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_491;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_402>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_490;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_491;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_403>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'L' | 'N' .. 'Z' => goto State_99;
               when 'M' => goto State_492;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'l' | 'n' .. 'z' => goto State_108;
               when 'm' => goto State_493;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_404>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'L' | 'N' .. 'Z' => goto State_99;
               when 'M' => goto State_492;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'l' | 'n' .. 'z' => goto State_108;
               when 'm' => goto State_493;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_405>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_494;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_495;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_406>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_494;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_495;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_407>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_496;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_497;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_408>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_496;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_497;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_409>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'Z' => goto State_99;
               when 'C' => goto State_498;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'z' => goto State_108;
               when 'c' => goto State_499;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_410>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'B' | 'D' .. 'Z' => goto State_99;
               when 'C' => goto State_498;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'b' | 'd' .. 'z' => goto State_108;
               when 'c' => goto State_499;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_411>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_500;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_501;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_412>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_500;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_501;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_413>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'X' | 'Z' => goto State_99;
               when 'Y' => goto State_502;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'x' | 'z' => goto State_108;
               when 'y' => goto State_503;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_414>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'X' | 'Z' => goto State_99;
               when 'Y' => goto State_502;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'x' | 'z' => goto State_108;
               when 'y' => goto State_503;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_415>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Task;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_416>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Task;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_417>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'I' => goto State_504;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'i' => goto State_505;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_418>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'I' => goto State_504;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'i' => goto State_505;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_419>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Then;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_420>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Then;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_421>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Type;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_422>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Type;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_423>>

               Match_Index := Index - 1;
               Match_Kind := Ada_When;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_424>>

               Match_Index := Index - 1;
               Match_Kind := Ada_When;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_425>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_506;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_507;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_426>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_506;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_507;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_427>>

               Match_Index := Index - 1;
               Match_Kind := Ada_With;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_428>>

               Match_Index := Index - 1;
               Match_Kind := Ada_With;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_429>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when ']' => goto State_508;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_430>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_429;
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_430;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_431>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when ']' => goto State_509;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_432>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_431;
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_432;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_433>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. '$' | '&' .. 'Z' | '\' | '^' .. Character_Type'Val (16#10ffff#) => goto State_77;
               when '%' => goto State_78;
               when '[' => goto State_79;
               when ']' => goto State_510;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_434>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when Character_Type'Val (16#0#) .. Character_Type'Val (16#9#) | Character_Type'Val (16#b#) .. '!' | '#' .. '$' | '&' .. '/' | ':' .. '@' | 'G' .. 'Z' | '\' .. '`' | 'g' .. Character_Type'Val (16#10ffff#) => goto State_77;
               when '"' => goto State_433;
               when '%' => goto State_78;
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_434;
               when '[' => goto State_79;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_435>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when ']' => goto State_511;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_436>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_435;
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_436;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_437>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '+' => goto State_512;
               when '-' => goto State_513;
               when '0' .. '9' => goto State_514;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_438>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '#' | ':' => goto State_515;
               when '0' .. '9' | 'A' .. 'Z' | 'a' .. 'z' => goto State_516;
               when '_' => goto State_517;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_439>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_441;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_440>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_441;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_441>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Decimal;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_518;
               when '_' => goto State_519;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_442>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Abort;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_443>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Abort;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_444>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_520;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_521;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_445>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_522;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_523;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_446>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_520;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_521;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_447>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_522;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_523;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_448>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Array;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_449>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Array;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_450>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when ']' => goto State_524;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_451>>


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '"' => goto State_450;
               when '0' .. '9' | 'A' .. 'F' | 'a' .. 'f' => goto State_451;

            when others =>

               goto Stop;
            end case;
         end;

            <<State_452>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Begin;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_453>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Begin;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_454>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_525;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_526;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_455>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_525;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_526;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_456>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_527;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_528;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_457>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Q' | 'S' .. 'Z' => goto State_99;
               when 'R' => goto State_527;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'q' | 's' .. 'z' => goto State_108;
               when 'r' => goto State_528;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_458>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Delay;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_459>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Delay;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_460>>

               case Self.Last_Token_Kind is
                     when Ada_Tick =>
                        Match_Kind := Ada_Identifier;
                        Match_Index := Index - 1 - 0;
                     when others =>
                        Match_Kind := Ada_Delta;
                        Match_Index := Index - 1 - 0;
               end case;


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_461>>

               case Self.Last_Token_Kind is
                     when Ada_Tick =>
                        Match_Kind := Ada_Identifier;
                        Match_Index := Index - 1 - 0;
                     when others =>
                        Match_Kind := Ada_Delta;
                        Match_Index := Index - 1 - 0;
               end case;


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_462>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_529;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_530;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_463>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_529;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_530;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_464>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Elsif;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_465>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Elsif;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_466>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Entry;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_467>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Entry;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_468>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_531;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_532;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_469>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_531;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_532;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_470>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'I' => goto State_533;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'i' => goto State_534;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_471>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'I' => goto State_533;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'i' => goto State_534;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_472>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'I' => goto State_535;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'i' => goto State_536;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_473>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'H' | 'J' .. 'Z' => goto State_99;
               when 'I' => goto State_535;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'h' | 'j' .. 'z' => goto State_108;
               when 'i' => goto State_536;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_474>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_537;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_538;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_475>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_537;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_538;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_476>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_539;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_540;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_477>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_539;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_540;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_478>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'F' | 'H' .. 'Z' => goto State_99;
               when 'G' => goto State_541;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'f' | 'h' .. 'z' => goto State_108;
               when 'g' => goto State_542;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_479>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'F' | 'H' .. 'Z' => goto State_99;
               when 'G' => goto State_541;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'f' | 'h' .. 'z' => goto State_108;
               when 'g' => goto State_542;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_480>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_543;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_544;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_481>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_543;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_544;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_482>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_545;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_546;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_483>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_545;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_546;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_484>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'C' | 'E' .. 'Z' => goto State_99;
               when 'D' => goto State_547;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'c' | 'e' .. 'z' => goto State_108;
               when 'd' => goto State_548;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_485>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'C' | 'E' .. 'Z' => goto State_99;
               when 'D' => goto State_547;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'c' | 'e' .. 'z' => goto State_108;
               when 'd' => goto State_548;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_486>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Raise;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_487>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Raise;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_488>>

               case Self.Last_Token_Kind is
                     when Ada_Tick =>
                        Match_Kind := Ada_Identifier;
                        Match_Index := Index - 1 - 0;
                     when others =>
                        Match_Kind := Ada_Range;
                        Match_Index := Index - 1 - 0;
               end case;


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_489>>

               case Self.Last_Token_Kind is
                     when Ada_Tick =>
                        Match_Kind := Ada_Identifier;
                        Match_Index := Index - 1 - 0;
                     when others =>
                        Match_Kind := Ada_Range;
                        Match_Index := Index - 1 - 0;
               end case;


         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_490>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'C' | 'E' .. 'Z' => goto State_99;
               when 'D' => goto State_549;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'c' | 'e' .. 'z' => goto State_108;
               when 'd' => goto State_550;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_491>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'C' | 'E' .. 'Z' => goto State_99;
               when 'D' => goto State_549;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'c' | 'e' .. 'z' => goto State_108;
               when 'd' => goto State_550;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_492>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_551;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_552;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_493>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'D' | 'F' .. 'Z' => goto State_99;
               when 'E' => goto State_551;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'd' | 'f' .. 'z' => goto State_108;
               when 'e' => goto State_552;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_494>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_553;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_554;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_495>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_553;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_554;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_496>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_555;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_556;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_497>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'R' | 'T' .. 'Z' => goto State_99;
               when 'S' => goto State_555;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'r' | 't' .. 'z' => goto State_108;
               when 's' => goto State_556;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_498>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_557;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_558;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_499>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'S' | 'U' .. 'Z' => goto State_99;
               when 'T' => goto State_557;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 's' | 'u' .. 'z' => goto State_108;
               when 't' => goto State_558;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_500>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_559;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_560;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_501>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' => goto State_559;
               when 'B' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' => goto State_560;
               when 'b' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_502>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'O' | 'Q' .. 'Z' => goto State_99;
               when 'P' => goto State_561;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'o' | 'q' .. 'z' => goto State_108;
               when 'p' => goto State_562;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_503>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'O' | 'Q' .. 'Z' => goto State_99;
               when 'P' => goto State_561;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'o' | 'q' .. 'z' => goto State_108;
               when 'p' => goto State_562;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_504>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_563;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_564;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_505>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'M' | 'O' .. 'Z' => goto State_99;
               when 'N' => goto State_563;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'm' | 'o' .. 'z' => goto State_108;
               when 'n' => goto State_564;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_506>>

               Match_Index := Index - 1;
               Match_Kind := Ada_While;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_507>>

               Match_Index := Index - 1;
               Match_Kind := Ada_While;

         if Index > Self.Input_Last then
            goto Stop;
         end if;

         declare
            Input_Char : constant Character_Type := Input (Index);
         begin
            Index := Index + 1;

            case Input_Char is
               when '0' .. '9' => goto State_98;
               when 'A' .. 'Z' => goto State_99;
               when '[' => goto State_106;
               when '_' => goto State_107;
               when 'a' .. 'z' => goto State_108;

            when others =>
               if Input_Char > Character_Type'Val (127) then
                     if Contains (Input_Char, Ranges_6) then
                        goto State_98;
                     end if;
                     if Contains (Input_Char, Ranges_0) then
                        goto State_99;
                     end if;
                     if Contains (Input_Char, Ranges_1) then
                        goto State_108;
                     end if;
                     if Contains (Input_Char, Ranges_2) then
                        goto State_115;
                     end if;
                     if Contains (Input_Char, Ranges_3) then
                        goto State_116;
                     end if;
                     if Contains (Input_Char, Ranges_4) then
                        goto State_117;
                     end if;
                     if Contains (Input_Char, Ranges_7) then
                        goto State_118;
                     end if;
                     if Contains (Input_Char, Ranges_8) then
                        goto State_119;
                     end if;
                     if Contains (Input_Char, Ranges_5) then
                        goto State_120;
                     end if;
               end if;

               goto Stop;
            end case;
         end;

            <<State_508>>

               Match_Index := Index - 1;
               Match_Kind := Ada_Identifier;

         if 