#version 110
// Need to enable the draw buffers extension
#extension GL_ARB_draw_buffers : enable 

varying vec4 oColor;
varying vec2 oDepth;
varying vec4 oWp;
uniform vec4 slicePlane;

vec4 pack(float value)
{
  vec4 shift = vec4(256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0);
  vec4 mask = vec4(0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);
  vec4 ret = fract(value * shift);
  ret -= ret.xxyz * mask;
  return ret.wzyx;
}

void main()
{
  if(((slicePlane.x + slicePlane.y + slicePlane.z) != 0.0) && (slicePlane.x * oWp.x + slicePlane.y * oWp.y + slicePlane.z * oWp.z + slicePlane.w > 0.0))
    discard;
  
  gl_FragData[0] = oColor;
  gl_FragData[1] = pack(oDepth.x / oDepth.y);
}
