/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.RGBColorSpace;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/ajalt/colormath/model/PqNonlinearity;", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "()V", "c1", "", "c2", "c3", "lp", "m1", "m1d", "m2", "m2d", "eotf", "", "x", "oetf", "colormath"})
final class PqNonlinearity
implements RGBColorSpace.TransferFunctions {
    @NotNull
    public static final PqNonlinearity INSTANCE = new PqNonlinearity();
    private static final double m1 = 0.1593017578125;
    private static final double m2 = 78.84375;
    private static final double c1 = 0.8359375;
    private static final double c2 = 18.8515625;
    private static final double c3 = 18.6875;
    private static final double lp = 10000.0;
    private static final double m1d = 6.277394636015326;
    private static final double m2d = 0.012683313515655966;

    private PqNonlinearity() {
    }

    @Override
    public float eotf(float x) {
        double vp = InternalMathKt.spow(x, 0.012683313515655966);
        double n = RangesKt.coerceAtLeast(vp - 0.8359375, 0.0);
        double l = InternalMathKt.spow(n / (18.8515625 - 18.6875 * vp), 6.277394636015326);
        return (float)(10000.0 * l);
    }

    @Override
    public float oetf(float x) {
        double yp = InternalMathKt.spow((double)x / 10000.0, 0.1593017578125);
        return (float)InternalMathKt.spow((0.8359375 + 18.8515625 * yp) / (1.0 + 18.6875 * yp), 78.84375);
    }
}

