%feature("docstring") OT::PiecewiseHermiteEvaluation
"Piecewise Hermite interpolation evaluation.

Parameters
----------
locations : sequence of float
    Locations
values : 1-d or 2-d sequence of float
    Values at each location
derivatives : 1-d or 2-d sequence of float
    Derivatives at each location

See also
--------
PiecewiseLinearEvaluation

Examples
--------
>>> import openturns as ot
>>> locations = [1.0, 2.0, 3.0, 4.0, 5.0]
>>> values = [-2.0, 2.0, 1.0, 3.0, 5.0]
>>> derivatives = [0.0]*5
>>> evaluation = ot.PiecewiseHermiteEvaluation(locations, values, derivatives)
>>> f = ot.Function(evaluation)
>>> print(f([2.5]))
[1.5]"
