#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsetdebugterminal_ PETSCSETDEBUGTERMINAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsetdebugterminal_ petscsetdebugterminal
#endif
PETSC_EXTERN void petscsetdebugterminal_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscSetDebugTerminal(c_a);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsetdebugger_ PETSCSETDEBUGGER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsetdebugger_ petscsetdebugger
#endif
PETSC_EXTERN void petscsetdebugger_(char a[], PetscBool *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscSetDebugger(c_a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsetdefaultdebugger_ PETSCSETDEFAULTDEBUGGER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsetdefaultdebugger_ petscsetdefaultdebugger
#endif
PETSC_EXTERN void petscsetdefaultdebugger_(PetscErrorCode *ierr)
{
  *ierr = PetscSetDefaultDebugger();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsetdebuggerfromstring_ PETSCSETDEBUGGERFROMSTRING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsetdebuggerfromstring_ petscsetdebuggerfromstring
#endif
PETSC_EXTERN void petscsetdebuggerfromstring_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscSetDebuggerFromString(c_a);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscwaitonerror_ PETSCWAITONERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscwaitonerror_ petscwaitonerror
#endif
PETSC_EXTERN void petscwaitonerror_(PetscErrorCode *ierr)
{
  *ierr = PetscWaitOnError();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscattachdebugger_ PETSCATTACHDEBUGGER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscattachdebugger_ petscattachdebugger
#endif
PETSC_EXTERN void petscattachdebugger_(PetscErrorCode *ierr)
{
  *ierr = PetscAttachDebugger();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscstopfordebugger_ PETSCSTOPFORDEBUGGER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscstopfordebugger_ petscstopfordebugger
#endif
PETSC_EXTERN void petscstopfordebugger_(PetscErrorCode *ierr)
{
  *ierr = PetscStopForDebugger();
  if (*ierr) return;
}
