#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscheapcreate_ PETSCHEAPCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscheapcreate_ petscheapcreate
#endif
PETSC_EXTERN void petscheapcreate_(PetscInt *a, PetscHeap *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscHeapCreate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscheapadd_ PETSCHEAPADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscheapadd_ petscheapadd
#endif
PETSC_EXTERN void petscheapadd_(PetscHeap *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscHeapAdd(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscheappop_ PETSCHEAPPOP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscheappop_ petscheappop
#endif
PETSC_EXTERN void petscheappop_(PetscHeap *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscHeapPop(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscheappeek_ PETSCHEAPPEEK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscheappeek_ petscheappeek
#endif
PETSC_EXTERN void petscheappeek_(PetscHeap *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscHeapPeek(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscheapstash_ PETSCHEAPSTASH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscheapstash_ petscheapstash
#endif
PETSC_EXTERN void petscheapstash_(PetscHeap *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = PetscHeapStash(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscheapunstash_ PETSCHEAPUNSTASH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscheapunstash_ petscheapunstash
#endif
PETSC_EXTERN void petscheapunstash_(PetscHeap *a, PetscErrorCode *ierr)
{
  *ierr = PetscHeapUnstash(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscheapdestroy_ PETSCHEAPDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscheapdestroy_ petscheapdestroy
#endif
PETSC_EXTERN void petscheapdestroy_(PetscHeap *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscHeapDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscheapview_ PETSCHEAPVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscheapview_ petscheapview
#endif
PETSC_EXTERN void petscheapview_(PetscHeap *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscHeapView(*a, v_b);
  if (*ierr) return;
}
