#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taotesthessian_ TAOTESTHESSIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taotesthessian_ taotesthessian
#endif
PETSC_EXTERN void taotesthessian_(Tao *a, PetscErrorCode *ierr)
{
  *ierr = TaoTestHessian(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputehessian_ TAOCOMPUTEHESSIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputehessian_ taocomputehessian
#endif
PETSC_EXTERN void taocomputehessian_(Tao *a, Vec *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = TaoComputeHessian(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputejacobian_ TAOCOMPUTEJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputejacobian_ taocomputejacobian
#endif
PETSC_EXTERN void taocomputejacobian_(Tao *a, Vec *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = TaoComputeJacobian(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputeresidualjacobian_ TAOCOMPUTERESIDUALJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputeresidualjacobian_ taocomputeresidualjacobian
#endif
PETSC_EXTERN void taocomputeresidualjacobian_(Tao *a, Vec *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = TaoComputeResidualJacobian(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputejacobianstate_ TAOCOMPUTEJACOBIANSTATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputejacobianstate_ taocomputejacobianstate
#endif
PETSC_EXTERN void taocomputejacobianstate_(Tao *a, Vec *b, Mat *c, Mat *d, Mat *e, PetscErrorCode *ierr)
{
  *ierr = TaoComputeJacobianState(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputejacobiandesign_ TAOCOMPUTEJACOBIANDESIGN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputejacobiandesign_ taocomputejacobiandesign
#endif
PETSC_EXTERN void taocomputejacobiandesign_(Tao *a, Vec *b, Mat *c, PetscErrorCode *ierr)
{
  *ierr = TaoComputeJacobianDesign(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetstatedesignis_ TAOSETSTATEDESIGNIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetstatedesignis_ taosetstatedesignis
#endif
PETSC_EXTERN void taosetstatedesignis_(Tao *a, IS *b, IS *c, PetscErrorCode *ierr)
{
  *ierr = TaoSetStateDesignIS(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputejacobianequality_ TAOCOMPUTEJACOBIANEQUALITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputejacobianequality_ taocomputejacobianequality
#endif
PETSC_EXTERN void taocomputejacobianequality_(Tao *a, Vec *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = TaoComputeJacobianEquality(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputejacobianinequality_ TAOCOMPUTEJACOBIANINEQUALITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputejacobianinequality_ taocomputejacobianinequality
#endif
PETSC_EXTERN void taocomputejacobianinequality_(Tao *a, Vec *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = TaoComputeJacobianInequality(*a, *b, *c, *d);
  if (*ierr) return;
}
