#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectsview_ PETSCOBJECTSVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectsview_ petscobjectsview
#endif
PETSC_EXTERN void petscobjectsview_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscObjectsView(v_a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectsgetobject_ PETSCOBJECTSGETOBJECT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectsgetobject_ petscobjectsgetobject
#endif
PETSC_EXTERN void petscobjectsgetobject_(char a[], PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  char* c_c = PETSC_NULLPTR;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscObjectsGetObject(c_a, b, (const char **)&c_c);
  if (*ierr) return;
  FREECHAR(a, c_a);
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectsetprintedoptions_ PETSCOBJECTSETPRINTEDOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectsetprintedoptions_ petscobjectsetprintedoptions
#endif
PETSC_EXTERN void petscobjectsetprintedoptions_(PetscObject *a, PetscErrorCode *ierr)
{
  *ierr = PetscObjectSetPrintedOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectinheritprintedoptions_ PETSCOBJECTINHERITPRINTEDOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectinheritprintedoptions_ petscobjectinheritprintedoptions
#endif
PETSC_EXTERN void petscobjectinheritprintedoptions_(PetscObject *a, PetscObject *b, PetscErrorCode *ierr)
{
  *ierr = PetscObjectInheritPrintedOptions(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectprocessoptionshandlers_ PETSCOBJECTPROCESSOPTIONSHANDLERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectprocessoptionshandlers_ petscobjectprocessoptionshandlers
#endif
PETSC_EXTERN void petscobjectprocessoptionshandlers_(PetscObject *a, PetscOptionItems *b, PetscErrorCode *ierr)
{
  *ierr = PetscObjectProcessOptionsHandlers(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectdestroyoptionshandlers_ PETSCOBJECTDESTROYOPTIONSHANDLERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectdestroyoptionshandlers_ petscobjectdestroyoptionshandlers
#endif
PETSC_EXTERN void petscobjectdestroyoptionshandlers_(PetscObject *a, PetscErrorCode *ierr)
{
  *ierr = PetscObjectDestroyOptionsHandlers(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectreference_ PETSCOBJECTREFERENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectreference_ petscobjectreference
#endif
PETSC_EXTERN void petscobjectreference_(PetscObject *a, PetscErrorCode *ierr)
{
  *ierr = PetscObjectReference(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectgetreference_ PETSCOBJECTGETREFERENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectgetreference_ petscobjectgetreference
#endif
PETSC_EXTERN void petscobjectgetreference_(PetscObject *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscObjectGetReference(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectdereference_ PETSCOBJECTDEREFERENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectdereference_ petscobjectdereference
#endif
PETSC_EXTERN void petscobjectdereference_(PetscObject *a, PetscErrorCode *ierr)
{
  *ierr = PetscObjectDereference(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectremovereference_ PETSCOBJECTREMOVEREFERENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectremovereference_ petscobjectremovereference
#endif
PETSC_EXTERN void petscobjectremovereference_(PetscObject *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscObjectRemoveReference(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectcomposeraw_ PETSCOBJECTCOMPOSERAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectcomposeraw_ petscobjectcomposeraw
#endif
PETSC_EXTERN void petscobjectcomposeraw_(PetscObject *a, char b[], PetscObject *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscObjectCompose(*a, c_b, *c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectqueryraw_ PETSCOBJECTQUERYRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectqueryraw_ petscobjectqueryraw
#endif
PETSC_EXTERN void petscobjectqueryraw_(PetscObject *a, char b[], PetscObject *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscObjectQuery(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjecthasfunction_ PETSCOBJECTHASFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjecthasfunction_ petscobjecthasfunction
#endif
PETSC_EXTERN void petscobjecthasfunction_(PetscObject *a, char b[], PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscObjectHasFunction(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectcontainercompose_ PETSCOBJECTCONTAINERCOMPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectcontainercompose_ petscobjectcontainercompose
#endif
PETSC_EXTERN void petscobjectcontainercompose_(PetscObject *a, char b[], void *c, PetscCtxDestroyFn *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscObjectContainerCompose(*a, c_b, c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectcontainerquery_ PETSCOBJECTCONTAINERQUERY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectcontainerquery_ petscobjectcontainerquery
#endif
PETSC_EXTERN void petscobjectcontainerquery_(PetscObject *a, char b[], PeCtx c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscObjectContainerQuery(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectsetfromoptions_ PETSCOBJECTSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectsetfromoptions_ petscobjectsetfromoptions
#endif
PETSC_EXTERN void petscobjectsetfromoptions_(PetscObject *a, PetscErrorCode *ierr)
{
  *ierr = PetscObjectSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectsetup_ PETSCOBJECTSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectsetup_ petscobjectsetup
#endif
PETSC_EXTERN void petscobjectsetup_(PetscObject *a, PetscErrorCode *ierr)
{
  *ierr = PetscObjectSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccontainergetpointer_ PETSCCONTAINERGETPOINTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccontainergetpointer_ petsccontainergetpointer
#endif
PETSC_EXTERN void petsccontainergetpointer_(PetscContainer *a, PeCtx b, PetscErrorCode *ierr)
{
  *ierr = PetscContainerGetPointer(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccontainersetpointer_ PETSCCONTAINERSETPOINTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccontainersetpointer_ petsccontainersetpointer
#endif
PETSC_EXTERN void petsccontainersetpointer_(PetscContainer *a, void *b, PetscErrorCode *ierr)
{
  *ierr = PetscContainerSetPointer(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccontainerdestroy_ PETSCCONTAINERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccontainerdestroy_ petsccontainerdestroy
#endif
PETSC_EXTERN void petsccontainerdestroy_(PetscContainer *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscContainerDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccontainercreate_ PETSCCONTAINERCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccontainercreate_ petsccontainercreate
#endif
PETSC_EXTERN void petsccontainercreate_(MPI_Fint *a, PetscContainer *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscContainerCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
