#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetlogicalcoordinate_ DMDAGETLOGICALCOORDINATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetlogicalcoordinate_ dmdagetlogicalcoordinate
#endif
PETSC_EXTERN void dmdagetlogicalcoordinate_(DM *a, PetscScalar *b, PetscScalar *c, PetscScalar *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscScalar *h, PetscScalar *i, PetscScalar *j, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLSCALAR(h);
  CHKFORTRANNULLSCALAR(i);
  CHKFORTRANNULLSCALAR(j);
  *ierr = DMDAGetLogicalCoordinate(*a, *b, *c, *d, e, f, g, h, i, j);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetray_ DMDAGETRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetray_ dmdagetray
#endif
PETSC_EXTERN void dmdagetray_(DM *a, DMDirection *b, PetscInt *c, Vec *d, VecScatter *e, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMDAGetRay(*a, *b, *c, d, e);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
