#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petschasexternalpackage_ PETSCHASEXTERNALPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petschasexternalpackage_ petschasexternalpackage
#endif
PETSC_EXTERN void petschasexternalpackage_(char a[], PetscBool *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscHasExternalPackage(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
