#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetaotype_ DMDASETAOTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetaotype_ dmdasetaotype
#endif
PETSC_EXTERN void dmdasetaotype_(DM *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMDASetAOType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetao_ DMDAGETAO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetao_ dmdagetao
#endif
PETSC_EXTERN void dmdagetao_(DM *a, AO *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMDAGetAO(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
