#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmumpsseticntl_ MATMUMPSSETICNTL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmumpsseticntl_ matmumpsseticntl
#endif
PETSC_EXTERN void matmumpsseticntl_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = MatMumpsSetIcntl(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmumpsgeticntl_ MATMUMPSGETICNTL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmumpsgeticntl_ matmumpsgeticntl
#endif
PETSC_EXTERN void matmumpsgeticntl_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatMumpsGetIcntl(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmumpssetcntl_ MATMUMPSSETCNTL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmumpssetcntl_ matmumpssetcntl
#endif
PETSC_EXTERN void matmumpssetcntl_(Mat *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = MatMumpsSetCntl(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmumpsgetcntl_ MATMUMPSGETCNTL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmumpsgetcntl_ matmumpsgetcntl
#endif
PETSC_EXTERN void matmumpsgetcntl_(Mat *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = MatMumpsGetCntl(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmumpsgetinverse_ MATMUMPSGETINVERSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmumpsgetinverse_ matmumpsgetinverse
#endif
PETSC_EXTERN void matmumpsgetinverse_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = MatMumpsGetInverse(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmumpsgetinversetranspose_ MATMUMPSGETINVERSETRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmumpsgetinversetranspose_ matmumpsgetinversetranspose
#endif
PETSC_EXTERN void matmumpsgetinversetranspose_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = MatMumpsGetInverseTranspose(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmumpsgetinfo_ MATMUMPSGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmumpsgetinfo_ matmumpsgetinfo
#endif
PETSC_EXTERN void matmumpsgetinfo_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatMumpsGetInfo(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmumpsgetinfog_ MATMUMPSGETINFOG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmumpsgetinfog_ matmumpsgetinfog
#endif
PETSC_EXTERN void matmumpsgetinfog_(Mat *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = MatMumpsGetInfog(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmumpsgetrinfo_ MATMUMPSGETRINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmumpsgetrinfo_ matmumpsgetrinfo
#endif
PETSC_EXTERN void matmumpsgetrinfo_(Mat *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = MatMumpsGetRinfo(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmumpsgetrinfog_ MATMUMPSGETRINFOG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmumpsgetrinfog_ matmumpsgetrinfog
#endif
PETSC_EXTERN void matmumpsgetrinfog_(Mat *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = MatMumpsGetRinfog(*a, *b, c);
  if (*ierr) return;
}
