#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatempiaijcrl_ MATCREATEMPIAIJCRL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatempiaijcrl_ matcreatempiaijcrl
#endif
PETSC_EXTERN void matcreatempiaijcrl_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, const PetscInt e[], PetscInt *f, const PetscInt g[], Mat *h, PetscErrorCode *ierr)
{
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLOBJECT(h);
  *ierr = MatCreateMPIAIJCRL(MPI_Comm_f2c(*(a)), *b, *c, *d, e, *f, g, h);
  if (*ierr) return;
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
