#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matnormalhermitiangetmat_ MATNORMALHERMITIANGETMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matnormalhermitiangetmat_ matnormalhermitiangetmat
#endif
PETSC_EXTERN void matnormalhermitiangetmat_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatNormalHermitianGetMat(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatenormalhermitian_ MATCREATENORMALHERMITIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatenormalhermitian_ matcreatenormalhermitian
#endif
PETSC_EXTERN void matcreatenormalhermitian_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatCreateNormalHermitian(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
