# @HEADER
# *****************************************************************************
#            TriBITS: Tribal Build, Integrate, and Test System
#
# Copyright 2013-2016 NTESS and the TriBITS contributors.
# SPDX-License-Identifier: BSD-3-Clause
# *****************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/ThyraCore clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "ThyraCore requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Trilinos/ThyraCore build
## ---------------------------------------------------------------------------

set(ThyraCore_CXX_COMPILER "D:/M/msys64/mingw64/bin/g++.exe")

set(ThyraCore_C_COMPILER "D:/M/msys64/mingw64/bin/gcc.exe")

set(ThyraCore_Fortran_COMPILER "D:/M/msys64/mingw64/bin/gfortran.exe")
# Deprecated!
set(ThyraCore_FORTRAN_COMPILER "D:/M/msys64/mingw64/bin/gfortran.exe") 


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/ThyraCore build
## ---------------------------------------------------------------------------

## Give the build type
set(ThyraCore_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(ThyraCore_CXX_FLAGS [[ ]])

set(ThyraCore_C_FLAGS [[  -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 ]])

set(ThyraCore_Fortran_FLAGS [[ ]])
# Deprecated
set(ThyraCore_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(ThyraCore_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(ThyraCore_SHARED_LIB_RPATH_COMMAND "/mingw64/lib")
set(ThyraCore_BUILD_SHARED_LIBS "ON")

set(ThyraCore_LINKER D:/M/msys64/mingw64/bin/ld.exe)
set(ThyraCore_AR D:/M/msys64/mingw64/bin/ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(ThyraCore_INSTALL_DIR "/mingw64")

## List of package libraries
set(ThyraCore_LIBRARIES ThyraCore::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(ThyraCore_MPI_LIBRARIES "")
set(ThyraCore_MPI_LIBRARY_DIRS "")
set(ThyraCore_MPI_INCLUDE_DIRS "")
set(ThyraCore_MPI_EXEC "")
set(ThyraCore_MPI_EXEC_MAX_NUMPROCS "")
set(ThyraCore_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(ThyraCore_ENABLE_TeuchosCore ON)
set(ThyraCore_ENABLE_TeuchosParameterList ON)
set(ThyraCore_ENABLE_TeuchosComm ON)
set(ThyraCore_ENABLE_TeuchosNumerics ON)
set(ThyraCore_ENABLE_RTOp ON)

# Exported cache variables
set(Thyra_ENABLE_DEBUG "OFF")
set(HAVE_THYRA_DEBUG "OFF")
set(Thyra_ENABLE_EXPLICIT_INSTANTIATION "ON")
set(HAVE_THYRA_EXPLICIT_INSTANTIATION "ON")
set(Thyra_ENABLE_ME_POLYNOMIAL "OFF")
set(HAVE_THYRA_ME_POLYNOMIAL "OFF")
set(Thyra_ENABLE_HESSIAN_SUPPORT "ON")
set(Thyra_BUILD_HESSIAN_SUPPORT "ON")

# Include configuration of dependent packages
if (NOT TARGET TeuchosCore::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../TeuchosCore/TeuchosCoreConfig.cmake")
endif()
if (NOT TARGET TeuchosParameterList::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../TeuchosParameterList/TeuchosParameterListConfig.cmake")
endif()
if (NOT TARGET TeuchosComm::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../TeuchosComm/TeuchosCommConfig.cmake")
endif()
if (NOT TARGET TeuchosNumerics::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../TeuchosNumerics/TeuchosNumericsConfig.cmake")
endif()
if (NOT TARGET RTOp::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../RTOp/RTOpConfig.cmake")
endif()

# Import ThyraCore targets
include("${CMAKE_CURRENT_LIST_DIR}/ThyraCoreTargets.cmake")

# Standard TriBITS-compliant external package variables
set(ThyraCore_IS_TRIBITS_COMPLIANT TRUE)
set(ThyraCore_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(ThyraCore_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(ThyraCore_EXPORTED_PACKAGE_LIBS_NAMES "thyracore")

foreach(libname IN LISTS ThyraCore_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE ThyraCore::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Trilinos', then use the"
      " new namespaced target 'ThyraCore::${libname}', or better yet,"
      " 'ThyraCore::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'ThyraCore'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Trilinos', instead link against the"
      " libraries specified by the variable 'ThyraCore_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
