!!****f* ABINIT/ptg_D3d
!!
!! NAME
!! ptg_D3d
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2010-2025 ABINIT group (MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SOURCE
!!
!********************************************************************************
! This include file has been automatically generated by the script ptg.py
! Do not edit! Change the script source instead.
!********************************************************************************

! Point group name  D3d  (-3m)

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

module m_ptg_D3d

#ifdef FC_INTEL
!DEC$ NOOPTIMIZE
#endif

contains
!!**

 subroutine ptg_D3d (nsym,nclass,sym,class_ids,class_names,Irr)
 use defs_basis
 use m_abicore
 use m_defs_ptgroups,  only : irrep_t
 implicit none
!Arguments ------------------------------------
 integer,intent(out) :: nclass,nsym
 !arrays
 integer,allocatable,intent(out) :: sym(:,:,:), class_ids(:,:)
 character(len=5),allocatable,intent(out) :: class_names(:)
 type(irrep_t),allocatable,intent(out) :: Irr(:)
 !Local variables-------------------------------
 complex(dpc) :: j=(0.0_dp,1.0_dp)
 ! ********************************************************************************
! List of symmetries packed in classes
 nsym = 12
 ABI_MALLOC(sym, (3,3,nsym))
 sym(:,:,1) = RESHAPE( (/1, 0, 0, 0, 1, 0, 0, 0, 1/) ,(/3,3/) )
 sym(:,:,2) = RESHAPE( (/0, 1, 0, -1, -1, 0, 0, 0, 1/) ,(/3,3/) )
 sym(:,:,3) = RESHAPE( (/-1, -1, 0, 1, 0, 0, 0, 0, 1/) ,(/3,3/) )
 sym(:,:,4) = RESHAPE( (/0, -1, 0, -1, 0, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,5) = RESHAPE( (/-1, 0, 0, 1, 1, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,6) = RESHAPE( (/1, 1, 0, 0, -1, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,7) = RESHAPE( (/-1, 0, 0, 0, -1, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,8) = RESHAPE( (/0, -1, 0, 1, 1, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,9) = RESHAPE( (/1, 1, 0, -1, 0, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,10) = RESHAPE( (/0, 1, 0, 1, 0, 0, 0, 0, 1/) ,(/3,3/) )
 sym(:,:,11) = RESHAPE( (/1, 0, 0, -1, -1, 0, 0, 0, 1/) ,(/3,3/) )
 sym(:,:,12) = RESHAPE( (/-1, -1, 0, 0, 1, 0, 0, 0, 1/) ,(/3,3/) )

! Number of classes and corresponding indices
 nclass = 6
 ABI_MALLOC(class_ids, (2,nclass))
 class_ids(1,1) = 1
 class_ids(2,1) = 1
 class_ids(1,2) = 2
 class_ids(2,2) = 3
 class_ids(1,3) = 4
 class_ids(2,3) = 6
 class_ids(1,4) = 7
 class_ids(2,4) = 7
 class_ids(1,5) = 8
 class_ids(2,5) = 9
 class_ids(1,6) = 10
 class_ids(2,6) = 12

ABI_MALLOC(class_names,(6))
 class_names(1) = "1+"
 class_names(2) = "3+"
 class_names(3) = "2+"
 class_names(4) = "-2-"
 class_names(5) = "-6-"
 class_names(6) = "-2+"

! List of irreducible representations.
 ABI_MALLOC(Irr, (6))
 Irr(1)%name = "A1g"
 Irr(1)%dim = 1
 Irr(1)%nsym = 12
 ABI_MALLOC(Irr(1)%mat, (1,1,12))
 Irr(1)%mat(:,:,1) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,2) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,3) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,4) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,5) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,6) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,7) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,8) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,9) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,10) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,11) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,12) =  RESHAPE( (/1.0/), (/1, 1/) )

 Irr(2)%name = "A1u"
 Irr(2)%dim = 1
 Irr(2)%nsym = 12
 ABI_MALLOC(Irr(2)%mat, (1,1,12))
 Irr(2)%mat(:,:,1) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,2) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,3) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,4) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,5) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,6) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,7) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,8) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,9) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,10) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,11) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,12) =  RESHAPE( (/-1.0/), (/1, 1/) )

 Irr(3)%name = "A2g"
 Irr(3)%dim = 1
 Irr(3)%nsym = 12
 ABI_MALLOC(Irr(3)%mat, (1,1,12))
 Irr(3)%mat(:,:,1) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,2) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,3) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,4) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,5) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,6) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,7) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,8) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,9) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,10) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,11) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,12) =  RESHAPE( (/-1.0/), (/1, 1/) )

 Irr(4)%name = "A2u"
 Irr(4)%dim = 1
 Irr(4)%nsym = 12
 ABI_MALLOC(Irr(4)%mat, (1,1,12))
 Irr(4)%mat(:,:,1) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,2) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,3) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,4) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,5) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,6) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,7) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,8) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,9) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,10) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,11) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,12) =  RESHAPE( (/1.0/), (/1, 1/) )

 Irr(5)%name = "Eu"
 Irr(5)%dim = 2
 Irr(5)%nsym = 12
 ABI_MALLOC(Irr(5)%mat, (2,2,12))
 Irr(5)%mat(:,:,1) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(5)%mat(:,:,2) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,3) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,4) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(5)%mat(:,:,5) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,6) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,7) =  RESHAPE( (/-1.0, 0.0, 0.0, -1.0/), (/2, 2/) )
 Irr(5)%mat(:,:,8) =  RESHAPE( (/0.5-0.86603*j, 0*j, 0*j, 0.5+0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,9) =  RESHAPE( (/0.5+0.86603*j, 0*j, 0*j, 0.5-0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,10) =  RESHAPE( (/0.0, -1.0, -1.0, 0.0/), (/2, 2/) )
 Irr(5)%mat(:,:,11) =  RESHAPE( (/0*j, 0.5-0.86603*j, 0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,12) =  RESHAPE( (/0*j, 0.5+0.86603*j, 0.5-0.86603*j, 0*j/), (/2, 2/) )

 Irr(6)%name = "Eg"
 Irr(6)%dim = 2
 Irr(6)%nsym = 12
 ABI_MALLOC(Irr(6)%mat, (2,2,12))
 Irr(6)%mat(:,:,1) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(6)%mat(:,:,2) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,3) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,4) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(6)%mat(:,:,5) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,6) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,7) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(6)%mat(:,:,8) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,9) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,10) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(6)%mat(:,:,11) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,12) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )

 RETURN
  if (.FALSE.) write(std_out,*) j
 end subroutine ptg_D3d
!!***

end module m_ptg_D3d
!!***
