!--------------------------------------------------------------------------------------------------!
!   CP2K: A general program to perform molecular dynamics simulations                              !
!   Copyright 2000-2026 CP2K developers group <https://cp2k.org>                                   !
!                                                                                                  !
!   SPDX-License-Identifier: GPL-2.0-or-later                                                      !
!--------------------------------------------------------------------------------------------------!

!--------------------------------------------------------------------------------------------------!
!   Copyright (c) 2008, Joost VandeVondele and Manuel Guidon                                       !
!   All rights reserved.                                                                           !
!                                                                                                  !
!   Redistribution and use in source and binary forms, with or without                             !
!   modification, are permitted provided that the following conditions are met:                    !
!       * Redistributions of source code must retain the above copyright                           !
!         notice, this list of conditions and the following disclaimer.                            !
!       * Redistributions in binary form must reproduce the above copyright                        !
!         notice, this list of conditions and the following disclaimer in the                      !
!         documentation and/or other materials provided with the distribution.                     !
!                                                                                                  !
!   THIS SOFTWARE IS PROVIDED BY Joost VandeVondele and Manuel Guidon AS IS AND ANY                !
!   EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED                      !
!   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE                         !
!   DISCLAIMED. IN NO EVENT SHALL Joost VandeVondele or Manuel Guidon BE LIABLE FOR ANY            !
!   DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES                     !
!   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;                   !
!   LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND                    !
!   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT                     !
!   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS                  !
!   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                   !
!--------------------------------------------------------------------------------------------------!

! **************************************************************************************************
!> \brief ...
!> \author Joost VandeVondele and Manuel Guidon
!> \par History
!>      Nov 2008 Joost VandeVondele and Manuel Guidon
!>      Sep 2019 A.Bussy: Moved the file to common (together with gamma.F and t_c_g0.F)
! **************************************************************************************************
MODULE t_sh_p_s_c
   USE kinds,                           ONLY: dp
   USE message_passing,                 ONLY: mp_comm_type
#include "../base/base_uses.f90"

   IMPLICIT NONE
   PRIVATE

   PUBLIC :: trunc_CS_poly_n20, init, free_C0
   REAL(KIND=dp), DIMENSION(:, :), ALLOCATABLE, SAVE :: C0
   INTEGER, PARAMETER :: degree = 15
   REAL(KIND=dp), PARAMETER :: target_error = 0.100000E-08
   INTEGER, PARAMETER :: nderiv_max = 21
   INTEGER, SAVE      :: nderiv_init = -1
   INTEGER, SAVE      :: patches = -1

CONTAINS

! **************************************************************************************************
!> \brief ...
!> \param RES ...
!> \param R ...
!> \param T ...
!> \param NDERIV ...
! **************************************************************************************************
   SUBROUTINE trunc_CS_poly_n20(RES, R, T, NDERIV)
      REAL(KIND=dp), INTENT(OUT)                         :: RES(*)
      REAL(KIND=dp), INTENT(IN)                          :: R, T
      INTEGER, INTENT(IN)                                :: NDERIV

      REAL(KIND=dp), PARAMETER :: eps = 34.53877639491068526026987182_dp, n = 2.0_dp

      INTEGER                                            :: i
      REAL(KIND=dp)                                      :: lower, TG1, TG2, X1, X2

      IF (T <= 81.0_dp) THEN
         X2 = 1/(1 + R)
         X1 = 1/(1 + SQRT(T))
         IF (X2 <= 0.500000000000000000E+00_dp) THEN
            IF (X2 <= 0.250000000000000000E+00_dp) THEN
               IF (X1 <= 0.550000000000000044E+00_dp) THEN
                  IF (X1 <= 0.325000000000000011E+00_dp) THEN
                     IF (X1 <= 0.212500000000000022E+00_dp) THEN
                        IF (X2 <= 0.125000000000000000E+00_dp) THEN
                           IF (X2 <= 0.625000000000000000E-01_dp) THEN
                              TG1 = (2*X1 - 0.312500000000000000E+00_dp)*0.888888888888888751E+01_dp
                              TG2 = (2*X2 - 0.625000000000000000E-01_dp)*0.160000000000000000E+02_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 1))
                           ELSE
                              IF (X1 <= 0.156250000000000000E+00_dp) THEN
                                 IF (X2 <= 0.937500000000000000E-01_dp) THEN
                                    IF (X1 <= 0.128124999999999989E+00_dp) THEN
                                       TG1 = (2*X1 - 0.228124999999999994E+00_dp)*0.355555555555555785E+02_dp
                                       TG2 = (2*X2 - 0.156250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 2))
                                    ELSE
                                       TG1 = (2*X1 - 0.284374999999999989E+00_dp)*0.355555555555555429E+02_dp
                                       TG2 = (2*X2 - 0.156250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 3))
                                    END IF
                                 ELSE
                                    IF (X1 <= 0.128124999999999989E+00_dp) THEN
                                       IF (X2 <= 0.109375000000000000E+00_dp) THEN
                                          TG1 = (2*X1 - 0.228124999999999994E+00_dp)*0.355555555555555785E+02_dp
                                          TG2 = (2*X2 - 0.203125000000000000E+00_dp)*0.640000000000000000E+02_dp
                                          CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 4))
                                       ELSE
                                          TG1 = (2*X1 - 0.228124999999999994E+00_dp)*0.355555555555555785E+02_dp
                                          TG2 = (2*X2 - 0.234375000000000000E+00_dp)*0.640000000000000000E+02_dp
                                          CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 5))
                                       END IF
                                    ELSE
                                       TG1 = (2*X1 - 0.284374999999999989E+00_dp)*0.355555555555555429E+02_dp
                                       TG2 = (2*X2 - 0.218750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 6))
                                    END IF
                                 END IF
                              ELSE
                                 TG1 = (2*X1 - 0.368750000000000022E+00_dp)*0.177777777777777715E+02_dp
                                 TG2 = (2*X2 - 0.187500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 7))
                              END IF
                           END IF
                        ELSE
                           IF (X2 <= 0.187500000000000000E+00_dp) THEN
                              IF (X1 <= 0.156250000000000000E+00_dp) THEN
                                 IF (X2 <= 0.156250000000000000E+00_dp) THEN
                                    IF (X1 <= 0.128124999999999989E+00_dp) THEN
                                       TG1 = (2*X1 - 0.228124999999999994E+00_dp)*0.355555555555555785E+02_dp
                                       TG2 = (2*X2 - 0.281250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 8))
                                    ELSE
                                       TG1 = (2*X1 - 0.284374999999999989E+00_dp)*0.355555555555555429E+02_dp
                                       TG2 = (2*X2 - 0.281250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 9))
                                    END IF
                                 ELSE
                                    IF (X1 <= 0.128124999999999989E+00_dp) THEN
                                       IF (X1 <= 0.114062499999999997E+00_dp) THEN
                                          TG1 = (2*X1 - 0.214062499999999989E+00_dp)*0.711111111111111569E+02_dp
                                          TG2 = (2*X2 - 0.343750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                          CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 10))
                                       ELSE
                                          TG1 = (2*X1 - 0.242187500000000000E+00_dp)*0.711111111111111569E+02_dp
                                          TG2 = (2*X2 - 0.343750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                          CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 11))
                                       END IF
                                    ELSE
                                       TG1 = (2*X1 - 0.284374999999999989E+00_dp)*0.355555555555555429E+02_dp
                                       TG2 = (2*X2 - 0.343750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 12))
                                    END IF
                                 END IF
                              ELSE
                                 IF (X2 <= 0.156250000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.368750000000000022E+00_dp)*0.177777777777777715E+02_dp
                                    TG2 = (2*X2 - 0.281250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 13))
                                 ELSE
                                    TG1 = (2*X1 - 0.368750000000000022E+00_dp)*0.177777777777777715E+02_dp
                                    TG2 = (2*X2 - 0.343750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 14))
                                 END IF
                              END IF
                           ELSE
                              IF (X1 <= 0.156250000000000000E+00_dp) THEN
                                 IF (X1 <= 0.128124999999999989E+00_dp) THEN
                                    IF (X2 <= 0.218750000000000000E+00_dp) THEN
                                       IF (X1 <= 0.114062499999999997E+00_dp) THEN
                                          TG1 = (2*X1 - 0.214062499999999989E+00_dp)*0.711111111111111569E+02_dp
                                          TG2 = (2*X2 - 0.406250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                          CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 15))
                                       ELSE
                                          TG1 = (2*X1 - 0.242187500000000000E+00_dp)*0.711111111111111569E+02_dp
                                          TG2 = (2*X2 - 0.406250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                          CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 16))
                                       END IF
                                    ELSE
                                       TG1 = (2*X1 - 0.228124999999999994E+00_dp)*0.355555555555555785E+02_dp
                                       TG2 = (2*X2 - 0.468750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 17))
                                    END IF
                                 ELSE
                                    IF (X2 <= 0.218750000000000000E+00_dp) THEN
                                       TG1 = (2*X1 - 0.284374999999999989E+00_dp)*0.355555555555555429E+02_dp
                                       TG2 = (2*X2 - 0.406250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 18))
                                    ELSE
                                       TG1 = (2*X1 - 0.284374999999999989E+00_dp)*0.355555555555555429E+02_dp
                                       TG2 = (2*X2 - 0.468750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 19))
                                    END IF
                                 END IF
                              ELSE
                                 IF (X2 <= 0.218750000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.368750000000000022E+00_dp)*0.177777777777777715E+02_dp
                                    TG2 = (2*X2 - 0.406250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 20))
                                 ELSE
                                    TG1 = (2*X1 - 0.368750000000000022E+00_dp)*0.177777777777777715E+02_dp
                                    TG2 = (2*X2 - 0.468750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 21))
                                 END IF
                              END IF
                           END IF
                        END IF
                     ELSE
                        IF (X2 <= 0.125000000000000000E+00_dp) THEN
                           TG1 = (2*X1 - 0.537500000000000089E+00_dp)*0.888888888888888928E+01_dp
                           TG2 = (2*X2 - 0.125000000000000000E+00_dp)*0.800000000000000000E+01_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 22))
                        ELSE
                           IF (X2 <= 0.187500000000000000E+00_dp) THEN
                              IF (X1 <= 0.268750000000000044E+00_dp) THEN
                                 TG1 = (2*X1 - 0.481250000000000067E+00_dp)*0.177777777777777715E+02_dp
                                 TG2 = (2*X2 - 0.312500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 23))
                              ELSE
                                 TG1 = (2*X1 - 0.593750000000000000E+00_dp)*0.177777777777777892E+02_dp
                                 TG2 = (2*X2 - 0.312500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 24))
                              END IF
                           ELSE
                              IF (X1 <= 0.268750000000000044E+00_dp) THEN
                                 TG1 = (2*X1 - 0.481250000000000067E+00_dp)*0.177777777777777715E+02_dp
                                 TG2 = (2*X2 - 0.437500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 25))
                              ELSE
                                 TG1 = (2*X1 - 0.593750000000000000E+00_dp)*0.177777777777777892E+02_dp
                                 TG2 = (2*X2 - 0.437500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 26))
                              END IF
                           END IF
                        END IF
                     END IF
                  ELSE
                     IF (X2 <= 0.125000000000000000E+00_dp) THEN
                        TG1 = (2*X1 - 0.875000000000000000E+00_dp)*0.444444444444444375E+01_dp
                        TG2 = (2*X2 - 0.125000000000000000E+00_dp)*0.800000000000000000E+01_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 27))
                     ELSE
                        IF (X2 <= 0.187500000000000000E+00_dp) THEN
                           TG1 = (2*X1 - 0.875000000000000000E+00_dp)*0.444444444444444375E+01_dp
                           TG2 = (2*X2 - 0.312500000000000000E+00_dp)*0.160000000000000000E+02_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 28))
                        ELSE
                           TG1 = (2*X1 - 0.875000000000000000E+00_dp)*0.444444444444444375E+01_dp
                           TG2 = (2*X2 - 0.437500000000000000E+00_dp)*0.160000000000000000E+02_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 29))
                        END IF
                     END IF
                  END IF
               ELSE
                  IF (X2 <= 0.125000000000000000E+00_dp) THEN
                     TG1 = (2*X1 - 0.155000000000000004E+01_dp)*0.222222222222222232E+01_dp
                     TG2 = (2*X2 - 0.125000000000000000E+00_dp)*0.800000000000000000E+01_dp
                     CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 30))
                  ELSE
                     TG1 = (2*X1 - 0.155000000000000004E+01_dp)*0.222222222222222232E+01_dp
                     TG2 = (2*X2 - 0.375000000000000000E+00_dp)*0.800000000000000000E+01_dp
                     CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 31))
                  END IF
               END IF
            ELSE
               IF (X1 <= 0.550000000000000044E+00_dp) THEN
                  IF (X1 <= 0.325000000000000011E+00_dp) THEN
                     IF (X1 <= 0.212500000000000022E+00_dp) THEN
                        IF (X1 <= 0.156250000000000000E+00_dp) THEN
                           IF (X2 <= 0.375000000000000000E+00_dp) THEN
                              IF (X1 <= 0.128124999999999989E+00_dp) THEN
                                 IF (X2 <= 0.312500000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.228124999999999994E+00_dp)*0.355555555555555785E+02_dp
                                    TG2 = (2*X2 - 0.562500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 32))
                                 ELSE
                                    TG1 = (2*X1 - 0.228124999999999994E+00_dp)*0.355555555555555785E+02_dp
                                    TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 33))
                                 END IF
                              ELSE
                                 IF (X2 <= 0.312500000000000000E+00_dp) THEN
                                    IF (X2 <= 0.281250000000000000E+00_dp) THEN
                                       TG1 = (2*X1 - 0.284374999999999989E+00_dp)*0.355555555555555429E+02_dp
                                       TG2 = (2*X2 - 0.531250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 34))
                                    ELSE
                                       TG1 = (2*X1 - 0.284374999999999989E+00_dp)*0.355555555555555429E+02_dp
                                       TG2 = (2*X2 - 0.593750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 35))
                                    END IF
                                 ELSE
                                    TG1 = (2*X1 - 0.284374999999999989E+00_dp)*0.355555555555555429E+02_dp
                                    TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 36))
                                 END IF
                              END IF
                           ELSE
                              TG1 = (2*X1 - 0.256249999999999978E+00_dp)*0.177777777777777786E+02_dp
                              TG2 = (2*X2 - 0.875000000000000000E+00_dp)*0.800000000000000000E+01_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 37))
                           END IF
                        ELSE
                           IF (X2 <= 0.375000000000000000E+00_dp) THEN
                              IF (X2 <= 0.312500000000000000E+00_dp) THEN
                                 IF (X1 <= 0.184375000000000011E+00_dp) THEN
                                    TG1 = (2*X1 - 0.340625000000000011E+00_dp)*0.355555555555555429E+02_dp
                                    TG2 = (2*X2 - 0.562500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 38))
                                 ELSE
                                    TG1 = (2*X1 - 0.396875000000000033E+00_dp)*0.355555555555555429E+02_dp
                                    TG2 = (2*X2 - 0.562500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 39))
                                 END IF
                              ELSE
                                 IF (X1 <= 0.184375000000000011E+00_dp) THEN
                                    TG1 = (2*X1 - 0.340625000000000011E+00_dp)*0.355555555555555429E+02_dp
                                    TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 40))
                                 ELSE
                                    TG1 = (2*X1 - 0.396875000000000033E+00_dp)*0.355555555555555429E+02_dp
                                    TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 41))
                                 END IF
                              END IF
                           ELSE
                              IF (X1 <= 0.184375000000000011E+00_dp) THEN
                                 TG1 = (2*X1 - 0.340625000000000011E+00_dp)*0.355555555555555429E+02_dp
                                 TG2 = (2*X2 - 0.875000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 42))
                              ELSE
                                 TG1 = (2*X1 - 0.396875000000000033E+00_dp)*0.355555555555555429E+02_dp
                                 TG2 = (2*X2 - 0.875000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 43))
                              END IF
                           END IF
                        END IF
                     ELSE
                        IF (X2 <= 0.375000000000000000E+00_dp) THEN
                           IF (X2 <= 0.312500000000000000E+00_dp) THEN
                              IF (X1 <= 0.268750000000000044E+00_dp) THEN
                                 TG1 = (2*X1 - 0.481250000000000067E+00_dp)*0.177777777777777715E+02_dp
                                 TG2 = (2*X2 - 0.562500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 44))
                              ELSE
                                 TG1 = (2*X1 - 0.593750000000000000E+00_dp)*0.177777777777777892E+02_dp
                                 TG2 = (2*X2 - 0.562500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 45))
                              END IF
                           ELSE
                              IF (X1 <= 0.268750000000000044E+00_dp) THEN
                                 TG1 = (2*X1 - 0.481250000000000067E+00_dp)*0.177777777777777715E+02_dp
                                 TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 46))
                              ELSE
                                 TG1 = (2*X1 - 0.593750000000000000E+00_dp)*0.177777777777777892E+02_dp
                                 TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 47))
                              END IF
                           END IF
                        ELSE
                           IF (X1 <= 0.268750000000000044E+00_dp) THEN
                              TG1 = (2*X1 - 0.481250000000000067E+00_dp)*0.177777777777777715E+02_dp
                              TG2 = (2*X2 - 0.875000000000000000E+00_dp)*0.800000000000000000E+01_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 48))
                           ELSE
                              TG1 = (2*X1 - 0.593750000000000000E+00_dp)*0.177777777777777892E+02_dp
                              TG2 = (2*X2 - 0.875000000000000000E+00_dp)*0.800000000000000000E+01_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 49))
                           END IF
                        END IF
                     END IF
                  ELSE
                     IF (X2 <= 0.375000000000000000E+00_dp) THEN
                        IF (X1 <= 0.437500000000000000E+00_dp) THEN
                           TG1 = (2*X1 - 0.762499999999999956E+00_dp)*0.888888888888888928E+01_dp
                           TG2 = (2*X2 - 0.625000000000000000E+00_dp)*0.800000000000000000E+01_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 50))
                        ELSE
                           TG1 = (2*X1 - 0.987500000000000044E+00_dp)*0.888888888888888573E+01_dp
                           TG2 = (2*X2 - 0.625000000000000000E+00_dp)*0.800000000000000000E+01_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 51))
                        END IF
                     ELSE
                        IF (X2 <= 0.437500000000000000E+00_dp) THEN
                           IF (X1 <= 0.437500000000000000E+00_dp) THEN
                              TG1 = (2*X1 - 0.762499999999999956E+00_dp)*0.888888888888888928E+01_dp
                              TG2 = (2*X2 - 0.812500000000000000E+00_dp)*0.160000000000000000E+02_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 52))
                           ELSE
                              TG1 = (2*X1 - 0.987500000000000044E+00_dp)*0.888888888888888573E+01_dp
                              TG2 = (2*X2 - 0.812500000000000000E+00_dp)*0.160000000000000000E+02_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 53))
                           END IF
                        ELSE
                           IF (X1 <= 0.437500000000000000E+00_dp) THEN
                              TG1 = (2*X1 - 0.762499999999999956E+00_dp)*0.888888888888888928E+01_dp
                              TG2 = (2*X2 - 0.937500000000000000E+00_dp)*0.160000000000000000E+02_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 54))
                           ELSE
                              TG1 = (2*X1 - 0.987500000000000044E+00_dp)*0.888888888888888573E+01_dp
                              TG2 = (2*X2 - 0.937500000000000000E+00_dp)*0.160000000000000000E+02_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 55))
                           END IF
                        END IF
                     END IF
                  END IF
               ELSE
                  IF (X2 <= 0.375000000000000000E+00_dp) THEN
                     IF (X2 <= 0.312500000000000000E+00_dp) THEN
                        TG1 = (2*X1 - 0.155000000000000004E+01_dp)*0.222222222222222232E+01_dp
                        TG2 = (2*X2 - 0.562500000000000000E+00_dp)*0.160000000000000000E+02_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 56))
                     ELSE
                        TG1 = (2*X1 - 0.155000000000000004E+01_dp)*0.222222222222222232E+01_dp
                        TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 57))
                     END IF
                  ELSE
                     IF (X2 <= 0.437500000000000000E+00_dp) THEN
                        TG1 = (2*X1 - 0.155000000000000004E+01_dp)*0.222222222222222232E+01_dp
                        TG2 = (2*X2 - 0.812500000000000000E+00_dp)*0.160000000000000000E+02_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 58))
                     ELSE
                        IF (X1 <= 0.775000000000000022E+00_dp) THEN
                           TG1 = (2*X1 - 0.132500000000000018E+01_dp)*0.444444444444444464E+01_dp
                           TG2 = (2*X2 - 0.937500000000000000E+00_dp)*0.160000000000000000E+02_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 59))
                        ELSE
                           TG1 = (2*X1 - 0.177499999999999991E+01_dp)*0.444444444444444464E+01_dp
                           TG2 = (2*X2 - 0.937500000000000000E+00_dp)*0.160000000000000000E+02_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 60))
                        END IF
                     END IF
                  END IF
               END IF
            END IF
         ELSE
            IF (X1 <= 0.550000000000000044E+00_dp) THEN
               IF (X1 <= 0.325000000000000011E+00_dp) THEN
                  IF (X1 <= 0.212500000000000022E+00_dp) THEN
                     IF (X2 <= 0.750000000000000000E+00_dp) THEN
                        IF (X1 <= 0.156250000000000000E+00_dp) THEN
                           TG1 = (2*X1 - 0.256249999999999978E+00_dp)*0.177777777777777786E+02_dp
                           TG2 = (2*X2 - 0.125000000000000000E+01_dp)*0.400000000000000000E+01_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 61))
                        ELSE
                           TG1 = (2*X1 - 0.368750000000000022E+00_dp)*0.177777777777777715E+02_dp
                           TG2 = (2*X2 - 0.125000000000000000E+01_dp)*0.400000000000000000E+01_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 62))
                        END IF
                     ELSE
                        TG1 = (2*X1 - 0.312500000000000000E+00_dp)*0.888888888888888751E+01_dp
                        TG2 = (2*X2 - 0.175000000000000000E+01_dp)*0.400000000000000000E+01_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 63))
                     END IF
                  ELSE
                     IF (X2 <= 0.750000000000000000E+00_dp) THEN
                        IF (X2 <= 0.625000000000000000E+00_dp) THEN
                           IF (X1 <= 0.268750000000000044E+00_dp) THEN
                              TG1 = (2*X1 - 0.481250000000000067E+00_dp)*0.177777777777777715E+02_dp
                              TG2 = (2*X2 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 64))
                           ELSE
                              TG1 = (2*X1 - 0.593750000000000000E+00_dp)*0.177777777777777892E+02_dp
                              TG2 = (2*X2 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 65))
                           END IF
                        ELSE
                           TG1 = (2*X1 - 0.537500000000000089E+00_dp)*0.888888888888888928E+01_dp
                           TG2 = (2*X2 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 66))
                        END IF
                     ELSE
                        TG1 = (2*X1 - 0.537500000000000089E+00_dp)*0.888888888888888928E+01_dp
                        TG2 = (2*X2 - 0.175000000000000000E+01_dp)*0.400000000000000000E+01_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 67))
                     END IF
                  END IF
               ELSE
                  IF (X2 <= 0.750000000000000000E+00_dp) THEN
                     IF (X2 <= 0.625000000000000000E+00_dp) THEN
                        IF (X1 <= 0.437500000000000000E+00_dp) THEN
                           TG1 = (2*X1 - 0.762499999999999956E+00_dp)*0.888888888888888928E+01_dp
                           TG2 = (2*X2 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 68))
                        ELSE
                           TG1 = (2*X1 - 0.987500000000000044E+00_dp)*0.888888888888888573E+01_dp
                           TG2 = (2*X2 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 69))
                        END IF
                     ELSE
                        IF (X1 <= 0.437500000000000000E+00_dp) THEN
                           TG1 = (2*X1 - 0.762499999999999956E+00_dp)*0.888888888888888928E+01_dp
                           TG2 = (2*X2 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 70))
                        ELSE
                           TG1 = (2*X1 - 0.987500000000000044E+00_dp)*0.888888888888888573E+01_dp
                           TG2 = (2*X2 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 71))
                        END IF
                     END IF
                  ELSE
                     IF (X1 <= 0.437500000000000000E+00_dp) THEN
                        TG1 = (2*X1 - 0.762499999999999956E+00_dp)*0.888888888888888928E+01_dp
                        TG2 = (2*X2 - 0.175000000000000000E+01_dp)*0.400000000000000000E+01_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 72))
                     ELSE
                        TG1 = (2*X1 - 0.987500000000000044E+00_dp)*0.888888888888888573E+01_dp
                        TG2 = (2*X2 - 0.175000000000000000E+01_dp)*0.400000000000000000E+01_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 73))
                     END IF
                  END IF
               END IF
            ELSE
               IF (X2 <= 0.750000000000000000E+00_dp) THEN
                  IF (X2 <= 0.625000000000000000E+00_dp) THEN
                     IF (X1 <= 0.775000000000000022E+00_dp) THEN
                        TG1 = (2*X1 - 0.132500000000000018E+01_dp)*0.444444444444444464E+01_dp
                        TG2 = (2*X2 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 74))
                     ELSE
                        TG1 = (2*X1 - 0.177499999999999991E+01_dp)*0.444444444444444464E+01_dp
                        TG2 = (2*X2 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 75))
                     END IF
                  ELSE
                     IF (X1 <= 0.775000000000000022E+00_dp) THEN
                        TG1 = (2*X1 - 0.132500000000000018E+01_dp)*0.444444444444444464E+01_dp
                        TG2 = (2*X2 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 76))
                     ELSE
                        TG1 = (2*X1 - 0.177499999999999991E+01_dp)*0.444444444444444464E+01_dp
                        TG2 = (2*X2 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 77))
                     END IF
                  END IF
               ELSE
                  IF (X2 <= 0.875000000000000000E+00_dp) THEN
                     TG1 = (2*X1 - 0.155000000000000004E+01_dp)*0.222222222222222232E+01_dp
                     TG2 = (2*X2 - 0.162500000000000000E+01_dp)*0.800000000000000000E+01_dp
                     CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 78))
                  ELSE
                     TG1 = (2*X1 - 0.155000000000000004E+01_dp)*0.222222222222222232E+01_dp
                     TG2 = (2*X2 - 0.187500000000000000E+01_dp)*0.800000000000000000E+01_dp
                     CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 79))
                  END IF
               END IF
            END IF
         END IF
      ELSE
         X1 = SQRT(81.0_dp/T)
         lower = (SQRT(T) - SQRT(eps))/n
         IF (R >= lower) THEN
            X2 = lower/R
            IF (X2 <= 0.500000000000000000E+00_dp) THEN
               IF (X1 <= 0.500000000000000000E+00_dp) THEN
                  IF (X2 <= 0.250000000000000000E+00_dp) THEN
                     TG1 = (2*X1 - 0.500000000000000000E+00_dp)*0.200000000000000000E+01_dp
                     TG2 = (2*X2 - 0.250000000000000000E+00_dp)*0.400000000000000000E+01_dp
                     CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 80))
                  ELSE
                     IF (X2 <= 0.375000000000000000E+00_dp) THEN
                        IF (X1 <= 0.250000000000000000E+00_dp) THEN
                           TG1 = (2*X1 - 0.250000000000000000E+00_dp)*0.400000000000000000E+01_dp
                           TG2 = (2*X2 - 0.625000000000000000E+00_dp)*0.800000000000000000E+01_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 81))
                        ELSE
                           IF (X2 <= 0.312500000000000000E+00_dp) THEN
                              TG1 = (2*X1 - 0.750000000000000000E+00_dp)*0.400000000000000000E+01_dp
                              TG2 = (2*X2 - 0.562500000000000000E+00_dp)*0.160000000000000000E+02_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 82))
                           ELSE
                              IF (X1 <= 0.375000000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.625000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 83))
                              ELSE
                                 TG1 = (2*X1 - 0.875000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 84))
                              END IF
                           END IF
                        END IF
                     ELSE
                        IF (X1 <= 0.250000000000000000E+00_dp) THEN
                           IF (X2 <= 0.437500000000000000E+00_dp) THEN
                              IF (X1 <= 0.125000000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.125000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.812500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 85))
                              ELSE
                                 TG1 = (2*X1 - 0.375000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.812500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 86))
                              END IF
                           ELSE
                              IF (X1 <= 0.125000000000000000E+00_dp) THEN
                                 IF (X2 <= 0.468750000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.125000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                    TG2 = (2*X2 - 0.906250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 87))
                                 ELSE
                                    TG1 = (2*X1 - 0.125000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                    TG2 = (2*X2 - 0.968750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 88))
                                 END IF
                              ELSE
                                 IF (X2 <= 0.468750000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.375000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                    TG2 = (2*X2 - 0.906250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 89))
                                 ELSE
                                    TG1 = (2*X1 - 0.375000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                    TG2 = (2*X2 - 0.968750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 90))
                                 END IF
                              END IF
                           END IF
                        ELSE
                           IF (X2 <= 0.437500000000000000E+00_dp) THEN
                              IF (X2 <= 0.406250000000000000E+00_dp) THEN
                                 IF (X1 <= 0.375000000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.625000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                    TG2 = (2*X2 - 0.781250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 91))
                                 ELSE
                                    TG1 = (2*X1 - 0.875000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                    TG2 = (2*X2 - 0.781250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 92))
                                 END IF
                              ELSE
                                 TG1 = (2*X1 - 0.750000000000000000E+00_dp)*0.400000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.843750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 93))
                              END IF
                           ELSE
                              TG1 = (2*X1 - 0.750000000000000000E+00_dp)*0.400000000000000000E+01_dp
                              TG2 = (2*X2 - 0.937500000000000000E+00_dp)*0.160000000000000000E+02_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 94))
                           END IF
                        END IF
                     END IF
                  END IF
               ELSE
                  IF (X2 <= 0.250000000000000000E+00_dp) THEN
                     IF (X2 <= 0.125000000000000000E+00_dp) THEN
                        TG1 = (2*X1 - 0.150000000000000000E+01_dp)*0.200000000000000000E+01_dp
                        TG2 = (2*X2 - 0.125000000000000000E+00_dp)*0.800000000000000000E+01_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 95))
                     ELSE
                        IF (X2 <= 0.187500000000000000E+00_dp) THEN
                           IF (X1 <= 0.750000000000000000E+00_dp) THEN
                              TG1 = (2*X1 - 0.125000000000000000E+01_dp)*0.400000000000000000E+01_dp
                              TG2 = (2*X2 - 0.312500000000000000E+00_dp)*0.160000000000000000E+02_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 96))
                           ELSE
                              IF (X1 <= 0.875000000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.162500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.312500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 97))
                              ELSE
                                 IF (X2 <= 0.156250000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.187500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                    TG2 = (2*X2 - 0.281250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 98))
                                 ELSE
                                    TG1 = (2*X1 - 0.187500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                    TG2 = (2*X2 - 0.343750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 99))
                                 END IF
                              END IF
                           END IF
                        ELSE
                           IF (X1 <= 0.750000000000000000E+00_dp) THEN
                              IF (X1 <= 0.625000000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.437500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 100))
                              ELSE
                                 TG1 = (2*X1 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.437500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 101))
                              END IF
                           ELSE
                              IF (X1 <= 0.875000000000000000E+00_dp) THEN
                                 IF (X2 <= 0.218750000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.162500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                    TG2 = (2*X2 - 0.406250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 102))
                                 ELSE
                                    TG1 = (2*X1 - 0.162500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                    TG2 = (2*X2 - 0.468750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 103))
                                 END IF
                              ELSE
                                 IF (X2 <= 0.218750000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.187500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                    TG2 = (2*X2 - 0.406250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 104))
                                 ELSE
                                    TG1 = (2*X1 - 0.187500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                    TG2 = (2*X2 - 0.468750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 105))
                                 END IF
                              END IF
                           END IF
                        END IF
                     END IF
                  ELSE
                     IF (X2 <= 0.375000000000000000E+00_dp) THEN
                        IF (X1 <= 0.750000000000000000E+00_dp) THEN
                           IF (X2 <= 0.312500000000000000E+00_dp) THEN
                              IF (X1 <= 0.625000000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.562500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 106))
                              ELSE
                                 TG1 = (2*X1 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.562500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 107))
                              END IF
                           ELSE
                              IF (X1 <= 0.625000000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 108))
                              ELSE
                                 TG1 = (2*X1 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 109))
                              END IF
                           END IF
                        ELSE
                           IF (X2 <= 0.312500000000000000E+00_dp) THEN
                              IF (X1 <= 0.875000000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.162500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.562500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 110))
                              ELSE
                                 TG1 = (2*X1 - 0.187500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.562500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 111))
                              END IF
                           ELSE
                              IF (X1 <= 0.875000000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.162500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 112))
                              ELSE
                                 IF (X1 <= 0.937500000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.181250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 113))
                                 ELSE
                                    TG1 = (2*X1 - 0.193750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 114))
                                 END IF
                              END IF
                           END IF
                        END IF
                     ELSE
                        IF (X1 <= 0.750000000000000000E+00_dp) THEN
                           IF (X1 <= 0.625000000000000000E+00_dp) THEN
                              TG1 = (2*X1 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                              TG2 = (2*X2 - 0.875000000000000000E+00_dp)*0.800000000000000000E+01_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 115))
                           ELSE
                              IF (X2 <= 0.437500000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.812500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 116))
                              ELSE
                                 TG1 = (2*X1 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.937500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 117))
                              END IF
                           END IF
                        ELSE
                           IF (X1 <= 0.875000000000000000E+00_dp) THEN
                              IF (X2 <= 0.437500000000000000E+00_dp) THEN
                                 IF (X1 <= 0.812500000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.156250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.812500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 118))
                                 ELSE
                                    TG1 = (2*X1 - 0.168750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.812500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 119))
                                 END IF
                              ELSE
                                 TG1 = (2*X1 - 0.162500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.937500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 120))
                              END IF
                           ELSE
                              IF (X2 <= 0.437500000000000000E+00_dp) THEN
                                 IF (X1 <= 0.937500000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.181250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.812500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 121))
                                 ELSE
                                    TG1 = (2*X1 - 0.193750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.812500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 122))
                                 END IF
                              ELSE
                                 TG1 = (2*X1 - 0.187500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.937500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 123))
                              END IF
                           END IF
                        END IF
                     END IF
                  END IF
               END IF
            ELSE
               IF (X1 <= 0.500000000000000000E+00_dp) THEN
                  IF (X2 <= 0.750000000000000000E+00_dp) THEN
                     IF (X1 <= 0.250000000000000000E+00_dp) THEN
                        TG1 = (2*X1 - 0.250000000000000000E+00_dp)*0.400000000000000000E+01_dp
                        TG2 = (2*X2 - 0.125000000000000000E+01_dp)*0.400000000000000000E+01_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 124))
                     ELSE
                        IF (X2 <= 0.625000000000000000E+00_dp) THEN
                           IF (X1 <= 0.375000000000000000E+00_dp) THEN
                              TG1 = (2*X1 - 0.625000000000000000E+00_dp)*0.800000000000000000E+01_dp
                              TG2 = (2*X2 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 125))
                           ELSE
                              TG1 = (2*X1 - 0.875000000000000000E+00_dp)*0.800000000000000000E+01_dp
                              TG2 = (2*X2 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 126))
                           END IF
                        ELSE
                           IF (X1 <= 0.375000000000000000E+00_dp) THEN
                              IF (X2 <= 0.687500000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.625000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.131250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 127))
                              ELSE
                                 TG1 = (2*X1 - 0.625000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.143750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 128))
                              END IF
                           ELSE
                              IF (X2 <= 0.687500000000000000E+00_dp) THEN
                                 IF (X1 <= 0.437500000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.812500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.131250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 129))
                                 ELSE
                                    TG1 = (2*X1 - 0.937500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.131250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 130))
                                 END IF
                              ELSE
                                 TG1 = (2*X1 - 0.875000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.143750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 131))
                              END IF
                           END IF
                        END IF
                     END IF
                  ELSE
                     IF (X1 <= 0.250000000000000000E+00_dp) THEN
                        IF (X2 <= 0.875000000000000000E+00_dp) THEN
                           IF (X1 <= 0.125000000000000000E+00_dp) THEN
                              TG1 = (2*X1 - 0.125000000000000000E+00_dp)*0.800000000000000000E+01_dp
                              TG2 = (2*X2 - 0.162500000000000000E+01_dp)*0.800000000000000000E+01_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 132))
                           ELSE
                              IF (X2 <= 0.812500000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.375000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.156250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 133))
                              ELSE
                                 IF (X1 <= 0.187500000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.312500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.168750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 134))
                                 ELSE
                                    TG1 = (2*X1 - 0.437500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.168750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 135))
                                 END IF
                              END IF
                           END IF
                        ELSE
                           IF (X1 <= 0.125000000000000000E+00_dp) THEN
                              IF (X2 <= 0.937500000000000000E+00_dp) THEN
                                 IF (X1 <= 0.625000000000000000E-01_dp) THEN
                                    TG1 = (2*X1 - 0.625000000000000000E-01_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.181250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 136))
                                 ELSE
                                    IF (X2 <= 0.906250000000000000E+00_dp) THEN
                                       TG1 = (2*X1 - 0.187500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                       TG2 = (2*X2 - 0.178125000000000000E+01_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 137))
                                    ELSE
                                       TG1 = (2*X1 - 0.187500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                       TG2 = (2*X2 - 0.184375000000000000E+01_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 138))
                                    END IF
                                 END IF
                              ELSE
                                 IF (X1 <= 0.625000000000000000E-01_dp) THEN
                                    IF (X2 <= 0.968750000000000000E+00_dp) THEN
                                       IF (X1 <= 0.312500000000000000E-01_dp) THEN
                                          TG1 = (2*X1 - 0.312500000000000000E-01_dp)*0.320000000000000000E+02_dp
                                          TG2 = (2*X2 - 0.190625000000000000E+01_dp)*0.320000000000000000E+02_dp
                                          CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 139))
                                       ELSE
                                          TG1 = (2*X1 - 0.937500000000000000E-01_dp)*0.320000000000000000E+02_dp
                                          TG2 = (2*X2 - 0.190625000000000000E+01_dp)*0.320000000000000000E+02_dp
                                          CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 140))
                                       END IF
                                    ELSE
                                       IF (X1 <= 0.312500000000000000E-01_dp) THEN
                                          IF (X2 <= 0.984375000000000000E+00_dp) THEN
                                             TG1 = (2*X1 - 0.312500000000000000E-01_dp)*0.320000000000000000E+02_dp
                                             TG2 = (2*X2 - 0.195312500000000000E+01_dp)*0.640000000000000000E+02_dp
                                             CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 141))
                                          ELSE
                                             TG1 = (2*X1 - 0.312500000000000000E-01_dp)*0.320000000000000000E+02_dp
                                             TG2 = (2*X2 - 0.198437500000000000E+01_dp)*0.640000000000000000E+02_dp
                                             CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 142))
                                          END IF
                                       ELSE
                                          TG1 = (2*X1 - 0.937500000000000000E-01_dp)*0.320000000000000000E+02_dp
                                          TG2 = (2*X2 - 0.196875000000000000E+01_dp)*0.320000000000000000E+02_dp
                                          CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 143))
                                       END IF
                                    END IF
                                 ELSE
                                    IF (X2 <= 0.968750000000000000E+00_dp) THEN
                                       IF (X1 <= 0.937500000000000000E-01_dp) THEN
                                          TG1 = (2*X1 - 0.156250000000000000E+00_dp)*0.320000000000000000E+02_dp
                                          TG2 = (2*X2 - 0.190625000000000000E+01_dp)*0.320000000000000000E+02_dp
                                          CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 144))
                                       ELSE
                                          TG1 = (2*X1 - 0.218750000000000000E+00_dp)*0.320000000000000000E+02_dp
                                          TG2 = (2*X2 - 0.190625000000000000E+01_dp)*0.320000000000000000E+02_dp
                                          CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 145))
                                       END IF
                                    ELSE
                                       TG1 = (2*X1 - 0.187500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                       TG2 = (2*X2 - 0.196875000000000000E+01_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 146))
                                    END IF
                                 END IF
                              END IF
                           ELSE
                              IF (X2 <= 0.937500000000000000E+00_dp) THEN
                                 IF (X1 <= 0.187500000000000000E+00_dp) THEN
                                    IF (X2 <= 0.906250000000000000E+00_dp) THEN
                                       TG1 = (2*X1 - 0.312500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                       TG2 = (2*X2 - 0.178125000000000000E+01_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 147))
                                    ELSE
                                       TG1 = (2*X1 - 0.312500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                       TG2 = (2*X2 - 0.184375000000000000E+01_dp)*0.320000000000000000E+02_dp
                                       CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 148))
                                    END IF
                                 ELSE
                                    TG1 = (2*X1 - 0.437500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.181250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 149))
                                 END IF
                              ELSE
                                 TG1 = (2*X1 - 0.375000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.193750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 150))
                              END IF
                           END IF
                        END IF
                     ELSE
                        IF (X2 <= 0.875000000000000000E+00_dp) THEN
                           IF (X1 <= 0.375000000000000000E+00_dp) THEN
                              IF (X2 <= 0.812500000000000000E+00_dp) THEN
                                 IF (X1 <= 0.312500000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.562500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.156250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 151))
                                 ELSE
                                    TG1 = (2*X1 - 0.687500000000000000E+00_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.156250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 152))
                                 END IF
                              ELSE
                                 TG1 = (2*X1 - 0.625000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.168750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 153))
                              END IF
                           ELSE
                              IF (X2 <= 0.812500000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.875000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.156250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 154))
                              ELSE
                                 TG1 = (2*X1 - 0.875000000000000000E+00_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.168750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 155))
                              END IF
                           END IF
                        ELSE
                           TG1 = (2*X1 - 0.750000000000000000E+00_dp)*0.400000000000000000E+01_dp
                           TG2 = (2*X2 - 0.187500000000000000E+01_dp)*0.800000000000000000E+01_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 156))
                        END IF
                     END IF
                  END IF
               ELSE
                  IF (X2 <= 0.750000000000000000E+00_dp) THEN
                     IF (X1 <= 0.750000000000000000E+00_dp) THEN
                        IF (X2 <= 0.625000000000000000E+00_dp) THEN
                           IF (X1 <= 0.625000000000000000E+00_dp) THEN
                              IF (X2 <= 0.562500000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.106250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 157))
                              ELSE
                                 IF (X1 <= 0.562500000000000000E+00_dp) THEN
                                    TG1 = (2*X1 - 0.106250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.118750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 158))
                                 ELSE
                                    TG1 = (2*X1 - 0.118750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    TG2 = (2*X2 - 0.118750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                    CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 159))
                                 END IF
                              END IF
                           ELSE
                              IF (X2 <= 0.562500000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.106250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 160))
                              ELSE
                                 TG1 = (2*X1 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.118750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 161))
                              END IF
                           END IF
                        ELSE
                           IF (X1 <= 0.625000000000000000E+00_dp) THEN
                              IF (X2 <= 0.687500000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.131250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 162))
                              ELSE
                                 TG1 = (2*X1 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.143750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 163))
                              END IF
                           ELSE
                              TG1 = (2*X1 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                              TG2 = (2*X2 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 164))
                           END IF
                        END IF
                     ELSE
                        IF (X2 <= 0.625000000000000000E+00_dp) THEN
                           IF (X1 <= 0.875000000000000000E+00_dp) THEN
                              IF (X2 <= 0.562500000000000000E+00_dp) THEN
                                 TG1 = (2*X1 - 0.162500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.106250000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 165))
                              ELSE
                                 TG1 = (2*X1 - 0.162500000000000000E+01_dp)*0.800000000000000000E+01_dp
                                 TG2 = (2*X2 - 0.118750000000000000E+01_dp)*0.160000000000000000E+02_dp
                                 CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 166))
                              END IF
                           ELSE
                              TG1 = (2*X1 - 0.187500000000000000E+01_dp)*0.800000000000000000E+01_dp
                              TG2 = (2*X2 - 0.112500000000000000E+01_dp)*0.800000000000000000E+01_dp
                              CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 167))
                           END IF
                        ELSE
                           TG1 = (2*X1 - 0.175000000000000000E+01_dp)*0.400000000000000000E+01_dp
                           TG2 = (2*X2 - 0.137500000000000000E+01_dp)*0.800000000000000000E+01_dp
                           CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 168))
                        END IF
                     END IF
                  ELSE
                     IF (X1 <= 0.750000000000000000E+00_dp) THEN
                        TG1 = (2*X1 - 0.125000000000000000E+01_dp)*0.400000000000000000E+01_dp
                        TG2 = (2*X2 - 0.175000000000000000E+01_dp)*0.400000000000000000E+01_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 169))
                     ELSE
                        TG1 = (2*X1 - 0.175000000000000000E+01_dp)*0.400000000000000000E+01_dp
                        TG2 = (2*X2 - 0.175000000000000000E+01_dp)*0.400000000000000000E+01_dp
                        CALL PD2VAL(RES, NDERIV, TG1, TG2, C0(1, 170))
                     END IF
                  END IF
               END IF
            END IF
         ELSE
            DO i = 1, NDERIV + 1
               RES(i) = 0.0_dp
            END DO
         END IF
      END IF
   END SUBROUTINE trunc_CS_poly_n20

! **************************************************************************************************
!> \brief ...
!> \param Nder the number of derivatives that will actually be used
!> \param iunit contains the data file to initialize the table
!> \param mepos ...
!> \param group ...
! **************************************************************************************************
   SUBROUTINE INIT(Nder, iunit, mepos, group)
      INTEGER, INTENT(IN)                                :: Nder, iunit, mepos

      CLASS(mp_comm_type), INTENT(IN)                     :: group

      INTEGER                                            :: I
      REAL(KIND=dp), ALLOCATABLE, DIMENSION(:)           :: chunk

      patches = 170
      IF (Nder > nderiv_max) CPABORT("Reading data for initialization of C0 failed")
      nderiv_init = Nder
      IF (ALLOCATED(C0)) DEALLOCATE (C0)
      ! round up to a multiple of 32 to give some generous alignment for each C0
      ALLOCATE (C0(32*((31 + (Nder + 1)*(degree + 1)*(degree + 2)/2)/32), patches))
      ! valgrind workaround
      C0 = HUGE(0.0_dp)
      IF (mepos == 0) THEN
         ALLOCATE (chunk((nderiv_max + 1)*(degree + 1)*(degree + 2)/2))
         DO I = 1, patches
            READ (iunit, *) chunk
            C0(1:(Nder + 1)*(degree + 1)*(degree + 2)/2, I) = chunk(1:(Nder + 1)*(degree + 1)*(degree + 2)/2)
         END DO
         DEALLOCATE (chunk)
      END IF
      CALL group%bcast(C0, 0)
   END SUBROUTINE INIT

! **************************************************************************************************
!> \brief ...
! **************************************************************************************************
   SUBROUTINE free_C0()
      IF (ALLOCATED(C0)) DEALLOCATE (C0)
      nderiv_init = -1
   END SUBROUTINE free_C0

! **************************************************************************************************
!> \brief ...
!> \param RES ...
!> \param NDERIV ...
!> \param TG1 ...
!> \param TG2 ...
!> \param C0 ...
! **************************************************************************************************
   SUBROUTINE PD2VAL(RES, NDERIV, TG1, TG2, C0)
      REAL(KIND=dp), INTENT(OUT)                         :: res(*)
      INTEGER, INTENT(IN)                                :: NDERIV
      REAL(KIND=dp), INTENT(IN)                          :: TG1, TG2, C0(136, *)

      REAL(KIND=dp), PARAMETER :: SQRT2 = 1.4142135623730950488016887242096980785696718753_dp

      INTEGER                                            :: K
      REAL(KIND=dp)                                      :: T1(0:15), T2(0:15)

      T1(0) = 1.0_dp
      T2(0) = 1.0_dp
      T1(1) = SQRT2*TG1
      T2(1) = SQRT2*TG2
      T1(2) = 2*TG1*T1(1) - SQRT2
      T2(2) = 2*TG2*T2(1) - SQRT2
      T1(3) = 2*TG1*T1(2) - T1(1)
      T2(3) = 2*TG2*T2(2) - T2(1)
      T1(4) = 2*TG1*T1(3) - T1(2)
      T2(4) = 2*TG2*T2(3) - T2(2)
      T1(5) = 2*TG1*T1(4) - T1(3)
      T2(5) = 2*TG2*T2(4) - T2(3)
      T1(6) = 2*TG1*T1(5) - T1(4)
      T2(6) = 2*TG2*T2(5) - T2(4)
      T1(7) = 2*TG1*T1(6) - T1(5)
      T2(7) = 2*TG2*T2(6) - T2(5)
      T1(8) = 2*TG1*T1(7) - T1(6)
      T2(8) = 2*TG2*T2(7) - T2(6)
      T1(9) = 2*TG1*T1(8) - T1(7)
      T2(9) = 2*TG2*T2(8) - T2(7)
      T1(10) = 2*TG1*T1(9) - T1(8)
      T2(10) = 2*TG2*T2(9) - T2(8)
      T1(11) = 2*TG1*T1(10) - T1(9)
      T2(11) = 2*TG2*T2(10) - T2(9)
      T1(12) = 2*TG1*T1(11) - T1(10)
      T2(12) = 2*TG2*T2(11) - T2(10)
      T1(13) = 2*TG1*T1(12) - T1(11)
      T2(13) = 2*TG2*T2(12) - T2(11)
      T1(14) = 2*TG1*T1(13) - T1(12)
      T2(14) = 2*TG2*T2(13) - T2(12)
      T1(15) = 2*TG1*T1(14) - T1(13)
      T2(15) = 2*TG2*T2(14) - T2(13)
      DO K = 1, NDERIV + 1
         RES(K) = 0.0_dp
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:15), C0(1:16, K))*T2(0)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:14), C0(17:31, K))*T2(1)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:13), C0(32:45, K))*T2(2)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:12), C0(46:58, K))*T2(3)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:11), C0(59:70, K))*T2(4)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:10), C0(71:81, K))*T2(5)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:9), C0(82:91, K))*T2(6)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:8), C0(92:100, K))*T2(7)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:7), C0(101:108, K))*T2(8)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:6), C0(109:115, K))*T2(9)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:5), C0(116:121, K))*T2(10)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:4), C0(122:126, K))*T2(11)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:3), C0(127:130, K))*T2(12)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:2), C0(131:133, K))*T2(13)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:1), C0(134:135, K))*T2(14)
         RES(K) = RES(K) + DOT_PRODUCT(T1(0:0), C0(136:136, K))*T2(15)
      END DO
   END SUBROUTINE PD2VAL

END MODULE t_sh_p_s_c
