/*!

\if MANPAGES
\page dcmpsmk Create DICOM grayscale softcopy presentation state
\else
\page dcmpsmk dcmpsmk: Create DICOM grayscale softcopy presentation state
\endif

\section dcmpsmk_synopsis SYNOPSIS

\verbatim
dcmpsmk [options] dcmfile-in dcmfile-out
\endverbatim

\section dcmpsmk_description DESCRIPTION

The \b dcmpsmk utility reads a DICOM image file and creates a grayscale
softcopy presentation state object according to Supplement 33.  The
presentation state object is written back to file.  A number of command line
options allow one to specify how certain constructs that might be present in
the image file should be referenced or activated in the presentation state.
The newly created presentation state references the source image and
contains values that should allow for a "reasonable" display of the image
when rendered under control of the presentation state.

\section dcmpsmk_parameters PARAMETERS

\verbatim
dcmfile-in   DICOM image file(s) to be read ("-" for stdin)

dcmfile-out  DICOM presentation state file to be created ("-" for stdout)
\endverbatim

\section dcmpsmk_options OPTIONS

\subsection dcmpsmk_general_options general options
\verbatim
  -h   --help
         print this help text and exit

       --version
         print version information and exit

       --arguments
         print expanded command line arguments

  -q   --quiet
         quiet mode, print no warnings and errors

  -v   --verbose
         verbose mode, print processing details

  -d   --debug
         debug mode, print debug information

  -ll  --log-level  [l]evel: string constant
         (fatal, error, warn, info, debug, trace)
         use level l for the logger

  -lc  --log-config  [f]ilename: string
         use config file f for the logger
\endverbatim

\subsection dcmpsmk_input_options input options
\verbatim
input file format:

  +f   --read-file
         read file format or data set (default)

  +fo  --read-file-only
         read file format only

  -f   --read-dataset
         read data set without file meta information

input transfer syntax:

  -t=  --read-xfer-auto
         use TS recognition (default)

  -td  --read-xfer-detect
         ignore TS specified in the file meta header

  -te  --read-xfer-little
         read with explicit VR little endian TS

  -tb  --read-xfer-big
         read with explicit VR big endian TS

  -ti  --read-xfer-implicit
         read with implicit VR little endian TS
\endverbatim

\subsection dcmpsmk_processing_options processing options
\verbatim
VOI transform handling:

  +Vl  --voi-lut
         use first VOI LUT if present (default)

  +Vw  --voi-window
         use first window center/width if present

  -V   --voi-ignore
         ignore VOI LUT and window center/width

curve handling:

  +c   --curve-activate
         activate curve data if present (default)

  -c   --curve-ignore
         ignore curve data

overlay handling:

  +oc  --overlay-copy
         copy overlays if not embedded, activate otherwise (default)

  +oa  --overlay-activate
         activate overlays

  -o   --overlay-ignore
         ignore overlays

shutter handling:

  +s   --shutter-activate
         use shutter if present in image (default)

  -s   --shutter-ignore
         ignore shutter

presentation LUT shape handling:

  +p   --plut-activate
         use presentation LUT shape if present (default)

  -p   --plut-ignore
         ignore presentation LUT shape

layering:

  +l1  --layer-single
         all curves and overlays are in one layer

  +l2  --layer-double
         one layer for curves, one for overlays (default)

  +ls  --layer-separate
         separate layers for each curve and overlay

location of referenced image:

  -lx  --location-none
         image reference without location (default)

  -ln  --location-network  [a]etitle: string
         image located at application entity a

  -lm  --location-media  [f]ilesetID, fileset[UID]: string
         image located on storage medium
\endverbatim

\subsection dcmpsmk_validation_options validation options
\verbatim
       --validate-std
          images referenced by GSPS must belong to the
          same SOP class (default)

       --validate-related
          images referenced by GSPS may belong to related
          'for presentation' and 'for processing' SOP class

       --validate-relaxed
          images referenced by GSPS may be any SOP class
\endverbatim

\subsection dcmpsmk_output_options output options
\verbatim
output transfer syntax:

  +t=   --write-xfer-same
          write with same TS as image file (default)

  +te   --write-xfer-little
          write with explicit VR little endian TS

  +tb   --write-xfer-big
          write with explicit VR big endian TS

  +ti   --write-xfer-implicit
          write with implicit VR little endian TS
\endverbatim

\section dcmpsmk_notes NOTES

If more than one input file (\e dcmfile-in) is specified, the additional image
files are only referenced from the created presentation state file, but no
further (e.g. display-related) information is taken over.

\section dcmpsmk_logging LOGGING

The level of logging output of the various command line tools and underlying
libraries can be specified by the user.  By default, only errors and warnings
are written to the standard error stream.  Using option \e --verbose also
informational messages like processing details are reported.  Option
\e --debug can be used to get more details on the internal activity, e.g. for
debugging purposes.  Other logging levels can be selected using option
\e --log-level.  In \e --quiet mode only fatal errors are reported.  In such
very severe error events, the application will usually terminate.  For more
details on the different logging levels, see documentation of module "oflog".

In case the logging output should be written to file (optionally with logfile
rotation), to syslog (Unix) or the event log (Windows) option \e --log-config
can be used.  This configuration file also allows for directing only certain
messages to a particular output stream and for filtering certain messages
based on the module or application where they are generated.  An example
configuration file is provided in <em>\<etcdir\>/logger.cfg</em>.

\section dcmpsmk_command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behavior conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator unless they appear between two
quotation marks) prior to any further evaluation.  Please note that a command
file cannot contain another command file.  This simple but effective approach
allows one to summarize common combinations of options/parameters and avoids
longish and confusing command lines (an example is provided in file
<em>\<datadir\>/dumppat.txt</em>).

\section dcmpsmk_environment ENVIRONMENT

The \b dcmpsmk utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<datadir\>/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behavior should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  On Windows systems,
a semicolon (";") is used as a separator.  The data dictionary code will
attempt to load each file specified in the \e DCMDICTPATH environment variable.
It is an error if no data dictionary can be loaded.

\section dcmpsmk_copyright COPYRIGHT

Copyright (C) 1998-2025 by OFFIS e.V., Escherweg 2, 26121 Oldenburg, Germany.

*/
