/*
 *
 *  Copyright (C) 2022, OFFIS e.V.
 *  All rights reserved.  See COPYRIGHT file for details.
 *
 *  This software and supporting documentation were developed by
 *
 *    OFFIS e.V.
 *    R&D Division Health
 *    Escherweg 2
 *    D-26121 Oldenburg, Germany
 *
 *
 *  Module:  oficonv
 *
 *  Author:  Marco Eichelberg
 *
 *  Purpose: JIS_X0201 related tables for oficonv unit tests
 *
 */

#ifndef TABLES_JIS_X0201_H
#define TABLES_JIS_X0201_H


unsigned char jis_x0201_characters[] = {
  0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
  0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
  0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
  0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
  0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
  0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e,
        0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
  0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
  0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
  0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf
};

unsigned char jis_x0201_to_utf8[] = {
  0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b,
  0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43,
  0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
  0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b,
  0xc2, 0xa5, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66,
  0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72,
  0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0xe2,
  0x80, 0xbe, 0xef, 0xbd, 0xa1, 0xef, 0xbd, 0xa2, 0xef, 0xbd, 0xa3, 0xef,
  0xbd, 0xa4, 0xef, 0xbd, 0xa5, 0xef, 0xbd, 0xa6, 0xef, 0xbd, 0xa7, 0xef,
  0xbd, 0xa8, 0xef, 0xbd, 0xa9, 0xef, 0xbd, 0xaa, 0xef, 0xbd, 0xab, 0xef,
  0xbd, 0xac, 0xef, 0xbd, 0xad, 0xef, 0xbd, 0xae, 0xef, 0xbd, 0xaf, 0xef,
  0xbd, 0xb0, 0xef, 0xbd, 0xb1, 0xef, 0xbd, 0xb2, 0xef, 0xbd, 0xb3, 0xef,
  0xbd, 0xb4, 0xef, 0xbd, 0xb5, 0xef, 0xbd, 0xb6, 0xef, 0xbd, 0xb7, 0xef,
  0xbd, 0xb8, 0xef, 0xbd, 0xb9, 0xef, 0xbd, 0xba, 0xef, 0xbd, 0xbb, 0xef,
  0xbd, 0xbc, 0xef, 0xbd, 0xbd, 0xef, 0xbd, 0xbe, 0xef, 0xbd, 0xbf, 0xef,
  0xbe, 0x80, 0xef, 0xbe, 0x81, 0xef, 0xbe, 0x82, 0xef, 0xbe, 0x83, 0xef,
  0xbe, 0x84, 0xef, 0xbe, 0x85, 0xef, 0xbe, 0x86, 0xef, 0xbe, 0x87, 0xef,
  0xbe, 0x88, 0xef, 0xbe, 0x89, 0xef, 0xbe, 0x8a, 0xef, 0xbe, 0x8b, 0xef,
  0xbe, 0x8c, 0xef, 0xbe, 0x8d, 0xef, 0xbe, 0x8e, 0xef, 0xbe, 0x8f, 0xef,
  0xbe, 0x90, 0xef, 0xbe, 0x91, 0xef, 0xbe, 0x92, 0xef, 0xbe, 0x93, 0xef,
  0xbe, 0x94, 0xef, 0xbe, 0x95, 0xef, 0xbe, 0x96, 0xef, 0xbe, 0x97, 0xef,
  0xbe, 0x98, 0xef, 0xbe, 0x99, 0xef, 0xbe, 0x9a, 0xef, 0xbe, 0x9b, 0xef,
  0xbe, 0x9c, 0xef, 0xbe, 0x9d, 0xef, 0xbe, 0x9e, 0xef, 0xbe, 0x9f
};

unsigned char jis_x0201_to_ascii[] = {
  0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b,
  0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43,
  0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
  0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b,
  0x3f, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
  0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73,
  0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x3f, 0x3f,
  0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
  0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
  0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
  0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
  0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,
  0x3f, 0x3f
};

#endif
