! This file is part of mstore.
! SPDX-Identifier: Apache-2.0
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.

module mstore_mb16_43
   use mctc_env_accuracy, only : wp
   use mctc_io_structure, only : structure_type, new
   use mstore_data_record, only : record_type, new_record, select_record
   implicit none
   private

   public :: get_mb16_43_records

contains

subroutine get_mb16_43_records(records)
   type(record_type), allocatable, intent(out) :: records(:)

   records = [ &
      new_record('01', mindless01), &
      new_record('02', mindless02), &
      new_record('03', mindless03), &
      new_record('04', mindless04), &
      new_record('05', mindless05), &
      new_record('06', mindless06), &
      new_record('07', mindless07), &
      new_record('08', mindless08), &
      new_record('09', mindless09), &
      new_record('10', mindless10), &
      new_record('11', mindless11), &
      new_record('12', mindless12), &
      new_record('13', mindless13), &
      new_record('14', mindless14), &
      new_record('15', mindless15), &
      new_record('16', mindless16), &
      new_record('17', mindless17), &
      new_record('18', mindless18), &
      new_record('19', mindless19), &
      new_record('20', mindless20), &
      new_record('21', mindless21), &
      new_record('22', mindless22), &
      new_record('23', mindless23), &
      new_record('24', mindless24), &
      new_record('25', mindless25), &
      new_record('26', mindless26), &
      new_record('27', mindless27), &
      new_record('28', mindless28), &
      new_record('29', mindless29), &
      new_record('30', mindless30), &
      new_record('31', mindless31), &
      new_record('32', mindless32), &
      new_record('33', mindless33), &
      new_record('34', mindless34), &
      new_record('35', mindless35), &
      new_record('36', mindless36), &
      new_record('37', mindless37), &
      new_record('38', mindless38), &
      new_record('39', mindless39), &
      new_record('40', mindless40), &
      new_record('41', mindless41), &
      new_record('42', mindless42), &
      new_record('43', mindless43), &
      new_record('AlH3', AlH3), &
      new_record('BH3', BH3), &
      new_record('BeH2', BeH2), &
      new_record('CH4', CH4), &
      new_record('Cl2', Cl2), &
      new_record('F2', F2), &
      new_record('H2', H2), &
      new_record('LiH', LiH), &
      new_record('MgH2', MgH2), &
      new_record('N2', N2), &
      new_record('NaH', NaH), &
      new_record('O2', O2), &
      new_record('P2', P2), &
      new_record('S2', S2), &
      new_record('SiH4', SiH4) &
      ]

end subroutine get_mb16_43_records

subroutine mindless01(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Na", "H", "O", "H", "F", "H", "H", "O", "N", "H", "H", "Cl", "B", "B", "N", "Al"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -1.85528263484662_wp,  3.58670515364616_wp, -2.41763729306344_wp, &
      &  4.40178023537845_wp,  0.02338844412653_wp, -4.95457749372945_wp, &
      & -2.98706033463438_wp,  4.76252065456814_wp,  1.27043301573532_wp, &
      &  0.79980886075526_wp,  1.41103455609189_wp, -5.04655321620119_wp, &
      & -4.20647469409936_wp,  1.84275767548460_wp,  4.55038084858449_wp, &
      & -3.54356121843970_wp, -3.18835665176557_wp,  1.46240021785588_wp, &
      &  2.70032160109941_wp,  1.06818452504054_wp, -1.73234650374438_wp, &
      &  3.73114088824361_wp, -2.07001543363453_wp,  2.23160937604731_wp, &
      & -1.75306819230397_wp,  0.35951417150421_wp,  1.05323406177129_wp, &
      &  5.41755788583825_wp, -1.57881830078929_wp,  1.75394002750038_wp, &
      & -2.23462868255966_wp, -2.13856505054269_wp,  4.10922285746451_wp, &
      &  1.01565866207568_wp, -3.21952154552768_wp, -3.36050963020778_wp, &
      &  2.42119255723593_wp,  0.26626435093114_wp, -3.91862474360560_wp, &
      & -3.02526098819107_wp,  2.53667889095925_wp,  2.31664984740423_wp, &
      & -2.00438948664892_wp, -2.29235136977220_wp,  2.19782807357059_wp, &
      &  1.12226554109716_wp, -1.36942007032045_wp,  0.48455055461782_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless01

subroutine mindless02(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "S", "B", "O", "Mg", "H", "H", "H", "Si", "H", "B", "Li", "F", "H", "H", "S"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -1.79537625851198_wp, -3.77866422935275_wp, -1.07883558363403_wp, &
      & -2.68278833302782_wp,  0.38892666265890_wp,  1.66214865238427_wp, &
      &  0.11484649791305_wp,  1.48857933226955_wp,  3.65660396510375_wp, &
      & -1.07998879593946_wp, -0.16259121615748_wp, -4.55703065871422_wp, &
      &  0.60302832999383_wp,  4.08816149622342_wp, -0.02589373148029_wp, &
      & -1.22534089315880_wp, -1.79981382478068_wp, -3.70773173318592_wp, &
      & -1.33460982049866_wp, -4.24819082475503_wp,  2.72791902701083_wp, &
      & -0.16278082578516_wp,  2.41267994179303_wp,  5.69030695190570_wp, &
      &  2.87802444057103_wp, -0.33120525058830_wp,  1.88311373530297_wp, &
      &  0.68489327931487_wp,  0.32790204044961_wp, -4.20547693710673_wp, &
      & -1.20919773588330_wp, -2.87253762561437_wp,  0.94064204223101_wp, &
      & -3.25572604597922_wp,  2.21241092990940_wp, -2.86715549314771_wp, &
      & -1.83147468262373_wp,  5.20527293771933_wp, -2.26976270603341_wp, &
      &  4.90885865772880_wp, -1.92576561961811_wp,  2.99069919443735_wp, &
      &  1.26806242248758_wp, -2.60409341782411_wp,  0.55162805282247_wp, &
      &  4.11956976339902_wp,  1.59892866766766_wp, -1.39117477789609_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless02

subroutine mindless03(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "O", "H", "Li", "Mg", "Al", "C", "H", "H", "H", "F", "S", "C", "H", "Na", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.02148551327524_wp, -0.67161751504297_wp, -4.75078512817560_wp, &
      &  1.37792545875526_wp, -3.24818416423144_wp,  3.83896600631495_wp, &
      & -2.23986953822894_wp,  1.64550402751694_wp,  3.42773272178522_wp, &
      & -0.87622711432790_wp, -2.74068400827752_wp,  1.43723692979592_wp, &
      &  1.29492470653815_wp,  1.86470311043681_wp, -1.04536500695239_wp, &
      & -3.65768365013010_wp,  0.45437052179208_wp, -1.41566056087159_wp, &
      & -0.23245910487384_wp, -1.83274112101585_wp, -2.43395808606122_wp, &
      &  0.30373451850419_wp, -3.84228931776777_wp, -2.44882782867802_wp, &
      & -3.36159503902161_wp,  4.20056392581975_wp,  1.63352684198071_wp, &
      &  0.49372989648081_wp, -1.56245253044952_wp, -6.53610501083288_wp, &
      &  4.38566058812996_wp,  1.86127331114460_wp,  0.56178822055152_wp, &
      & -1.17545963764009_wp,  2.49456345795141_wp, -4.90195191215762_wp, &
      & -1.86623614216854_wp,  2.76329843590746_wp,  1.71572598870213_wp, &
      &  1.02361259176985_wp, -4.24377370348987_wp,  5.32418288889440_wp, &
      &  4.71194535010347_wp, -1.03648125005561_wp,  3.35573062118779_wp, &
      & -0.16051737061546_wp,  3.89394681976155_wp,  2.23776331451663_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless03

subroutine mindless04(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "B", "H", "F", "B", "H", "H", "Si", "H", "H", "C", "Al", "Si", "O", "H", "B"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -1.34544890768411_wp,  2.85946545334720_wp,  3.11183388215396_wp, &
      & -0.36293929605305_wp,  4.15983774640545_wp,  1.36413101934678_wp, &
      & -3.36268280924844_wp,  4.92951597114402_wp, -3.59085684882314_wp, &
      &  3.78143178536443_wp, -4.97181356229699_wp,  1.59003443639387_wp, &
      &  3.44227417874042_wp, -3.46504338606415_wp,  3.62082644591507_wp, &
      &  1.88917586252014_wp,  3.42088101960529_wp,  1.28872629783483_wp, &
      & -0.32747529934233_wp, -4.29711514977711_wp, -3.55330460209973_wp, &
      & -3.58768360829779_wp, -1.39509759062952_wp, -1.10396714572410_wp, &
      & -0.39440896193088_wp,  6.31837673143592_wp,  1.99105318714945_wp, &
      &  4.34376903295874_wp, -4.12502353873667_wp,  5.57829602371555_wp, &
      & -1.39570266622309_wp, -2.60410756418652_wp, -4.03149806979915_wp, &
      &  0.21788515354592_wp,  0.28610741675369_wp,  1.29731097788136_wp, &
      & -2.00000183598828_wp,  3.04473467156937_wp, -2.00578147078785_wp, &
      &  2.12833842504876_wp, -1.30141517432227_wp,  3.38069910888504_wp, &
      & -2.48411958079522_wp, -2.81581487156584_wp, -5.76829803496286_wp, &
      & -0.54241147261516_wp, -0.04348817268188_wp, -3.16920520707912_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless04

subroutine mindless05(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "B", "P", "H", "H", "B", "P", "H", "Cl", "N", "H", "P", "Si", "H", "H", "P", "N"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.68391902268453_wp,  0.21679405065309_wp, -2.81441127558071_wp, &
      & -2.67199537993843_wp, -3.97743927106200_wp,  0.03497540139192_wp, &
      &  2.02325266152397_wp, -0.16048070975416_wp, -0.41980608052722_wp, &
      &  4.26224346168617_wp,  3.65384961705338_wp, -2.81836810458488_wp, &
      & -2.80378310343644_wp,  1.84796600006216_wp,  0.15107304476153_wp, &
      &  1.58317082705122_wp,  3.77079801391042_wp, -2.86230158107979_wp, &
      &  2.63670178694113_wp,  3.13142099211650_wp,  2.24139937019049_wp, &
      & -6.27112533979613_wp, -3.92471014080274_wp,  1.62562669834852_wp, &
      & -0.92594349239390_wp, -2.94451283088352_wp,  2.60616476876177_wp, &
      & -1.79532342290201_wp, -1.56841672860834_wp,  3.65515689388732_wp, &
      & -3.01460634915379_wp, -0.47748181717446_wp, -2.44834110183776_wp, &
      &  2.18249449208515_wp, -2.23505035804805_wp,  1.77725119258081_wp, &
      &  3.26068149442689_wp, -4.54078259646428_wp,  0.57204329987377_wp, &
      &  1.73744972267909_wp, -1.18654391698320_wp, -4.24063427353503_wp, &
      &  0.94405328902426_wp,  4.99525793054843_wp,  1.18501287451328_wp, &
      & -1.83118967048165_wp,  3.39933176543682_wp,  1.75515887283605_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless05

subroutine mindless06(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "B", "N", "H", "O", "B", "H", "Al", "H", "B", "Mg", "H", "H", "H", "H", "C", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.10912945825730_wp,  1.64180252123600_wp,  0.27838149792131_wp, &
      & -2.30085163837888_wp,  0.87765138232225_wp, -0.60457694150897_wp, &
      &  2.78083551168063_wp,  4.95421363506113_wp,  0.40788634984219_wp, &
      & -5.36229602768251_wp, -7.29510945515334_wp,  0.06097106408867_wp, &
      &  2.13846114572058_wp, -0.99012126457352_wp,  0.93647189687052_wp, &
      &  0.09330150731888_wp, -2.75648066796634_wp, -3.70294675694565_wp, &
      & -1.52684105316140_wp, -2.44981814860506_wp, -1.02727325811774_wp, &
      & -0.45240334635443_wp,  5.86105501765814_wp,  0.30815308772432_wp, &
      & -3.95419048213910_wp, -5.52061943693205_wp, -0.31702321028260_wp, &
      &  2.68706169520082_wp, -0.13577304635533_wp, -3.57041492458512_wp, &
      & -3.79914135008731_wp,  2.06429808651079_wp, -0.77285245656187_wp, &
      &  0.89693752015341_wp,  4.58640300917890_wp,  3.09718012019731_wp, &
      &  2.76317093138142_wp, -0.62928000132252_wp,  3.08807601371151_wp, &
      &  1.00075543259914_wp, -3.11885279872042_wp,  1.08659460804098_wp, &
      &  0.86969979951508_wp,  4.43363816376984_wp,  1.02355776570620_wp, &
      &  4.05637089597643_wp, -1.52300699610852_wp, -0.29218485610105_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless06

subroutine mindless07(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "B", "H", "H", "Cl", "F", "N", "C", "H", "S", "H", "H", "O", "F", "Mg"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -3.75104222741336_wp, -5.81308736205268_wp, -1.22507366840233_wp, &
      & -1.45226572768296_wp, -3.01878767879831_wp,  2.38723142561073_wp, &
      & -1.99423317853240_wp, -3.52953889999752_wp, -1.30301724065129_wp, &
      & -4.33750965171233_wp, -6.65936981001909_wp,  0.55979831484564_wp, &
      & -4.51833920602637_wp, -6.72398616322561_wp, -2.90031439001886_wp, &
      & -1.25657105633503_wp, -2.39389339457851_wp, -4.58765484136593_wp, &
      & -0.14864209579028_wp,  4.40065007854051_wp,  1.35717716022989_wp, &
      & -0.91662354168326_wp, -2.22680612180354_wp,  0.71122632634918_wp, &
      &  1.83282041695179_wp,  5.36061635978157_wp,  3.22095765094686_wp, &
      &  0.66518416413161_wp,  6.30980889882630_wp,  4.62705414435961_wp, &
      &  3.68701623423530_wp,  2.79957532381681_wp,  4.21336212424745_wp, &
      &  1.69373321407504_wp,  0.01030275402386_wp, -3.74820290941150_wp, &
      &  3.35791986589808_wp,  2.52513229318111_wp, -3.46078430541625_wp, &
      &  2.79199182665654_wp,  1.01759578021447_wp, -2.59243571461852_wp, &
      &  3.05358934464082_wp,  7.15252337445235_wp,  1.82164153773112_wp, &
      &  1.29297161858681_wp,  0.78926456763834_wp,  0.91903438556425_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless07

subroutine mindless08(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "O", "B", "F", "H", "Al", "H", "H", "O", "B", "Be", "C", "H", "H", "B", "F"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -1.27823293129313_wp,  0.06442674490989_wp,  2.76980447300615_wp, &
      &  2.05039033278229_wp,  0.64690940303039_wp, -0.29571013189632_wp, &
      & -0.07388472989895_wp,  2.46033979750309_wp, -1.30590420482375_wp, &
      &  1.10019432741349_wp,  4.43501067437330_wp, -2.64796515354449_wp, &
      & -1.89008873387150_wp,  0.02064696008121_wp,  4.74727599156952_wp, &
      &  0.81013963557610_wp,  1.41165582964016_wp, -6.35835508532445_wp, &
      &  2.51638337449170_wp,  1.74086425451198_wp,  3.45340860505386_wp, &
      &  2.62048878651566_wp, -1.58024532804571_wp,  2.87415150030394_wp, &
      & -0.92472602392464_wp, -3.37659091509259_wp, -0.68138826965952_wp, &
      & -2.19962829538645_wp, -2.53092502025386_wp,  1.35654623095955_wp, &
      &  0.92594749614406_wp, -1.61669775704536_wp, -1.93872059141561_wp, &
      &  1.63141903847248_wp,  0.18081362275364_wp,  2.42899361614054_wp, &
      & -3.96336280784845_wp, -3.68611886004249_wp,  2.18920954455515_wp, &
      & -1.17097381446263_wp,  1.08303722364990_wp, -3.04753977323348_wp, &
      & -2.18263847972349_wp,  2.31604957286801_wp,  1.11461091308323_wp, &
      &  2.02857282501340_wp, -1.56917620284149_wp, -4.65841766477431_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless08

subroutine mindless09(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "H", "H", "H", "Li", "H", "C", "B", "H", "H", "Si", "H", "Cl", "F", "H", "B"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.97360649552839_wp,  1.71723751297383_wp, -0.51862929250676_wp, &
      &  0.16903666216522_wp,  1.73154352333176_wp, -0.40099024352959_wp, &
      & -3.94463844105182_wp, -1.24346369608005_wp,  0.09565841726334_wp, &
      &  2.21647168119803_wp,  4.10625979391554_wp,  2.61391340002321_wp, &
      & -0.04488993380842_wp, -2.16288302687041_wp,  4.48488595610432_wp, &
      &  3.52287141817194_wp, -0.90500888687059_wp, -5.00916337263077_wp, &
      &  1.95336082370762_wp, -0.83849036872324_wp, -3.65515970516029_wp, &
      &  2.05706981818495_wp,  1.70095588601056_wp, -2.06303335904159_wp, &
      & -6.40097100472159_wp, -1.71072935987273_wp,  3.14621771036234_wp, &
      &  2.04751538182937_wp, -2.55691868000982_wp, -2.49926722310562_wp, &
      &  2.03251078714394_wp,  1.35094356516468_wp,  2.02150308748654_wp, &
      &  0.20477572129201_wp, -0.93291693232462_wp, -4.76431390827476_wp, &
      & -2.67673272939098_wp,  1.40764602033672_wp,  4.10347165469140_wp, &
      & -2.75901984658887_wp, -3.73954809548334_wp,  3.19373273207227_wp, &
      &  1.96938102642596_wp,  3.74070925169244_wp, -3.03185101883736_wp, &
      & -4.32034786008576_wp, -1.66533650719069_wp,  2.28302516508337_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless09

subroutine mindless10(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "Si", "H", "Cl", "C", "H", "F", "H", "C", "N", "B", "H", "Mg", "C", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.57062307661218_wp, -1.68792229443234_wp,  2.78939425857465_wp, &
      & -2.08994110527129_wp,  3.25317728228563_wp, -0.42147881550833_wp, &
      &  2.13532981939105_wp, -1.71356933061236_wp, -2.49234593851880_wp, &
      & -2.46885241522113_wp, -4.41076598859264_wp, -0.58746410797603_wp, &
      &  3.86605901148259_wp, -0.50808683490216_wp,  1.10929274542242_wp, &
      & -4.57284898019279_wp, -1.54920337824862_wp, -2.63711913350102_wp, &
      & -4.99945502320431_wp,  0.09990896897876_wp, -3.20268495970371_wp, &
      &  1.63618508154720_wp,  2.66791559582643_wp, -3.16904643876699_wp, &
      & -2.28445827511587_wp,  0.42792856662334_wp,  2.04433546457507_wp, &
      &  0.78486183614848_wp,  1.96692225005484_wp, -1.58921219981020_wp, &
      & -0.92003258313224_wp, -1.56076484060483_wp,  0.46494611026243_wp, &
      & -1.07970143095156_wp,  1.19037461384346_wp,  3.56880222429743_wp, &
      &  3.27327901654007_wp,  3.47628642644825_wp,  1.85050408639730_wp, &
      &  1.64922592697103_wp, -0.66726875777723_wp, -0.77306391492380_wp, &
      &  5.67004330685832_wp, -1.05218123504276_wp,  0.25282456342591_wp, &
      & -4.17031726246173_wp,  0.06724895615223_wp,  2.79231605575371_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless10

subroutine mindless11(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "F", "H", "C", "C", "Al", "H", "Mg", "H", "H", "O", "B", "H", "N", "B", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.39399122975547_wp,  5.14091896117130_wp,  4.40928318999264_wp, &
      &  4.06332599724680_wp,  2.89333815085921_wp, -4.32833111947385_wp, &
      & -2.22845292206017_wp,  0.42002793309425_wp, -3.45868055251423_wp, &
      & -1.49770451057766_wp, -1.68069171985484_wp, -2.73673542549826_wp, &
      &  1.19115081293635_wp, -4.28146043880485_wp, -1.99531977473885_wp, &
      & -0.74372091358381_wp, -4.83538319731112_wp,  1.50555116376334_wp, &
      &  2.51199102196632_wp,  0.60313325365867_wp, -2.59127249049262_wp, &
      &  0.42939862473241_wp, -4.04511919109908_wp,  1.83194992963925_wp, &
      &  3.75865865959758_wp,  4.13006538213244_wp,  0.61345157103729_wp, &
      &  2.49256631740965_wp,  2.81253718525177_wp,  0.83420623708204_wp, &
      &  0.87698843423605_wp,  3.19044830120342_wp,  2.87972538495414_wp, &
      &  0.06460247530076_wp, -7.06337733119705_wp, -2.26231893768320_wp, &
      & -1.18984344172052_wp,  1.57849953113440_wp,  3.23008867846786_wp, &
      & -3.09720852623704_wp,  0.17024869437589_wp,  3.09924834582518_wp, &
      & -4.87920132697979_wp, -1.13329080601198_wp,  3.07863000348210_wp, &
      & -3.14654193202239_wp,  2.10010529139757_wp, -4.10947620384282_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless11

subroutine mindless12(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "B", "C", "Cl", "P", "H", "B", "F", "H", "O", "Al", "Al", "H", "N", "N", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -4.35721344494385_wp,  0.90297887659219_wp,  0.82819233141540_wp, &
      &  0.28337212071123_wp,  1.65183522650412_wp, -0.76130120690799_wp, &
      &  0.40499986618945_wp, -2.21558439545454_wp, -6.16499989069313_wp, &
      &  4.15644868219944_wp, -2.19476121076230_wp, -4.94369195800440_wp, &
      & -0.72928258377481_wp, -1.13601712855358_wp,  1.45660672033766_wp, &
      & -4.70639755670489_wp,  2.26855027951224_wp,  3.76265136193590_wp, &
      & -5.47771378344344_wp, -1.52436798778786_wp,  0.66383610284043_wp, &
      &  6.21507264154963_wp,  2.27878148270302_wp, -0.80373330514543_wp, &
      & -4.87554903473953_wp,  3.28951364055773_wp,  5.82073438127352_wp, &
      &  3.86713990157750_wp, -4.59193470093940_wp, -1.31571887753581_wp, &
      &  3.86803648047669_wp,  0.42734990415643_wp, -0.80771778802946_wp, &
      & -4.96472075857332_wp,  2.33939507094589_wp, -0.85409476439592_wp, &
      & -1.39618131239632_wp,  0.41936067926590_wp,  0.50672702152227_wp, &
      &  3.98116786771506_wp, -2.53173594891645_wp,  1.24535230245461_wp, &
      & -0.51006577527794_wp,  3.27396147305804_wp, -1.77306674565962_wp, &
      &  4.24088668943515_wp, -2.65732526088144_wp,  3.14022431459194_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless12

subroutine mindless13(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "S", "H", "H", "H", "Mg", "N", "O", "S", "N", "N", "C", "H", "C", "H", "O", "N"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.57574036035327_wp, -4.02282764325494_wp, -4.10271573398965_wp, &
      & -1.40533385551419_wp,  5.29619535860537_wp,  1.19133909911655_wp, &
      & -4.10030165367002_wp, -3.47444607088170_wp, -0.84824917779295_wp, &
      &  2.89658127013424_wp,  2.43629490376305_wp,  5.50411332444429_wp, &
      &  2.45223989880149_wp, -2.00772987824320_wp, -0.15398865213557_wp, &
      & -1.51712879417944_wp,  2.30053850878811_wp, -1.75239637267891_wp, &
      & -0.24289876757842_wp,  4.82009844091674_wp,  2.63475101874460_wp, &
      & -3.00492618118656_wp, -3.88480103564452_wp, -3.11946558561028_wp, &
      &  0.11173458099590_wp,  1.31688888517734_wp, -0.06206428896608_wp, &
      &  0.00524925248702_wp, -4.76711579851013_wp, -1.90726480440786_wp, &
      &  2.57601813355660_wp,  1.32908831557216_wp,  3.75986393037341_wp, &
      & -2.04043480418002_wp,  1.05827175168348_wp, -3.15072404226943_wp, &
      &  0.69751576100407_wp,  2.58138323259360_wp,  2.02510177710824_wp, &
      & -0.01728451336903_wp, -6.68439661497786_wp, -1.71305216173944_wp, &
      & -2.63921004165725_wp,  4.45065100898568_wp, -1.54188290181614_wp, &
      &  3.65243935400236_wp, -0.74809336457323_wp,  3.23663457161927_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless13

subroutine mindless14(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "O", "Al", "Si", "H", "Li", "H", "Cl", "Al", "H", "H", "B", "H", "H", "B", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -1.88332360130493_wp,  2.53007018112862_wp, -3.98608409275760_wp, &
      &  3.27699641160873_wp, -0.08631186370352_wp,  3.67688206792605_wp, &
      & -1.16614867306779_wp, -0.32037853786420_wp,  1.69058708847006_wp, &
      & -5.46850272430429_wp,  4.57266985537483_wp, -0.52932965856254_wp, &
      &  0.97164309414888_wp,  0.66747218768211_wp, -3.25964102581397_wp, &
      & -2.71819679481837_wp,  3.29559046821708_wp, -5.41688109011592_wp, &
      &  2.85413254707780_wp, -3.25426055782090_wp, -3.79200415312706_wp, &
      & -3.09698974374561_wp,  2.78925413414222_wp, -0.83815690575307_wp, &
      &  2.34072910305112_wp, -3.87746592952390_wp, -1.28536131379933_wp, &
      & -1.36811706056119_wp, -5.33992924257833_wp,  1.85884414777145_wp, &
      &  0.32243267919508_wp, -3.89767157004043_wp,  2.33599294560113_wp, &
      & -0.70224139290426_wp,  4.73181417800063_wp,  0.83802421106008_wp, &
      &  1.09114517030528_wp, -4.08447628058437_wp,  4.49611170180434_wp, &
      &  0.64162207927749_wp,  2.85728024980057_wp,  1.42502824903478_wp, &
      &  2.20119350049594_wp, -4.36085483793465_wp,  0.98418737138644_wp, &
      &  2.70362540554619_wp,  3.77719756570419_wp,  1.80180045687518_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless14

subroutine mindless15(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "H", "Si", "H", "Na", "S", "H", "H", "Al", "H", "C", "Si", "Cl", "B", "B", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -3.61478930225678_wp,  3.93645943144797_wp,  6.51030060445427_wp, &
      &  0.61236907478983_wp, -6.51759578912215_wp, -1.76934035726066_wp, &
      &  1.57630708202517_wp, -4.10115032100919_wp, -2.82579187907104_wp, &
      & -1.97320774600117_wp, -1.17546431655209_wp, -0.87295648907904_wp, &
      &  5.13463622899929_wp,  0.77090632447117_wp, -0.60327683123775_wp, &
      &  0.80018620160269_wp,  2.05990685666801_wp, -3.50442438462677_wp, &
      & -2.63169697740212_wp, -1.50450649386349_wp, -4.55963505869507_wp, &
      & -4.43315123481822_wp,  2.67584248182708_wp, -1.51015562837913_wp, &
      &  2.46073116204381_wp,  2.20893876320240_wp,  3.99000166203290_wp, &
      &  3.78074851536128_wp, -3.38741952485899_wp, -1.17756344627767_wp, &
      & -1.17537958130662_wp,  2.50624310668895_wp,  2.62487185864947_wp, &
      & -1.88900890700459_wp,  2.02234287084311_wp, -0.58612350123645_wp, &
      &  2.08821790641218_wp,  3.12116385815725_wp,  8.02735873215896_wp, &
      & -0.92280146340488_wp, -1.25632251283573_wp, -3.09913865635809_wp, &
      & -2.52751267815688_wp,  3.27297273732310_wp,  4.69811218606474_wp, &
      &  2.71435171911696_wp, -4.63231747238742_wp, -5.34223881113872_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless15

subroutine mindless16(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Si", "H", "O", "B", "H", "B", "H", "Si", "Mg", "H", "B", "Mg", "H", "H", "Al", "Li"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.35657681818464_wp,  1.56413352120650_wp,  0.15633191455554_wp, &
      &  3.73917059667152_wp,  4.62925085487901_wp, -2.78650603123275_wp, &
      &  3.14560604851984_wp,  2.89719360409943_wp, -2.78417514965298_wp, &
      & -0.77007531623341_wp,  2.61211360015145_wp,  2.33311615406392_wp, &
      & -0.66443402867749_wp,  4.05997385957096_wp,  4.06971059462416_wp, &
      & -1.35794144684175_wp, -3.75758532634922_wp, -0.38278945412140_wp, &
      & -2.23158951954857_wp,  3.52161941806966_wp,  0.71501793840421_wp, &
      & -1.21528967345105_wp, -1.22312093897026_wp,  3.34968237398899_wp, &
      & -2.91125704119979_wp,  0.39569409719795_wp, -1.08361131016514_wp, &
      & -1.52127986148665_wp, -5.83354834109118_wp,  0.65117354687277_wp, &
      &  0.96426075166446_wp, -1.73395662042913_wp, -0.29756953994186_wp, &
      &  1.76477233718293_wp, -5.12961800838251_wp,  2.54274889905822_wp, &
      & -2.66597958259665_wp,  1.28123105561800_wp, -4.29750060549502_wp, &
      & -3.13008195341572_wp, -3.60405914945209_wp, -1.88201177072058_wp, &
      &  3.70343741730607_wp, -0.47466561516456_wp,  4.15636571641078_wp, &
      &  0.79410445392162_wp,  0.79534398904606_wp, -4.45998327664881_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless16

subroutine mindless17(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Mg", "B", "H", "C", "Si", "B", "F", "F", "H", "H", "F", "H", "H", "O", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.68460861953273_wp, -1.46442870252660_wp,  1.67856153340039_wp, &
      & -0.18053173984261_wp, -3.96944005202894_wp, -0.80661420861966_wp, &
      & -0.58984435587144_wp, -5.98708837691298_wp, -1.71743303841248_wp, &
      &  1.07719032312989_wp, -1.76303169348468_wp, -2.22950669619910_wp, &
      &  0.24421210314383_wp,  1.76887707010948_wp, -4.26437232785349_wp, &
      & -1.64589939447879_wp, -0.90586156069035_wp, -2.45065764617243_wp, &
      &  0.71078922997216_wp,  0.88479326169415_wp,  3.64517056373104_wp, &
      &  5.77984092031648_wp, -2.28654280723977_wp,  2.67325530102119_wp, &
      & -3.50012299703202_wp, -1.32272929604435_wp, -1.24933974739626_wp, &
      & -0.52632555428452_wp, -3.77091486672575_wp,  1.47071730349011_wp, &
      & -0.27536787387566_wp,  4.17239735599888_wp, -2.08796280751818_wp, &
      & -1.56874517509641_wp,  4.33699624911296_wp,  0.52992881707066_wp, &
      & -1.79332867160074_wp,  5.69507449430072_wp,  3.22335048552804_wp, &
      & -2.07387284201988_wp,  4.10380585322630_wp,  2.35332246894739_wp, &
      & -0.64011933245457_wp,  2.42620166307914_wp,  3.12632079492992_wp, &
      &  2.29751674046149_wp, -1.91810859186826_wp, -3.89474079594712_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless17

subroutine mindless18(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "B", "O", "F", "B", "H", "H", "B", "H", "H", "H", "Al", "H", "H", "N", "Cl", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.40067197598477_wp, -0.08985341973088_wp, -0.35360803293282_wp, &
      & -2.83282958022577_wp,  2.19543863961379_wp, -2.18955384738373_wp, &
      &  5.76472816382552_wp, -0.49603864211693_wp, -1.21358566654694_wp, &
      & -1.70657706313951_wp, -2.05255181572206_wp,  1.55052937602492_wp, &
      &  1.58835041779542_wp, -4.83165774154759_wp, -0.48805672906064_wp, &
      &  3.54674889802012_wp,  3.80881069243976_wp,  0.32571615345912_wp, &
      &  1.16082415084961_wp, -2.68836939011385_wp,  0.10500536580848_wp, &
      & -2.11113140454788_wp, -2.49669165662651_wp,  3.73236603932328_wp, &
      &  2.92912991112290_wp, -2.02449672449414_wp,  1.55839966416896_wp, &
      &  1.63937827184425_wp, -1.46234301835244_wp, -1.90571308865243_wp, &
      & -0.98466979025434_wp,  2.17972514177944_wp,  1.02443512211936_wp, &
      & -2.34515635373322_wp,  4.36572054230165_wp,  2.55396166772487_wp, &
      & -4.08748558787908_wp,  3.52482829165651_wp, -2.37153781897694_wp, &
      &  2.37963551318215_wp,  2.29174375751632_wp,  0.30075348600901_wp, &
      & -4.58734878956482_wp, -2.74804845935684_wp, -0.43511853641680_wp, &
      & -3.75426873328011_wp,  0.52378380275384_wp, -2.19399315466763_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless18

subroutine mindless19(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "F", "P", "Al", "H", "H", "Al", "B", "Li", "P", "O", "H", "H", "B", "S", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.14132037405479_wp, -1.34402701877044_wp, -2.32492500904728_wp, &
      &  4.46671289205392_wp, -2.04800110524830_wp,  0.44422406067087_wp, &
      & -4.92212517643478_wp, -1.73734240529793_wp,  0.96890323821450_wp, &
      & -1.30966093045696_wp, -0.52977363497805_wp,  3.44453452239668_wp, &
      & -4.34208759006189_wp, -4.30470270977329_wp,  0.39887431726215_wp, &
      &  0.61788392767516_wp,  2.62484136683297_wp, -3.28228926932647_wp, &
      &  4.23562873444840_wp, -1.68839322682951_wp, -3.53824299552792_wp, &
      &  2.23130060612446_wp,  1.93579813100155_wp, -1.80384647554323_wp, &
      & -2.32285463652832_wp,  2.90603947535842_wp, -1.39684847191937_wp, &
      &  2.34557941578250_wp,  2.86074312333371_wp,  1.82827238641666_wp, &
      & -3.66431367659153_wp, -0.42910188232667_wp, -1.81957402856634_wp, &
      & -0.34927881505446_wp, -1.75988134003940_wp,  5.98017466326572_wp, &
      &  0.29500802281217_wp, -2.00226104143537_wp,  0.53023447931897_wp, &
      &  2.10449364205058_wp, -0.56741404446633_wp,  0.30975625014335_wp, &
      & -1.59355304432499_wp,  3.69176153150419_wp,  2.87878226787916_wp, &
      &  4.34858700256050_wp,  2.39171478113440_wp, -2.61802993563738_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless19

subroutine mindless20(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "H", "C", "P", "F", "B", "H", "N", "B", "H", "B", "F", "C", "N", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -3.56132327758016_wp, -0.50590085238174_wp, -2.98614943377472_wp, &
      &  6.12190813023731_wp, -2.35228748938866_wp,  3.75935201941147_wp, &
      & -4.34282032833498_wp, -0.28678181437038_wp, -1.09805777877152_wp, &
      &  2.57052144742115_wp, -0.40247030519467_wp, -2.56572964270492_wp, &
      & -3.92097125925856_wp,  1.48036650758191_wp,  3.29415948733951_wp, &
      & -6.66911427573612_wp, -1.35341771485854_wp, -0.49846319808505_wp, &
      &  8.56365434130296_wp, -1.33222529253566_wp,  1.52783471671607_wp, &
      & -0.52141451750542_wp,  2.33438421612239_wp,  0.56035230733389_wp, &
      & -2.90954166080909_wp,  1.18276803449089_wp,  0.93797224746425_wp, &
      &  0.38193015332468_wp,  3.29737018144725_wp,  1.94924416561643_wp, &
      &  4.70530986478769_wp, -1.06561959276401_wp,  0.10586810360697_wp, &
      & -8.81215551493898_wp, -2.31081594790128_wp,  0.13341415744873_wp, &
      &  6.55717403671558_wp, -1.61464395571515_wp,  1.88882216641417_wp, &
      &  0.89613231382312_wp,  2.23420396330817_wp, -1.69658088413948_wp, &
      &  0.04418757944144_wp,  3.17060517011463_wp, -3.13808838478374_wp, &
      &  0.89652296710938_wp, -2.47553510795512_wp, -2.17395004909208_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless20

subroutine mindless21(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Na", "H", "O", "H", "Mg", "H", "Al", "H", "H", "Mg", "O", "Cl", "Al", "H", "H", "B"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.18294129861388_wp,  5.17635425576036_wp,  2.53512139200503_wp, &
      & -2.72683247182739_wp, -3.39194667454037_wp, -0.23834227870370_wp, &
      & -0.75855366175094_wp,  4.74691008582543_wp, -1.39927620499620_wp, &
      &  2.92739319491602_wp,  2.44443575873615_wp,  3.14458209862877_wp, &
      &  1.23919567811335_wp, -4.41897159427163_wp,  0.43226401019214_wp, &
      &  3.20937545665750_wp, -3.21142881515834_wp, -6.05888536934730_wp, &
      &  0.72746311456760_wp,  1.71619994623856_wp, -1.05009965494641_wp, &
      & -2.72808139383107_wp, -0.90803839524278_wp, -3.09682306663388_wp, &
      &  4.30751115261870_wp, -3.28792293589283_wp, -1.12225460514131_wp, &
      & -1.42549717482863_wp, -0.69918554185533_wp,  3.08847148976639_wp, &
      &  1.27708807641867_wp,  2.08872674593635_wp,  2.44160017407866_wp, &
      & -4.19981191531758_wp,  1.67962269920133_wp,  5.53173981599153_wp, &
      &  2.61978965708327_wp, -1.73857224072923_wp, -3.50050404806289_wp, &
      & -1.18491506495268_wp,  5.29299905806450_wp, -3.08723184000056_wp, &
      &  0.40552851269042_wp, -3.78948940166016_wp,  3.71336381217627_wp, &
      & -1.50671186194339_wp, -1.69969295041205_wp, -1.33372572500655_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless21

subroutine mindless22(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "H", "H", "B", "B", "H", "O", "B", "F", "O", "H", "H", "H", "H", "P", "Mg"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -1.94633525554584_wp,  0.76523114833346_wp,  1.47848728292319_wp, &
      & -4.93627611113503_wp, -1.40472357851712_wp,  0.57813131556686_wp, &
      &  2.68035091393186_wp,  3.39299374217513_wp, -0.75280185443442_wp, &
      &  3.18312913740965_wp, -2.83960214951919_wp,  4.14575667208970_wp, &
      & -2.87645831021461_wp, -0.72812797332544_wp, -0.03990006847521_wp, &
      &  4.54477823998069_wp, -2.22476569460365_wp,  5.84989380425193_wp, &
      & -3.15308294343285_wp,  0.82283912288745_wp, -2.60880967309348_wp, &
      & -1.02937353133672_wp,  2.15641193645999_wp, -3.74734760025429_wp, &
      &  3.34021375526521_wp,  3.26781422716865_wp,  1.00328254253346_wp, &
      &  1.14900648531048_wp,  1.80864640998484_wp, -2.62409200296276_wp, &
      & -1.46073358039106_wp, -2.49318585671109_wp, -0.52815256357786_wp, &
      &  0.95816379318560_wp, -2.24379778592308_wp,  4.40361781268138_wp, &
      & -4.82975145183797_wp,  0.99654217508314_wp, -3.32099025490788_wp, &
      & -1.56028643371105_wp,  3.40289100235743_wp, -5.54839314536270_wp, &
      &  4.24796764058348_wp, -4.30865125995802_wp,  1.23020585937669_wp, &
      &  1.68868765193817_wp, -0.37051546589254_wp,  0.48111187364535_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless22

subroutine mindless23(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "B", "B", "H", "Si", "F", "H", "B", "H", "H", "H", "B", "Si", "Mg", "H", "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.11226811981015_wp, -0.34829022873845_wp,  2.99467697524931_wp, &
      & -2.70575071298185_wp,  0.39203568257658_wp,  0.05902962839189_wp, &
      & -1.67212147447562_wp, -0.25733294261485_wp,  3.20596020928315_wp, &
      &  0.96175764793059_wp,  2.37163677024038_wp, -2.71929022289959_wp, &
      &  1.34195252438576_wp, -3.41541089620698_wp, -2.44405531765901_wp, &
      &  6.46179227612364_wp,  2.96948122446421_wp, -0.28421526119262_wp, &
      &  3.97795770734757_wp, -2.10437813202892_wp, -2.45007590661560_wp, &
      &  0.10303801907593_wp, -1.34209338428340_wp,  0.47773368299374_wp, &
      & -0.09333056042480_wp, -1.17539208076900_wp, -4.22254331763940_wp, &
      & -2.83116129967151_wp,  1.93429756935911_wp,  1.89498088881455_wp, &
      & -4.75406228128583_wp, -0.45342556282377_wp, -0.69214106681206_wp, &
      & -0.46445005936450_wp,  0.58205511412942_wp, -2.45480806761419_wp, &
      & -3.81083864563332_wp,  2.30229031632066_wp, -3.01117465244618_wp, &
      &  3.75187610627302_wp,  1.01556798375282_wp, -0.13684110066950_wp, &
      &  2.50443413007552_wp, -1.00891850335955_wp,  4.35200185857142_wp, &
      & -3.88336149718475_wp, -1.46212293001823_wp,  5.43076167024403_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless23

subroutine mindless24(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "F", "F", "S", "H", "F", "Si", "F", "B", "O", "Al", "Si", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.09865488361584_wp, -0.26671334694805_wp,  0.11500959614593_wp, &
      & -1.92814086292263_wp, -1.45998030208190_wp, -4.24391725069101_wp, &
      & -2.21886651291371_wp,  2.91386873291865_wp, -3.77185364430026_wp, &
      & -1.80829769338283_wp,  3.55187677596079_wp,  4.84533539088538_wp, &
      &  1.86278571650446_wp,  0.18303211232547_wp,  7.25066846579634_wp, &
      &  1.64100680865153_wp,  0.93120851006911_wp, -3.03778024953160_wp, &
      &  0.56268968453809_wp,  0.30643961016893_wp,  4.79676981566217_wp, &
      & -1.12018434926383_wp, -2.25909022646758_wp,  4.57242730025606_wp, &
      & -0.72562705793597_wp,  1.10073670067262_wp, -4.74190662922398_wp, &
      &  2.51867281723794_wp,  0.25924267813357_wp,  2.43925198268054_wp, &
      &  2.68588765571021_wp, -1.12501707883434_wp, -0.47969569301419_wp, &
      & -2.61964500070239_wp, -2.87086316695570_wp, -0.96424383638923_wp, &
      & -2.28212601322933_wp,  3.44447540722543_wp,  2.34350654710912_wp, &
      &  0.38434593261636_wp, -3.50656190921757_wp, -0.80265928122267_wp, &
      & -0.04372765394735_wp,  1.17102391854365_wp, -6.87774979736687_wp, &
      &  5.18988141265529_wp, -2.37367841551304_wp, -1.44316271679574_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless24

subroutine mindless25(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "F", "H", "H", "H", "F", "H", "B", "Si", "B", "O", "O", "H", "Al", "H", "Si", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.34615971967753_wp, -0.32487631307947_wp,  0.36295506410253_wp, &
      &  1.23470648296579_wp,  2.76472739537673_wp,  2.08715883633936_wp, &
      &  0.11018468901374_wp, -3.08598457265941_wp, -1.56537087783620_wp, &
      &  0.00099062312950_wp, -3.45088739451521_wp,  2.05584324530526_wp, &
      &  3.74680704395100_wp, -1.35058106165553_wp, -3.70978888902154_wp, &
      & -3.87316731190805_wp, -0.57667961683030_wp, -5.44301329318868_wp, &
      &  0.14758906961964_wp, -1.85868623991030_wp,  0.35622957758409_wp, &
      &  3.21383803887858_wp,  0.76442871069754_wp,  1.57574470089075_wp, &
      &  2.54882601862486_wp,  0.04048780648020_wp, -1.95191520913567_wp, &
      &  0.39009007110805_wp, -0.79801092246434_wp,  6.48773967147244_wp, &
      & -3.90459172949880_wp,  1.07524270743641_wp, -4.68003134495453_wp, &
      & -0.17076402953610_wp,  0.85174102149428_wp,  5.91242096734190_wp, &
      & -2.20173933951191_wp,  2.04693764708250_wp, -2.14699446407170_wp, &
      & -2.36753646444433_wp,  4.78334707524571_wp, -1.06495600626915_wp, &
      &  2.43785524253901_wp, -2.47888809178607_wp,  4.76512876180488_wp, &
      &  1.03307131474654_wp,  1.59768184908728_wp, -3.04115074036373_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless25

subroutine mindless26(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "O", "Si", "O", "H", "H", "P", "H", "H", "H", "Al", "H", "Mg", "C", "H", "H", "B"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  5.08825653091502_wp,  0.44352916480174_wp,  0.08850248839538_wp, &
      &  0.75534149154358_wp, -1.83381849972773_wp, -3.25229032100481_wp, &
      & -0.40054830558360_wp,  3.68637632308404_wp,  2.66746869501338_wp, &
      &  1.07302048624435_wp,  1.14412637759041_wp, -3.17460784535229_wp, &
      &  6.40020577519895_wp,  0.23989411943900_wp,  1.35440387005988_wp, &
      &  4.94817833728034_wp, -2.27655215927096_wp, -1.93186622868265_wp, &
      & -3.71038931702480_wp,  1.27927811321010_wp, -1.64748149522948_wp, &
      & -5.66300559633635_wp, -0.92964215623398_wp, -0.11362730531415_wp, &
      &  0.36174564342390_wp, -1.68123238650515_wp,  1.34858640393055_wp, &
      & -3.35648004589935_wp,  2.43523042931631_wp,  2.80296247550590_wp, &
      & -5.42817561752809_wp,  3.18729352868201_wp,  4.83637380167112_wp, &
      &  1.52777505763427_wp,  1.71483188592975_wp,  0.53368975540377_wp, &
      & -3.80116638785181_wp, -0.02788071018658_wp, -0.01958135836029_wp, &
      &  5.94409956827520_wp, -1.00469206955903_wp, -4.08095307428878_wp, &
      & -2.13927094853889_wp, -4.25463088963778_wp,  0.56557772168051_wp, &
      & -1.59958667175270_wp, -2.12211107093212_wp,  0.02284241657192_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless26

subroutine mindless27(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "Cl", "N", "O", "Al", "C", "S", "H", "H", "H", "N", "H", "C", "B", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.24620648234201_wp, -1.69331336761231_wp, -0.82752015945012_wp, &
      &  4.52583545689861_wp, -0.97585115608949_wp,  4.75049668273442_wp, &
      &  3.80663917558727_wp, -0.07541859006097_wp, -1.92163821706463_wp, &
      &  1.12020949831801_wp, -1.26331518615184_wp, -5.24003632715075_wp, &
      &  2.77077621768203_wp, -0.77378752543158_wp,  1.23718420801436_wp, &
      & -0.33818709415505_wp,  3.09675653380296_wp,  1.19932140232875_wp, &
      & -4.65734076459232_wp, -0.06781273039264_wp,  2.17987129847942_wp, &
      &  1.62834965303657_wp,  3.16036172454468_wp,  1.94505131031944_wp, &
      & -1.42844657913855_wp,  4.15289573473359_wp,  2.60527449747832_wp, &
      & -1.16286573775269_wp, -3.51628664831911_wp, -1.09208270016905_wp, &
      & -6.01542230621291_wp, -2.70707429207954_wp,  1.28689921067607_wp, &
      & -0.24308537312679_wp,  4.20564492524565_wp, -0.55046241271179_wp, &
      &  1.58833470074036_wp, -0.99850958870202_wp, -3.00531439491895_wp, &
      & -1.59912313311372_wp,  0.38726161224598_wp,  0.61695287723810_wp, &
      & -4.91313413399993_wp, -3.53495260753947_wp, -0.09300711000276_wp, &
      &  5.16366690217116_wp,  0.60340116180604_wp, -3.09099016580079_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless27

subroutine mindless28(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "N", "N", "H", "F", "H", "H", "H", "B", "H", "B", "H", "Al", "H", "O", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -4.77113461867124_wp,  0.51921475758691_wp, -0.02227545826337_wp, &
      & -2.19604031741465_wp,  1.60743242600343_wp, -0.06191093579691_wp, &
      & -3.04068070232779_wp, -2.05762521765496_wp, -2.06693712080406_wp, &
      & -0.09290106020388_wp, -2.46999326860004_wp, -3.03442840385113_wp, &
      & -0.59812664741059_wp, -1.98509239606299_wp,  1.76124600573536_wp, &
      &  4.69545652063269_wp,  1.00475507388473_wp,  2.02283235441832_wp, &
      & -1.58265296473335_wp,  1.71741096330492_wp, -1.90557671433315_wp, &
      &  2.98421139377606_wp,  1.41884430242964_wp,  0.57599937241164_wp, &
      &  2.69220467161312_wp,  3.59932020182625_wp,  0.00599256113336_wp, &
      & -0.03138464521918_wp,  0.32184357481265_wp,  1.75217917635981_wp, &
      & -0.32750384668821_wp,  1.02636660625371_wp,  3.87195175957206_wp, &
      &  2.06546608375037_wp, -2.26672292101151_wp, -0.59446715243159_wp, &
      &  3.65576711322340_wp, -4.66942394116901_wp,  0.06237695093514_wp, &
      & -4.76008849702644_wp, -1.64045275175894_wp, -1.37746065425525_wp, &
      &  3.74606052126127_wp,  0.45053251417757_wp, -1.54563200857096_wp, &
      & -2.43865300456156_wp,  3.42359007597762_wp,  0.55611026774069_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless28

subroutine mindless29(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "S", "Si", "F", "H", "H", "H", "H", "B", "H", "F", "F", "C", "N", "Li", "H", "B"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.53673507425188_wp,  3.99507323885206_wp,  1.55715066130074_wp, &
      & -3.07737286911969_wp,  0.32958703140654_wp, -0.29111275363830_wp, &
      & -0.90425452031684_wp, -1.43212833553986_wp,  5.30476824707744_wp, &
      &  1.39557510304364_wp, -0.97102221315848_wp, -0.90265330978463_wp, &
      &  0.36176777266221_wp,  2.54151175821408_wp, -5.48453558072427_wp, &
      & -1.29200695930432_wp, -5.37261851507424_wp,  3.84828452605234_wp, &
      & -2.23318041755225_wp, -2.44248025076844_wp,  1.53520950131838_wp, &
      &  0.83757858645274_wp,  2.25239366602931_wp, -3.30153286211756_wp, &
      & -0.24590359165577_wp, -1.68122466359558_wp, -3.48056269425221_wp, &
      & -4.72999576650605_wp, -1.42587426107348_wp, -2.24209845479198_wp, &
      &  1.79916114955707_wp, -2.92228936110041_wp,  2.34181872059793_wp, &
      &  1.93301568225445_wp,  4.21559229438933_wp, -1.59731897723933_wp, &
      &  0.08927265541336_wp, -0.30230247619135_wp, -2.17180854392205_wp, &
      &  1.86508908526015_wp,  0.40457167112912_wp,  3.95286034161327_wp, &
      &  2.40809970783612_wp,  6.06219779987045_wp, -2.37748662505823_wp, &
      & -0.74358069227670_wp, -3.25098738338901_wp,  3.30901780356843_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless29

subroutine mindless30(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "F", "F", "B", "C", "F", "F", "Si", "F", "H", "H", "S", "H", "H", "Li", "Li", "Al"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.35482780620483_wp,  2.69517552604475_wp, -2.56262865840600_wp, &
      & -4.29664774931055_wp, -1.60934079963824_wp,  3.33098405108049_wp, &
      &  1.08292927645438_wp, -2.41580347067355_wp, -3.96302193135335_wp, &
      & -0.39887441180269_wp,  2.99952569754639_wp,  1.30758229109368_wp, &
      &  4.59628533948414_wp,  1.01941186492018_wp,  1.78810087893105_wp, &
      & -3.96640595241071_wp, -0.28687175702578_wp, -1.05357076267703_wp, &
      &  2.93521225417215_wp,  3.34714278393498_wp,  0.39574204131248_wp, &
      &  2.98984146033511_wp, -3.24471166070361_wp, -5.41016516912380_wp, &
      & -0.62659344976548_wp,  3.79103115730366_wp,  3.21572179231212_wp, &
      & -0.31251767976269_wp, -0.87906712336825_wp, -4.82943716846292_wp, &
      &  0.66584399899298_wp, -3.76712493867650_wp, -0.85271163980940_wp, &
      & -1.53100607144279_wp,  4.13473581761254_wp, -0.01029097559062_wp, &
      &  0.33160888189911_wp, -1.47515295715015_wp,  3.91802577232059_wp, &
      &  3.17924391695390_wp, -2.19723784512016_wp,  2.46598922567729_wp, &
      & -6.41493573453774_wp, -1.43764333393204_wp,  0.78030211077994_wp, &
      & -1.58881188546398_wp, -0.67406896107423_wp,  1.47937814191545_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless30

subroutine mindless31(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "H", "C", "B", "H", "P", "O", "Cl", "Al", "P", "B", "H", "F", "P", "H", "P"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.79274810283778_wp,  3.82998228828316_wp, -2.79287054959216_wp, &
      & -1.43447454186833_wp,  0.43418729987882_wp,  5.53854345129809_wp, &
      & -3.26268343665218_wp, -2.50644032426151_wp, -1.56631149351046_wp, &
      &  2.14548759959147_wp, -0.88798018953965_wp, -2.24592534506187_wp, &
      & -4.30233097423181_wp, -3.93631518670031_wp, -0.48930754109119_wp, &
      &  0.06107643564880_wp, -3.82467931731366_wp, -2.22333344469482_wp, &
      &  0.41168550401858_wp,  0.58105573172764_wp,  5.56854609916143_wp, &
      &  4.41363836635653_wp,  3.92515871809283_wp,  2.57961724984000_wp, &
      &  1.33707758998700_wp,  1.40194471661647_wp,  1.97530004949523_wp, &
      &  3.08342709834868_wp,  1.72520024666801_wp, -4.42666116106828_wp, &
      & -3.02346932078505_wp,  0.04438199934191_wp, -0.27636197425010_wp, &
      &  1.11508390868455_wp, -0.97617412809198_wp,  6.25462847718180_wp, &
      &  0.61938955433011_wp,  2.17903547389232_wp, -6.21279842416963_wp, &
      & -2.67491681346835_wp,  3.00175899761859_wp,  1.05038813614845_wp, &
      & -4.13181080289514_wp, -2.34226739863660_wp, -3.44356159392859_wp, &
      &  2.85007173009739_wp, -2.64884892757600_wp,  0.71010806424206_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless31

subroutine mindless32(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Si", "H", "N", "H", "F", "B", "F", "B", "B", "H", "H", "H", "H", "Al", "Li", "S"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.80685149395399_wp, -0.18082593449508_wp, -3.30571286894111_wp, &
      & -1.16329402202021_wp, -1.00697515973340_wp,  2.91205604195522_wp, &
      &  2.73507082240027_wp,  0.90625147651169_wp,  2.62422193900388_wp, &
      &  1.70410509005372_wp, -3.20602870287555_wp,  1.61878148639311_wp, &
      & -4.64335840488757_wp,  1.83035537458832_wp,  0.94057402097667_wp, &
      &  0.84431392308369_wp, -0.96623794870498_wp,  1.84233078868657_wp, &
      & -1.88461463389674_wp, -4.24913696695397_wp, -0.62534635016924_wp, &
      &  0.66843725271797_wp, -3.30389141237550_wp, -0.83741044724369_wp, &
      &  1.61498043043493_wp,  2.59118961360492_wp,  0.75381456362374_wp, &
      & -3.03500291825856_wp,  5.93071034427450_wp, -1.81816264166002_wp, &
      &  4.57548897629847_wp,  0.43682466837615_wp,  2.29943033667038_wp, &
      &  2.16157250693937_wp, -4.85901289730729_wp, -1.51122062149659_wp, &
      & -1.88264848388850_wp,  1.01849494669503_wp, -2.82641937504102_wp, &
      & -2.06588257374175_wp,  3.59661080458449_wp, -0.23493377941025_wp, &
      & -3.70513094370430_wp, -1.43496411645908_wp,  0.58457030199158_wp, &
      &  3.26911148451517_wp,  2.89663591026976_wp, -2.41657339533921_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless32

subroutine mindless33(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "H", "H", "N", "Al", "C", "S", "F", "H", "S", "H", "H", "H", "B", "N", "B"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.98595010375570_wp,  0.69603461915421_wp,  2.03438177944977_wp, &
      &  0.34662685363856_wp,  3.22344677251486_wp, -3.30140409538948_wp, &
      & -0.59584974855826_wp, -0.46550932258965_wp, -5.85128583249012_wp, &
      & -0.13040702867760_wp,  1.73584317556754_wp, -2.16870618406503_wp, &
      & -1.21814604567531_wp,  2.65173548387321_wp,  1.07958972122996_wp, &
      & -2.77871213157299_wp, -2.46850870157840_wp, -2.46402775980056_wp, &
      &  0.68121780081704_wp, -1.83256178623512_wp,  4.85256384498170_wp, &
      &  4.35584697039899_wp,  0.44416813870209_wp, -0.88290564172520_wp, &
      & -3.17116441149853_wp, -4.20595925507553_wp, -3.47409041399858_wp, &
      & -4.77082349340764_wp,  0.40467059690846_wp,  2.25189364264341_wp, &
      &  2.12622885652594_wp,  2.30788590428860_wp,  4.63979493638384_wp, &
      &  2.61559406074676_wp,  0.85658164096989_wp, -1.60495411572440_wp, &
      &  3.07341625574771_wp, -2.47784188426153_wp,  5.47801341799639_wp, &
      & -1.15768049002676_wp, -0.40576456023730_wp, -3.65139427334525_wp, &
      &  1.51955973242177_wp,  1.04480712344963_wp,  3.31146491250984_wp, &
      & -3.88165728463531_wp, -1.50902794545099_wp, -0.24893393865636_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless33

subroutine mindless34(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "F", "B", "H", "N", "Al", "C", "H", "P", "O", "H", "O", "H", "Mg", "H", "Si"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.23980113909674_wp, -0.71718988629406_wp, -4.95813363141336_wp, &
      & -2.58855576067787_wp, -1.29452359720472_wp,  0.68009949938747_wp, &
      & -0.06392998656889_wp, -0.19669220286248_wp,  1.18303565189036_wp, &
      &  1.79426936474380_wp, -3.88702385280115_wp,  2.41727936477534_wp, &
      & -0.34118501500562_wp,  2.09796955621762_wp,  2.90569675213891_wp, &
      &  1.55219980060992_wp,  4.30462117577208_wp,  0.26808163865786_wp, &
      &  1.98731758110000_wp, -2.39001830906911_wp,  0.99706061919075_wp, &
      &  3.94329945799359_wp, -1.68821293858197_wp,  1.08022376229859_wp, &
      & -3.07330629587161_wp,  4.09289916915300_wp,  2.05097545073640_wp, &
      & -1.59203748370749_wp, -0.77115776516204_wp, -4.74904990701402_wp, &
      &  0.02541349701989_wp,  2.04119118400858_wp,  4.78993104897985_wp, &
      &  1.56367709335188_wp, -3.57872340767051_wp, -1.45575467949619_wp, &
      & -4.96553706422700_wp,  2.16753242295326_wp,  2.22041320042979_wp, &
      & -3.00686589574692_wp,  1.16067252159400_wp, -2.17558505445076_wp, &
      &  0.51590408956965_wp,  1.04879072594139_wp, -0.91579153486619_wp, &
      &  1.00953547831986_wp, -2.39013479599388_wp, -4.33848218124478_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless34

subroutine mindless35(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "B", "Si", "H", "P", "H", "O", "Li", "Al", "C", "B", "H", "Cl", "H", "Al", "C", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.29968630061798_wp, -2.54698821741503_wp, -2.09875910728905_wp, &
      & -3.24221683970416_wp,  4.60313082845957_wp, -2.82834629504841_wp, &
      &  4.13820676246960_wp,  1.42236978460233_wp,  0.47903356390473_wp, &
      &  3.16822235720641_wp, -2.79589819414689_wp,  2.95484106063974_wp, &
      & -0.12113228109330_wp, -4.71057631951744_wp, -2.56814415961438_wp, &
      & -0.57782853814089_wp, -0.74764565149345_wp, -4.08981082821461_wp, &
      & -1.88135705145627_wp,  1.87631730609432_wp,  1.37440110459172_wp, &
      &  5.00302258828032_wp, -3.30267641173818_wp, -1.27679729987481_wp, &
      &  1.15971855883715_wp, -1.57808646023889_wp,  0.39501991102896_wp, &
      & -1.63072847887697_wp,  1.34506894851975_wp, -3.55087225384462_wp, &
      & -4.99931287425375_wp,  3.21535360571389_wp, -1.00184385576628_wp, &
      & -2.90103792053413_wp,  0.00836332942810_wp,  4.99980833854173_wp, &
      &  1.80607242587923_wp,  1.73808761461682_wp,  2.99309378574787_wp, &
      & -1.70530236897872_wp, -4.08425814858802_wp,  3.51378699856504_wp, &
      &  2.63880273545079_wp,  0.48816026599651_wp,  1.57001912544046_wp, &
      & -1.15481537570334_wp,  5.06927771970654_wp, -0.86543008880803_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless35

subroutine mindless36(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "N", "H", "H", "C", "H", "P", "H", "H", "Li", "Cl", "O", "H", "H", "O", "H", "F"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.72026039063660_wp,  1.94792776305125_wp, -5.74839384859916_wp, &
      & -0.84543746941483_wp, -2.76063595266465_wp,  3.25512487375100_wp, &
      &  0.42496325206265_wp, -1.13137230811820_wp,  5.94925432127412_wp, &
      &  0.73091739872398_wp, -1.62520801360841_wp,  3.96243051766001_wp, &
      &  2.08263001835807_wp,  2.48151896850828_wp, -3.91676880596756_wp, &
      &  0.93173606993270_wp,  1.22139896442741_wp,  2.12342719368603_wp, &
      &  2.49166516448853_wp, -2.68929418564968_wp,  3.76672970789632_wp, &
      &  2.18596324893896_wp,  3.02814775290213_wp, -7.27239706984257_wp, &
      & -0.83202319008680_wp, -1.38577494350811_wp, -2.84157423983172_wp, &
      & -3.33222580042752_wp, -4.17535211831009_wp, -1.06603963837401_wp, &
      &  1.06245496232071_wp,  0.87147007927368_wp, -0.71397686940212_wp, &
      & -1.01720777936165_wp,  2.81895189135679_wp,  2.93934804552141_wp, &
      & -4.40064484920013_wp, -1.34855542034685_wp,  0.83160825302155_wp, &
      &  0.23748703828597_wp,  0.04907716296823_wp, -6.09654345501890_wp, &
      &  3.11565884869782_wp,  2.46364888638105_wp,  3.02311078284745_wp, &
      & -4.55619730395500_wp,  0.23405147333712_wp,  1.80466023137818_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless36

subroutine mindless37(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "B", "Si", "B", "O", "H", "S", "Al", "C", "H", "B", "H", "S", "F", "O", "B", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.38227394912931_wp, -3.92401441781010_wp,  2.21505886871659_wp, &
      & -4.94372933010698_wp,  1.91842004530398_wp, -0.89165147046564_wp, &
      &  2.89284938378182_wp, -2.44102930364194_wp, -0.15397687135886_wp, &
      & -0.51640333675590_wp, -3.71051083175890_wp,  3.89580351163823_wp, &
      & -6.95344510576003_wp,  3.12791073229668_wp, -2.42603992152638_wp, &
      &  4.06161550341566_wp, -5.57237127854899_wp,  1.04913523625188_wp, &
      & -1.68633091396224_wp, -1.36962331222993_wp,  1.76665363503174_wp, &
      & -5.12097683596175_wp, -0.85240899589182_wp,  0.84478410804784_wp, &
      & -0.37308113391534_wp,  1.69457579037097_wp,  1.20436111441585_wp, &
      & -1.29992227296702_wp,  2.66541126974260_wp, -0.85104497647149_wp, &
      & -6.67603282861319_wp, -2.17448534752515_wp,  1.07006713718671_wp, &
      &  0.92382492277113_wp,  3.69618669756465_wp, -2.96256454520918_wp, &
      &  6.14728576770757_wp,  2.91741749696644_wp, -2.71885339324426_wp, &
      &  3.94256882536540_wp, -0.73161790953702_wp, -1.60109065974385_wp, &
      &  4.17725576830437_wp,  2.03961674741162_wp, -1.30539484310864_wp, &
      &  4.04224763756721_wp,  2.71652261728687_wp,  0.86475306983942_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless37

subroutine mindless38(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "Si", "H", "Al", "H", "H", "Si", "H", "N", "H", "C", "S", "F", "N", "B", "P"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  5.47121230577729_wp,  4.58582823547938_wp,  0.26961202336008_wp, &
      &  6.10811241517809_wp,  1.59903076060873_wp,  5.11446275480878_wp, &
      &  1.67686561896040_wp, -2.71100335106841_wp,  3.92741578422061_wp, &
      & -4.15310136820012_wp, -4.14519681045295_wp, -4.30146372203325_wp, &
      & -5.78681709028396_wp,  1.00635179481995_wp, -0.99487217800318_wp, &
      &  2.24435173366916_wp,  2.32727846357570_wp, -0.79104514019846_wp, &
      &  3.15000984231788_wp, -0.53680527725251_wp,  2.90884054024936_wp, &
      & -5.37610073022013_wp, -1.19333129700653_wp,  1.19041542410208_wp, &
      & -5.32212376673330_wp, -0.85217693431390_wp, -0.71563017276632_wp, &
      &  7.64423524881630_wp,  6.36396131667655_wp,  3.09322741880209_wp, &
      &  1.50897285982493_wp,  0.61501728333733_wp,  0.11316406359547_wp, &
      & -7.69307313996996_wp, -2.84523417328937_wp, -2.28760590559557_wp, &
      & -4.07644564667803_wp, -6.32039655979874_wp, -6.54656042235985_wp, &
      & -0.50460336013170_wp, -0.35421029143537_wp, -0.92248115306910_wp, &
      & -2.45190183007916_wp, -1.53146337280276_wp, -1.90293570297557_wp, &
      &  7.56040690775227_wp,  3.99235021292296_wp,  1.84545638786277_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless38

subroutine mindless39(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Li", "Cl", "F", "H", "H", "Na", "B", "H", "C", "H", "H", "F", "C", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.06521084486823_wp,  0.08218432748393_wp, -3.31794862285397_wp, &
      & -2.32042477766402_wp, -5.46684392277772_wp, -4.04262137940086_wp, &
      &  2.26054697581965_wp, -3.03018226193694_wp, -4.64150015772052_wp, &
      & -0.14839777550969_wp, -0.43671669092912_wp,  5.46349590128611_wp, &
      &  1.25506764958846_wp,  3.72255296450239_wp,  3.12461655723367_wp, &
      & -3.70871338035337_wp, -1.70938913801338_wp, -1.44451499871032_wp, &
      & -0.50789889989427_wp, -0.08663524018430_wp,  3.25334078665520_wp, &
      &  1.95889668026174_wp, -0.69562876271128_wp,  1.49780663184774_wp, &
      & -0.13609934796341_wp,  2.63877103476555_wp,  2.01392332556491_wp, &
      & -2.03651637484513_wp, -1.53932035918944_wp,  2.35235290216748_wp, &
      &  1.01732693290435_wp,  4.50598465234050_wp, -1.41360090365614_wp, &
      & -1.21371363315079_wp,  1.45147299379122_wp, -2.46002878669847_wp, &
      &  0.99959759042027_wp,  2.58862220349908_wp, -0.61148816085282_wp, &
      &  1.82755250562899_wp, -1.68931361321449_wp,  2.62013289657120_wp, &
      & -1.90490242357524_wp,  3.74722938063725_wp,  2.11670736907658_wp, &
      &  0.59246743346417_wp, -4.08278756806328_wp, -4.51067336050986_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine mindless39

subroutine mindless40(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "B", "C", "Si", "N", "H", "H", "H", "H", "C", "Al", "C", "B", "B", "Si", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.74796224766529_wp, -2.46540130579202_wp, -0.01108444894225_wp, &
      &  0.49023445484593_wp,  3.00285508043919_wp, -4.24166509685101_wp, &
      &  1.72676061244275_wp,  0.47303274699649_wp,  2.84576000369214_wp, &
      & -1.76447271124602_wp,  0.36677971666465_wp,  3.86532658343247_wp, &
      & -2.72959974594335_wp, -2.33613000671033_wp,  2.24932292815969_wp, &
      &  4.58179870910052_wp, -0.74357959179408_wp,  0.17263495762094_wp, &
      &  2.32012933285707_wp,  2.45217987313074_wp,  3.06690075244411_wp, &
      & -4.76760943738786_wp, -5.37367547108355_wp,  0.76477596804281_wp, &
      & -2.02263802608789_wp,  3.07373512039521_wp, -4.45677646359359_wp, &
      &  2.52077188267503_wp, -0.55245612309763_wp,  0.22041236236107_wp, &
      & -4.54474339494448_wp,  0.16477189451264_wp, -0.39353128248210_wp, &
      & -4.23775185098846_wp, -3.37879141035877_wp,  0.68805515687465_wp, &
      & -1.57376456425170_wp,  1.50369296606211_wp, -2.58214563598389_wp, &
      &  1.52540043111133_wp,  1.16798339658969_wp, -2.03354819810265_wp, &
      &  3.98420314183915_wp,  3.20958805139438_wp, -4.49456977225629_wp, &
      &  2.74331891831264_wp, -0.56458493734866_wp,  4.34013218558386_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless40

subroutine mindless41(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Na", "H", "S", "H", "F", "H", "B", "Al", "B", "S", "H", "H", "H", "C", "C", "C"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.73383002688019_wp, -2.12975725871274_wp, -3.54030576600146_wp, &
      &  3.64600733032912_wp,  0.86730743742201_wp,  0.27061481008061_wp, &
      &  4.00757971551880_wp, -4.44125679187697_wp,  0.17832874103588_wp, &
      &  2.31303626714085_wp,  3.53013246128506_wp,  1.86658615912412_wp, &
      & -4.12388406785751_wp,  4.55610681245276_wp, -1.15885570087832_wp, &
      & -2.72541367605559_wp, -0.44755423216299_wp, -4.21441780802681_wp, &
      & -2.23360194311705_wp, -0.02788929942445_wp, -2.03904711322407_wp, &
      & -3.50809450377456_wp, -0.14026641570661_wp,  2.15815735527538_wp, &
      &  1.96124279767320_wp, -3.71582129496608_wp,  2.62784529852261_wp, &
      &  0.83935216862620_wp, -0.39147875500058_wp,  3.50579781002461_wp, &
      &  0.46948988288340_wp,  3.33201413601455_wp, -2.59267821981247_wp, &
      &  1.10714847166937_wp, -5.12900666201440_wp,  4.17012664229038_wp, &
      & -2.39651426612083_wp, -2.02434674915564_wp, -0.71557318655016_wp, &
      &  1.88451329997468_wp,  1.72450404588578_wp,  0.95409560564141_wp, &
      & -2.83939961162302_wp,  2.41452060251232_wp, -0.36414868350476_wp, &
      & -0.13529189214728_wp,  2.02279196344798_wp, -1.10652594399693_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless41

subroutine mindless42(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "B", "H", "H", "O", "H", "H", "N", "F", "P", "C", "B", "Al", "O", "H", "F", "Al"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.14628207950146_wp, -1.85576660458868_wp, -4.85622811164430_wp, &
      & -5.47038524196166_wp, -3.30230442196969_wp, -5.81027853826046_wp, &
      &  0.15001477665874_wp, -1.18071608353775_wp,  3.48224515554880_wp, &
      & -3.71376031627917_wp, -3.29683091333333_wp, -6.33290709152903_wp, &
      &  0.03614983746815_wp, -1.81256982247418_wp, -5.45172201005106_wp, &
      & -4.77023298084312_wp, -0.45658862352220_wp, -2.16928428266035_wp, &
      & -2.91787433919920_wp, -0.42239567027236_wp, -2.69024790239055_wp, &
      & -2.10935154814617_wp,  2.90092278176962_wp,  1.70000099440458_wp, &
      &  3.35637062243926_wp,  2.78272946639544_wp, -0.63815356404931_wp, &
      &  2.04981760349598_wp, -0.59223471212537_wp,  4.09070837482881_wp, &
      &  4.06769591564662_wp,  0.80112130294596_wp,  2.47081697610363_wp, &
      &  1.10644440013696_wp,  4.51587210578955_wp,  2.94256783850596_wp, &
      &  2.04935213256888_wp,  1.99056458624430_wp,  5.04557088440070_wp, &
      &  6.21018770899405_wp,  0.77750307023768_wp,  3.14736941189843_wp, &
      &  2.75692516538951_wp, -2.20960199394989_wp,  5.99510936109577_wp, &
      & -0.65507165686738_wp,  1.36029553239095_wp, -0.92556749620160_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless42

subroutine mindless43(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "Al", "Si", "B", "N", "Si", "O", "H", "N", "H", "H", "H", "H", "N", "F", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -2.22637136991187_wp,  4.36908395486987_wp, -1.29852815745255_wp, &
      & -0.48663839708594_wp,  2.11007907628228_wp, -0.44472946941807_wp, &
      &  3.48991900928581_wp,  2.13635079229624_wp, -4.17945359423805_wp, &
      & -2.40814744890156_wp, -1.53992030174177_wp,  2.09852927949292_wp, &
      & -1.03522209743987_wp, -1.55615078641226_wp, -0.59213216398502_wp, &
      &  4.39074711311996_wp, -1.21150596575544_wp, -0.84146848613511_wp, &
      & -1.48951943225482_wp,  1.17017446776897_wp,  2.85529570348086_wp, &
      &  0.56904157592924_wp,  1.56767306473634_wp, -4.25285587859865_wp, &
      &  3.04789595517692_wp,  2.08437814410898_wp, -0.52660000278769_wp, &
      &  4.20585560142972_wp,  3.25519365139247_wp,  0.46690930759499_wp, &
      &  1.32485014871011_wp, -4.57960701190276_wp, -0.12978800788505_wp, &
      & -2.59898303167945_wp,  2.09807601538605_wp,  3.96960354015314_wp, &
      & -4.67331985051452_wp, -1.56880823508050_wp,  1.83141388500645_wp, &
      &  1.43423854110560_wp, -2.73663316703527_wp, -0.66292450547673_wp, &
      & -1.43735738597892_wp, -3.32107079967094_wp,  3.72935359838024_wp, &
      & -2.10698893099043_wp, -2.27731289924221_wp, -2.02262504813162_wp],&
      & shape(xyz))
   integer, parameter :: uhf = 1
   call new(self, sym, xyz, uhf=uhf)
end subroutine mindless43

subroutine AlH3(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 4
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Al", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.00000000000000_wp,  0.00000000000000_wp,  0.00000000000000_wp, &
      & -1.49789399773227_wp,  2.59442850842475_wp,  0.00000000000000_wp, &
      & -1.49789399773227_wp, -2.59442850842475_wp,  0.00000000000000_wp, &
      &  2.99578799546453_wp,  0.00000000000000_wp,  0.00000000000000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine AlH3

subroutine BH3(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 4
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "B", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp, -0.00000000000000_wp,  0.00000000000000_wp, &
      & -1.12758605299580_wp,  1.95303633369477_wp,  0.00000000000000_wp, &
      & -1.12758605299580_wp, -1.95303633369477_wp,  0.00000000000000_wp, &
      &  2.25517210599159_wp,  0.00000000000000_wp,  0.00000000000000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine BH3

subroutine BeH2(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 3
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Be", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.00000000000000_wp,  0.00000000000000_wp,  0.00000000000000_wp, &
      &  0.00000000000000_wp,  0.00000000000000_wp, -2.52791574974357_wp, &
      &  0.00000000000000_wp,  0.00000000000000_wp,  2.52791574974357_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine BeH2

subroutine CH4(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 5
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp, -0.00000000000000_wp,  0.00000000000000_wp, &
      & -1.19220800552211_wp,  1.19220800552211_wp,  1.19220800552211_wp, &
      &  1.19220800552211_wp, -1.19220800552211_wp,  1.19220800552211_wp, &
      & -1.19220800552211_wp, -1.19220800552211_wp, -1.19220800552211_wp, &
      &  1.19220800552211_wp,  1.19220800552211_wp, -1.19220800552211_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine CH4

subroutine Cl2(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 2
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Cl", "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp, -1.90078726685926_wp, &
      &  0.00000000000000_wp,  0.00000000000000_wp,  1.90078726685926_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine Cl2

subroutine F2(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 2
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "F", "F"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp, -1.33716170786228_wp, &
      &  0.00000000000000_wp,  0.00000000000000_wp,  1.33716170786228_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine F2

subroutine H2(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 2
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp, -0.70252931147690_wp, &
      &  0.00000000000000_wp,  0.00000000000000_wp,  0.70252931147690_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine H2

subroutine LiH(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 2
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Li", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp, -1.50796743897235_wp, &
      &  0.00000000000000_wp,  0.00000000000000_wp,  1.50796743897235_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine LiH

subroutine MgH2(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 3
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Mg", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp,  0.00000000000000_wp, &
      & -0.00000000000000_wp, -0.00000000000000_wp, -3.22563797588364_wp, &
      & -0.00000000000000_wp,  0.00000000000000_wp,  3.22563797588364_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine MgH2

subroutine N2(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 2
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "N", "N"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp, -1.03943592254399_wp, &
      &  0.00000000000000_wp,  0.00000000000000_wp,  1.03943592254399_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine N2

subroutine NaH(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 2
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Na", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp, -1.79256246225629_wp, &
      &  0.00000000000000_wp,  0.00000000000000_wp,  1.79256246225629_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine NaH

subroutine O2(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 2
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "O", "O"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp, -1.15215374000051_wp, &
      &  0.00000000000000_wp,  0.00000000000000_wp,  1.15215374000051_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine O2

subroutine P2(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 2
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "P", "P"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp, -1.79359822114972_wp, &
      &  0.00000000000000_wp,  0.00000000000000_wp,  1.79359822114972_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine P2

subroutine S2(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 2
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "S", "S"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp, -1.80281271474629_wp, &
      &  0.00000000000000_wp,  0.00000000000000_wp,  1.80281271474629_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine S2

subroutine SiH4(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 5
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Si", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp, -0.00000000000000_wp,  0.00000000000000_wp, &
      &  1.61768389755830_wp,  1.61768389755830_wp, -1.61768389755830_wp, &
      & -1.61768389755830_wp, -1.61768389755830_wp, -1.61768389755830_wp, &
      &  1.61768389755830_wp, -1.61768389755830_wp,  1.61768389755830_wp, &
      & -1.61768389755830_wp,  1.61768389755830_wp,  1.61768389755830_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine SiH4

end module mstore_mb16_43
