---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab release upload`

Upload release asset files or links to a GitLab release.

## Synopsis

Upload release assets to a GitLab release.

Define the display name by appending '#' after the filename.
The link type comes after the display name, like this: 'myfile.tar.gz#My display name#package'

```plaintext
glab release upload <tag> [<files>...] [flags]
```

## Examples

```console
# Upload a release asset with a display name. 'Type' defaults to 'other'.
$ glab release upload v1.0.1 '/path/to/asset.zip#My display label'

# Upload a release asset with a display name and type.
$ glab release upload v1.0.1 '/path/to/asset.png#My display label#image'

# Upload all assets in a specified folder. 'Type' defaults to 'other'.
$ glab release upload v1.0.1 ./dist/*

# Upload all tarballs in a specified folder. 'Type' defaults to 'other'.
$ glab release upload v1.0.1 ./dist/*.tar.gz

# Upload release assets links specified as JSON string
$ glab release upload v1.0.1 --assets-links='
  [
    {
      "name": "Asset1",
      "url":"https://<domain>/some/location/1",
      "link_type": "other",
      "direct_asset_path": "path/to/file"
    }
  ]'

```

## Options

```plaintext
  -a, --assets-links JSON      JSON string representation of assets links, like: `--assets-links='[{"name": "Asset1", "url":"https://<domain>/some/location/1", "link_type": "other", "direct_asset_path": "path/to/file"}]'.`
      --package-name string    [EXPERIMENTAL] The package name to use when uploading the assets to the generic package release with --use-package-registry. (default "release-assets")
      --use-package-registry   [EXPERIMENTAL] Upload release assets to the generic package registry of the project. Alternatively to this flag you may also set the GITLAB_RELEASE_ASSETS_USE_PACKAGE_REGISTRY environment variable to either the value true or 1. The flag takes precedence over this environment variable.
```

## Options inherited from parent commands

```plaintext
  -h, --help              Show help for this command.
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
```
